# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
BRepMesh module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_brepmesh.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepMesh
else:
    import _BRepMesh

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepMesh.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _BRepMesh.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BRepMesh.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BRepMesh.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _BRepMesh.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _BRepMesh.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _BRepMesh.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _BRepMesh.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _BRepMesh.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _BRepMesh.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BRepMesh.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _BRepMesh.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _BRepMesh.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BRepMesh.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BRepMesh.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BRepMesh.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _BRepMesh.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepMesh:
_BRepMesh.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _BRepMesh.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.IMeshTools
import OCC.Core.IMeshData
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.BRepAdaptor
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dAdaptor
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.Bnd
import OCC.Core.BVH

from enum import IntEnum
from OCC.Core.Exception import *

BRepMesh_FE_NOERROR = _BRepMesh.BRepMesh_FE_NOERROR
BRepMesh_FE_LIBRARYNOTFOUND = _BRepMesh.BRepMesh_FE_LIBRARYNOTFOUND
BRepMesh_FE_FUNCTIONNOTFOUND = _BRepMesh.BRepMesh_FE_FUNCTIONNOTFOUND
BRepMesh_FE_CANNOTCREATEALGO = _BRepMesh.BRepMesh_FE_CANNOTCREATEALGO
BRepMesh_Free = _BRepMesh.BRepMesh_Free
BRepMesh_InVolume = _BRepMesh.BRepMesh_InVolume
BRepMesh_OnSurface = _BRepMesh.BRepMesh_OnSurface
BRepMesh_OnCurve = _BRepMesh.BRepMesh_OnCurve
BRepMesh_Fixed = _BRepMesh.BRepMesh_Fixed
BRepMesh_Frontier = _BRepMesh.BRepMesh_Frontier
BRepMesh_Deleted = _BRepMesh.BRepMesh_Deleted


class BRepMesh_FactoryError(IntEnum):
	BRepMesh_FE_NOERROR = 0
	BRepMesh_FE_LIBRARYNOTFOUND = 1
	BRepMesh_FE_FUNCTIONNOTFOUND = 2
	BRepMesh_FE_CANNOTCREATEALGO = 3
BRepMesh_FE_NOERROR = BRepMesh_FactoryError.BRepMesh_FE_NOERROR
BRepMesh_FE_LIBRARYNOTFOUND = BRepMesh_FactoryError.BRepMesh_FE_LIBRARYNOTFOUND
BRepMesh_FE_FUNCTIONNOTFOUND = BRepMesh_FactoryError.BRepMesh_FE_FUNCTIONNOTFOUND
BRepMesh_FE_CANNOTCREATEALGO = BRepMesh_FactoryError.BRepMesh_FE_CANNOTCREATEALGO

class BRepMesh_DegreeOfFreedom(IntEnum):
	BRepMesh_Free = 0
	BRepMesh_InVolume = 1
	BRepMesh_OnSurface = 2
	BRepMesh_OnCurve = 3
	BRepMesh_Fixed = 4
	BRepMesh_Frontier = 5
	BRepMesh_Deleted = 6
BRepMesh_Free = BRepMesh_DegreeOfFreedom.BRepMesh_Free
BRepMesh_InVolume = BRepMesh_DegreeOfFreedom.BRepMesh_InVolume
BRepMesh_OnSurface = BRepMesh_DegreeOfFreedom.BRepMesh_OnSurface
BRepMesh_OnCurve = BRepMesh_DegreeOfFreedom.BRepMesh_OnCurve
BRepMesh_Fixed = BRepMesh_DegreeOfFreedom.BRepMesh_Fixed
BRepMesh_Frontier = BRepMesh_DegreeOfFreedom.BRepMesh_Frontier
BRepMesh_Deleted = BRepMesh_DegreeOfFreedom.BRepMesh_Deleted


def Handle_BRepMesh_Classifier_Create() -> "opencascade::handle< BRepMesh_Classifier >":
    return _BRepMesh.Handle_BRepMesh_Classifier_Create()

def Handle_BRepMesh_Classifier_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_Classifier >":
    return _BRepMesh.Handle_BRepMesh_Classifier_DownCast(t)

def Handle_BRepMesh_Classifier_IsNull(t: "opencascade::handle< BRepMesh_Classifier > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_Classifier_IsNull(t)

def Handle_BRepMesh_DataStructureOfDelaun_Create() -> "opencascade::handle< BRepMesh_DataStructureOfDelaun >":
    return _BRepMesh.Handle_BRepMesh_DataStructureOfDelaun_Create()

def Handle_BRepMesh_DataStructureOfDelaun_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_DataStructureOfDelaun >":
    return _BRepMesh.Handle_BRepMesh_DataStructureOfDelaun_DownCast(t)

def Handle_BRepMesh_DataStructureOfDelaun_IsNull(t: "opencascade::handle< BRepMesh_DataStructureOfDelaun > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_DataStructureOfDelaun_IsNull(t)

def Handle_BRepMesh_Deflection_Create() -> "opencascade::handle< BRepMesh_Deflection >":
    return _BRepMesh.Handle_BRepMesh_Deflection_Create()

def Handle_BRepMesh_Deflection_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_Deflection >":
    return _BRepMesh.Handle_BRepMesh_Deflection_DownCast(t)

def Handle_BRepMesh_Deflection_IsNull(t: "opencascade::handle< BRepMesh_Deflection > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_Deflection_IsNull(t)

def Handle_BRepMesh_DiscretRoot_Create() -> "opencascade::handle< BRepMesh_DiscretRoot >":
    return _BRepMesh.Handle_BRepMesh_DiscretRoot_Create()

def Handle_BRepMesh_DiscretRoot_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_DiscretRoot >":
    return _BRepMesh.Handle_BRepMesh_DiscretRoot_DownCast(t)

def Handle_BRepMesh_DiscretRoot_IsNull(t: "opencascade::handle< BRepMesh_DiscretRoot > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_DiscretRoot_IsNull(t)

def Handle_BRepMesh_FaceChecker_Create() -> "opencascade::handle< BRepMesh_FaceChecker >":
    return _BRepMesh.Handle_BRepMesh_FaceChecker_Create()

def Handle_BRepMesh_FaceChecker_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_FaceChecker >":
    return _BRepMesh.Handle_BRepMesh_FaceChecker_DownCast(t)

def Handle_BRepMesh_FaceChecker_IsNull(t: "opencascade::handle< BRepMesh_FaceChecker > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_FaceChecker_IsNull(t)

def Handle_BRepMesh_MeshTool_Create() -> "opencascade::handle< BRepMesh_MeshTool >":
    return _BRepMesh.Handle_BRepMesh_MeshTool_Create()

def Handle_BRepMesh_MeshTool_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_MeshTool >":
    return _BRepMesh.Handle_BRepMesh_MeshTool_DownCast(t)

def Handle_BRepMesh_MeshTool_IsNull(t: "opencascade::handle< BRepMesh_MeshTool > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_MeshTool_IsNull(t)

def Handle_BRepMesh_SelectorOfDataStructureOfDelaun_Create() -> "opencascade::handle< BRepMesh_SelectorOfDataStructureOfDelaun >":
    return _BRepMesh.Handle_BRepMesh_SelectorOfDataStructureOfDelaun_Create()

def Handle_BRepMesh_SelectorOfDataStructureOfDelaun_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_SelectorOfDataStructureOfDelaun >":
    return _BRepMesh.Handle_BRepMesh_SelectorOfDataStructureOfDelaun_DownCast(t)

def Handle_BRepMesh_SelectorOfDataStructureOfDelaun_IsNull(t: "opencascade::handle< BRepMesh_SelectorOfDataStructureOfDelaun > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_SelectorOfDataStructureOfDelaun_IsNull(t)

def Handle_BRepMesh_ShapeTool_Create() -> "opencascade::handle< BRepMesh_ShapeTool >":
    return _BRepMesh.Handle_BRepMesh_ShapeTool_Create()

def Handle_BRepMesh_ShapeTool_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_ShapeTool >":
    return _BRepMesh.Handle_BRepMesh_ShapeTool_DownCast(t)

def Handle_BRepMesh_ShapeTool_IsNull(t: "opencascade::handle< BRepMesh_ShapeTool > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_ShapeTool_IsNull(t)

def Handle_BRepMesh_VertexTool_Create() -> "opencascade::handle< BRepMesh_VertexTool >":
    return _BRepMesh.Handle_BRepMesh_VertexTool_Create()

def Handle_BRepMesh_VertexTool_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_VertexTool >":
    return _BRepMesh.Handle_BRepMesh_VertexTool_DownCast(t)

def Handle_BRepMesh_VertexTool_IsNull(t: "opencascade::handle< BRepMesh_VertexTool > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_VertexTool_IsNull(t)

def Handle_BRepMesh_IncrementalMesh_Create() -> "opencascade::handle< BRepMesh_IncrementalMesh >":
    return _BRepMesh.Handle_BRepMesh_IncrementalMesh_Create()

def Handle_BRepMesh_IncrementalMesh_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepMesh_IncrementalMesh >":
    return _BRepMesh.Handle_BRepMesh_IncrementalMesh_DownCast(t)

def Handle_BRepMesh_IncrementalMesh_IsNull(t: "opencascade::handle< BRepMesh_IncrementalMesh > const &") -> "bool":
    return _BRepMesh.Handle_BRepMesh_IncrementalMesh_IsNull(t)
class BRepMesh_BaseMeshAlgo(OCC.Core.IMeshTools.IMeshTools_MeshAlgo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_BaseMeshAlgo

# Register BRepMesh_BaseMeshAlgo in _BRepMesh:
_BRepMesh.BRepMesh_BaseMeshAlgo_swigregister(BRepMesh_BaseMeshAlgo)

class BRepMesh_Circle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Constructor. @param thelocation location of a circle. @param theradius radius of a circle.

        Parameters
        ----------
        theLocation: gp_XY
        theRadius: float

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_Circle_swiginit(self, _BRepMesh.new_BRepMesh_Circle(*args))

    def Location(self, *args) -> "gp_XY const":
        r"""
        Returns location of a circle.

        Returns
        -------
        gp_XY

        """
        return _BRepMesh.BRepMesh_Circle_Location(self, *args)

    def Radius(self, *args) -> "Standard_Real const &":
        r"""
        Returns radius of a circle.

        Returns
        -------
        float

        """
        return _BRepMesh.BRepMesh_Circle_Radius(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Sets location of a circle. @param thelocation location of a circle.

        Parameters
        ----------
        theLocation: gp_XY

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Circle_SetLocation(self, *args)

    def SetRadius(self, *args) -> "void":
        r"""
        Sets radius of a circle. @param theradius radius of a circle.

        Parameters
        ----------
        theRadius: float

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Circle_SetRadius(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_Circle

# Register BRepMesh_Circle in _BRepMesh:
_BRepMesh.BRepMesh_Circle_swigregister(BRepMesh_Circle)

class BRepMesh_CircleInspector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. @param thetolerance tolerance to be used for identification of shot circles. @param thereservedsize size to be reserved for vector of circles. @param theallocator memory allocator to be used by internal collections.

        Parameters
        ----------
        theTolerance: float
        theReservedSize: int
        theAllocator: NCollection_IncAllocator

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_CircleInspector_swiginit(self, _BRepMesh.new_BRepMesh_CircleInspector(*args))

    def Bind(self, *args) -> "void":
        r"""
        Adds the circle to vector of circles at the given position. @param theindex position of circle in the vector. @param thecircle circle to be added.

        Parameters
        ----------
        theIndex: int
        theCircle: BRepMesh_Circle

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_CircleInspector_Bind(self, *args)

    def Circle(self, *args) -> "BRepMesh_Circle &":
        r"""
        Returns circle with the given index. @param theindex index of circle. returns circle with the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Circle

        """
        return _BRepMesh.BRepMesh_CircleInspector_Circle(self, *args)

    def Circles(self, *args) -> "IMeshData::VectorOfCircle const &":
        r"""
        Resutns vector of registered circles.

        Returns
        -------
        IMeshData::VectorOfCircle

        """
        return _BRepMesh.BRepMesh_CircleInspector_Circles(self, *args)

    def GetShotCircles(self, *args) -> "IMeshData::ListOfInteger &":
        r"""
        Returns list of circles shot by the reference point.

        Returns
        -------
        IMeshData::ListOfInteger

        """
        return _BRepMesh.BRepMesh_CircleInspector_GetShotCircles(self, *args)

    def Inspect(self, *args) -> "NCollection_CellFilter_Action":
        r"""
        Performs inspection of a circle with the given index. @param thetargetindex index of a circle to be checked. returns status of the check.

        Parameters
        ----------
        theTargetIndex: int

        Returns
        -------
        NCollection_CellFilter_Action

        """
        return _BRepMesh.BRepMesh_CircleInspector_Inspect(self, *args)

    @staticmethod
    def IsEqual(*args) -> "Standard_Boolean":
        r"""
        Checks indices for equlity.

        Parameters
        ----------
        theIndex: int
        theTargetIndex: int

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_CircleInspector_IsEqual(*args)

    def SetPoint(self, *args) -> "void":
        r"""
        Set reference point to be checked. @param thepoint bullet point.

        Parameters
        ----------
        thePoint: gp_XY

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_CircleInspector_SetPoint(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_CircleInspector

# Register BRepMesh_CircleInspector in _BRepMesh:
_BRepMesh.BRepMesh_CircleInspector_swigregister(BRepMesh_CircleInspector)

def BRepMesh_CircleInspector_IsEqual(*args) -> "Standard_Boolean":
    r"""
    Checks indices for equlity.

    Parameters
    ----------
    theIndex: int
    theTargetIndex: int

    Returns
    -------
    bool

    """
    return _BRepMesh.BRepMesh_CircleInspector_IsEqual(*args)

class BRepMesh_CircleTool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. @param theallocator memory allocator to be used by internal structures.

        Parameters
        ----------
        theAllocator: NCollection_IncAllocator

        Returns
        -------
        None
        Constructor. @param thereservedsize size to be reserved for vector of circles. @param theallocator memory allocator to be used by internal structures.

        Parameters
        ----------
        theReservedSize: int
        theAllocator: NCollection_IncAllocator

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_CircleTool_swiginit(self, _BRepMesh.new_BRepMesh_CircleTool(*args))

    def Bind(self, *args) -> "Standard_Boolean":
        r"""
        Binds the circle to the tool. @param theindex index a circle should be bound with. @param thecircle circle to be bound.

        Parameters
        ----------
        theIndex: int
        theCircle: gp_Circ2d

        Returns
        -------
        None
        Computes circle on three points and bind it to the tool. @param theindex index a circle should be bound with. @param thepoint1 first point. @param thepoint2 second point. @param thepoint3 third point. returns false in case of impossibility to build a circle on the given points, true elsewhere.

        Parameters
        ----------
        theIndex: int
        thePoint1: gp_XY
        thePoint2: gp_XY
        thePoint3: gp_XY

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_CircleTool_Bind(self, *args)

    def Delete(self, *args) -> "void":
        r"""
        Deletes a circle from the tool. @param theindex index of a circle to be removed.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_CircleTool_Delete(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Initializes the tool. @param thereservedsize size to be reserved for vector of circles.

        Parameters
        ----------
        Standard_Integer: 

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_CircleTool_Init(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Retruns true if cell filter contains no circle.

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_CircleTool_IsEmpty(self, *args)

    @staticmethod
    def MakeCircle(*args) -> "Standard_Real &":
        r"""
        Computes circle on three points. @param thepoint1 first point. @param thepoint2 second point. @param thepoint3 third point. @param[out] thelocation center of computed circle. @param[out] theradius radius of computed circle. returns false in case of impossibility to build a circle on the given points, true elsewhere.

        Parameters
        ----------
        thePoint1: gp_XY
        thePoint2: gp_XY
        thePoint3: gp_XY
        theLocation: gp_XY

        Returns
        -------
        theRadius: float

        """
        return _BRepMesh.BRepMesh_CircleTool_MakeCircle(*args)

    def MocBind(self, *args) -> "void":
        r"""
        Binds implicit zero circle. @param theindex index a zero circle should be bound with.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_CircleTool_MocBind(self, *args)

    def Select(self, *args) -> "IMeshData::ListOfInteger &":
        r"""
        Select the circles shot by the given point. @param thepoint bullet point.

        Parameters
        ----------
        thePoint: gp_XY

        Returns
        -------
        IMeshData::ListOfInteger

        """
        return _BRepMesh.BRepMesh_CircleTool_Select(self, *args)

    def SetCellSize(self, *args) -> "void":
        r"""
        Sets new size for cell filter. @param thesize cell size to be set for x and y dimensions.

        Parameters
        ----------
        theSize: float

        Returns
        -------
        None
        Sets new size for cell filter. @param thesizex cell size to be set for x dimension. @param thesizey cell size to be set for y dimension.

        Parameters
        ----------
        theSizeX: float
        theSizeY: float

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_CircleTool_SetCellSize(self, *args)

    def SetMinMaxSize(self, *args) -> "void":
        r"""
        Sets limits of inspection area. @param themin bottom left corner of inspection area. @param themax top right corner of inspection area.

        Parameters
        ----------
        theMin: gp_XY
        theMax: gp_XY

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_CircleTool_SetMinMaxSize(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_CircleTool

# Register BRepMesh_CircleTool in _BRepMesh:
_BRepMesh.BRepMesh_CircleTool_swigregister(BRepMesh_CircleTool)

def BRepMesh_CircleTool_MakeCircle(*args) -> "Standard_Real &":
    r"""
    Computes circle on three points. @param thepoint1 first point. @param thepoint2 second point. @param thepoint3 third point. @param[out] thelocation center of computed circle. @param[out] theradius radius of computed circle. returns false in case of impossibility to build a circle on the given points, true elsewhere.

    Parameters
    ----------
    thePoint1: gp_XY
    thePoint2: gp_XY
    thePoint3: gp_XY
    theLocation: gp_XY

    Returns
    -------
    theRadius: float

    """
    return _BRepMesh.BRepMesh_CircleTool_MakeCircle(*args)

class BRepMesh_Classifier(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_Classifier_swiginit(self, _BRepMesh.new_BRepMesh_Classifier(*args))

    def Perform(self, *args) -> "TopAbs_State":
        r"""
        Performs classification of the given point regarding to face internals. @param thepoint point in parametric space to be classified. returns topabs_in if point lies within face boundaries and topabs_out elsewhere.

        Parameters
        ----------
        thePoint: gp_Pnt2d

        Returns
        -------
        TopAbs_State

        """
        return _BRepMesh.BRepMesh_Classifier_Perform(self, *args)

    def RegisterWire(self, *args) -> "void":
        r"""
        Registers wire specified by sequence of points for further classification of points. @param thewire wire to be registered. specified by sequence of points. @param thetoluv tolerance to be used for calculations in parametric space. @param theumin lower u boundary of the face in parametric space. @param theumax upper u boundary of the face in parametric space. @param thevmin lower v boundary of the face in parametric space. @param thevmax upper v boundary of the face in parametric space.

        Parameters
        ----------
        theWire: NCollection_Sequence< gp_Pnt2d *>
        theTolUV: std::pair<float, float>
        theRangeU: std::pair<float, float>
        theRangeV: std::pair<float, float>

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Classifier_RegisterWire(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_Classifier_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_Classifier

# Register BRepMesh_Classifier in _BRepMesh:
_BRepMesh.BRepMesh_Classifier_swigregister(BRepMesh_Classifier)

class BRepMesh_Context(OCC.Core.IMeshTools.IMeshTools_Context):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_Context_swiginit(self, _BRepMesh.new_BRepMesh_Context(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_Context

# Register BRepMesh_Context in _BRepMesh:
_BRepMesh.BRepMesh_Context_swigregister(BRepMesh_Context)

class BRepMesh_CurveTessellator(OCC.Core.IMeshTools.IMeshTools_CurveTessellator):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Parameters
        ----------
        theEdge: IMeshData::IEdgeHandle
        theParameters: IMeshTools_Parameters

        Returns
        -------
        None
        Constructor.

        Parameters
        ----------
        theEdge: IMeshData::IEdgeHandle
        theOrientation: TopAbs_Orientation
        theFace: IMeshData::IFaceHandle
        theParameters: IMeshTools_Parameters

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_CurveTessellator_swiginit(self, _BRepMesh.new_BRepMesh_CurveTessellator(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_CurveTessellator

# Register BRepMesh_CurveTessellator in _BRepMesh:
_BRepMesh.BRepMesh_CurveTessellator_swigregister(BRepMesh_CurveTessellator)

class BRepMesh_DataStructureOfDelaun(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. @param theallocator memory allocator to be used by internal structures. @param thereservednodesize presumed number of nodes in this mesh.

        Parameters
        ----------
        theAllocator: NCollection_IncAllocator
        theReservedNodeSize: int,optional
        	default value is 100

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_DataStructureOfDelaun_swiginit(self, _BRepMesh.new_BRepMesh_DataStructureOfDelaun(*args))

    def AddElement(self, *args) -> "Standard_Integer":
        r"""
        Adds element to the mesh if it is not already in the mesh. @param theelement element to be added to the mesh. returns index of the element in the structure.

        Parameters
        ----------
        theElement: BRepMesh_Triangle

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_AddElement(self, *args)

    def AddLink(self, *args) -> "Standard_Integer":
        r"""
        Adds link to the mesh if it is not already in the mesh. @param thelink link to be added to the mesh. returns index of the link in the structure.

        Parameters
        ----------
        theLink: BRepMesh_Edge

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_AddLink(self, *args)

    def AddNode(self, *args) -> "Standard_Integer":
        r"""
        Adds node to the mesh if it is not already in the mesh. @param thenode node to be added to the mesh. @param isforceadd adds the given node to structure without checking on coincidence with other nodes. returns index of the node in the structure.

        Parameters
        ----------
        theNode: BRepMesh_Vertex
        isForceAdd: bool,optional
        	default value is Standard_False

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_AddNode(self, *args)

    def Allocator(self, *args) -> "opencascade::handle< NCollection_IncAllocator > const &":
        r"""
        Returns memory allocator used by the structure.

        Returns
        -------
        opencascade::handle<NCollection_IncAllocator>

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_Allocator(self, *args)

    def ClearDeleted(self, *args) -> "void":
        r"""
        Substitutes deleted items by the last one from corresponding map to have only non-deleted elements, links or nodes in the structure.

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_ClearDeleted(self, *args)

    def ClearDomain(self, *args) -> "void":
        r"""
        Removes all elements.

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_ClearDomain(self, *args)

    def Data(self, *args) -> "opencascade::handle< BRepMesh_VertexTool > const &":
        r"""
        Gives the data structure for initialization of cell size and tolerance.

        Returns
        -------
        opencascade::handle<BRepMesh_VertexTool>

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_Data(self, *args)

    def Dump(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theFileNameStr: char *

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_Dump(self, *args)

    def ElementNodes(self, *args) -> "void":
        r"""
        Returns indices of nodes forming the given element. @param theelement element which nodes should be retrieved. @param[out] thenodes nodes of the given element.

        Parameters
        ----------
        theElement: BRepMesh_Triangle
        ): int (  theNodes

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_ElementNodes(self, *args)

    def ElementsConnectedTo(self, *args) -> "BRepMesh_PairOfIndex const &":
        r"""
        Returns indices of elements conected to the link with the given index. @param thelinkindex index of link whose data should be retrieved. returns indices of elements conected to the link.

        Parameters
        ----------
        theLinkIndex: int

        Returns
        -------
        BRepMesh_PairOfIndex

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_ElementsConnectedTo(self, *args)

    def ElementsOfDomain(self, *args) -> "IMeshData::MapOfInteger const &":
        r"""
        Returns map of indices of elements registered in mesh.

        Returns
        -------
        IMeshData::MapOfInteger

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_ElementsOfDomain(self, *args)

    def GetElement(self, *args) -> "BRepMesh_Triangle const &":
        r"""
        Get element by the index. @param theindex index of an element. returns element with the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Triangle

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_GetElement(self, *args)

    def GetLink(self, *args) -> "BRepMesh_Edge const &":
        r"""
        Get link by the index. @param theindex index of a link. returns link with the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Edge

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_GetLink(self, *args)

    def GetNode(self, *args) -> "BRepMesh_Vertex const &":
        r"""
        Get node by the index. @param theindex index of a node. returns node with the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Vertex

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_GetNode(self, *args)

    def IndexOf(self, *args) -> "Standard_Integer":
        r"""
        Finds the index of the given node. @param thenode node to find. returns index of the given element of zero if node is not in the mesh.

        Parameters
        ----------
        theNode: BRepMesh_Vertex

        Returns
        -------
        int
        Finds the index of the given link. @param thelink link to find. returns index of the given element of zero if link is not in the mesh.

        Parameters
        ----------
        theLink: BRepMesh_Edge

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_IndexOf(self, *args)

    def LinksConnectedTo(self, *args) -> "IMeshData::ListOfInteger const &":
        r"""
        Get list of links attached to the node with the given index. @param theindex index of node whose links should be retrieved. returns list of links attached to the node.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        IMeshData::ListOfInteger

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_LinksConnectedTo(self, *args)

    def LinksOfDomain(self, *args) -> "IMeshData::MapOfInteger const &":
        r"""
        Returns map of indices of links registered in mesh.

        Returns
        -------
        IMeshData::MapOfInteger

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_LinksOfDomain(self, *args)

    def NbElements(self, *args) -> "Standard_Integer":
        r"""
        Returns number of links.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_NbElements(self, *args)

    def NbLinks(self, *args) -> "Standard_Integer":
        r"""
        Returns number of links.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_NbLinks(self, *args)

    def NbNodes(self, *args) -> "Standard_Integer":
        r"""
        Returns number of nodes.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_NbNodes(self, *args)

    def RemoveElement(self, *args) -> "void":
        r"""
        Removes element from the mesh. @param theindex index of element to be removed.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_RemoveElement(self, *args)

    def RemoveLink(self, *args) -> "void":
        r"""
        Removes link from the mesh in case if it has no connected elements and its type is free. @param theindex index of link to be removed. @param isforce if true link will be removed even if movability is not free.

        Parameters
        ----------
        theIndex: int
        isForce: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_RemoveLink(self, *args)

    def RemoveNode(self, *args) -> "void":
        r"""
        Removes node from the mesh in case if it has no connected links and its type is free. @param theindex index of node to be removed. @param isforce if true node will be removed even if movability is not free.

        Parameters
        ----------
        theIndex: int
        isForce: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_RemoveNode(self, *args)

    def StatisticsToString(self) -> "std::string":
        r"""StatisticsToString(BRepMesh_DataStructureOfDelaun self) -> std::string"""
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_StatisticsToString(self)

    def SubstituteElement(self, *args) -> "Standard_Boolean":
        r"""
        Substitutes the element with the given index by new one. @param theindex index of element to be substituted. @param thenewlink substituting element. returns false in case if new element is already in the structure, true elsewhere.

        Parameters
        ----------
        theIndex: int
        theNewElement: BRepMesh_Triangle

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_SubstituteElement(self, *args)

    def SubstituteLink(self, *args) -> "Standard_Boolean":
        r"""
        Substitutes the link with the given index by new one. @param theindex index of link to be substituted. @param thenewlink substituting link. returns false in case if new link is already in the structure, true elsewhere.

        Parameters
        ----------
        theIndex: int
        theNewLink: BRepMesh_Edge

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_SubstituteLink(self, *args)

    def SubstituteNode(self, *args) -> "Standard_Boolean":
        r"""
        Substitutes the node with the given index by new one. @param theindex index of node to be substituted. @param thenewnode substituting node. returns false in case if new node is already in the structure, true elsewhere.

        Parameters
        ----------
        theIndex: int
        theNewNode: BRepMesh_Vertex

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_DataStructureOfDelaun_SubstituteNode(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_DataStructureOfDelaun_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_DataStructureOfDelaun

# Register BRepMesh_DataStructureOfDelaun in _BRepMesh:
_BRepMesh.BRepMesh_DataStructureOfDelaun_swigregister(BRepMesh_DataStructureOfDelaun)

class BRepMesh_Deflection(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ComputeAbsoluteDeflection(*args) -> "Standard_Real":
        r"""
        Returns absolute deflection for theshape with respect to the relative deflection and themaxshapesize. @param theshape shape for that the deflection should be computed. @param therelativedeflection relative deflection. @param themaxshapesize maximum size of the whole shape. returns absolute deflection for the shape.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theRelativeDeflection: float
        theMaxShapeSize: float

        Returns
        -------
        float

        """
        return _BRepMesh.BRepMesh_Deflection_ComputeAbsoluteDeflection(*args)

    @staticmethod
    def ComputeDeflection(*args) -> "void":
        r"""
        Computes and updates deflection of the given discrete edge.

        Parameters
        ----------
        theDEdge: IMeshData::IEdgeHandle
        theMaxShapeSize: float
        theParameters: IMeshTools_Parameters

        Returns
        -------
        None
        Computes and updates deflection of the given discrete wire.

        Parameters
        ----------
        theDWire: IMeshData::IWireHandle
        theParameters: IMeshTools_Parameters

        Returns
        -------
        None
        Computes and updates deflection of the given discrete face.

        Parameters
        ----------
        theDFace: IMeshData::IFaceHandle
        theParameters: IMeshTools_Parameters

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Deflection_ComputeDeflection(*args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_Deflection_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _BRepMesh.BRepMesh_Deflection_swiginit(self, _BRepMesh.new_BRepMesh_Deflection())
    __swig_destroy__ = _BRepMesh.delete_BRepMesh_Deflection

# Register BRepMesh_Deflection in _BRepMesh:
_BRepMesh.BRepMesh_Deflection_swigregister(BRepMesh_Deflection)

def BRepMesh_Deflection_ComputeAbsoluteDeflection(*args) -> "Standard_Real":
    r"""
    Returns absolute deflection for theshape with respect to the relative deflection and themaxshapesize. @param theshape shape for that the deflection should be computed. @param therelativedeflection relative deflection. @param themaxshapesize maximum size of the whole shape. returns absolute deflection for the shape.

    Parameters
    ----------
    theShape: TopoDS_Shape
    theRelativeDeflection: float
    theMaxShapeSize: float

    Returns
    -------
    float

    """
    return _BRepMesh.BRepMesh_Deflection_ComputeAbsoluteDeflection(*args)

def BRepMesh_Deflection_ComputeDeflection(*args) -> "void":
    r"""
    Computes and updates deflection of the given discrete edge.

    Parameters
    ----------
    theDEdge: IMeshData::IEdgeHandle
    theMaxShapeSize: float
    theParameters: IMeshTools_Parameters

    Returns
    -------
    None
    Computes and updates deflection of the given discrete wire.

    Parameters
    ----------
    theDWire: IMeshData::IWireHandle
    theParameters: IMeshTools_Parameters

    Returns
    -------
    None
    Computes and updates deflection of the given discrete face.

    Parameters
    ----------
    theDFace: IMeshData::IFaceHandle
    theParameters: IMeshTools_Parameters

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_Deflection_ComputeDeflection(*args)

class BRepMesh_Delaun(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates instance of triangulator, but do not run the algorithm automatically.

        Parameters
        ----------
        theOldMesh: BRepMesh_DataStructureOfDelaun
        theCellsCountU: int
        theCellsCountV: int
        isFillCircles: bool

        Returns
        -------
        None
        Creates the triangulation with an empty mesh data structure.

        Parameters
        ----------
        theVertices: IMeshData::Array1OfVertexOfDelaun

        Returns
        -------
        None
        Creates the triangulation with an existent mesh data structure.

        Parameters
        ----------
        theOldMesh: BRepMesh_DataStructureOfDelaun
        theVertices: IMeshData::Array1OfVertexOfDelaun

        Returns
        -------
        None
        Creates the triangulation with an existant mesh data structure.

        Parameters
        ----------
        theOldMesh: BRepMesh_DataStructureOfDelaun
        theVertexIndices: IMeshData::VectorOfInteger

        Returns
        -------
        None
        Creates the triangulation with an existant mesh data structure.

        Parameters
        ----------
        theOldMesh: Handle ( BRepMesh_DataStructureOfDelaun )
        theVertexIndices: IMeshData::VectorOfInteger
        theCellsCountU: int
        theCellsCountV: int

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_Delaun_swiginit(self, _BRepMesh.new_BRepMesh_Delaun(*args))

    def AddVertices(self, *args) -> "void":
        r"""
        Adds some vertices into the triangulation.

        Parameters
        ----------
        theVerticesIndices: IMeshData::VectorOfInteger

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Delaun_AddVertices(self, *args)

    def Circles(self, *args) -> "BRepMesh_CircleTool const &":
        r"""
        Returns tool used to build mesh consistent to delaunay criteria.

        Returns
        -------
        BRepMesh_CircleTool

        """
        return _BRepMesh.BRepMesh_Delaun_Circles(self, *args)

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Test is the given triangle contains the given vertex. @param thesqtolerance square tolerance to check closeness to some edge @param theedgeon if it is != 0 the vertex lies onto the edge index returned through this parameter.

        Parameters
        ----------
        theTriangleId: int
        theVertex: BRepMesh_Vertex
        theSqTolerance: float

        Returns
        -------
        theEdgeOn: int

        """
        return _BRepMesh.BRepMesh_Delaun_Contains(self, *args)

    def GetEdge(self, *args) -> "BRepMesh_Edge const &":
        r"""
        Gives edge with the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Edge

        """
        return _BRepMesh.BRepMesh_Delaun_GetEdge(self, *args)

    def GetTriangle(self, *args) -> "BRepMesh_Triangle const &":
        r"""
        Gives triangle with the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Triangle

        """
        return _BRepMesh.BRepMesh_Delaun_GetTriangle(self, *args)

    def GetVertex(self, *args) -> "BRepMesh_Vertex const &":
        r"""
        Gives vertex with the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Vertex

        """
        return _BRepMesh.BRepMesh_Delaun_GetVertex(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Initializes the triangulation with an array of vertices.

        Parameters
        ----------
        theVertices: IMeshData::Array1OfVertexOfDelaun

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Delaun_Init(self, *args)

    def InitCirclesTool(self, *args) -> "void":
        r"""
        Forces initialization of circles cell filter using working structure.

        Parameters
        ----------
        theCellsCountU: int
        theCellsCountV: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Delaun_InitCirclesTool(self, *args)

    def RemoveVertex(self, *args) -> "void":
        r"""
        Removes a vertex from the triangulation.

        Parameters
        ----------
        theVertex: BRepMesh_Vertex

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Delaun_RemoveVertex(self, *args)

    def Result(self, *args) -> "opencascade::handle< BRepMesh_DataStructureOfDelaun > const &":
        r"""
        Gives the mesh data structure.

        Returns
        -------
        opencascade::handle<BRepMesh_DataStructureOfDelaun>

        """
        return _BRepMesh.BRepMesh_Delaun_Result(self, *args)

    def UseEdge(self, *args) -> "Standard_Boolean":
        r"""
        Modify mesh to use the edge. returns true if done.

        Parameters
        ----------
        theEdge: int

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_Delaun_UseEdge(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Frontier(self):
    	pass

    @methodnotwrapped
    def InternalEdges(self):
    	pass

    @methodnotwrapped
    def FreeEdges(self):
    	pass

    @methodnotwrapped
    def ProcessConstraints(self):
    	pass

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_Delaun

# Register BRepMesh_Delaun in _BRepMesh:
_BRepMesh.BRepMesh_Delaun_swigregister(BRepMesh_Delaun)

class BRepMesh_DiscretFactory(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def DefaultName(self, *args) -> "TCollection_AsciiString const &":
        r"""
        Returns name for current meshing algorithm.

        Returns
        -------
        TCollection_AsciiString

        """
        return _BRepMesh.BRepMesh_DiscretFactory_DefaultName(self, *args)

    def Discret(self, *args) -> "opencascade::handle< BRepMesh_DiscretRoot >":
        r"""
        Returns triangulation algorithm instance. @param theshape shape to be meshed. @param thelindeflection linear deflection to be used for meshing. @param theangdeflection angular deflection to be used for meshing.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theLinDeflection: float
        theAngDeflection: float

        Returns
        -------
        opencascade::handle<BRepMesh_DiscretRoot>

        """
        return _BRepMesh.BRepMesh_DiscretFactory_Discret(self, *args)

    def ErrorStatus(self, *args) -> "BRepMesh_FactoryError":
        r"""
        Returns error status for last meshing algorithm switch.

        Returns
        -------
        BRepMesh_FactoryError

        """
        return _BRepMesh.BRepMesh_DiscretFactory_ErrorStatus(self, *args)

    def FunctionName(self, *args) -> "TCollection_AsciiString const &":
        r"""
        Returns function name that should be exported by plugin.

        Returns
        -------
        TCollection_AsciiString

        """
        return _BRepMesh.BRepMesh_DiscretFactory_FunctionName(self, *args)

    @staticmethod
    def Get(*args) -> "BRepMesh_DiscretFactory &":
        r"""
        Returns the global factory instance.

        Returns
        -------
        BRepMesh_DiscretFactory

        """
        return _BRepMesh.BRepMesh_DiscretFactory_Get(*args)

    def Names(self, *args) -> "TColStd_MapOfAsciiString const &":
        r"""
        Returns the list of registered meshing algorithms.

        Returns
        -------
        TColStd_MapOfAsciiString

        """
        return _BRepMesh.BRepMesh_DiscretFactory_Names(self, *args)

    def SetDefault(self, *args) -> "Standard_Boolean":
        r"""
        Setup meshing algorithm that should be created by this factory. returns true if requested tool is available. on fail factory will continue to use previous algo. call ::errorstatus() method to retrieve fault reason.

        Parameters
        ----------
        theName: TCollection_AsciiString
        theFuncName: TCollection_AsciiString,optional
        	default value is 'DISCRETALGO'

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_DiscretFactory_SetDefault(self, *args)

    def SetDefaultName(self, *args) -> "Standard_Boolean":
        r"""
        Setup meshing algorithm by name. returns true if requested tool is available. on fail factory will continue to use previous algo.

        Parameters
        ----------
        theName: TCollection_AsciiString

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_DiscretFactory_SetDefaultName(self, *args)

    def SetFunctionName(self, *args) -> "Standard_Boolean":
        r"""
        Advanced function. changes function name to retrieve from plugin. returns true if requested tool is available. on fail factory will continue to use previous algo.

        Parameters
        ----------
        theFuncName: TCollection_AsciiString

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_DiscretFactory_SetFunctionName(self, *args)

    __repr__ = _dumps_object


# Register BRepMesh_DiscretFactory in _BRepMesh:
_BRepMesh.BRepMesh_DiscretFactory_swigregister(BRepMesh_DiscretFactory)

def BRepMesh_DiscretFactory_Get(*args) -> "BRepMesh_DiscretFactory &":
    r"""
    Returns the global factory instance.

    Returns
    -------
    BRepMesh_DiscretFactory

    """
    return _BRepMesh.BRepMesh_DiscretFactory_Get(*args)

class BRepMesh_DiscretRoot(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if triangualtion was performed and has success.

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_DiscretRoot_IsDone(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Compute triangulation for set shape.

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DiscretRoot_Perform(self, *args)

    def SetShape(self, *args) -> "void":
        r"""
        Set the shape to triangulate.

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_DiscretRoot_SetShape(self, *args)

    def Shape(self, *args) -> "TopoDS_Shape const":
        r"""
        No available documentation.

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepMesh.BRepMesh_DiscretRoot_Shape(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_DiscretRoot_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_DiscretRoot

# Register BRepMesh_DiscretRoot in _BRepMesh:
_BRepMesh.BRepMesh_DiscretRoot_swigregister(BRepMesh_DiscretRoot)

class BRepMesh_EdgeDiscret(OCC.Core.IMeshTools.IMeshTools_ModelAlgo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_EdgeDiscret_swiginit(self, _BRepMesh.new_BRepMesh_EdgeDiscret(*args))

    @staticmethod
    def CreateEdgeTessellationExtractor(*args) -> "opencascade::handle< IMeshTools_CurveTessellator >":
        r"""
        Creates instance of tessellation extractor.

        Parameters
        ----------
        theDEdge: IMeshData::IEdgeHandle
        theDFace: IMeshData::IFaceHandle

        Returns
        -------
        opencascade::handle<IMeshTools_CurveTessellator>

        """
        return _BRepMesh.BRepMesh_EdgeDiscret_CreateEdgeTessellationExtractor(*args)

    @staticmethod
    def CreateEdgeTessellator(*args) -> "opencascade::handle< IMeshTools_CurveTessellator >":
        r"""
        Creates instance of free edge tessellator.

        Parameters
        ----------
        theDEdge: IMeshData::IEdgeHandle
        theParameters: IMeshTools_Parameters

        Returns
        -------
        opencascade::handle<IMeshTools_CurveTessellator>
        Creates instance of edge tessellator.

        Parameters
        ----------
        theDEdge: IMeshData::IEdgeHandle
        theOrientation: TopAbs_Orientation
        theDFace: IMeshData::IFaceHandle
        theParameters: IMeshTools_Parameters

        Returns
        -------
        opencascade::handle<IMeshTools_CurveTessellator>

        """
        return _BRepMesh.BRepMesh_EdgeDiscret_CreateEdgeTessellator(*args)

    @staticmethod
    def Tessellate2d(*args) -> "void":
        r"""
        Updates 2d discrete edge model using tessellation of 3d curve.

        Parameters
        ----------
        theDEdge: IMeshData::IEdgeHandle
        theUpdateEnds: bool

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_EdgeDiscret_Tessellate2d(*args)

    @staticmethod
    def Tessellate3d(*args) -> "void":
        r"""
        Updates 3d discrete edge model using the given tessellation tool.

        Parameters
        ----------
        theDEdge: IMeshData::IEdgeHandle
        theTessellator: IMeshTools_CurveTessellator
        theUpdateEnds: bool

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_EdgeDiscret_Tessellate3d(*args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_EdgeDiscret

# Register BRepMesh_EdgeDiscret in _BRepMesh:
_BRepMesh.BRepMesh_EdgeDiscret_swigregister(BRepMesh_EdgeDiscret)

def BRepMesh_EdgeDiscret_CreateEdgeTessellationExtractor(*args) -> "opencascade::handle< IMeshTools_CurveTessellator >":
    r"""
    Creates instance of tessellation extractor.

    Parameters
    ----------
    theDEdge: IMeshData::IEdgeHandle
    theDFace: IMeshData::IFaceHandle

    Returns
    -------
    opencascade::handle<IMeshTools_CurveTessellator>

    """
    return _BRepMesh.BRepMesh_EdgeDiscret_CreateEdgeTessellationExtractor(*args)

def BRepMesh_EdgeDiscret_CreateEdgeTessellator(*args) -> "opencascade::handle< IMeshTools_CurveTessellator >":
    r"""
    Creates instance of free edge tessellator.

    Parameters
    ----------
    theDEdge: IMeshData::IEdgeHandle
    theParameters: IMeshTools_Parameters

    Returns
    -------
    opencascade::handle<IMeshTools_CurveTessellator>
    Creates instance of edge tessellator.

    Parameters
    ----------
    theDEdge: IMeshData::IEdgeHandle
    theOrientation: TopAbs_Orientation
    theDFace: IMeshData::IFaceHandle
    theParameters: IMeshTools_Parameters

    Returns
    -------
    opencascade::handle<IMeshTools_CurveTessellator>

    """
    return _BRepMesh.BRepMesh_EdgeDiscret_CreateEdgeTessellator(*args)

def BRepMesh_EdgeDiscret_Tessellate2d(*args) -> "void":
    r"""
    Updates 2d discrete edge model using tessellation of 3d curve.

    Parameters
    ----------
    theDEdge: IMeshData::IEdgeHandle
    theUpdateEnds: bool

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_EdgeDiscret_Tessellate2d(*args)

def BRepMesh_EdgeDiscret_Tessellate3d(*args) -> "void":
    r"""
    Updates 3d discrete edge model using the given tessellation tool.

    Parameters
    ----------
    theDEdge: IMeshData::IEdgeHandle
    theTessellator: IMeshTools_CurveTessellator
    theUpdateEnds: bool

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_EdgeDiscret_Tessellate3d(*args)

class BRepMesh_FaceChecker(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Parameters
        ----------
        theFace: IMeshData::IFaceHandle
        theParameters: IMeshTools_Parameters

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_FaceChecker_swiginit(self, _BRepMesh.new_BRepMesh_FaceChecker(*args))

    def Perform(self, *args) -> "Standard_Boolean":
        r"""
        Performs check wires of the face for intersections. returns true if there is no intersection, false elsewhere.

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_FaceChecker_Perform(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_FaceChecker_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_FaceChecker

# Register BRepMesh_FaceChecker in _BRepMesh:
_BRepMesh.BRepMesh_FaceChecker_swigregister(BRepMesh_FaceChecker)

class BRepMesh_FaceDiscret(OCC.Core.IMeshTools.IMeshTools_ModelAlgo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Parameters
        ----------
        theAlgoFactory: IMeshTools_MeshAlgoFactory

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_FaceDiscret_swiginit(self, _BRepMesh.new_BRepMesh_FaceDiscret(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_FaceDiscret

# Register BRepMesh_FaceDiscret in _BRepMesh:
_BRepMesh.BRepMesh_FaceDiscret_swigregister(BRepMesh_FaceDiscret)

class BRepMesh_GeomTool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    NoIntersection = _BRepMesh.BRepMesh_GeomTool_NoIntersection
    Cross = _BRepMesh.BRepMesh_GeomTool_Cross
    EndPointTouch = _BRepMesh.BRepMesh_GeomTool_EndPointTouch
    PointOnSegment = _BRepMesh.BRepMesh_GeomTool_PointOnSegment
    Glued = _BRepMesh.BRepMesh_GeomTool_Glued
    Same = _BRepMesh.BRepMesh_GeomTool_Same


    class IntFlag(IntEnum):
    	NoIntersection = 0
    	Cross = 1
    	EndPointTouch = 2
    	PointOnSegment = 3
    	Glued = 4
    	Same = 5
    NoIntersection = IntFlag.NoIntersection
    Cross = IntFlag.Cross
    EndPointTouch = IntFlag.EndPointTouch
    PointOnSegment = IntFlag.PointOnSegment
    Glued = IntFlag.Glued
    Same = IntFlag.Same


    def __init__(self, *args):
        r"""
        Constructor. initiates discretization of the given geometric curve. @param thecurve curve to be discretized. @param thefirstparam first parameter of the curve. @param thelastparam last parameter of the curve. @param thelindeflection linear deflection. @param theangdeflection angular deflection. @param theminpointsnb minimum nuber of points to be produced.

        Parameters
        ----------
        theCurve: BRepAdaptor_Curve
        theFirstParam: float
        theLastParam: float
        theLinDeflection: float
        theAngDeflection: float
        theMinPointsNb: int,optional
        	default value is 2
        theMinSize: float,optional
        	default value is Precision::Confusion()

        Returns
        -------
        None
        Constructor. initiates discretization of geometric curve corresponding to iso curve of the given surface. @param thesurface surface the iso curve to be taken from. @param theisotype type of iso curve to be used, u or v. @param theparamiso parameter on the surface specifying the iso curve. @param thefirstparam first parameter of the curve. @param thelastparam last parameter of the curve. @param thelindeflection linear deflection. @param theangdeflection angular deflection. @param theminpointsnb minimum nuber of points to be produced.

        Parameters
        ----------
        theSurface: BRepAdaptor_HSurface
        theIsoType: GeomAbs_IsoType
        theParamIso: float
        theFirstParam: float
        theLastParam: float
        theLinDeflection: float
        theAngDeflection: float
        theMinPointsNb: int,optional
        	default value is 2
        theMinSize: float,optional
        	default value is Precision::Confusion()

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_GeomTool_swiginit(self, _BRepMesh.new_BRepMesh_GeomTool(*args))

    def AddPoint(self, *args) -> "Standard_Integer":
        r"""
        Adds point to already calculated points (or replaces existing). @param thepoint point to be added. @param theparam parameter on the curve corresponding to the given point. @param theisreplace if true replaces existing point lying within parameteric tolerance of the given point. returns index of new added point or found with parametric tolerance.

        Parameters
        ----------
        thePoint: gp_Pnt
        theParam: float
        theIsReplace: bool,optional
        	default value is Standard_True

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_GeomTool_AddPoint(self, *args)

    @staticmethod
    def CellsCount(*args) -> "std::pair< Standard_Integer,Standard_Integer >":
        r"""
        No available documentation.

        Parameters
        ----------
        theSurface: Handle ( Adaptor3d_HSurface )
        theVerticesNb: int
        theDeflection: float
        theRangeSplitter: BRepMesh_DefaultRangeSplitter *

        Returns
        -------
        std::pair<int, int >

        """
        return _BRepMesh.BRepMesh_GeomTool_CellsCount(*args)

    def NbPoints(self, *args) -> "Standard_Integer":
        r"""
        Returns number of discretization points.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_GeomTool_NbPoints(self, *args)

    @staticmethod
    def SquareDeflectionOfSegment(*args) -> "Standard_Real":
        r"""
        Compute deflection of the given segment.

        Parameters
        ----------
        theFirstPoint: gp_Pnt
        theLastPoint: gp_Pnt
        theMidPoint: gp_Pnt

        Returns
        -------
        float

        """
        return _BRepMesh.BRepMesh_GeomTool_SquareDeflectionOfSegment(*args)

    def Value(self, *args) -> "Standard_Boolean":
        r"""
        Gets parameters of discretization point with the given index. @param theindex index of discretization point. @param theisoparam parameter on surface to be used as second coordinate of resulting 2d point. @param theparam[out] parameter of the point on the iso curve. @param thepoint[out] discretization point. @param theuv[out] discretization point in parametric space of the surface. returns true on success, false elsewhere.

        Parameters
        ----------
        theIndex: int
        theIsoParam: float
        thePoint: gp_Pnt
        theUV: gp_Pnt2d

        Returns
        -------
        theParam: float
        Gets parameters of discretization point with the given index. @param theindex index of discretization point. @param thesurface surface the curve is lying onto. @param theparam[out] parameter of the point on the curve. @param thepoint[out] discretization point. @param theuv[out] discretization point in parametric space of the surface. returns true on success, false elsewhere.

        Parameters
        ----------
        theIndex: int
        theSurface: BRepAdaptor_HSurface
        thePoint: gp_Pnt
        theUV: gp_Pnt2d

        Returns
        -------
        theParam: float

        """
        return _BRepMesh.BRepMesh_GeomTool_Value(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def IntLinLin(self):
    	pass

    @methodnotwrapped
    def Normal(self):
    	pass

    @methodnotwrapped
    def IntSegSeg(self):
    	pass

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_GeomTool

# Register BRepMesh_GeomTool in _BRepMesh:
_BRepMesh.BRepMesh_GeomTool_swigregister(BRepMesh_GeomTool)

def BRepMesh_GeomTool_CellsCount(*args) -> "std::pair< Standard_Integer,Standard_Integer >":
    r"""
    No available documentation.

    Parameters
    ----------
    theSurface: Handle ( Adaptor3d_HSurface )
    theVerticesNb: int
    theDeflection: float
    theRangeSplitter: BRepMesh_DefaultRangeSplitter *

    Returns
    -------
    std::pair<int, int >

    """
    return _BRepMesh.BRepMesh_GeomTool_CellsCount(*args)

def BRepMesh_GeomTool_SquareDeflectionOfSegment(*args) -> "Standard_Real":
    r"""
    Compute deflection of the given segment.

    Parameters
    ----------
    theFirstPoint: gp_Pnt
    theLastPoint: gp_Pnt
    theMidPoint: gp_Pnt

    Returns
    -------
    float

    """
    return _BRepMesh.BRepMesh_GeomTool_SquareDeflectionOfSegment(*args)

class BRepMesh_MeshAlgoFactory(OCC.Core.IMeshTools.IMeshTools_MeshAlgoFactory):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_MeshAlgoFactory_swiginit(self, _BRepMesh.new_BRepMesh_MeshAlgoFactory(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_MeshAlgoFactory

# Register BRepMesh_MeshAlgoFactory in _BRepMesh:
_BRepMesh.BRepMesh_MeshAlgoFactory_swigregister(BRepMesh_MeshAlgoFactory)

class BRepMesh_MeshTool(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. initializes tool by the given data structure.

        Parameters
        ----------
        theStructure: BRepMesh_DataStructureOfDelaun

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_MeshTool_swiginit(self, _BRepMesh.new_BRepMesh_MeshTool(*args))

    def AddAndLegalizeTriangle(self, *args) -> "void":
        r"""
        Adds new triangle with specified nodes to mesh. legalizes triangle in case if it violates circle criteria.

        Parameters
        ----------
        thePoint1: int
        thePoint2: int
        thePoint3: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_MeshTool_AddAndLegalizeTriangle(self, *args)

    def AddLink(self, *args) -> "void":
        r"""
        Adds new link to mesh. updates link index and link orientaion parameters.

        Parameters
        ----------
        theFirstNode: int
        theLastNode: int

        Returns
        -------
        theLinkIndex: int
        theLinkOri: bool

        """
        return _BRepMesh.BRepMesh_MeshTool_AddLink(self, *args)

    def AddTriangle(self, *args) -> "void":
        r"""
        Adds new triangle with specified nodes to mesh.

        Parameters
        ----------
        thePoint1: int
        thePoint2: int
        thePoint3: int
        ): int (  theEdges

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_MeshTool_AddTriangle(self, *args)

    def CleanFrontierLinks(self, *args) -> "void":
        r"""
        Cleans frontier links from triangles to the right.

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_MeshTool_CleanFrontierLinks(self, *args)

    def EraseFreeLinks(self, *args) -> "void":
        r"""
        Erases all links that have no elements connected to them.

        Returns
        -------
        None
        Erases links from the specified map that have no elements connected to them.

        Parameters
        ----------
        theLinks: IMeshData::MapOfIntegerInteger

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_MeshTool_EraseFreeLinks(self, *args)

    def EraseItemsConnectedTo(self, *args) -> "void":
        r"""
        Erases all elements connected to the specified artificial node. in addition, erases the artificial node itself.

        Parameters
        ----------
        theNodeIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_MeshTool_EraseItemsConnectedTo(self, *args)

    def EraseTriangle(self, *args) -> "void":
        r"""
        Erases triangle with the given index and adds the free edges into the map. when an edge is suppressed more than one time it is destroyed.

        Parameters
        ----------
        theTriangleIndex: int
        theLoopEdges: IMeshData::MapOfIntegerInteger

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_MeshTool_EraseTriangle(self, *args)

    def GetStructure(self, *args) -> "opencascade::handle< BRepMesh_DataStructureOfDelaun > const &":
        r"""
        Returns data structure manipulated by this tool.

        Returns
        -------
        opencascade::handle<BRepMesh_DataStructureOfDelaun>

        """
        return _BRepMesh.BRepMesh_MeshTool_GetStructure(self, *args)

    def Legalize(self, *args) -> "void":
        r"""
        Performs legalization of triangles connected to the specified link.

        Parameters
        ----------
        theLinkIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_MeshTool_Legalize(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_MeshTool_DownCast(t)


    __repr__ = _dumps_object

    @methodnotwrapped
    def DumpTriangles(self):
    	pass

    @methodnotwrapped
    def EraseTriangles(self):
    	pass

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_MeshTool

# Register BRepMesh_MeshTool in _BRepMesh:
_BRepMesh.BRepMesh_MeshTool_swigregister(BRepMesh_MeshTool)

class BRepMesh_ModelBuilder(OCC.Core.IMeshTools.IMeshTools_ModelBuilder):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_ModelBuilder_swiginit(self, _BRepMesh.new_BRepMesh_ModelBuilder(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_ModelBuilder

# Register BRepMesh_ModelBuilder in _BRepMesh:
_BRepMesh.BRepMesh_ModelBuilder_swigregister(BRepMesh_ModelBuilder)

class BRepMesh_ModelHealer(OCC.Core.IMeshTools.IMeshTools_ModelAlgo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_ModelHealer_swiginit(self, _BRepMesh.new_BRepMesh_ModelHealer(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_ModelHealer

# Register BRepMesh_ModelHealer in _BRepMesh:
_BRepMesh.BRepMesh_ModelHealer_swigregister(BRepMesh_ModelHealer)

class BRepMesh_ModelPostProcessor(OCC.Core.IMeshTools.IMeshTools_ModelAlgo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_ModelPostProcessor_swiginit(self, _BRepMesh.new_BRepMesh_ModelPostProcessor(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_ModelPostProcessor

# Register BRepMesh_ModelPostProcessor in _BRepMesh:
_BRepMesh.BRepMesh_ModelPostProcessor_swigregister(BRepMesh_ModelPostProcessor)

class BRepMesh_ModelPreProcessor(OCC.Core.IMeshTools.IMeshTools_ModelAlgo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_ModelPreProcessor_swiginit(self, _BRepMesh.new_BRepMesh_ModelPreProcessor(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_ModelPreProcessor

# Register BRepMesh_ModelPreProcessor in _BRepMesh:
_BRepMesh.BRepMesh_ModelPreProcessor_swigregister(BRepMesh_ModelPreProcessor)

class BRepMesh_OrientedEdge(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Constructs a link between two vertices.

        Parameters
        ----------
        theFirstNode: int
        theLastNode: int

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_OrientedEdge_swiginit(self, _BRepMesh.new_BRepMesh_OrientedEdge(*args))

    def FirstNode(self, *args) -> "Standard_Integer":
        r"""
        Returns index of first node of the link.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_OrientedEdge_FirstNode(self, *args)

    def HashCode(self, *args) -> "Standard_Integer":
        r"""
        Computes a hash code for this oriented edge, in the range [1, theupperbound] @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theUpperBound: int

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_OrientedEdge_HashCode(self, *args)

    def __hash__(self) -> "Standard_Integer":
        return _BRepMesh.BRepMesh_OrientedEdge___hash__(self)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Checks this and other edge for equality. @param theother edge to be checked against this one. @retrun true if edges have the same orientation, false if not.

        Parameters
        ----------
        theOther: BRepMesh_OrientedEdge

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_OrientedEdge_IsEqual(self, *args)

    def LastNode(self, *args) -> "Standard_Integer":
        r"""
        Returns index of last node of the link.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_OrientedEdge_LastNode(self, *args)

    def __eq_wrapper__(self, other: "BRepMesh_OrientedEdge") -> "bool":
        return _BRepMesh.BRepMesh_OrientedEdge___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_OrientedEdge

# Register BRepMesh_OrientedEdge in _BRepMesh:
_BRepMesh.BRepMesh_OrientedEdge_swigregister(BRepMesh_OrientedEdge)

class BRepMesh_PairOfIndex(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_PairOfIndex_swiginit(self, _BRepMesh.new_BRepMesh_PairOfIndex(*args))

    def Append(self, *args) -> "void":
        r"""
        Appends index to the pair.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_PairOfIndex_Append(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears indices.

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_PairOfIndex_Clear(self, *args)

    def Extent(self, *args) -> "Standard_Integer":
        r"""
        Returns number of initialized indeces.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_PairOfIndex_Extent(self, *args)

    def FirstIndex(self, *args) -> "Standard_Integer":
        r"""
        Returns first index of pair.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_PairOfIndex_FirstIndex(self, *args)

    def Index(self, *args) -> "Standard_Integer":
        r"""
        Returns index corresponding to the given position in the pair. @param thepairpos position of index in the pair (1 or 2).

        Parameters
        ----------
        thePairPos: int

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_PairOfIndex_Index(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns is pair is empty.

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_PairOfIndex_IsEmpty(self, *args)

    def LastIndex(self, *args) -> "Standard_Integer":
        r"""
        Returns last index of pair.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_PairOfIndex_LastIndex(self, *args)

    def Prepend(self, *args) -> "void":
        r"""
        Prepends index to the pair.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_PairOfIndex_Prepend(self, *args)

    def RemoveIndex(self, *args) -> "void":
        r"""
        Remove index from the given position. @param thepairpos position of index in the pair (1 or 2).

        Parameters
        ----------
        thePairPos: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_PairOfIndex_RemoveIndex(self, *args)

    def SetIndex(self, *args) -> "void":
        r"""
        Sets index corresponding to the given position in the pair. @param thepairpos position of index in the pair (1 or 2). @param theindex index to be stored.

        Parameters
        ----------
        thePairPos: int
        theIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_PairOfIndex_SetIndex(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_PairOfIndex

# Register BRepMesh_PairOfIndex in _BRepMesh:
_BRepMesh.BRepMesh_PairOfIndex_swigregister(BRepMesh_PairOfIndex)

class BRepMesh_SelectorOfDataStructureOfDelaun(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Constructor. initializes selector by the mesh.

        Parameters
        ----------
        theMesh: BRepMesh_DataStructureOfDelaun

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_swiginit(self, _BRepMesh.new_BRepMesh_SelectorOfDataStructureOfDelaun(*args))

    def AddNeighbours(self, *args) -> "void":
        r"""
        Adds a level of neighbours by edge the selector.

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_AddNeighbours(self, *args)

    def Elements(self, *args) -> "IMeshData::MapOfInteger const &":
        r"""
        Returns selected elements.

        Returns
        -------
        IMeshData::MapOfInteger

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_Elements(self, *args)

    def FrontierLinks(self, *args) -> "IMeshData::MapOfInteger const &":
        r"""
        Gives the list of incices of frontier links.

        Returns
        -------
        IMeshData::MapOfInteger

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_FrontierLinks(self, *args)

    def Initialize(self, *args) -> "void":
        r"""
        Initializes selector by the mesh.

        Parameters
        ----------
        theMesh: BRepMesh_DataStructureOfDelaun

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_Initialize(self, *args)

    def Links(self, *args) -> "IMeshData::MapOfInteger const &":
        r"""
        Returns selected links.

        Returns
        -------
        IMeshData::MapOfInteger

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_Links(self, *args)

    def NeighboursByEdgeOf(self, *args) -> "void":
        r"""
        Selects all neighboring elements by links of the given element.

        Parameters
        ----------
        theElement: BRepMesh_Triangle

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_NeighboursByEdgeOf(self, *args)

    def NeighboursOf(self, *args) -> "void":
        r"""
        Selects all neighboring elements of the given node.

        Parameters
        ----------
        theNode: BRepMesh_Vertex

        Returns
        -------
        None
        Selects all neighboring elements of the given link.

        Parameters
        ----------
        theLink: BRepMesh_Edge

        Returns
        -------
        None
        Selects all neighboring elements of the given element.

        Parameters
        ----------
        theElement: BRepMesh_Triangle

        Returns
        -------
        None
        Adds a level of neighbours by edge to the selector.

        Parameters
        ----------
        &: BRepMesh_SelectorOfDataStructureOfDelaun

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_NeighboursOf(self, *args)

    def NeighboursOfElement(self, *args) -> "void":
        r"""
        Selects all neighboring elements by nodes of the given element.

        Parameters
        ----------
        theElementIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_NeighboursOfElement(self, *args)

    def NeighboursOfLink(self, *args) -> "void":
        r"""
        Selects all neighboring elements of link with the given index.

        Parameters
        ----------
        theLinkIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_NeighboursOfLink(self, *args)

    def NeighboursOfNode(self, *args) -> "void":
        r"""
        Selects all neighboring elements of node with the given index.

        Parameters
        ----------
        theNodeIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_NeighboursOfNode(self, *args)

    def Nodes(self, *args) -> "IMeshData::MapOfInteger const &":
        r"""
        Returns selected nodes.

        Returns
        -------
        IMeshData::MapOfInteger

        """
        return _BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_Nodes(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_SelectorOfDataStructureOfDelaun_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_SelectorOfDataStructureOfDelaun

# Register BRepMesh_SelectorOfDataStructureOfDelaun in _BRepMesh:
_BRepMesh.BRepMesh_SelectorOfDataStructureOfDelaun_swigregister(BRepMesh_SelectorOfDataStructureOfDelaun)

class BRepMesh_ShapeTool(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def AddInFace(*args) -> "void":
        r"""
        Stores the given triangulation into the given face. @param theface face to be updated by triangulation. @param thetriangulation triangulation to be stored into the face.

        Parameters
        ----------
        theFace: TopoDS_Face
        theTriangulation: Poly_Triangulation

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_ShapeTool_AddInFace(*args)

    @staticmethod
    def BoxMaxDimension(*args) -> "Standard_Real &":
        r"""
        Gets the maximum dimension of the given bounding box. if the given bounding box is void leaves the resulting value unchanged. @param thebox bounding box to be processed. @param themaxdimension maximum dimension of the given box.

        Parameters
        ----------
        theBox: Bnd_Box

        Returns
        -------
        theMaxDimension: float

        """
        return _BRepMesh.BRepMesh_ShapeTool_BoxMaxDimension(*args)

    @staticmethod
    def CheckAndUpdateFlags(*args) -> "void":
        r"""
        Checks same parameter, same range and degenerativity attributes using geometrical data of the given edge and updates edge model by computed parameters in case of worst case - it can drop flags same parameter and same range to false but never to true if it is already set to false. in contrary, it can also drop degenerated flag to true, but never to false if it is already set to true.

        Parameters
        ----------
        theEdge: IMeshData::IEdgeHandle
        thePCurve: IMeshData::IPCurveHandle

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_ShapeTool_CheckAndUpdateFlags(*args)

    @staticmethod
    def MaxFaceTolerance(*args) -> "Standard_Real":
        r"""
        Returns maximum tolerance of the given face. considers tolerances of edges and vertices contained in the given face.

        Parameters
        ----------
        theFace: TopoDS_Face

        Returns
        -------
        float

        """
        return _BRepMesh.BRepMesh_ShapeTool_MaxFaceTolerance(*args)

    @staticmethod
    def NullifyEdge(*args) -> "void":
        r"""
        Nullifies polygon on triangulation stored in the edge. @param theedge edge to be updated by null polygon. @param thetriangulation triangulation the given edge is associated to. @param thelocation face location.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theTriangulation: Handle ( Poly_Triangulation )
        theLocation: TopLoc_Location

        Returns
        -------
        None
        Nullifies 3d polygon stored in the edge. @param theedge edge to be updated by null polygon. @param thelocation face location.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theLocation: TopLoc_Location

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_ShapeTool_NullifyEdge(*args)

    @staticmethod
    def NullifyFace(*args) -> "void":
        r"""
        Nullifies triangulation stored in the face. @param theface face to be updated by null triangulation.

        Parameters
        ----------
        theFace: TopoDS_Face

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_ShapeTool_NullifyFace(*args)

    @staticmethod
    def Range(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        Gets the parametric range of the given edge on the given face.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face
        thePCurve: Handle ( Geom2d_Curve )
        isConsiderOrientation: bool,optional
        	default value is Standard_False

        Returns
        -------
        theFirstParam: float
        theLastParam: float
        Gets the 3d range of the given edge.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theCurve: Handle ( Geom_Curve )
        isConsiderOrientation: bool,optional
        	default value is Standard_False

        Returns
        -------
        theFirstParam: float
        theLastParam: float

        """
        return _BRepMesh.BRepMesh_ShapeTool_Range(*args)

    @staticmethod
    def UVPoints(*args) -> "Standard_Boolean":
        r"""
        Gets the strict uv locations of the extremities of the edge using pcurve.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face
        theFirstPoint2d: gp_Pnt2d
        theLastPoint2d: gp_Pnt2d
        isConsiderOrientation: bool,optional
        	default value is Standard_False

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_ShapeTool_UVPoints(*args)

    @staticmethod
    def UpdateEdge(*args) -> "void":
        r"""
        Updates the given edge by the given tessellated representation. @param theedge edge to be updated. @param thepolygon tessellated representation of the edge to be stored. @param thetriangulation triangulation the given edge is associated to. @param thelocation face location.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        thePolygon: Handle ( Poly_PolygonOnTriangulation )
        theTriangulation: Handle ( Poly_Triangulation )
        theLocation: TopLoc_Location

        Returns
        -------
        None
        Updates the given edge by the given tessellated representation. @param theedge edge to be updated. @param thepolygon tessellated representation of the edge to be stored.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        thePolygon: Poly_Polygon3D

        Returns
        -------
        None
        Updates the given seam edge by the given tessellated representations. @param theedge edge to be updated. @param thepolygon1 tessellated representation corresponding to forward direction of the seam edge. @param thepolygon2 tessellated representation corresponding to reversed direction of the seam edge. @param thetriangulation triangulation the given edge is associated to. @param thelocation face location.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        thePolygon1: Handle ( Poly_PolygonOnTriangulation )
        thePolygon2: Handle ( Poly_PolygonOnTriangulation )
        theTriangulation: Handle ( Poly_Triangulation )
        theLocation: TopLoc_Location

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_ShapeTool_UpdateEdge(*args)

    @staticmethod
    def UseLocation(*args) -> "gp_Pnt":
        r"""
        Applies location to the given point and return result. @param thepnt point to be transformed. @param theloc location to be applied.

        Parameters
        ----------
        thePnt: gp_Pnt
        theLoc: TopLoc_Location

        Returns
        -------
        gp_Pnt

        """
        return _BRepMesh.BRepMesh_ShapeTool_UseLocation(*args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_ShapeTool_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _BRepMesh.BRepMesh_ShapeTool_swiginit(self, _BRepMesh.new_BRepMesh_ShapeTool())
    __swig_destroy__ = _BRepMesh.delete_BRepMesh_ShapeTool

# Register BRepMesh_ShapeTool in _BRepMesh:
_BRepMesh.BRepMesh_ShapeTool_swigregister(BRepMesh_ShapeTool)

def BRepMesh_ShapeTool_AddInFace(*args) -> "void":
    r"""
    Stores the given triangulation into the given face. @param theface face to be updated by triangulation. @param thetriangulation triangulation to be stored into the face.

    Parameters
    ----------
    theFace: TopoDS_Face
    theTriangulation: Poly_Triangulation

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_ShapeTool_AddInFace(*args)

def BRepMesh_ShapeTool_BoxMaxDimension(*args) -> "Standard_Real &":
    r"""
    Gets the maximum dimension of the given bounding box. if the given bounding box is void leaves the resulting value unchanged. @param thebox bounding box to be processed. @param themaxdimension maximum dimension of the given box.

    Parameters
    ----------
    theBox: Bnd_Box

    Returns
    -------
    theMaxDimension: float

    """
    return _BRepMesh.BRepMesh_ShapeTool_BoxMaxDimension(*args)

def BRepMesh_ShapeTool_CheckAndUpdateFlags(*args) -> "void":
    r"""
    Checks same parameter, same range and degenerativity attributes using geometrical data of the given edge and updates edge model by computed parameters in case of worst case - it can drop flags same parameter and same range to false but never to true if it is already set to false. in contrary, it can also drop degenerated flag to true, but never to false if it is already set to true.

    Parameters
    ----------
    theEdge: IMeshData::IEdgeHandle
    thePCurve: IMeshData::IPCurveHandle

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_ShapeTool_CheckAndUpdateFlags(*args)

def BRepMesh_ShapeTool_MaxFaceTolerance(*args) -> "Standard_Real":
    r"""
    Returns maximum tolerance of the given face. considers tolerances of edges and vertices contained in the given face.

    Parameters
    ----------
    theFace: TopoDS_Face

    Returns
    -------
    float

    """
    return _BRepMesh.BRepMesh_ShapeTool_MaxFaceTolerance(*args)

def BRepMesh_ShapeTool_NullifyEdge(*args) -> "void":
    r"""
    Nullifies polygon on triangulation stored in the edge. @param theedge edge to be updated by null polygon. @param thetriangulation triangulation the given edge is associated to. @param thelocation face location.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    theTriangulation: Handle ( Poly_Triangulation )
    theLocation: TopLoc_Location

    Returns
    -------
    None
    Nullifies 3d polygon stored in the edge. @param theedge edge to be updated by null polygon. @param thelocation face location.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    theLocation: TopLoc_Location

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_ShapeTool_NullifyEdge(*args)

def BRepMesh_ShapeTool_NullifyFace(*args) -> "void":
    r"""
    Nullifies triangulation stored in the face. @param theface face to be updated by null triangulation.

    Parameters
    ----------
    theFace: TopoDS_Face

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_ShapeTool_NullifyFace(*args)

def BRepMesh_ShapeTool_Range(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    Gets the parametric range of the given edge on the given face.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    theFace: TopoDS_Face
    thePCurve: Handle ( Geom2d_Curve )
    isConsiderOrientation: bool,optional
    	default value is Standard_False

    Returns
    -------
    theFirstParam: float
    theLastParam: float
    Gets the 3d range of the given edge.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    theCurve: Handle ( Geom_Curve )
    isConsiderOrientation: bool,optional
    	default value is Standard_False

    Returns
    -------
    theFirstParam: float
    theLastParam: float

    """
    return _BRepMesh.BRepMesh_ShapeTool_Range(*args)

def BRepMesh_ShapeTool_UVPoints(*args) -> "Standard_Boolean":
    r"""
    Gets the strict uv locations of the extremities of the edge using pcurve.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    theFace: TopoDS_Face
    theFirstPoint2d: gp_Pnt2d
    theLastPoint2d: gp_Pnt2d
    isConsiderOrientation: bool,optional
    	default value is Standard_False

    Returns
    -------
    bool

    """
    return _BRepMesh.BRepMesh_ShapeTool_UVPoints(*args)

def BRepMesh_ShapeTool_UpdateEdge(*args) -> "void":
    r"""
    Updates the given edge by the given tessellated representation. @param theedge edge to be updated. @param thepolygon tessellated representation of the edge to be stored. @param thetriangulation triangulation the given edge is associated to. @param thelocation face location.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    thePolygon: Handle ( Poly_PolygonOnTriangulation )
    theTriangulation: Handle ( Poly_Triangulation )
    theLocation: TopLoc_Location

    Returns
    -------
    None
    Updates the given edge by the given tessellated representation. @param theedge edge to be updated. @param thepolygon tessellated representation of the edge to be stored.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    thePolygon: Poly_Polygon3D

    Returns
    -------
    None
    Updates the given seam edge by the given tessellated representations. @param theedge edge to be updated. @param thepolygon1 tessellated representation corresponding to forward direction of the seam edge. @param thepolygon2 tessellated representation corresponding to reversed direction of the seam edge. @param thetriangulation triangulation the given edge is associated to. @param thelocation face location.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    thePolygon1: Handle ( Poly_PolygonOnTriangulation )
    thePolygon2: Handle ( Poly_PolygonOnTriangulation )
    theTriangulation: Handle ( Poly_Triangulation )
    theLocation: TopLoc_Location

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_ShapeTool_UpdateEdge(*args)

def BRepMesh_ShapeTool_UseLocation(*args) -> "gp_Pnt":
    r"""
    Applies location to the given point and return result. @param thepnt point to be transformed. @param theloc location to be applied.

    Parameters
    ----------
    thePnt: gp_Pnt
    theLoc: TopLoc_Location

    Returns
    -------
    gp_Pnt

    """
    return _BRepMesh.BRepMesh_ShapeTool_UseLocation(*args)

class BRepMesh_ShapeVisitor(OCC.Core.IMeshTools.IMeshTools_ShapeVisitor):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Parameters
        ----------
        theModel: Handle ( IMeshData_Model )

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_ShapeVisitor_swiginit(self, _BRepMesh.new_BRepMesh_ShapeVisitor(*args))

    def Visit(self, *args) -> "void":
        r"""
        Handles topods_face object.

        Parameters
        ----------
        theFace: TopoDS_Face

        Returns
        -------
        None
        Handles topods_edge object.

        Parameters
        ----------
        theEdge: TopoDS_Edge

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_ShapeVisitor_Visit(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_ShapeVisitor

# Register BRepMesh_ShapeVisitor in _BRepMesh:
_BRepMesh.BRepMesh_ShapeVisitor_swigregister(BRepMesh_ShapeVisitor)

class BRepMesh_Triangle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    myEdges = property(_BRepMesh.BRepMesh_Triangle_myEdges_get, _BRepMesh.BRepMesh_Triangle_myEdges_set)
    myOrientations = property(_BRepMesh.BRepMesh_Triangle_myOrientations_get, _BRepMesh.BRepMesh_Triangle_myOrientations_set)
    myMovability = property(_BRepMesh.BRepMesh_Triangle_myMovability_get, _BRepMesh.BRepMesh_Triangle_myMovability_set)

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Constructor. @param theedges array of edges of triangle. @param theorientations array of edge's orientations. @param themovability movability of triangle.

        Parameters
        ----------
        ): int (  theEdges
        ): bool (  theOrientations
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_Triangle_swiginit(self, _BRepMesh.new_BRepMesh_Triangle(*args))

    def Edges(self, *args) -> "void":
        r"""
        Gets edges with orientations composing the triangle. @param[out] theedges array edges are stored to. @param[out] theorientations array orientations are stored to.

        Parameters
        ----------
        ): int (  theEdges
        ): bool (  theOrientations

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Triangle_Edges(self, *args)

    def HashCode(self, *args) -> "Standard_Integer":
        r"""
        Computes a hash code for this triangle, in the range [1, theupperbound] @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theUpperBound: int

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_Triangle_HashCode(self, *args)

    def __hash__(self) -> "Standard_Integer":
        return _BRepMesh.BRepMesh_Triangle___hash__(self)

    def Initialize(self, *args) -> "void":
        r"""
        Initializes the triangle by the given parameters. @param theedges array of edges of triangle. @param theorientations array of edge's orientations. @param themovability movability of triangle.

        Parameters
        ----------
        ): int (  theEdges
        ): bool (  theOrientations
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Triangle_Initialize(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Checks for equality with another triangle. @param theother triangle to be checked against this one. returns true if equal, false if not.

        Parameters
        ----------
        theOther: BRepMesh_Triangle

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_Triangle_IsEqual(self, *args)

    def Movability(self, *args) -> "BRepMesh_DegreeOfFreedom":
        r"""
        Returns movability of the triangle.

        Returns
        -------
        BRepMesh_DegreeOfFreedom

        """
        return _BRepMesh.BRepMesh_Triangle_Movability(self, *args)

    def SetMovability(self, *args) -> "void":
        r"""
        Sets movability of the triangle.

        Parameters
        ----------
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Triangle_SetMovability(self, *args)

    def __eq_wrapper__(self, other: "BRepMesh_Triangle") -> "bool":
        return _BRepMesh.BRepMesh_Triangle___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_Triangle

# Register BRepMesh_Triangle in _BRepMesh:
_BRepMesh.BRepMesh_Triangle_swigregister(BRepMesh_Triangle)

class BRepMesh_Vertex(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Creates vertex associated with point in 3d space. @param theuv position of vertex in parametric space. @param thelocation3d index of 3d point to be associated with vertex. @param themovability movability of the vertex.

        Parameters
        ----------
        theUV: gp_XY
        theLocation3d: int
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None
        Creates vertex without association with point in 3d space. @param theu u position of vertex in parametric space. @param thev v position of vertex in parametric space. @param themovability movability of the vertex.

        Parameters
        ----------
        theU: float
        theV: float
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_Vertex_swiginit(self, _BRepMesh.new_BRepMesh_Vertex(*args))

    def ChangeCoord(self, *args) -> "gp_XY":
        r"""
        Returns position of the vertex in parametric space for modification.

        Returns
        -------
        gp_XY

        """
        return _BRepMesh.BRepMesh_Vertex_ChangeCoord(self, *args)

    def Coord(self, *args) -> "gp_XY const":
        r"""
        Returns position of the vertex in parametric space.

        Returns
        -------
        gp_XY

        """
        return _BRepMesh.BRepMesh_Vertex_Coord(self, *args)

    def HashCode(self, *args) -> "Standard_Integer":
        r"""
        Computes a hash code for this vertex, in the range [1, theupperbound] @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theUpperBound: int

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_Vertex_HashCode(self, *args)

    def __hash__(self) -> "Standard_Integer":
        return _BRepMesh.BRepMesh_Vertex___hash__(self)

    def Initialize(self, *args) -> "void":
        r"""
        Initializes vertex associated with point in 3d space. @param theuv position of vertex in parametric space. @param thelocation3d index of 3d point to be associated with vertex. @param themovability movability of the vertex.

        Parameters
        ----------
        theUV: gp_XY
        theLocation3d: int
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Vertex_Initialize(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Checks for equality with another vertex. @param theother vertex to be checked against this one. returns true if equal, false if not.

        Parameters
        ----------
        theOther: BRepMesh_Vertex

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_Vertex_IsEqual(self, *args)

    def Location3d(self, *args) -> "Standard_Integer":
        r"""
        Returns index of 3d point associated with the vertex.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_Vertex_Location3d(self, *args)

    def Movability(self, *args) -> "BRepMesh_DegreeOfFreedom":
        r"""
        Returns movability of the vertex.

        Returns
        -------
        BRepMesh_DegreeOfFreedom

        """
        return _BRepMesh.BRepMesh_Vertex_Movability(self, *args)

    def SetMovability(self, *args) -> "void":
        r"""
        Sets movability of the vertex.

        Parameters
        ----------
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Vertex_SetMovability(self, *args)

    def __eq_wrapper__(self, other: "BRepMesh_Vertex") -> "bool":
        return _BRepMesh.BRepMesh_Vertex___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_Vertex

# Register BRepMesh_Vertex in _BRepMesh:
_BRepMesh.BRepMesh_Vertex_swigregister(BRepMesh_Vertex)

class BRepMesh_VertexInspector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. @param theallocator memory allocator to be used by internal collections.

        Parameters
        ----------
        theAllocator: NCollection_IncAllocator

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_VertexInspector_swiginit(self, _BRepMesh.new_BRepMesh_VertexInspector(*args))

    def Add(self, *args) -> "Standard_Integer":
        r"""
        Registers the given vertex. @param thevertex vertex to be registered.

        Parameters
        ----------
        theVertex: BRepMesh_Vertex

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_VertexInspector_Add(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clear inspector's internal data structures.

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexInspector_Clear(self, *args)

    def Delete(self, *args) -> "void":
        r"""
        Deletes vertex with the given index. @param theindex index of vertex to be removed.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexInspector_Delete(self, *args)

    def GetCoincidentPoint(self, *args) -> "Standard_Integer":
        r"""
        Returns index of point coinciding with regerence one.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_VertexInspector_GetCoincidentPoint(self, *args)

    def GetListOfDelPoints(self, *args) -> "IMeshData::ListOfInteger const &":
        r"""
        Returns list with indexes of vertices that have movability attribute equal to brepmesh_deleted and can be replaced with another node.

        Returns
        -------
        IMeshData::ListOfInteger

        """
        return _BRepMesh.BRepMesh_VertexInspector_GetListOfDelPoints(self, *args)

    def GetVertex(self, *args) -> "BRepMesh_Vertex &":
        r"""
        Returns vertex with the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Vertex

        """
        return _BRepMesh.BRepMesh_VertexInspector_GetVertex(self, *args)

    def Inspect(self, *args) -> "NCollection_CellFilter_Action":
        r"""
        Performs inspection of a point with the given index. @param thetargetindex index of a circle to be checked. returns status of the check.

        Parameters
        ----------
        theTargetIndex: int

        Returns
        -------
        NCollection_CellFilter_Action

        """
        return _BRepMesh.BRepMesh_VertexInspector_Inspect(self, *args)

    @staticmethod
    def IsEqual(*args) -> "Standard_Boolean":
        r"""
        Checks indices for equlity.

        Parameters
        ----------
        theIndex: int
        theTargetIndex: int

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_VertexInspector_IsEqual(*args)

    def NbVertices(self, *args) -> "Standard_Integer":
        r"""
        Returns number of registered vertices.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_VertexInspector_NbVertices(self, *args)

    def SetPoint(self, *args) -> "void":
        r"""
        Set reference point to be checked.

        Parameters
        ----------
        thePoint: gp_XY

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexInspector_SetPoint(self, *args)

    def SetTolerance(self, *args) -> "void":
        r"""
        Sets the tolerance to be used for identification of coincident vertices equal for both dimensions.

        Parameters
        ----------
        theTolerance: float

        Returns
        -------
        None
        Sets the tolerance to be used for identification of coincident vertices. @param thetolerancex tolerance for x dimension. @param thetolerancey tolerance for y dimension.

        Parameters
        ----------
        theToleranceX: float
        theToleranceY: float

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexInspector_SetTolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_VertexInspector

# Register BRepMesh_VertexInspector in _BRepMesh:
_BRepMesh.BRepMesh_VertexInspector_swigregister(BRepMesh_VertexInspector)

def BRepMesh_VertexInspector_IsEqual(*args) -> "Standard_Boolean":
    r"""
    Checks indices for equlity.

    Parameters
    ----------
    theIndex: int
    theTargetIndex: int

    Returns
    -------
    bool

    """
    return _BRepMesh.BRepMesh_VertexInspector_IsEqual(*args)

class BRepMesh_VertexTool(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. @param theallocator memory allocator to be used by internal collections.

        Parameters
        ----------
        theAllocator: NCollection_IncAllocator

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_VertexTool_swiginit(self, _BRepMesh.new_BRepMesh_VertexTool(*args))

    def Add(self, *args) -> "Standard_Integer":
        r"""
        Adds vertex with empty data to the tool. @param thevertex node to be added to the mesh. @param isforceadd adds the given node to structure without checking on coincidence with other nodes. returns index of the node in the structure.

        Parameters
        ----------
        theVertex: BRepMesh_Vertex
        isForceAdd: bool

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_VertexTool_Add(self, *args)

    def DeleteVertex(self, *args) -> "void":
        r"""
        Deletes vertex with the given index from the tool.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexTool_DeleteVertex(self, *args)

    def Extent(self, *args) -> "Standard_Integer":
        r"""
        Returns a number of vertices.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_VertexTool_Extent(self, *args)

    def FindIndex(self, *args) -> "Standard_Integer":
        r"""
        Returns index of the given vertex.

        Parameters
        ----------
        theVertex: BRepMesh_Vertex

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_VertexTool_FindIndex(self, *args)

    def FindKey(self, *args) -> "BRepMesh_Vertex const &":
        r"""
        Returns vertex by the given index.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        BRepMesh_Vertex

        """
        return _BRepMesh.BRepMesh_VertexTool_FindKey(self, *args)

    def GetListOfDelNodes(self, *args) -> "IMeshData::ListOfInteger const &":
        r"""
        Returns the list with indexes of vertices that have movability attribute equal to brepmesh_deleted and can be replaced with another node.

        Returns
        -------
        IMeshData::ListOfInteger

        """
        return _BRepMesh.BRepMesh_VertexTool_GetListOfDelNodes(self, *args)

    def GetTolerance(self, *args) -> "void":
        r"""
        Gets the tolerance to be used for identification of coincident vertices. @param thetolerancex tolerance for x dimension. @param thetolerancey tolerance for y dimension.

        Parameters
        ----------

        Returns
        -------
        theToleranceX: float
        theToleranceY: float

        """
        return _BRepMesh.BRepMesh_VertexTool_GetTolerance(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns true when the map contains no keys. .

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_VertexTool_IsEmpty(self, *args)

    def RemoveLast(self, *args) -> "void":
        r"""
        Remove last node from the structure.

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexTool_RemoveLast(self, *args)

    def SetCellSize(self, *args) -> "void":
        r"""
        Sets new size of cell for cellfilter equal in both directions.

        Parameters
        ----------
        theSize: float

        Returns
        -------
        None
        Sets new size of cell for cellfilter. @param thesizex size for x dimension. @param thesizey size for y dimension.

        Parameters
        ----------
        theSizeX: float
        theSizeY: float

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexTool_SetCellSize(self, *args)

    def SetTolerance(self, *args) -> "void":
        r"""
        Sets the tolerance to be used for identification of coincident vertices equal for both dimensions.

        Parameters
        ----------
        theTolerance: float

        Returns
        -------
        None
        Sets the tolerance to be used for identification of coincident vertices. @param thetolerancex tolerance for x dimension. @param thetolerancey tolerance for y dimension.

        Parameters
        ----------
        theToleranceX: float
        theToleranceY: float

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexTool_SetTolerance(self, *args)

    def StatisticsToString(self) -> "std::string":
        r"""StatisticsToString(BRepMesh_VertexTool self) -> std::string"""
        return _BRepMesh.BRepMesh_VertexTool_StatisticsToString(self)

    def Substitute(self, *args) -> "void":
        r"""
        Substitutes vertex with the given by the given vertex with attributes. @param theindex index of vertex to be substituted. @param thevertex replacement vertex.

        Parameters
        ----------
        theIndex: int
        theVertex: BRepMesh_Vertex

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_VertexTool_Substitute(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_VertexTool_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_VertexTool

# Register BRepMesh_VertexTool in _BRepMesh:
_BRepMesh.BRepMesh_VertexTool_swigregister(BRepMesh_VertexTool)

class BRepMesh_Edge(BRepMesh_OrientedEdge):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Constructs a link between two vertices.

        Parameters
        ----------
        theFirstNode: int
        theLastNode: int
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_Edge_swiginit(self, _BRepMesh.new_BRepMesh_Edge(*args))

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Checks for equality with another edge. @param theother edge to be checked against this one. returns true if equal, false if not.

        Parameters
        ----------
        theOther: BRepMesh_Edge

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_Edge_IsEqual(self, *args)

    def IsSameOrientation(self, *args) -> "Standard_Boolean":
        r"""
        Checks if the given edge and this one have the same orientation. @param theother edge to be checked against this one. etrun true if edges have the same orientation, false if not.

        Parameters
        ----------
        theOther: BRepMesh_Edge

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_Edge_IsSameOrientation(self, *args)

    def Movability(self, *args) -> "BRepMesh_DegreeOfFreedom":
        r"""
        Returns movability flag of the link.

        Returns
        -------
        BRepMesh_DegreeOfFreedom

        """
        return _BRepMesh.BRepMesh_Edge_Movability(self, *args)

    def SetMovability(self, *args) -> "void":
        r"""
        Sets movability flag of the link. @param themovability flag to be set.

        Parameters
        ----------
        theMovability: BRepMesh_DegreeOfFreedom

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_Edge_SetMovability(self, *args)

    def __eq_wrapper__(self, other: "BRepMesh_Edge") -> "bool":
        return _BRepMesh.BRepMesh_Edge___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_Edge

# Register BRepMesh_Edge in _BRepMesh:
_BRepMesh.BRepMesh_Edge_swigregister(BRepMesh_Edge)

class BRepMesh_IncrementalMesh(BRepMesh_DiscretRoot):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None
        Constructor. automatically calls method perform. @param theshape shape to be meshed. @param thelindeflection linear deflection. @param isrelative if true deflection used for discretization of each edge will be <thelindeflection> * <size of edge>. deflection used for the faces will be the maximum deflection of their edges. @param theangdeflection angular deflection. @param isinparallel if true shape will be meshed in parallel.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theLinDeflection: float
        isRelative: bool,optional
        	default value is Standard_False
        theAngDeflection: float,optional
        	default value is 0.5
        isInParallel: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Constructor. automatically calls method perform. @param theshape shape to be meshed. @param theparameters - parameters of meshing.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theParameters: IMeshTools_Parameters

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_IncrementalMesh_swiginit(self, _BRepMesh.new_BRepMesh_IncrementalMesh(*args))

    def ChangeParameters(self, *args) -> "IMeshTools_Parameters &":
        r"""
        Returns modifiable meshing parameters.

        Returns
        -------
        IMeshTools_Parameters

        """
        return _BRepMesh.BRepMesh_IncrementalMesh_ChangeParameters(self, *args)

    @staticmethod
    def Discret(*args) -> "Standard_Integer":
        r"""
        Plugin interface for the mesh factories. initializes meshing algorithm with the given parameters. @param theshape shape to be meshed. @param thelindeflection linear deflection. @param theangdeflection angular deflection. @param[out] thealgo pointer to initialized algorithm.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theLinDeflection: float
        theAngDeflection: float
        theAlgo: BRepMesh_DiscretRoot *

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_IncrementalMesh_Discret(*args)

    def GetStatusFlags(self, *args) -> "Standard_Integer":
        r"""
        Returns accumulated status flags faced during meshing.

        Returns
        -------
        int

        """
        return _BRepMesh.BRepMesh_IncrementalMesh_GetStatusFlags(self, *args)

    def IsModified(self, *args) -> "Standard_Boolean":
        r"""
        Returns modified flag.

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_IncrementalMesh_IsModified(self, *args)

    @staticmethod
    def IsParallelDefault(*args) -> "Standard_Boolean":
        r"""
        Returns multi-threading usage flag set by default in discret() static method (thus applied only to mesh factories).

        Returns
        -------
        bool

        """
        return _BRepMesh.BRepMesh_IncrementalMesh_IsParallelDefault(*args)

    def Parameters(self, *args) -> "IMeshTools_Parameters const &":
        r"""
        Returns meshing parameters.

        Returns
        -------
        IMeshTools_Parameters

        """
        return _BRepMesh.BRepMesh_IncrementalMesh_Parameters(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Performs meshing ot the shape.

        Returns
        -------
        None
        Performs meshing using custom context;.

        Parameters
        ----------
        theContext: IMeshTools_Context

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_IncrementalMesh_Perform(self, *args)

    @staticmethod
    def SetParallelDefault(*args) -> "void":
        r"""
        Setup multi-threading usage flag set by default in discret() static method (thus applied only to mesh factories).

        Parameters
        ----------
        isInParallel: bool

        Returns
        -------
        None

        """
        return _BRepMesh.BRepMesh_IncrementalMesh_SetParallelDefault(*args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepMesh_IncrementalMesh_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_IncrementalMesh

# Register BRepMesh_IncrementalMesh in _BRepMesh:
_BRepMesh.BRepMesh_IncrementalMesh_swigregister(BRepMesh_IncrementalMesh)

def BRepMesh_IncrementalMesh_Discret(*args) -> "Standard_Integer":
    r"""
    Plugin interface for the mesh factories. initializes meshing algorithm with the given parameters. @param theshape shape to be meshed. @param thelindeflection linear deflection. @param theangdeflection angular deflection. @param[out] thealgo pointer to initialized algorithm.

    Parameters
    ----------
    theShape: TopoDS_Shape
    theLinDeflection: float
    theAngDeflection: float
    theAlgo: BRepMesh_DiscretRoot *

    Returns
    -------
    int

    """
    return _BRepMesh.BRepMesh_IncrementalMesh_Discret(*args)

def BRepMesh_IncrementalMesh_IsParallelDefault(*args) -> "Standard_Boolean":
    r"""
    Returns multi-threading usage flag set by default in discret() static method (thus applied only to mesh factories).

    Returns
    -------
    bool

    """
    return _BRepMesh.BRepMesh_IncrementalMesh_IsParallelDefault(*args)

def BRepMesh_IncrementalMesh_SetParallelDefault(*args) -> "void":
    r"""
    Setup multi-threading usage flag set by default in discret() static method (thus applied only to mesh factories).

    Parameters
    ----------
    isInParallel: bool

    Returns
    -------
    None

    """
    return _BRepMesh.BRepMesh_IncrementalMesh_SetParallelDefault(*args)

class BRepMesh_DelaunayBaseMeshAlgo(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _BRepMesh.BRepMesh_DelaunayBaseMeshAlgo_swiginit(self, _BRepMesh.new_BRepMesh_DelaunayBaseMeshAlgo(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepMesh.delete_BRepMesh_DelaunayBaseMeshAlgo

# Register BRepMesh_DelaunayBaseMeshAlgo in _BRepMesh:
_BRepMesh.BRepMesh_DelaunayBaseMeshAlgo_swigregister(BRepMesh_DelaunayBaseMeshAlgo)


@classnotwrapped
class BRepMesh_WireInterferenceChecker:
	pass

@classnotwrapped
class BRepMesh_EdgeTessellator:
	pass

@classnotwrapped
class BRepMesh_EdgeTessellationExtractor:
	pass

@classnotwrapped
class BRepMesh_EdgeParameterProvider:
	pass

@classnotwrapped
class BRepMesh_FastDiscret:
	pass

@classnotwrapped
class BRepMesh_CustomDelaunayBaseMeshAlgo:
	pass

@classnotwrapped
class BRepMesh_NodeInsertionMeshAlgo:
	pass

@classnotwrapped
class BRepMesh_ConstrainedBaseMeshAlgo:
	pass

@classnotwrapped
class BRepMesh_CustomBaseMeshAlgo:
	pass

@classnotwrapped
class BRepMesh_DelaunayDeflectionControlMeshAlgo:
	pass

@classnotwrapped
class BRepMesh_DelaunayNodeInsertionMeshAlgo:
	pass






