from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *

#the following typedef cannot be wrapped as is
TColQuantity_Array2OfLength = NewType('TColQuantity_Array2OfLength', Any)

class TColQuantity_Array1OfLength:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Quantity_Length: ...
    def __setitem__(self, index: int, value: Quantity_Length) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Quantity_Length]: ...
    def next(self) -> Quantity_Length: ...
    __next__ = next
    def Init(self, theValue: Quantity_Length) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Quantity_Length: ...
    def Last(self) -> Quantity_Length: ...
    def Value(self, theIndex: int) -> Quantity_Length: ...
    def SetValue(self, theIndex: int, theValue: Quantity_Length) -> None: ...

# harray1 classes

class TColQuantity_HArray1OfLength(TColQuantity_Array1OfLength, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TColQuantity_Array1OfLength: ...

# harray2 classes

class TColQuantity_HArray2OfLength(TColQuantity_Array2OfLength, Standard_Transient):
    @overload
    def __init__(self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int) -> None: ...
    @overload
    def __init__(self, theOther: TColQuantity_Array2OfLength) -> None: ...
    def Array2(self) -> TColQuantity_Array2OfLength: ...

# hsequence classes

