# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
ProjLib module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_projlib.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ProjLib
else:
    import _ProjLib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ProjLib.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _ProjLib.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _ProjLib.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _ProjLib.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _ProjLib.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _ProjLib.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _ProjLib.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _ProjLib.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _ProjLib.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _ProjLib.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _ProjLib.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _ProjLib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _ProjLib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _ProjLib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _ProjLib.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _ProjLib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _ProjLib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _ProjLib:
_ProjLib.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _ProjLib.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColgp
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.AppParCurves
import OCC.Core.GeomAdaptor

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_ProjLib_HCompProjectedCurve_Create() -> "opencascade::handle< ProjLib_HCompProjectedCurve >":
    return _ProjLib.Handle_ProjLib_HCompProjectedCurve_Create()

def Handle_ProjLib_HCompProjectedCurve_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< ProjLib_HCompProjectedCurve >":
    return _ProjLib.Handle_ProjLib_HCompProjectedCurve_DownCast(t)

def Handle_ProjLib_HCompProjectedCurve_IsNull(t: "opencascade::handle< ProjLib_HCompProjectedCurve > const &") -> "bool":
    return _ProjLib.Handle_ProjLib_HCompProjectedCurve_IsNull(t)

def Handle_ProjLib_HProjectedCurve_Create() -> "opencascade::handle< ProjLib_HProjectedCurve >":
    return _ProjLib.Handle_ProjLib_HProjectedCurve_Create()

def Handle_ProjLib_HProjectedCurve_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< ProjLib_HProjectedCurve >":
    return _ProjLib.Handle_ProjLib_HProjectedCurve_DownCast(t)

def Handle_ProjLib_HProjectedCurve_IsNull(t: "opencascade::handle< ProjLib_HProjectedCurve > const &") -> "bool":
    return _ProjLib.Handle_ProjLib_HProjectedCurve_IsNull(t)

def Handle_ProjLib_HSequenceOfHSequenceOfPnt_Create() -> "opencascade::handle< ProjLib_HSequenceOfHSequenceOfPnt >":
    return _ProjLib.Handle_ProjLib_HSequenceOfHSequenceOfPnt_Create()

def Handle_ProjLib_HSequenceOfHSequenceOfPnt_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< ProjLib_HSequenceOfHSequenceOfPnt >":
    return _ProjLib.Handle_ProjLib_HSequenceOfHSequenceOfPnt_DownCast(t)

def Handle_ProjLib_HSequenceOfHSequenceOfPnt_IsNull(t: "opencascade::handle< ProjLib_HSequenceOfHSequenceOfPnt > const &") -> "bool":
    return _ProjLib.Handle_ProjLib_HSequenceOfHSequenceOfPnt_IsNull(t)
class ProjLib_SequenceOfHSequenceOfPnt(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Sequence< opencascade::handle< TColgp_HSequenceOfPnt > >::iterator":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_begin(self)

    def end(self) -> "NCollection_Sequence< opencascade::handle< TColgp_HSequenceOfPnt > >::iterator":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_end(self)

    def cbegin(self) -> "NCollection_Sequence< opencascade::handle< TColgp_HSequenceOfPnt > >::const_iterator":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_cbegin(self)

    def cend(self) -> "NCollection_Sequence< opencascade::handle< TColgp_HSequenceOfPnt > >::const_iterator":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_cend(self)

    def __init__(self, *args):
        _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_swiginit(self, _ProjLib.new_ProjLib_SequenceOfHSequenceOfPnt(*args))

    def Size(self) -> "Standard_Integer":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Size(self)

    def Length(self) -> "Standard_Integer":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Length(self)

    def Lower(self) -> "Standard_Integer":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Upper(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_IsEmpty(self)

    def Reverse(self) -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Reverse(self)

    def Exchange(self, I: "Standard_Integer const", J: "Standard_Integer const") -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_delNode(theNode, theAl)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Clear(self, theAllocator)

    def Assign(self, theOther: "ProjLib_SequenceOfHSequenceOfPnt") -> "NCollection_Sequence< opencascade::handle< TColgp_HSequenceOfPnt > > &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Assign(self, theOther)

    def Set(self, theOther: "ProjLib_SequenceOfHSequenceOfPnt") -> "NCollection_Sequence< opencascade::handle< TColgp_HSequenceOfPnt > > &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Set(self, theOther)

    def Remove(self, *args) -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Remove(self, *args)

    def Append(self, *args) -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Prepend(self, *args)

    def InsertBefore(self, *args) -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_InsertAfter(self, *args)

    def Split(self, theIndex: "Standard_Integer const", theSeq: "ProjLib_SequenceOfHSequenceOfPnt") -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Split(self, theIndex, theSeq)

    def First(self) -> "opencascade::handle< TColgp_HSequenceOfPnt > const &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_First(self)

    def ChangeFirst(self) -> "opencascade::handle< TColgp_HSequenceOfPnt > &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_ChangeFirst(self)

    def Last(self) -> "opencascade::handle< TColgp_HSequenceOfPnt > const &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Last(self)

    def ChangeLast(self) -> "opencascade::handle< TColgp_HSequenceOfPnt > &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "opencascade::handle< TColgp_HSequenceOfPnt > const &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "opencascade::handle< TColgp_HSequenceOfPnt > &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "opencascade::handle< TColgp_HSequenceOfPnt > &":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "opencascade::handle< TColgp_HSequenceOfPnt > const &") -> "void":
        return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _ProjLib.delete_ProjLib_SequenceOfHSequenceOfPnt

    def __len__(self):
        return self.Size()


# Register ProjLib_SequenceOfHSequenceOfPnt in _ProjLib:
_ProjLib.ProjLib_SequenceOfHSequenceOfPnt_swigregister(ProjLib_SequenceOfHSequenceOfPnt)

def ProjLib_SequenceOfHSequenceOfPnt_delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
    return _ProjLib.ProjLib_SequenceOfHSequenceOfPnt_delNode(theNode, theAl)

class projlib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def IsAnaSurf(*args) -> "Standard_Boolean":
        r"""
        Returns 'true' if surface is analytical, that is it can be plane, cylinder, cone, sphere, torus. for all other types of surface method returns 'false'.

        Parameters
        ----------
        theAS: Adaptor3d_HSurface

        Returns
        -------
        bool

        """
        return _ProjLib.projlib_IsAnaSurf(*args)

    @staticmethod
    def MakePCurveOfType(*args) -> "void":
        r"""
        Make empty p-curve <ac> of relevant to <pc> type.

        Parameters
        ----------
        PC: ProjLib_ProjectedCurve
        aC: Geom2d_Curve

        Returns
        -------
        None

        """
        return _ProjLib.projlib_MakePCurveOfType(*args)

    @staticmethod
    def Project(*args) -> "gp_Lin2d":
        r"""
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        P: gp_Pnt

        Returns
        -------
        gp_Pnt2d
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        L: gp_Lin

        Returns
        -------
        gp_Lin2d
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        C: gp_Circ

        Returns
        -------
        gp_Circ2d
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        E: gp_Elips

        Returns
        -------
        gp_Elips2d
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        P: gp_Parab

        Returns
        -------
        gp_Parab2d
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln
        H: gp_Hypr

        Returns
        -------
        gp_Hypr2d
        No available documentation.

        Parameters
        ----------
        Cy: gp_Cylinder
        P: gp_Pnt

        Returns
        -------
        gp_Pnt2d
        No available documentation.

        Parameters
        ----------
        Cy: gp_Cylinder
        L: gp_Lin

        Returns
        -------
        gp_Lin2d
        No available documentation.

        Parameters
        ----------
        Cy: gp_Cylinder
        Ci: gp_Circ

        Returns
        -------
        gp_Lin2d
        No available documentation.

        Parameters
        ----------
        Co: gp_Cone
        P: gp_Pnt

        Returns
        -------
        gp_Pnt2d
        No available documentation.

        Parameters
        ----------
        Co: gp_Cone
        L: gp_Lin

        Returns
        -------
        gp_Lin2d
        No available documentation.

        Parameters
        ----------
        Co: gp_Cone
        Ci: gp_Circ

        Returns
        -------
        gp_Lin2d
        No available documentation.

        Parameters
        ----------
        Sp: gp_Sphere
        P: gp_Pnt

        Returns
        -------
        gp_Pnt2d
        No available documentation.

        Parameters
        ----------
        Sp: gp_Sphere
        Ci: gp_Circ

        Returns
        -------
        gp_Lin2d
        No available documentation.

        Parameters
        ----------
        To: gp_Torus
        P: gp_Pnt

        Returns
        -------
        gp_Pnt2d
        No available documentation.

        Parameters
        ----------
        To: gp_Torus
        Ci: gp_Circ

        Returns
        -------
        gp_Lin2d

        """
        return _ProjLib.projlib_Project(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _ProjLib.projlib_swiginit(self, _ProjLib.new_projlib())
    __swig_destroy__ = _ProjLib.delete_projlib

# Register projlib in _ProjLib:
_ProjLib.projlib_swigregister(projlib)

def projlib_IsAnaSurf(*args) -> "Standard_Boolean":
    r"""
    Returns 'true' if surface is analytical, that is it can be plane, cylinder, cone, sphere, torus. for all other types of surface method returns 'false'.

    Parameters
    ----------
    theAS: Adaptor3d_HSurface

    Returns
    -------
    bool

    """
    return _ProjLib.projlib_IsAnaSurf(*args)

def projlib_MakePCurveOfType(*args) -> "void":
    r"""
    Make empty p-curve <ac> of relevant to <pc> type.

    Parameters
    ----------
    PC: ProjLib_ProjectedCurve
    aC: Geom2d_Curve

    Returns
    -------
    None

    """
    return _ProjLib.projlib_MakePCurveOfType(*args)

def projlib_Project(*args) -> "gp_Lin2d":
    r"""
    No available documentation.

    Parameters
    ----------
    Pl: gp_Pln
    P: gp_Pnt

    Returns
    -------
    gp_Pnt2d
    No available documentation.

    Parameters
    ----------
    Pl: gp_Pln
    L: gp_Lin

    Returns
    -------
    gp_Lin2d
    No available documentation.

    Parameters
    ----------
    Pl: gp_Pln
    C: gp_Circ

    Returns
    -------
    gp_Circ2d
    No available documentation.

    Parameters
    ----------
    Pl: gp_Pln
    E: gp_Elips

    Returns
    -------
    gp_Elips2d
    No available documentation.

    Parameters
    ----------
    Pl: gp_Pln
    P: gp_Parab

    Returns
    -------
    gp_Parab2d
    No available documentation.

    Parameters
    ----------
    Pl: gp_Pln
    H: gp_Hypr

    Returns
    -------
    gp_Hypr2d
    No available documentation.

    Parameters
    ----------
    Cy: gp_Cylinder
    P: gp_Pnt

    Returns
    -------
    gp_Pnt2d
    No available documentation.

    Parameters
    ----------
    Cy: gp_Cylinder
    L: gp_Lin

    Returns
    -------
    gp_Lin2d
    No available documentation.

    Parameters
    ----------
    Cy: gp_Cylinder
    Ci: gp_Circ

    Returns
    -------
    gp_Lin2d
    No available documentation.

    Parameters
    ----------
    Co: gp_Cone
    P: gp_Pnt

    Returns
    -------
    gp_Pnt2d
    No available documentation.

    Parameters
    ----------
    Co: gp_Cone
    L: gp_Lin

    Returns
    -------
    gp_Lin2d
    No available documentation.

    Parameters
    ----------
    Co: gp_Cone
    Ci: gp_Circ

    Returns
    -------
    gp_Lin2d
    No available documentation.

    Parameters
    ----------
    Sp: gp_Sphere
    P: gp_Pnt

    Returns
    -------
    gp_Pnt2d
    No available documentation.

    Parameters
    ----------
    Sp: gp_Sphere
    Ci: gp_Circ

    Returns
    -------
    gp_Lin2d
    No available documentation.

    Parameters
    ----------
    To: gp_Torus
    P: gp_Pnt

    Returns
    -------
    gp_Pnt2d
    No available documentation.

    Parameters
    ----------
    To: gp_Torus
    Ci: gp_Circ

    Returns
    -------
    gp_Lin2d

    """
    return _ProjLib.projlib_Project(*args)

class ProjLib_CompProjectedCurve(OCC.Core.Adaptor2d.Adaptor2d_Curve2d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        Try to find all solutions.

        Parameters
        ----------
        S: Adaptor3d_HSurface
        C: Adaptor3d_HCurve
        TolU: float
        TolV: float

        Returns
        -------
        None
        This constructor tries to optimize the search using the assumption that maximum distance between surface and curve less or equal then maxdist. if maxdist < 0 then algorithm works as above.

        Parameters
        ----------
        S: Adaptor3d_HSurface
        C: Adaptor3d_HCurve
        TolU: float
        TolV: float
        MaxDist: float

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_CompProjectedCurve_swiginit(self, _ProjLib.new_ProjLib_CompProjectedCurve(*args))

    def Bounds(self, *args) -> "void":
        r"""
        Returns the bounds of the continuous part corresponding to index.

        Parameters
        ----------
        Index: int

        Returns
        -------
        Udeb: float
        Ufin: float

        """
        return _ProjLib.ProjLib_CompProjectedCurve_Bounds(self, *args)

    def GetCurve(self, *args) -> "opencascade::handle< Adaptor3d_HCurve > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Adaptor3d_HCurve>

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetCurve(self, *args)

    def GetSequence(self, *args) -> "opencascade::handle< ProjLib_HSequenceOfHSequenceOfPnt > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<ProjLib_HSequenceOfHSequenceOfPnt>

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetSequence(self, *args)

    def GetSurface(self, *args) -> "opencascade::handle< Adaptor3d_HSurface > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Adaptor3d_HSurface>

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetSurface(self, *args)

    def GetTolerance(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------

        Returns
        -------
        TolU: float
        TolV: float

        """
        return _ProjLib.ProjLib_CompProjectedCurve_GetTolerance(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Computes a set of projected point and determine the continuous parts of the projected curves. the points corresponding to a projection on the bounds of the surface are included in this set of points.

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_CompProjectedCurve_Init(self, *args)

    def IsSinglePnt(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if part of projection with number index is a single point and writes its coordinates in p.

        Parameters
        ----------
        Index: int
        P: gp_Pnt2d

        Returns
        -------
        bool

        """
        return _ProjLib.ProjLib_CompProjectedCurve_IsSinglePnt(self, *args)

    def IsUIso(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if part of projection with number index is an u-isoparametric curve of input surface.

        Parameters
        ----------
        Index: int

        Returns
        -------
        U: float

        """
        return _ProjLib.ProjLib_CompProjectedCurve_IsUIso(self, *args)

    def IsVIso(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if part of projection with number index is an v-isoparametric curve of input surface.

        Parameters
        ----------
        Index: int

        Returns
        -------
        V: float

        """
        return _ProjLib.ProjLib_CompProjectedCurve_IsVIso(self, *args)

    def Load(self, *args) -> "void":
        r"""
        Changes the surface.

        Parameters
        ----------
        S: Adaptor3d_HSurface

        Returns
        -------
        None
        Changes the curve.

        Parameters
        ----------
        C: Adaptor3d_HCurve

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_CompProjectedCurve_Load(self, *args)

    def MaxDistance(self, *args) -> "Standard_Real":
        r"""
        Returns the maximum distance between curve to project and surface.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _ProjLib.ProjLib_CompProjectedCurve_MaxDistance(self, *args)

    def NbCurves(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of continuous part of the projected curve.

        Returns
        -------
        int

        """
        return _ProjLib.ProjLib_CompProjectedCurve_NbCurves(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_CompProjectedCurve

# Register ProjLib_CompProjectedCurve in _ProjLib:
_ProjLib.ProjLib_CompProjectedCurve_swigregister(ProjLib_CompProjectedCurve)

class ProjLib_ComputeApprox(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor, it only sets some initial values for class fields.

        Returns
        -------
        None
        <tol> is the tolerance with which the approximation is performed. other parameters for approximation have default values.

        Parameters
        ----------
        C: Adaptor3d_HCurve
        S: Adaptor3d_HSurface
        Tol: float

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_ComputeApprox_swiginit(self, _ProjLib.new_ProjLib_ComputeApprox(*args))

    def BSpline(self, *args) -> "opencascade::handle< Geom2d_BSplineCurve >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        """
        return _ProjLib.ProjLib_ComputeApprox_BSpline(self, *args)

    def Bezier(self, *args) -> "opencascade::handle< Geom2d_BezierCurve >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Geom2d_BezierCurve>

        """
        return _ProjLib.ProjLib_ComputeApprox_Bezier(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Performs projecting. in case of approximation current values of parameters are used: default values or set by corresponding methods set...

        Parameters
        ----------
        C: Adaptor3d_HCurve
        S: Adaptor3d_HSurface

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApprox_Perform(self, *args)

    def SetBndPnt(self, *args) -> "void":
        r"""
        Set the parameter, which defines type of boundary condition between segments during approximation. it can be appparcurves_passpoint or appparcurves_tangencypoint. default value is appparcurves_tangencypoint;.

        Parameters
        ----------
        theBndPnt: AppParCurves_Constraint

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApprox_SetBndPnt(self, *args)

    def SetDegree(self, *args) -> "void":
        r"""
        Set min and max possible degree of result bspline curve2d, which is got by approximation. if thedegmin/max < 0, algorithm uses values that are chosen depending of types curve 3d and surface.

        Parameters
        ----------
        theDegMin: int
        theDegMax: int

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApprox_SetDegree(self, *args)

    def SetMaxSegments(self, *args) -> "void":
        r"""
        Set the parameter, which defines maximal value of parametric intervals the projected curve can be cut for approximation. if themaxsegments < 0, algorithm uses default value = 1000.

        Parameters
        ----------
        theMaxSegments: int

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApprox_SetMaxSegments(self, *args)

    def SetTolerance(self, *args) -> "void":
        r"""
        Set tolerance of approximation. default value is precision::confusion().

        Parameters
        ----------
        theTolerance: float

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApprox_SetTolerance(self, *args)

    def Tolerance(self, *args) -> "Standard_Real":
        r"""
        Returns the reached tolerance.

        Returns
        -------
        float

        """
        return _ProjLib.ProjLib_ComputeApprox_Tolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_ComputeApprox

# Register ProjLib_ComputeApprox in _ProjLib:
_ProjLib.ProjLib_ComputeApprox_swigregister(ProjLib_ComputeApprox)

class ProjLib_ComputeApproxOnPolarSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor, it only sets some initial values for class fields.

        Returns
        -------
        None
        Constructor, which performs projecting.

        Parameters
        ----------
        C: Adaptor3d_HCurve
        S: Adaptor3d_HSurface
        Tol: float,optional
        	default value is 1.0e-4

        Returns
        -------
        None
        Constructor, which performs projecting, using initial curve 2d initcurve2d, which is any rough approximation of result curve. parameter tol is 3d tolerance of approximation.

        Parameters
        ----------
        InitCurve2d: Adaptor2d_HCurve2d
        C: Adaptor3d_HCurve
        S: Adaptor3d_HSurface
        Tol: float

        Returns
        -------
        None
        Constructor, which performs projecting, using two initial curves 2d: initcurve2d and initcurve2dbis that are any rough approximations of result curves. this constructor is used to get two pcurves for seem edge. parameter tol is 3d tolerance of approximation.

        Parameters
        ----------
        InitCurve2d: Adaptor2d_HCurve2d
        InitCurve2dBis: Adaptor2d_HCurve2d
        C: Adaptor3d_HCurve
        S: Adaptor3d_HSurface
        Tol: float

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_ComputeApproxOnPolarSurface_swiginit(self, _ProjLib.new_ProjLib_ComputeApproxOnPolarSurface(*args))

    def BSpline(self, *args) -> "opencascade::handle< Geom2d_BSplineCurve >":
        r"""
        Returns result curve 2d.

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_BSpline(self, *args)

    def BuildInitialCurve2d(self, *args) -> "opencascade::handle< Adaptor2d_HCurve2d >":
        r"""
        Builds initial 2d curve as bspline with degree = 1 using extrema algoritm. method is used in method perform(...).

        Parameters
        ----------
        Curve: Adaptor3d_HCurve
        S: Adaptor3d_HSurface

        Returns
        -------
        opencascade::handle<Adaptor2d_HCurve2d>

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_BuildInitialCurve2d(self, *args)

    def Curve2d(self, *args) -> "opencascade::handle< Geom2d_Curve >":
        r"""
        Returns second 2d curve.

        Returns
        -------
        opencascade::handle<Geom2d_Curve>

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_Curve2d(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_IsDone(self, *args)

    def Perform(self, *args) -> "opencascade::handle< Geom2d_BSplineCurve >":
        r"""
        Method, which performs projecting, using default values of parameters or they must be set by corresponding methods before using.

        Parameters
        ----------
        C: Adaptor3d_HCurve
        S: Adaptor3d_HSurface

        Returns
        -------
        None
        Method, which performs projecting, using default values of parameters or they must be set by corresponding methods before using. parameter initcurve2d is any rough estimation of 2d result curve.

        Parameters
        ----------
        InitCurve2d: Adaptor2d_HCurve2d
        C: Adaptor3d_HCurve
        S: Adaptor3d_HSurface

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_Perform(self, *args)

    def ProjectUsingInitialCurve2d(self, *args) -> "opencascade::handle< Geom2d_BSplineCurve >":
        r"""
        Method, which performs projecting. method is used in method perform(...).

        Parameters
        ----------
        Curve: Adaptor3d_HCurve
        S: Adaptor3d_HSurface
        InitCurve2d: Adaptor2d_HCurve2d

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_ProjectUsingInitialCurve2d(self, *args)

    def SetBndPnt(self, *args) -> "void":
        r"""
        Set the parameter, which defines type of boundary condition between segments during approximation. it can be appparcurves_passpoint or appparcurves_tangencypoint. default value is appparcurves_tangencypoint.

        Parameters
        ----------
        theBndPnt: AppParCurves_Constraint

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetBndPnt(self, *args)

    def SetDegree(self, *args) -> "void":
        r"""
        Set min and max possible degree of result bspline curve2d, which is got by approximation. if thedegmin/max < 0, algorithm uses values min = 2, max = 8.

        Parameters
        ----------
        theDegMin: int
        theDegMax: int

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetDegree(self, *args)

    def SetMaxDist(self, *args) -> "void":
        r"""
        Set the parameter, which defines maximal possible distance between projected curve and surface. it is used only for projecting on not analytical surfaces. if themaxdist < 0, algoritm uses default value 100.*tolerance. if real distance between curve and surface more then themaxdist, algorithm stops working.

        Parameters
        ----------
        theMaxDist: float

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetMaxDist(self, *args)

    def SetMaxSegments(self, *args) -> "void":
        r"""
        Set the parameter, which defines maximal value of parametric intervals the projected curve can be cut for approximation. if themaxsegments < 0, algorithm uses default value = 1000.

        Parameters
        ----------
        theMaxSegments: int

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetMaxSegments(self, *args)

    def SetTolerance(self, *args) -> "void":
        r"""
        Set the tolerance used to project the curve on the surface. default value is precision::approximation().

        Parameters
        ----------
        theTolerance: float

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_SetTolerance(self, *args)

    def Tolerance(self, *args) -> "Standard_Real":
        r"""
        Returns the reached tolerance.

        Returns
        -------
        float

        """
        return _ProjLib.ProjLib_ComputeApproxOnPolarSurface_Tolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_ComputeApproxOnPolarSurface

# Register ProjLib_ComputeApproxOnPolarSurface in _ProjLib:
_ProjLib.ProjLib_ComputeApproxOnPolarSurface_swigregister(ProjLib_ComputeApproxOnPolarSurface)

class ProjLib_HCompProjectedCurve(OCC.Core.Adaptor2d.Adaptor2d_HCurve2d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty genhcurve2d.

        Returns
        -------
        None
        Creates a genhcurve2d from a curve.

        Parameters
        ----------
        C: ProjLib_CompProjectedCurve

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_HCompProjectedCurve_swiginit(self, _ProjLib.new_ProjLib_HCompProjectedCurve(*args))

    def ChangeCurve2d(self, *args) -> "ProjLib_CompProjectedCurve &":
        r"""
        Returns the curve used to create the genhcurve.

        Returns
        -------
        ProjLib_CompProjectedCurve

        """
        return _ProjLib.ProjLib_HCompProjectedCurve_ChangeCurve2d(self, *args)

    def Set(self, *args) -> "void":
        r"""
        Sets the field of the genhcurve2d.

        Parameters
        ----------
        C: ProjLib_CompProjectedCurve

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_HCompProjectedCurve_Set(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ProjLib_HCompProjectedCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_HCompProjectedCurve

# Register ProjLib_HCompProjectedCurve in _ProjLib:
_ProjLib.ProjLib_HCompProjectedCurve_swigregister(ProjLib_HCompProjectedCurve)

class ProjLib_HProjectedCurve(OCC.Core.Adaptor2d.Adaptor2d_HCurve2d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty genhcurve2d.

        Returns
        -------
        None
        Creates a genhcurve2d from a curve.

        Parameters
        ----------
        C: ProjLib_ProjectedCurve

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_HProjectedCurve_swiginit(self, _ProjLib.new_ProjLib_HProjectedCurve(*args))

    def ChangeCurve2d(self, *args) -> "ProjLib_ProjectedCurve &":
        r"""
        Returns the curve used to create the genhcurve.

        Returns
        -------
        ProjLib_ProjectedCurve

        """
        return _ProjLib.ProjLib_HProjectedCurve_ChangeCurve2d(self, *args)

    def Set(self, *args) -> "void":
        r"""
        Sets the field of the genhcurve2d.

        Parameters
        ----------
        C: ProjLib_ProjectedCurve

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_HProjectedCurve_Set(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ProjLib_HProjectedCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_HProjectedCurve

# Register ProjLib_HProjectedCurve in _ProjLib:
_ProjLib.ProjLib_HProjectedCurve_swigregister(ProjLib_HProjectedCurve)

class ProjLib_PrjFunc(OCC.Core.math.math_FunctionSetWithDerivatives):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        C: Adaptor3d_CurvePtr
        FixVal: float
        S: Adaptor3d_SurfacePtr
        Fix: int

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_PrjFunc_swiginit(self, _ProjLib.new_ProjLib_PrjFunc(*args))

    def Solution(self, *args) -> "gp_Pnt2d":
        r"""
        Returns point on surface.

        Returns
        -------
        gp_Pnt2d

        """
        return _ProjLib.ProjLib_PrjFunc_Solution(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_PrjFunc

# Register ProjLib_PrjFunc in _ProjLib:
_ProjLib.ProjLib_PrjFunc_swigregister(ProjLib_PrjFunc)

class ProjLib_PrjResolve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        C: Adaptor3d_Curve
        S: Adaptor3d_Surface
        Fix: int

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_PrjResolve_swiginit(self, _ProjLib.new_ProjLib_PrjResolve(*args))

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the distance is found.

        Returns
        -------
        bool

        """
        return _ProjLib.ProjLib_PrjResolve_IsDone(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Calculates the ort from c(t) to s with a close point. the close point is defined by the parameter values u0 and v0. the function f(u,v)=distance(s(u,v),c(t)) has an extremum when gradient(f)=0. the algorithm searchs a zero near the close point.

        Parameters
        ----------
        t: float
        U: float
        V: float
        Tol: gp_Pnt2d
        Inf: gp_Pnt2d
        Sup: gp_Pnt2d
        FTol: float,optional
        	default value is -1
        StrictInside: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_PrjResolve_Perform(self, *args)

    def Solution(self, *args) -> "gp_Pnt2d":
        r"""
        Returns the point of the extremum distance.

        Returns
        -------
        gp_Pnt2d

        """
        return _ProjLib.ProjLib_PrjResolve_Solution(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_PrjResolve

# Register ProjLib_PrjResolve in _ProjLib:
_ProjLib.ProjLib_PrjResolve_swigregister(ProjLib_PrjResolve)

class ProjLib_ProjectOnPlane(OCC.Core.Adaptor3d.Adaptor3d_Curve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None
        The projection will be normal to the plane defined by the ax3 <pl>.

        Parameters
        ----------
        Pl: gp_Ax3

        Returns
        -------
        None
        The projection will be along the direction <d> on the plane defined by the ax3 <pl>. raises if the direction <d> is parallel to the plane <pl>.

        Parameters
        ----------
        Pl: gp_Ax3
        D: gp_Dir

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_ProjectOnPlane_swiginit(self, _ProjLib.new_ProjLib_ProjectOnPlane(*args))

    def GetCurve(self, *args) -> "opencascade::handle< Adaptor3d_HCurve > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Adaptor3d_HCurve>

        """
        return _ProjLib.ProjLib_ProjectOnPlane_GetCurve(self, *args)

    def GetDirection(self, *args) -> "gp_Dir const":
        r"""
        No available documentation.

        Returns
        -------
        gp_Dir

        """
        return _ProjLib.ProjLib_ProjectOnPlane_GetDirection(self, *args)

    def GetPlane(self, *args) -> "gp_Ax3 const":
        r"""
        No available documentation.

        Returns
        -------
        gp_Ax3

        """
        return _ProjLib.ProjLib_ProjectOnPlane_GetPlane(self, *args)

    def GetResult(self, *args) -> "opencascade::handle< GeomAdaptor_HCurve > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<GeomAdaptor_HCurve>

        """
        return _ProjLib.ProjLib_ProjectOnPlane_GetResult(self, *args)

    def Load(self, *args) -> "void":
        r"""
        Sets the curve and perform the projection. if <keepparametrization> is true, the parametrization of the projected curve <pc> will be the same as the parametrization of the initial curve <c>. it meens: proj(c(u)) = pc(u) for each u. otherwize, the parametrization may change.

        Parameters
        ----------
        C: Adaptor3d_HCurve
        Tolerance: float
        KeepParametrization: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ProjectOnPlane_Load(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_ProjectOnPlane

# Register ProjLib_ProjectOnPlane in _ProjLib:
_ProjLib.ProjLib_ProjectOnPlane_swigregister(ProjLib_ProjectOnPlane)

class ProjLib_ProjectOnSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Create an empty projector.

        Returns
        -------
        None
        Create a projector normaly to the surface <s>.

        Parameters
        ----------
        S: Adaptor3d_HSurface

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_ProjectOnSurface_swiginit(self, _ProjLib.new_ProjLib_ProjectOnSurface(*args))

    def BSpline(self, *args) -> "opencascade::handle< Geom_BSplineCurve >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Geom_BSplineCurve>

        """
        return _ProjLib.ProjLib_ProjectOnSurface_BSpline(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _ProjLib.ProjLib_ProjectOnSurface_IsDone(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Load(self):
    	pass

    __swig_destroy__ = _ProjLib.delete_ProjLib_ProjectOnSurface

# Register ProjLib_ProjectOnSurface in _ProjLib:
_ProjLib.ProjLib_ProjectOnSurface_swigregister(ProjLib_ProjectOnSurface)

class ProjLib_ProjectedCurve(OCC.Core.Adaptor2d.Adaptor2d_Curve2d):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor, it only sets some initial values for class fields.

        Returns
        -------
        None
        Constructor with initialisation field mysurface.

        Parameters
        ----------
        S: Adaptor3d_HSurface

        Returns
        -------
        None
        Constructor, which performs projecting. if projecting uses approximation, default parameters are used, in particular, 3d tolerance of approximation is precision::confusion().

        Parameters
        ----------
        S: Adaptor3d_HSurface
        C: Adaptor3d_HCurve

        Returns
        -------
        None
        Constructor, which performs projecting. if projecting uses approximation, 3d tolerance is tol, default parameters are used, .

        Parameters
        ----------
        S: Adaptor3d_HSurface
        C: Adaptor3d_HCurve
        Tol: float

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_ProjectedCurve_swiginit(self, _ProjLib.new_ProjLib_ProjectedCurve(*args))

    def GetCurve(self, *args) -> "opencascade::handle< Adaptor3d_HCurve > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Adaptor3d_HCurve>

        """
        return _ProjLib.ProjLib_ProjectedCurve_GetCurve(self, *args)

    def GetSurface(self, *args) -> "opencascade::handle< Adaptor3d_HSurface > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Adaptor3d_HSurface>

        """
        return _ProjLib.ProjLib_ProjectedCurve_GetSurface(self, *args)

    def GetTolerance(self, *args) -> "Standard_Real":
        r"""
        Returns the tolerance reached if an approximation is done.

        Returns
        -------
        float

        """
        return _ProjLib.ProjLib_ProjectedCurve_GetTolerance(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Performs projecting for given curve. if projecting uses approximation, approximation parameters can be set before by corresponding methods setdegree(...), setmaxsegmets(...), setbndpnt(...), setmaxdist(...).

        Parameters
        ----------
        C: Adaptor3d_HCurve

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ProjectedCurve_Perform(self, *args)

    def SetBndPnt(self, *args) -> "void":
        r"""
        Set the parameter, which defines type of boundary condition between segments during approximation. it can be appparcurves_passpoint or appparcurves_tangencypoint. default value is appparcurves_tangencypoint;.

        Parameters
        ----------
        theBndPnt: AppParCurves_Constraint

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ProjectedCurve_SetBndPnt(self, *args)

    def SetDegree(self, *args) -> "void":
        r"""
        Set min and max possible degree of result bspline curve2d, which is got by approximation. if thedegmin/max < 0, algorithm uses values that are chosen depending of types curve 3d and surface.

        Parameters
        ----------
        theDegMin: int
        theDegMax: int

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ProjectedCurve_SetDegree(self, *args)

    def SetMaxDist(self, *args) -> "void":
        r"""
        Set the parameter, which degines maximal possible distance between projected curve and surface. it uses only for projecting on not analytical surfaces. if themaxdist < 0, algoritm uses default value 100.*tolerance. if real distance between curve and surface more then themaxdist, algorithm stops working.

        Parameters
        ----------
        theMaxDist: float

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ProjectedCurve_SetMaxDist(self, *args)

    def SetMaxSegments(self, *args) -> "void":
        r"""
        Set the parameter, which defines maximal value of parametric intervals the projected curve can be cut for approximation. if themaxsegments < 0, algorithm uses default value = 1000.

        Parameters
        ----------
        theMaxSegments: int

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_ProjectedCurve_SetMaxSegments(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Load(self):
    	pass

    __swig_destroy__ = _ProjLib.delete_ProjLib_ProjectedCurve

# Register ProjLib_ProjectedCurve in _ProjLib:
_ProjLib.ProjLib_ProjectedCurve_swigregister(ProjLib_ProjectedCurve)

class ProjLib_Projector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Sets the type to othercurve.

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_Projector_swiginit(self, _ProjLib.new_ProjLib_Projector(*args))

    def BSpline(self, *args) -> "opencascade::handle< Geom2d_BSplineCurve >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        """
        return _ProjLib.ProjLib_Projector_BSpline(self, *args)

    def Bezier(self, *args) -> "opencascade::handle< Geom2d_BezierCurve >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Geom2d_BezierCurve>

        """
        return _ProjLib.ProjLib_Projector_Bezier(self, *args)

    def Circle(self, *args) -> "gp_Circ2d const":
        r"""
        No available documentation.

        Returns
        -------
        gp_Circ2d

        """
        return _ProjLib.ProjLib_Projector_Circle(self, *args)

    def Done(self, *args) -> "void":
        r"""
        Set isdone = standard_true;.

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Projector_Done(self, *args)

    def Ellipse(self, *args) -> "gp_Elips2d const":
        r"""
        No available documentation.

        Returns
        -------
        gp_Elips2d

        """
        return _ProjLib.ProjLib_Projector_Ellipse(self, *args)

    def GetType(self, *args) -> "GeomAbs_CurveType":
        r"""
        No available documentation.

        Returns
        -------
        GeomAbs_CurveType

        """
        return _ProjLib.ProjLib_Projector_GetType(self, *args)

    def Hyperbola(self, *args) -> "gp_Hypr2d const":
        r"""
        No available documentation.

        Returns
        -------
        gp_Hypr2d

        """
        return _ProjLib.ProjLib_Projector_Hyperbola(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _ProjLib.ProjLib_Projector_IsDone(self, *args)

    def IsPeriodic(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _ProjLib.ProjLib_Projector_IsPeriodic(self, *args)

    def Line(self, *args) -> "gp_Lin2d const":
        r"""
        No available documentation.

        Returns
        -------
        gp_Lin2d

        """
        return _ProjLib.ProjLib_Projector_Line(self, *args)

    def Parabola(self, *args) -> "gp_Parab2d const":
        r"""
        No available documentation.

        Returns
        -------
        gp_Parab2d

        """
        return _ProjLib.ProjLib_Projector_Parabola(self, *args)

    def Project(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Projector_Project(self, *args)

    def SetBSpline(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        C: Geom2d_BSplineCurve

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Projector_SetBSpline(self, *args)

    def SetBezier(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        C: Geom2d_BezierCurve

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Projector_SetBezier(self, *args)

    def SetPeriodic(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Projector_SetPeriodic(self, *args)

    def SetType(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Type: GeomAbs_CurveType

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Projector_SetType(self, *args)

    def UFrame(self, *args) -> "void":
        r"""
        Translates the 2d curve to set the part of the curve [cfirst, clast] in the range [ ufirst, ufirst + period [.

        Parameters
        ----------
        CFirst: float
        CLast: float
        UFirst: float
        Period: float

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Projector_UFrame(self, *args)

    def VFrame(self, *args) -> "void":
        r"""
        Translates the 2d curve to set the part of the curve [cfirst, clast] in the range [ vfirst, vfirst + period [.

        Parameters
        ----------
        CFirst: float
        CLast: float
        VFirst: float
        Period: float

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Projector_VFrame(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Projector

# Register ProjLib_Projector in _ProjLib:
_ProjLib.ProjLib_Projector_swigregister(ProjLib_Projector)

class ProjLib_Cone(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Undefined projection.

        Returns
        -------
        None
        Projection on the cone <co>.

        Parameters
        ----------
        Co: gp_Cone

        Returns
        -------
        None
        Projection of the line <l> on the cone <co>.

        Parameters
        ----------
        Co: gp_Cone
        L: gp_Lin

        Returns
        -------
        None
        Projection of the circle <c> on the cone <co>.

        Parameters
        ----------
        Co: gp_Cone
        C: gp_Circ

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_Cone_swiginit(self, _ProjLib.new_ProjLib_Cone(*args))

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Co: gp_Cone

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Cone_Init(self, *args)

    def Project(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Cone_Project(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Cone

# Register ProjLib_Cone in _ProjLib:
_ProjLib.ProjLib_Cone_swigregister(ProjLib_Cone)

class ProjLib_Cylinder(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Undefined projection.

        Returns
        -------
        None
        Projection on the cylinder <cyl>.

        Parameters
        ----------
        Cyl: gp_Cylinder

        Returns
        -------
        None
        Projection of the line <l> on the cylinder <cyl>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        L: gp_Lin

        Returns
        -------
        None
        Projection of the circle <c> on the cylinder <cyl>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        C: gp_Circ

        Returns
        -------
        None
        Projection of the ellipse <e> on the cylinder <cyl>.

        Parameters
        ----------
        Cyl: gp_Cylinder
        E: gp_Elips

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_Cylinder_swiginit(self, _ProjLib.new_ProjLib_Cylinder(*args))

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Cyl: gp_Cylinder

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Cylinder_Init(self, *args)

    def Project(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Cylinder_Project(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Cylinder

# Register ProjLib_Cylinder in _ProjLib:
_ProjLib.ProjLib_Cylinder_swigregister(ProjLib_Cylinder)

class ProjLib_Plane(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Undefined projection.

        Returns
        -------
        None
        Projection on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln

        Returns
        -------
        None
        Projection of the line <l> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        L: gp_Lin

        Returns
        -------
        None
        Projection of the circle <c> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        C: gp_Circ

        Returns
        -------
        None
        Projection of the ellipse <e> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        E: gp_Elips

        Returns
        -------
        None
        Projection of the parabola <p> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        P: gp_Parab

        Returns
        -------
        None
        Projection of the hyperbola <h> on the plane <pl>.

        Parameters
        ----------
        Pl: gp_Pln
        H: gp_Hypr

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_Plane_swiginit(self, _ProjLib.new_ProjLib_Plane(*args))

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Pl: gp_Pln

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Plane_Init(self, *args)

    def Project(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Plane_Project(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Plane

# Register ProjLib_Plane in _ProjLib:
_ProjLib.ProjLib_Plane_swigregister(ProjLib_Plane)

class ProjLib_Sphere(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Undefined projection.

        Returns
        -------
        None
        Projection on the sphere <sp>.

        Parameters
        ----------
        Sp: gp_Sphere

        Returns
        -------
        None
        Projection of the circle <c> on the sphere <sp>.

        Parameters
        ----------
        Sp: gp_Sphere
        C: gp_Circ

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_Sphere_swiginit(self, _ProjLib.new_ProjLib_Sphere(*args))

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Sp: gp_Sphere

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Sphere_Init(self, *args)

    def Project(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Sphere_Project(self, *args)

    def SetInBounds(self, *args) -> "void":
        r"""
        Set the point of parameter u on c in the natural restrictions of the sphere.

        Parameters
        ----------
        U: float

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Sphere_SetInBounds(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Sphere

# Register ProjLib_Sphere in _ProjLib:
_ProjLib.ProjLib_Sphere_swigregister(ProjLib_Sphere)

class ProjLib_Torus(ProjLib_Projector):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Undefined projection.

        Returns
        -------
        None
        Projection on the torus <to>.

        Parameters
        ----------
        To: gp_Torus

        Returns
        -------
        None
        Projection of the circle <c> on the torus <to>.

        Parameters
        ----------
        To: gp_Torus
        C: gp_Circ

        Returns
        -------
        None

        """
        _ProjLib.ProjLib_Torus_swiginit(self, _ProjLib.new_ProjLib_Torus(*args))

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        To: gp_Torus

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Torus_Init(self, *args)

    def Project(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: gp_Circ

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        E: gp_Elips

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P: gp_Parab

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        H: gp_Hypr

        Returns
        -------
        None

        """
        return _ProjLib.ProjLib_Torus_Project(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ProjLib.delete_ProjLib_Torus

# Register ProjLib_Torus in _ProjLib:
_ProjLib.ProjLib_Torus_swigregister(ProjLib_Torus)

class ProjLib_HSequenceOfHSequenceOfPnt(ProjLib_SequenceOfHSequenceOfPnt, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_swiginit(self, _ProjLib.new_ProjLib_HSequenceOfHSequenceOfPnt(*args))

    def Sequence(self) -> "ProjLib_SequenceOfHSequenceOfPnt const &":
        return _ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_Sequence(self)

    def Append(self, *args) -> "void":
        return _ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_Append(self, *args)

    def ChangeSequence(self) -> "ProjLib_SequenceOfHSequenceOfPnt &":
        return _ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_ChangeSequence(self)


    @staticmethod
    def DownCast(t):
      return Handle_ProjLib_HSequenceOfHSequenceOfPnt_DownCast(t)

    __swig_destroy__ = _ProjLib.delete_ProjLib_HSequenceOfHSequenceOfPnt

# Register ProjLib_HSequenceOfHSequenceOfPnt in _ProjLib:
_ProjLib.ProjLib_HSequenceOfHSequenceOfPnt_swigregister(ProjLib_HSequenceOfHSequenceOfPnt)





