from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *
from OCC.Core.GeomAbs import *
from OCC.Core.TColgp import *
from OCC.Core.TColStd import *


class Geom2d_Geometry(Standard_Transient):
	def Copy(self) -> Geom2d_Geometry: ...
	@overload
	def Mirror(self, P: gp_Pnt2d) -> None: ...
	@overload
	def Mirror(self, A: gp_Ax2d) -> None: ...
	@overload
	def Mirrored(self, P: gp_Pnt2d) -> Geom2d_Geometry: ...
	@overload
	def Mirrored(self, A: gp_Ax2d) -> Geom2d_Geometry: ...
	def Rotate(self, P: gp_Pnt2d, Ang: float) -> None: ...
	def Rotated(self, P: gp_Pnt2d, Ang: float) -> Geom2d_Geometry: ...
	def Scale(self, P: gp_Pnt2d, S: float) -> None: ...
	def Scaled(self, P: gp_Pnt2d, S: float) -> Geom2d_Geometry: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...
	def Transformed(self, T: gp_Trsf2d) -> Geom2d_Geometry: ...
	@overload
	def Translate(self, V: gp_Vec2d) -> None: ...
	@overload
	def Translate(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
	@overload
	def Translated(self, V: gp_Vec2d) -> Geom2d_Geometry: ...
	@overload
	def Translated(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> Geom2d_Geometry: ...

class Geom2d_Transformation(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, T: gp_Trsf2d) -> None: ...
	def Copy(self) -> Geom2d_Transformation: ...
	def Form(self) -> gp_TrsfForm: ...
	def Invert(self) -> None: ...
	def Inverted(self) -> Geom2d_Transformation: ...
	def IsNegative(self) -> bool: ...
	def Multiplied(self, Other: Geom2d_Transformation) -> Geom2d_Transformation: ...
	def Multiply(self, Other: Geom2d_Transformation) -> None: ...
	def Power(self, N: int) -> None: ...
	def Powered(self, N: int) -> Geom2d_Transformation: ...
	def PreMultiply(self, Other: Geom2d_Transformation) -> None: ...
	def ScaleFactor(self) -> float: ...
	@overload
	def SetMirror(self, P: gp_Pnt2d) -> None: ...
	@overload
	def SetMirror(self, A: gp_Ax2d) -> None: ...
	def SetRotation(self, P: gp_Pnt2d, Ang: float) -> None: ...
	def SetScale(self, P: gp_Pnt2d, S: float) -> None: ...
	@overload
	def SetTransformation(self, FromSystem1: gp_Ax2d, ToSystem2: gp_Ax2d) -> None: ...
	@overload
	def SetTransformation(self, ToSystem: gp_Ax2d) -> None: ...
	@overload
	def SetTranslation(self, V: gp_Vec2d) -> None: ...
	@overload
	def SetTranslation(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
	def SetTrsf2d(self, T: gp_Trsf2d) -> None: ...
	def Transforms(self) -> Tuple[float, float]: ...
	def Trsf2d(self) -> gp_Trsf2d: ...
	def Value(self, Row: int, Col: int) -> float: ...

class Geom2d_AxisPlacement(Geom2d_Geometry):
	@overload
	def __init__(self, A: gp_Ax2d) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt2d, V: gp_Dir2d) -> None: ...
	def Angle(self, Other: Geom2d_AxisPlacement) -> float: ...
	def Ax2d(self) -> gp_Ax2d: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def Direction(self) -> gp_Dir2d: ...
	def Location(self) -> gp_Pnt2d: ...
	def Reverse(self) -> None: ...
	def Reversed(self) -> Geom2d_AxisPlacement: ...
	def SetAxis(self, A: gp_Ax2d) -> None: ...
	def SetDirection(self, V: gp_Dir2d) -> None: ...
	def SetLocation(self, P: gp_Pnt2d) -> None: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...

class Geom2d_Curve(Geom2d_Geometry):
	def Continuity(self) -> GeomAbs_Shape: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def FirstParameter(self) -> float: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def ParametricTransformation(self, T: gp_Trsf2d) -> float: ...
	def Period(self) -> float: ...
	def Reverse(self) -> None: ...
	def Reversed(self) -> Geom2d_Curve: ...
	def ReversedParameter(self, U: float) -> float: ...
	def TransformedParameter(self, U: float, T: gp_Trsf2d) -> float: ...
	def Value(self, U: float) -> gp_Pnt2d: ...

class Geom2d_Point(Geom2d_Geometry):
	def Coord(self) -> Tuple[float, float]: ...
	def Distance(self, Other: Geom2d_Point) -> float: ...
	def Pnt2d(self) -> gp_Pnt2d: ...
	def SquareDistance(self, Other: Geom2d_Point) -> float: ...
	def X(self) -> float: ...
	def Y(self) -> float: ...

class Geom2d_Vector(Geom2d_Geometry):
	def Angle(self, Other: Geom2d_Vector) -> float: ...
	def Coord(self) -> Tuple[float, float]: ...
	def Crossed(self, Other: Geom2d_Vector) -> float: ...
	def Dot(self, Other: Geom2d_Vector) -> float: ...
	def Magnitude(self) -> float: ...
	def Reverse(self) -> None: ...
	def Reversed(self) -> Geom2d_Vector: ...
	def SquareMagnitude(self) -> float: ...
	def Vec2d(self) -> gp_Vec2d: ...
	def X(self) -> float: ...
	def Y(self) -> float: ...

class Geom2d_BoundedCurve(Geom2d_Curve):
	def EndPoint(self) -> gp_Pnt2d: ...
	def StartPoint(self) -> gp_Pnt2d: ...

class Geom2d_CartesianPoint(Geom2d_Point):
	@overload
	def __init__(self, P: gp_Pnt2d) -> None: ...
	@overload
	def __init__(self, X: float, Y: float) -> None: ...
	def Coord(self) -> Tuple[float, float]: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def Pnt2d(self) -> gp_Pnt2d: ...
	def SetCoord(self, X: float, Y: float) -> None: ...
	def SetPnt2d(self, P: gp_Pnt2d) -> None: ...
	def SetX(self, X: float) -> None: ...
	def SetY(self, Y: float) -> None: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...
	def X(self) -> float: ...
	def Y(self) -> float: ...

class Geom2d_Conic(Geom2d_Curve):
	def Continuity(self) -> GeomAbs_Shape: ...
	def Eccentricity(self) -> float: ...
	def IsCN(self, N: int) -> bool: ...
	def Location(self) -> gp_Pnt2d: ...
	def Position(self) -> gp_Ax22d: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetAxis(self, A: gp_Ax22d) -> None: ...
	def SetLocation(self, P: gp_Pnt2d) -> None: ...
	def SetXAxis(self, A: gp_Ax2d) -> None: ...
	def SetYAxis(self, A: gp_Ax2d) -> None: ...
	def XAxis(self) -> gp_Ax2d: ...
	def YAxis(self) -> gp_Ax2d: ...

class Geom2d_Direction(Geom2d_Vector):
	@overload
	def __init__(self, X: float, Y: float) -> None: ...
	@overload
	def __init__(self, V: gp_Dir2d) -> None: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def Crossed(self, Other: Geom2d_Vector) -> float: ...
	def Dir2d(self) -> gp_Dir2d: ...
	def Magnitude(self) -> float: ...
	def SetCoord(self, X: float, Y: float) -> None: ...
	def SetDir2d(self, V: gp_Dir2d) -> None: ...
	def SetX(self, X: float) -> None: ...
	def SetY(self, Y: float) -> None: ...
	def SquareMagnitude(self) -> float: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...

class Geom2d_Line(Geom2d_Curve):
	@overload
	def __init__(self, A: gp_Ax2d) -> None: ...
	@overload
	def __init__(self, L: gp_Lin2d) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt2d, V: gp_Dir2d) -> None: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def Direction(self) -> gp_Dir2d: ...
	def Distance(self, P: gp_Pnt2d) -> float: ...
	def FirstParameter(self) -> float: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def Lin2d(self) -> gp_Lin2d: ...
	def Location(self) -> gp_Pnt2d: ...
	def ParametricTransformation(self, T: gp_Trsf2d) -> float: ...
	def Position(self) -> gp_Ax2d: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetDirection(self, V: gp_Dir2d) -> None: ...
	def SetLin2d(self, L: gp_Lin2d) -> None: ...
	def SetLocation(self, P: gp_Pnt2d) -> None: ...
	def SetPosition(self, A: gp_Ax2d) -> None: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...
	def TransformedParameter(self, U: float, T: gp_Trsf2d) -> float: ...

class Geom2d_OffsetCurve(Geom2d_Curve):
	def __init__(self, C: Geom2d_Curve, Offset: float, isNotCheckC0: Optional[bool] = False) -> None: ...
	def BasisCurve(self) -> Geom2d_Curve: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def FirstParameter(self) -> float: ...
	def GetBasisCurveContinuity(self) -> GeomAbs_Shape: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def Offset(self) -> float: ...
	def ParametricTransformation(self, T: gp_Trsf2d) -> float: ...
	def Period(self) -> float: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetBasisCurve(self, C: Geom2d_Curve, isNotCheckC0: Optional[bool] = False) -> None: ...
	def SetOffsetValue(self, D: float) -> None: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...
	def TransformedParameter(self, U: float, T: gp_Trsf2d) -> float: ...

class Geom2d_VectorWithMagnitude(Geom2d_Vector):
	@overload
	def __init__(self, V: gp_Vec2d) -> None: ...
	@overload
	def __init__(self, X: float, Y: float) -> None: ...
	@overload
	def __init__(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
	def Add(self, Other: Geom2d_Vector) -> None: ...
	def Added(self, Other: Geom2d_Vector) -> Geom2d_VectorWithMagnitude: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def Crossed(self, Other: Geom2d_Vector) -> float: ...
	def Divide(self, Scalar: float) -> None: ...
	def Divided(self, Scalar: float) -> Geom2d_VectorWithMagnitude: ...
	def Magnitude(self) -> float: ...
	def Multiplied(self, Scalar: float) -> Geom2d_VectorWithMagnitude: ...
	def Multiply(self, Scalar: float) -> None: ...
	def Normalize(self) -> None: ...
	def Normalized(self) -> Geom2d_VectorWithMagnitude: ...
	def SetCoord(self, X: float, Y: float) -> None: ...
	def SetVec2d(self, V: gp_Vec2d) -> None: ...
	def SetX(self, X: float) -> None: ...
	def SetY(self, Y: float) -> None: ...
	def SquareMagnitude(self) -> float: ...
	def Subtract(self, Other: Geom2d_Vector) -> None: ...
	def Subtracted(self, Other: Geom2d_Vector) -> Geom2d_VectorWithMagnitude: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...

class Geom2d_BSplineCurve(Geom2d_BoundedCurve):
	@overload
	def __init__(self, Poles: TColgp_Array1OfPnt2d, Knots: TColStd_Array1OfReal, Multiplicities: TColStd_Array1OfInteger, Degree: int, Periodic: Optional[bool] = False) -> None: ...
	@overload
	def __init__(self, Poles: TColgp_Array1OfPnt2d, Weights: TColStd_Array1OfReal, Knots: TColStd_Array1OfReal, Multiplicities: TColStd_Array1OfInteger, Degree: int, Periodic: Optional[bool] = False) -> None: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def Degree(self) -> int: ...
	def EndPoint(self) -> gp_Pnt2d: ...
	def FirstParameter(self) -> float: ...
	def FirstUKnotIndex(self) -> int: ...
	def IncreaseDegree(self, Degree: int) -> None: ...
	@overload
	def IncreaseMultiplicity(self, Index: int, M: int) -> None: ...
	@overload
	def IncreaseMultiplicity(self, I1: int, I2: int, M: int) -> None: ...
	def IncrementMultiplicity(self, I1: int, I2: int, M: int) -> None: ...
	def InsertKnot(self, U: float, M: Optional[int] = 1, ParametricTolerance: Optional[float] = 0.0) -> None: ...
	def InsertKnots(self, Knots: TColStd_Array1OfReal, Mults: TColStd_Array1OfInteger, ParametricTolerance: Optional[float] = 0.0, Add: Optional[bool] = False) -> None: ...
	def InsertPoleAfter(self, Index: int, P: gp_Pnt2d, Weight: Optional[float] = 1.0) -> None: ...
	def InsertPoleBefore(self, Index: int, P: gp_Pnt2d, Weight: Optional[float] = 1.0) -> None: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsG1(self, theTf: float, theTl: float, theAngTol: float) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def IsRational(self) -> bool: ...
	def Knot(self, Index: int) -> float: ...
	def KnotDistribution(self) -> GeomAbs_BSplKnotDistribution: ...
	@overload
	def KnotSequence(self, K: TColStd_Array1OfReal) -> None: ...
	@overload
	def KnotSequence(self) -> TColStd_Array1OfReal: ...
	@overload
	def Knots(self, K: TColStd_Array1OfReal) -> None: ...
	@overload
	def Knots(self) -> TColStd_Array1OfReal: ...
	def LastParameter(self) -> float: ...
	def LastUKnotIndex(self) -> int: ...
	def LocalD0(self, U: float, FromK1: int, ToK2: int, P: gp_Pnt2d) -> None: ...
	def LocalD1(self, U: float, FromK1: int, ToK2: int, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def LocalD2(self, U: float, FromK1: int, ToK2: int, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def LocalD3(self, U: float, FromK1: int, ToK2: int, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def LocalDN(self, U: float, FromK1: int, ToK2: int, N: int) -> gp_Vec2d: ...
	def LocalValue(self, U: float, FromK1: int, ToK2: int) -> gp_Pnt2d: ...
	def LocateU(self, U: float, ParametricTolerance: float, WithKnotRepetition: Optional[bool] = False) -> Tuple[int, int]: ...
	@staticmethod
	def MaxDegree() -> int: ...
	def MovePoint(self, U: float, P: gp_Pnt2d, Index1: int, Index2: int) -> Tuple[int, int]: ...
	def MovePointAndTangent(self, U: float, P: gp_Pnt2d, Tangent: gp_Vec2d, Tolerance: float, StartingCondition: int, EndingCondition: int) -> int: ...
	@overload
	def Multiplicities(self, M: TColStd_Array1OfInteger) -> None: ...
	@overload
	def Multiplicities(self) -> TColStd_Array1OfInteger: ...
	def Multiplicity(self, Index: int) -> int: ...
	def NbKnots(self) -> int: ...
	def NbPoles(self) -> int: ...
	def PeriodicNormalization(self) -> float: ...
	def Pole(self, Index: int) -> gp_Pnt2d: ...
	@overload
	def Poles(self, P: TColgp_Array1OfPnt2d) -> None: ...
	@overload
	def Poles(self) -> TColgp_Array1OfPnt2d: ...
	def RemoveKnot(self, Index: int, M: int, Tolerance: float) -> bool: ...
	def RemovePole(self, Index: int) -> None: ...
	def Resolution(self, ToleranceUV: float) -> float: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def Segment(self, U1: float, U2: float, theTolerance: Optional[float] = precision_PConfusion()) -> None: ...
	@overload
	def SetKnot(self, Index: int, K: float) -> None: ...
	@overload
	def SetKnot(self, Index: int, K: float, M: int) -> None: ...
	def SetKnots(self, K: TColStd_Array1OfReal) -> None: ...
	def SetNotPeriodic(self) -> None: ...
	def SetOrigin(self, Index: int) -> None: ...
	def SetPeriodic(self) -> None: ...
	@overload
	def SetPole(self, Index: int, P: gp_Pnt2d) -> None: ...
	@overload
	def SetPole(self, Index: int, P: gp_Pnt2d, Weight: float) -> None: ...
	def SetWeight(self, Index: int, Weight: float) -> None: ...
	def StartPoint(self) -> gp_Pnt2d: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...
	def Weight(self, Index: int) -> float: ...
	@overload
	def Weights(self, W: TColStd_Array1OfReal) -> None: ...
	@overload
	def Weights(self) -> TColStd_Array1OfReal: ...

class Geom2d_BezierCurve(Geom2d_BoundedCurve):
	@overload
	def __init__(self, CurvePoles: TColgp_Array1OfPnt2d) -> None: ...
	@overload
	def __init__(self, CurvePoles: TColgp_Array1OfPnt2d, PoleWeights: TColStd_Array1OfReal) -> None: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def Degree(self) -> int: ...
	def EndPoint(self) -> gp_Pnt2d: ...
	def FirstParameter(self) -> float: ...
	def Increase(self, Degree: int) -> None: ...
	def InsertPoleAfter(self, Index: int, P: gp_Pnt2d, Weight: Optional[float] = 1.0) -> None: ...
	def InsertPoleBefore(self, Index: int, P: gp_Pnt2d, Weight: Optional[float] = 1.0) -> None: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def IsRational(self) -> bool: ...
	def LastParameter(self) -> float: ...
	@staticmethod
	def MaxDegree() -> int: ...
	def NbPoles(self) -> int: ...
	def Pole(self, Index: int) -> gp_Pnt2d: ...
	@overload
	def Poles(self, P: TColgp_Array1OfPnt2d) -> None: ...
	@overload
	def Poles(self) -> TColgp_Array1OfPnt2d: ...
	def RemovePole(self, Index: int) -> None: ...
	def Resolution(self, ToleranceUV: float) -> float: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def Segment(self, U1: float, U2: float) -> None: ...
	@overload
	def SetPole(self, Index: int, P: gp_Pnt2d) -> None: ...
	@overload
	def SetPole(self, Index: int, P: gp_Pnt2d, Weight: float) -> None: ...
	def SetWeight(self, Index: int, Weight: float) -> None: ...
	def StartPoint(self) -> gp_Pnt2d: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...
	def Weight(self, Index: int) -> float: ...
	@overload
	def Weights(self, W: TColStd_Array1OfReal) -> None: ...
	@overload
	def Weights(self) -> TColStd_Array1OfReal: ...

class Geom2d_Circle(Geom2d_Conic):
	@overload
	def __init__(self, C: gp_Circ2d) -> None: ...
	@overload
	def __init__(self, A: gp_Ax2d, Radius: float, Sense: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, A: gp_Ax22d, Radius: float) -> None: ...
	def Circ2d(self) -> gp_Circ2d: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def Eccentricity(self) -> float: ...
	def FirstParameter(self) -> float: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def Radius(self) -> float: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetCirc2d(self, C: gp_Circ2d) -> None: ...
	def SetRadius(self, R: float) -> None: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...

class Geom2d_Ellipse(Geom2d_Conic):
	@overload
	def __init__(self, E: gp_Elips2d) -> None: ...
	@overload
	def __init__(self, MajorAxis: gp_Ax2d, MajorRadius: float, MinorRadius: float, Sense: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, Axis: gp_Ax22d, MajorRadius: float, MinorRadius: float) -> None: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def Directrix1(self) -> gp_Ax2d: ...
	def Directrix2(self) -> gp_Ax2d: ...
	def Eccentricity(self) -> float: ...
	def Elips2d(self) -> gp_Elips2d: ...
	def FirstParameter(self) -> float: ...
	def Focal(self) -> float: ...
	def Focus1(self) -> gp_Pnt2d: ...
	def Focus2(self) -> gp_Pnt2d: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def MajorRadius(self) -> float: ...
	def MinorRadius(self) -> float: ...
	def Parameter(self) -> float: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetElips2d(self, E: gp_Elips2d) -> None: ...
	def SetMajorRadius(self, MajorRadius: float) -> None: ...
	def SetMinorRadius(self, MinorRadius: float) -> None: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...

class Geom2d_Hyperbola(Geom2d_Conic):
	@overload
	def __init__(self, H: gp_Hypr2d) -> None: ...
	@overload
	def __init__(self, MajorAxis: gp_Ax2d, MajorRadius: float, MinorRadius: float, Sense: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, Axis: gp_Ax22d, MajorRadius: float, MinorRadius: float) -> None: ...
	def Asymptote1(self) -> gp_Ax2d: ...
	def Asymptote2(self) -> gp_Ax2d: ...
	def ConjugateBranch1(self) -> gp_Hypr2d: ...
	def ConjugateBranch2(self) -> gp_Hypr2d: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def Directrix1(self) -> gp_Ax2d: ...
	def Directrix2(self) -> gp_Ax2d: ...
	def Eccentricity(self) -> float: ...
	def FirstParameter(self) -> float: ...
	def Focal(self) -> float: ...
	def Focus1(self) -> gp_Pnt2d: ...
	def Focus2(self) -> gp_Pnt2d: ...
	def Hypr2d(self) -> gp_Hypr2d: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def MajorRadius(self) -> float: ...
	def MinorRadius(self) -> float: ...
	def OtherBranch(self) -> gp_Hypr2d: ...
	def Parameter(self) -> float: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetHypr2d(self, H: gp_Hypr2d) -> None: ...
	def SetMajorRadius(self, MajorRadius: float) -> None: ...
	def SetMinorRadius(self, MinorRadius: float) -> None: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...

class Geom2d_Parabola(Geom2d_Conic):
	@overload
	def __init__(self, Prb: gp_Parab2d) -> None: ...
	@overload
	def __init__(self, MirrorAxis: gp_Ax2d, Focal: float, Sense: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, Axis: gp_Ax22d, Focal: float) -> None: ...
	@overload
	def __init__(self, D: gp_Ax2d, F: gp_Pnt2d) -> None: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def Directrix(self) -> gp_Ax2d: ...
	def Eccentricity(self) -> float: ...
	def FirstParameter(self) -> float: ...
	def Focal(self) -> float: ...
	def Focus(self) -> gp_Pnt2d: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def Parab2d(self) -> gp_Parab2d: ...
	def Parameter(self) -> float: ...
	def ParametricTransformation(self, T: gp_Trsf2d) -> float: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetFocal(self, Focal: float) -> None: ...
	def SetParab2d(self, Prb: gp_Parab2d) -> None: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...
	def TransformedParameter(self, U: float, T: gp_Trsf2d) -> float: ...

class Geom2d_TrimmedCurve(Geom2d_BoundedCurve):
	def __init__(self, C: Geom2d_Curve, U1: float, U2: float, Sense: Optional[bool] = True, theAdjustPeriodic: Optional[bool] = True) -> None: ...
	def BasisCurve(self) -> Geom2d_Curve: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	def Copy(self) -> Geom2d_Geometry: ...
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	def D1(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def EndPoint(self) -> gp_Pnt2d: ...
	def FirstParameter(self) -> float: ...
	def IsCN(self, N: int) -> bool: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def LastParameter(self) -> float: ...
	def ParametricTransformation(self, T: gp_Trsf2d) -> float: ...
	def Period(self) -> float: ...
	def Reverse(self) -> None: ...
	def ReversedParameter(self, U: float) -> float: ...
	def SetTrim(self, U1: float, U2: float, Sense: Optional[bool] = True, theAdjustPeriodic: Optional[bool] = True) -> None: ...
	def StartPoint(self) -> gp_Pnt2d: ...
	def Transform(self, T: gp_Trsf2d) -> None: ...
	def TransformedParameter(self, U: float, T: gp_Trsf2d) -> float: ...

# harray1 classes
# harray2 classes
# hsequence classes

Geom2d_BSplineCurve_MaxDegree = Geom2d_BSplineCurve.MaxDegree
Geom2d_BezierCurve_MaxDegree = Geom2d_BezierCurve.MaxDegree
