from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.CDM import *
from OCC.Core.TCollection import *
from OCC.Core.PCDM import *


class CDF_TypeOfActivation(IntEnum):
	CDF_TOA_New: int = ...
	CDF_TOA_Modified: int = ...
	CDF_TOA_Unchanged: int = ...
CDF_TOA_New = CDF_TypeOfActivation.CDF_TOA_New
CDF_TOA_Modified = CDF_TypeOfActivation.CDF_TOA_Modified
CDF_TOA_Unchanged = CDF_TypeOfActivation.CDF_TOA_Unchanged

class CDF_TryStoreStatus(IntEnum):
	CDF_TS_OK: int = ...
	CDF_TS_NoCurrentDocument: int = ...
	CDF_TS_NoDriver: int = ...
	CDF_TS_NoSubComponentDriver: int = ...
CDF_TS_OK = CDF_TryStoreStatus.CDF_TS_OK
CDF_TS_NoCurrentDocument = CDF_TryStoreStatus.CDF_TS_NoCurrentDocument
CDF_TS_NoDriver = CDF_TryStoreStatus.CDF_TS_NoDriver
CDF_TS_NoSubComponentDriver = CDF_TryStoreStatus.CDF_TS_NoSubComponentDriver

class CDF_SubComponentStatus(IntEnum):
	CDF_SCS_Consistent: int = ...
	CDF_SCS_Unconsistent: int = ...
	CDF_SCS_Stored: int = ...
	CDF_SCS_Modified: int = ...
CDF_SCS_Consistent = CDF_SubComponentStatus.CDF_SCS_Consistent
CDF_SCS_Unconsistent = CDF_SubComponentStatus.CDF_SCS_Unconsistent
CDF_SCS_Stored = CDF_SubComponentStatus.CDF_SCS_Stored
CDF_SCS_Modified = CDF_SubComponentStatus.CDF_SCS_Modified

class CDF_StoreSetNameStatus(IntEnum):
	CDF_SSNS_OK: int = ...
	CDF_SSNS_ReplacingAnExistentDocument: int = ...
	CDF_SSNS_OpenDocument: int = ...
CDF_SSNS_OK = CDF_StoreSetNameStatus.CDF_SSNS_OK
CDF_SSNS_ReplacingAnExistentDocument = CDF_StoreSetNameStatus.CDF_SSNS_ReplacingAnExistentDocument
CDF_SSNS_OpenDocument = CDF_StoreSetNameStatus.CDF_SSNS_OpenDocument

class cdf:
	@staticmethod
	def GetLicense(anApplicationIdentifier: int) -> None: ...
	@staticmethod
	def IsAvailable(anApplicationIdentifier: int) -> bool: ...

class CDF_Application(CDM_Application):
	def CanClose(self, aDocument: CDM_Document) -> CDM_CanCloseStatus: ...
	@overload
	def CanRetrieve(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString) -> PCDM_ReaderStatus: ...
	@overload
	def CanRetrieve(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString, aVersion: TCollection_ExtendedString) -> PCDM_ReaderStatus: ...
	def Close(self, aDocument: CDM_Document) -> None: ...
	def DefaultFolder(self) -> Standard_ExtString: ...
	def Format(self, aFileName: TCollection_ExtendedString, theFormat: TCollection_ExtendedString) -> bool: ...
	def GetRetrieveStatus(self) -> PCDM_ReaderStatus: ...
	@staticmethod
	def Load(aGUID: Standard_GUID) -> CDF_Application: ...
	def Open(self, aDocument: CDM_Document) -> None: ...
	def ReaderFromFormat(self, aFormat: TCollection_ExtendedString) -> PCDM_Reader: ...
	@overload
	def Retrieve(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString, UseStorageConfiguration: Optional[bool] = True) -> CDM_Document: ...
	@overload
	def Retrieve(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString, aVersion: TCollection_ExtendedString, UseStorageConfiguration: Optional[bool] = True) -> CDM_Document: ...
	def SetDefaultFolder(self, aFolder: Standard_ExtString) -> bool: ...
	def WriterFromFormat(self, aFormat: TCollection_ExtendedString) -> PCDM_StorageDriver: ...

class CDF_Directory(Standard_Transient):
	def __init__(self) -> None: ...
	def Add(self, aDocument: CDM_Document) -> None: ...
	def Contains(self, aDocument: CDM_Document) -> bool: ...
	def IsEmpty(self) -> bool: ...
	def Last(self) -> CDM_Document: ...
	def Length(self) -> int: ...
	def Remove(self, aDocument: CDM_Document) -> None: ...

class CDF_MetaDataDriver(Standard_Transient):
	def BuildFileName(self, aDocument: CDM_Document) -> TCollection_ExtendedString: ...
	def CreateDependsOn(self, aFirstData: CDM_MetaData, aSecondData: CDM_MetaData) -> None: ...
	def CreateMetaData(self, aDocument: CDM_Document, aFileName: TCollection_ExtendedString) -> CDM_MetaData: ...
	def CreateReference(self, aFrom: CDM_MetaData, aTo: CDM_MetaData, aReferenceIdentifier: int, aToDocumentVersion: int) -> None: ...
	def DefaultFolder(self) -> TCollection_ExtendedString: ...
	@overload
	def Find(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString, aVersion: TCollection_ExtendedString) -> bool: ...
	@overload
	def Find(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString) -> bool: ...
	def FindFolder(self, aFolder: TCollection_ExtendedString) -> bool: ...
	def HasReadPermission(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString, aVersion: TCollection_ExtendedString) -> bool: ...
	def HasVersion(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString) -> bool: ...
	def HasVersionCapability(self) -> bool: ...
	def LastVersion(self, aMetaData: CDM_MetaData) -> CDM_MetaData: ...
	@overload
	def MetaData(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString, aVersion: TCollection_ExtendedString) -> CDM_MetaData: ...
	@overload
	def MetaData(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString) -> CDM_MetaData: ...
	def ReferenceIterator(self) -> PCDM_ReferenceIterator: ...
	def SetName(self, aDocument: CDM_Document, aName: TCollection_ExtendedString) -> TCollection_ExtendedString: ...

class CDF_MetaDataDriverFactory(Standard_Transient):
	def Build(self) -> CDF_MetaDataDriver: ...

class CDF_Session(Standard_Transient):
	def __init__(self) -> None: ...
	def CurrentApplication(self) -> CDF_Application: ...
	@staticmethod
	def CurrentSession() -> CDF_Session: ...
	def Directory(self) -> CDF_Directory: ...
	@staticmethod
	def Exists() -> bool: ...
	def HasCurrentApplication(self) -> bool: ...
	def LoadDriver(self) -> None: ...
	def MetaDataDriver(self) -> CDF_MetaDataDriver: ...
	def SetCurrentApplication(self, anApplication: CDF_Application) -> None: ...
	def UnsetCurrentApplication(self) -> None: ...

class CDF_Store:
	def __init__(self, aDocument: CDM_Document) -> None: ...
	def AssociatedStatusText(self) -> Standard_ExtString: ...
	def Comment(self) -> Standard_ExtString: ...
	def Component(self) -> Standard_ExtString: ...
	def CurrentIsConsistent(self) -> bool: ...
	def Description(self) -> Standard_ExtString: ...
	def Folder(self) -> Standard_ExtString: ...
	def HasAPreviousVersion(self) -> bool: ...
	def HasSubComponents(self) -> bool: ...
	def InitComponent(self) -> None: ...
	def IsConsistent(self) -> bool: ...
	def IsMainDocument(self) -> bool: ...
	def IsModified(self) -> bool: ...
	def IsStored(self) -> bool: ...
	def MetaDataPath(self) -> Standard_ExtString: ...
	def MoreComponent(self) -> bool: ...
	def Name(self) -> Standard_ExtString: ...
	def NextComponent(self) -> None: ...
	def Path(self) -> Standard_ExtString: ...
	def PreviousVersion(self) -> Standard_ExtString: ...
	def Realize(self) -> None: ...
	def RecheckName(self) -> CDF_StoreSetNameStatus: ...
	def SetComment(self, aComment: Standard_ExtString) -> None: ...
	@overload
	def SetCurrent(self) -> None: ...
	@overload
	def SetCurrent(self, aPresentation: Standard_ExtString) -> None: ...
	@overload
	def SetFolder(self, aFolder: TCollection_ExtendedString) -> bool: ...
	@overload
	def SetFolder(self, aFolder: Standard_ExtString) -> bool: ...
	def SetMain(self) -> None: ...
	@overload
	def SetName(self, aName: Standard_ExtString) -> CDF_StoreSetNameStatus: ...
	@overload
	def SetName(self, aName: TCollection_ExtendedString) -> CDF_StoreSetNameStatus: ...
	def SetPreviousVersion(self, aPreviousVersion: Standard_ExtString) -> bool: ...
	def StoreStatus(self) -> PCDM_StoreStatus: ...
	def SubComponentStatus(self, aPresentation: Standard_ExtString) -> CDF_SubComponentStatus: ...

class CDF_StoreList(Standard_Transient):
	def __init__(self, aDocument: CDM_Document) -> None: ...
	def Init(self) -> None: ...
	def IsConsistent(self) -> bool: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def Store(self, aMetaData: CDM_MetaData, aStatusAssociatedText: TCollection_ExtendedString) -> PCDM_StoreStatus: ...
	def Value(self) -> CDM_Document: ...

class CDF_FWOSDriver(CDF_MetaDataDriver):
	def __init__(self) -> None: ...
	def BuildFileName(self, aDocument: CDM_Document) -> TCollection_ExtendedString: ...
	def DefaultFolder(self) -> TCollection_ExtendedString: ...
	def Find(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString, aVersion: TCollection_ExtendedString) -> bool: ...
	def FindFolder(self, aFolder: TCollection_ExtendedString) -> bool: ...
	def HasReadPermission(self, aFolder: TCollection_ExtendedString, aName: TCollection_ExtendedString, aVersion: TCollection_ExtendedString) -> bool: ...
	def SetName(self, aDocument: CDM_Document, aName: TCollection_ExtendedString) -> TCollection_ExtendedString: ...

#classnotwrapped
class CDF_DirectoryIterator: ...

# harray1 classes
# harray2 classes
# hsequence classes

cdf_GetLicense = cdf.GetLicense
cdf_IsAvailable = cdf.IsAvailable
CDF_Application_Load = CDF_Application.Load
CDF_Session_CurrentSession = CDF_Session.CurrentSession
CDF_Session_Exists = CDF_Session.Exists
