from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Geom import *
from OCC.Core.TopoDS import *
from OCC.Core.TopTools import *
from OCC.Core.BRepAlgo import *
from OCC.Core.TopAbs import *
from OCC.Core.GeomAbs import *
from OCC.Core.TCollection import *
from OCC.Core.BRepTools import *
from OCC.Core.TopLoc import *
from OCC.Core.Geom2d import *
from OCC.Core.gp import *


class BRepOffset_ListOfInterval:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> BRepOffset_Interval: ...
    def Last(self) -> BRepOffset_Interval: ...
    def Append(self, theItem: BRepOffset_Interval) -> BRepOffset_Interval: ...
    def Prepend(self, theItem: BRepOffset_Interval) -> BRepOffset_Interval: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> BRepOffset_Interval: ...
    def SetValue(self, theIndex: int, theValue: BRepOffset_Interval) -> None: ...

class BRepOffset_Error(IntEnum):
	BRepOffset_NoError: int = ...
	BRepOffset_UnknownError: int = ...
	BRepOffset_BadNormalsOnGeometry: int = ...
	BRepOffset_C0Geometry: int = ...
	BRepOffset_NullOffset: int = ...
	BRepOffset_NotConnectedShell: int = ...
BRepOffset_NoError = BRepOffset_Error.BRepOffset_NoError
BRepOffset_UnknownError = BRepOffset_Error.BRepOffset_UnknownError
BRepOffset_BadNormalsOnGeometry = BRepOffset_Error.BRepOffset_BadNormalsOnGeometry
BRepOffset_C0Geometry = BRepOffset_Error.BRepOffset_C0Geometry
BRepOffset_NullOffset = BRepOffset_Error.BRepOffset_NullOffset
BRepOffset_NotConnectedShell = BRepOffset_Error.BRepOffset_NotConnectedShell

class BRepOffsetSimple_Status(IntEnum):
	BRepOffsetSimple_OK: int = ...
	BRepOffsetSimple_NullInputShape: int = ...
	BRepOffsetSimple_ErrorOffsetComputation: int = ...
	BRepOffsetSimple_ErrorWallFaceComputation: int = ...
	BRepOffsetSimple_ErrorInvalidNbShells: int = ...
	BRepOffsetSimple_ErrorNonClosedShell: int = ...
BRepOffsetSimple_OK = BRepOffsetSimple_Status.BRepOffsetSimple_OK
BRepOffsetSimple_NullInputShape = BRepOffsetSimple_Status.BRepOffsetSimple_NullInputShape
BRepOffsetSimple_ErrorOffsetComputation = BRepOffsetSimple_Status.BRepOffsetSimple_ErrorOffsetComputation
BRepOffsetSimple_ErrorWallFaceComputation = BRepOffsetSimple_Status.BRepOffsetSimple_ErrorWallFaceComputation
BRepOffsetSimple_ErrorInvalidNbShells = BRepOffsetSimple_Status.BRepOffsetSimple_ErrorInvalidNbShells
BRepOffsetSimple_ErrorNonClosedShell = BRepOffsetSimple_Status.BRepOffsetSimple_ErrorNonClosedShell

class BRepOffset_Mode(IntEnum):
	BRepOffset_Skin: int = ...
	BRepOffset_Pipe: int = ...
	BRepOffset_RectoVerso: int = ...
BRepOffset_Skin = BRepOffset_Mode.BRepOffset_Skin
BRepOffset_Pipe = BRepOffset_Mode.BRepOffset_Pipe
BRepOffset_RectoVerso = BRepOffset_Mode.BRepOffset_RectoVerso

class BRepOffset_Type(IntEnum):
	BRepOffset_Concave: int = ...
	BRepOffset_Convex: int = ...
	BRepOffset_Tangent: int = ...
	BRepOffset_FreeBoundary: int = ...
	BRepOffset_Other: int = ...
BRepOffset_Concave = BRepOffset_Type.BRepOffset_Concave
BRepOffset_Convex = BRepOffset_Type.BRepOffset_Convex
BRepOffset_Tangent = BRepOffset_Type.BRepOffset_Tangent
BRepOffset_FreeBoundary = BRepOffset_Type.BRepOffset_FreeBoundary
BRepOffset_Other = BRepOffset_Type.BRepOffset_Other

class BRepOffset_Status(IntEnum):
	BRepOffset_Good: int = ...
	BRepOffset_Reversed: int = ...
	BRepOffset_Degenerated: int = ...
	BRepOffset_Unknown: int = ...
BRepOffset_Good = BRepOffset_Status.BRepOffset_Good
BRepOffset_Reversed = BRepOffset_Status.BRepOffset_Reversed
BRepOffset_Degenerated = BRepOffset_Status.BRepOffset_Degenerated
BRepOffset_Unknown = BRepOffset_Status.BRepOffset_Unknown

class brepoffset:
	@staticmethod
	def CollapseSingularities(theSurface: Geom_Surface, theFace: TopoDS_Face, thePrecision: float) -> Geom_Surface: ...
	@staticmethod
	def Surface(Surface: Geom_Surface, Offset: float, theStatus: BRepOffset_Status, allowC0: Optional[bool] = False) -> Geom_Surface: ...

class BRepOffset_Analyse:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, S: TopoDS_Shape, Angle: float) -> None: ...
	@overload
	def AddFaces(self, Face: TopoDS_Face, Co: TopoDS_Compound, Map: TopTools_MapOfShape, Type: BRepOffset_Type) -> None: ...
	@overload
	def AddFaces(self, Face: TopoDS_Face, Co: TopoDS_Compound, Map: TopTools_MapOfShape, Type1: BRepOffset_Type, Type2: BRepOffset_Type) -> None: ...
	def Ancestors(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
	def Clear(self) -> None: ...
	@overload
	def Edges(self, V: TopoDS_Vertex, T: BRepOffset_Type, L: TopTools_ListOfShape) -> None: ...
	@overload
	def Edges(self, F: TopoDS_Face, T: BRepOffset_Type, L: TopTools_ListOfShape) -> None: ...
	@overload
	def Explode(self, L: TopTools_ListOfShape, Type: BRepOffset_Type) -> None: ...
	@overload
	def Explode(self, L: TopTools_ListOfShape, Type1: BRepOffset_Type, Type2: BRepOffset_Type) -> None: ...
	def HasAncestor(self, S: TopoDS_Shape) -> bool: ...
	def IsDone(self) -> bool: ...
	def Perform(self, S: TopoDS_Shape, Angle: float) -> None: ...
	def TangentEdges(self, Edge: TopoDS_Edge, Vertex: TopoDS_Vertex, Edges: TopTools_ListOfShape) -> None: ...
	def Type(self, E: TopoDS_Edge) -> BRepOffset_ListOfInterval: ...

class BRepOffset_Inter2d:
	@staticmethod
	def Compute(AsDes: BRepAlgo_AsDes, F: TopoDS_Face, NewEdges: TopTools_IndexedMapOfShape, Tol: float, theDMVV: TopTools_IndexedDataMapOfShapeListOfShape) -> None: ...
	@staticmethod
	def ConnexIntByInt(FI: TopoDS_Face, OFI: BRepOffset_Offset, MES: TopTools_DataMapOfShapeShape, Build: TopTools_DataMapOfShapeShape, AsDes2d: BRepAlgo_AsDes, Offset: float, Tol: float, FacesWithVerts: TopTools_IndexedMapOfShape, theDMVV: TopTools_IndexedDataMapOfShapeListOfShape) -> None: ...
	@staticmethod
	def ConnexIntByIntInVert(FI: TopoDS_Face, OFI: BRepOffset_Offset, MES: TopTools_DataMapOfShapeShape, Build: TopTools_DataMapOfShapeShape, AsDes: BRepAlgo_AsDes, AsDes2d: BRepAlgo_AsDes, Tol: float, theDMVV: TopTools_IndexedDataMapOfShapeListOfShape) -> None: ...
	@staticmethod
	def ExtentEdge(E: TopoDS_Edge, NE: TopoDS_Edge, theOffset: float) -> None: ...
	@staticmethod
	def FuseVertices(theDMVV: TopTools_IndexedDataMapOfShapeListOfShape, theAsDes: BRepAlgo_AsDes) -> None: ...

class BRepOffset_Inter3d:
	def __init__(self, AsDes: BRepAlgo_AsDes, Side: TopAbs_State, Tol: float) -> None: ...
	def AddCommonEdges(self, SetOfFaces: TopTools_ListOfShape) -> None: ...
	def AsDes(self) -> BRepAlgo_AsDes: ...
	def CompletInt(self, SetOfFaces: TopTools_ListOfShape, InitOffsetFace: BRepAlgo_Image) -> None: ...
	def ConnexIntByArc(self, SetOfFaces: TopTools_ListOfShape, ShapeInit: TopoDS_Shape, Analyse: BRepOffset_Analyse, InitOffsetFace: BRepAlgo_Image) -> None: ...
	def ConnexIntByInt(self, SI: TopoDS_Shape, MapSF: BRepOffset_DataMapOfShapeOffset, A: BRepOffset_Analyse, MES: TopTools_DataMapOfShapeShape, Build: TopTools_DataMapOfShapeShape, Failed: TopTools_ListOfShape, bIsPlanar: Optional[bool] = False) -> None: ...
	def ContextIntByArc(self, ContextFaces: TopTools_IndexedMapOfShape, ExtentContext: bool, Analyse: BRepOffset_Analyse, InitOffsetFace: BRepAlgo_Image, InitOffsetEdge: BRepAlgo_Image) -> None: ...
	def ContextIntByInt(self, ContextFaces: TopTools_IndexedMapOfShape, ExtentContext: bool, MapSF: BRepOffset_DataMapOfShapeOffset, A: BRepOffset_Analyse, MES: TopTools_DataMapOfShapeShape, Build: TopTools_DataMapOfShapeShape, Failed: TopTools_ListOfShape, bIsPlanar: Optional[bool] = False) -> None: ...
	def FaceInter(self, F1: TopoDS_Face, F2: TopoDS_Face, InitOffsetFace: BRepAlgo_Image) -> None: ...
	def IsDone(self, F1: TopoDS_Face, F2: TopoDS_Face) -> bool: ...
	def NewEdges(self) -> TopTools_IndexedMapOfShape: ...
	def SetDone(self, F1: TopoDS_Face, F2: TopoDS_Face) -> None: ...
	def TouchedFaces(self) -> TopTools_IndexedMapOfShape: ...

class BRepOffset_Interval:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, U1: float, U2: float, Type: BRepOffset_Type) -> None: ...
	@overload
	def First(self, U: float) -> None: ...
	@overload
	def First(self) -> float: ...
	@overload
	def Last(self, U: float) -> None: ...
	@overload
	def Last(self) -> float: ...
	@overload
	def Type(self, T: BRepOffset_Type) -> None: ...
	@overload
	def Type(self) -> BRepOffset_Type: ...

class BRepOffset_MakeLoops:
	def __init__(self) -> None: ...
	def Build(self, LF: TopTools_ListOfShape, AsDes: BRepAlgo_AsDes, Image: BRepAlgo_Image) -> None: ...
	def BuildFaces(self, LF: TopTools_ListOfShape, AsDes: BRepAlgo_AsDes, Image: BRepAlgo_Image) -> None: ...
	def BuildOnContext(self, LContext: TopTools_ListOfShape, Analyse: BRepOffset_Analyse, AsDes: BRepAlgo_AsDes, Image: BRepAlgo_Image, InSide: bool) -> None: ...

class BRepOffset_MakeOffset:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, S: TopoDS_Shape, Offset: float, Tol: float, Mode: Optional[BRepOffset_Mode] = BRepOffset_Skin, Intersection: Optional[bool] = False, SelfInter: Optional[bool] = False, Join: Optional[GeomAbs_JoinType] = GeomAbs_Arc, Thickening: Optional[bool] = False, RemoveIntEdges: Optional[bool] = False) -> None: ...
	def AddFace(self, F: TopoDS_Face) -> None: ...
	def CheckInputData(self) -> bool: ...
	def Clear(self) -> None: ...
	def ClosingFaces(self) -> TopTools_IndexedMapOfShape: ...
	def Error(self) -> BRepOffset_Error: ...
	def GetBadShape(self) -> TopoDS_Shape: ...
	def GetJoinType(self) -> GeomAbs_JoinType: ...
	def Initialize(self, S: TopoDS_Shape, Offset: float, Tol: float, Mode: Optional[BRepOffset_Mode] = BRepOffset_Skin, Intersection: Optional[bool] = False, SelfInter: Optional[bool] = False, Join: Optional[GeomAbs_JoinType] = GeomAbs_Arc, Thickening: Optional[bool] = False, RemoveIntEdges: Optional[bool] = False) -> None: ...
	def IsDone(self) -> bool: ...
	def MakeOffsetShape(self) -> None: ...
	def MakeThickSolid(self) -> None: ...
	def OffsetEdgesFromShapes(self) -> BRepAlgo_Image: ...
	def OffsetFacesFromShapes(self) -> BRepAlgo_Image: ...
	def SetOffsetOnFace(self, F: TopoDS_Face, Off: float) -> None: ...
	def Shape(self) -> TopoDS_Shape: ...

class BRepOffset_MakeSimpleOffset:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, theInputShape: TopoDS_Shape, theOffsetValue: float) -> None: ...
	def Generated(self, theShape: TopoDS_Shape) -> TopoDS_Shape: ...
	def GetBuildSolidFlag(self) -> bool: ...
	def GetError(self) -> False: ...
	def GetErrorMessage(self) -> TCollection_AsciiString: ...
	def GetOffsetValue(self) -> float: ...
	def GetResultShape(self) -> TopoDS_Shape: ...
	def GetTolerance(self) -> float: ...
	def Initialize(self, theInputShape: TopoDS_Shape, theOffsetValue: float) -> None: ...
	def IsDone(self) -> bool: ...
	def Modified(self, theShape: TopoDS_Shape) -> TopoDS_Shape: ...
	def Perform(self) -> None: ...
	def SetBuildSolidFlag(self, theBuildFlag: bool) -> None: ...
	def SetOffsetValue(self, theOffsetValue: float) -> None: ...
	def SetTolerance(self, theValue: float) -> None: ...

class BRepOffset_Offset:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, Face: TopoDS_Face, Offset: float, OffsetOutside: Optional[bool] = True, JoinType: Optional[GeomAbs_JoinType] = GeomAbs_Arc) -> None: ...
	@overload
	def __init__(self, Face: TopoDS_Face, Offset: float, Created: TopTools_DataMapOfShapeShape, OffsetOutside: Optional[bool] = True, JoinType: Optional[GeomAbs_JoinType] = GeomAbs_Arc) -> None: ...
	@overload
	def __init__(self, Path: TopoDS_Edge, Edge1: TopoDS_Edge, Edge2: TopoDS_Edge, Offset: float, Polynomial: Optional[bool] = False, Tol: Optional[float] = 1.0e-4, Conti: Optional[GeomAbs_Shape] = GeomAbs_C1) -> None: ...
	@overload
	def __init__(self, Path: TopoDS_Edge, Edge1: TopoDS_Edge, Edge2: TopoDS_Edge, Offset: float, FirstEdge: TopoDS_Edge, LastEdge: TopoDS_Edge, Polynomial: Optional[bool] = False, Tol: Optional[float] = 1.0e-4, Conti: Optional[GeomAbs_Shape] = GeomAbs_C1) -> None: ...
	@overload
	def __init__(self, Vertex: TopoDS_Vertex, LEdge: TopTools_ListOfShape, Offset: float, Polynomial: Optional[bool] = False, Tol: Optional[float] = 1.0e-4, Conti: Optional[GeomAbs_Shape] = GeomAbs_C1) -> None: ...
	def Face(self) -> TopoDS_Face: ...
	def Generated(self, Shape: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def Init(self, Face: TopoDS_Face, Offset: float, OffsetOutside: Optional[bool] = True, JoinType: Optional[GeomAbs_JoinType] = GeomAbs_Arc) -> None: ...
	@overload
	def Init(self, Face: TopoDS_Face, Offset: float, Created: TopTools_DataMapOfShapeShape, OffsetOutside: Optional[bool] = True, JoinType: Optional[GeomAbs_JoinType] = GeomAbs_Arc) -> None: ...
	@overload
	def Init(self, Path: TopoDS_Edge, Edge1: TopoDS_Edge, Edge2: TopoDS_Edge, Offset: float, Polynomial: Optional[bool] = False, Tol: Optional[float] = 1.0e-4, Conti: Optional[GeomAbs_Shape] = GeomAbs_C1) -> None: ...
	@overload
	def Init(self, Path: TopoDS_Edge, Edge1: TopoDS_Edge, Edge2: TopoDS_Edge, Offset: float, FirstEdge: TopoDS_Edge, LastEdge: TopoDS_Edge, Polynomial: Optional[bool] = False, Tol: Optional[float] = 1.0e-4, Conti: Optional[GeomAbs_Shape] = GeomAbs_C1) -> None: ...
	@overload
	def Init(self, Vertex: TopoDS_Vertex, LEdge: TopTools_ListOfShape, Offset: float, Polynomial: Optional[bool] = False, Tol: Optional[float] = 1.0e-4, Conti: Optional[GeomAbs_Shape] = GeomAbs_C1) -> None: ...
	@overload
	def Init(self, Edge: TopoDS_Edge, Offset: float) -> None: ...
	def InitialShape(self) -> TopoDS_Shape: ...
	def Status(self) -> BRepOffset_Status: ...

class BRepOffset_SimpleOffset(BRepTools_Modification):
	def __init__(self, theInputShape: TopoDS_Shape, theOffsetValue: float, theTolerance: float) -> None: ...
	def Continuity(self, E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face, NewE: TopoDS_Edge, NewF1: TopoDS_Face, NewF2: TopoDS_Face) -> GeomAbs_Shape: ...
	def NewCurve(self, E: TopoDS_Edge, C: Geom_Curve, L: TopLoc_Location) -> Tuple[bool, float]: ...
	def NewCurve2d(self, E: TopoDS_Edge, F: TopoDS_Face, NewE: TopoDS_Edge, NewF: TopoDS_Face, C: Geom2d_Curve) -> Tuple[bool, float]: ...
	def NewParameter(self, V: TopoDS_Vertex, E: TopoDS_Edge) -> Tuple[bool, float, float]: ...
	def NewPoint(self, V: TopoDS_Vertex, P: gp_Pnt) -> Tuple[bool, float]: ...
	def NewSurface(self, F: TopoDS_Face, S: Geom_Surface, L: TopLoc_Location) -> Tuple[bool, float, bool, bool]: ...

class BRepOffset_Tool:
	@staticmethod
	def BuildNeighbour(W: TopoDS_Wire, F: TopoDS_Face, NOnV1: TopTools_DataMapOfShapeShape, NOnV2: TopTools_DataMapOfShapeShape) -> None: ...
	@staticmethod
	def CheckBounds(F: TopoDS_Face, Analyse: BRepOffset_Analyse) -> Tuple[bool, bool, bool]: ...
	@staticmethod
	def CheckPlanesNormals(theFace1: TopoDS_Face, theFace2: TopoDS_Face, theTolAng: Optional[float] = 1e-8) -> bool: ...
	@staticmethod
	def CorrectOrientation(SI: TopoDS_Shape, NewEdges: TopTools_IndexedMapOfShape, AsDes: BRepAlgo_AsDes, InitOffset: BRepAlgo_Image, Offset: float) -> None: ...
	@staticmethod
	def Deboucle3D(S: TopoDS_Shape, Boundary: TopTools_MapOfShape) -> TopoDS_Shape: ...
	@staticmethod
	def EdgeVertices(E: TopoDS_Edge, V1: TopoDS_Vertex, V2: TopoDS_Vertex) -> None: ...
	@staticmethod
	def EnLargeFace(F: TopoDS_Face, NF: TopoDS_Face, ChangeGeom: bool, UpDatePCurve: Optional[bool] = False, enlargeU: Optional[bool] = True, enlargeVfirst: Optional[bool] = True, enlargeVlast: Optional[bool] = True, theExtensionMode: Optional[int] = 1, theLenBeforeUfirst: Optional[float] = -1, theLenAfterUlast: Optional[float] = -1, theLenBeforeVfirst: Optional[float] = -1, theLenAfterVlast: Optional[float] = -1) -> bool: ...
	@staticmethod
	def ExtentFace(F: TopoDS_Face, ConstShapes: TopTools_DataMapOfShapeShape, ToBuild: TopTools_DataMapOfShapeShape, Side: TopAbs_State, TolConf: float, NF: TopoDS_Face) -> None: ...
	@overload
	@staticmethod
	def FindCommonShapes(theF1: TopoDS_Face, theF2: TopoDS_Face, theLE: TopTools_ListOfShape, theLV: TopTools_ListOfShape) -> bool: ...
	@overload
	@staticmethod
	def FindCommonShapes(theS1: TopoDS_Shape, theS2: TopoDS_Shape, theType: TopAbs_ShapeEnum, theLSC: TopTools_ListOfShape) -> bool: ...
	@staticmethod
	def Gabarit(aCurve: Geom_Curve) -> float: ...
	@staticmethod
	def Inter2d(F: TopoDS_Face, E1: TopoDS_Edge, E2: TopoDS_Edge, LV: TopTools_ListOfShape, Tol: float) -> None: ...
	@staticmethod
	def Inter3D(F1: TopoDS_Face, F2: TopoDS_Face, LInt1: TopTools_ListOfShape, LInt2: TopTools_ListOfShape, Side: TopAbs_State, RefEdge: TopoDS_Edge, IsRefEdgeDefined: Optional[bool] = False) -> None: ...
	@staticmethod
	def InterOrExtent(F1: TopoDS_Face, F2: TopoDS_Face, LInt1: TopTools_ListOfShape, LInt2: TopTools_ListOfShape, Side: TopAbs_State) -> None: ...
	@staticmethod
	def MapVertexEdges(S: TopoDS_Shape, MVE: TopTools_DataMapOfShapeListOfShape) -> None: ...
	@staticmethod
	def OriEdgeInFace(E: TopoDS_Edge, F: TopoDS_Face) -> TopAbs_Orientation: ...
	@staticmethod
	def OrientSection(E: TopoDS_Edge, F1: TopoDS_Face, F2: TopoDS_Face, O1: TopAbs_Orientation, O2: TopAbs_Orientation) -> None: ...
	@staticmethod
	def PipeInter(F1: TopoDS_Face, F2: TopoDS_Face, LInt1: TopTools_ListOfShape, LInt2: TopTools_ListOfShape, Side: TopAbs_State) -> None: ...
	@staticmethod
	def TryProject(F1: TopoDS_Face, F2: TopoDS_Face, Edges: TopTools_ListOfShape, LInt1: TopTools_ListOfShape, LInt2: TopTools_ListOfShape, Side: TopAbs_State, TolConf: float) -> bool: ...

# harray1 classes
# harray2 classes
# hsequence classes

brepoffset_CollapseSingularities = brepoffset.CollapseSingularities
brepoffset_Surface = brepoffset.Surface
BRepOffset_Inter2d_Compute = BRepOffset_Inter2d.Compute
BRepOffset_Inter2d_ConnexIntByInt = BRepOffset_Inter2d.ConnexIntByInt
BRepOffset_Inter2d_ConnexIntByIntInVert = BRepOffset_Inter2d.ConnexIntByIntInVert
BRepOffset_Inter2d_ExtentEdge = BRepOffset_Inter2d.ExtentEdge
BRepOffset_Inter2d_FuseVertices = BRepOffset_Inter2d.FuseVertices
BRepOffset_Tool_BuildNeighbour = BRepOffset_Tool.BuildNeighbour
BRepOffset_Tool_CheckBounds = BRepOffset_Tool.CheckBounds
BRepOffset_Tool_CheckPlanesNormals = BRepOffset_Tool.CheckPlanesNormals
BRepOffset_Tool_CorrectOrientation = BRepOffset_Tool.CorrectOrientation
BRepOffset_Tool_Deboucle3D = BRepOffset_Tool.Deboucle3D
BRepOffset_Tool_EdgeVertices = BRepOffset_Tool.EdgeVertices
BRepOffset_Tool_EnLargeFace = BRepOffset_Tool.EnLargeFace
BRepOffset_Tool_ExtentFace = BRepOffset_Tool.ExtentFace
BRepOffset_Tool_FindCommonShapes = BRepOffset_Tool.FindCommonShapes
BRepOffset_Tool_FindCommonShapes = BRepOffset_Tool.FindCommonShapes
BRepOffset_Tool_Gabarit = BRepOffset_Tool.Gabarit
BRepOffset_Tool_Inter2d = BRepOffset_Tool.Inter2d
BRepOffset_Tool_Inter3D = BRepOffset_Tool.Inter3D
BRepOffset_Tool_InterOrExtent = BRepOffset_Tool.InterOrExtent
BRepOffset_Tool_MapVertexEdges = BRepOffset_Tool.MapVertexEdges
BRepOffset_Tool_OriEdgeInFace = BRepOffset_Tool.OriEdgeInFace
BRepOffset_Tool_OrientSection = BRepOffset_Tool.OrientSection
BRepOffset_Tool_PipeInter = BRepOffset_Tool.PipeInter
BRepOffset_Tool_TryProject = BRepOffset_Tool.TryProject
