# -*- python -*-

"""
MINT - Mimetic INTerpolation on the Sphere

MINT computes line/flux integrals of edge/face staggered vector fields. The line and flux integrals 
are conserved in the sense that closed line integrals of a vector field deriving from a potential
or streamfunction are zero to near machine accuracy. MINT can also be applied to regrid vector
fields from source to destination grids.
"""

#
#__init__.py is automatically generated from __init__.py.in, DO NOT EDIT __init__.py
#

from ctypes import CDLL
from pathlib import Path

__version__ = "1.23.0"

# open shared library, the name of the shared object is always libmint.so 
# even on Windows
MINTLIB = CDLL(str(Path(__path__[0]).parent / Path('libmint.so')))
CELL_BY_CELL_DATA = 0
UNIQUE_EDGE_DATA = 1
NUM_EDGES_PER_QUAD = 4
NUM_VERTS_PER_QUAD = 4
NUM_VERTS_PER_EDGE = 2

__all__ = ('regrid_edges', 'grid', 'polyline_integral',
           'vector_interp', 'message_handler', 'utils',
           MINTLIB, CELL_BY_CELL_DATA, UNIQUE_EDGE_DATA, 
           NUM_EDGES_PER_QUAD, NUM_VERTS_PER_QUAD, NUM_VERTS_PER_EDGE)

from .message_handler import error_handler, warning_handler, printLogMessages, writeLogMessages
from .regrid_edges import RegridEdges
from .grid import Grid
from .polyline_integral import PolylineIntegral
from .vector_interp import VectorInterp
from .utils import getIntegralsInLonLat, getIntegralsInXYZ

