
# import statement needed on some systems
import sys
import os.path
import inspect
try: 
  _filename = inspect.getframeinfo(inspect.currentframe()).filename
except:
  _filename = __file__
_path = os.path.dirname(os.path.abspath(_filename))
if not _path in sys.path:
  sys.path.append(_path)


USE_LIBSBML_PYTHON_API2_WARNINGS = False
# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _libsbml
else:
    import _libsbml

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class ModelCreatorList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libsbml.ModelCreatorList_swiginit(self, _libsbml.new_ModelCreatorList())
    __swig_destroy__ = _libsbml.delete_ModelCreatorList

    def add(self, item):
        return _libsbml.ModelCreatorList_add(self, item)

    def get(self, n):
        return _libsbml.ModelCreatorList_get(self, n)

    def prepend(self, item):
        return _libsbml.ModelCreatorList_prepend(self, item)

    def remove(self, n):
        return _libsbml.ModelCreatorList_remove(self, n)

    def getSize(self):
        return _libsbml.ModelCreatorList_getSize(self)

# Register ModelCreatorList in _libsbml:
_libsbml.ModelCreatorList_swigregister(ModelCreatorList)

class DateList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libsbml.DateList_swiginit(self, _libsbml.new_DateList())
    __swig_destroy__ = _libsbml.delete_DateList

    def add(self, item):
        return _libsbml.DateList_add(self, item)

    def get(self, n):
        return _libsbml.DateList_get(self, n)

    def prepend(self, item):
        return _libsbml.DateList_prepend(self, item)

    def remove(self, n):
        return _libsbml.DateList_remove(self, n)

    def getSize(self):
        return _libsbml.DateList_getSize(self)

# Register DateList in _libsbml:
_libsbml.DateList_swigregister(DateList)

class CVTermList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libsbml.CVTermList_swiginit(self, _libsbml.new_CVTermList())
    __swig_destroy__ = _libsbml.delete_CVTermList

    def add(self, item):
        return _libsbml.CVTermList_add(self, item)

    def get(self, n):
        return _libsbml.CVTermList_get(self, n)

    def prepend(self, item):
        return _libsbml.CVTermList_prepend(self, item)

    def remove(self, n):
        return _libsbml.CVTermList_remove(self, n)

    def getSize(self):
        return _libsbml.CVTermList_getSize(self)

# Register CVTermList in _libsbml:
_libsbml.CVTermList_swigregister(CVTermList)

class ASTNodeList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libsbml.ASTNodeList_swiginit(self, _libsbml.new_ASTNodeList())
    __swig_destroy__ = _libsbml.delete_ASTNodeList

    def add(self, item):
        return _libsbml.ASTNodeList_add(self, item)

    def get(self, n):
        return _libsbml.ASTNodeList_get(self, n)

    def prepend(self, item):
        return _libsbml.ASTNodeList_prepend(self, item)

    def remove(self, n):
        return _libsbml.ASTNodeList_remove(self, n)

    def getSize(self):
        return _libsbml.ASTNodeList_getSize(self)

# Register ASTNodeList in _libsbml:
_libsbml.ASTNodeList_swigregister(ASTNodeList)

class SBMLNamespacesList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libsbml.SBMLNamespacesList_swiginit(self, _libsbml.new_SBMLNamespacesList())
    __swig_destroy__ = _libsbml.delete_SBMLNamespacesList

    def add(self, item):
        return _libsbml.SBMLNamespacesList_add(self, item)

    def get(self, n):
        return _libsbml.SBMLNamespacesList_get(self, n)

    def prepend(self, item):
        return _libsbml.SBMLNamespacesList_prepend(self, item)

    def remove(self, n):
        return _libsbml.SBMLNamespacesList_remove(self, n)

    def getSize(self):
        return _libsbml.SBMLNamespacesList_getSize(self)

# Register SBMLNamespacesList in _libsbml:
_libsbml.SBMLNamespacesList_swigregister(SBMLNamespacesList)

class SBaseList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libsbml.SBaseList_swiginit(self, _libsbml.new_SBaseList())
    __swig_destroy__ = _libsbml.delete_SBaseList

    def add(self, item):
        return _libsbml.SBaseList_add(self, item)

    def get(self, n):
        return _libsbml.SBaseList_get(self, n)

    def prepend(self, item):
        return _libsbml.SBaseList_prepend(self, item)

    def remove(self, n):
        return _libsbml.SBaseList_remove(self, n)

    def getSize(self):
        return _libsbml.SBaseList_getSize(self)

# Register SBaseList in _libsbml:
_libsbml.SBaseList_swigregister(SBaseList)



## enable optional new API2 functionality by configure or environment
if 'USE_LIBSBML_PYTHON_API2_WARNINGS' in os.environ:
    try:
        _etest = int(os.environ['USE_LIBSBML_PYTHON_API2_WARNINGS'])
    except ValueError:
        _etest = 0
        print('\nThe environment variable "USE_LIBSBML_PYTHON_API2_WARNINGS" should have the value 1 or 0\n')

    if _etest:
        USE_LIBSBML_PYTHON_API2_WARNINGS = True
    else:
        USE_LIBSBML_PYTHON_API2_WARNINGS = False

# class decorator, from six, that will be used to solve Python2/3 metaclass issues
# usage is NewClass(with_metaclass(MetaClass, BaseClasses)):
#def with_metaclass(meta, *bases):
#    """Create a base class with a metaclass.
#Usage is: NewClass(with_metaclass(MetaClass, BaseClass*)"""
# This requires a bit of explanation: the basic idea is to make a dummy
# metaclass for one level of class instantiation that replaces itself with
# the actual metaclass.
#    class metaclass(type):
#
#        def __new__(cls, name, this_bases, d):
#            return meta(name, bases, d)
#
#        @classmethod
#        def __prepare__(cls, name, this_bases):
#            return meta.__prepare__(name, bases)
#    return type.__new__(metaclass, 'temporary_class', (), {})

if USE_LIBSBML_PYTHON_API2_WARNINGS:
    import warnings
    class PythonAPI2Warning(UserWarning):
        """ Custom warning class for warnings generated by libSBML Python API2. """

        def __init__(self, msg):
            """ x.__init__(...) initializes x; see help(type(x)) for signature """
            print(msg)

    def p_func_warning_decorator(F):
        try:
            incoming_name = F.__name__
        except:
            return F
        from functools import wraps
        @wraps(F)
        def warning_wrap(*args, **kwargs):
            res = msg = None
            res = F(*args, **kwargs)
            if type(res) == int and res < 0:
                msg = '\"{}\" returns an error ({}): {}'.format(incoming_name, res,\
                                            OperationReturnValue_toString(res))
                warnings.warn(msg, category=PythonAPI2Warning)
            return res
        return warning_wrap

class AutoProperty(type):
    """
    Auto-detect Python class getX/setX methods.

    This class is attached to SBase and automatically applies for all classes
    which inherit from it.  Its purpose is to make libSBML more convenient to
    use from Python.  It works by analyzing classes at class creation time
    (not at instantiation) and adding corresponding properties (directly
    calling C methods where possible) to the class dictionary.

    @note The code should work for python 2.6 upwards, however for python 3 it
          needs to be attached via constructors.
    """
    def __new__(cls, classname, bases, classdict):
        """
        Iterate over the items in the classdict looking for get/set pairs
        and declaring them as properties.
        """
        import re
        import keyword
        import sys
        if sys.version_info < (3, 0):
          from inspect import getargspec as mygetargspec
        else:
          from inspect import getfullargspec as mygetargspec

        re_mangle = re.compile(r'[A-Za-z][a-z]+|[A-Z]+(?=$|[A-Z0-9])|\d+')
        re_id = re.compile(r'^[A-Za-z_][A-Za-z0-9_]*$')
        re_getdoc = re.compile(r'^\s*[A-Za-z_][A-Za-z0-9_]*\(self\)')
        re_setdoc = re.compile(r'^\s*[A-Za-z_][A-Za-z0-9_]*\(self,[^,)]+\)')

#convert ACapitalCasedStringXYZ123 -> a_capital_cased_string_xyz_123
        mangle_name = lambda x: ('_'.join(re_mangle.findall(x))).lower()

        get_methods = set()
        set_methods = set()
        swig_setter = classdict.get('__swig_setmethods__', {})

        if USE_LIBSBML_PYTHON_API2_WARNINGS:
# explicitly collect unsetX methods separately for method decorator
            unset_methods = set()
# collect addX and methods for method decorator
            re_addfunc = re.compile(r'add[A-Z][A-Za-z0-9_]*')
            add_methods = set()

        allowed_methods = [
            'Annotation',
            'AnnotationString',
            'Notes',
            'NotesString',
        ]

#only search for get/set methods
#we assume that any unset method also has either get or set
#a small number of set without get cases exist so we can't only
#search for get methods
        for k, v in classdict.items():
            name = k[3:]
            prefix = k[:3]
            mangled = mangle_name(name)
            if name:
                if callable(v):
                    if re_id.match(mangled) and mangled not in keyword.kwlist:
                        if prefix == 'get':
                            get_methods.add(name)
                        elif prefix == 'set':
                            set_methods.add(name)
            if USE_LIBSBML_PYTHON_API2_WARNINGS:
# find addX methods for decoration
                if re_addfunc.match(k) is not None:
                    add_methods.add(k)

        for name in get_methods | set_methods:

            mangled = mangle_name(name)

#ListOfFoobars -> foobars
            if mangled.startswith('list_of_'):
                mangled = mangled[8:]

            getter = setter = deleter = None
            if name in get_methods:
                getter = classdict['get'+name]

#this is a very dirty way of checking if the get method
#requires extra arguments (and hence cannot be a property)
#it should be possible to do this properly in SWIG?
                try:
                    argspec = mygetargspec(getter)
                    numargs = len(argspec.args)
                    if numargs > 1 or (numargs == 1 and argspec.args[0] != 'self')  \
                       or (argspec.varargs!=None and name not in allowed_methods and not name.startswith('ListOf') ):
                        continue
                except Exception:
                    continue

#use the c-level get function if the python function
#only consists of a call to it
                cname = classname + '_get' + name
#test if function is "return _libsbml.CLASS_getNAME(__args__)"
                try:
                    if getter.func_code.co_names == ('_libsbml', cname):
                        getter = getattr(_libsbml, cname)
                except:
                    if getter.__code__.co_names == ('_libsbml', cname):
                        getter = getattr(_libsbml, cname)

            if name in set_methods:
                setter = classdict['set'+name]
                try:
                    argspec = mygetargspec(getter)
                    numargs = len(argspec.args)
                    if numargs > 1 and argspec.args[0] == 'self':
                        cname = classname + '_set' + name
                        try:
                            if setter.func_code.co_names == ('_libsbml', cname):
                                setter = getattr(_libsbml, cname)
                        except:
                            if setter.__code__.co_names == ('_libsbml', cname):
                                setter = getattr(_libsbml, cname)

#property fget does not get intercepted by __getattr__
#but fset does, so we implement property setting via
#the __swig_setmethods__ dict
                        if USE_LIBSBML_PYTHON_API2_WARNINGS:
                            swig_setter[mangled] = p_func_warning_decorator(setter)
                        else:
                            swig_setter[mangled] = setter
                        continue
                except:
                    pass

            if 'unset' + name in classdict:
                deleter = classdict['unset'+name]

                try:
                    argspec = mygetargspec(getter)
                    numargs = len(argspec.args)
                    if numargs == 1 and argspec.args[0] == 'self' and \
                       (argspec.varargs==None or name in allowed_methods):
                        cname = classname + '_unset' + name
                        try:
                            if deleter.func_code.co_names == ('_libsbml', cname):
                                deleter = getattr(_libsbml, cname)
                        except:
                            if deleter.__code__.co_names == ('_libsbml', cname):
                                deleter = getattr(_libsbml, cname)
                except:
                    pass

# wrap mangled deleters
                if USE_LIBSBML_PYTHON_API2_WARNINGS:
                    unset_methods.add(name)

            if getter or setter or deleter:
#fset is technically redundant since the method is dispatched
#via _swig_setattr rather than through the property due to that
#function not delegating to object.__setattr__ which properly
#handles properties
                classdict[mangled] = property(fget=getter, fset=setter, fdel=deleter)


            def __repr__(self):
                desc = self.__class__.__name__
                if hasattr(self, '__len__'):
                    desc += '[%s]' % self.__len__()
                if hasattr(self, 'id') and self.id:
                    desc += ' %s' % self.id
                if hasattr(self, 'name') and self.name:
                    desc += ' "%s"' % self.name
                return '<' + desc + '>'

            if classdict.get('__repr__', None) in (_swig_repr, None):
                classdict['__repr__'] = __repr__

        if USE_LIBSBML_PYTHON_API2_WARNINGS:
# decorate get methods
            for gm in get_methods:
                if 'get'+gm in classdict:
                    classdict['get'+gm] = p_func_warning_decorator(classdict['get'+gm])

# decorate set methods
            for sm in set_methods:
                if 'set'+sm in classdict:
                    classdict['set'+sm] = p_func_warning_decorator(classdict['set'+sm])

# decorate unset methods
            for dm in unset_methods:
                if 'unset'+dm in classdict:
                    classdict['unset'+dm] = p_func_warning_decorator(classdict['unset'+dm])

# decorate unset methods
            if len(add_methods) > 0:
                for am in add_methods:
                    if am in classdict:
                        classdict[am] = p_func_warning_decorator(classdict[am])

        return type.__new__(cls, classname, bases, classdict)


class SwigPyIterator(object):
    r"""Proxy of C++ swig::SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_SwigPyIterator

    def value(self):
        r"""value(SwigPyIterator self) -> PyObject *"""
        return _libsbml.SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _libsbml.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _libsbml.SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _libsbml.SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _libsbml.SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(SwigPyIterator self) -> SwigPyIterator"""
        return _libsbml.SwigPyIterator_copy(self)

    def next(self):
        r"""next(SwigPyIterator self) -> PyObject *"""
        return _libsbml.SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(SwigPyIterator self) -> PyObject *"""
        return _libsbml.SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(SwigPyIterator self) -> PyObject *"""
        return _libsbml.SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _libsbml.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _libsbml.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _libsbml.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _libsbml.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _libsbml.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _libsbml.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _libsbml.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _libsbml:
_libsbml.SwigPyIterator_swigregister(SwigPyIterator)

class string(object):
    r"""Proxy of C++ std::basic_string< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def length(self):
        r"""length(string self) -> std::basic_string< char >::size_type"""
        return _libsbml.string_length(self)

    def max_size(self):
        r"""max_size(string self) -> std::basic_string< char >::size_type"""
        return _libsbml.string_max_size(self)

    def copy(self, __s, __n, __pos=0):
        r"""copy(string self, char * __s, std::basic_string< char >::size_type __n, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type"""
        return _libsbml.string_copy(self, __s, __n, __pos)

    def c_str(self):
        r"""c_str(string self) -> char const *"""
        return _libsbml.string_c_str(self)

    def find(self, *args):
        r"""
        find(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libsbml.string_find(self, *args)

    def rfind(self, *args):
        r"""
        rfind(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        rfind(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        rfind(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libsbml.string_rfind(self, *args)

    def find_first_of(self, *args):
        r"""
        find_first_of(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find_first_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_first_of(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libsbml.string_find_first_of(self, *args)

    def find_last_of(self, *args):
        r"""
        find_last_of(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        find_last_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_last_of(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libsbml.string_find_last_of(self, *args)

    def find_first_not_of(self, *args):
        r"""
        find_first_not_of(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find_first_not_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_first_not_of(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libsbml.string_find_first_not_of(self, *args)

    def find_last_not_of(self, *args):
        r"""
        find_last_not_of(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        find_last_not_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_last_not_of(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libsbml.string_find_last_not_of(self, *args)

    def substr(self, *args):
        r"""substr(string self, std::basic_string< char >::size_type __pos=0, std::basic_string< char >::size_type __n=std::basic_string< char >::npos) -> string"""
        return _libsbml.string_substr(self, *args)

    def empty(self):
        r"""empty(string self) -> bool"""
        return _libsbml.string_empty(self)

    def size(self):
        r"""size(string self) -> std::basic_string< char >::size_type"""
        return _libsbml.string_size(self)

    def swap(self, v):
        r"""swap(string self, string v)"""
        return _libsbml.string_swap(self, v)

    def erase(self, *args):
        r"""
        erase(string self, std::basic_string< char >::size_type __pos=0, std::basic_string< char >::size_type __n=std::basic_string< char >::npos) -> string
        erase(string self, std::basic_string< char >::iterator pos) -> std::basic_string< char >::iterator
        erase(string self, std::basic_string< char >::iterator first, std::basic_string< char >::iterator last) -> std::basic_string< char >::iterator
        """
        return _libsbml.string_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(string self, char const * __s, std::basic_string< char >::size_type __n) -> string
        __init__(string self) -> string
        __init__(string self, string other) -> string
        __init__(string self, std::basic_string< char >::size_type size, std::basic_string< char >::value_type value) -> string
        """
        _libsbml.string_swiginit(self, _libsbml.new_string(*args))

    def assign(self, *args):
        r"""
        assign(string self, string __str) -> string
        assign(string self, string __str, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> string
        assign(string self, char const * __s, std::basic_string< char >::size_type __n) -> string
        assign(string self, std::basic_string< char >::size_type n, std::basic_string< char >::value_type x)
        """
        return _libsbml.string_assign(self, *args)

    def resize(self, *args):
        r"""
        resize(string self, std::basic_string< char >::size_type new_size)
        resize(string self, std::basic_string< char >::size_type new_size, std::basic_string< char >::value_type x)
        """
        return _libsbml.string_resize(self, *args)

    def iterator(self):
        r"""iterator(string self) -> SwigPyIterator"""
        return _libsbml.string_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(string self) -> bool"""
        return _libsbml.string___nonzero__(self)

    def __bool__(self):
        r"""__bool__(string self) -> bool"""
        return _libsbml.string___bool__(self)

    def __len__(self):
        r"""__len__(string self) -> std::basic_string< char >::size_type"""
        return _libsbml.string___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j) -> string"""
        return _libsbml.string___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j)
        __setslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j, string v)
        """
        return _libsbml.string___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j)"""
        return _libsbml.string___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(string self, std::basic_string< char >::difference_type i)
        __delitem__(string self, PySliceObject * slice)
        """
        return _libsbml.string___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(string self, PySliceObject * slice) -> string
        __getitem__(string self, std::basic_string< char >::difference_type i) -> std::basic_string< char >::value_type
        """
        return _libsbml.string___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(string self, PySliceObject * slice, string v)
        __setitem__(string self, PySliceObject * slice)
        __setitem__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::value_type x)
        """
        return _libsbml.string___setitem__(self, *args)

    def insert(self, *args):
        r"""
        insert(string self, std::basic_string< char >::size_type __pos1, string __str) -> string
        insert(string self, std::basic_string< char >::size_type __pos1, string __str, std::basic_string< char >::size_type __pos2, std::basic_string< char >::size_type __n) -> string
        insert(string self, std::basic_string< char >::size_type __pos, char const * __s, std::basic_string< char >::size_type __n) -> string
        insert(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n, char __c) -> string
        insert(string self, std::basic_string< char >::iterator pos, std::basic_string< char >::value_type x) -> std::basic_string< char >::iterator
        insert(string self, std::basic_string< char >::iterator pos, std::basic_string< char >::size_type n, std::basic_string< char >::value_type x)
        insert(string self, std::basic_string< char >::iterator __p, std::basic_string< char >::size_type __n, char __c)
        """
        return _libsbml.string_insert(self, *args)

    def replace(self, *args):
        r"""
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n, string __str) -> string
        replace(string self, std::basic_string< char >::size_type __pos1, std::basic_string< char >::size_type __n1, string __str, std::basic_string< char >::size_type __pos2, std::basic_string< char >::size_type __n2) -> string
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n1, char const * __s, std::basic_string< char >::size_type __n2) -> string
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n1, std::basic_string< char >::size_type __n2, char __c) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, string __str) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, char const * __s, std::basic_string< char >::size_type __n) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, std::basic_string< char >::size_type __n, char __c) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, char const * __k1, char const * __k2) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, std::basic_string< char >::const_iterator __k1, std::basic_string< char >::const_iterator __k2) -> string
        """
        return _libsbml.string_replace(self, *args)

    def __iadd__(self, v):
        r"""__iadd__(string self, string v) -> string"""
        return _libsbml.string___iadd__(self, v)

    def __add__(self, v):
        r"""__add__(string self, string v) -> string"""
        return _libsbml.string___add__(self, v)

    def __radd__(self, v):
        r"""__radd__(string self, string v) -> string"""
        return _libsbml.string___radd__(self, v)

    def __str__(self):
        r"""__str__(string self) -> string"""
        return _libsbml.string___str__(self)

    def __rlshift__(self, out):
        r"""__rlshift__(string self, ostream out) -> ostream"""
        return _libsbml.string___rlshift__(self, out)

    def __eq__(self, v):
        r"""__eq__(string self, string v) -> bool"""
        return _libsbml.string___eq__(self, v)

    def __ne__(self, v):
        r"""__ne__(string self, string v) -> bool"""
        return _libsbml.string___ne__(self, v)

    def __gt__(self, v):
        r"""__gt__(string self, string v) -> bool"""
        return _libsbml.string___gt__(self, v)

    def __lt__(self, v):
        r"""__lt__(string self, string v) -> bool"""
        return _libsbml.string___lt__(self, v)

    def __ge__(self, v):
        r"""__ge__(string self, string v) -> bool"""
        return _libsbml.string___ge__(self, v)

    def __le__(self, v):
        r"""__le__(string self, string v) -> bool"""
        return _libsbml.string___le__(self, v)
    __swig_destroy__ = _libsbml.delete_string

# Register string in _libsbml:
_libsbml.string_swigregister(string)
cvar = _libsbml.cvar
string.npos = _libsbml.cvar.string_npos

class ostream(object):
    r"""Proxy of C++ std::basic_ostream< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        r"""__init__(ostream self, std::basic_streambuf< char,std::char_traits< char > > * __sb) -> ostream"""
        _libsbml.ostream_swiginit(self, _libsbml.new_ostream(__sb))
    __swig_destroy__ = _libsbml.delete_ostream

# Register ostream in _libsbml:
_libsbml.ostream_swigregister(ostream)

class ostringstream(ostream):
    r"""Proxy of C++ std::basic_ostringstream< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(ostringstream self, std::ios_base::openmode __mode=std::ios_base::out) -> ostringstream"""
        _libsbml.ostringstream_swiginit(self, _libsbml.new_ostringstream(*args))
    __swig_destroy__ = _libsbml.delete_ostringstream

    def str(self, *args):
        r"""
        str(ostringstream self) -> string
        str(ostringstream self, string __s)
        """
        return _libsbml.ostringstream_str(self, *args)

# Register ostringstream in _libsbml:
_libsbml.ostringstream_swigregister(ostringstream)


def endl(arg1):
    r"""endl(ostream arg1) -> ostream"""
    return _libsbml.endl(arg1)

def flush(arg1):
    r"""flush(ostream arg1) -> ostream"""
    return _libsbml.flush(arg1)

import sys
import os.path

# @cond doxygenLibsbmlInternal

def conditional_abspath (filename):
  """conditional_abspath (filename) -> filename

  Returns filename with an absolute path prepended, if necessary.
  Some combinations of platforms and underlying XML parsers *require*
  an absolute path to a filename while others do not.  This function
  encapsulates the appropriate logic.  It is used by readSBML() and
  SBMLReader.readSBML().
  """
  if sys.platform.find('cygwin') != -1:
    return filename
  else:
    return os.path.abspath(filename)

# @endcond


def readSBML(*args):
  """
  readSBML(self, string filename) -> SBMLDocument

  Reads an SBML document from a file.

  This method is identical to readSBMLFromFile().

  If the file named 'filename' does not exist or its content is not
  valid SBML, one or more errors will be logged with the SBMLDocument
  object returned by this method.  Callers can use the methods on
  SBMLDocument such as SBMLDocument.getNumErrors() and
  SBMLDocument.getError() to get the errors.  The object returned by
  SBMLDocument.getError() is an SBMLError object, and it has methods to
  get the error code, category, and severity level of the problem, as
  well as a textual description of the problem.  The possible severity
  levels range from informational messages to fatal errors; see the
  documentation for SBMLError for more information.

  If the file 'filename' could not be read, the file-reading error will
  appear first.  The error code can provide a clue about what happened.
  For example, a file might be unreadable (either because it does not
  actually exist or because the user does not have the necessary access
  priviledges to read it) or some sort of file operation error may have
  been reported by the underlying operating system.  Callers can check
  for these situations using a program fragment such as the following:

   reader = SBMLReader()
   doc    = reader.readSBML(filename)

   if doc.getNumErrors() > 0:
     if doc.getError(0).getErrorId() == libsbml.XMLFileUnreadable:
# Handle case of unreadable file here.
     elif doc.getError(0).getErrorId() == libsbml.XMLFileOperationError:
# Handle case of other file error here.
     else:
# Handle other error cases here.

  If the given filename ends with the suffix \".gz\" (for example,
  \"myfile.xml.gz\"), the file is assumed to be compressed in gzip format
  and will be automatically decompressed upon reading.  Similarly, if the
  given filename ends with \".zip\" or \".bz2\", the file is assumed to be
  compressed in zip or bzip2 format (respectively).  Files whose names
  lack these suffixes will be read uncompressed.  Note that if the file
  is in zip format but the archive contains more than one file, only the
  first file in the archive will be read and the rest ignored.

  To read a gzip/zip file, libSBML needs to be configured and linked with
  the zlib library at compile time.  It also needs to be linked with the
  bzip2 library to read files in bzip2 format.  (Both of these are the
  default configurations for libSBML.)  Errors about unreadable files
  will be logged if a compressed filename is given and libSBML was not
  linked with the corresponding required library.

  Parameter 'filename is the name or full pathname of the file to be
  read.

  Returns a pointer to the SBMLDocument created from the SBML content.

  See also SBMLError.

  Note:

  LibSBML versions 2.x and later versions behave differently in
  error handling in several respects.  One difference is how early some
  errors are caught and whether libSBML continues processing a file in
  the face of some early errors.  In general, libSBML versions after 2.x
  stop parsing SBML inputs sooner than libSBML version 2.x in the face
  of XML errors, because the errors may invalidate any further SBML
  content.  For example, a missing XML declaration at the beginning of
  the file was ignored by libSBML 2.x but in version 3.x and later, it
  will cause libSBML to stop parsing the rest of the input altogether.
  While this behavior may seem more severe and intolerant, it was
  necessary in order to provide uniform behavior regardless of which
  underlying XML parser (Expat, Xerces, libxml2) is being used by
  libSBML.  The XML parsers themselves behave differently in their error
  reporting, and sometimes libSBML has to resort to the lowest common
  denominator.
  """
  reader = SBMLReader()
  return reader.readSBML(args[0])

class ListWrapperSBMLNamespaces(object):
    r"""Proxy of C++ ListWrapper< SBMLNamespaces > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(ListWrapperSBMLNamespaces self) -> ListWrapperSBMLNamespaces"""
        _libsbml.ListWrapperSBMLNamespaces_swiginit(self, _libsbml.new_ListWrapperSBMLNamespaces())
    __swig_destroy__ = _libsbml.delete_ListWrapperSBMLNamespaces

    def add(self, item):
        r"""add(ListWrapperSBMLNamespaces self, SBMLNamespaces item)"""
        return _libsbml.ListWrapperSBMLNamespaces_add(self, item)

    def get(self, n):
        r"""get(ListWrapperSBMLNamespaces self, unsigned int n) -> SBMLNamespaces"""
        return _libsbml.ListWrapperSBMLNamespaces_get(self, n)

    def prepend(self, item):
        r"""prepend(ListWrapperSBMLNamespaces self, SBMLNamespaces item)"""
        return _libsbml.ListWrapperSBMLNamespaces_prepend(self, item)

    def remove(self, n):
        r"""remove(ListWrapperSBMLNamespaces self, unsigned int n) -> SBMLNamespaces"""
        return _libsbml.ListWrapperSBMLNamespaces_remove(self, n)

    def getSize(self):
        r"""getSize(ListWrapperSBMLNamespaces self) -> unsigned int"""
        return _libsbml.ListWrapperSBMLNamespaces_getSize(self)

    def __len__(self):
        r"""__len__(ListWrapperSBMLNamespaces self) -> int"""
        return _libsbml.ListWrapperSBMLNamespaces___len__(self)

    def __getitem__(self, key):

      try:
         keyIsSlice = isinstance(key, slice)
      except:
         keyIsSlice = 0

      if keyIsSlice:
        start = key.start
        if start is None:
          start = 0
        stop = key.stop
        if stop is None:
          stop = self.getSize()
        return [self[i] for i in range(
          self._fixNegativeIndex(start), self._fixNegativeIndex(stop)
        )]

      key = self._fixNegativeIndex(key)
      if key < 0 or key >= self.getSize():
        raise IndexError(key)
      return self.get(key)


    def _fixNegativeIndex(self, index):
      if index < 0:
        return index + self.getSize()
      else:
        return index


    def __iter__(self):
      for i in range(self.getSize()):
        yield self[i]


    def __repr__(self):
      return "[" + ", ".join([repr(self[i]) for i in range(len(self))]) + "]"


    def __str__(self):
      return repr(self)


# Register ListWrapperSBMLNamespaces in _libsbml:
_libsbml.ListWrapperSBMLNamespaces_swigregister(ListWrapperSBMLNamespaces)
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

class ListWrapperCVTerm(object):
    r"""Proxy of C++ ListWrapper< CVTerm > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(ListWrapperCVTerm self) -> ListWrapperCVTerm"""
        _libsbml.ListWrapperCVTerm_swiginit(self, _libsbml.new_ListWrapperCVTerm())
    __swig_destroy__ = _libsbml.delete_ListWrapperCVTerm

    def add(self, item):
        r"""add(ListWrapperCVTerm self, CVTerm item)"""
        return _libsbml.ListWrapperCVTerm_add(self, item)

    def get(self, n):
        r"""get(ListWrapperCVTerm self, unsigned int n) -> CVTerm"""
        return _libsbml.ListWrapperCVTerm_get(self, n)

    def prepend(self, item):
        r"""prepend(ListWrapperCVTerm self, CVTerm item)"""
        return _libsbml.ListWrapperCVTerm_prepend(self, item)

    def remove(self, n):
        r"""remove(ListWrapperCVTerm self, unsigned int n) -> CVTerm"""
        return _libsbml.ListWrapperCVTerm_remove(self, n)

    def getSize(self):
        r"""getSize(ListWrapperCVTerm self) -> unsigned int"""
        return _libsbml.ListWrapperCVTerm_getSize(self)

    def __len__(self):
        r"""__len__(ListWrapperCVTerm self) -> int"""
        return _libsbml.ListWrapperCVTerm___len__(self)

    def __getitem__(self, key):

      try:
         keyIsSlice = isinstance(key, slice)
      except:
         keyIsSlice = 0

      if keyIsSlice:
        start = key.start
        if start is None:
          start = 0
        stop = key.stop
        if stop is None:
          stop = self.getSize()
        return [self[i] for i in range(
          self._fixNegativeIndex(start), self._fixNegativeIndex(stop)
        )]

      key = self._fixNegativeIndex(key)
      if key < 0 or key >= self.getSize():
        raise IndexError(key)
      return self.get(key)


    def _fixNegativeIndex(self, index):
      if index < 0:
        return index + self.getSize()
      else:
        return index


    def __iter__(self):
      for i in range(self.getSize()):
        yield self[i]


    def __repr__(self):
      return "[" + ", ".join([repr(self[i]) for i in range(len(self))]) + "]"


    def __str__(self):
      return repr(self)


# Register ListWrapperCVTerm in _libsbml:
_libsbml.ListWrapperCVTerm_swigregister(ListWrapperCVTerm)

class ListWrapperDate(object):
    r"""Proxy of C++ ListWrapper< Date > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(ListWrapperDate self) -> ListWrapperDate"""
        _libsbml.ListWrapperDate_swiginit(self, _libsbml.new_ListWrapperDate())
    __swig_destroy__ = _libsbml.delete_ListWrapperDate

    def add(self, item):
        r"""add(ListWrapperDate self, Date item)"""
        return _libsbml.ListWrapperDate_add(self, item)

    def get(self, n):
        r"""get(ListWrapperDate self, unsigned int n) -> Date"""
        return _libsbml.ListWrapperDate_get(self, n)

    def prepend(self, item):
        r"""prepend(ListWrapperDate self, Date item)"""
        return _libsbml.ListWrapperDate_prepend(self, item)

    def remove(self, n):
        r"""remove(ListWrapperDate self, unsigned int n) -> Date"""
        return _libsbml.ListWrapperDate_remove(self, n)

    def getSize(self):
        r"""getSize(ListWrapperDate self) -> unsigned int"""
        return _libsbml.ListWrapperDate_getSize(self)

    def __len__(self):
        r"""__len__(ListWrapperDate self) -> int"""
        return _libsbml.ListWrapperDate___len__(self)

    def __getitem__(self, key):

      try:
         keyIsSlice = isinstance(key, slice)
      except:
         keyIsSlice = 0

      if keyIsSlice:
        start = key.start
        if start is None:
          start = 0
        stop = key.stop
        if stop is None:
          stop = self.getSize()
        return [self[i] for i in range(
          self._fixNegativeIndex(start), self._fixNegativeIndex(stop)
        )]

      key = self._fixNegativeIndex(key)
      if key < 0 or key >= self.getSize():
        raise IndexError(key)
      return self.get(key)


    def _fixNegativeIndex(self, index):
      if index < 0:
        return index + self.getSize()
      else:
        return index


    def __iter__(self):
      for i in range(self.getSize()):
        yield self[i]


    def __repr__(self):
      return "[" + ", ".join([repr(self[i]) for i in range(len(self))]) + "]"


    def __str__(self):
      return repr(self)


# Register ListWrapperDate in _libsbml:
_libsbml.ListWrapperDate_swigregister(ListWrapperDate)

class ListWrapperModelCreator(object):
    r"""Proxy of C++ ListWrapper< ModelCreator > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(ListWrapperModelCreator self) -> ListWrapperModelCreator"""
        _libsbml.ListWrapperModelCreator_swiginit(self, _libsbml.new_ListWrapperModelCreator())
    __swig_destroy__ = _libsbml.delete_ListWrapperModelCreator

    def add(self, item):
        r"""add(ListWrapperModelCreator self, ModelCreator item)"""
        return _libsbml.ListWrapperModelCreator_add(self, item)

    def get(self, n):
        r"""get(ListWrapperModelCreator self, unsigned int n) -> ModelCreator"""
        return _libsbml.ListWrapperModelCreator_get(self, n)

    def prepend(self, item):
        r"""prepend(ListWrapperModelCreator self, ModelCreator item)"""
        return _libsbml.ListWrapperModelCreator_prepend(self, item)

    def remove(self, n):
        r"""remove(ListWrapperModelCreator self, unsigned int n) -> ModelCreator"""
        return _libsbml.ListWrapperModelCreator_remove(self, n)

    def getSize(self):
        r"""getSize(ListWrapperModelCreator self) -> unsigned int"""
        return _libsbml.ListWrapperModelCreator_getSize(self)

    def __len__(self):
        r"""__len__(ListWrapperModelCreator self) -> int"""
        return _libsbml.ListWrapperModelCreator___len__(self)

    def __getitem__(self, key):

      try:
         keyIsSlice = isinstance(key, slice)
      except:
         keyIsSlice = 0

      if keyIsSlice:
        start = key.start
        if start is None:
          start = 0
        stop = key.stop
        if stop is None:
          stop = self.getSize()
        return [self[i] for i in range(
          self._fixNegativeIndex(start), self._fixNegativeIndex(stop)
        )]

      key = self._fixNegativeIndex(key)
      if key < 0 or key >= self.getSize():
        raise IndexError(key)
      return self.get(key)


    def _fixNegativeIndex(self, index):
      if index < 0:
        return index + self.getSize()
      else:
        return index


    def __iter__(self):
      for i in range(self.getSize()):
        yield self[i]


    def __repr__(self):
      return "[" + ", ".join([repr(self[i]) for i in range(len(self))]) + "]"


    def __str__(self):
      return repr(self)


# Register ListWrapperModelCreator in _libsbml:
_libsbml.ListWrapperModelCreator_swigregister(ListWrapperModelCreator)

class ListWrapperSBase(object):
    r"""Proxy of C++ ListWrapper< SBase > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(ListWrapperSBase self) -> ListWrapperSBase"""
        _libsbml.ListWrapperSBase_swiginit(self, _libsbml.new_ListWrapperSBase())
    __swig_destroy__ = _libsbml.delete_ListWrapperSBase

    def add(self, item):
        r"""add(ListWrapperSBase self, SBase item)"""
        return _libsbml.ListWrapperSBase_add(self, item)

    def get(self, n):
        r"""get(ListWrapperSBase self, unsigned int n) -> SBase"""
        return _libsbml.ListWrapperSBase_get(self, n)

    def prepend(self, item):
        r"""prepend(ListWrapperSBase self, SBase item)"""
        return _libsbml.ListWrapperSBase_prepend(self, item)

    def remove(self, n):
        r"""remove(ListWrapperSBase self, unsigned int n) -> SBase"""
        return _libsbml.ListWrapperSBase_remove(self, n)

    def getSize(self):
        r"""getSize(ListWrapperSBase self) -> unsigned int"""
        return _libsbml.ListWrapperSBase_getSize(self)

    def __len__(self):
        r"""__len__(ListWrapperSBase self) -> int"""
        return _libsbml.ListWrapperSBase___len__(self)

    def __getitem__(self, key):

      try:
         keyIsSlice = isinstance(key, slice)
      except:
         keyIsSlice = 0

      if keyIsSlice:
        start = key.start
        if start is None:
          start = 0
        stop = key.stop
        if stop is None:
          stop = self.getSize()
        return [self[i] for i in range(
          self._fixNegativeIndex(start), self._fixNegativeIndex(stop)
        )]

      key = self._fixNegativeIndex(key)
      if key < 0 or key >= self.getSize():
        raise IndexError(key)
      return self.get(key)


    def _fixNegativeIndex(self, index):
      if index < 0:
        return index + self.getSize()
      else:
        return index


    def __iter__(self):
      for i in range(self.getSize()):
        yield self[i]


    def __repr__(self):
      return "[" + ", ".join([repr(self[i]) for i in range(len(self))]) + "]"


    def __str__(self):
      return repr(self)


# Register ListWrapperSBase in _libsbml:
_libsbml.ListWrapperSBase_swigregister(ListWrapperSBase)

LIBSBML_DOTTED_VERSION = _libsbml.LIBSBML_DOTTED_VERSION

LIBSBML_VERSION = _libsbml.LIBSBML_VERSION

LIBSBML_VERSION_STRING = _libsbml.LIBSBML_VERSION_STRING


def getLibSBMLVersion():
    r"""
    getLibSBMLVersion() -> int

    Returns the version number of this copy of libSBML as an integer.

    Returns the libSBML version as an integer; version 1.2.3 becomes
    10203.

    """
    return _libsbml.getLibSBMLVersion()

def getLibSBMLDottedVersion():
    r"""
    getLibSBMLDottedVersion() -> char const *

    Returns the version number of this copy of libSBML as a string.

    Returns the libSBML version as a string; version 1.2.3 becomes
    '1.2.3'.

    See also getLibSBMLVersionString().

    """
    return _libsbml.getLibSBMLDottedVersion()

def getLibSBMLVersionString():
    r"""
    getLibSBMLVersionString() -> char const *

    Returns the version number of this copy of libSBML as a string without
    periods.

    Returns the libSBML version as a string: version 1.2.3 becomes
    '10203'.

    See also getLibSBMLDottedVersion().

    """
    return _libsbml.getLibSBMLVersionString()

def isLibSBMLCompiledWith(option):
    r"""
    isLibSBMLCompiledWith(char const * option) -> int

    Returns an indication whether libSBML has been compiled with against a
    specific library.

    Parameter 'option' is the library to test against, this can be one of
    'expat', 'libxml', 'xerces-c', 'bzip2', 'zip'

    Returns 0 in case the libSBML has not been compiled against  that
    library and nonzero otherwise (for libraries  that define an integer
    version number that number will  be returned).

    See also getLibSBMLDependencyVersionOf().

    """
    return _libsbml.isLibSBMLCompiledWith(option)

def getLibSBMLDependencyVersionOf(option):
    r"""
    getLibSBMLDependencyVersionOf(char const * option) -> char const *

    Returns the version string for the dependency library used.

    Parameter 'option' is the library for which the version should be
    retrieved, this can be one of 'expat', 'libxml', 'xerces-c', 'bzip2',
    'zip'

    Returns None in case libSBML has not been compiled against  that
    library and a version string otherwise.

    See also isLibSBMLCompiledWith().

    """
    return _libsbml.getLibSBMLDependencyVersionOf(option)
LIBSBML_OPERATION_SUCCESS = _libsbml.LIBSBML_OPERATION_SUCCESS

LIBSBML_INDEX_EXCEEDS_SIZE = _libsbml.LIBSBML_INDEX_EXCEEDS_SIZE

LIBSBML_UNEXPECTED_ATTRIBUTE = _libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE

LIBSBML_OPERATION_FAILED = _libsbml.LIBSBML_OPERATION_FAILED

LIBSBML_INVALID_ATTRIBUTE_VALUE = _libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE

LIBSBML_INVALID_OBJECT = _libsbml.LIBSBML_INVALID_OBJECT

LIBSBML_DUPLICATE_OBJECT_ID = _libsbml.LIBSBML_DUPLICATE_OBJECT_ID

LIBSBML_LEVEL_MISMATCH = _libsbml.LIBSBML_LEVEL_MISMATCH

LIBSBML_VERSION_MISMATCH = _libsbml.LIBSBML_VERSION_MISMATCH

LIBSBML_INVALID_XML_OPERATION = _libsbml.LIBSBML_INVALID_XML_OPERATION

LIBSBML_NAMESPACES_MISMATCH = _libsbml.LIBSBML_NAMESPACES_MISMATCH

LIBSBML_DUPLICATE_ANNOTATION_NS = _libsbml.LIBSBML_DUPLICATE_ANNOTATION_NS

LIBSBML_ANNOTATION_NAME_NOT_FOUND = _libsbml.LIBSBML_ANNOTATION_NAME_NOT_FOUND

LIBSBML_ANNOTATION_NS_NOT_FOUND = _libsbml.LIBSBML_ANNOTATION_NS_NOT_FOUND

LIBSBML_MISSING_METAID = _libsbml.LIBSBML_MISSING_METAID

LIBSBML_DEPRECATED_ATTRIBUTE = _libsbml.LIBSBML_DEPRECATED_ATTRIBUTE

LIBSBML_USE_ID_ATTRIBUTE_FUNCTION = _libsbml.LIBSBML_USE_ID_ATTRIBUTE_FUNCTION

LIBSBML_PKG_VERSION_MISMATCH = _libsbml.LIBSBML_PKG_VERSION_MISMATCH

LIBSBML_PKG_UNKNOWN = _libsbml.LIBSBML_PKG_UNKNOWN

LIBSBML_PKG_UNKNOWN_VERSION = _libsbml.LIBSBML_PKG_UNKNOWN_VERSION

LIBSBML_PKG_DISABLED = _libsbml.LIBSBML_PKG_DISABLED

LIBSBML_PKG_CONFLICTED_VERSION = _libsbml.LIBSBML_PKG_CONFLICTED_VERSION

LIBSBML_PKG_CONFLICT = _libsbml.LIBSBML_PKG_CONFLICT

LIBSBML_CONV_INVALID_TARGET_NAMESPACE = _libsbml.LIBSBML_CONV_INVALID_TARGET_NAMESPACE

LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE = _libsbml.LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE

LIBSBML_CONV_INVALID_SRC_DOCUMENT = _libsbml.LIBSBML_CONV_INVALID_SRC_DOCUMENT

LIBSBML_CONV_CONVERSION_NOT_AVAILABLE = _libsbml.LIBSBML_CONV_CONVERSION_NOT_AVAILABLE

LIBSBML_CONV_PKG_CONSIDERED_UNKNOWN = _libsbml.LIBSBML_CONV_PKG_CONSIDERED_UNKNOWN


def OperationReturnValue_toString(returnValue):
    r"""
    OperationReturnValue_toString(int returnValue) -> char const *

    This method takes an SBML operation return value and returns a string
    representing the code.

    Parameter 'returnValue' is the operation return value to convert to a
    string.

    Returns a human readable name for the given operation return value .

    Note: The caller does not own the returned string and is therefore not
    allowed to modify it.

    """
    return _libsbml.OperationReturnValue_toString(returnValue)
class IdList(object):
    r"""

    Internal implementation method.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(IdList self) -> IdList
        __init__(IdList self, string commaSeparated) -> IdList

        Internal implementation method.

        """
        _libsbml.IdList_swiginit(self, _libsbml.new_IdList(*args))

    def append(self, id):
        r"""
        append(IdList self, string id)

        Internal implementation method.

        """
        return _libsbml.IdList_append(self, id)

    def contains(self, id):
        r"""
        contains(IdList self, string id) -> bool

        Internal implementation method.

        """
        return _libsbml.IdList_contains(self, id)

    def empty(self):
        r"""
        empty(IdList self) -> bool

        Internal implementation method.

        """
        return _libsbml.IdList_empty(self)

    def removeIdsBefore(self, id):
        r"""
        removeIdsBefore(IdList self, string id)

        Internal implementation method.

        """
        return _libsbml.IdList_removeIdsBefore(self, id)

    def size(self):
        r"""
        size(IdList self) -> unsigned int

        Internal implementation method.

        """
        return _libsbml.IdList_size(self)

    def clear(self):
        r"""clear(IdList self)"""
        return _libsbml.IdList_clear(self)

    def at(self, n):
        r"""at(IdList self, int n) -> string"""
        return _libsbml.IdList_at(self, n)
    __swig_destroy__ = _libsbml.delete_IdList

# Register IdList in _libsbml:
_libsbml.IdList_swigregister(IdList)

class IdentifierTransformer(object):
    r"""

    Internal implementation method.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(IdentifierTransformer self) -> IdentifierTransformer

        Internal implementation method.

        """
        if self.__class__ == IdentifierTransformer:
            _self = None
        else:
            _self = self
        _libsbml.IdentifierTransformer_swiginit(self, _libsbml.new_IdentifierTransformer(_self, ))
    __swig_destroy__ = _libsbml.delete_IdentifierTransformer

    def transform(self, element):
        r"""transform(IdentifierTransformer self, SBase element) -> int"""
        return _libsbml.IdentifierTransformer_transform(self, element)
    def __disown__(self):
        self.this.disown()
        _libsbml.disown_IdentifierTransformer(self)
        return weakref.proxy(self)

# Register IdentifierTransformer in _libsbml:
_libsbml.IdentifierTransformer_swigregister(IdentifierTransformer)

class ElementFilter(object):
    r"""

    Base class for filter functions.

    This class of objects is defined by libSBML only and has no direct
    equivalent in terms of SBML components.  It is a class used in the
    implementation of extra functionality provided by libSBML.

    Some libSBML objects provide the ability to return lists of
    components. To provide callers with greater control over exactly what
    is returned, these methods take optional arguments in the form of
    filters. The ElementFilter class is the parent class for these
    filters.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(ElementFilter self) -> ElementFilter

        Creates a new ElementFilter object.

        """
        if self.__class__ == ElementFilter:
            _self = None
        else:
            _self = self
        _libsbml.ElementFilter_swiginit(self, _libsbml.new_ElementFilter(_self, ))
    __swig_destroy__ = _libsbml.delete_ElementFilter

    def filter(self, element):
        r"""
        filter(ElementFilter self, SBase element) -> bool

        Predicate to test elements.

        This is the central predicate of the ElementFilter class.  In
        subclasses of ElementFilter, callers should implement this method such
        that it returns 'True' for 'element' arguments that are 'desirable'
        and 'False' for those that are 'undesirable' in whatever filtering
        context the ElementFilter subclass is designed to be used.

        Parameter 'element' is the element to be tested.

        Returns 'True' if the 'element' is desirable or should be kept,
        'False' otherwise.

        """
        return _libsbml.ElementFilter_filter(self, element)
    def __disown__(self):
        self.this.disown()
        _libsbml.disown_ElementFilter(self)
        return weakref.proxy(self)

# Register ElementFilter in _libsbml:
_libsbml.ElementFilter_swigregister(ElementFilter)

class SBMLReader(object):
    r"""

    File and text-string SBML reader.

    This class of objects is defined by libSBML only and has no direct
    equivalent in terms of SBML components.  This class is not prescribed
    by the SBML specifications, although it is used to implement features
    defined in SBML.

    The SBMLReader class provides the main interface for reading SBML
    content from files and strings.  The methods for reading SBML all
    return an SBMLDocument object representing the results.  In the case
    of failures (such as if the SBML contains errors or a file cannot be
    read), the errors will be recorded with the SBMLErrorLog object kept
    in the SBMLDocument returned by SBMLReader.  Consequently, immediately
    after calling a method on SBMLReader, callers should always check for
    errors and warnings using the methods for this purpose provided by
    SBMLDocument.

    For convenience as well as easy access from other languages besides
    C++, this file also defines two global functions,
    @sbmlglobalfunction{readSBML, String} and
    @sbmlglobalfunction{readSBMLFromString, String}.  They are equivalent
    to creating an SBMLReader object and then calling the
    SBMLReader.readSBML() and SBMLReader.readSBMLFromString() methods,
    respectively.

    Support for reading compressed files
    ======================================================================

    LibSBML provides support for reading (as well as writing) compressed
    SBML files.  The process is transparent to the calling application---
    the application does not need to do anything deliberate to invoke the
    functionality.  If a given SBML filename ends with an extension for
    the gzip, zip or bzip2 compression formats (respectively, '.gz,'
    '.zip,' or '.bz2),' then the methods SBMLReader.readSBML() and
    SBMLWriter.writeSBML() will automatically decompress and compress the
    file while reading and writing it.  If the filename has no such
    extension, it will be read and written uncompressed as normal.

    The compression feature requires that the zlib (for gzip and zip
    formats) and/or bzip2 (for bzip2 format) be available on the system
    running libSBML, and that libSBML was configured with their support
    compiled-in.  Please see the libSBML installation instructions for
    more information about this.  The methods hasZlib() and hasBzip2() can
    be used by an application to query at run-time whether support for the
    compression libraries is available in the present copy of libSBML.

    Support for compression is not mandated by the SBML standard, but
    applications may find it helpful, particularly when large SBML models
    are being communicated across data links of limited bandwidth.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(SBMLReader self) -> SBMLReader

        Creates a new SBMLReader object and returns it.

        The libSBML SBMLReader object offers methods for reading SBML in XML
        form from files and text strings.

        """
        _libsbml.SBMLReader_swiginit(self, _libsbml.new_SBMLReader())
    __swig_destroy__ = _libsbml.delete_SBMLReader

    def readSBML(*args):
      """
      readSBML(self, string filename) -> SBMLDocument

      Reads an SBML document from a file.

      This method is identical to readSBMLFromFile().

      If the file named 'filename' does not exist or its content is not
      valid SBML, one or more errors will be logged with the SBMLDocument
      object returned by this method.  Callers can use the methods on
      SBMLDocument such as SBMLDocument.getNumErrors() and
      SBMLDocument.getError() to get the errors.  The object returned by
      SBMLDocument.getError() is an SBMLError object, and it has methods to
      get the error code, category, and severity level of the problem, as
      well as a textual description of the problem.  The possible severity
      levels range from informational messages to fatal errors; see the
      documentation for SBMLError for more information.

      If the file 'filename' could not be read, the file-reading error will
      appear first.  The error code can provide a clue about what happened.
      For example, a file might be unreadable (either because it does not
      actually exist or because the user does not have the necessary access
      priviledges to read it) or some sort of file operation error may have
      been reported by the underlying operating system.  Callers can check
      for these situations using a program fragment such as the following:

       reader = SBMLReader()
       doc    = reader.readSBML(filename)

       if doc.getNumErrors() > 0:
         if doc.getError(0).getErrorId() == libsbml.XMLFileUnreadable:
    # Handle case of unreadable file here.
         elif doc.getError(0).getErrorId() == libsbml.XMLFileOperationError:
    # Handle case of other file error here.
         else:
    # Handle other error cases here.

      If the given filename ends with the suffix \".gz\" (for example,
      \"myfile.xml.gz\"), the file is assumed to be compressed in gzip format
      and will be automatically decompressed upon reading.  Similarly, if the
      given filename ends with \".zip\" or \".bz2\", the file is assumed to be
      compressed in zip or bzip2 format (respectively).  Files whose names
      lack these suffixes will be read uncompressed.  Note that if the file
      is in zip format but the archive contains more than one file, only the
      first file in the archive will be read and the rest ignored.

      To read a gzip/zip file, libSBML needs to be configured and linked with
      the zlib library at compile time.  It also needs to be linked with the
      bzip2 library to read files in bzip2 format.  (Both of these are the
      default configurations for libSBML.)  Errors about unreadable files
      will be logged if a compressed filename is given and libSBML was not
      linked with the corresponding required library.

      Parameter 'filename is the name or full pathname of the file to be
      read.

      Returns a pointer to the SBMLDocument created from the SBML content.

      See also SBMLError.

      Note:

      LibSBML versions 2.x and later versions behave differently in
      error handling in several respects.  One difference is how early some
      errors are caught and whether libSBML continues processing a file in
      the face of some early errors.  In general, libSBML versions after 2.x
      stop parsing SBML inputs sooner than libSBML version 2.x in the face
      of XML errors, because the errors may invalidate any further SBML
      content.  For example, a missing XML declaration at the beginning of
      the file was ignored by libSBML 2.x but in version 3.x and later, it
      will cause libSBML to stop parsing the rest of the input altogether.
      While this behavior may seem more severe and intolerant, it was
      necessary in order to provide uniform behavior regardless of which
      underlying XML parser (Expat, Xerces, libxml2) is being used by
      libSBML.  The XML parsers themselves behave differently in their error
      reporting, and sometimes libSBML has to resort to the lowest common
      denominator.
      """
      args_copy    = list(args)
      args_copy[1] = conditional_abspath(args[1])
      return _libsbml.SBMLReader_readSBML(*args_copy)



    def readSBMLFromFile(*args):
      """
      Reads an SBML document from the given file.

      If the file named 'filename' does not exist or its content is not
      valid SBML, one or more errors will be logged with the SBMLDocument
      object returned by this method.  Callers can use the methods on
      SBMLDocument such as SBMLDocument.getNumErrors() and
      SBMLDocument.getError() to get the errors.  The object returned by
      SBMLDocument.getError() is an SBMLError object, and it has methods to
      get the error code, category, and severity level of the problem, as
      well as a textual description of the problem.  The possible severity
      levels range from informational messages to fatal errors; see the
      documentation for SBMLError for more information.

      If the file 'filename' could not be read, the file-reading error will
      appear first.  The error code  can provide a clue about what happened.
      For example, a file might be unreadable (either because it does not
      actually exist or because the user does not have the necessary access
      priviledges to read it) or some sort of file operation error may have
      been reported by the underlying operating system.  Callers can check
      for these situations using a program fragment such as the following:

        reader = SBMLReader()
        if reader == None:
    # Handle the truly exceptional case of no object created here.

        doc = reader.readSBMLFromFile(filename)
        if doc.getNumErrors() > 0:
          if doc.getError(0).getErrorId() == XMLFileUnreadable:
    # Handle case of unreadable file here.
          elif doc.getError(0).getErrorId() == XMLFileOperationError:
    # Handle case of other file error here.
          else:
    # Handle other error cases here.

      If the given filename ends with the suffix '.gz' (for example,
      'myfile.xml.gz'), the file is assumed to be compressed in gzip format
      and will be automatically decompressed upon reading. Similarly, if the
      given filename ends with '.zip' or '.bz2', the file is assumed to be
      compressed in zip or bzip2 format (respectively).  Files whose names
      lack these suffixes will be read uncompressed.  Note that if the file
      is in zip format but the archive contains more than one file, only the
      first file in the archive will be read and the rest ignored.

      To read a gzip/zip file, libSBML needs to be configured and linked
      with the zlib library at compile time.  It also needs to be linked
      with the bzip2 library to read files in bzip2 format.  (Both of these
      are the default configurations for libSBML.)  Errors about unreadable
      files will be logged if a compressed filename is given and libSBML was
      not linked with the corresponding required library.

      Parameter 'filename' is the name or full pathname of the file to be
      read.

      Returns a pointer to the SBMLDocument structure created from the SBML
      content in 'filename'.
      """
      args_copy    = list(args)
      args_copy[1] = conditional_abspath(args[1])
      return _libsbml.SBMLReader_readSBML(*args_copy)



    def readSBMLFromString(self, xml):
        r"""
        readSBMLFromString(SBMLReader self, string xml) -> SBMLDocument

        Reads an SBML document from a text string.

        This method is flexible with respect to the presence of an XML
        declaration at the beginning of the string.  In particular, if the
        string in 'xml' does not begin with the XML declaration

          <?xml version='1.0' encoding='UTF-8'?>

        then this method will automatically prepend the declaration to 'xml'.

        This method will log a fatal error if the content given in the
        parameter 'xml' is not in SBML format.  See the method documentation
        for SBMLReader.readSBML()

        for an example of code for testing the returned error code.

        Parameter 'xml' is a string containing a full SBML model.

        Returns a pointer to the SBMLDocument created from the SBML content,
        or a null pointer if 'xml' is 'None.'

        Note: When using this method to read an SBMLDocument that uses the
        SBML Level 3 Hierarchical Model Composition package (comp) the
        document location cannot be set automatically. Thus, if the model
        contains references to ExternalModelDefinition objects, it will be
        necessary to manually set the document URI location
        (SBMLDocument.setLocationURI()

        ) in order to facilitate resolving these models.

        See also SBMLReader.readSBML().

        """
        return _libsbml.SBMLReader_readSBMLFromString(self, xml)

    @staticmethod
    def hasZlib():
        r"""
        hasZlib() -> bool

        Static method; returns 'True' if this copy of libSBML supports gzip
        and zip format compression.

        Returns 'True' if libSBML has been linked with the zlib library,
        'False' otherwise.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also SBMLReader.hasBzip2().

        """
        return _libsbml.SBMLReader_hasZlib()

    @staticmethod
    def hasBzip2():
        r"""
        hasBzip2() -> bool

        Static method; returns 'True' if this copy of libSBML supports bzip2
        format compression.

        Returns 'True' if libSBML is linked with the bzip2 libraries, 'False'
        otherwise.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also SBMLReader.hasZlib().

        """
        return _libsbml.SBMLReader_hasBzip2()

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register SBMLReader in _libsbml:
_libsbml.SBMLReader_swigregister(SBMLReader)

def SBMLReader_hasZlib():
    r"""
    SBMLReader_hasZlib() -> bool

    Static method; returns 'True' if this copy of libSBML supports gzip
    and zip format compression.

    Returns 'True' if libSBML has been linked with the zlib library,
    'False' otherwise.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also SBMLReader.hasBzip2().

    """
    return _libsbml.SBMLReader_hasZlib()

def SBMLReader_hasBzip2():
    r"""
    SBMLReader_hasBzip2() -> bool

    Static method; returns 'True' if this copy of libSBML supports bzip2
    format compression.

    Returns 'True' if libSBML is linked with the bzip2 libraries, 'False'
    otherwise.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also SBMLReader.hasZlib().

    """
    return _libsbml.SBMLReader_hasBzip2()


def readSBMLFromFile(filename):
    r"""
    readSBMLFromFile(char const * filename) -> SBMLDocument

    Reads an SBML document from the given file.

    If the file named 'filename' does not exist or its content is not
    valid SBML, one or more errors will be logged with the SBMLDocument
    object returned by this method.  Callers can use the methods on
    SBMLDocument such as SBMLDocument.getNumErrors(),
    SBMLDocument.getNumErrors() and SBMLDocument.getError()

    to get the errors.  The object returned by SBMLDocument.getError()

    is an SBMLError object, and it has methods to get the error code,
    category, and severity level of the problem, as well as a textual
    description of the problem.  The possible severity levels range from
    informational messages to fatal errors; see the documentation for
    SBMLError for more information.

    If the file 'filename' could not be read, the file-reading error will
    appear first.  The error code  can provide a clue about what happened.
    For example, a file might be unreadable (either because it does not
    actually exist or because the user does not have the necessary access
    privileges to read it) or some sort of file operation error may have
    been reported by the underlying operating system.  Callers can check
    for these situations using a program fragment such as the following:

      reader = SBMLReader()
      if reader == None:
        # Handle the truly exceptional case of no object created here.

      doc = reader.readSBMLFromFile(filename)
      if doc.getNumErrors() > 0:
        if doc.getError(0).getErrorId() == XMLFileUnreadable:
          # Handle case of unreadable file here.
        elif doc.getError(0).getErrorId() == XMLFileOperationError:
          # Handle case of other file error here.
        else:
          # Handle other error cases here.

    If the given filename ends with the suffix ''.gz'' (for example,
    ''myfile.xml.gz'),' the file is assumed to be compressed in gzip
    format and will be automatically decompressed upon reading. Similarly,
    if the given filename ends with ''.zip'' or ''.bz2',' the file is
    assumed to be compressed in zip or bzip2 format (respectively).  Files
    whose names lack these suffixes will be read uncompressed.  Note that
    if the file is in zip format but the archive contains more than one
    file, only the first file in the archive will be read and the rest
    ignored.

    To read a gzip/zip file, libSBML needs to be configured and linked
    with the zlib library at compile time.  It also needs to be linked
    with the bzip2 library to read files in bzip2 format.  (Both of these
    are the default configurations for libSBML.)  Errors about unreadable
    files will be logged if a compressed filename is given and libSBML was
    not linked with the corresponding required library.

    Parameter 'filename' is the name or full pathname of the file to be
    read.

    Returns a pointer to the SBMLDocument structure created from the SBML
    content in 'filename'.

    """
    return _libsbml.readSBMLFromFile(filename)

def readSBMLFromString(xml):
    r"""
    readSBMLFromString(char const * xml) -> SBMLDocument

    Reads an SBML document from a text string.

    This method is flexible with respect to the presence of an XML
    declaration at the beginning of the string.  In particular, if the
    string in 'xml' does not begin with the XML declaration

      <?xml version='1.0' encoding='UTF-8'?>

    then this method will automatically prepend the declaration to 'xml'.

    This method will log a fatal error if the content given in the
    parameter 'xml' is not in SBML format.  See the method documentation
    for SBMLReader.readSBML()

    for an example of code for testing the returned error code.

    Parameter 'xml' is a string containing a full SBML model.

    Returns a pointer to the SBMLDocument structure created from the SBML
    content in 'xml'.

    Note: When using this method to read an SBMLDocument that uses the
    SBML Level 3 Hierarchical Model Composition package (comp) the
    document location cannot be set automatically. Thus, if the model
    contains references to ExternalModelDefinition objects, it will be
    necessary to manually set the document URI location
    (SBMLDocument.setLocationURI()

    ) in order to facilitate resolving these models.

    """
    return _libsbml.readSBMLFromString(xml)
class SBMLWriter(object):
    r"""

    File and text-string SBML writer.

    This class of objects is defined by libSBML only and has no direct
    equivalent in terms of SBML components.  This class is not prescribed
    by the SBML specifications, although it is used to implement features
    defined in SBML.

    The SBMLWriter class is the converse of SBMLReader, and provides the
    main interface for serializing SBML models into XML and writing the
    result to an output stream or to files and text strings.  The methods
    for writing SBML all take an SBMLDocument object and a destination.
    They return a boolean or integer value to indicate success or failure.

    Support for writing compressed files
    ======================================================================

    LibSBML provides support for writing (as well as reading) compressed
    SBML files.  The process is transparent to the calling application---
    the application does not need to do anything deliberate to invoke the
    functionality.  If a given SBML filename ends with an extension for
    the gzip, zip or bzip2 compression formats (respectively, ".gz",
    ".zip", or ".bz2"), then the methods SBMLWriter.writeSBML() and
    SBMLReader.readSBML() will automatically compress and decompress the
    file while writing and reading it.  If the filename has no such
    extension, it will be written and read uncompressed as normal.

    The compression feature requires that the zlib (for gzip and zip
    formats) and/or bzip2 (for bzip2 format) be available on the system
    running libSBML, and that libSBML was configured with their support
    compiled-in.  Please see the libSBML installation instructions for
    more information about this.  The methods SBMLWriter.hasZlib() and
    SBMLWriter.hasBzip2() can be used by an application to query at run-
    time whether support for the compression libraries is available in the
    present copy of libSBML.

    Support for compression is not mandated by the SBML standard, but
    applications may find it helpful, particularly when large SBML models
    are being communicated across data links of limited bandwidth.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        __init__(SBMLWriter self) -> SBMLWriter

        Creates a new SBMLWriter.

        The libSBML SBMLWriter objects offer methods for writing SBML in XML
        form to files and text strings.

        """
        _libsbml.SBMLWriter_swiginit(self, _libsbml.new_SBMLWriter())
    __swig_destroy__ = _libsbml.delete_SBMLWriter

    def setProgramName(self, name):
        r"""
        setProgramName(SBMLWriter self, string name) -> int

        Sets the name of this program, i.e., the program that is about to
        write out the SBMLDocument.

        If the program name and version are set (see
        SBMLWriter.setProgramVersion()), the following XML comment, intended
        for human consumption, will be written at the beginning of the XML
        document:

           <!-- Created by <program name> version <program version>
           on yyyy-MM-dd HH:mm with libSBML version <libsbml version>. -->

        If the program name and version are not set at some point before
        calling the writeSBML() methods, no such comment is written out.

        Parameter 'name' is the name of this program (where 'this program'
        refers to program in which libSBML is embedded, not libSBML itself!)

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        See also setProgramVersion().

        """
        return _libsbml.SBMLWriter_setProgramName(self, name)

    def setProgramVersion(self, version):
        r"""
        setProgramVersion(SBMLWriter self, string version) -> int

        Sets the version of this program, i.e., the program that is about to
        write out the SBMLDocument.

        If the program version and name are set (see
        SBMLWriter.setProgramName()), the following XML comment, intended for
        human consumption, will be written at the beginning of the document:

           <!-- Created by <program name> version <program version>
           on yyyy-MM-dd HH:mm with libSBML version <libsbml version>. -->

        If the program version and name are not set at some point before
        calling the writeSBML() methods, no such comment is written out.

        Parameter 'version' is the version of this program (where 'this
        program' refers to program in which libSBML is embedded, not libSBML
        itself!)

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        See also setProgramName().

        """
        return _libsbml.SBMLWriter_setProgramVersion(self, version)

    def writeSBML(self, *args):
        r"""
        writeSBML(SBMLWriter self, SBMLDocument d, string filename) -> bool
        writeSBML(SBMLWriter self, SBMLDocument d, ostream stream) -> bool

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            writeSBML(SBMLDocument d, string filename)

        Writes the given SBML document to filename.

        If the given filename ends with the suffix ".gz" (for example,
        "myfile.xml.gz"), libSBML assumes the caller wants the file to be
        written compressed in gzip format. Similarly, if the given filename
        ends with ".zip" or ".bz2", libSBML assumes the caller wants the
        file to be compressed in zip or bzip2 format (respectively). Files
        whose names lack these suffixes will be written uncompressed. Special
        considerations for the zip format: If the given filename ends with
        ".zip", the file placed in the zip archive will have the suffix
        ".xml" or ".sbml".  For example, the file in the zip archive will
        be named "test.xml" if the given filename is "test.xml.zip" or
        "test.zip". Similarly, the filename in the archive will be
        "test.sbml" if the given filename is "test.sbml.zip".

        Parameter 'd' is the SBML document to be written.

        Parameter 'filename' is the name or full pathname of the file where
        the SBML is to be written.

        Returns 'True' on success and 'False' if the filename could not be
        opened for writing.

        Note: To write a gzip/zip file, libSBML needs to be configured and
        linked with the zlib library at compile time.  It also needs to be
        linked with the bzip2 library to write files in bzip2 format.  (Both
        of these are the default configurations for libSBML.)  Errors about
        unreadable files will be logged and this method will return false if a
        compressed filename is given and libSBML was not linked with the
        corresponding required library.

        See also setProgramVersion(), setProgramName().

        ______________________________________________________________________
        Method variant with the following signature:

            writeSBML(SBMLDocument d, std::ostream& stream)

        Writes the given SBML document to the output stream.

        Parameter 'd' is the SBML document to be written.

        Parameter 'stream' is the stream object where the SBML is to be
        written.

        Returns 'True' on success and 'False' if one of the underlying parser
        components fail (rare).

        See also setProgramVersion(), setProgramName().

        """
        return _libsbml.SBMLWriter_writeSBML(self, *args)

    def writeToString(self, d):
        r"""
        writeToString(SBMLWriter self, SBMLDocument d) -> char *

        Internal implementation method.

        """
        return _libsbml.SBMLWriter_writeToString(self, d)

    def writeSBMLToFile(self, d, filename):
        r"""
        writeSBMLToFile(SBMLWriter self, SBMLDocument d, string filename) -> bool

        Writes the given SBML document to filename.

        If the given filename ends with the suffix ".gz" (for example,
        "myfile.xml.gz"), libSBML assumes the caller wants the file to be
        written compressed in gzip format. Similarly, if the given filename
        ends with ".zip" or ".bz2", libSBML assumes the caller wants the
        file to be compressed in zip or bzip2 format (respectively). Files
        whose names lack these suffixes will be written uncompressed. Special
        considerations for the zip format: If the given filename ends with
        ".zip", the file placed in the zip archive will have the suffix
        ".xml" or ".sbml".  For example, the file in the zip archive will
        be named "test.xml" if the given filename is "test.xml.zip" or
        "test.zip". Similarly, the filename in the archive will be
        "test.sbml" if the given filename is "test.sbml.zip".

        Parameter 'd' is the SBML document to be written.

        Parameter 'filename' is the name or full pathname of the file where
        the SBML is to be written.

        Returns 'True' on success and 'False' if the filename could not be
        opened for writing.

        Note: To write a gzip/zip file, libSBML needs to be configured and
        linked with the zlib library at compile time.  It also needs to be
        linked with the bzip2 library to write files in bzip2 format.  (Both
        of these are the default configurations for libSBML.)  Errors about
        unreadable files will be logged and this method will return false if a
        compressed filename is given and libSBML was not linked with the
        corresponding required library.

        See also setProgramVersion(), setProgramName().

        """
        return _libsbml.SBMLWriter_writeSBMLToFile(self, d, filename)

    def writeSBMLToString(self, d):
        r"""
        writeSBMLToString(SBMLWriter self, SBMLDocument d) -> char *

        Writes the given SBML document to an in-memory string and returns a
        pointer to it.

        The string is owned by the caller and should be freed (with 'free())'
        when no longer needed.

        Parameter 'd' is the SBML document to be written.

        Returns the string on success and '0' if one of the underlying parser
        components fail.

        See also setProgramVersion(), setProgramName().

        """
        return _libsbml.SBMLWriter_writeSBMLToString(self, d)

    @staticmethod
    def hasZlib():
        r"""
        hasZlib() -> bool

        Predicate returning 'True' if this copy of libSBML has been linked
        with the zlib library.

        LibSBML supports reading and writing files compressed with either
        bzip2 or zip/gzip compression.  The facility depends on libSBML having
        been compiled with the necessary support libraries.  This method
        allows a calling program to inquire whether that is the case for the
        copy of libSBML it is using.

        Returns 'True' if libSBML is linked with zlib, 'False' otherwise.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also SBMLWriter.hasBzip2() .

        """
        return _libsbml.SBMLWriter_hasZlib()

    @staticmethod
    def hasBzip2():
        r"""
        hasBzip2() -> bool

        Predicate returning 'True' if this copy of libSBML has been linked
        with the bzip2 library.

        LibSBML supports reading and writing files compressed with either
        bzip2 or zip/gzip compression.  The facility depends on libSBML having
        been compiled with the necessary support libraries.  This method
        allows a calling program to inquire whether that is the case for the
        copy of libSBML it is using.

        Returns 'True' if libSBML is linked with bzip2, 'False' otherwise.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also SBMLWriter.hasZlib() .

        """
        return _libsbml.SBMLWriter_hasBzip2()

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register SBMLWriter in _libsbml:
_libsbml.SBMLWriter_swigregister(SBMLWriter)

def SBMLWriter_hasZlib():
    r"""
    SBMLWriter_hasZlib() -> bool

    Predicate returning 'True' if this copy of libSBML has been linked
    with the zlib library.

    LibSBML supports reading and writing files compressed with either
    bzip2 or zip/gzip compression.  The facility depends on libSBML having
    been compiled with the necessary support libraries.  This method
    allows a calling program to inquire whether that is the case for the
    copy of libSBML it is using.

    Returns 'True' if libSBML is linked with zlib, 'False' otherwise.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also SBMLWriter.hasBzip2() .

    """
    return _libsbml.SBMLWriter_hasZlib()

def SBMLWriter_hasBzip2():
    r"""
    SBMLWriter_hasBzip2() -> bool

    Predicate returning 'True' if this copy of libSBML has been linked
    with the bzip2 library.

    LibSBML supports reading and writing files compressed with either
    bzip2 or zip/gzip compression.  The facility depends on libSBML having
    been compiled with the necessary support libraries.  This method
    allows a calling program to inquire whether that is the case for the
    copy of libSBML it is using.

    Returns 'True' if libSBML is linked with bzip2, 'False' otherwise.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also SBMLWriter.hasZlib() .

    """
    return _libsbml.SBMLWriter_hasBzip2()


def writeSBML(d, filename):
    r"""
    writeSBML(SBMLDocument d, char const * filename) -> int

    Writes the given SBML document 'd' to the file named by 'filename'.
    This convenience function is functionally equivalent to:

    SBMLWriter_writeSBML(SBMLWriter_create(), d, filename);

    If the given filename ends with the suffix ".gz" (for example,
    "myfile.xml.gz"), libSBML assumes the caller wants the file to be
    written compressed in gzip format. Similarly, if the given filename
    ends with ".zip" or ".bz2", libSBML assumes the caller wants the
    file to be compressed in zip or bzip2 format (respectively). Files
    whose names lack these suffixes will be written uncompressed. Special
    considerations for the zip format: If the given filename ends with
    ".zip", the file placed in the zip archive will have the suffix
    ".xml" or ".sbml".  For example, the file in the zip archive will
    be named "test.xml" if the given filename is "test.xml.zip" or
    "test.zip". Similarly, the filename in the archive will be
    "test.sbml" if the given filename is "test.sbml.zip".

    Parameter 'd' is the SBMLDocument object to be written out in XML
    format.

    Parameter 'filename' is a string giving the path to a file where the
    XML content is to be written.

    Returns '1' (true) on success and '0' (false) if 'filename' could not
    be written.  Some possible reasons for failure include (a) being
    unable to open the file, and (b) using a filename that indicates a
    compressed SBML file (i.e., a filename ending in ".zip" or similar)
    when the compression functionality has not been enabled in the
    underlying copy of libSBML.

    See also SBMLWriter.hasZlib(), SBMLWriter.hasBzip2().

    """
    return _libsbml.writeSBML(d, filename)

def writeSBMLToString(d):
    r"""
    writeSBMLToString(SBMLDocument d) -> char *

    Writes the given SBML document 'd' to an in-memory string and returns
    a pointer to it.  The string is owned by the caller and should be
    freed (with free()) when no longer needed.  This convenience function
    is functionally equivalent to:

    SBMLWriter_writeSBMLToString(SBMLWriter_create(), d);

    but does not require the caller to create an SBMLWriter object first.

    Parameter 'd' is an SBMLDocument object to be written out in XML
    format.

    Returns the string on success and 'None' if one of the underlying
    parser components fail.

    """
    return _libsbml.writeSBMLToString(d)

def writeSBMLToFile(d, filename):
    r"""
    writeSBMLToFile(SBMLDocument d, char const * filename) -> int

    Writes the given SBML document 'd' to the file 'filename'. This
    convenience function is functionally equivalent to:

    SBMLWriter_writeSBMLToFile(SBMLWriter_create(), d, filename);

    but that does not require the caller to create an SBMLWriter object
    first.

    If the given filename ends with the suffix ".gz" (for example,
    "myfile.xml.gz"), libSBML assumes the caller wants the file to be
    written compressed in gzip format. Similarly, if the given filename
    ends with ".zip" or ".bz2", libSBML assumes the caller wants the
    file to be compressed in zip or bzip2 format (respectively). Files
    whose names lack these suffixes will be written uncompressed. Special
    considerations for the zip format: If the given filename ends with
    ".zip", the file placed in the zip archive will have the suffix
    ".xml" or ".sbml".  For example, the file in the zip archive will
    be named "test.xml" if the given filename is "test.xml.zip" or
    "test.zip". Similarly, the filename in the archive will be
    "test.sbml" if the given filename is "test.sbml.zip".

    Parameter 'd' is an SBMLDocument object to be written out in XML
    format.

    Parameter 'filename' is a string giving the path to a file where the
    XML content is to be written.

    Returns '1' (true) on success and '0' (false) if 'filename' could not
    be written.  Some possible reasons for failure include (a) being
    unable to open the file, and (b) using a filename that indicates a
    compressed SBML file (i.e., a filename ending in ".zip" or similar)
    when the compression functionality has not been enabled in the
    underlying copy of libSBML.

    See also SBMLWriter.hasZlib(), SBMLWriter.hasBzip2().

    """
    return _libsbml.writeSBMLToFile(d, filename)
SBML_UNKNOWN = _libsbml.SBML_UNKNOWN

SBML_COMPARTMENT = _libsbml.SBML_COMPARTMENT

SBML_COMPARTMENT_TYPE = _libsbml.SBML_COMPARTMENT_TYPE

SBML_CONSTRAINT = _libsbml.SBML_CONSTRAINT

SBML_DOCUMENT = _libsbml.SBML_DOCUMENT

SBML_EVENT = _libsbml.SBML_EVENT

SBML_EVENT_ASSIGNMENT = _libsbml.SBML_EVENT_ASSIGNMENT

SBML_FUNCTION_DEFINITION = _libsbml.SBML_FUNCTION_DEFINITION

SBML_INITIAL_ASSIGNMENT = _libsbml.SBML_INITIAL_ASSIGNMENT

SBML_KINETIC_LAW = _libsbml.SBML_KINETIC_LAW

SBML_LIST_OF = _libsbml.SBML_LIST_OF

SBML_MODEL = _libsbml.SBML_MODEL

SBML_PARAMETER = _libsbml.SBML_PARAMETER

SBML_REACTION = _libsbml.SBML_REACTION

SBML_RULE = _libsbml.SBML_RULE

SBML_SPECIES = _libsbml.SBML_SPECIES

SBML_SPECIES_REFERENCE = _libsbml.SBML_SPECIES_REFERENCE

SBML_SPECIES_TYPE = _libsbml.SBML_SPECIES_TYPE

SBML_MODIFIER_SPECIES_REFERENCE = _libsbml.SBML_MODIFIER_SPECIES_REFERENCE

SBML_UNIT_DEFINITION = _libsbml.SBML_UNIT_DEFINITION

SBML_UNIT = _libsbml.SBML_UNIT

SBML_ALGEBRAIC_RULE = _libsbml.SBML_ALGEBRAIC_RULE

SBML_ASSIGNMENT_RULE = _libsbml.SBML_ASSIGNMENT_RULE

SBML_RATE_RULE = _libsbml.SBML_RATE_RULE

SBML_SPECIES_CONCENTRATION_RULE = _libsbml.SBML_SPECIES_CONCENTRATION_RULE

SBML_COMPARTMENT_VOLUME_RULE = _libsbml.SBML_COMPARTMENT_VOLUME_RULE

SBML_PARAMETER_RULE = _libsbml.SBML_PARAMETER_RULE

SBML_TRIGGER = _libsbml.SBML_TRIGGER

SBML_DELAY = _libsbml.SBML_DELAY

SBML_STOICHIOMETRY_MATH = _libsbml.SBML_STOICHIOMETRY_MATH

SBML_LOCAL_PARAMETER = _libsbml.SBML_LOCAL_PARAMETER

SBML_PRIORITY = _libsbml.SBML_PRIORITY

SBML_GENERIC_SBASE = _libsbml.SBML_GENERIC_SBASE


def SBMLTypeCode_toString(tc, pkgName):
    r"""
    SBMLTypeCode_toString(int tc, char const * pkgName) -> char const *

    This method takes an SBML type code and returns a string representing
    the code.

    LibSBML attaches an identifying code to every kind of SBML object.
    These are known as SBML type codes.  In the Python language interface
    for libSBML, the type codes are defined as static integer constants in
    the interface class 'libsbml'.  The names of the type codes all begin
    with the characters 'SBML_.'

    Returns a human readable name for the given SBML type code.

    Note: The caller does not own the returned string and is therefore not
    allowed to modify it.

    """
    return _libsbml.SBMLTypeCode_toString(tc, pkgName)
class SBase(object, metaclass=AutoProperty):
    r"""

    SBML's SBase class, base class of most SBML objects.

    Most components in SBML are derived from a single abstract base type,
    SBase.  In addition to serving as the parent class for most other
    classes of objects in SBML, this base type is designed to allow a
    modeler or a software package to attach arbitrary information to each
    major element or list in an SBML model.

    SBase has an optional subelement called 'notes'.  It is intended to
    serve as a place for storing optional information intended to be seen
    by humans.  An example use of the 'notes' element would be to contain
    formatted user comments about the model element in which the 'notes'
    element is enclosed.  There are certain conditions on the XHTML
    content permitted inside the 'notes' element; please consult the SBML
    specification document corresponding to the SBML Level and Version of
    your model for more information about the requirements for 'notes'
    content.

    SBase has another optional subelement called 'annotation'.  Whereas
    the 'notes' element described above is a container for content to be
    shown directly to humans, the 'annotation' element is a container for
    optional software-generated content not meant to be shown to humans.
    The element's content type is XML type 'any', allowing essentially
    arbitrary data content.  SBML places only a few restrictions on the
    organization of the content; these are intended to help software tools
    read and write the data as well as help reduce conflicts between
    annotations added by different tools.  As is the case with 'notes', it
    is important to refer to the SBML specification document corresponding
    to the SBML Level and Version of your model for more information about
    the requirements for 'annotation' content.

    It is worth pointing out that the 'annotation' element in the
    definition of SBase exists in order that software developers may
    attach optional application-specific data to the elements in an SBML
    model.  However, it is important that this facility not be misused.
    In particular, it is critical that data essential to a model
    definition or that can be encoded in existing SBML elements is not
    stored in 'annotation'. Parameter values, functional dependencies
    between model elements, etc., should not be recorded as annotations.
    It is crucial to keep in mind the fact that data placed in annotations
    can be freely ignored by software applications.  If such data affects
    the interpretation of a model, then software interoperability is
    greatly impeded.

    SBML Level 2 introduced an optional SBase attribute named 'metaid' for
    supporting metadata annotations using RDF (Resource Description
    Format). The attribute value has the data type XML ID, the XML
    identifier type, which means each 'metaid' value must be globally
    unique within an SBML file.  (Importantly, this uniqueness criterion
    applies across any attribute with type XML ID, not just the 'metaid'
    attribute used by SBML---something to be aware of if your application-
    specific XML content inside the 'annotation' subelement happens to use
    XML ID.)  The 'metaid' value serves to identify a model component for
    purposes such as referencing that component from metadata placed
    within 'annotation' subelements.

    Beginning with SBML Level 2 Version 2, SBase has an optional attribute
    named 'sboTerm' for supporting the use of the Systems Biology
    Ontology.  In SBML proper, the data type of the attribute is a string
    of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a seven digit integer
    number; libSBML simplifies the representation by only storing the
    'NNNNNNN' integer portion.  Thus, in libSBML, the 'sboTerm' attribute
    on SBase has data type 'int,' and SBO identifiers are stored simply as
    integers. (For convenience, SBase offers methods for returning both
    the integer form and a text-string form of the SBO identifier.)  SBO
    terms are a type of optional annotation, and each different class of
    SBML object derived from SBase imposes its own requirements about the
    values permitted for 'sboTerm'.  More details can be found in SBML
    specifications for Level 2 Version 2 and above.

    Finally, note that, in the list of methods on SBase, there is no
    public constructor because SBase is an abstract class.  The
    constructors reside in the subclasses derived from SBase.

    Standard format for annotations linking data resources
    ======================================================================

    SBML Level 2 Versions 2, 3 and 4, and Level 3, define a proposed
    regular format for encoding two particular categories of annotations:
    (a) references to controlled vocabulary terms and database identifiers
    which define and describe biological and biochemical entities in a
    model; and (b) descriptions of the provenance of a model, including
    its author(s) and modification history.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_SBase

    def clone(self):
        r"""
        clone(SBase self) -> SBase

        Creates and returns a deep copy of this SBase object.

        Returns the (deep) copy of this SBase object.

        """
        return _libsbml.SBase_clone(self)

    def getElementBySId(self, *args):
        r"""
        getElementBySId(SBase self, string id) -> SBase
        getElementBySId(SBase self, string id) -> SBase

        Returns the first child element found that has the given 'id' in the
        model-wide 'SId' namespace, or 'None' if no such object is found.

        Parameter 'id' is string representing the 'id' attribute value of the
        object to find.

        Returns pointer to the first element found with the given identifier.

        """
        return _libsbml.SBase_getElementBySId(self, *args)

    def getElementByMetaId(self, *args):
        r"""
        getElementByMetaId(SBase self, string metaid) -> SBase
        getElementByMetaId(SBase self, string metaid) -> SBase

        Returns the first child element it can find with a specific 'metaid'
        attribute value, or 'None' if no such object is found.

        The optional attribute named 'metaid', present on every major SBML
        component type, is for supporting metadata annotations using RDF
        (Resource Description Format).  The attribute value has the data type
        XML ID, the XML identifier type, which means each 'metaid' value must
        be globally unique within an SBML file.  The latter point is
        important, because the uniqueness criterion applies across any
        attribute with type ID anywhere in the file, not just the 'metaid'
        attribute used by SBML---something to be aware of if your application-
        specific XML content inside the 'annotation' subelement happens to use
        the XML ID type.  Although SBML itself specifies the use of XML ID
        only for the 'metaid' attribute, SBML-compatible applications should
        be careful if they use XML ID's in XML portions of a model that are
        not defined by SBML, such as in the application-specific content of
        the 'annotation' subelement.  Finally, note that LibSBML does not
        provide an explicit XML ID data type; it uses ordinary character
        strings, which is easier for applications to support.

        Parameter 'metaid' is string representing the 'metaid' attribute value
        of the object to find.

        Returns pointer to the first element found with the given meta-
        identifier.

        """
        return _libsbml.SBase_getElementByMetaId(self, *args)

    def renameSIdRefs(self, oldid, newid):
        r"""
        renameSIdRefs(SBase self, string oldid, string newid)

        Replaces all uses of a given 'SIdRef' type attribute value with
        another value.

        In SBML, object identifiers are of a data type called SId. In SBML
        Level 3, an explicit data type called SIdRef was introduced for
        attribute values that refer to SId values; in previous Levels of SBML,
        this data type did not exist and attributes were simply described to
        as 'referring to an identifier', but the effective data type was the
        same as SIdRef in Level 3.  These and other methods of libSBML refer
        to the type SIdRef for all Levels of SBML, even if the corresponding
        SBML specification did not explicitly name the data type.

        This method works by looking at all attributes and (if appropriate)
        mathematical formulas in MathML content, comparing the referenced
        identifiers to the value of 'oldid'.  If any matches are found, the
        matching values are replaced with 'newid'.  The method does not
        descend into child elements.

        Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
        identifier.

        """
        return _libsbml.SBase_renameSIdRefs(self, oldid, newid)

    def renameMetaIdRefs(self, oldid, newid):
        r"""
        renameMetaIdRefs(SBase self, string oldid, string newid)

        Replaces all uses of a given meta identifier attribute value with
        another value.

        In SBML, object 'meta' identifiers are of the XML data type ID; the
        SBML object attribute itself is typically named metaid.  All
        attributes that hold values referring to values of type ID are of the
        XML data type IDREF.  They are also sometimes informally referred to
        as 'metaid refs', in analogy to the SBML-defined type SIdRef.

        This method works by looking at all meta-identifier attribute values,
        comparing the identifiers to the value of 'oldid'.  If any matches are
        found, the matching identifiers are replaced with 'newid'.  The method
        does not descend into child elements.

        Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
        identifier.

        """
        return _libsbml.SBase_renameMetaIdRefs(self, oldid, newid)

    def renameUnitSIdRefs(self, oldid, newid):
        r"""
        renameUnitSIdRefs(SBase self, string oldid, string newid)

        Replaces all uses of a given 'UnitSIdRef' type attribute value with
        another value.

        In SBML, unit definitions have identifiers of type UnitSId.  In SBML
        Level 3, an explicit data type called UnitSIdRef was introduced for
        attribute values that refer to UnitSId values; in previous Levels of
        SBML, this data type did not exist and attributes were simply
        described to as 'referring to a unit identifier', but the effective
        data type was the same as UnitSIdRef in Level 3.  These and other
        methods of libSBML refer to the type UnitSIdRef for all Levels of
        SBML, even if the corresponding SBML specification did not explicitly
        name the data type.

        This method works by looking at all unit identifier attribute values
        (including, if appropriate, inside mathematical formulas), comparing
        the referenced unit identifiers to the value of 'oldid'.  If any
        matches are found, the matching values are replaced with 'newid'.  The
        method does not descend into child elements.

        Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
        identifier.

        """
        return _libsbml.SBase_renameUnitSIdRefs(self, oldid, newid)

    def replaceSIDWithFunction(self, id, function):
        r"""
        replaceSIDWithFunction(SBase self, string id, ASTNode function)

        Internal implementation method.

        """
        return _libsbml.SBase_replaceSIDWithFunction(self, id, function)

    def divideAssignmentsToSIdByFunction(self, id, function):
        r"""
        divideAssignmentsToSIdByFunction(SBase self, string id, ASTNode function)

        Internal implementation method.

        """
        return _libsbml.SBase_divideAssignmentsToSIdByFunction(self, id, function)

    def multiplyAssignmentsToSIdByFunction(self, id, function):
        r"""
        multiplyAssignmentsToSIdByFunction(SBase self, string id, ASTNode function)

        Internal implementation method.

        """
        return _libsbml.SBase_multiplyAssignmentsToSIdByFunction(self, id, function)

    def getElementFromPluginsBySId(self, id):
        r"""
        getElementFromPluginsBySId(SBase self, string id) -> SBase

        Internal implementation method.

        """
        return _libsbml.SBase_getElementFromPluginsBySId(self, id)

    def getElementFromPluginsByMetaId(self, metaid):
        r"""
        getElementFromPluginsByMetaId(SBase self, string metaid) -> SBase

        Internal implementation method.

        """
        return _libsbml.SBase_getElementFromPluginsByMetaId(self, metaid)

    def hasNonstandardIdentifierBeginningWith(self, prefix):
        r"""
        hasNonstandardIdentifierBeginningWith(SBase self, string prefix) -> bool

        Internal implementation method.

        """
        return _libsbml.SBase_hasNonstandardIdentifierBeginningWith(self, prefix)

    def prependStringToAllIdentifiers(self, prefix):
        r"""
        prependStringToAllIdentifiers(SBase self, string prefix) -> int

        Internal implementation method.

        """
        return _libsbml.SBase_prependStringToAllIdentifiers(self, prefix)

    def transformIdentifiers(self, idTransformer):
        r"""
        transformIdentifiers(SBase self, IdentifierTransformer idTransformer) -> int

        Internal implementation method.

        """
        return _libsbml.SBase_transformIdentifiers(self, idTransformer)

    def getMetaId(self):
        r"""
        getMetaId(SBase self) -> string

        Returns the value of the 'metaid' attribute of this SBML object.

        The optional attribute named 'metaid', present on every major SBML
        component type, is for supporting metadata annotations using RDF
        (Resource Description Format).  The attribute value has the data type
        XML ID, the XML identifier type, which means each 'metaid' value must
        be globally unique within an SBML file.  The latter point is
        important, because the uniqueness criterion applies across any
        attribute with type ID anywhere in the file, not just the 'metaid'
        attribute used by SBML---something to be aware of if your application-
        specific XML content inside the 'annotation' subelement happens to use
        the XML ID type.  Although SBML itself specifies the use of XML ID
        only for the 'metaid' attribute, SBML-compatible applications should
        be careful if they use XML ID's in XML portions of a model that are
        not defined by SBML, such as in the application-specific content of
        the 'annotation' subelement.  Finally, note that LibSBML does not
        provide an explicit XML ID data type; it uses ordinary character
        strings, which is easier for applications to support.

        Returns the meta-identifier of this SBML object.

        See also isSetMetaId(), setMetaId().

        """
        return _libsbml.SBase_getMetaId(self)

    def getId(self):
        r"""
        getId(SBase self) -> string

        Returns the value of the 'id' attribute of this SBML object, if it has
        one,  or the 'variable' attribute of a Rule, or the 'symbol' attribute
        of an InitialAssignment.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this SBML object, or the 'variable' if the object is
        a Rule, or the 'symbol' if the object is an InitialAssignment.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, callers should use getIdAttribute()
        instead.

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.SBase_getId(self)

    def getIdAttribute(self):
        r"""
        getIdAttribute(SBase self) -> string

        Returns the value of the 'id' attribute of this SBML object.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this SBML object, if set and valid for this level
        and version of SBML; an empty string otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, callers should use getIdAttribute()
        instead.

        See also setIdAttribute(), isSetIdAttribute(), unsetIdAttribute().

        """
        return _libsbml.SBase_getIdAttribute(self)

    def getName(self):
        r"""
        getName(SBase self) -> string

        Returns the value of the 'name' attribute of this SBML object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns the name of this SBML object, or the empty string if not set
        or unsettable.

        See also getIdAttribute(), isSetName(), setName(), unsetName().

        """
        return _libsbml.SBase_getName(self)

    def getNotes(self, *args):
        r"""
        getNotes(SBase self) -> XMLNode
        getNotes(SBase self) -> XMLNode

        Returns the content of the 'notes' subelement of this object as a tree
        of XMLNode objects.

        The optional SBML element named 'notes', present on every major SBML
        component type (and in SBML Level 3, the 'message' subelement of
        Constraint), is intended as a place for storing optional information
        intended to be seen by humans.  An example use of the 'notes' element
        would be to contain formatted user comments about the model element in
        which the 'notes' element is enclosed.  Every object derived directly
        or indirectly from type SBase can have a separate value for 'notes',
        allowing users considerable freedom when adding comments to their
        models.

        The format of 'notes' elements conform to the definition of XHTML 1.0.
        However, the content cannot be entirely free-form; it must satisfy
        certain requirements defined in the SBML specifications for specific
        SBML Levels.  To help verify the formatting of 'notes' content,
        libSBML provides the static utility method
        SyntaxChecker.hasExpectedXHTMLSyntax(); this method implements a
        verification process that lets callers check whether the content of a
        given XMLNode object conforms to the SBML requirements for 'notes' and
        'message' structure.  Developers are urged to consult the appropriate
        SBML specification document for the Level and Version of their model
        for more in-depth explanations of using 'notes' in SBML.  The SBML
        Level 2 and 3 specifications have considerable detail about how
        'notes' element content must be structured.

        The 'notes' element content returned by this method will be in XML
        form, but libSBML does not provide an object model specifically for
        the content of notes.  Callers will need to traverse the XML tree
        structure using the facilities available on XMLNode and related
        objects.  For an alternative method of accessing the notes, see
        getNotesString().

        Returns the content of the 'notes' subelement of this SBML object as a
        tree structure composed of XMLNode objects.

        See also getNotesString(), isSetNotes(), setNotes(), setNotes(),
        appendNotes(), appendNotes(), unsetNotes(),
        SyntaxChecker.hasExpectedXHTMLSyntax().

        """
        return _libsbml.SBase_getNotes(self, *args)

    def getNotesString(self, *args):
        r"""
        getNotesString(SBase self) -> string
        getNotesString(SBase self) -> string

        Returns the content of the 'notes' subelement of this object as a
        string.

        The optional SBML element named 'notes', present on every major SBML
        component type (and in SBML Level 3, the 'message' subelement of
        Constraint), is intended as a place for storing optional information
        intended to be seen by humans.  An example use of the 'notes' element
        would be to contain formatted user comments about the model element in
        which the 'notes' element is enclosed.  Every object derived directly
        or indirectly from type SBase can have a separate value for 'notes',
        allowing users considerable freedom when adding comments to their
        models.

        The format of 'notes' elements conform to the definition of XHTML 1.0.
        However, the content cannot be entirely free-form; it must satisfy
        certain requirements defined in the SBML specifications for specific
        SBML Levels.  To help verify the formatting of 'notes' content,
        libSBML provides the static utility method
        SyntaxChecker.hasExpectedXHTMLSyntax(); this method implements a
        verification process that lets callers check whether the content of a
        given XMLNode object conforms to the SBML requirements for 'notes' and
        'message' structure.  Developers are urged to consult the appropriate
        SBML specification document for the Level and Version of their model
        for more in-depth explanations of using 'notes' in SBML.  The SBML
        Level 2 and 3 specifications have considerable detail about how
        'notes' element content must be structured.

        For an alternative method of accessing the notes, see getNotes(),
        which returns the content as an XMLNode tree structure.  Depending on
        an application's needs, one or the other method may be more
        convenient.

        Returns the content of the 'notes' subelement of this SBML object as a
        string.

        See also getNotes(), isSetNotes(), setNotes(), setNotes(),
        appendNotes(), appendNotes(), unsetNotes(),
        SyntaxChecker.hasExpectedXHTMLSyntax().

        """
        return _libsbml.SBase_getNotesString(self, *args)

    def getAnnotation(self, *args):
        r"""
        getAnnotation(SBase self) -> XMLNode
        getAnnotation(SBase self) -> XMLNode

        Returns the content of the 'annotation' subelement of this object as a
        tree of XMLNode objects.

        Whereas the SBML 'notes' subelement is a container for content to be
        shown directly to humans, the 'annotation' element is a container for
        optional software-generated content not meant to be shown to humans.
        Every object derived from SBase can have its own value for
        'annotation'.  The element's content type is XML type 'any', allowing
        essentially arbitrary well-formed XML data content.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        The annotations returned by this method will be in XML form.  LibSBML
        provides an object model and related interfaces for certain specific
        kinds of annotations, namely model history information and RDF
        content.  See the ModelHistory, CVTerm and RDFAnnotationParser classes
        for more information about the facilities available.

        Returns the annotation of this SBML object as a tree of XMLNode
        objects.

        See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
        setAnnotation(), appendAnnotation(), appendAnnotation(),
        unsetAnnotation().

        """
        return _libsbml.SBase_getAnnotation(self, *args)

    def getAnnotationString(self, *args):
        r"""
        getAnnotationString(SBase self) -> string
        getAnnotationString(SBase self) -> string

        Returns the content of the 'annotation' subelement of this object as a
        character string.

        Whereas the SBML 'notes' subelement is a container for content to be
        shown directly to humans, the 'annotation' element is a container for
        optional software-generated content not meant to be shown to humans.
        Every object derived from SBase can have its own value for
        'annotation'.  The element's content type is XML type 'any', allowing
        essentially arbitrary well-formed XML data content.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        The annotations returned by this method will be in string form.  See
        the method getAnnotation() for a version that returns annotations in
        XML form.

        Returns the annotation of this SBML object as a character string.

        See also getAnnotation(), isSetAnnotation(), setAnnotation(),
        setAnnotation(), appendAnnotation(), appendAnnotation(),
        unsetAnnotation().

        """
        return _libsbml.SBase_getAnnotationString(self, *args)

    def getNamespaces(self):
        r"""
        getNamespaces(SBase self) -> XMLNamespaces

        Returns a list of the XML Namespaces declared on the SBML document
        owning this object.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.

        Returns the XML Namespaces associated with this SBML object, or 'None'
        in certain very usual circumstances where a namespace is not set.

        See also getLevel(), getVersion().

        """
        return _libsbml.SBase_getNamespaces(self)

    def getSBMLDocument(self, *args):
        r"""
        getSBMLDocument(SBase self) -> SBMLDocument
        getSBMLDocument(SBase self) -> SBMLDocument

        Returns the SBMLDocument object containing this object instance.

        LibSBML uses the class SBMLDocument as a top-level container for
        storing SBML content and data associated with it (such as warnings and
        error messages).  An SBML model in libSBML is contained inside an
        SBMLDocument object.  SBMLDocument corresponds roughly to the class
        SBML defined in the SBML Level 3 and Level 2 specifications, but it
        does not have a direct correspondence in SBML Level 1.  (But, it is
        created by libSBML no matter whether the model is Level 1, Level 2 or
        Level 3.)

        This method allows the caller to obtain the SBMLDocument for the
        current object.

        Returns the parent SBMLDocument object of this SBML object.

        See also getParentSBMLObject(), getModel().

        """
        return _libsbml.SBase_getSBMLDocument(self, *args)

    def getParentSBMLObject(self, *args):
        r"""
        getParentSBMLObject(SBase self) -> SBase
        getParentSBMLObject(SBase self) -> SBase

        Returns the parent SBML object containing this object.

        This returns the immediately-containing object.  This method is
        convenient when holding an object nested inside other objects in an
        SBML model.

        Returns the parent SBML object of this SBML object.

        See also getSBMLDocument(), getModel().

        """
        return _libsbml.SBase_getParentSBMLObject(self, *args)

    def getAncestorOfType(self, *args):
        r"""
        getAncestorOfType(SBase self, int type, string pkgName="core") -> SBase
        getAncestorOfType(SBase self, int type, string pkgName="core") -> SBase

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getAncestorOfType(int type, string pkgName = 'core')

        Returns the first ancestor object that has the given SBML type code
        from the given package.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are known as SBML type codes.  In the Python language interface
        for libSBML, the type codes are defined as static integer constants in
        the interface class 'libsbml'.  The names of the type codes all begin
        with the characters 'SBML_.'

        This method searches the tree of objects that are parents of this
        object, and returns the first one that has the given SBML type code
        from  the given 'pkgName'.

        Parameter 'type' is the SBML type code of the object sought.

        Parameter 'pkgName' is (optional) the short name of an SBML Level 3
        package to which the sought-after object must belong.

        Returns the ancestor SBML object of this SBML object that corresponds
        to the given SBML object type code, or 'None' if no ancestor exists.

        WARNING:

        The optional argument 'pkgName' must be used for all type codes from
        SBML Level 3 packages.  Otherwise, the function will search the
        'core' namespace alone, not find any corresponding elements, and
        return  None.

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        ______________________________________________________________________
        Method variant with the following signature:

            getAncestorOfType(int type, string pkgName = 'core')

        Returns the first ancestor object that has the given SBML type code
        from the given package.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are known as SBML type codes.  In the Python language interface
        for libSBML, the type codes are defined as static integer constants in
        the interface class 'libsbml'.  The names of the type codes all begin
        with the characters 'SBML_.'

        This method searches the tree of objects that are parents of this
        object, and returns the first one that has the given SBML type code
        from  the given 'pkgName'.

        Parameter 'type' is the SBML type code of the object sought.

        Parameter 'pkgName' is (optional) the short name of an SBML Level 3
        package to which the sought-after object must belong.

        Returns the ancestor SBML object of this SBML object that corresponds
        to the given SBML object type code, or 'None' if no ancestor exists.

        WARNING:

        The optional argument 'pkgName' must be used for all type codes from
        SBML Level 3 packages.  Otherwise, the function will search the
        'core' namespace alone, not find any corresponding elements, and
        return  None.

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBase_getAncestorOfType(self, *args)

    def getSBOTerm(self):
        r"""
        getSBOTerm(SBase self) -> int

        Returns the integer portion of the value of the 'sboTerm' attribute of
        this object.

        Beginning with SBML Level 2 Version 2, objects derived from SBase
        have an optional attribute named 'sboTerm' for supporting the use of
        the Systems Biology Ontology.  In SBML proper, the data type of the
        attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
        seven digit integer number; libSBML simplifies the representation by
        only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
        'sboTerm' attribute on SBase has data type 'int,' and SBO identifiers
        are stored simply as integers.

        SBO terms are a type of optional annotation, and each different class
        of SBML object derived from SBase imposes its own requirements about
        the values permitted for 'sboTerm'. More details can be found in SBML
        specifications for Level 2 Version 2 and above.

        Returns the value of the 'sboTerm' attribute as an integer, or '-1' if
        the value is not set.

        """
        return _libsbml.SBase_getSBOTerm(self)

    def getSBOTermID(self):
        r"""
        getSBOTermID(SBase self) -> string

        Returns the string representation of the 'sboTerm' attribute of this
        object.

        Beginning with SBML Level 2 Version 2, objects derived from SBase
        have an optional attribute named 'sboTerm' for supporting the use of
        the Systems Biology Ontology.  In SBML proper, the data type of the
        attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
        seven digit integer number; libSBML simplifies the representation by
        only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
        'sboTerm' attribute on SBase has data type 'int,' and SBO identifiers
        are stored simply as integers.

        SBO terms are a type of optional annotation, and each different class
        of SBML object derived from SBase imposes its own requirements about
        the values permitted for 'sboTerm'. More details can be found in SBML
        specifications for Level 2 Version 2 and above.

        Returns the value of the 'sboTerm' attribute as a string (its value
        will be of the form 'SBO:NNNNNNN'), or an empty string if the value is
        not set.

        """
        return _libsbml.SBase_getSBOTermID(self)

    def getSBOTermAsURL(self):
        r"""
        getSBOTermAsURL(SBase self) -> string

        Returns the URL representation of the 'sboTerm' attribute of this
        object.

        This method returns the entire SBO identifier as a text string in the
        form http://identifiers.org/biomodels.sbo/SBO:NNNNNNN'.

        SBO terms are a type of optional annotation, and each different class
        of SBML object derived from SBase imposes its own requirements about
        the values permitted for 'sboTerm'. More details can be found in SBML
        specifications for Level 2 Version 2 and above.

        Returns the value of the 'sboTerm' attribute as an identifiers.org
        URL, or an empty string if the value is not set.

        """
        return _libsbml.SBase_getSBOTermAsURL(self)

    def getLine(self):
        r"""
        getLine(SBase self) -> unsigned int

        Returns the line number where this object first appears in the XML
        representation of the SBML document.

        Returns the line number of this SBML object.  If this object was
        created programmatically and not read from a file, this method will
        return the value '0.'

        Note: The line number for each construct in an SBML model is set upon
        reading the model.  The accuracy of the line number depends on the
        correctness of the XML representation of the model, and on the
        particular XML parser library being used.  The former limitation
        relates to the following problem: if the model is actually invalid
        XML, then the parser may not be able to interpret the data correctly
        and consequently may not be able to establish the real line number.
        The latter limitation is simply that different parsers seem to have
        their own accuracy limitations, and out of all the parsers supported
        by libSBML, none have been 100% accurate in all situations. (At this
        time, libSBML supports the use of libxml2, Expat and Xerces.)

        See also getColumn().

        """
        return _libsbml.SBase_getLine(self)

    def getColumn(self):
        r"""
        getColumn(SBase self) -> unsigned int

        Returns the column number where this object first appears in the XML
        representation of the SBML document.

        Returns the column number of this SBML object.  If this object was
        created programmatically and not read from a file, this method will
        return the value '0.'

        Note: The column number for each construct in an SBML model is set
        upon reading the model.  The accuracy of the column number depends on
        the correctness of the XML representation of the model, and on the
        particular XML parser library being used.  The former limitation
        relates to the following problem: if the model is actually invalid
        XML, then the parser may not be able to interpret the data correctly
        and consequently may not be able to establish the real column number.
        The latter limitation is simply that different parsers seem to have
        their own accuracy limitations, and out of all the parsers supported
        by libSBML, none have been 100% accurate in all situations. (At this
        time, libSBML supports the use of libxml2, Expat and Xerces.)

        See also getLine().

        """
        return _libsbml.SBase_getColumn(self)

    def getModelHistory(self, *args):
        r"""
        getModelHistory(SBase self) -> ModelHistory
        getModelHistory(SBase self) -> ModelHistory

        Returns the ModelHistory object, if any, attached to this object.

        Returns the ModelHistory object attached to this object, or 'None' if
        none exist.

        Note: In SBML Level 2, model history annotations were only permitted
        on the Model element.  In SBML Level 3, they are permitted on all SBML
        components derived from SBase.

        """
        return _libsbml.SBase_getModelHistory(self, *args)

    def isSetMetaId(self):
        r"""
        isSetMetaId(SBase self) -> bool

        Predicate returning 'True' if this object's 'metaid' attribute is set.

        The optional attribute named 'metaid', present on every major SBML
        component type, is for supporting metadata annotations using RDF
        (Resource Description Format).  The attribute value has the data type
        XML ID, the XML identifier type, which means each 'metaid' value must
        be globally unique within an SBML file.  The latter point is
        important, because the uniqueness criterion applies across any
        attribute with type ID anywhere in the file, not just the 'metaid'
        attribute used by SBML---something to be aware of if your application-
        specific XML content inside the 'annotation' subelement happens to use
        the XML ID type.  Although SBML itself specifies the use of XML ID
        only for the 'metaid' attribute, SBML-compatible applications should
        be careful if they use XML ID's in XML portions of a model that are
        not defined by SBML, such as in the application-specific content of
        the 'annotation' subelement.  Finally, note that LibSBML does not
        provide an explicit XML ID data type; it uses ordinary character
        strings, which is easier for applications to support.

        Returns 'True' if the 'metaid' attribute of this SBML object is set,
        'False' otherwise.

        See also getMetaId(), setMetaId().

        """
        return _libsbml.SBase_isSetMetaId(self)

    def isSetId(self):
        r"""
        isSetId(SBase self) -> bool

        Predicate returning 'True' if a call to getId() returns a non-empty
        string.

        For most objects, this function will return 'True' if its 'id'
        attribute is set, and 'False' if it is not, or if the object has no
        'id' attribute at all.  However, for an EventAssignment or a Rule,
        isSetId() checks whether the 'variable' attribute is set, and for an
        InitialAssignment, it checks whether the 'symbol' attribute is set.
        Because those elements will also have an 'id' attribute in SBML Level
        3 Version 2 which isSetId() will not check, the function itself is
        deprecated, and it is recommended to use isSetIdAttribute() in all
        cases where one needs to know whether the 'id' attribute is set, and
        to use EventAssignment.isSetVariable(), Rule.isSetVariable() and
        InitialAssignment.isSetSymbol() when the status of the 'variable' or
        'symbol' attributes need to be checked.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is recommended that callers use
        isSetIdAttribute() instead.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
        isSetIdAttribute().

        """
        return _libsbml.SBase_isSetId(self)

    def isSetIdAttribute(self):
        r"""
        isSetIdAttribute(SBase self) -> bool

        Predicate returning 'True' if this object's 'id' attribute is set.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute().

        """
        return _libsbml.SBase_isSetIdAttribute(self)

    def isSetName(self):
        r"""
        isSetName(SBase self) -> bool

        Predicate returning 'True' if this object's 'name' attribute is set.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns 'True' if the 'name' attribute of this SBML object is set,
        'False' otherwise.

        See also getName(), setName(), unsetName().

        """
        return _libsbml.SBase_isSetName(self)

    def isSetNotes(self):
        r"""
        isSetNotes(SBase self) -> bool

        Predicate returning 'True' if this object's 'notes' subelement exists
        and has content.

        The optional SBML element named 'notes', present on every major SBML
        component type, is intended as a place for storing optional
        information intended to be seen by humans.  An example use of the
        'notes' element would be to contain formatted user comments about the
        model element in which the 'notes' element is enclosed.  Every object
        derived directly or indirectly from type SBase can have a separate
        value for 'notes', allowing users considerable freedom when adding
        comments to their models.

        The format of 'notes' elements must be XHTML 1.0.  To help verify the
        formatting of 'notes' content, libSBML provides the static utility
        method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
        urged to consult the appropriate SBML specification document for the
        Level and Version of their model for more in-depth explanations.  The
        SBML Level 2 and 3 specifications have considerable detail about how
        'notes' element content must be structured.

        Returns 'True' if a 'notes' subelement exists, 'False' otherwise.

        See also getNotes(), getNotesString(), setNotes(), setNotes(),
        appendNotes(), appendNotes(), unsetNotes(),
        SyntaxChecker.hasExpectedXHTMLSyntax().

        """
        return _libsbml.SBase_isSetNotes(self)

    def isSetAnnotation(self):
        r"""
        isSetAnnotation(SBase self) -> bool

        Predicate returning 'True' if this object's 'annotation' subelement
        exists and has content.

        Whereas the SBase 'notes' subelement is a container for content to be
        shown directly to humans, the 'annotation' element is a container for
        optional software-generated content not meant to be shown to humans.
        Every object derived from SBase can have its own value for
        'annotation'.  The element's content type is XML type 'any', allowing
        essentially arbitrary well-formed XML data content.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        Returns 'True' if a 'annotation' subelement exists, 'False' otherwise.

        See also getAnnotation(), getAnnotationString(), setAnnotation(),
        setAnnotation(), appendAnnotation(), appendAnnotation(),
        unsetAnnotation().

        """
        return _libsbml.SBase_isSetAnnotation(self)

    def isSetSBOTerm(self):
        r"""
        isSetSBOTerm(SBase self) -> bool

        Predicate returning 'True' if this object's 'sboTerm' attribute is
        set.

        Returns 'True' if the 'sboTerm' attribute of this SBML object is set,
        'False' otherwise.

        """
        return _libsbml.SBase_isSetSBOTerm(self)

    def setMetaId(self, metaid):
        r"""
        setMetaId(SBase self, string metaid) -> int

        Sets the value of the meta-identifier attribute of this SBML object.

        The optional attribute named 'metaid', present on every major SBML
        component type, is for supporting metadata annotations using RDF
        (Resource Description Format).  The attribute value has the data type
        XML ID, the XML identifier type, which means each 'metaid' value must
        be globally unique within an SBML file.  The latter point is
        important, because the uniqueness criterion applies across any
        attribute with type ID anywhere in the file, not just the 'metaid'
        attribute used by SBML---something to be aware of if your application-
        specific XML content inside the 'annotation' subelement happens to use
        the XML ID type.  Although SBML itself specifies the use of XML ID
        only for the 'metaid' attribute, SBML-compatible applications should
        be careful if they use XML ID's in XML portions of a model that are
        not defined by SBML, such as in the application-specific content of
        the 'annotation' subelement.  Finally, note that LibSBML does not
        provide an explicit XML ID data type; it uses ordinary character
        strings, which is easier for applications to support.

        The string 'metaid' is copied.

        Parameter 'metaid' is the identifier string to use as the value of the
        'metaid' attribute.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getMetaId(), isSetMetaId().

        """
        return _libsbml.SBase_setMetaId(self, metaid)

    def isSetModelHistory(self):
        r"""
        isSetModelHistory(SBase self) -> bool

        Predicate returning 'True' if this object has a ModelHistory object
        attached to it.

        Returns 'True' if the ModelHistory of this object is set, 'False'
        otherwise.

        Note: In SBML Level 2, model history annotations were only permitted
        on the Model element.  In SBML Level 3, they are permitted on all SBML
        components derived from SBase.

        """
        return _libsbml.SBase_isSetModelHistory(self)

    def setId(self, sid):
        r"""
        setId(SBase self, string sid) -> int

        Sets the value of the 'id' attribute of this SBML object.

        The string 'sid' is copied.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Parameter 'sid' is the string to use as the identifier of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.SBase_setId(self, sid)

    def setIdAttribute(self, sid):
        r"""
        setIdAttribute(SBase self, string sid) -> int

        Sets the value of the 'id' attribute of this SBML object.

        The string 'sid' is copied.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Parameter 'sid' is the string to use as the identifier of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.SBase_setIdAttribute(self, sid)

    def setName(self, name):
        r"""
        setName(SBase self, string name) -> int

        Sets the value of the 'name' attribute of this SBML object.

        The string in 'name' is copied.

        Parameter 'name' is the new name for the SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.SBase_setName(self, name)

    def setAnnotation(self, *args):
        r"""
        setAnnotation(SBase self, XMLNode annotation) -> int
        setAnnotation(SBase self, string annotation) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            setAnnotation(XMLNode annotation)

        Sets the value of the 'annotation' subelement of this SBML object.

        The content of 'annotation' is copied, and any previous content of
        this object's 'annotation' subelement is deleted.

        Whereas the SBase 'notes' subelement is a container for content to be
        shown directly to humans, the 'annotation' element is a container for
        optional software-generated content not meant to be shown to humans.
        Every object derived from SBase can have its own value for
        'annotation'.  The element's content type is XML type 'any', allowing
        essentially arbitrary well-formed XML data content.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        Call this method will result in any existing content of the
        'annotation' subelement to be discarded.  Unless you have taken steps
        to first copy and reconstitute any existing annotations into the
        'annotation' that is about to be assigned, it is likely that
        performing such wholesale replacement is unfriendly towards other
        software applications whose annotations are discarded.  An alternative
        may be to use SBase.appendAnnotation() or SBase.appendAnnotation().

        Parameter 'annotation' is an XML structure that is to be used as the
        new content of the 'annotation' subelement of this object.

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
        appendAnnotation(), appendAnnotation(), unsetAnnotation().

        ______________________________________________________________________
        Method variant with the following signature:

            setAnnotation(string annotation)

        Sets the value of the 'annotation' subelement of this SBML object.

        The content of 'annotation' is copied, and any previous content of
        this object's 'annotation' subelement is deleted.

        Whereas the SBase 'notes' subelement is a container for content to be
        shown directly to humans, the 'annotation' element is a container for
        optional software-generated content not meant to be shown to humans.
        Every object derived from SBase can have its own value for
        'annotation'.  The element's content type is XML type 'any', allowing
        essentially arbitrary well-formed XML data content.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        Call this method will result in any existing content of the
        'annotation' subelement to be discarded.  Unless you have taken steps
        to first copy and reconstitute any existing annotations into the
        'annotation' that is about to be assigned, it is likely that
        performing such wholesale replacement is unfriendly towards other
        software applications whose annotations are discarded.  An alternative
        may be to use SBase.appendAnnotation() or SBase.appendAnnotation().

        Parameter 'annotation' is an XML string that is to be used as the
        content of the 'annotation' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
        appendAnnotation(), appendAnnotation(), unsetAnnotation().

        """
        return _libsbml.SBase_setAnnotation(self, *args)

    def appendAnnotation(self, *args):
        r"""
        appendAnnotation(SBase self, XMLNode annotation) -> int
        appendAnnotation(SBase self, string annotation) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            appendAnnotation(XMLNode annotation)

        Appends the given 'annotation' to the 'annotation' subelement of this
        object.

        Whereas the SBase 'notes' subelement is a container for content to be
        shown directly to humans, the 'annotation' element is a container for
        optional software-generated content not meant to be shown to humans.
        Every object derived from SBase can have its own value for
        'annotation'.  The element's content type is XML type 'any', allowing
        essentially arbitrary well-formed XML data content.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        Unlike SBase.setAnnotation() or SBase.setAnnotation(), this method
        allows other annotations to be preserved when an application adds its
        own data.

        Parameter 'annotation' is an XML structure that is to be copied and
        appended to the content of the 'annotation' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_UNEXPECTED_ATTRIBUTE (if the parent element does not have
        the 'metaid' attribute set)

        * LIBSBML_DUPLICATE_ANNOTATION_NS (if the parent was already
        annotated with the annotation in question)

        See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
        setAnnotation(), appendAnnotation(), unsetAnnotation().

        ______________________________________________________________________
        Method variant with the following signature:

            appendAnnotation(string annotation)

        Appends the given 'annotation' to the 'annotation' subelement of this
        object.

        Whereas the SBase 'notes' subelement is a container for content to be
        shown directly to humans, the 'annotation' element is a container for
        optional software-generated content not meant to be shown to humans.
        Every object derived from SBase can have its own value for
        'annotation'.  The element's content type is XML type 'any', allowing
        essentially arbitrary well-formed XML data content.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        Unlike SBase.setAnnotation() or SBase.setAnnotation(), this method
        allows other annotations to be preserved when an application adds its
        own data.

        Parameter 'annotation' is an XML string that is to be copied and
        appended to the content of the 'annotation' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_UNEXPECTED_ATTRIBUTE (if the parent element does not have
        the 'metaid' attribute set)

        * LIBSBML_DUPLICATE_ANNOTATION_NS (if the parent was already
        annotated with the annotation in question)

        See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
        setAnnotation(), appendAnnotation(), unsetAnnotation().

        """
        return _libsbml.SBase_appendAnnotation(self, *args)

    def removeTopLevelAnnotationElement(self, *args):
        r"""
        removeTopLevelAnnotationElement(SBase self, string elementName, string elementURI="", bool removeEmpty=True) -> int

        Removes the top-level element within the 'annotation' subelement of
        this SBML object with the given name and optional URI.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        Calling this method allows a particular annotation element to be
        removed whilst the remaining annotations remain intact.

        Parameter 'elementName' is a string representing the name of the top
        level annotation element that is to be removed. Parameter 'elementURI'
        is an optional string that is used to check both the name and URI of
        the top level element to be removed. Parameter 'removeEmpty' is if
        after removing of the element, the annotation is  empty, and the
        removeEmpty argument is true, the annotation node will be  deleted
        (default).

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_ANNOTATION_NAME_NOT_FOUND

        * LIBSBML_ANNOTATION_NS_NOT_FOUND

        See also replaceTopLevelAnnotationElement(),
        replaceTopLevelAnnotationElement().

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBase_removeTopLevelAnnotationElement(self, *args)

    def replaceTopLevelAnnotationElement(self, *args):
        r"""
        replaceTopLevelAnnotationElement(SBase self, XMLNode annotation) -> int
        replaceTopLevelAnnotationElement(SBase self, string annotation) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            replaceTopLevelAnnotationElement(XMLNode annotation)

        Replaces the given top-level element within the 'annotation'
        subelement of this SBML object and with the annotation element
        supplied.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        This method determines the name of the element to be replaced from the
        annotation argument. Functionally it is equivalent to calling
        removeTopLevelAnnotationElement(name) followed by calling
        appendAnnotation(annotation_with_name), with the exception that the
        placement of the annotation element remains the same.

        Parameter 'annotation' is XMLNode representing the replacement top
        level annotation.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_INVALID_OBJECT

        See also removeTopLevelAnnotationElement(),
        replaceTopLevelAnnotationElement().

        ______________________________________________________________________
        Method variant with the following signature:

            replaceTopLevelAnnotationElement(string annotation)

        Replaces the given top-level element within the 'annotation'
        subelement of this SBML object and with the annotation element
        supplied.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        This method determines the name of the element to be replaced from the
        annotation argument. Functionally it is equivalent to calling
        removeTopLevelAnnotationElement(name) followed by calling
        appendAnnotation(annotation_with_name), with the exception that the
        placement of the annotation element remains the same.

        Parameter 'annotation' is string representing the replacement top
        level annotation.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_INVALID_OBJECT

        See also removeTopLevelAnnotationElement(),
        replaceTopLevelAnnotationElement().

        """
        return _libsbml.SBase_replaceTopLevelAnnotationElement(self, *args)

    def setNotes(self, *args):
        r"""
        setNotes(SBase self, XMLNode notes) -> int
        setNotes(SBase self, string notes, bool addXHTMLMarkup=False) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            setNotes(XMLNode notes)

        Sets the value of the 'notes' subelement of this SBML object.

        The content of 'notes' is copied, and any existing content of this
        object's 'notes' subelement is deleted.

        The optional SBML element named 'notes', present on every major SBML
        component type, is intended as a place for storing optional
        information intended to be seen by humans.  An example use of the
        'notes' element would be to contain formatted user comments about the
        model element in which the 'notes' element is enclosed.  Every object
        derived directly or indirectly from type SBase can have a separate
        value for 'notes', allowing users considerable freedom when adding
        comments to their models.

        The format of 'notes' elements must be XHTML 1.0.  To help verify the
        formatting of 'notes' content, libSBML provides the static utility
        method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
        urged to consult the appropriate SBML specification document for the
        Level and Version of their model for more in-depth explanations.  The
        SBML Level 2 and 3 specifications have considerable detail about how
        'notes' element content must be structured.

        Parameter 'notes' is an XML structure that is to be used as the
        content of the 'notes' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        See also getNotesString(), isSetNotes(), setNotes(), appendNotes(),
        appendNotes(), unsetNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().

        ______________________________________________________________________
        Method variant with the following signature:

            setNotes(string notes, bool addXHTMLMarkup = false)

        Sets the value of the 'notes' subelement of this SBML object to a copy
        of the string 'notes'.

        The content of 'notes' is copied, and any existing content of this
        object's 'notes' subelement is deleted.

        The optional SBML element named 'notes', present on every major SBML
        component type, is intended as a place for storing optional
        information intended to be seen by humans.  An example use of the
        'notes' element would be to contain formatted user comments about the
        model element in which the 'notes' element is enclosed.  Every object
        derived directly or indirectly from type SBase can have a separate
        value for 'notes', allowing users considerable freedom when adding
        comments to their models.

        The format of 'notes' elements must be XHTML 1.0.  To help verify the
        formatting of 'notes' content, libSBML provides the static utility
        method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
        urged to consult the appropriate SBML specification document for the
        Level and Version of their model for more in-depth explanations.  The
        SBML Level 2 and 3 specifications have considerable detail about how
        'notes' element content must be structured.

        The following code illustrates a very simple way of setting the notes
        using this method.  Here, the object being annotated is the whole SBML
        document, but that is for illustration purposes only; you could of
        course use this same approach to annotate any other SBML component.

          try:
            sbmlDoc = SBMLDocument(3, 1)
          except ValueError:
            print('Could not create SBMLDocument object')
            sys.exit(1)

          note = '<body xmlns='http://www.w3.org/1999/xhtml'><p>here is my note</p></body>'

          status = sbmlDoc.setNotes(note)
          if status != LIBSBML_OPERATION_SUCCESS:
            # Do something to handle the error here.
            print('Unable to set notes on the SBML document object')
            sys.exit(1)

        Parameter 'notes' is an XML string that is to be used as the content
        of the 'notes' subelement of this object.

        Parameter 'addXHTMLMarkup' is a boolean indicating whether to wrap the
        contents of the 'notes' argument with XHTML paragraph (<p>) tags.
        This is appropriate when the string in 'notes' does not already
        containg the appropriate XHTML markup.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        See also getNotesString(), isSetNotes(), setNotes(), appendNotes(),
        appendNotes(), unsetNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBase_setNotes(self, *args)

    def appendNotes(self, *args):
        r"""
        appendNotes(SBase self, XMLNode notes) -> int
        appendNotes(SBase self, string notes) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            appendNotes(XMLNode notes)

        Appends the given 'notes' to the 'notes' subelement of this object.

        The content of 'notes' is copied.

        The optional SBML element named 'notes', present on every major SBML
        component type, is intended as a place for storing optional
        information intended to be seen by humans.  An example use of the
        'notes' element would be to contain formatted user comments about the
        model element in which the 'notes' element is enclosed.  Every object
        derived directly or indirectly from type SBase can have a separate
        value for 'notes', allowing users considerable freedom when adding
        comments to their models.

        The format of 'notes' elements must be XHTML 1.0.  To help verify the
        formatting of 'notes' content, libSBML provides the static utility
        method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
        urged to consult the appropriate SBML specification document for the
        Level and Version of their model for more in-depth explanations.  The
        SBML Level 2 and 3 specifications have considerable detail about how
        'notes' element content must be structured.

        Parameter 'notes' is an XML node structure that is to appended to the
        content of the 'notes' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        See also getNotesString(), isSetNotes(), setNotes(), setNotes(),
        appendNotes(), unsetNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().

        ______________________________________________________________________
        Method variant with the following signature:

            appendNotes(string notes)

        Appends the given 'notes' to the 'notes' subelement of this object.

        The content of the parameter 'notes' is copied.

        The optional SBML element named 'notes', present on every major SBML
        component type, is intended as a place for storing optional
        information intended to be seen by humans.  An example use of the
        'notes' element would be to contain formatted user comments about the
        model element in which the 'notes' element is enclosed.  Every object
        derived directly or indirectly from type SBase can have a separate
        value for 'notes', allowing users considerable freedom when adding
        comments to their models.

        The format of 'notes' elements must be XHTML 1.0.  To help verify the
        formatting of 'notes' content, libSBML provides the static utility
        method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
        urged to consult the appropriate SBML specification document for the
        Level and Version of their model for more in-depth explanations.  The
        SBML Level 2 and 3 specifications have considerable detail about how
        'notes' element content must be structured.

        Parameter 'notes' is an XML string that is to appended to the content
        of the 'notes' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        See also getNotesString(), isSetNotes(), setNotes(), setNotes(),
        appendNotes(), unsetNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().

        """
        return _libsbml.SBase_appendNotes(self, *args)

    def setModelHistory(self, history):
        r"""
        setModelHistory(SBase self, ModelHistory history) -> int

        Sets the ModelHistory of this object.

        The content of 'history' is copied, and this object's existing model
        history content is deleted.

        Parameter 'history' is ModelHistory of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_INVALID_OBJECT

        Note: In SBML Level 2, model history annotations were only permitted
        on the Model element.  In SBML Level 3, they are permitted on all SBML
        components derived from SBase.

        """
        return _libsbml.SBase_setModelHistory(self, history)

    def connectToParent(self, parent):
        r"""
        connectToParent(SBase self, SBase parent)

        Internal implementation method.

        """
        return _libsbml.SBase_connectToParent(self, parent)

    def connectToChild(self):
        r"""connectToChild(SBase self)"""
        return _libsbml.SBase_connectToChild(self)

    def setSBOTerm(self, *args):
        r"""
        setSBOTerm(SBase self, int value) -> int
        setSBOTerm(SBase self, string sboid) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            setSBOTerm(int value)

        Sets the value of the 'sboTerm' attribute.

        Beginning with SBML Level 2 Version 2, objects derived from SBase
        have an optional attribute named 'sboTerm' for supporting the use of
        the Systems Biology Ontology.  In SBML proper, the data type of the
        attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
        seven digit integer number; libSBML simplifies the representation by
        only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
        'sboTerm' attribute on SBase has data type 'int,' and SBO identifiers
        are stored simply as integers.

        SBO terms are a type of optional annotation, and each different class
        of SBML object derived from SBase imposes its own requirements about
        the values permitted for 'sboTerm'. More details can be found in SBML
        specifications for Level 2 Version 2 and above.

        Parameter 'value' is the NNNNNNN integer portion of the SBO
        identifier.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also setSBOTerm().

        ______________________________________________________________________
        Method variant with the following signature:

            setSBOTerm(string &sboid)

        Sets the value of the 'sboTerm' attribute by string.

        Beginning with SBML Level 2 Version 2, objects derived from SBase
        have an optional attribute named 'sboTerm' for supporting the use of
        the Systems Biology Ontology.  In SBML proper, the data type of the
        attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
        seven digit integer number; libSBML simplifies the representation by
        only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
        'sboTerm' attribute on SBase has data type 'int,' and SBO identifiers
        are stored simply as integers.

        SBO terms are a type of optional annotation, and each different class
        of SBML object derived from SBase imposes its own requirements about
        the values permitted for 'sboTerm'. More details can be found in SBML
        specifications for Level 2 Version 2 and above.

        Parameter 'sboid' is the SBO identifier string of the form
        'SBO:NNNNNNN'.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also setSBOTerm().

        """
        return _libsbml.SBase_setSBOTerm(self, *args)

    def setNamespaces(self, xmlns):
        r"""
        setNamespaces(SBase self, XMLNamespaces xmlns) -> int

        Sets the namespaces relevant of this SBML object.

        The content of 'xmlns' is copied, and this object's existing namespace
        content is deleted.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.

        Parameter 'xmlns' is the namespaces to set.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        """
        return _libsbml.SBase_setNamespaces(self, xmlns)

    def unsetMetaId(self):
        r"""
        unsetMetaId(SBase self) -> int

        Unsets the value of the 'metaid' attribute of this SBML object.

        The optional attribute named 'metaid', present on every major SBML
        component type, is for supporting metadata annotations using RDF
        (Resource Description Format).  The attribute value has the data type
        XML ID, the XML identifier type, which means each 'metaid' value must
        be globally unique within an SBML file.  The latter point is
        important, because the uniqueness criterion applies across any
        attribute with type ID anywhere in the file, not just the 'metaid'
        attribute used by SBML---something to be aware of if your application-
        specific XML content inside the 'annotation' subelement happens to use
        the XML ID type.  Although SBML itself specifies the use of XML ID
        only for the 'metaid' attribute, SBML-compatible applications should
        be careful if they use XML ID's in XML portions of a model that are
        not defined by SBML, such as in the application-specific content of
        the 'annotation' subelement.  Finally, note that LibSBML does not
        provide an explicit XML ID data type; it uses ordinary character
        strings, which is easier for applications to support.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_OPERATION_FAILED

        """
        return _libsbml.SBase_unsetMetaId(self)

    def unsetId(self):
        r"""
        unsetId(SBase self) -> int

        Unsets the value of the 'id' attribute of this SBML object.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.SBase_unsetId(self)

    def unsetIdAttribute(self):
        r"""
        unsetIdAttribute(SBase self) -> int

        Unsets the value of the 'id' attribute of this SBML object.

        Most (but not all) objects in SBML include two common attributes: 'id'
        and 'name'.  The identifier given by an object's 'id' attribute value
        is used to identify the object within the SBML model definition. Other
        objects can refer to the component using this identifier.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute().

        """
        return _libsbml.SBase_unsetIdAttribute(self)

    def unsetName(self):
        r"""
        unsetName(SBase self) -> int

        Unsets the value of the 'name' attribute of this SBML object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getName(), setName(), isSetName().

        """
        return _libsbml.SBase_unsetName(self)

    def unsetNotes(self):
        r"""
        unsetNotes(SBase self) -> int

        Unsets the value of the 'notes' subelement of this SBML object.

        The optional SBML element named 'notes', present on every major SBML
        component type, is intended as a place for storing optional
        information intended to be seen by humans.  An example use of the
        'notes' element would be to contain formatted user comments about the
        model element in which the 'notes' element is enclosed.  Every object
        derived directly or indirectly from type SBase can have a separate
        value for 'notes', allowing users considerable freedom when adding
        comments to their models.

        The format of 'notes' elements must be XHTML 1.0.  To help verify the
        formatting of 'notes' content, libSBML provides the static utility
        method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
        urged to consult the appropriate SBML specification document for the
        Level and Version of their model for more in-depth explanations.  The
        SBML Level 2 and 3 specifications have considerable detail about how
        'notes' element content must be structured.

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        See also getNotesString(), isSetNotes(), setNotes(), setNotes(),
        appendNotes(), appendNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().

        """
        return _libsbml.SBase_unsetNotes(self)

    def unsetAnnotation(self):
        r"""
        unsetAnnotation(SBase self) -> int

        Unsets the value of the 'annotation' subelement of this SBML object.

        Whereas the SBase 'notes' subelement is a container for content to be
        shown directly to humans, the 'annotation' element is a container for
        optional software-generated content not meant to be shown to humans.
        Every object derived from SBase can have its own value for
        'annotation'.  The element's content type is XML type 'any', allowing
        essentially arbitrary well-formed XML data content.

        SBML places a few restrictions on the organization of the content of
        annotations; these are intended to help software tools read and write
        the data as well as help reduce conflicts between annotations added by
        different tools.  Please see the SBML specifications for more details.

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        See also getAnnotation(), getAnnotationString(), isSetAnnotation(),
        setAnnotation(), setAnnotation(), appendAnnotation(),
        appendAnnotation().

        """
        return _libsbml.SBase_unsetAnnotation(self)

    def unsetSBOTerm(self):
        r"""
        unsetSBOTerm(SBase self) -> int

        Unsets the value of the 'sboTerm' attribute of this SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        """
        return _libsbml.SBase_unsetSBOTerm(self)

    def addCVTerm(self, term, newBag=False):
        r"""
        addCVTerm(SBase self, CVTerm term, bool newBag=False) -> int

        Adds a copy of the given CVTerm object to this SBML object.

        Parameter 'term' is the CVTerm to assign.

        Parameter 'newBag' is if 'True,' creates a new RDF bag with the same
        identifier as a previous bag, and if 'False,' adds the term to an
        existing RDF bag with the same type of qualifier as the term being
        added.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_UNEXPECTED_ATTRIBUTE, if this object lacks a 'metaid'
        attribute

        * LIBSBML_INVALID_OBJECT

        Note: Since the CV Term uses the 'metaid' attribute of the object as a
        reference, if the object has no 'metaid' attribute value set, then the
        CVTerm will not be added.

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBase_addCVTerm(self, term, newBag)

    def getCVTerms(self):
      """
      getCVTerms(self) -> CVTermList

      Get the List of CVTerm objects in this element.

      Returns the CVTermList for this element.


      """

      cvlist = _libsbml.SBase_getCVTerms(self)
      if cvlist is None:
        return []
      else:
        return cvlist



    def getNumCVTerms(self):
        r"""
        getNumCVTerms(SBase self) -> unsigned int

        Returns the number of CVTerm objects in the annotations of this SBML
        object.

        Returns the number of CVTerms for this SBML object.

        """
        return _libsbml.SBase_getNumCVTerms(self)

    def getCVTerm(self, n):
        r"""
        getCVTerm(SBase self, unsigned int n) -> CVTerm

        Returns the nth CVTerm in the list of CVTerms of this SBML object.

        Parameter 'n' is long the index of the CVTerm to retrieve.

        Returns the nth CVTerm in the list of CVTerms for this SBML object. If
        the index 'n' is invalid, 'None' is returned.

        """
        return _libsbml.SBase_getCVTerm(self, n)

    def unsetCVTerms(self):
        r"""
        unsetCVTerms(SBase self) -> int

        Clears the list of CVTerm objects attached to this SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        """
        return _libsbml.SBase_unsetCVTerms(self)

    def unsetModelHistory(self):
        r"""
        unsetModelHistory(SBase self) -> int

        Unsets the ModelHistory object attached to this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_OPERATION_FAILED

        Note: In SBML Level 2, model history annotations were only permitted
        on the Model element.  In SBML Level 3, they are permitted on all SBML
        components derived from SBase.

        """
        return _libsbml.SBase_unsetModelHistory(self)

    def getResourceBiologicalQualifier(self, resource):
        r"""
        getResourceBiologicalQualifier(SBase self, string resource) -> BiolQualifierType_t

        Returns the MIRIAM biological qualifier associated with the given
        resource.

        In MIRIAM, qualifiers are an optional means of indicating the
        relationship between a model component and its annotations.  There are
        two broad kinds of annotations: model and biological.  The latter kind
        is used to qualify the relationship between a model component and a
        biological entity which it represents.  Examples of relationships
        include 'is' and 'has part', but many others are possible.  MIRIAM
        defines numerous relationship qualifiers to enable different software
        tools to qualify biological annotations in the same standardized way.
        In libSBML, the MIRIAM controlled-vocabulary annotations on an SBML
        model element are represented using lists of CVTerm objects, and the
        the MIRIAM biological qualifiers are represented using values whose
        names begin with BQB_ in the interface class libsbml.

        This method searches the controlled-vocabulary annotations (i.e., the
        list of CVTerm objects) on the present object, then out of those that
        have biological qualifiers, looks for an annotation to the given
        'resource'.  If such an annotation is found, it returns the type of
        biological qualifier associated with that resource as a  value whose
        name begins with BQB_ from the interface class libsbml.

        Parameter 'resource' is string representing the resource; e.g.,
        'http://www.geneontology.org/#GO:0005892'.

        Returns the qualifier associated with the resource, or BQB_UNKNOWN if
        the resource does not exist.

        Note: The set of MIRIAM biological qualifiers grows over time,
        although relatively slowly.  The values are up to date with MIRIAM at
        the time of a given libSBML release.  The set of values in list of
        BQB_ constants defined in libsbml may be expanded in later libSBML
        releases, to match the values defined by MIRIAM at that later time.

        """
        return _libsbml.SBase_getResourceBiologicalQualifier(self, resource)

    def getResourceModelQualifier(self, resource):
        r"""
        getResourceModelQualifier(SBase self, string resource) -> ModelQualifierType_t

        Returns the MIRIAM model qualifier associated with the given resource.

        In MIRIAM, qualifiers are an optional means of indicating the
        relationship between a model component and its annotations.  There are
        two broad kinds of annotations: model and biological.  The former kind
        is used to qualify the relationship between a model component and
        another modeling object.  An example qualifier is 'isDerivedFrom', to
        indicate that a given component of the model is derived from the
        modeling object represented by the referenced resource.  MIRIAM
        defines numerous relationship qualifiers to enable different software
        tools to qualify model annotations in the same standardized way.  In
        libSBML, the MIRIAM controlled-vocabulary annotations on an SBML model
        element are represented using lists of CVTerm objects, and the  the
        MIRIAM model qualifiers are represented using values whose names begin
        with BQM_ in the interface class libsbml.

        This method method searches the controlled-vocabulary annotations
        (i.e., the list of CVTerm objects) on the present object, then out of
        those that have model qualifiers, looks for an annotation to the given
        'resource'.  If such an annotation is found, it returns the type of
        type of model qualifier associated with that resource as a  value
        whose name begins with BQM_ from the interface class libsbml.

        Parameter 'resource' is string representing the resource; e.g.,
        'http://www.geneontology.org/#GO:0005892'.

        Returns the model qualifier type associated with the resource, or
        BQM_UNKNOWN if the resource does not exist.

        Note: The set of MIRIAM model qualifiers grows over time, although
        relatively slowly.  The values are up to date with MIRIAM at the time
        of a given libSBML release.  The set of values in list of BQM_
        constants defined in libsbml may be expanded in later libSBML
        releases, to match the values defined by MIRIAM at that later time.

        """
        return _libsbml.SBase_getResourceModelQualifier(self, resource)

    def getModel(self):
        r"""
        getModel(SBase self) -> Model

        Returns the Model object for the SBML Document in which the current
        object is located.

        Returns the Model object for the SBML Document of this SBML object.

        See also getParentSBMLObject(), getSBMLDocument().

        """
        return _libsbml.SBase_getModel(self)

    def getLevel(self):
        r"""
        getLevel(SBase self) -> unsigned int

        Returns the SBML Level of the SBMLDocument object containing this
        object.

        LibSBML uses the class SBMLDocument as a top-level container for
        storing SBML content and data associated with it (such as warnings and
        error messages).  An SBML model in libSBML is contained inside an
        SBMLDocument object.  SBMLDocument corresponds roughly to the class
        SBML defined in the SBML Level 3 and Level 2 specifications, but it
        does not have a direct correspondence in SBML Level 1.  (But, it is
        created by libSBML no matter whether the model is Level 1, Level 2 or
        Level 3.)

        Returns the SBML level of this SBML object.

        See also getVersion(), getNamespaces(), getPackageVersion().

        """
        return _libsbml.SBase_getLevel(self)

    def getVersion(self):
        r"""
        getVersion(SBase self) -> unsigned int

        Returns the Version within the SBML Level of the SBMLDocument object
        containing this object.

        LibSBML uses the class SBMLDocument as a top-level container for
        storing SBML content and data associated with it (such as warnings and
        error messages).  An SBML model in libSBML is contained inside an
        SBMLDocument object.  SBMLDocument corresponds roughly to the class
        SBML defined in the SBML Level 3 and Level 2 specifications, but it
        does not have a direct correspondence in SBML Level 1.  (But, it is
        created by libSBML no matter whether the model is Level 1, Level 2 or
        Level 3.)

        Returns the SBML version of this SBML object.

        See also getLevel(), getNamespaces().

        """
        return _libsbml.SBase_getVersion(self)

    def getPackageCoreVersion(self):
        r"""
        getPackageCoreVersion(SBase self) -> unsigned int

        Returns the SBML Core Version within the SBML Level of the actual
        object.

        LibSBML uses the class SBMLDocument as a top-level container for
        storing SBML content and data associated with it (such as warnings and
        error messages).  An SBML model in libSBML is contained inside an
        SBMLDocument object.  SBMLDocument corresponds roughly to the class
        SBML defined in the SBML Level 3 and Level 2 specifications, but it
        does not have a direct correspondence in SBML Level 1.  (But, it is
        created by libSBML no matter whether the model is Level 1, Level 2 or
        Level 3.)

        Returns the SBML core version of this SBML object.

        """
        return _libsbml.SBase_getPackageCoreVersion(self)

    def getPackageVersion(self):
        r"""
        getPackageVersion(SBase self) -> unsigned int

        Returns the Version of the SBML Level 3 package to which this element
        belongs to.

        Returns the version of the SBML Level 3 package to which this element
        belongs. The value '0' will be returned if this element belongs to the
        SBML Level 3 Core package.

        See also getLevel(), getVersion().

        """
        return _libsbml.SBase_getPackageVersion(self)

    def getPackageName(self):
        r"""
        getPackageName(SBase self) -> string

        Returns the name of the SBML Level 3 package in which this element is
        defined.

        Returns the name of the SBML package in which this element is defined.
        The string "core" will be returned if this element is defined in
        SBML Level 3 Core. The string "unknown" will be returned if this
        element is not defined in any SBML package.

        """
        return _libsbml.SBase_getPackageName(self)

    def getTypeCode(self):
        r"""
        getTypeCode(SBase self) -> int

        Returns the libSBML type code for this object.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Here follow some additional general information about libSBML type
        codes:

        * The codes are the possible return values (integers) for the
        following functions:

        * SBase.getTypeCode()

        * ListOf.getItemTypeCode() (Compatibility note: in libSBML 5, the
        type of return values of these functions changed from an enumeration
        to an integer for extensibility in the face of different programming
        languages.)

        * Each package extension must define similar sets of values for
        each SBase subclass (e.g. SBMLLayoutTypeCode_t for the SBML Level 3
        Layout extension, SBMLFbcTypeCode_t for the SBML Level 3 Flux Balance
        Constraints extension, etc.).

        * The value of each package-specific type code can be duplicated
        between those of different packages.  (This is necessary because the
        development of libSBML extensions for different SBML packages may be
        undertaken by different developers at different times; requiring the
        developers to coordinate their use of type codes would be nettlesome
        and probably doomed to failure.)

        * To distinguish between the type codes of different packages,
        both the return value of SBase.getTypeCode() and
        SBase.getPackageName() must be checked.  This is particularly
        important for functions that take an SBML type code as an argument,
        such as SBase.getAncestorOfType(), which by default assumes you are
        handing it a core type, and will return 'None' if the value you give
        it is actually from a package.

        The following example code illustrates the combined use of
        SBase.getPackageName() and SBase.getTypeCode():

          def example(item):
            pkg_name  = item.getPackageName()
            type_code = item.getTypeCode()
            if pkg_name == 'core':
              print('Got a ' + SBMLTypeCode_toString(type_code, 'core') + ' object')
              if type_code == SBML_MODEL:
                print('This is a very, very nice model')
                # Do whatever the application wants to do with the model.
              elif type_code == SBML_COMPARTMENT:
                print('This is a very, very nice compartment')
                # Do whatever the application wants to do with the compartment.
              elif type_code == SBML_SPECIES:
                print('This is a very, very nice species')
                # Do whatever the application wants to do with the species.
              elif ...
                ...
            elif pkg_name == 'layout':
              print('Got a ' + SBMLTypeCode_toString(type_code, 'layout') + ' object')
              if type_code == SBML_LAYOUT_POINT:
                print('This is a very, very nice layout point')
                # Do whatever the application wants to do with the layout point.
              elif type_code == SBML_LAYOUT_BOUNDINGBOX:
                print('This is a very, very nice layout bounding box')
                # Do whatever the application wants to do with the layout bounding box.
              elif ...
                ...
            elif pkg_name == 'unknown':
              print('Something went wrong -- libSBML did not recognize the object type')
              # Handle errors

        Returns the SBML object type code of this SBML object, or
        SBML_UNKNOWN (the default).  The latter is possible because subclasses
        of SBase are not required to implement this method to return a type
        code.

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getPackageName(), getElementName().

        """
        return _libsbml.SBase_getTypeCode(self)

    def hasValidLevelVersionNamespaceCombination(self):
        r"""
        hasValidLevelVersionNamespaceCombination(SBase self) -> bool

        Predicate returning @c true if this object's level/version and namespace
        values correspond to a valid SBML specification.

        The valid combinations of SBML Level, Version and Namespace as of this
        release of libSBML are the following:
        <ul>
        <li> Level&nbsp;1 Version&nbsp;2: <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level1</code>
        <li> Level&nbsp;2 Version&nbsp;1: <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2</code>
        <li> Level&nbsp;2 Version&nbsp;2: <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version2</code>
        <li> Level&nbsp;2 Version&nbsp;3: <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version3</code>
        <li> Level&nbsp;2 Version&nbsp;4: <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level2/version4</code>
        <li> Level&nbsp;3 Version&nbsp;1 Core: <code style='margin-right:0; padding-right:0'>http</code><code style='margin-left:0; padding-left:0'>://www.sbml.org/sbml/level3/version1/core</code>
        </ul>

        @return @c true if the level, version and namespace values of this 
        SBML object correspond to a valid set of values, @c false otherwise.

        """
        return _libsbml.SBase_hasValidLevelVersionNamespaceCombination(self)

    def getElementName(self):
        r"""
        getElementName(SBase self) -> string

        Returns the XML element name of this object.

        This is overridden by subclasses to return a string appropriate to the
        SBML component.  For example, Model defines it as returning ''model','
        CompartmentType defines it as returning ''compartmentType',' and so
        on.

        """
        return _libsbml.SBase_getElementName(self)

    def toSBML(self):
        r"""
        toSBML(SBase self) -> char *

        Returns a string consisting of a partial SBML corresponding to just
        this object.

        Returns the partial SBML that describes this SBML object.

        WARNING:

        This is primarily provided for testing and debugging purposes.  It may
        be removed in a future version of libSBML.

        """
        return _libsbml.SBase_toSBML(self)

    def toXMLNode(self):
        r"""
        toXMLNode(SBase self) -> XMLNode

        Returns this element as an XMLNode.

        Returns this element as an XMLNode.

        WARNING:

        This operation is computationally expensive, because the element has
        to be fully serialized to a string and then parsed into the XMLNode
        structure.  Attempting to convert a large tree structure (e.g., a
        large Model) may consume significant computer memory and time.

        """
        return _libsbml.SBase_toXMLNode(self)

    def getPlugin(self, *args):
        r"""
        getPlugin(SBase self, string package) -> SBasePlugin
        getPlugin(SBase self, string package) -> SBasePlugin
        getPlugin(SBase self, unsigned int n) -> SBasePlugin
        getPlugin(SBase self, unsigned int n) -> SBasePlugin

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getPlugin(string package)

        Returns a plug-in object (extension interface) for an SBML Level 3
        package extension with the given package name or URI. The returned
        plug-in will be the appropriate type of plugin requested: calling
        Model.getPlugin() will return an FbcModelPlugin; calling
        Parameter.getPlugin() will return CompSBasePlugin, etc.

        If no such plugin exists, None is returned.

        SBML Level 3 consists of a Core definition that can be extended via
        optional SBML Level 3 packages.  A given model may indicate that it
        uses one or more SBML packages, and likewise, a software tool may be
        able to support one or more packages.  LibSBML does not come
        preconfigured with all possible packages included and enabled, in part
        because not all package specifications have been finalized.  To
        support the ability for software systems to enable support for the
        Level 3 packages they choose, libSBML features a plug-in mechanism.
        Each SBML Level 3 package is implemented in a separate code plug-in
        that can be enabled by the application to support working with that
        SBML package.  A given SBML model may thus contain not only objects
        defined by SBML Level 3 Core, but also objects created by libSBML
        plug-ins supporting additional Level 3 packages.

        Parameter 'package' is the name or URI of the package.

        Returns the plug-in object (the libSBML extension interface) of a
        package extension with the given package name or URI.

        See also getPlugin().

        ______________________________________________________________________
        Method variant with the following signature:

            getPlugin(long n)

        Returns the nth plug-in object (extension interface) for an SBML Level
        3 package extension. The returned plug-in will be the appropriate type
        of plugin requested: calling Model.getPlugin() will return an
        FbcModelPlugin; calling Parameter.getPlugin() will return
        CompSBasePlugin, etc.

        If no such plugin exists, None is returned.

        SBML Level 3 consists of a Core definition that can be extended via
        optional SBML Level 3 packages.  A given model may indicate that it
        uses one or more SBML packages, and likewise, a software tool may be
        able to support one or more packages.  LibSBML does not come
        preconfigured with all possible packages included and enabled, in part
        because not all package specifications have been finalized.  To
        support the ability for software systems to enable support for the
        Level 3 packages they choose, libSBML features a plug-in mechanism.
        Each SBML Level 3 package is implemented in a separate code plug-in
        that can be enabled by the application to support working with that
        SBML package.  A given SBML model may thus contain not only objects
        defined by SBML Level 3 Core, but also objects created by libSBML
        plug-ins supporting additional Level 3 packages.

        Parameter 'n' is the index of the plug-in to return.

        Returns the nth plug-in object (the libSBML extension interface) of a
        package extension. If the index 'n' is invalid, 'None' is returned.

        See also getNumPlugins(), getPlugin().

        """
        return _libsbml.SBase_getPlugin(self, *args)

    def getDisabledPlugin(self, *args):
        r"""
        getDisabledPlugin(SBase self, unsigned int n) -> SBasePlugin
        getDisabledPlugin(SBase self, unsigned int n) -> SBasePlugin

        Returns the nth disabled plug-in object (extension interface) for an
        SBML Level 3 package extension.  If no such plugin exists, None is
        returned.

        SBML Level 3 consists of a Core definition that can be extended via
        optional SBML Level 3 packages.  A given model may indicate that it
        uses one or more SBML packages, and likewise, a software tool may be
        able to support one or more packages.  LibSBML does not come
        preconfigured with all possible packages included and enabled, in part
        because not all package specifications have been finalized.  To
        support the ability for software systems to enable support for the
        Level 3 packages they choose, libSBML features a plug-in mechanism.
        Each SBML Level 3 package is implemented in a separate code plug-in
        that can be enabled by the application to support working with that
        SBML package.  A given SBML model may thus contain not only objects
        defined by SBML Level 3 Core, but also objects created by libSBML
        plug-ins supporting additional Level 3 packages.

        If a plugin is disabled, the package information it contains is no
        longer considered to be part of the SBML document for the purposes of
        searching the document or writing out the document.  However, the
        information is still retained, so if the plugin is enabled again, the
        same information will once again be available, and will be written out
        to the final model.

        Parameter 'n' is the index of the disabled plug-in to return.

        Returns the nth disabled plug-in object (the libSBML extension
        interface) of a package extension. If the index 'n' is invalid, 'None'
        is returned.

        See also getNumDisabledPlugins(), getPlugin().

        """
        return _libsbml.SBase_getDisabledPlugin(self, *args)

    def getNumPlugins(self):
        r"""
        getNumPlugins(SBase self) -> unsigned int

        Returns the number of plug-in objects (extenstion interfaces) for SBML
        Level 3 package extensions known.

        SBML Level 3 consists of a Core definition that can be extended via
        optional SBML Level 3 packages.  A given model may indicate that it
        uses one or more SBML packages, and likewise, a software tool may be
        able to support one or more packages.  LibSBML does not come
        preconfigured with all possible packages included and enabled, in part
        because not all package specifications have been finalized.  To
        support the ability for software systems to enable support for the
        Level 3 packages they choose, libSBML features a plug-in mechanism.
        Each SBML Level 3 package is implemented in a separate code plug-in
        that can be enabled by the application to support working with that
        SBML package.  A given SBML model may thus contain not only objects
        defined by SBML Level 3 Core, but also objects created by libSBML
        plug-ins supporting additional Level 3 packages.

        Returns the number of plug-in objects (extension interfaces) of
        package extensions known by this instance of libSBML.

        See also getPlugin().

        """
        return _libsbml.SBase_getNumPlugins(self)

    def getNumDisabledPlugins(self):
        r"""
        getNumDisabledPlugins(SBase self) -> unsigned int

        Returns the number of disabled plug-in objects (extension interfaces)
        for SBML Level 3 package extensions known.

        SBML Level 3 consists of a Core definition that can be extended via
        optional SBML Level 3 packages.  A given model may indicate that it
        uses one or more SBML packages, and likewise, a software tool may be
        able to support one or more packages.  LibSBML does not come
        preconfigured with all possible packages included and enabled, in part
        because not all package specifications have been finalized.  To
        support the ability for software systems to enable support for the
        Level 3 packages they choose, libSBML features a plug-in mechanism.
        Each SBML Level 3 package is implemented in a separate code plug-in
        that can be enabled by the application to support working with that
        SBML package.  A given SBML model may thus contain not only objects
        defined by SBML Level 3 Core, but also objects created by libSBML
        plug-ins supporting additional Level 3 packages.

        If a plugin is disabled, the package information it contains is no
        longer considered to be part of the SBML document for the purposes of
        searching the document or writing out the document.  However, the
        information is still retained, so if the plugin is enabled again, the
        same information will once again be available, and will be written out
        to the final model.

        Returns the number of disabled plug-in objects (extension interfaces)
        of package extensions known by this instance of libSBML.

        """
        return _libsbml.SBase_getNumDisabledPlugins(self)

    def deleteDisabledPlugins(self, recursive=True):
        r"""
        deleteDisabledPlugins(SBase self, bool recursive=True)

        Deletes all information stored in disabled plugins.  If the plugin is
        re-enabled later, it will then not have any previously-stored
        information.

        SBML Level 3 consists of a Core definition that can be extended via
        optional SBML Level 3 packages.  A given model may indicate that it
        uses one or more SBML packages, and likewise, a software tool may be
        able to support one or more packages.  LibSBML does not come
        preconfigured with all possible packages included and enabled, in part
        because not all package specifications have been finalized.  To
        support the ability for software systems to enable support for the
        Level 3 packages they choose, libSBML features a plug-in mechanism.
        Each SBML Level 3 package is implemented in a separate code plug-in
        that can be enabled by the application to support working with that
        SBML package.  A given SBML model may thus contain not only objects
        defined by SBML Level 3 Core, but also objects created by libSBML
        plug-ins supporting additional Level 3 packages.

        If a plugin is disabled, the package information it contains is no
        longer considered to be part of the SBML document for the purposes of
        searching the document or writing out the document.  However, the
        information is still retained, so if the plugin is enabled again, the
        same information will once again be available, and will be written out
        to the final model.

        Parameter 'recursive' is if 'True,' the disabled information will be
        deleted also from all child elements, otherwise only from this SBase
        element.

        See also getNumDisabledPlugins().

        """
        return _libsbml.SBase_deleteDisabledPlugins(self, recursive)

    def enablePackage(self, pkgURI, pkgPrefix, flag):
        r"""
        enablePackage(SBase self, string pkgURI, string pkgPrefix, bool flag) -> int

        Enables or disables the given SBML Level 3 package on this object.

        This method enables the specified package on this object and other
        objects connected by child-parent links in the same SBMLDocument
        object. This method is the converse of SBase.disablePackage().

        Parameter 'pkgURI' is the URI of the package.

        Parameter 'pkgPrefix' is the XML prefix of the package.

        Parameter 'flag' is whether to enable ('True)' or disable ('False)'
        the package.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_PKG_UNKNOWN

        * LIBSBML_PKG_VERSION_MISMATCH

        * LIBSBML_PKG_CONFLICTED_VERSION

        See also disablePackage().

        """
        return _libsbml.SBase_enablePackage(self, pkgURI, pkgPrefix, flag)

    def disablePackage(self, pkgURI, pkgPrefix):
        r"""
        disablePackage(SBase self, string pkgURI, string pkgPrefix) -> int

        Disables the given SBML Level 3 package on this object.

        This method disables the specified package on this object and other
        objects connected by child-parent links in the same SBMLDocument
        object.

        An example of when this may be useful is during construction of model
        components when mixing existing and new models.  Suppose your
        application read an SBML document containing a model that used the
        SBML Hierarchical Model Composition ("comp") package, and extracted
        parts of that model in order to construct a new model in memory.  The
        new, in-memory model will not accept a component drawn from an other
        SBMLDocument with different package namespace declarations. You could
        reconstruct the same namespaces in the in-memory model first, but as a
        shortcut, you could also disable the package namespace on the object
        being added.  Here is a code example to help clarify this:

          import sys
          import os.path
          from libsbml import *

          # We read an SBML L3V1 model that uses the 'comp' package.

          doc = readSBML('sbml-file-with-comp-elements.xml');
          if doc.getNumErrors() > 0:
            print('readSBML encountered errors while reading the file.')
            doc.printErrors()
            sys.exit(1)

          # We extract one of the species from the model.

          model = doc.getModel()
          if model == None:
            print('Unable to retrieve Model object')
            sys.exit(1)

          s1 = model.getSpecies(0)
          if s1 == None:
            print('Unable to retrieve Species object')
            sys.exit(1)

          # We construct a new model.
          # This model does not use the 'comp' package.

          try:
            newDoc = SBMLDocument(3, 1)
          except ValueError:
            print('Could not create SBMLDocument object')
            sys.exit(1)

          newModel = newDoc.createModel()
          if newModel == None:
            print('Unable to create new Model object')
            sys.exit(1)

          # The following would normally fail with an error, because
          # addSpecies() would first check that the parent of the given
          # object has namespaces declared, and will discover that s1
          # does but newModel does not.

          #   newModel.addSpecies(s1)

          # However, if we disable the 'comp' package on s1, then the
          # call to addSpecies will work.

          compNS = 'http://www.sbml.org/sbml/level3/version1/comp/version1'
          status = s1.disablePackage(compNS, 'comp')
          if status != LIBSBML_OPERATION_SUCCESS:
            print('Unable to disable package.')
            sys.exit(1)

          newSpecies = newModel.addSpecies(s1)   # This will work now.
          if newSpecies == None:
            print('Could not add Species')       # (This will not happen,
            sys.exit(1)                          # but always check errors.)

        Parameter 'pkgURI' is the URI of the package.

        Parameter 'pkgPrefix' is the XML prefix of the package.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_PKG_UNKNOWN

        * LIBSBML_PKG_VERSION_MISMATCH

        * LIBSBML_PKG_CONFLICTED_VERSION

        See also enablePackage().

        """
        return _libsbml.SBase_disablePackage(self, pkgURI, pkgPrefix)

    def enablePackageInternal(self, pkgURI, pkgPrefix, flag):
        r"""
        enablePackageInternal(SBase self, string pkgURI, string pkgPrefix, bool flag)

        Internal implementation method.

        """
        return _libsbml.SBase_enablePackageInternal(self, pkgURI, pkgPrefix, flag)

    def isPackageURIEnabled(self, pkgURI):
        r"""
        isPackageURIEnabled(SBase self, string pkgURI) -> bool

        Predicate returning 'True' if an SBML Level 3 package with the given
        URI is enabled with this object.

        Parameter 'pkgURI' is the URI of the package.

        Returns 'True' if the given package is enabled within this object,
        'False' otherwise.

        See also isPackageEnabled().

        """
        return _libsbml.SBase_isPackageURIEnabled(self, pkgURI)

    def isPackageEnabled(self, pkgName):
        r"""
        isPackageEnabled(SBase self, string pkgName) -> bool

        Predicate returning 'True' if the given SBML Level 3 package is
        enabled with this object.

        The search ignores the package version.

        Parameter 'pkgName' is the name of the package.

        Returns 'True' if the given package is enabled within this object,
        'False' otherwise.

        See also isPackageURIEnabled().

        """
        return _libsbml.SBase_isPackageEnabled(self, pkgName)

    def isPkgURIEnabled(self, pkgURI):
        r"""
        isPkgURIEnabled(SBase self, string pkgURI) -> bool

        Predicate returning 'True' if an SBML Level 3 package with the given
        URI is enabled with this object.

        Parameter 'pkgURI' is the URI of the package.

        Returns 'True' if the given package is enabled within this object,
        'False' otherwise.

        DEPRECATED. Replaced in libSBML 5.2.0 by SBase.isPackageURIEnabled().

        See also isPkgEnabled().

        """
        return _libsbml.SBase_isPkgURIEnabled(self, pkgURI)

    def isPkgEnabled(self, pkgName):
        r"""
        isPkgEnabled(SBase self, string pkgName) -> bool

        Predicate returning 'True' if the given SBML Level 3 package is
        enabled with this object.

        The search ignores the package version.

        Parameter 'pkgName' is the name of the package.

        Returns 'True' if the given package is enabled within this object,
        'False' otherwise.

        DEPRECATED. Replaced in libSBML 5.2.0 by SBase.isPackageEnabled().

        See also isPkgURIEnabled().

        """
        return _libsbml.SBase_isPkgEnabled(self, pkgName)

    def writeExtensionElements(self, stream):
        r"""
        writeExtensionElements(SBase self, XMLOutputStream stream)

        Internal implementation method.

        """
        return _libsbml.SBase_writeExtensionElements(self, stream)

    def read(self, *args):
        r"""
        read(SBase self, XMLNode node, XMLErrorSeverityOverride_t flag=LIBSBML_OVERRIDE_DISABLED)
        read(SBase self, XMLInputStream stream)
        """
        return _libsbml.SBase_read(self, *args)

    def write(self, stream):
        r"""
        write(SBase self, XMLOutputStream stream)

        Internal implementation method.

        """
        return _libsbml.SBase_write(self, stream)

    def hasRequiredAttributes(self):
        r"""
        hasRequiredAttributes(SBase self) -> bool

        Internal implementation method.

        """
        return _libsbml.SBase_hasRequiredAttributes(self)

    def hasRequiredElements(self):
        r"""
        hasRequiredElements(SBase self) -> bool

        Internal implementation method.

        """
        return _libsbml.SBase_hasRequiredElements(self)

    def checkCompatibility(self, object):
        r"""
        checkCompatibility(SBase self, SBase object) -> int

        Internal implementation method.

        """
        return _libsbml.SBase_checkCompatibility(self, object)

    def setSBMLNamespacesAndOwn(self, disownedNs):
        r"""
        setSBMLNamespacesAndOwn(SBase self, SBMLNamespaces disownedNs)

        Internal implementation method.

        """
        return _libsbml.SBase_setSBMLNamespacesAndOwn(self, disownedNs)

    def getSBMLNamespaces(self):
        r"""
        getSBMLNamespaces(SBase self) -> SBMLNamespaces

        Internal implementation method.

        """
        return _libsbml.SBase_getSBMLNamespaces(self)

    def removeDuplicateAnnotations(self):
        r"""
        removeDuplicateAnnotations(SBase self)

        Internal implementation method.

        """
        return _libsbml.SBase_removeDuplicateAnnotations(self)

    def checkMathMLNamespace(self, elem):
        r"""
        checkMathMLNamespace(SBase self, XMLToken elem) -> string

        Internal implementation method.

        """
        return _libsbml.SBase_checkMathMLNamespace(self, elem)

    def getDerivedUnitDefinition(self):
        r"""
        getDerivedUnitDefinition(SBase self) -> UnitDefinition

        Internal implementation method.

        """
        return _libsbml.SBase_getDerivedUnitDefinition(self)

    def containsUndeclaredUnits(self):
        r"""
        containsUndeclaredUnits(SBase self) -> bool

        Internal implementation method.

        """
        return _libsbml.SBase_containsUndeclaredUnits(self)

    def removeFromParentAndDelete(self):
        r"""
        removeFromParentAndDelete(SBase self) -> int

        Removes this object from its parent.

        If the parent was storing this object as a pointer, it is deleted.  If
        not, it is simply cleared (as in ListOf objects).  This is a pure
        virtual method, as every SBase element has different parents, and
        therefore different methods of removing itself.  Will fail (and not
        delete itself) if it has no parent object.  This function is designed
        to be overridden, but for all objects whose parent is of the class
        ListOf, the default implementation will work.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        """
        return _libsbml.SBase_removeFromParentAndDelete(self)

    def matchesSBMLNamespaces(self, *args):
        r"""
        matchesSBMLNamespaces(SBase self, SBase sb) -> bool
        matchesSBMLNamespaces(SBase self, SBase sb) -> bool

        Returns 'True' if this object's set of XML namespaces are the same as
        the given object's XML namespaces.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        Parameter 'sb' is an object to compare with respect to namespaces.

        Returns boolean, 'True' if this object's collection of namespaces is
        the same as 'sb's', 'False' otherwise.

        """
        return _libsbml.SBase_matchesSBMLNamespaces(self, *args)

    def matchesRequiredSBMLNamespacesForAddition(self, *args):
        r"""
        matchesRequiredSBMLNamespacesForAddition(SBase self, SBase sb) -> bool
        matchesRequiredSBMLNamespacesForAddition(SBase self, SBase sb) -> bool

        Returns 'True' if this object's set of XML namespaces are a subset of
        the given object's XML namespaces.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        Parameter 'sb' is an object to compare with respect to namespaces.

        Returns boolean, 'True' if this object's collection of namespaces is a
        subset of 'sb's', 'False' otherwise.

        """
        return _libsbml.SBase_matchesRequiredSBMLNamespacesForAddition(self, *args)

    def isSetUserData(self):
        r"""
        isSetUserData(SBase self) -> bool

        Predicate returning true or false depending on whether the user data
        of this element has been set.

        The user data associated with an SBML object can be used by an
        application developer to attach custom information to that object in
        the model.  In case of a deep copy, this data will passed as-is.  The
        data attribute will never be interpreted by libSBML.

        Returns boolean, 'True' if this object's user data has been set,
        'False' otherwise.

        """
        return _libsbml.SBase_isSetUserData(self)

    def unsetUserData(self):
        r"""
        unsetUserData(SBase self) -> int

        Unsets the user data of this element.

        The user data associated with an SBML object can be used by an
        application developer to attach custom information to that object in
        the model.  In case of a deep copy, this data will passed as-is.  The
        data attribute will never be interpreted by libSBML.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        """
        return _libsbml.SBase_unsetUserData(self)

    def getURI(self):
        r"""
        getURI(SBase self) -> string

        Returns the namespace URI to which this element belongs to.

        For example, all elements that belong to SBML Level 3 Version 1 Core
        must would have the URI
        'http://www.sbml.org/sbml/level3/version1/core'; all elements that
        belong to Layout Extension Version 1 for SBML Level 3 Version 1 Core
        must would have the URI
        'http://www.sbml.org/sbml/level3/version1/layout/version1'.

        This function first returns the URI for this element by looking into
        the SBMLNamespaces object of the document with the its package name.
        If not found, it will then look for the namespace associated with the
        element itself.

        Returns the URI of this element, as a text string.

        See also getSBMLDocument(), getPackageName().

        """
        return _libsbml.SBase_getURI(self)

    def getPrefix(self):
        r"""
        getPrefix(SBase self) -> string

        Returns the XML namespace prefix of this element.

        This reports the XML namespace prefix chosen for this class of object
        in the current SBML document.  This may be an empty string if the
        component has no explicit prefix (for instance, if it is a core SBML
        object placed in the default SBML namespace of the document).  If it
        is not empty, then it corresponds to the XML namespace prefix used set
        the object, whatever that may be in a given SBML document.

        Returns a text string representing the XML namespace prefix.

        """
        return _libsbml.SBase_getPrefix(self)

    def hasOptionalAttributes(self):
        r"""
        hasOptionalAttributes(SBase self) -> bool

        Internal implementation method.

        """
        return _libsbml.SBase_hasOptionalAttributes(self)

    def hasOptionalElements(self):
        r"""
        hasOptionalElements(SBase self) -> bool

        Internal implementation method.

        """
        return _libsbml.SBase_hasOptionalElements(self)

    def updateSBMLNamespace(self, package, level, version):
        r"""
        updateSBMLNamespace(SBase self, string package, unsigned int level, unsigned int version)

        Internal implementation method.

        """
        return _libsbml.SBase_updateSBMLNamespace(self, package, level, version)

    __metaclass__ = AutoProperty


    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


    def getListOfAllElements(self, *args):
      """
      getListOfAllElements(self) -> SBaseList

      Get the List of all SBase objects in this element.

      Returns the List of all child elements.


      """
      return _libsbml.SBase_getListOfAllElements(self, *args)



    def getListOfAllElementsFromPlugins(self, *args):
      """
      getListOfAllElementsFromPlugins(self) -> SBaseList

      Get the List of SBase objects in this elements plugins.

      Returns the SBaseList of all plugins for this element.


      """
      return _libsbml.SBase_getListOfAllElementsFromPlugins(self, *args)



# Register SBase in _libsbml:
_libsbml.SBase_swigregister(SBase)

class ListOf(SBase):
    r"""

    Parent class for libSBML's 'ListOfXYZ' classes.

    This class of objects is defined by libSBML only and has no direct
    equivalent in terms of SBML components.  This class is not prescribed
    by the SBML specifications, although it is used to implement features
    defined in SBML.

    The ListOf class in libSBML is a utility class that serves as the
    parent class for implementing the ListOf__ classes.  It provides
    methods for working generically with the various SBML lists of objects
    in a program. LibSBML uses this separate list class rather than
    ordinary Python lists, so that it can provide the methods and features
    associated with SBase.

    Whether a given ListOf element may be empty or not depends on the
    element in question, and on what level and version of SBML it is being
    used for.  For ListOf elements in SBML Level 3 Version 1 and prior, no
    core list and few package lists could be empty.  As of SBML Level 3
    Version 2, the rules were relaxed, and lists were allowed to be empty.
    In libSBML, documents created for Level 3 Version 2 will be written
    with empty ListOf's if that ListOf contains some other 'extra'
    information: an attribute such as metaid or sboTerm, a child '<notes>'
    or '<annotation>', or information from a SBML  Level 3 package.

    The various ListOf___ classes in SBML are merely containers used for
    organizing the main components of an SBML model.  In libSBML's
    implementation, ListOf___ classes are derived from the intermediate
    utility class ListOf, which is not defined by the SBML specifications
    but serves as a useful programmatic construct.  ListOf is itself is in
    turn derived from SBase, which provides all of the various ListOf___
    classes with common features defined by the SBML specification, such
    as 'metaid' attributes and annotations.

    The relationship between the lists and the rest of an SBML model is
    illustrated by the following (for SBML Level 2 Version 4):

      <?xml version="1.0" encoding="UTF-8"?>
      <sbml xmlns="http://www.sbml.org/sbml/level3/version1/core" 
            level="3" version="1">
        <model id="My_Model">
          <listOfFunctionDefinitions>
            <functionDefinition> ... </functionDefinition> 
          </listOfFunctionDefinitions>
          <listOfUnitDefinitions>
            <unitDefinition> ... </unitDefinition> 
          </listOfUnitDefinitions>
          <listOfCompartments>
            <compartment> ... </compartment> 
          </listOfCompartments>
          <listOfSpecies>
            <species> ... </species> 
          </listOfSpecies>
          <listOfParameters>
            <parameter> ... </parameter> 
          </listOfParameters>
          <listOfInitialAssignments>
            <initialAssignment> ... </initialAssignment> 
          </listOfInitialAssignments>
          <listOfRules>
            ... elements of subclasses of Rule ...
          </listOfRules>
          <listOfConstraints>
            <constraint> ... </constraint> 
          </listOfConstraints>
          <listOfReactions>
            <reaction> ... </reaction> 
          </listOfReactions>
          <listOfEvents>
            <event> ... </event> 
          </listOfEvents>
        </model>
      </sbml>

    SBML Level 3 Version 1 has essentially the same structure as  Level
    2 Version 4, depicted above, but SBML Level 3  Version 2 allows
    containers to contain zero or more of the relevant object, instead of
    requiring at least one.  As such, libsbml will write out an
    otherwise-empty ListOf___ element that has any optional attribute set
    (such as 'id' or 'metaid'), that has an optional child (such  as a
    'notes' or 'annotation'), or that has attributes or children set from
    any SBML Level 3 package, whether or not the ListOf___ has  any other
    children.

    Readers may wonder about the motivations for using the ListOf___
    containers in SBML.  A simpler approach in XML might be to place the
    components all directly at the top level of the model definition.  The
    choice made in SBML is to group them within XML elements named after
    ListOfClassname, in part because it helps organize the components.
    More importantly, the fact that the container classes are derived from
    SBase means that software tools can add information about the lists
    themselves into each list container's 'annotation'.

    See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
    ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
    ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_ListOf

    def __init__(self, *args):
        r"""
        __init__(ListOf self, unsigned int level=SBML_DEFAULT_LEVEL, unsigned int version=SBML_DEFAULT_VERSION) -> ListOf
        __init__(ListOf self, SBMLNamespaces sbmlns) -> ListOf
        __init__(ListOf self, ListOf orig) -> ListOf

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOf(long level   = SBML_DEFAULT_LEVEL, long version =
        SBML_DEFAULT_VERSION)

        Creates a new ListOf object.

        Parameter 'level' is the SBML Level; if not assigned, defaults to the
        value of SBMLDocument.getDefaultLevel().

        Parameter 'version' is the Version within the SBML Level; if not
        assigned, defaults to the value of SBMLDocument.getDefaultVersion().

        Note: Bare ListOf objects are impossible to add to SBML models.  The
        ListOf class is simply the base of other classes in libSBML.  Calling
        programs are not intended to create bare ListOf objects themselves.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOf(SBMLNamespaces sbmlns)

        Creates a new ListOf with a given SBMLNamespaces object.

        Parameter 'sbmlns' is the set of SBML namespaces that this ListOf
        should contain.

        Note: Bare ListOf objects are impossible to add to SBML models.  The
        ListOf class is simply the base of other classes in libSBML.  Calling
        programs are not intended to create bare ListOf objects themselves.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOf(ListOf orig)

        Copy constructor; creates a copy of this ListOf.

        Parameter 'orig' is the ListOf instance to copy.

        """
        _libsbml.ListOf_swiginit(self, _libsbml.new_ListOf(*args))

    def clone(self):
        r"""
        clone(ListOf self) -> ListOf

        Creates and returns a deep copy of this ListOf object.

        Returns the (deep) copy of this ListOf object.

        """
        return _libsbml.ListOf_clone(self)

    def append(self, item):
        r"""
        append(ListOf self, SBase item) -> int

        Adds an item to the end of this ListOf's list of items.

        This method makes a clone of the 'item' handed to it.  This means that
        when the ListOf object is destroyed, the original items will not be
        destroyed.  For a method with an alternative ownership behavior, see
        the ListOf.appendAndOwn() method.

        Parameter 'item' is the item to be added to the list.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        See also appendAndOwn(), appendFrom().

        """
        return _libsbml.ListOf_append(self, item)

    def appendAndOwn(self, disownedItem):
        r"""
        appendAndOwn(ListOf self, SBase disownedItem) -> int

        Adds an item to the end of this ListOf's list of items.

        This method does not clone the 'disownedItem' handed to it; instead,
        it assumes ownership of it.  This means that when the ListOf is
        destroyed, the item will be destroyed along with it.  For a method
        with an alternative ownership behavior, see the ListOf.append()
        method.

        Parameter 'disownedItem' is the item to be added to the list. Will
        become a child of the parent list.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        See also append(), appendFrom().

        """
        return _libsbml.ListOf_appendAndOwn(self, disownedItem)

    def appendFrom(self, list):
        r"""
        appendFrom(ListOf self, ListOf list) -> int

        Adds a clone of a list of items to this ListOf's list.

        Note that because this clones the objects handed to it, the original
        items will not be destroyed when this ListOf object is destroyed.

        Parameter 'list' is a list of items to be added.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        See also append(), appendAndOwn().

        """
        return _libsbml.ListOf_appendFrom(self, list)

    def insert(self, location, item):
        r"""
        insert(ListOf self, int location, SBase item) -> int

        Inserts an item at a given position in this ListOf's list of items.

        This variant of the method makes a clone of the 'item' handed to it.
        This means that when the ListOf is destroyed, the original 'item' will
        not be destroyed.

        Parameter 'location' is the location in the list where to insert the
        item. Parameter 'item' is the item to be inserted to the list.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        See also insertAndOwn().

        """
        return _libsbml.ListOf_insert(self, location, item)

    def insertAndOwn(self, location, disownedItem):
        r"""
        insertAndOwn(ListOf self, int location, SBase disownedItem) -> int

        Inserts an item at a given position in this ListOf's list of items.

        This variant of the method does not make a clone of the 'disownedItem'
        handed to it. This means that when the ListOf is destroyed, the
        original 'item' will be destroyed.

        Parameter 'location' is the location where to insert the item.
        Parameter 'disownedItem' is the item to be inserted to the list. Will
        become a child of the parent list.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        See also insert().

        """
        return _libsbml.ListOf_insertAndOwn(self, location, disownedItem)

    def get(self, *args):
        r"""
        get(ListOf self, unsigned int n) -> SBase
        get(ListOf self, unsigned int n) -> SBase

        Get an item from the list.

        Parameter 'n' is the index number of the item to get.

        Returns the nth item in this ListOf items, or a null pointer if the
        index number 'n' refers to a nonexistent position in this list.

        See also size().

        """
        return _libsbml.ListOf_get(self, *args)

    def getElementBySId(self, id):
        r"""
        getElementBySId(ListOf self, string id) -> SBase

        Returns the first child element found that has the given identifier.

        This method searches this ListOf's list of items for SBML objects
        based on their 'id' attribute value in the model-wide SId identifier
        namespace.

        Parameter 'id' is string representing the id of the object to find.

        Returns the first element found with the given 'id', or 'None' if no
        such object is found.

        """
        return _libsbml.ListOf_getElementBySId(self, id)

    def getElementByMetaId(self, metaid):
        r"""
        getElementByMetaId(ListOf self, string metaid) -> SBase

        Returns the first child element found with the given meta-identifier.

        Parameter 'metaid' is string representing the 'metaid' attribute of
        the object to find.

        Returns the first element found with the given 'metaid', or 'None' if
        no such object is found.

        """
        return _libsbml.ListOf_getElementByMetaId(self, metaid)

    def clear(self, doDelete=True):
        r"""
        clear(ListOf self, bool doDelete=True)

        Removes all items in this ListOf object.

        If parameter 'doDelete' is 'True' (default), all items in this ListOf
        object are deleted and cleared, and thus the caller doesn't have to
        delete those items.  Otherwise, all items are cleared only from this
        ListOf object; the caller is still responsible for deleting the actual
        items.  (In the latter case, callers are advised to store pointers to
        all items elsewhere before calling this function.)

        Parameter 'doDelete' is if 'True' (default), all items are deleted and
        cleared. Otherwise, all items are just cleared and not deleted.

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.ListOf_clear(self, doDelete)

    def removeFromParentAndDelete(self):
        r"""
        removeFromParentAndDelete(ListOf self) -> int

        Removes all items in this ListOf object and deletes its properties
        too.

        This performs a call to clear() with an argument of 'True' (thus
        removing all the child objects in the list), followed by calls to
        various libSBML unsetFoo methods to delete everything else: CVTerm
        objects, model history objects, etc.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        """
        return _libsbml.ListOf_removeFromParentAndDelete(self)

    def remove(self, n):
        r"""
        remove(ListOf self, unsigned int n) -> SBase

        Removes the nth item from this ListOf list of items and returns it.

        The caller owns the returned item and is responsible for deleting it.

        Parameter 'n' is the index of the item to remove.

        See also size().

        """
        return _libsbml.ListOf_remove(self, n)

    def size(self):
        r"""
        size(ListOf self) -> unsigned int

        Returns number of items in this ListOf list.

        Returns the number of items in this ListOf items.

        """
        return _libsbml.ListOf_size(self)

    def connectToChild(self):
        r"""connectToChild(ListOf self)"""
        return _libsbml.ListOf_connectToChild(self)

    def getTypeCode(self):
        r"""
        getTypeCode(ListOf self) -> int

        Returns the libSBML type code for this object, namely, SBML_LIST_OF.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_LIST_OF (default).

        Note: The various ListOf classes mostly differ from each other in what
        they contain.  Hence, one must call getItemTypeCode() to fully
        determine the class of this SBML object.

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getItemTypeCode(), getElementName(), getPackageName().

        """
        return _libsbml.ListOf_getTypeCode(self)

    def getItemTypeCode(self):
        r"""
        getItemTypeCode(ListOf self) -> int

        Get the type code of the objects contained in this ListOf.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Classes that inherit from the ListOf class should override this method
        to return the SBML type code for the objects contained in this ListOf.
        If they do not, this method will return SBML_UNKNOWN

        Returns The ListOf base class contains no SBML objects, and therefore
        this method returns SBML_UNKNOWN.

        See also getElementName(), getPackageName().

        """
        return _libsbml.ListOf_getItemTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(ListOf self) -> string

        Returns the XML element name of this object, which for ListOf, is
        always ''listOf'.'

        Returns the XML name of this element.

        """
        return _libsbml.ListOf_getElementName(self)

    def enablePackageInternal(self, pkgURI, pkgPrefix, flag):
        r"""
        enablePackageInternal(ListOf self, string pkgURI, string pkgPrefix, bool flag)

        Internal implementation method.

        """
        return _libsbml.ListOf_enablePackageInternal(self, pkgURI, pkgPrefix, flag)

    def updateSBMLNamespace(self, package, level, version):
        r"""
        updateSBMLNamespace(ListOf self, string package, unsigned int level, unsigned int version)

        Internal implementation method.

        """
        return _libsbml.ListOf_updateSBMLNamespace(self, package, level, version)

    def hasOptionalElements(self):
        r"""
        hasOptionalElements(ListOf self) -> bool

        Internal implementation method.

        """
        return _libsbml.ListOf_hasOptionalElements(self)

    def isExplicitlyListed(self):
        r"""
        isExplicitlyListed(ListOf self) -> bool

        Internal implementation method.

        """
        return _libsbml.ListOf_isExplicitlyListed(self)

    def setExplicitlyListed(self, value=True):
        r"""
        setExplicitlyListed(ListOf self, bool value=True)

        Internal implementation method.

        """
        return _libsbml.ListOf_setExplicitlyListed(self, value)

    def sort(self):
        r"""
        sort(ListOf self)

        Internal implementation method.

        """
        return _libsbml.ListOf_sort(self)

    def __len__(self):
        r"""__len__(ListOf self) -> int"""
        return _libsbml.ListOf___len__(self)

    def __getitem__(self, key):

      try:
         keyIsSlice = isinstance(key, slice)
      except:
         keyIsSlice = 0

      if keyIsSlice:
        start = key.start
        if start is None:
          start = 0
        stop = key.stop
        if stop is None:
          stop = self.size()
        return [self[i] for i in range(
          self._fixNegativeIndex(start), self._fixNegativeIndex(stop)
        )]

      key = self._fixNegativeIndex(key)
      if key < 0 or key >= self.size():
        raise IndexError(key)
      return self.get(key)


    def _fixNegativeIndex(self, index):
      if index < 0:
        return index + self.size()
      else:
        return index


    def __iter__(self):
      for i in range(self.size()):
        yield self[i]


    def __repr__(self):
      return "[" + ", ".join([repr(self[i]) for i in range(len(self))]) + "]"


    def __str__(self):
      return repr(self)


# Register ListOf in _libsbml:
_libsbml.ListOf_swigregister(ListOf)

class Model(SBase):
    r"""

    An SBML model.

    In an SBML model definition, a single object of class Model serves as
    the overall container for the lists of the various model components.
    All of the lists are optional, but if a given list container is
    present within the model, the list must not be empty; that is, it must
    have length one or more.  The following are the components and lists
    permitted in different Levels and Versions of SBML in version 5.19.3

    of libSBML:

    * In SBML Level 1, the components are: UnitDefinition, Compartment,
    Species, Parameter, Rule, and Reaction.  Instances of the classes are
    placed inside instances of classes ListOfUnitDefinitions,
    ListOfCompartments, ListOfSpecies, ListOfParameters, ListOfRules, and
    ListOfReactions.

    * In SBML Level 2 Version 1, the components are: FunctionDefinition,
    UnitDefinition, Compartment, Species, Parameter, Rule, Reaction and
    Event.  Instances of the classes are placed inside instances of
    classes ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartments, ListOfSpecies, ListOfParameters, ListOfRules,
    ListOfReactions, and ListOfEvents.

    * In SBML Level 2 Versions 2, 3 and 4, the components are:
    FunctionDefinition, UnitDefinition, CompartmentType, SpeciesType,
    Compartment, Species, Parameter, InitialAssignment, Rule, Constraint,
    Reaction and Event.  Instances of the classes are placed inside
    instances of classes ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
    ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
    ListOfRules, ListOfConstraints, ListOfReactions, and ListOfEvents.

    * In SBML Level 3 Version 1, the components are: FunctionDefinition,
    UnitDefinition, Compartment, Species, Parameter, InitialAssignment,
    Rule, Constraint, Reaction and Event.  Instances of the classes are
    placed inside instances of classes ListOfFunctionDefinitions,
    ListOfUnitDefinitions, ListOfCompartments, ListOfSpecies,
    ListOfParameters, ListOfInitialAssignments, ListOfRules,
    ListOfConstraints, ListOfReactions, and ListOfEvents.   Although all
    the lists are optional, there are dependencies between SBML components
    such that defining some components requires defining others. An
    example is that defining a species requires defining a compartment,
    and defining a reaction requires defining a species.  The dependencies
    are explained in more detail in the SBML specifications.

    In addition to the above lists and attributes, the Model class in both
    SBML Level 2 and Level 3 has the usual two attributes of 'id' and
    'name', and both are optional.  As is the case for other SBML
    components with 'id' and 'name' attributes, they must be used
    according to the guidelines described in the SBML specifications.
    (Within the frameworks of SBML Level 2 and Level 3, a Model object
    identifier has no assigned meaning, but extension packages planned for
    SBML Level 3 are likely to make use of this identifier.)

    Finally, SBML Level 3 has introduced a number of additional Model
    attributes.  They are discussed in a separate section below.

    Approaches to creating objects using the libSBML API
    ======================================================================

    LibSBML provides two main mechanisms for creating objects: class
    constructors (e.g., Species.Species() ),  and createObject() methods
    (such as Model.createSpecies()) provided by certain Object classes
    such as Model.  These multiple mechanisms are provided by libSBML for
    flexibility and to support different use-cases, but they also have
    different implications for the overall model structure.

    In general, the recommended approach is to use the createObject()
    methods.  These methods both create an object and link it to the
    parent in one step. Here is an example:

      # Create an SBMLDocument object in Level 3 Version 1 format.
      # Make sure to check for possible failures.

      try:
        sbmlDoc = SBMLDocument(3, 1)
      except ValueError:
        print('Could not create SBMLDocument object')
        sys.exit(1)

      # Create a Model object inside the SBMLDocument object and set its
      # identifier, checking the returned values.  The call to setId() returns a
      # status code to indicate whether the assignment was successful.

      model = sbmlDoc.createModel()
      if model == None:
        # Do something to handle the error here.
        print('Unable to create Model object.')
        sys.exit(1)

      status = model.setId('BestModelEver')
      if status != LIBSBML_OPERATION_SUCCESS:
        # Do something to handle the error here.
        print('Unable to set identifier on the Model object')
        sys.exit(1)

      # Create a Species object inside the Model and set its identifier.
      # Again, the setId() returns a status code to indicate whether the
      # assignment was successful.

      sp = model.createSpecies()
      if sp == None:
        # Do something to handle the error here.
        print('Unable to create Species object.')
        sys.exit(1)

      status = sp.setId('BestSpeciesEver')
      if status != LIBSBML_OPERATION_SUCCESS:
        # Do something to handle the error here.
        print('Unable to set identifier on the Species object')
        sys.exit(1)

    The createObject() methods return a pointer to the object created,
    but they also add the object to the relevant list of object instances
    contained in the parent.  (These lists become the <listOfObjects>
    elements in the finished XML rendition of SBML.)  In the example
    above, Model.createSpecies() adds the created species directly to the
    <listOfSpeciesgt; list in the model.  Subsequently, methods called on
    the species change the species in the model (which is what is expected
    in most situations).

    Consistency and adherence to SBML specifications
    ======================================================================

    To make it easier for applications to do whatever they need, libSBML
    version 5.19.3

    is relatively lax when it comes to enforcing correctness and
    completeness of models during model construction and editing.
    Essentially, libSBML will not in most cases check automatically that a
    model's components have valid attribute values, or that the overall
    model is consistent and free of errors---even obvious errors such as
    duplication of identifiers.  This allows applications great leeway in
    how they build their models, but it means that software authors must
    take deliberate steps to ensure that the model will be, in the end,
    valid SBML.  These steps include such things as keeping track of the
    identifiers used in a model, manually performing updates in certain
    situations where an entity is referenced in more than one place (e.g.,
    a species that is referenced by multiple SpeciesReference objects),
    and so on.

    That said, libSBML does provide powerful features for deliberately
    performing validation of SBML when an application decides it is time
    to do so.  The interfaces to these facilities are on the SBMLDocument
    class, in the form of SBMLDocument.checkInternalConsistency() and
    SBMLDocument.checkConsistency().  Please refer to the documentation
    for SBMLDocument for more information about this.

    While applications may play fast and loose and live like free spirits
    during the construction and editing of SBML models, they should always
    make sure to call SBMLDocument.checkInternalConsistency() and/or
    SBMLDocument.checkConsistency() before writing out the final version
    of an SBML model.

    Model attributes introduced in SBML Level 3
    ======================================================================

    As mentioned above, the Model class has a number of optional
    attributes in SBML Level 3.  These are 'substanceUnits', 'timeUnits',
    'volumeUnits', 'areaUnits', 'lengthUnits', 'extentUnits', and
    'conversionFactor.  The following provide more information about them.

    The 'substanceUnits' attribute
    ......................................................................

    The 'substanceUnits' attribute is used to specify the unit of
    measurement associated with substance quantities of Species objects
    that do not specify units explicitly.  If a given Species object
    definition does not specify its unit of substance quantity via the
    'substanceUnits' attribute on the Species object instance, then that
    species inherits the value of the Model 'substanceUnits' attribute.
    If the Model does not define a value for this attribute, then there is
    no unit to inherit, and all species that do not specify individual
    'substanceUnits' attribute values then have no declared units for
    their quantities.  The SBML Level 3 specifications provide more
    details.

    Note that when the identifier of a species appears in a model's
    mathematical expressions, the unit of measurement associated with that
    identifier is not solely determined by setting 'substanceUnits' on
    Model or Species.  Please see the discussion about units given in the
    documentation for the Species class.

    The 'timeUnits' attribute
    ......................................................................

    The 'timeUnits' attribute on SBML Level 3's Model object is used to
    specify the unit in which time is measured in the model.  This
    attribute on Model is the only way to specify a unit for time in a
    model. It is a global attribute; time is measured in the model
    everywhere in the same way.  This is particularly relevant to Reaction
    and RateRule objects in a model: all Reaction and RateRule objects in
    SBML define per-time values, and the unit of time is given by the
    'timeUnits' attribute on the Model object instance.  If the Model
    'timeUnits' attribute has no value, it means that the unit of time is
    not defined for the model's reactions and rate rules.  Leaving it
    unspecified in an SBML model does not result in an invalid model in
    SBML Level 3; however, as a matter of best practice, we strongly
    recommend that all models specify units of measurement for time.

    The 'volumeUnits', 'areaUnits', and 'lengthUnits' attributes
    ......................................................................

    The attributes 'volumeUnits', 'areaUnits' and 'lengthUnits' together
    are used to set the units of measurements for the sizes of Compartment
    objects in an SBML Level 3 model when those objects do not otherwise
    specify units.  The three attributes correspond to the most common
    cases of compartment dimensions: 'volumeUnits' for compartments having
    a 'spatialDimensions' attribute value of ''3',' 'areaUnits' for
    compartments having a 'spatialDimensions' attribute value of ''2','
    and 'lengthUnits' for compartments having a 'spatialDimensions'
    attribute value of ''1'.'  The attributes are not applicable to
    compartments whose 'spatialDimensions' attribute values are not one of
    ''1',' ''2'' or ''3'.'

    If a given Compartment object instance does not provide a value for
    its 'units' attribute, then the unit of measurement of that
    compartment's size is inherited from the value specified by the Model
    'volumeUnits', 'areaUnits' or 'lengthUnits' attribute, as appropriate
    based on the Compartment object's 'spatialDimensions' attribute value.
    If the Model object does not define the relevant attribute, then there
    are no units to inherit, and all Compartment objects that do not set a
    value for their 'units' attribute then have no units associated with
    their compartment sizes.

    The use of three separate attributes is a carry-over from SBML Level
    2.  Note that it is entirely possible for a model to define a value
    for two or more of the attributes 'volumeUnits', 'areaUnits' and
    'lengthUnits' simultaneously, because SBML models may contain
    compartments with different numbers of dimensions.

    The 'extentUnits' attribute
    ......................................................................

    Reactions are processes that occur over time.  These processes involve
    events of some sort, where a single ``reaction event'' is one in which
    some set of entities (known as reactants, products and modifiers in
    SBML) interact, once.  The extent of a reaction is a measure of how
    many times the reaction has occurred, while the time derivative of the
    extent gives the instantaneous rate at which the reaction is
    occurring.  Thus, what is colloquially referred to as the 'rate of the
    reaction' is in fact equal to the rate of change of reaction extent.

    In SBML Level 3, the combination of 'extentUnits' and 'timeUnits'
    defines the units of kinetic laws in SBML and establishes how the
    numerical value of each KineticLaw object's mathematical formula is
    meant to be interpreted in a model.  The units of the kinetic laws are
    taken to be 'extentUnits' divided by 'timeUnits'.

    Note that this embodies an important principle in SBML Level 3 models:
    all reactions in an SBML model must have the same units for the rate
    of change of extent.  In other words, the units of all reaction rates
    in the model must be the same.  There is only one global value for
    'extentUnits' and one global value for 'timeUnits'.

    The 'conversionFactor' attribute
    ......................................................................

    The attribute 'conversionFactor' in SBML Level 3's Model object
    defines a global value inherited by all Species object instances that
    do not define separate values for their 'conversionFactor' attributes.
    The value of this attribute must refer to a Parameter object instance
    defined in the model.  The Parameter object in question must be a
    constant; ie it must have its 'constant' attribute value set to
    ''True'.'

    If a given Species object definition does not specify a conversion
    factor via the 'conversionFactor' attribute on Species, then the
    species inherits the conversion factor specified by the Model
    'conversionFactor' attribute.  If the Model does not define a value
    for this attribute, then there is no conversion factor to inherit.
    More information about conversion factors is provided in the SBML
    Level 3 specifications.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_Model

    def __init__(self, *args):
        r"""
        __init__(Model self, unsigned int level, unsigned int version) -> Model
        __init__(Model self, SBMLNamespaces sbmlns) -> Model
        __init__(Model self, Model orig) -> Model

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            Model(long level, long version)

        Creates a new Model using the given SBML 'level' and 'version' values.

        Parameter 'level' is a long integer, the SBML Level to assign to this
        Model.

        Parameter 'version' is a long integer, the SBML Version to assign to
        this Model.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            Model(SBMLNamespaces sbmlns)

        Creates a new Model using the given SBMLNamespaces object 'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            Model(Model orig)

        Copy constructor; creates a (deep) copy of the given Model object.

        Parameter 'orig' is the object to copy.

        """
        _libsbml.Model_swiginit(self, _libsbml.new_Model(*args))

    def clone(self):
        r"""
        clone(Model self) -> Model

        Creates and returns a deep copy of this Model object.

        Returns the (deep) copy of this Model object.

        """
        return _libsbml.Model_clone(self)

    def getElementBySId(self, id):
        r"""
        getElementBySId(Model self, string id) -> SBase

        Returns the first child element found that has the given 'id'.

        This operation searches the model-wide SId identifier type namespace

        Parameter 'id' is string representing the id of the object to find.

        Returns pointer to the first element found with the given 'id', or
        'None' if no such object is found.

        """
        return _libsbml.Model_getElementBySId(self, id)

    def getElementByMetaId(self, metaid):
        r"""
        getElementByMetaId(Model self, string metaid) -> SBase

        Returns the first child element it can find with the given 'metaid'.

        Parameter 'metaid' is string representing the meta-identifier of the
        object to find.

        Returns pointer to the first element found with the given 'metaid', or
        None if no such object is found.

        """
        return _libsbml.Model_getElementByMetaId(self, metaid)

    def getId(self):
        r"""
        getId(Model self) -> string

        Returns the value of the 'id' attribute of this Model.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is now recommended to use the
        getIdAttribute() function instead.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this Model.

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.Model_getId(self)

    def getName(self):
        r"""
        getName(Model self) -> string

        Returns the value of the 'name' attribute of this Model object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns the name of this SBML object, or the empty string if not set
        or unsettable.

        See also getIdAttribute(), isSetName(), setName(), unsetName().

        """
        return _libsbml.Model_getName(self)

    def getSubstanceUnits(self):
        r"""
        getSubstanceUnits(Model self) -> string

        Returns the value of the 'substanceUnits' attribute of this Model.

        Returns the substanceUnits of this Model.

        Note: The 'substanceUnits' attribute is available in SBML Level 3 but
        is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_getSubstanceUnits(self)

    def getTimeUnits(self):
        r"""
        getTimeUnits(Model self) -> string

        Returns the value of the 'timeUnits' attribute of this Model.

        Returns the timeUnits of this Model.

        Note: The 'timeUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_getTimeUnits(self)

    def getVolumeUnits(self):
        r"""
        getVolumeUnits(Model self) -> string

        Returns the value of the 'volumeUnits' attribute of this Model.

        Returns the volumeUnits of this Model.

        Note: The 'volumeUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_getVolumeUnits(self)

    def getAreaUnits(self):
        r"""
        getAreaUnits(Model self) -> string

        Returns the value of the 'areaUnits' attribute of this Model.

        Returns the areaUnits of this Model.

        Note: The 'areaUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_getAreaUnits(self)

    def getLengthUnits(self):
        r"""
        getLengthUnits(Model self) -> string

        Returns the value of the 'lengthUnits' attribute of this Model.

        Returns the lengthUnits of this Model.

        Note: The 'lengthUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_getLengthUnits(self)

    def getExtentUnits(self):
        r"""
        getExtentUnits(Model self) -> string

        Returns the value of the 'extentUnits' attribute of this Model.

        Returns the extentUnits of this Model.

        Note: The 'extentUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_getExtentUnits(self)

    def getConversionFactor(self):
        r"""
        getConversionFactor(Model self) -> string

        Returns the value of the 'conversionFactor' attribute of this Model.

        Returns the conversionFactor of this Model.

        Note: The 'conversionFactor' attribute is available in  SBML Level 3
        but is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_getConversionFactor(self)

    def isSetId(self):
        r"""
        isSetId(Model self) -> bool

        Predicate returning 'True' if this Model's 'id' attribute is set.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is recommended that callers use
        isSetIdAttribute() instead.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
        isSetIdAttribute().

        """
        return _libsbml.Model_isSetId(self)

    def isSetName(self):
        r"""
        isSetName(Model self) -> bool

        Predicate returning 'True' if this Model's 'name' attribute is set.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns 'True' if the 'name' attribute of this SBML object is set,
        'False' otherwise.

        See also getName(), setName(), unsetName().

        """
        return _libsbml.Model_isSetName(self)

    def isSetSubstanceUnits(self):
        r"""
        isSetSubstanceUnits(Model self) -> bool

        Predicate returning 'True' if this Model's 'substanceUnits' attribute
        is set.

        Returns 'True' if the 'substanceUnits' attribute of this Model is set,
        'False' otherwise.

        Note: The 'substanceUnits' attribute is available in  SBML Level 3 but
        is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_isSetSubstanceUnits(self)

    def isSetTimeUnits(self):
        r"""
        isSetTimeUnits(Model self) -> bool

        Predicate returning 'True' if this Model's 'timeUnits' attribute is
        set.

        Returns 'True' if the 'timeUnits' attribute of this Model is set,
        'False' otherwise.

        Note: The 'substanceUnits' attribute is available in  SBML Level 3 but
        is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_isSetTimeUnits(self)

    def isSetVolumeUnits(self):
        r"""
        isSetVolumeUnits(Model self) -> bool

        Predicate returning 'True' if this Model's 'volumeUnits' attribute is
        set.

        Returns 'True' if the 'volumeUnits' attribute of this Model is set,
        'False' otherwise.

        Note: The 'volumeUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_isSetVolumeUnits(self)

    def isSetAreaUnits(self):
        r"""
        isSetAreaUnits(Model self) -> bool

        Predicate returning 'True' if this Model's 'areaUnits' attribute is
        set.

        Returns 'True' if the 'areaUnits' attribute of this Model is set,
        'False' otherwise.

        Note: The 'areaUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_isSetAreaUnits(self)

    def isSetLengthUnits(self):
        r"""
        isSetLengthUnits(Model self) -> bool

        Predicate returning 'True' if this Model's 'lengthUnits' attribute is
        set.

        Returns 'True' if the 'lengthUnits' attribute of this Model is set,
        'False' otherwise.

        Note: The 'lengthUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_isSetLengthUnits(self)

    def isSetExtentUnits(self):
        r"""
        isSetExtentUnits(Model self) -> bool

        Predicate returning 'True' if this Model's 'extentUnits' attribute is
        set.

        Returns 'True' if the 'extentUnits' attribute of this Model is set,
        'False' otherwise.

        Note: The 'extentUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_isSetExtentUnits(self)

    def isSetConversionFactor(self):
        r"""
        isSetConversionFactor(Model self) -> bool

        Predicate returning 'True' if this Model's 'conversionFactor'
        attribute is set.

        Returns 'True' if the 'conversionFactor' attribute of this Model is
        set, 'False' otherwise.

        Note: The 'conversionFactor' attribute is available in  SBML Level 3
        but is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_isSetConversionFactor(self)

    def setId(self, sid):
        r"""
        setId(Model self, string sid) -> int

        Sets the value of the 'id' attribute of this Model.

        The string 'sid' is copied.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Parameter 'sid' is the string to use as the identifier of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.Model_setId(self, sid)

    def setName(self, name):
        r"""
        setName(Model self, string name) -> int

        Sets the value of the 'name' attribute of this Model.

        The string in 'name' is copied.

        Parameter 'name' is the new name for the SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.Model_setName(self, name)

    def setSubstanceUnits(self, units):
        r"""
        setSubstanceUnits(Model self, string units) -> int

        Sets the value of the 'substanceUnits' attribute of this Model.

        The string in 'units' is copied.

        Parameter 'units' is the new substanceUnits for the Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        Note: The 'substanceUnits' attribute is available in  SBML Level 3 but
        is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_setSubstanceUnits(self, units)

    def setTimeUnits(self, units):
        r"""
        setTimeUnits(Model self, string units) -> int

        Sets the value of the 'timeUnits' attribute of this Model.

        The string in 'units' is copied.

        Parameter 'units' is the new timeUnits for the Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        Note: The 'timeUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_setTimeUnits(self, units)

    def setVolumeUnits(self, units):
        r"""
        setVolumeUnits(Model self, string units) -> int

        Sets the value of the 'volumeUnits' attribute of this Model.

        The string in 'units' is copied.

        Parameter 'units' is the new volumeUnits for the Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        Note: The 'volumeUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_setVolumeUnits(self, units)

    def setAreaUnits(self, units):
        r"""
        setAreaUnits(Model self, string units) -> int

        Sets the value of the 'areaUnits' attribute of this Model.

        The string in 'units' is copied.

        Parameter 'units' is the new areaUnits for the Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        Note: The 'areaUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_setAreaUnits(self, units)

    def setLengthUnits(self, units):
        r"""
        setLengthUnits(Model self, string units) -> int

        Sets the value of the 'lengthUnits' attribute of this Model.

        The string in 'units' is copied.

        Parameter 'units' is the new lengthUnits for the Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        Note: The 'lengthUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_setLengthUnits(self, units)

    def setExtentUnits(self, units):
        r"""
        setExtentUnits(Model self, string units) -> int

        Sets the value of the 'extentUnits' attribute of this Model.

        The string in 'units' is copied.

        Parameter 'units' is the new extentUnits for the Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        Note: The 'extentUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_setExtentUnits(self, units)

    def setConversionFactor(self, units):
        r"""
        setConversionFactor(Model self, string units) -> int

        Sets the value of the 'conversionFactor' attribute of this Model.

        The string in 'units' is copied.

        Parameter 'units' is the new conversionFactor for the Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        Note: The 'conversionFactor' attribute is available in  SBML Level 3
        but is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_setConversionFactor(self, units)

    def unsetId(self):
        r"""
        unsetId(Model self) -> int

        Unsets the value of the 'id' attribute of this Model.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.Model_unsetId(self)

    def unsetName(self):
        r"""
        unsetName(Model self) -> int

        Unsets the value of the 'name' attribute of this Model.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getName(), setName(), isSetName().

        """
        return _libsbml.Model_unsetName(self)

    def unsetSubstanceUnits(self):
        r"""
        unsetSubstanceUnits(Model self) -> int

        Unsets the value of the 'substanceUnits' attribute of this Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        Note: The 'substanceUnits' attribute is available in  SBML Level 3 but
        is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_unsetSubstanceUnits(self)

    def unsetTimeUnits(self):
        r"""
        unsetTimeUnits(Model self) -> int

        Unsets the value of the 'timeUnits' attribute of this Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        Note: The 'timeUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_unsetTimeUnits(self)

    def unsetVolumeUnits(self):
        r"""
        unsetVolumeUnits(Model self) -> int

        Unsets the value of the 'volumeUnits' attribute of this Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        Note: The 'volumeUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_unsetVolumeUnits(self)

    def unsetAreaUnits(self):
        r"""
        unsetAreaUnits(Model self) -> int

        Unsets the value of the 'areaUnits' attribute of this Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_OPERATION_FAILED

        Note: The 'areaUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_unsetAreaUnits(self)

    def unsetLengthUnits(self):
        r"""
        unsetLengthUnits(Model self) -> int

        Unsets the value of the 'lengthUnits' attribute of this Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_OPERATION_FAILED

        Note: The 'lengthUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_unsetLengthUnits(self)

    def unsetExtentUnits(self):
        r"""
        unsetExtentUnits(Model self) -> int

        Unsets the value of the 'extentUnits' attribute of this Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_OPERATION_FAILED

        Note: The 'extentUnits' attribute is available in  SBML Level 3 but is
        not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_unsetExtentUnits(self)

    def unsetConversionFactor(self):
        r"""
        unsetConversionFactor(Model self) -> int

        Unsets the value of the 'conversionFactor' attribute of this Model.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        * LIBSBML_OPERATION_FAILED

        Note: The 'conversionFactor' attribute is available in  SBML Level 3
        but is not present on Model in lower Levels of SBML.

        """
        return _libsbml.Model_unsetConversionFactor(self)

    def addFunctionDefinition(self, fd):
        r"""
        addFunctionDefinition(Model self, FunctionDefinition fd) -> int

        Adds a copy of the given FunctionDefinition object to this Model.

        Parameter 'fd' is the FunctionDefinition to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createFunctionDefinition().

        """
        return _libsbml.Model_addFunctionDefinition(self, fd)

    def addUnitDefinition(self, ud):
        r"""
        addUnitDefinition(Model self, UnitDefinition ud) -> int

        Adds a copy of the given UnitDefinition object to this Model.

        Parameter 'ud' is the UnitDefinition object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createUnitDefinition().

        """
        return _libsbml.Model_addUnitDefinition(self, ud)

    def addCompartmentType(self, ct):
        r"""
        addCompartmentType(Model self, CompartmentType ct) -> int

        Adds a copy of the given CompartmentType object to this Model.

        Parameter 'ct' is the CompartmentType object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        Note: The CompartmentType object class is only available in SBML Level
        2 Versions 2-4.  It is not available in Level 1 nor Level 3.

        See also createCompartmentType().

        """
        return _libsbml.Model_addCompartmentType(self, ct)

    def addSpeciesType(self, st):
        r"""
        addSpeciesType(Model self, SpeciesType st) -> int

        Adds a copy of the given SpeciesType object to this Model.

        Parameter 'st' is the SpeciesType object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        Note: The SpeciesType object class is only available in SBML Level 2
        Versions 2-4.  It is not available in Level 1 nor Level 3.

        See also createSpeciesType().

        """
        return _libsbml.Model_addSpeciesType(self, st)

    def addCompartment(self, c):
        r"""
        addCompartment(Model self, Compartment c) -> int

        Adds a copy of the given Compartment object to this Model.

        Parameter 'c' is the Compartment object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createCompartment().

        """
        return _libsbml.Model_addCompartment(self, c)

    def addSpecies(self, s):
        r"""
        addSpecies(Model self, Species s) -> int

        Adds a copy of the given Species object to this Model.

        Parameter 's' is the Species object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createSpecies().

        """
        return _libsbml.Model_addSpecies(self, s)

    def addParameter(self, p):
        r"""
        addParameter(Model self, Parameter p) -> int

        Adds a copy of the given Parameter object to this Model.

        Parameter 'p' is the Parameter object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createParameter().

        """
        return _libsbml.Model_addParameter(self, p)

    def addInitialAssignment(self, ia):
        r"""
        addInitialAssignment(Model self, InitialAssignment ia) -> int

        Adds a copy of the given InitialAssignment object to this Model.

        Parameter 'ia' is the InitialAssignment object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createInitialAssignment().

        """
        return _libsbml.Model_addInitialAssignment(self, ia)

    def addRule(self, r):
        r"""
        addRule(Model self, Rule r) -> int

        Adds a copy of the given Rule object to this Model.

        Parameter 'r' is the Rule object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createAlgebraicRule(), createAssignmentRule(),
        createRateRule().

        """
        return _libsbml.Model_addRule(self, r)

    def addConstraint(self, c):
        r"""
        addConstraint(Model self, Constraint c) -> int

        Adds a copy of the given Constraint object to this Model.

        Parameter 'c' is the Constraint object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createConstraint().

        """
        return _libsbml.Model_addConstraint(self, c)

    def addReaction(self, r):
        r"""
        addReaction(Model self, Reaction r) -> int

        Adds a copy of the given Reaction object to this Model.

        Parameter 'r' is the Reaction object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createReaction().

        """
        return _libsbml.Model_addReaction(self, r)

    def addEvent(self, e):
        r"""
        addEvent(Model self, Event e) -> int

        Adds a copy of the given Event object to this Model.

        Parameter 'e' is the Event object to add.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_DUPLICATE_OBJECT_ID

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createEvent().

        """
        return _libsbml.Model_addEvent(self, e)

    def createFunctionDefinition(self):
        r"""
        createFunctionDefinition(Model self) -> FunctionDefinition

        Creates a new FunctionDefinition inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the FunctionDefinition object created.

        See also addFunctionDefinition().

        """
        return _libsbml.Model_createFunctionDefinition(self)

    def createUnitDefinition(self):
        r"""
        createUnitDefinition(Model self) -> UnitDefinition

        Creates a new UnitDefinition inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the UnitDefinition object created.

        See also addUnitDefinition().

        """
        return _libsbml.Model_createUnitDefinition(self)

    def createUnit(self):
        r"""
        createUnit(Model self) -> Unit

        Creates a new Unit object within the last UnitDefinition object
        created in this model and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The mechanism by which the UnitDefinition was created is not
        significant.  If a UnitDefinition object does not exist in this model,
        a new Unit is not created and 'None' is returned instead.

        Returns the Unit object created.

        See also addUnitDefinition().

        """
        return _libsbml.Model_createUnit(self)

    def createCompartmentType(self):
        r"""
        createCompartmentType(Model self) -> CompartmentType

        Creates a new CompartmentType inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the CompartmentType object created.

        Note: The CompartmentType object class is only available in SBML Level
        2 Versions 2-4.  It is not available in Level 1 nor Level 3.

        See also addCompartmentType().

        """
        return _libsbml.Model_createCompartmentType(self)

    def createSpeciesType(self):
        r"""
        createSpeciesType(Model self) -> SpeciesType

        Creates a new SpeciesType inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the SpeciesType object created.

        Note: The SpeciesType object class is only available in SBML Level 2
        Versions 2-4.  It is not available in Level 1 nor Level 3.

        See also addSpeciesType().

        """
        return _libsbml.Model_createSpeciesType(self)

    def createCompartment(self):
        r"""
        createCompartment(Model self) -> Compartment

        Creates a new Compartment inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the Compartment object created.

        See also addCompartment().

        """
        return _libsbml.Model_createCompartment(self)

    def createSpecies(self):
        r"""
        createSpecies(Model self) -> Species

        Creates a new Species inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the Species object created.

        See also addSpecies().

        """
        return _libsbml.Model_createSpecies(self)

    def createParameter(self):
        r"""
        createParameter(Model self) -> Parameter

        Creates a new Parameter inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the Parameter object created.

        See also addParameter().

        """
        return _libsbml.Model_createParameter(self)

    def createInitialAssignment(self):
        r"""
        createInitialAssignment(Model self) -> InitialAssignment

        Creates a new InitialAssignment inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the InitialAssignment object created.

        See also addInitialAssignment().

        """
        return _libsbml.Model_createInitialAssignment(self)

    def createAlgebraicRule(self):
        r"""
        createAlgebraicRule(Model self) -> AlgebraicRule

        Creates a new AlgebraicRule inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the AlgebraicRule object created.

        See also addRule().

        """
        return _libsbml.Model_createAlgebraicRule(self)

    def createAssignmentRule(self):
        r"""
        createAssignmentRule(Model self) -> AssignmentRule

        Creates a new AssignmentRule inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the AssignmentRule object created.

        See also addRule().

        """
        return _libsbml.Model_createAssignmentRule(self)

    def createRateRule(self):
        r"""
        createRateRule(Model self) -> RateRule

        Creates a new RateRule inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the RateRule object created.

        See also addRule().

        """
        return _libsbml.Model_createRateRule(self)

    def createConstraint(self):
        r"""
        createConstraint(Model self) -> Constraint

        Creates a new Constraint inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the Constraint object created.

        See also addConstraint().

        """
        return _libsbml.Model_createConstraint(self)

    def createReaction(self):
        r"""
        createReaction(Model self) -> Reaction

        Creates a new Reaction inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the Reaction object created.

        See also addReaction().

        """
        return _libsbml.Model_createReaction(self)

    def createReactant(self):
        r"""
        createReactant(Model self) -> SpeciesReference

        Creates a new SpeciesReference object for a reactant inside the last
        Reaction object in this Model, and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The mechanism by which the last Reaction object was created and added
        to this Model is not significant.  It could have been created in a
        variety of ways, for example using createReaction().  If a Reaction
        does not exist for this model, a new SpeciesReference is not created
        and 'None' is returned instead.

        Returns the SpeciesReference object created.  If a Reaction does not
        exist for this model, a new SpeciesReference is not created and 'None'
        is returned.

        """
        return _libsbml.Model_createReactant(self)

    def createProduct(self):
        r"""
        createProduct(Model self) -> SpeciesReference

        Creates a new SpeciesReference object for a product inside the last
        Reaction object in this Model, and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The mechanism by which the last Reaction object was created and added
        to this Model is not significant.  It could have been created in a
        variety of ways, for example using createReaction().  If a Reaction
        does not exist for this model, a new SpeciesReference is not created
        and 'None' is returned instead.

        Returns the SpeciesReference object created. If a Reaction does not
        exist for this model, a new SpeciesReference is not created and 'None'
        is returned.

        """
        return _libsbml.Model_createProduct(self)

    def createModifier(self):
        r"""
        createModifier(Model self) -> ModifierSpeciesReference

        Creates a new ModifierSpeciesReference object for a modifier species
        inside the last Reaction object in this Model, and returns a pointer
        to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The mechanism by which the last Reaction object was created and added
        to this Model is not significant.  It could have been created in a
        variety of ways, for example using createReaction().  If a Reaction
        does not exist for this model, a new SpeciesReference is not created
        and 'None' is returned instead.

        Returns the SpeciesReference object created.  If a Reaction does not
        exist for this model, a new SpeciesReference is not created and 'None'
        is returned.

        """
        return _libsbml.Model_createModifier(self)

    def createKineticLaw(self):
        r"""
        createKineticLaw(Model self) -> KineticLaw

        Creates a new KineticLaw inside the last Reaction object created in
        this Model, and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The mechanism by which the last Reaction object was created and added
        to this Model is not significant.  It could have been created in a
        variety of ways, for example using createReaction().  If a Reaction
        does not exist for this model, a new SpeciesReference is not created
        and 'None' is returned instead.

        Returns the KineticLaw object created.  If a Reaction does not exist
        for this model, or a Reaction does exist but already has a KineticLaw,
        a new KineticLaw is not created and 'None' is returned.

        """
        return _libsbml.Model_createKineticLaw(self)

    def createKineticLawParameter(self):
        r"""
        createKineticLawParameter(Model self) -> Parameter

        Creates a new local Parameter inside the KineticLaw object of the last
        Reaction created inside this Model, and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The last KineticLaw object in this Model could have been created in a
        variety of ways.  For example, it could have been added using
        createKineticLaw(), or it could be the result of using
        Reaction.createKineticLaw() on the Reaction object created by a
        createReaction().  If a Reaction does not exist for this model, or the
        last Reaction does not contain a KineticLaw object, a new Parameter is
        not created and 'None' is returned instead.

        Returns the Parameter object created.  If a Reaction does not exist
        for this model, or a KineticLaw for the Reaction does not exist, a new
        Parameter is not created and 'None' is returned.

        """
        return _libsbml.Model_createKineticLawParameter(self)

    def createKineticLawLocalParameter(self):
        r"""
        createKineticLawLocalParameter(Model self) -> LocalParameter

        Creates a new LocalParameter inside the KineticLaw object of the last
        Reaction created inside this Model, and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The last KineticLaw object in this Model could have been created in a
        variety of ways.  For example, it could have been added using
        createKineticLaw(), or it could be the result of using
        Reaction.createKineticLaw() on the Reaction object created by a
        createReaction().  If a Reaction does not exist for this model, or the
        last Reaction does not contain a KineticLaw object, a new Parameter is
        not created and 'None' is returned instead.

        Returns the Parameter object created.  If a Reaction does not exist
        for this model, or a KineticLaw for the Reaction does not exist, a new
        Parameter is not created and 'None' is returned.

        """
        return _libsbml.Model_createKineticLawLocalParameter(self)

    def createEvent(self):
        r"""
        createEvent(Model self) -> Event

        Creates a new Event inside this Model and returns it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        Returns the Event object created.

        """
        return _libsbml.Model_createEvent(self)

    def createEventAssignment(self):
        r"""
        createEventAssignment(Model self) -> EventAssignment

        Creates a new EventAssignment inside the last Event object created in
        this Model, and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The mechanism by which the last Event object in this model was
        created is not significant.  It could have been created in a variety
        of ways, for example by using createEvent().  If no Event object
        exists in this Model object, a new EventAssignment is not created and
        'None' is returned instead.

        Returns the EventAssignment object created.

        """
        return _libsbml.Model_createEventAssignment(self)

    def createTrigger(self):
        r"""
        createTrigger(Model self) -> Trigger

        Creates a new Trigger inside the last Event object created in this
        Model, and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The mechanism by which the last Event object in this model was
        created is not significant.  It could have been created in a variety
        of ways, for example by using createEvent().  If no Event object
        exists in this Model object, a new EventAssignment is not created and
        'None' is returned instead.

        Returns the Trigger object created.

        """
        return _libsbml.Model_createTrigger(self)

    def createDelay(self):
        r"""
        createDelay(Model self) -> Delay

        Creates a new Delay inside the last Event object created in this
        Model, and returns a pointer to it.

        The SBML Level and Version of the enclosing Model object, as well as
        any SBML package namespaces, are used to initialize this object's
        corresponding attributes.

        The mechanism by which the last Event object in this model was
        created is not significant.  It could have been created in a variety
        of ways, for example by using createEvent().  If no Event object
        exists in this Model object, a new EventAssignment is not created and
        'None' is returned instead.

        Returns the Delay object created.

        """
        return _libsbml.Model_createDelay(self)

    def setAnnotation(self, *args):
        r"""
        setAnnotation(Model self, XMLNode annotation) -> int
        setAnnotation(Model self, string annotation) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            setAnnotation(XMLNode annotation)

        Sets the value of the 'annotation' subelement of this SBML object to a
        copy of 'annotation'.

        Any existing content of the 'annotation' subelement is discarded.
        Unless you have taken steps to first copy and reconstitute any
        existing annotations into the 'annotation' that is about to be
        assigned, it is likely that performing such wholesale replacement is
        unfriendly towards other software applications whose annotations are
        discarded.  An alternative may be to use appendAnnotation().

        Parameter 'annotation' is an XML structure that is to be used as the
        content of the 'annotation' subelement of this object.

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        See also appendAnnotation().

        ______________________________________________________________________
        Method variant with the following signature:

            setAnnotation(string annotation)

        Sets the value of the 'annotation' subelement of this SBML object to a
        copy of 'annotation'.

        Any existing content of the 'annotation' subelement is discarded.
        Unless you have taken steps to first copy and reconstitute any
        existing annotations into the 'annotation' that is about to be
        assigned, it is likely that performing such wholesale replacement is
        unfriendly towards other software applications whose annotations are
        discarded.  An alternative may be to use appendAnnotation().

        Parameter 'annotation' is an XML string that is to be used as the
        content of the 'annotation' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also appendAnnotation().

        """
        return _libsbml.Model_setAnnotation(self, *args)

    def appendAnnotation(self, *args):
        r"""
        appendAnnotation(Model self, XMLNode annotation) -> int
        appendAnnotation(Model self, string annotation) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            appendAnnotation(XMLNode annotation)

        Appends annotation content to any existing content in the 'annotation'
        subelement of this object.

        The content in 'annotation' is copied.  Unlike setAnnotation(), this
        method allows other annotations to be preserved when an application
        adds its own data.

        Parameter 'annotation' is an XML structure that is to be copied and
        appended to the content of the 'annotation' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also setAnnotation().

        ______________________________________________________________________
        Method variant with the following signature:

            appendAnnotation(string annotation)

        Appends annotation content to any existing content in the 'annotation'
        subelement of this object.

        The content in 'annotation' is copied.  Unlike setAnnotation(), this
        method allows other annotations to be preserved when an application
        adds its own data.

        Parameter 'annotation' is an XML string that is to be copied and
        appended to the content of the 'annotation' subelement of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also setAnnotation().

        """
        return _libsbml.Model_appendAnnotation(self, *args)

    def getListOfFunctionDefinitions(self, *args):
        r"""
        getListOfFunctionDefinitions(Model self) -> ListOfFunctionDefinitions
        getListOfFunctionDefinitions(Model self) -> ListOfFunctionDefinitions

        Get the ListOfFunctionDefinitions object in this Model.

        Returns the list of FunctionDefinitions for this Model.

        """
        return _libsbml.Model_getListOfFunctionDefinitions(self, *args)

    def getListOfUnitDefinitions(self, *args):
        r"""
        getListOfUnitDefinitions(Model self) -> ListOfUnitDefinitions
        getListOfUnitDefinitions(Model self) -> ListOfUnitDefinitions

        Get the ListOfUnitDefinitions object in this Model.

        Returns the list of UnitDefinitions for this Model.

        """
        return _libsbml.Model_getListOfUnitDefinitions(self, *args)

    def getListOfCompartmentTypes(self, *args):
        r"""
        getListOfCompartmentTypes(Model self) -> ListOfCompartmentTypes
        getListOfCompartmentTypes(Model self) -> ListOfCompartmentTypes

        Get the ListOfCompartmentTypes object in this Model.

        Returns the list of CompartmentTypes for this Model.

        Note: The CompartmentType object class is only available in SBML Level
        2 Versions 2-4.  It is not available in Level 1 nor Level 3.

        """
        return _libsbml.Model_getListOfCompartmentTypes(self, *args)

    def getListOfSpeciesTypes(self, *args):
        r"""
        getListOfSpeciesTypes(Model self) -> ListOfSpeciesTypes
        getListOfSpeciesTypes(Model self) -> ListOfSpeciesTypes

        Get the ListOfSpeciesTypes object in this Model.

        Returns the list of SpeciesTypes for this Model.

        Note: The SpeciesType object class is only available in SBML Level 2
        Versions 2-4.  It is not available in Level 1 nor Level 3.

        """
        return _libsbml.Model_getListOfSpeciesTypes(self, *args)

    def getListOfCompartments(self, *args):
        r"""
        getListOfCompartments(Model self) -> ListOfCompartments
        getListOfCompartments(Model self) -> ListOfCompartments

        Get the ListOfCompartments object in this Model.

        Returns the list of Compartments for this Model.

        """
        return _libsbml.Model_getListOfCompartments(self, *args)

    def getListOfSpecies(self, *args):
        r"""
        getListOfSpecies(Model self) -> ListOfSpecies
        getListOfSpecies(Model self) -> ListOfSpecies

        Get the ListOfSpecies object in this Model.

        Returns the list of Species for this Model.

        """
        return _libsbml.Model_getListOfSpecies(self, *args)

    def getListOfParameters(self, *args):
        r"""
        getListOfParameters(Model self) -> ListOfParameters
        getListOfParameters(Model self) -> ListOfParameters

        Get the ListOfParameters object in this Model.

        Returns the list of Parameters for this Model.

        """
        return _libsbml.Model_getListOfParameters(self, *args)

    def getListOfInitialAssignments(self, *args):
        r"""
        getListOfInitialAssignments(Model self) -> ListOfInitialAssignments
        getListOfInitialAssignments(Model self) -> ListOfInitialAssignments

        Get the ListOfInitialAssignments object in this Model.

        Returns the list of InitialAssignments for this Model.

        """
        return _libsbml.Model_getListOfInitialAssignments(self, *args)

    def getListOfRules(self, *args):
        r"""
        getListOfRules(Model self) -> ListOfRules
        getListOfRules(Model self) -> ListOfRules

        Get the ListOfRules object in this Model.

        Returns the list of Rules for this Model.

        """
        return _libsbml.Model_getListOfRules(self, *args)

    def getListOfConstraints(self, *args):
        r"""
        getListOfConstraints(Model self) -> ListOfConstraints
        getListOfConstraints(Model self) -> ListOfConstraints

        Get the ListOfConstraints object in this Model.

        Returns the list of Constraints for this Model.

        """
        return _libsbml.Model_getListOfConstraints(self, *args)

    def getListOfReactions(self, *args):
        r"""
        getListOfReactions(Model self) -> ListOfReactions
        getListOfReactions(Model self) -> ListOfReactions

        Get the ListOfReactions object in this Model.

        Returns the list of Reactions for this Model.

        """
        return _libsbml.Model_getListOfReactions(self, *args)

    def getListOfEvents(self, *args):
        r"""
        getListOfEvents(Model self) -> ListOfEvents
        getListOfEvents(Model self) -> ListOfEvents

        Get the ListOfEvents object in this Model.

        Returns the list of Events for this Model.

        """
        return _libsbml.Model_getListOfEvents(self, *args)

    def getFunctionDefinition(self, *args):
        r"""
        getFunctionDefinition(Model self, unsigned int n) -> FunctionDefinition
        getFunctionDefinition(Model self, unsigned int n) -> FunctionDefinition
        getFunctionDefinition(Model self, string sid) -> FunctionDefinition
        getFunctionDefinition(Model self, string sid) -> FunctionDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getFunctionDefinition(long n)

        Get the nth FunctionDefinitions object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth FunctionDefinition of this Model. If the index 'n' is
        invalid, 'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getFunctionDefinition(string sid)

        Get a FunctionDefinition object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the FunctionDefinition in this Model with the identifier 'sid'
        or 'None' if no such FunctionDefinition exists.

        """
        return _libsbml.Model_getFunctionDefinition(self, *args)

    def getUnitDefinition(self, *args):
        r"""
        getUnitDefinition(Model self, unsigned int n) -> UnitDefinition
        getUnitDefinition(Model self, unsigned int n) -> UnitDefinition
        getUnitDefinition(Model self, string sid) -> UnitDefinition
        getUnitDefinition(Model self, string sid) -> UnitDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getUnitDefinition(long n)

        Get the nth UnitDefinition object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth UnitDefinition of this Model. If the index 'n' is
        invalid, 'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getUnitDefinition(string sid)

        Get a UnitDefinition based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the UnitDefinition in this Model with the identifier 'sid' or
        'None' if no such UnitDefinition exists.

        """
        return _libsbml.Model_getUnitDefinition(self, *args)

    def getCompartmentType(self, *args):
        r"""
        getCompartmentType(Model self, unsigned int n) -> CompartmentType
        getCompartmentType(Model self, unsigned int n) -> CompartmentType
        getCompartmentType(Model self, string sid) -> CompartmentType
        getCompartmentType(Model self, string sid) -> CompartmentType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getCompartmentType(long n)

        Get the nth CompartmentType object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth CompartmentType of this Model. If the index 'n' is
        invalid, 'None' is returned.

        Note: The CompartmentType object class is only available in SBML Level
        2 Versions 2-4.  It is not available in Level 1 nor Level 3.

        ______________________________________________________________________
        Method variant with the following signature:

            getCompartmentType(string sid)

        Get a CompartmentType object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the CompartmentType in this Model with the identifier 'sid' or
        'None' if no such CompartmentType exists.

        Note: The CompartmentType object class is only available in SBML Level
        2 Versions 2-4.  It is not available in Level 1 nor Level 3.

        """
        return _libsbml.Model_getCompartmentType(self, *args)

    def getSpeciesType(self, *args):
        r"""
        getSpeciesType(Model self, unsigned int n) -> SpeciesType
        getSpeciesType(Model self, unsigned int n) -> SpeciesType
        getSpeciesType(Model self, string sid) -> SpeciesType
        getSpeciesType(Model self, string sid) -> SpeciesType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getSpeciesType(long n)

        Get the nth SpeciesType object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth SpeciesType of this Model. If the index 'n' is
        invalid, 'None' is returned.

        Note: The SpeciesType object class is only available in SBML Level 2
        Versions 2-4.  It is not available in Level 1 nor Level 3.

        ______________________________________________________________________
        Method variant with the following signature:

            getSpeciesType(string sid)

        Get a SpeciesType object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the SpeciesType in this Model with the identifier 'sid' or
        'None' if no such SpeciesType exists.

        Note: The SpeciesType object class is only available in SBML Level 2
        Versions 2-4.  It is not available in Level 1 nor Level 3.

        """
        return _libsbml.Model_getSpeciesType(self, *args)

    def getCompartment(self, *args):
        r"""
        getCompartment(Model self, unsigned int n) -> Compartment
        getCompartment(Model self, unsigned int n) -> Compartment
        getCompartment(Model self, string sid) -> Compartment
        getCompartment(Model self, string sid) -> Compartment

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getCompartment(long n)

        Get the nth Compartment object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth Compartment of this Model. If the index 'n' is
        invalid, 'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getCompartment(string sid)

        Get a Compartment object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the Compartment in this Model with the identifier 'sid' or
        'None' if no such Compartment exists.

        """
        return _libsbml.Model_getCompartment(self, *args)

    def getSpecies(self, *args):
        r"""
        getSpecies(Model self, unsigned int n) -> Species
        getSpecies(Model self, unsigned int n) -> Species
        getSpecies(Model self, string sid) -> Species
        getSpecies(Model self, string sid) -> Species

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getSpecies(long n)

        Get the nth Species object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth Species of this Model. If the index 'n' is invalid,
        'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getSpecies(string sid)

        Get a Species object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the Species in this Model with the identifier 'sid' or 'None'
        if no such Species exists.

        """
        return _libsbml.Model_getSpecies(self, *args)

    def getParameter(self, *args):
        r"""
        getParameter(Model self, unsigned int n) -> Parameter
        getParameter(Model self, unsigned int n) -> Parameter
        getParameter(Model self, string sid) -> Parameter
        getParameter(Model self, string sid) -> Parameter

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getParameter(long n)

        Get the nth Parameter object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth Parameter of this Model. If the index 'n' is invalid,
        'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getParameter(string sid)

        Get a Parameter object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the Parameter in this Model with the identifier 'sid' or
        'None' if no such Parameter exists.

        """
        return _libsbml.Model_getParameter(self, *args)

    def getInitialAssignment(self, *args):
        r"""
        getInitialAssignment(Model self, unsigned int n) -> InitialAssignment
        getInitialAssignment(Model self, unsigned int n) -> InitialAssignment
        getInitialAssignment(Model self, string symbol) -> InitialAssignment
        getInitialAssignment(Model self, string symbol) -> InitialAssignment

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getInitialAssignment(long n)

        Get the nth InitialAssignment object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth InitialAssignment of this Model. If the index 'n' is
        invalid, 'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getInitialAssignment(string symbol)

        Get an InitialAssignment object based on the symbol to which it
        assigns a value.

        Parameter 'symbol' is the symbol to search for.

        Returns the InitialAssignment in this Model with the given 'symbol'
        attribute value or 'None' if no such InitialAssignment exists.

        """
        return _libsbml.Model_getInitialAssignment(self, *args)

    def getInitialAssignmentBySymbol(self, *args):
        r"""
        getInitialAssignmentBySymbol(Model self, string symbol) -> InitialAssignment
        getInitialAssignmentBySymbol(Model self, string symbol) -> InitialAssignment

        Get an InitialAssignment object based on the symbol to which it
        assigns a value.

        Parameter 'symbol' is the symbol to search for.

        Returns the InitialAssignment in this Model with the given 'symbol'
        attribute value or 'None' if no such InitialAssignment exists.

        """
        return _libsbml.Model_getInitialAssignmentBySymbol(self, *args)

    def getRule(self, *args):
        r"""
        getRule(Model self, unsigned int n) -> Rule
        getRule(Model self, unsigned int n) -> Rule
        getRule(Model self, string variable) -> Rule
        getRule(Model self, string variable) -> Rule

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getRule(long n)

        Get the nth Rule object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth Rule of this Model. If the index 'n' is invalid,
        'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getRule(string variable)

        Get a Rule object based on the variable to which it assigns a value.

        Parameter 'variable' is the variable to search for.

        Returns the Rule in this Model with the given 'variable' attribute
        value or 'None' if no such Rule exists.

        """
        return _libsbml.Model_getRule(self, *args)

    def getRuleByVariable(self, *args):
        r"""
        getRuleByVariable(Model self, string variable) -> Rule
        getRuleByVariable(Model self, string variable) -> Rule

        Get a Rule object based on the variable to which it assigns a value.

        Parameter 'variable' is the variable to search for.

        Returns the Rule in this Model with the given 'variable' attribute
        value or 'None' if no such Rule exists.

        """
        return _libsbml.Model_getRuleByVariable(self, *args)

    def getAssignmentRule(self, *args):
        r"""
        getAssignmentRule(Model self, string variable) -> AssignmentRule
        getAssignmentRule(Model self, string variable) -> AssignmentRule

        Get a Rule object based on the variable to which it assigns a value.

        Parameter 'variable' is the variable to search for.

        Returns the Rule in this Model with the given 'variable' attribute
        value or 'None' if no such Rule exists.

        """
        return _libsbml.Model_getAssignmentRule(self, *args)

    def getRateRule(self, *args):
        r"""
        getRateRule(Model self, string variable) -> RateRule
        getRateRule(Model self, string variable) -> RateRule

        Get a Rule object based on the variable to which it assigns a value.

        Parameter 'variable' is the symbol to search for.

        Returns the Rule in this Model with the given 'variable' attribute
        value or 'None' if no such Rule exists.

        """
        return _libsbml.Model_getRateRule(self, *args)

    def getAssignmentRuleByVariable(self, *args):
        r"""
        getAssignmentRuleByVariable(Model self, string variable) -> AssignmentRule
        getAssignmentRuleByVariable(Model self, string variable) -> AssignmentRule

        Get a Rule object based on the variable to which it assigns a value.

        Parameter 'variable' is the variable to search for.

        Returns the Rule in this Model with the given 'variable' attribute
        value or 'None' if no such Rule exists.

        """
        return _libsbml.Model_getAssignmentRuleByVariable(self, *args)

    def getRateRuleByVariable(self, *args):
        r"""
        getRateRuleByVariable(Model self, string variable) -> RateRule
        getRateRuleByVariable(Model self, string variable) -> RateRule

        Get a Rule object based on the variable to which it assigns a value.

        Parameter 'variable' is the variable to search for.

        Returns the Rule in this Model with the given 'variable' attribute
        value or 'None' if no such Rule exists.

        """
        return _libsbml.Model_getRateRuleByVariable(self, *args)

    def getConstraint(self, *args):
        r"""
        getConstraint(Model self, unsigned int n) -> Constraint
        getConstraint(Model self, unsigned int n) -> Constraint

        Get the nth Constraint object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth Constraint of this Model. If the index 'n' is invalid,
        'None' is returned.

        """
        return _libsbml.Model_getConstraint(self, *args)

    def getReaction(self, *args):
        r"""
        getReaction(Model self, unsigned int n) -> Reaction
        getReaction(Model self, unsigned int n) -> Reaction
        getReaction(Model self, string sid) -> Reaction
        getReaction(Model self, string sid) -> Reaction

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getReaction(long n)

        Get the nth Reaction object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth Reaction of this Model. If the index 'n' is invalid,
        'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getReaction(string sid)

        Get a Reaction object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the Reaction in this Model with the identifier 'sid' or 'None'
        if no such Reaction exists.

        """
        return _libsbml.Model_getReaction(self, *args)

    def getSpeciesReference(self, *args):
        r"""
        getSpeciesReference(Model self, string sid) -> SpeciesReference
        getSpeciesReference(Model self, string sid) -> SpeciesReference

        Get a SpeciesReference object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the SpeciesReference in this Model with the identifier 'sid'
        or 'None' if no such SpeciesReference exists.

        """
        return _libsbml.Model_getSpeciesReference(self, *args)

    def getModifierSpeciesReference(self, *args):
        r"""
        getModifierSpeciesReference(Model self, string sid) -> ModifierSpeciesReference
        getModifierSpeciesReference(Model self, string sid) -> ModifierSpeciesReference

        Get a ModifierSpeciesReference object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the ModifierSpeciesReference in this Model with the
        identifier 'sid' or 'None' if no such ModifierSpeciesReference exists.

        """
        return _libsbml.Model_getModifierSpeciesReference(self, *args)

    def getEvent(self, *args):
        r"""
        getEvent(Model self, unsigned int n) -> Event
        getEvent(Model self, unsigned int n) -> Event
        getEvent(Model self, string sid) -> Event
        getEvent(Model self, string sid) -> Event

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getEvent(long n)

        Get the nth Event object in this Model.

        Parameter 'n' is the index of the object to return.

        Returns the nth Event of this Model. If the index 'n' is invalid,
        'None' is returned.

        ______________________________________________________________________
        Method variant with the following signature:

            getEvent(string sid)

        Get an Event object based on its identifier.

        Parameter 'sid' is the identifier to search for.

        Returns the Event in this Model with the identifier 'sid' or 'None' if
        no such Event exists.

        """
        return _libsbml.Model_getEvent(self, *args)

    def getNumFunctionDefinitions(self):
        r"""
        getNumFunctionDefinitions(Model self) -> unsigned int

        Get the number of FunctionDefinition objects in this Model.

        Returns the number of FunctionDefinitions in this Model.

        """
        return _libsbml.Model_getNumFunctionDefinitions(self)

    def getNumUnitDefinitions(self):
        r"""
        getNumUnitDefinitions(Model self) -> unsigned int

        Get the number of UnitDefinition objects in this Model.

        Returns the number of UnitDefinitions in this Model.

        """
        return _libsbml.Model_getNumUnitDefinitions(self)

    def getNumCompartmentTypes(self):
        r"""
        getNumCompartmentTypes(Model self) -> unsigned int

        Get the number of CompartmentType objects in this Model.

        Returns the number of CompartmentTypes in this Model.

        Note: The CompartmentType object class is only available in SBML Level
        2 Versions 2-4.  It is not available in Level 1 nor Level 3.

        """
        return _libsbml.Model_getNumCompartmentTypes(self)

    def getNumSpeciesTypes(self):
        r"""
        getNumSpeciesTypes(Model self) -> unsigned int

        Get the number of SpeciesType objects in this Model.

        Returns the number of SpeciesTypes in this Model.

        Note: The SpeciesType object class is only available in SBML Level 2
        Versions 2-4.  It is not available in Level 1 nor Level 3.

        """
        return _libsbml.Model_getNumSpeciesTypes(self)

    def getNumCompartments(self):
        r"""
        getNumCompartments(Model self) -> unsigned int

        Get the number of Compartment objects in this Model.

        Returns the number of Compartments in this Model.

        """
        return _libsbml.Model_getNumCompartments(self)

    def getNumSpecies(self):
        r"""
        getNumSpecies(Model self) -> unsigned int

        Get the number of Species objects in this Model.

        Returns the number of Species in this Model.

        """
        return _libsbml.Model_getNumSpecies(self)

    def getNumSpeciesWithBoundaryCondition(self):
        r"""
        getNumSpeciesWithBoundaryCondition(Model self) -> unsigned int

        Get the number of Species in this Model having their
        'boundaryCondition' attribute value set to 'True.'

        Returns the number of Species in this Model with boundaryCondition set
        to true.

        """
        return _libsbml.Model_getNumSpeciesWithBoundaryCondition(self)

    def getNumParameters(self):
        r"""
        getNumParameters(Model self) -> unsigned int

        Get the number of Parameter objects in this Model.

        Returns the number of Parameters in this Model.  Parameters defined in
        KineticLaws are not included.

        """
        return _libsbml.Model_getNumParameters(self)

    def getNumInitialAssignments(self):
        r"""
        getNumInitialAssignments(Model self) -> unsigned int

        Get the number of InitialAssignment objects in this Model.

        Returns the number of InitialAssignments in this Model.

        """
        return _libsbml.Model_getNumInitialAssignments(self)

    def getNumRules(self):
        r"""
        getNumRules(Model self) -> unsigned int

        Get the number of Rule objects in this Model.

        Returns the number of Rules in this Model.

        """
        return _libsbml.Model_getNumRules(self)

    def getNumConstraints(self):
        r"""
        getNumConstraints(Model self) -> unsigned int

        Get the number of Constraint objects in this Model.

        Returns the number of Constraints in this Model.

        """
        return _libsbml.Model_getNumConstraints(self)

    def getNumReactions(self):
        r"""
        getNumReactions(Model self) -> unsigned int

        Get the number of Reaction objects in this Model.

        Returns the number of Reactions in this Model.

        """
        return _libsbml.Model_getNumReactions(self)

    def getNumEvents(self):
        r"""
        getNumEvents(Model self) -> unsigned int

        Get the number of Event objects in this Model.

        Returns the number of Events in this Model.

        """
        return _libsbml.Model_getNumEvents(self)

    def removeFromParentAndDelete(self):
        r"""
        removeFromParentAndDelete(Model self) -> int

        Remove this Model from its parent SBMLDocument object.

        This works by finding this Model's parent SBMLDocument and then
        calling setModel(None) on it, indirectly deleting itself. Overridden
        from the SBase function since the parent is not a ListOf.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        """
        return _libsbml.Model_removeFromParentAndDelete(self)

    def renameAllIds(self, idTransformer, filter=None):
        r"""
        renameAllIds(Model self, IdentifierTransformer idTransformer, ElementFilter filter=None) -> int

        Internal implementation method.

        """
        return _libsbml.Model_renameAllIds(self, idTransformer, filter)

    def renameSIdRefs(self, oldid, newid):
        r"""
        renameSIdRefs(Model self, string oldid, string newid)

        Replaces all uses of a given 'SIdRef' type attribute value with
        another value.

        In SBML, object identifiers are of a data type called SId. In SBML
        Level 3, an explicit data type called SIdRef was introduced for
        attribute values that refer to SId values; in previous Levels of SBML,
        this data type did not exist and attributes were simply described to
        as 'referring to an identifier', but the effective data type was the
        same as SIdRef in Level 3.  These and other methods of libSBML refer
        to the type SIdRef for all Levels of SBML, even if the corresponding
        SBML specification did not explicitly name the data type.

        This method works by looking at all attributes and (if appropriate)
        mathematical formulas in MathML content, comparing the referenced
        identifiers to the value of 'oldid'.  If any matches are found, the
        matching values are replaced with 'newid'.  The method does not
        descend into child elements.

        Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
        identifier.

        """
        return _libsbml.Model_renameSIdRefs(self, oldid, newid)

    def renameUnitSIdRefs(self, oldid, newid):
        r"""
        renameUnitSIdRefs(Model self, string oldid, string newid)

        Replaces all uses of a given 'UnitSIdRef' type attribute value with
        another value.

        In SBML, unit definitions have identifiers of type UnitSId.  In SBML
        Level 3, an explicit data type called UnitSIdRef was introduced for
        attribute values that refer to UnitSId values; in previous Levels of
        SBML, this data type did not exist and attributes were simply
        described to as 'referring to a unit identifier', but the effective
        data type was the same as UnitSIdRef in Level 3.  These and other
        methods of libSBML refer to the type UnitSIdRef for all Levels of
        SBML, even if the corresponding SBML specification did not explicitly
        name the data type.

        This method works by looking at all unit identifier attribute values
        (including, if appropriate, inside mathematical formulas), comparing
        the referenced unit identifiers to the value of 'oldid'.  If any
        matches are found, the matching values are replaced with 'newid'.  The
        method does not descend into child elements.

        Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
        identifier.

        """
        return _libsbml.Model_renameUnitSIdRefs(self, oldid, newid)

    def convertL1ToL2(self):
        r"""
        convertL1ToL2(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_convertL1ToL2(self)

    def convertL1ToL3(self, addDefaultUnits=True):
        r"""
        convertL1ToL3(Model self, bool addDefaultUnits=True)

        Internal implementation method.

        """
        return _libsbml.Model_convertL1ToL3(self, addDefaultUnits)

    def convertL2ToL3(self, strict=False, addDefaultUnits=True):
        r"""
        convertL2ToL3(Model self, bool strict=False, bool addDefaultUnits=True)

        Internal implementation method.

        """
        return _libsbml.Model_convertL2ToL3(self, strict, addDefaultUnits)

    def convertL2ToL1(self, strict=False):
        r"""
        convertL2ToL1(Model self, bool strict=False)

        Internal implementation method.

        """
        return _libsbml.Model_convertL2ToL1(self, strict)

    def convertL3ToL1(self, strict=False):
        r"""
        convertL3ToL1(Model self, bool strict=False)

        Internal implementation method.

        """
        return _libsbml.Model_convertL3ToL1(self, strict)

    def convertL3ToL2(self, strict=False):
        r"""
        convertL3ToL2(Model self, bool strict=False)

        Internal implementation method.

        """
        return _libsbml.Model_convertL3ToL2(self, strict)

    def convertFromL3V2(self, strict=False):
        r"""
        convertFromL3V2(Model self, bool strict=False)

        Internal implementation method.

        """
        return _libsbml.Model_convertFromL3V2(self, strict)

    def dealWithFast(self):
        r"""
        dealWithFast(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_dealWithFast(self)

    def dealWithL3Fast(self, targetVersion):
        r"""
        dealWithL3Fast(Model self, unsigned int targetVersion)

        Internal implementation method.

        """
        return _libsbml.Model_dealWithL3Fast(self, targetVersion)

    def addModifiers(self):
        r"""
        addModifiers(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_addModifiers(self)

    def addConstantAttribute(self):
        r"""
        addConstantAttribute(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_addConstantAttribute(self)

    def setSpatialDimensions(self, dims=3.0):
        r"""
        setSpatialDimensions(Model self, double dims=3.0)

        Internal implementation method.

        """
        return _libsbml.Model_setSpatialDimensions(self, dims)

    def addDefinitionsForDefaultUnits(self):
        r"""
        addDefinitionsForDefaultUnits(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_addDefinitionsForDefaultUnits(self)

    def dealWithDefaultValues(self):
        r"""
        dealWithDefaultValues(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_dealWithDefaultValues(self)

    def convertParametersToLocals(self, level, version):
        r"""
        convertParametersToLocals(Model self, unsigned int level, unsigned int version)

        Internal implementation method.

        """
        return _libsbml.Model_convertParametersToLocals(self, level, version)

    def setSpeciesReferenceConstantValueAndStoichiometry(self):
        r"""
        setSpeciesReferenceConstantValueAndStoichiometry(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_setSpeciesReferenceConstantValueAndStoichiometry(self)

    def removeParameterRuleUnits(self, strict):
        r"""
        removeParameterRuleUnits(Model self, bool strict)

        Internal implementation method.

        """
        return _libsbml.Model_removeParameterRuleUnits(self, strict)

    def convertStoichiometryMath(self):
        r"""
        convertStoichiometryMath(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_convertStoichiometryMath(self)

    def assignRequiredValues(self):
        r"""
        assignRequiredValues(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_assignRequiredValues(self)

    def dealWithModelUnits(self, strict=False):
        r"""
        dealWithModelUnits(Model self, bool strict=False)

        Internal implementation method.

        """
        return _libsbml.Model_dealWithModelUnits(self, strict)

    def dealWithStoichiometry(self):
        r"""
        dealWithStoichiometry(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_dealWithStoichiometry(self)

    def dealWithEvents(self, strict):
        r"""
        dealWithEvents(Model self, bool strict)

        Internal implementation method.

        """
        return _libsbml.Model_dealWithEvents(self, strict)

    def removeSpeciesTypes(self):
        r"""
        removeSpeciesTypes(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_removeSpeciesTypes(self)

    def removeCompartmentTypes(self):
        r"""
        removeCompartmentTypes(Model self)

        Internal implementation method.

        """
        return _libsbml.Model_removeCompartmentTypes(self)

    def connectToChild(self):
        r"""connectToChild(Model self)"""
        return _libsbml.Model_connectToChild(self)

    def getTypeCode(self):
        r"""
        getTypeCode(Model self) -> int

        Returns the libSBML type code for this SBML object.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_MODEL (default).

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getElementName(), getPackageName().

        """
        return _libsbml.Model_getTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(Model self) -> string

        Returns the XML element name of this object, which for Model, is
        always ''model'.'

        Returns the name of this element, i.e., ''model'.'

        """
        return _libsbml.Model_getElementName(self)

    def populateListFormulaUnitsData(self):
        r"""
        populateListFormulaUnitsData(Model self)

        Populates the internal list of derived units for this Model object.

        This method tells libSBML to (re)calculate all units for all
        components of the enclosing Model object.  The result is stored in an
        internal list of unit data.  Users can access the resulting data by
        calling the method SBase.getDerivedUnitDefinition() available on most
        objects.  (The name 'formula units data' is drawn from the name of the
        internal objects libSBML uses to store the data; note that these
        internal objects are not exposed to callers, because callers can
        interact with the results using the ordinary SBML unit objects.)

        This method is used by libSBML itself in the validator concerned with
        unit consistency.  The unit consistency validator (like all other
        validators in libSBML) is invoked by using
        SBMLDocument.checkConsistency(), with the consistency checks for the
        category LIBSBML_CAT_UNITS_CONSISTENCY turned on.  The method
        populateListFormulaUnitsData() does not need to be called prior to
        invoking the validator if unit consistency checking has not been
        turned off.  This method is only provided for cases when callers have
        a special need to force the unit data to be recalculated.  For
        instance, during construction of a model, a caller may want to
        interrogate libSBML's inferred units without invoking full-blown model
        validation; this is a scenario in which calling
        populateListFormulaUnitsData() may be useful.

        WARNING:

        Computing and inferring units is a time-consuming operation. Callers
        may want to call isPopulatedListFormulaUnitsData() to determine
        whether the units may already have been computed, to save themselves
        the need of invoking unit inference unnecessarily.

        See also isPopulatedListFormulaUnitsData().

        """
        return _libsbml.Model_populateListFormulaUnitsData(self)

    def isPopulatedListFormulaUnitsData(self):
        r"""
        isPopulatedListFormulaUnitsData(Model self) -> bool

        Predicate returning 'True' if libSBML has derived units for the
        components of this model.

        LibSBML can infer the units of measurement associated with different
        elements of a model.  When libSBML does that, it builds a complex
        internal structure during a resource-intensive operation.  This is
        done automatically only when callers invoke validation (via
        SBMLDocument.checkConsistency()) and have not turned off the unit
        validation option.

        Callers can force units to be recalculated by calling
        populateListFormulaUnitsData().  To avoid calling that method
        unnecessarily, calling programs may first want to invoke this method
        (isPopulatedListFormulaUnitsData()) to determine whether it is even
        necessary.

        Returns 'True' if the units have already been computed, 'False'
        otherwise.

        """
        return _libsbml.Model_isPopulatedListFormulaUnitsData(self)

    def getFormulaUnitsDataForVariable(self, sid):
        r"""
        getFormulaUnitsDataForVariable(Model self, string sid) -> FormulaUnitsData *

        Internal implementation method.

        """
        return _libsbml.Model_getFormulaUnitsDataForVariable(self, sid)

    def getFormulaUnitsDataForAssignment(self, sid):
        r"""
        getFormulaUnitsDataForAssignment(Model self, string sid) -> FormulaUnitsData *

        Internal implementation method.

        """
        return _libsbml.Model_getFormulaUnitsDataForAssignment(self, sid)

    def populateAllElementIdList(self):
        r"""
        populateAllElementIdList(Model self)

        Populates the internal list of the identifiers of all elements within
        this Model object.

        This method tells libSBML to retrieve the identifiers of all elements
        of the enclosing Model object.  The result is stored in an internal
        list of ids.  Users can access the resulting data by calling the
        method getAllElementIdList().

        WARNING:

        Retrieving all elements within a model is a time-consuming operation.
        Callers may want to call isPopulatedAllElementIdList() to determine
        whether the id list may already have been populated.

        See also isPopulatedAllElementIdList().

        """
        return _libsbml.Model_populateAllElementIdList(self)

    def isPopulatedAllElementIdList(self):
        r"""
        isPopulatedAllElementIdList(Model self) -> bool

        Predicate returning 'True' if libSBML has a list of the ids of all
        components of this model.

        Returns 'True' if the id list has already been populated, 'False'
        otherwise.

        """
        return _libsbml.Model_isPopulatedAllElementIdList(self)

    def getAllElementIdList(self):
        r"""
        getAllElementIdList(Model self) -> IdList

        Returns the internal list of the identifiers of all elements within
        this Model object.

        Returns an IdList of all the identifiers in the model.

        See also populateAllElementIdList(), isPopulatedAllElementIdList().

        """
        return _libsbml.Model_getAllElementIdList(self)

    def clearAllElementIdList(self):
        r"""
        clearAllElementIdList(Model self)

        Clears the internal list of the identifiers of all elements within
        this Model object.

        See also populateAllElementIdList(), isPopulatedAllElementIdList().

        """
        return _libsbml.Model_clearAllElementIdList(self)

    def populateAllElementMetaIdList(self):
        r"""
        populateAllElementMetaIdList(Model self)

        Populates the internal list of the metaids of all elements within this
        Model object.

        This method tells libSBML to retrieve the identifiers of all elements
        of the enclosing Model object.  The result is stored in an internal
        list of metaids.  Users can access the resulting data by calling the
        method getAllElementMetaIdList().

        WARNING:

        Retrieving all elements within a model is a time-consuming operation.
        Callers may want to call isPopulatedAllElementMetaIdList() to
        determine whether the metaid list may already have been populated.

        See also isPopulatedAllElementMetaIdList().

        """
        return _libsbml.Model_populateAllElementMetaIdList(self)

    def isPopulatedAllElementMetaIdList(self):
        r"""
        isPopulatedAllElementMetaIdList(Model self) -> bool

        Predicate returning 'True' if libSBML has a list of the metaids of all
        components of this model.

        Returns 'True' if the metaid list has already been populated, 'False'
        otherwise.

        """
        return _libsbml.Model_isPopulatedAllElementMetaIdList(self)

    def getAllElementMetaIdList(self):
        r"""
        getAllElementMetaIdList(Model self) -> IdList

        Returns the internal list of the metaids of all elements within this
        Model object.

        Returns an IdList of all the metaids in the model.

        See also populateAllElementMetaIdList(),
        isPopulatedAllElementMetaIdList().

        """
        return _libsbml.Model_getAllElementMetaIdList(self)

    def clearAllElementMetaIdList(self):
        r"""
        clearAllElementMetaIdList(Model self)

        Clears the internal list of the metaids of all elements within this
        Model object.

        See also populateAllElementMetaIdList(),
        isPopulatedAllElementMetaIdList().

        """
        return _libsbml.Model_clearAllElementMetaIdList(self)

    def hasRequiredElements(self):
        r"""
        hasRequiredElements(Model self) -> bool

        Predicate returning 'True' if all the required elements for this Model
        object have been set.

        Returns a boolean value indicating whether all the required elements
        for this object have been defined.

        """
        return _libsbml.Model_hasRequiredElements(self)

    def removeFunctionDefinition(self, *args):
        r"""
        removeFunctionDefinition(Model self, unsigned int n) -> FunctionDefinition
        removeFunctionDefinition(Model self, string sid) -> FunctionDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeFunctionDefinition(long n)

        Removes the nth FunctionDefinition object from this Model object and
        returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the FunctionDefinition object to remove.

        Returns the FunctionDefinition object removed, or 'None' if the given
        index is out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeFunctionDefinition(string sid)

        Removes the FunctionDefinition object with the given identifier from
        this Model  object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the FunctionDefinition object to
        remove.

        Returns the FunctionDefinition object removed, or 'None' if no
        FunctionDefinition object with the identifier exists in this Model
        object.

        """
        return _libsbml.Model_removeFunctionDefinition(self, *args)

    def removeUnitDefinition(self, *args):
        r"""
        removeUnitDefinition(Model self, unsigned int n) -> UnitDefinition
        removeUnitDefinition(Model self, string sid) -> UnitDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeUnitDefinition(long n)

        Removes the nth UnitDefinition object from this Model object and
        returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the UnitDefinition object to remove.

        Returns the UnitDefinition object removed., or 'None' if the given
        index is out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeUnitDefinition(string sid)

        Removes the UnitDefinition object with the given identifier from this
        Model object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the UnitDefinition object to
        remove.

        Returns the UnitDefinition object removed, or 'None' if no
        UnitDefinition object with the identifier exists in this Model object.

        """
        return _libsbml.Model_removeUnitDefinition(self, *args)

    def removeCompartmentType(self, *args):
        r"""
        removeCompartmentType(Model self, unsigned int n) -> CompartmentType
        removeCompartmentType(Model self, string sid) -> CompartmentType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeCompartmentType(long n)

        Removes the nth CompartmentType object from this Model object and
        returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the CompartmentType object to remove.

        Returns the ComapartmentType object removed, or 'None' if the given
        index is out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeCompartmentType(string sid)

        Removes the CompartmentType object with the given identifier from this
        Model object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the object to remove.

        Returns the CompartmentType object removed, or 'None' if no
        CompartmentType object with the identifier exists in this Model
        object.

        """
        return _libsbml.Model_removeCompartmentType(self, *args)

    def removeSpeciesType(self, *args):
        r"""
        removeSpeciesType(Model self, unsigned int n) -> SpeciesType
        removeSpeciesType(Model self, string sid) -> SpeciesType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeSpeciesType(long n)

        Removes the nth SpeciesType object from this Model object and returns
        a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the SpeciesType object to remove.

        Returns the SpeciesType object removed, or 'None' if the given index
        is out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeSpeciesType(string sid)

        Removes the SpeciesType object with the given identifier from this
        Model object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the SpeciesType object to remove.

        Returns the SpeciesType object removed, or 'None' if no SpeciesType
        object with the identifier exists in this Model object.

        """
        return _libsbml.Model_removeSpeciesType(self, *args)

    def removeCompartment(self, *args):
        r"""
        removeCompartment(Model self, unsigned int n) -> Compartment
        removeCompartment(Model self, string sid) -> Compartment

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeCompartment(long n)

        Removes the nth Compartment object from this Model object and returns
        a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the Compartment object to remove.

        Returns the Compartment object removed, or 'None' if the given index
        is out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeCompartment(string sid)

        Removes the Compartment object with the given identifier from this
        Model object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the Compartment object to remove.

        Returns the Compartment object removed, or 'None' if no Compartment
        object with the identifier exists in this Model object.

        """
        return _libsbml.Model_removeCompartment(self, *args)

    def removeSpecies(self, *args):
        r"""
        removeSpecies(Model self, unsigned int n) -> Species
        removeSpecies(Model self, string sid) -> Species

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeSpecies(long n)

        Removes the nth Species object from this Model object and returns a
        pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the Species object to remove.

        Returns the Species object removed, or 'None' if the given index is
        out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeSpecies(string sid)

        Removes the Species object with the given identifier from this Model
        object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the Species object to remove.

        Returns the Species object removed, or 'None' if no Species object
        with the identifier exists in this Model object.

        """
        return _libsbml.Model_removeSpecies(self, *args)

    def removeParameter(self, *args):
        r"""
        removeParameter(Model self, unsigned int n) -> Parameter
        removeParameter(Model self, string sid) -> Parameter

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeParameter(long n)

        Removes the nth Parameter object from this Model object and returns a
        pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the Parameter object to remove.

        Returns the Parameter object removed, or 'None' if the given index is
        out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeParameter(string sid)

        Removes the Parameter object with the given identifier from this Model
        object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the Parameter object to remove.

        Returns the Parameter object removed, or 'None' if no Parameter object
        with the identifier exists in this Model object.

        """
        return _libsbml.Model_removeParameter(self, *args)

    def removeInitialAssignment(self, *args):
        r"""
        removeInitialAssignment(Model self, unsigned int n) -> InitialAssignment
        removeInitialAssignment(Model self, string symbol) -> InitialAssignment

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeInitialAssignment(long n)

        Removes the nth InitialAssignment object from this Model object and
        returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the InitialAssignment object to remove.

        Returns the InitialAssignment object removed, or 'None' if the given
        index is out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeInitialAssignment(string symbol)

        Removes the InitialAssignment object with the given 'symbol' attribute
        from this Model object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'symbol' is the 'symbol' attribute of the InitialAssignment
        object to remove.

        Returns the InitialAssignment object removed, or 'None' if no
        InitialAssignment object with the 'symbol' attribute exists in this
        Model object.

        """
        return _libsbml.Model_removeInitialAssignment(self, *args)

    def removeRule(self, *args):
        r"""
        removeRule(Model self, unsigned int n) -> Rule
        removeRule(Model self, string variable) -> Rule

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeRule(long n)

        Removes the nth Rule object from this Model object and returns a
        pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the Rule object to remove.

        Returns the Rule object removed, or 'None' if the given index is out
        of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeRule(string variable)

        Removes the Rule object with the given 'variable' attribute from this
        Model  object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'variable' is the 'variable' attribute of the Rule object to
        remove.

        Returns the Rule object removed, or 'None' if no Rule object with the
        'variable' attribute exists in this Model object.

        """
        return _libsbml.Model_removeRule(self, *args)

    def removeRuleByVariable(self, variable):
        r"""
        removeRuleByVariable(Model self, string variable) -> Rule

        Removes the Rule object with the given 'variable' attribute from this
        Model  object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'variable' is the 'variable' attribute of the Rule object to
        remove.

        Returns the Rule object removed, or 'None' if no Rule object with the
        'variable' attribute exists in this Model object.

        """
        return _libsbml.Model_removeRuleByVariable(self, variable)

    def removeConstraint(self, n):
        r"""
        removeConstraint(Model self, unsigned int n) -> Constraint

        Removes the nth Constraint object from this Model object and returns a
        pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the Constraint object to remove.

        Returns the Constraint object removed, or 'None' if the given index is
        out of range.

        """
        return _libsbml.Model_removeConstraint(self, n)

    def removeReaction(self, *args):
        r"""
        removeReaction(Model self, unsigned int n) -> Reaction
        removeReaction(Model self, string sid) -> Reaction

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeReaction(long n)

        Removes the nth Reaction object from this Model object and returns a
        pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the Reaction object to remove.

        Returns the Reaction object removed, or 'None' if the given index is
        out of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeReaction(string sid)

        Removes the Reaction object with the given identifier from this Model
        object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the Reaction object to remove.

        Returns the Reaction object removed, or 'None' if no Reaction object
        with the identifier exists in this Model object.

        """
        return _libsbml.Model_removeReaction(self, *args)

    def removeEvent(self, *args):
        r"""
        removeEvent(Model self, unsigned int n) -> Event
        removeEvent(Model self, string sid) -> Event

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            removeEvent(long n)

        Removes the nth Event object from this Model object and returns a
        pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the Event object to remove.

        Returns the Event object removed, or 'None' if the given index is out
        of range.

        ______________________________________________________________________
        Method variant with the following signature:

            removeEvent(string sid)

        Removes the Event object with the given identifier from this Model
        object and returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'sid' is the identifier of the Event object to remove.

        Returns the Event object removed, or 'None' if no Event object with
        the identifier exists in this Model object.

        """
        return _libsbml.Model_removeEvent(self, *args)

    def appendFrom(self, model):
        r"""
        appendFrom(Model self, Model model) -> int

        Copies a given Model object's subcomponents and appends the copies to
        the appropriate places in this Model.

        This method also calls the appendFrom method on all libSBML plug-in
        objects.

        SBML Level 3 consists of a Core definition that can be extended via
        optional SBML Level 3 packages.  A given model may indicate that it
        uses one or more SBML packages, and likewise, a software tool may be
        able to support one or more packages.  LibSBML does not come
        preconfigured with all possible packages included and enabled, in part
        because not all package specifications have been finalized.  To
        support the ability for software systems to enable support for the
        Level 3 packages they choose, libSBML features a plug-in mechanism.
        Each SBML Level 3 package is implemented in a separate code plug-in
        that can be enabled by the application to support working with that
        SBML package.  A given SBML model may thus contain not only objects
        defined by SBML Level 3 Core, but also objects created by libSBML
        plug-ins supporting additional Level 3 packages.

        Parameter 'model' is the Model to merge with this one.

        """
        return _libsbml.Model_appendFrom(self, model)

    def enablePackageInternal(self, pkgURI, pkgPrefix, flag):
        r"""
        enablePackageInternal(Model self, string pkgURI, string pkgPrefix, bool flag)

        Internal implementation method.

        """
        return _libsbml.Model_enablePackageInternal(self, pkgURI, pkgPrefix, flag)

    def updateSBMLNamespace(self, package, level, version):
        r"""
        updateSBMLNamespace(Model self, string package, unsigned int level, unsigned int version)

        Internal implementation method.

        """
        return _libsbml.Model_updateSBMLNamespace(self, package, level, version)

    def renameIDs(self, elements, idTransformer):
        r"""
        renameIDs(Model self, SBaseList elements, IdentifierTransformer idTransformer)

        Internal implementation method.

        """
        return _libsbml.Model_renameIDs(self, elements, idTransformer)

# Register Model in _libsbml:
_libsbml.Model_swigregister(Model)

IdCheckON = _libsbml.IdCheckON

IdCheckOFF = _libsbml.IdCheckOFF

SBMLCheckON = _libsbml.SBMLCheckON

SBMLCheckOFF = _libsbml.SBMLCheckOFF

SBOCheckON = _libsbml.SBOCheckON

SBOCheckOFF = _libsbml.SBOCheckOFF

MathCheckON = _libsbml.MathCheckON

MathCheckOFF = _libsbml.MathCheckOFF

UnitsCheckON = _libsbml.UnitsCheckON

UnitsCheckOFF = _libsbml.UnitsCheckOFF

OverdeterCheckON = _libsbml.OverdeterCheckON

OverdeterCheckOFF = _libsbml.OverdeterCheckOFF

PracticeCheckON = _libsbml.PracticeCheckON

PracticeCheckOFF = _libsbml.PracticeCheckOFF

AllChecksON = _libsbml.AllChecksON

class SBMLDocument(SBase):
    r"""

    Overall SBML container object.

    LibSBML uses the class SBMLDocument as a top-level container for
    storing SBML content and data associated with it (such as warnings and
    error messages).  The two primary means of reading an SBML model,
    SBMLReader.readSBML() and SBMLReader.readSBMLFromString(), both return
    a pointer to an SBMLDocument object.  From there, callers can inquire
    about any errors encountered (e.g., using
    SBMLDocument.getNumErrors()), access the Model object, and perform
    other actions such as consistency-checking and model translation.

    When creating fresh models programmatically, the starting point is
    typically the creation of an SBMLDocument object instance.  The
    SBMLDocument constructor accepts arguments for the SBML Level and
    Version of the model to be created.  After creating the SBMLDocument
    object, calling programs then typically call
    SBMLDocument.createModel() almost immediately, and then proceed to
    call the methods on the Model object to fill out the model's contents.

    SBMLDocument corresponds roughly to the class Sbml defined in the SBML
    Level 2 specification and SBML in the Level 3 specification.  It does
    not have a direct correspondence in SBML Level 1.  (However, to make
    matters simpler for applications, libSBML creates an SBMLDocument no
    matter whether the model is Level 1, Level 2 or Level 3.)  In its
    barest form, when written out in XML format for (e.g.) SBML Level 2
    Version 4, the corresponding structure is the following:

      <sbml xmlns='http://www.sbml.org/sbml/level2/version4' level='2' version='4'>
        ...
      </sbml>

    SBMLDocument is derived from SBase, and therefore contains the usual
    SBase attributes (in SBML Level 2 and Level 3) of 'metaid' and
    'sboTerm', as well as the subelements 'notes' and 'annotation'.  It
    also contains the attributes 'level' and 'version' indicating the
    Level and Version of the SBML data structure.  These can be accessed
    using the methods defined by the SBase class for that purpose.

    Checking consistency and adherence to SBML specifications
    ======================================================================

    One of the most important features of libSBML is its ability to
    perform SBML validation to ensure that a model adheres to the SBML
    specification for whatever Level+Version combination the model uses.
    SBMLDocument provides the methods for running consistency-checking and
    validation rules on the SBML content.

    First, a brief explanation of the rationale is in order.  In libSBML
    versions up to and including the version 3.3.x series, the individual
    methods for creating and setting attributes and other components were
    quite lenient, and allowed a caller to compose SBML entities that
    might not, in the end, represent valid SBML.  This allowed
    applications the freedom to do things such as save incomplete models
    (which is useful when models are being developed over long periods of
    time).  In the version 4.x series, libSBML is somewhat stricter, but
    still permits structures to be created independently and the results
    to be combined in a separate step.  In all these cases, it means that
    a separate validation step is necessary when a calling program finally
    wants to finish a complete SBML document.

    The primary interface to this validation facility is SBMLDocument's
    SBMLDocument.checkInternalConsistency() and
    SBMLDocument.checkConsistency().  The former verifies the basic
    internal consistency and syntax of an SBML document, and the latter
    implements more elaborate validation rules (both those defined by the
    SBML specifications, as well as additional rules offered by libSBML).

    The checks performed by SBMLDocument.checkInternalConsistency() are
    hardwired and cannot be changed by calling programs, but the
    validation performed by SBMLDocument.checkConsistency() is under
    program control using the method SBMLDocument.setConsistencyChecks().
    Applications can selectively disable specific kinds of checks that
    they may not be interested in, by calling
    SBMLDocument.setConsistencyChecks() with appropriate parameters.

    These methods have slightly different relevance depending on whether
    a model is created programmaticaly from scratch, or whether it is read
    in from a file or data stream.  The following list summarizes the
    possible scenarios.

    Scenario 1: Creating a model from scratch.  Before writing out the
    model,

    * Call SBMLDocument.checkInternalConsistency(), then inquire about
    the results by calling SBMLDocument.getNumErrors()

    * Call SBMLDocument.setConsistencyChecks()  to configure which
    checks will be performed by SBMLDocument.checkConsistency()

    * Call SBMLDocument.checkConsistency(), then inquire about the
    results by calling SBMLDocument.getNumErrors()

    Scenario 2: Reading a model from a file or data stream. After reading
    the model,

    * Basic consistency checks will have been performed automatically
    by libSBML upon reading the content, so you only need to inquire about
    the results by using SBMLDocument.getNumErrors()

    * Call SBMLDocument.setConsistencyChecks()  to configure which
    checks are performed by SBMLDocument.checkConsistency()

    * Call SBMLDocument.checkConsistency(), then inquire about the
    results by calling SBMLDocument.getNumErrors()

    It should be noted that as of SBML Level 3 Version 2, the Model
    became an optional child of SBMLDocument, instead of being required.
    This means that one can no longer use SBMLDocument.getModel() as a
    cheap method of checking if an SBML document was read in properly: the
    more robust getError methods detailed above must be used instead.

    Converting documents between Levels and Versions of SBML
    ======================================================================

    LibSBML provides facilities for limited translation of SBML between
    Levels and Versions of the SBML specifications.  The method for doing
    is is setLevelAndVersion() .  In  general, models can be converted
    upward without difficulty (e.g., from SBML Level 1 to Level 2, or from
    an earlier Version of Level 2 to the latest Version of Level 2).
    Sometimes models can be translated downward as well, if they do not
    use constructs specific to more advanced Levels of SBML.

    Calling SBMLDocument.setLevelAndVersion()  will not necessarily lead
    to a successful conversion.  The method will return a boolean value to
    indicate success or failure.  Callers must check the error log (see
    next section) attached to the SBMLDocument object after calling
    SBMLDocument.setLevelAndVersion()  in order to assess whether any
    problems arose.

    If an application is interested in translating to a lower Level and/or
    Version of SBML within a Level, the following methods allow for prior
    assessment of whether there is sufficient compatibility to make a
    translation possible:

    * SBMLDocument.checkL1Compatibility(),

    * SBMLDocument.checkL2v1Compatibility(),

    * SBMLDocument.checkL2v2Compatibility(),

    * SBMLDocument.checkL2v3Compatibility(),

    * SBMLDocument.checkL2v4Compatibility(),

    * SBMLDocument.checkL2v5Compatibility(), and

    * SBMLDocument.checkL3v1Compatibility().

    Some changes between Versions of SBML Level 2 may lead to unexpected
    behaviors when attempting conversions in either direction. For
    example, SBML Level 2 Version 4 relaxed the requirement for
    consistency in units of measurement between expressions annd
    quantities in a model.  As a result, a model written in Version 4, if
    converted to Version 3 with no other changes, may fail validation as a
    Version 3 model because Version 3 imposed stricter requirements on
    unit consistency.

    Other changes between SBML Level 2 and Level 3 make downward
    conversions challenging.  In some cases, it means that a model
    converted to Level 2 from Level 3 will contain attributes that were
    not explicitly given in the Level 3 model, because in Level 2 these
    attributes may have been optional or have default values.

    Error handling
    ======================================================================

    Upon reading a model, SBMLDocument logs any problems encountered while
    reading the model from the file or data stream.  The log contains
    objects that record diagnostic information about any notable issues
    that arose.  Whether the problems are warnings or errors, they are
    both reported through a single common interface involving the object
    class SBMLError.

    The methods SBMLDocument.getNumErrors(), SBMLDocument.getError()  and
    SBMLDocument.printErrors() allow callers to interact with the warnings
    or errors logged.  Alternatively, callers may retrieve the entire log
    as an SBMLErrorLog object using the method SBMLDocument.getErrorLog().
    The SBMLErrorLog object provides some alternative methods for
    interacting with the set of errors and warnings.  In either case,
    applications typically should first call SBMLDocument.getNumErrors()
    to find out if any issues have been logged after specific libSBML
    operations such as the ones discussed in the sections above.  If they
    have, then an application will should proceed to inspect the
    individual reports using either the direct interfaces on SBMLDocument
    or using the methods on the SBMLErrorLog object.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def getDefaultLevel():
        r"""
        getDefaultLevel() -> unsigned int

        The default SBML Level of new SBMLDocument objects.

        This 'default Level' corresponds to the most recent SBML
        specification Level available at the time libSBML version 5.19.3  was
        released.  The default Level is used by SBMLDocument if no Level is
        explicitly specified at the time of the construction of an
        SBMLDocument instance.

        Returns an integer indicating the most recent SBML specification
        Level.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also SBMLDocument.getDefaultVersion() .

        """
        return _libsbml.SBMLDocument_getDefaultLevel()

    @staticmethod
    def getDefaultVersion():
        r"""
        getDefaultVersion() -> unsigned int

        The default Version of new SBMLDocument objects.

        This 'default Version' corresponds to the most recent Version within
        the most recent Level of SBML available at the time libSBML version
        5.19.3  was released.  The default Version is used by SBMLDocument if
        no Version is explicitly specified at the time of the construction of
        an SBMLDocument instance.

        Returns an integer indicating the most recent SBML specification
        Version.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also SBMLDocument.getDefaultLevel() .

        """
        return _libsbml.SBMLDocument_getDefaultVersion()
    __swig_destroy__ = _libsbml.delete_SBMLDocument

    def __init__(self, *args):
        r"""
        __init__(SBMLDocument self, unsigned int level=0, unsigned int version=0) -> SBMLDocument
        __init__(SBMLDocument self, SBMLNamespaces sbmlns) -> SBMLDocument
        __init__(SBMLDocument self, SBMLDocument orig) -> SBMLDocument

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            SBMLDocument(long level = 0, long version = 0)

        Creates a new SBMLDocument, optionally with given values for the SBML
        Level and Version.

        If both the SBML Level and Version attributes are not specified, the
        SBML document is treated as having the latest Level and Version of
        SBML as determined by SBMLDocument.getDefaultLevel() and
        SBMLDocument.getDefaultVersion(); however, the SBMLDocument object is
        otherwise left blank.  In particular, the blank SBMLDocument object
        has no associated XML attributes, including (but not limited to) an
        XML namespace declaration.  The XML namespace declaration is not added
        until the model is written out, or the method
        SBMLDocument.setLevelAndVersion() is called.  This may be important to
        keep in mind if an application needs to add additional XML namespace
        declarations on the <sbml> element.  Application writers should either
        provide values for 'level' and 'version' on the call to this
        constructor, or else call SBMLDocument.setLevelAndVersion() shortly
        after creating the SBMLDocument object.

        Parameter 'level' is an integer for the SBML Level.

        Parameter 'version' is an integer for the Version within the SBML
        Level.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        See also SBMLDocument.setLevelAndVersion(), getDefaultLevel(),
        getDefaultVersion().

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        ______________________________________________________________________
        Method variant with the following signature:

            SBMLDocument(SBMLNamespaces sbmlns)

        Creates a new SBMLDocument using the given SBMLNamespaces object
        'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        ______________________________________________________________________
        Method variant with the following signature:

            SBMLDocument(SBMLDocument orig)

        Copy constructor; creates a copy of this SBMLDocument.

        Parameter 'orig' is the object to copy.

        """
        _libsbml.SBMLDocument_swiginit(self, _libsbml.new_SBMLDocument(*args))

    def clone(self):
        r"""
        clone(SBMLDocument self) -> SBMLDocument

        Creates and returns a deep copy of this SBMLDocument object.

        Returns the (deep) copy of this SBMLDocument object.

        """
        return _libsbml.SBMLDocument_clone(self)

    def isSetModel(self):
        r"""
        isSetModel(SBMLDocument self) -> bool

        Returns 'True' if the Model object has been set, otherwise  returns
        'False.'

        Returns 'True' if the Model object has been set

        """
        return _libsbml.SBMLDocument_isSetModel(self)

    def getModel(self, *args):
      """
      getModel(SBMLDocument self) -> Model
      getModel(SBMLDocument self) -> Model


      Returns the Model object stored in this SBMLDocument.

      It is important to note that this method does not create a Model
      instance.  The model in the SBMLDocument must have been created at
      some prior time, for example using SBMLDocument.createModel()  or
      SBMLDocument.setModel(). This method returns 'None' if a model does
      not yet exist.

      Returns the Model contained in this SBMLDocument, or 'None' if no such
      model exists.

      See also createModel().

      """
      model = _libsbml.SBMLDocument_getModel(self, *args)
      if model is not None:
        model.__parent_ref__ = self
      return model



    def getElementBySId(self, id):
        r"""
        getElementBySId(SBMLDocument self, string id) -> SBase

        Returns the first child element found that has the given 'id' in the
        model-wide SId namespace, or 'None' if no such object is found.

        Parameter 'id' is string representing the id of the object to find.

        Returns pointer to the first element found with the given 'id'.

        """
        return _libsbml.SBMLDocument_getElementBySId(self, id)

    def getElementByMetaId(self, metaid):
        r"""
        getElementByMetaId(SBMLDocument self, string metaid) -> SBase

        Returns the first child element it can find with the given 'metaid',
        or itself if it has the given 'metaid', or 'None' if no such object is
        found.

        Parameter 'metaid' is string representing the metaid of the object to
        find.

        Returns pointer to the first element found with the given 'metaid'.

        """
        return _libsbml.SBMLDocument_getElementByMetaId(self, metaid)

    def expandFunctionDefinitions(self):
        r"""
        expandFunctionDefinitions(SBMLDocument self) -> bool

        Removes FunctionDefinition constructs from the document and expands
        any instances of their use within <math> elements.

        For example, suppose a Model contains a FunctionDefinition with
        identifier ''f'' representing the math expression: f(x, y) = x * y.
        Suppose further that there is a reaction in which the <math> element
        of the KineticLaw object contains f(s, p), where 's' and 'p' are other
        identifiers defined in the model.  The outcome of invoking this method
        is that the <math> of the KineticLaw now represents the expression s *
        p and the model no longer contains any FunctionDefinition objects.

        Returns bool 'True' if the transformation was successful,  'False,'
        otherwise.

        Note: This function will check the consistency of a model before
        attemptimg the transformation.  If the model is not valid SBML, the
        transformation will not be performed and the function will return
        'False.'

        """
        return _libsbml.SBMLDocument_expandFunctionDefinitions(self)

    def expandInitialAssignments(self):
        r"""
        expandInitialAssignments(SBMLDocument self) -> bool

        Removes InitialAssignment constructs from the document and replaces
        them with appropriate values.

        For example, suppose a Model contains a InitialAssignment to a symbol
        ''k'' where ''k'' is the identifier of a Parameter.  The outcome of
        invoking this method is that the 'value' attribute of the Parameter
        definition is set to the result calculated using the InitialAssignment
        object's <math> formula, and the corresponding InitialAssignment is
        then removed from the Model.

        Returns bool 'True' if the transformation was successful,  'False,'
        otherwise.

        Note: This function will check the consistency of a model before
        attemptimg the transformation.  If the model is not valid SBML, the
        transformation will not be performed and the function will return
        'False.'  As part of that process, this method will check that it has
        values for any components referred to by the <math> elements of
        InitialAssignment objects.  In cases where not all of the values have
        been declared (e.g., if the mathematical expression refers to model
        entities that have no declared values), the InitialAssignment in
        question will not be removed and this method will return 'False.'

        """
        return _libsbml.SBMLDocument_expandInitialAssignments(self)

    def setLevelAndVersion(self, level, version, strict=True, ignorePackages=False):
        r"""
        setLevelAndVersion(SBMLDocument self, unsigned int level, unsigned int version, bool strict=True, bool ignorePackages=False) -> bool

        Sets the SBML Level and Version of this SBMLDocument instance,
        attempting to convert the model as needed.

        This method is the principal way in libSBML to convert models between
        Levels and Versions of SBML.  Generally, models can be converted
        upward without difficulty (e.g., from SBML Level 1 to Level 2, or from
        an earlier Version of Level 2 to the latest Version of Level 2).
        Sometimes models can be translated downward as well, if they do not
        use constructs specific to more advanced Levels of SBML.

        Before calling this method, callers may check compatibility directly
        using the methods SBMLDocument.checkL1Compatibility(),
        SBMLDocument.checkL2v1Compatibility(),
        SBMLDocument.checkL2v2Compatibility(),
        SBMLDocument.checkL2v3Compatibility(),
        SBMLDocument.checkL2v4Compatibility(),
        SBMLDocument.checkL2v5Compatibility(),
        SBMLDocument.checkL3v1Compatibility(), and
        SBMLDocument.checkL3v2Compatibility().

        The valid combinations of SBML Level and Version as of this release of
        libSBML are the following:

        * Level 1 Version 2

        * Level 2 Version 1

        * Level 2 Version 2

        * Level 2 Version 3

        * Level 2 Version 4

        * Level 2 Version 5

        * Level 3 Version 1

        * Level 3 Version 2 Strict conversion applies the additional
        criteria that both the source and the target model must be consistent
        SBML.  Users can control the consistency checks that are applied using
        the SBMLDocument.setConsistencyChecksForConversion() method.  If
        either the source or the potential target model have validation
        errors, the conversion is not performed.  When a strict conversion is
        successful, the underlying SBML object model is altered to reflect the
        new level and version.  Thus, information that cannot be converted
        (e.g. sboTerms) will be lost.

        Parameter 'level' is the desired SBML Level.

        Parameter 'version' is the desired Version within the SBML Level.

        Parameter 'strict' is boolean indicating whether to check consistency
        of both the source and target model when performing conversion
        (defaults to  true ).

        Parameter 'ignorePackages' is boolean indicating whether the presence
        of packages should be ignored by the conversion routine  (defaults to
        false ).

        Returns 'True' if the level and version of the document were
        successfully set to the requested values (which may have required
        conversion of the model), 'False' otherwise.

        Note: Calling this method will not necessarily lead to a successful
        conversion.  If the conversion fails, it will be logged in the error
        list associated with this SBMLDocument.  Callers should consult
        getNumErrors() to find out if the conversion succeeded without
        problems.  For conversions from Level 2 to Level 1, callers can also
        check the Level of the model after calling this method to find out
        whether it is Level 1.  (If the conversion to Level 1 failed, the
        Level of this model will be left unchanged.)

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        See also checkL1Compatibility(), checkL2v1Compatibility(),
        checkL2v2Compatibility(), checkL2v3Compatibility(),
        checkL2v4Compatibility(), checkL2v5Compatibility(),
        checkL3v1Compatibility().

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBMLDocument_setLevelAndVersion(self, level, version, strict, ignorePackages)

    def updateSBMLNamespace(self, package, level, version):
        r"""
        updateSBMLNamespace(SBMLDocument self, string package, unsigned int level, unsigned int version)

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_updateSBMLNamespace(self, package, level, version)

    def setModel(self, m):
        r"""
        setModel(SBMLDocument self, Model m) -> int

        Sets the Model for this SBMLDocument to a copy of the given Model.

        Parameter 'm' is the new Model to use.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        See also createModel(), getModel().

        """
        return _libsbml.SBMLDocument_setModel(self, m)

    def createModel(self, *args):
        r"""
        createModel(SBMLDocument self, string sid="") -> Model

        Creates a new Model inside this SBMLDocument, and returns a pointer to
        it.

        In SBML Level 2, the use of an identifier on a Model object is
        optional.  This method takes an optional argument, 'sid', for setting
        the identifier.  If not supplied, the identifier attribute on the
        Model instance is not set.

        Parameter 'sid' is the identifier of the new Model to create.

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        See also getModel(), SBMLDocument.setModel().

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBMLDocument_createModel(self, *args)

    def setLocationURI(self, uri):
        r"""
        setLocationURI(SBMLDocument self, string uri)

        Sets the location of this SBMLDocument.

        Called automatically when readSBMLFromFile is used, but may be set
        manually as well.

        """
        return _libsbml.SBMLDocument_setLocationURI(self, uri)

    def getLocationURI(self, *args):
        r"""
        getLocationURI(SBMLDocument self) -> string
        getLocationURI(SBMLDocument self) -> string

        Get the location of this SBMLDocument.

        If this document was read from a file or had its location set
        manually, that filename or set location will be returned, otherwise,
        an empty string is returned.

        """
        return _libsbml.SBMLDocument_getLocationURI(self, *args)

    def setConsistencyChecks(self, category, apply):
        r"""
        setConsistencyChecks(SBMLDocument self, SBMLErrorCategory_t category, bool apply)

        Controls the consistency checks that are performed when
        SBMLDocument.checkConsistency() is called.

        This method works by adding or subtracting consistency checks from the
        set of all possible checks that SBMLDocument.checkConsistency() knows
        how to perform.  This method may need to be called multiple times in
        order to achieve the desired combination of checks.  The first
        argument ('category') in a call to this method indicates the category
        of consistency/error checks that are to be turned on or off, and the
        second argument ('apply', a boolean) indicates whether to turn it on
        (value of 'True)' or off (value of 'False).'

        The possible categories (values to the argument 'category') are the
        set of constants whose names begin with the characters LIBSBML_CAT_ in
        the interface class libsbml. The following are the possible choices:

        * LIBSBML_CAT_GENERAL_CONSISTENCY: Correctness and consistency of
        specific SBML language constructs. Performing this set of checks is
        highly recommended.  With respect to the SBML specification, these
        concern failures in applying the validation rules numbered 2xxxx in
        the Level 2 Versions 2-4 and Level 3 Versions 1-2 specifications.

        * LIBSBML_CAT_IDENTIFIER_CONSISTENCY: Correctness and consistency of
        identifiers used for model entities.  An example of inconsistency
        would be using a species identifier in a reaction rate formula without
        first having declared the species.  With respect to the SBML
        specification, these concern failures in applying the validation rules
        numbered 103xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
        specifications.

        * LIBSBML_CAT_UNITS_CONSISTENCY: Consistency of measurement units
        associated with quantities in a model. With respect to the SBML
        specification, these concern failures in applying the validation rules
        numbered 105xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
        specifications.

        * LIBSBML_CAT_MATHML_CONSISTENCY: Syntax of MathML constructs.  With
        respect to the SBML specification, these concern failures in applying
        the validation rules numbered 102xx in the Level 2 Versions 2-4 and
        Level 3 Versions 1-2 specifications.

        * LIBSBML_CAT_SBO_CONSISTENCY: Consistency and validity of SBO
        identifiers (if any) used in the model. With respect to the SBML
        specification, these concern failures in applying the validation rules
        numbered 107xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
        specifications.

        * LIBSBML_CAT_OVERDETERMINED_MODEL: Static analysis of whether the
        system of equations implied by a model is mathematically
        overdetermined.  With respect to the SBML specification, this is
        validation rule #10601 in the Level 2 Versions 2-4 and Level 3
        Versions 1-2 specifications.

        * LIBSBML_CAT_MODELING_PRACTICE: Additional checks for recommended
        good modeling practice. (These are tests performed by libSBML and do
        not have equivalent SBML validation rules.)  By default, all
        validation checks are applied to the model in an SBMLDocument object
        unless SBMLDocument.setConsistencyChecks() is called to indicate that
        only a subset should be applied.  Further, this default (i.e.,
        performing all checks) applies separately to each new SBMLDocument
        object created.  In other words, each time a model is read using
        SBMLReader.readSBML(), SBMLReader.readSBMLFromString(), or the global
        functions readSBML() and readSBMLFromString(), a new SBMLDocument is
        created and for that document, a call to
        SBMLDocument.checkConsistency() will default to applying all possible
        checks. Calling programs must invoke
        SBMLDocument.setConsistencyChecks() for each such new model if they
        wish to change the consistency checks applied.

        Parameter 'category' is a value drawn from the set of SBML error
        categories indicating the consistency checking/validation to be turned
        on or off.

        Parameter 'apply' is a boolean indicating whether the checks indicated
        by 'category' should be applied or not.

        See also SBMLDocument.checkConsistency().

        """
        return _libsbml.SBMLDocument_setConsistencyChecks(self, category, apply)

    def setConsistencyChecksForConversion(self, category, apply):
        r"""
        setConsistencyChecksForConversion(SBMLDocument self, SBMLErrorCategory_t category, bool apply)

        Controls the consistency checks that are performed when
        SBMLDocument.setLevelAndVersion() is called.

        This method works by adding or subtracting consistency checks from the
        set of all possible checks that may be performed to avoid conversion
        to or from an invalid document.  This method may need to be called
        multiple times in order to achieve the desired combination of checks.
        The first argument ('category') in a call to this method indicates the
        category of consistency/error checks that are to be turned on or off,
        and the second argument ('apply', a boolean) indicates whether to turn
        it on (value of 'True)' or off (value of 'False).'

        The possible categories (values to the argument 'category') are the
        set of constants whose names begin with the characters LIBSBML_CAT_ in
        the interface class libsbml. The following are the possible choices:

        * LIBSBML_CAT_GENERAL_CONSISTENCY: Correctness and consistency of
        specific SBML language constructs. Performing this set of checks is
        highly recommended.  With respect to the SBML specification, these
        concern failures in applying the validation rules numbered 2xxxx in
        the Level 2 Versions 2-4 and Level 3 Versions 1-2 specifications.

        * LIBSBML_CAT_IDENTIFIER_CONSISTENCY: Correctness and consistency of
        identifiers used for model entities.  An example of inconsistency
        would be using a species identifier in a reaction rate formula without
        first having declared the species.  With respect to the SBML
        specification, these concern failures in applying the validation rules
        numbered 103xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
        specifications.

        * LIBSBML_CAT_UNITS_CONSISTENCY: Consistency of measurement units
        associated with quantities in a model. With respect to the SBML
        specification, these concern failures in applying the validation rules
        numbered 105xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
        specifications.

        * LIBSBML_CAT_MATHML_CONSISTENCY: Syntax of MathML constructs.  With
        respect to the SBML specification, these concern failures in applying
        the validation rules numbered 102xx in the Level 2 Versions 2-4 and
        Level 3 Versions 1-2 specifications.

        * LIBSBML_CAT_SBO_CONSISTENCY: Consistency and validity of SBO
        identifiers (if any) used in the model. With respect to the SBML
        specification, these concern failures in applying the validation rules
        numbered 107xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
        specifications.

        * LIBSBML_CAT_OVERDETERMINED_MODEL: Static analysis of whether the
        system of equations implied by a model is mathematically
        overdetermined.  With respect to the SBML specification, this is
        validation rule #10601 in the Level 2 Versions 2-4 and Level 3
        Versions 1-2 specifications.

        * LIBSBML_CAT_MODELING_PRACTICE: Additional checks for recommended
        good modeling practice. (These are tests performed by libSBML and do
        not have equivalent SBML validation rules.) By default, all validation
        checks are applied to the model in an SBMLDocument object unless
        SBMLDocument.setConsistencyChecks() is called to indicate that only a
        subset should be applied.  Further, this default (i.e., performing all
        checks) applies separately to each new SBMLDocument object created.
        In other words, each time a model is read using SBMLReader.readSBML(),
        SBMLReader.readSBMLFromString(), or the global functions readSBML()
        and readSBMLFromString(), a new SBMLDocument is created and for that
        document, a call to SBMLDocument.checkConsistency() will default to
        applying all possible checks. Calling programs must invoke
        SBMLDocument.setConsistencyChecks() for each such new model if they
        wish to change the consistency checks applied.

        Parameter 'category' is a value drawn from the set of SBML error
        categories indicating the consistency checking/validation to be turned
        on or off.

        Parameter 'apply' is a boolean indicating whether the checks indicated
        by 'category' should be applied or not.

        See also SBMLDocument.setLevelAndVersion().

        """
        return _libsbml.SBMLDocument_setConsistencyChecksForConversion(self, category, apply)

    def checkConsistency(self):
        r"""
        checkConsistency(SBMLDocument self) -> unsigned int

        Performs consistency checking and validation on this SBML document.

        If this method returns a nonzero value (meaning, one or more
        consistency checks have failed for SBML document), the failures may be
        due to warnings or errors.  Callers should inspect the severity flag
        in the individual SBMLError objects returned by
        SBMLDocument.getError() to determine the nature of the failures.

        Returns the number of failed checks (errors) encountered.

        See also SBMLDocument.checkInternalConsistency().

        """
        return _libsbml.SBMLDocument_checkConsistency(self)

    def checkConsistencyWithStrictUnits(self):
        r"""
        checkConsistencyWithStrictUnits(SBMLDocument self) -> unsigned int

        Performs consistency checking and validation on this SBML document
        using the ultra strict units validator that assumes that there are no
        hidden numerical conversion factors.

        If this method returns a nonzero value (meaning, one or more
        consistency checks have failed for SBML document), the failures may be
        due to warnings or errors.  Callers should inspect the severity flag
        in the individual SBMLError objects returned by
        SBMLDocument.getError() to determine the nature of the failures.

        Returns the number of failed checks (errors) encountered.

        See also SBMLDocument.checkInternalConsistency().

        """
        return _libsbml.SBMLDocument_checkConsistencyWithStrictUnits(self)

    def validateSBML(self):
        r"""
        validateSBML(SBMLDocument self) -> unsigned int

        Performs consistency checking and validation on this SBML document.

        If this method returns a nonzero value (meaning, one or more
        consistency checks have failed for SBML document), the failures may be
        due to warnings or errors.  Callers should inspect the severity flag
        in the individual SBMLError objects returned by
        SBMLDocument.getError() to determine the nature of the failures.

        Note: unlike checkConsistency this method will write the document in
        order to determine all errors for the document. This will  also clear
        the error log.

        Returns the number of failed checks (errors) encountered.

        See also SBMLDocument.checkConsistency().

        """
        return _libsbml.SBMLDocument_validateSBML(self)

    def checkInternalConsistency(self):
        r"""
        checkInternalConsistency(SBMLDocument self) -> unsigned int

        Performs consistency checking on libSBML's internal representation of
        an SBML Model.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        The distinction between this method and
        SBMLDocument.checkConsistency() is that this method reports on
        fundamental syntactic and structural errors that violate the XML
        Schema for SBML; by contrast, SBMLDocument.checkConsistency() performs
        more elaborate model verifications and also validation according to
        the validation rules written in the appendices of the SBML Level 2
        Versions 2-4 specification documents.

        See also SBMLDocument.checkConsistency().

        """
        return _libsbml.SBMLDocument_checkInternalConsistency(self)

    def checkL1Compatibility(self, inConversion=False):
        r"""
        checkL1Compatibility(SBMLDocument self, bool inConversion=False) -> unsigned int

        Performs a set of consistency checks on the document to establish
        whether it is compatible with SBML Level 1 and can be converted to
        Level 1.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBMLDocument_checkL1Compatibility(self, inConversion)

    def checkL2v1Compatibility(self, inConversion=False):
        r"""
        checkL2v1Compatibility(SBMLDocument self, bool inConversion=False) -> unsigned int

        Performs a set of consistency checks on the document to establish
        whether it is compatible with SBML Level 2 Version 1 and can be
        converted to Level 2 Version 1.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBMLDocument_checkL2v1Compatibility(self, inConversion)

    def checkL2v2Compatibility(self, inConversion=False):
        r"""
        checkL2v2Compatibility(SBMLDocument self, bool inConversion=False) -> unsigned int

        Performs a set of consistency checks on the document to establish
        whether it is compatible with SBML Level 2 Version 2 and can be
        converted to Level 2 Version 2.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBMLDocument_checkL2v2Compatibility(self, inConversion)

    def checkL2v3Compatibility(self, inConversion=False):
        r"""
        checkL2v3Compatibility(SBMLDocument self, bool inConversion=False) -> unsigned int

        Performs a set of consistency checks on the document to establish
        whether it is compatible with SBML Level 2 Version 3 and can be
        converted to Level 2 Version 3.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.SBMLDocument_checkL2v3Compatibility(self, inConversion)

    def checkL2v4Compatibility(self):
        r"""
        checkL2v4Compatibility(SBMLDocument self) -> unsigned int

        Performs a set of consistency checks on the document to establish
        whether it is compatible with SBML Level 2 Version 4 and can be
        converted to Level 2 Version 4.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        """
        return _libsbml.SBMLDocument_checkL2v4Compatibility(self)

    def checkL2v5Compatibility(self):
        r"""
        checkL2v5Compatibility(SBMLDocument self) -> unsigned int

        Performs a set of consistency checks on the document to establish
        whether it is compatible with SBML Level 2 Version 5 and can be
        converted to Level 2 Version 5.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        """
        return _libsbml.SBMLDocument_checkL2v5Compatibility(self)

    def checkL3v1Compatibility(self):
        r"""
        checkL3v1Compatibility(SBMLDocument self) -> unsigned int

        Performs a set of consistency checks on the document to establish
        whether it is compatible with SBML Level 3 Version 1 and can be
        converted to Level 3 Version 1.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        """
        return _libsbml.SBMLDocument_checkL3v1Compatibility(self)

    def checkL3v2Compatibility(self):
        r"""
        checkL3v2Compatibility(SBMLDocument self) -> unsigned int

        Performs a set of consistency checks on the document to establish
        whether it is compatible with SBML Level 3 Version 2 and can be
        converted to Level 3 Version 2.

        Callers should query the results of the consistency check by calling
        SBMLDocument.getError().

        Returns the number of failed checks (errors) encountered.

        """
        return _libsbml.SBMLDocument_checkL3v2Compatibility(self)

    def getError(self, n):
        r"""
        getError(SBMLDocument self, unsigned int n) -> SBMLError

        Returns the nth error or warning encountered during parsing,
        consistency checking, or attempted translation of this model.

        Callers can use method XMLError.getSeverity() on the result to assess
        the severity of the problem.  The possible severity levels range from
        informational messages to fatal errors.

        Returns the error or warning indexed by integer 'n', or return 'None'
        if n > (getNumErrors() - 1).

        Parameter 'n' is the integer index of the error sought.

        See also SBMLDocument.getNumErrors().

        """
        return _libsbml.SBMLDocument_getError(self, n)

    def getErrorWithSeverity(self, n, severity):
        r"""
        getErrorWithSeverity(SBMLDocument self, unsigned int n, unsigned int severity) -> SBMLError

        Returns the nth error or warning with the given severity encountered
        during parsing, consistency checking, or attempted translation of this
        model.

        Returns the error or warning indexed by integer 'n', or return 'None'
        if n > (getNumErrors(severity) - 1).

        Parameter 'n' is the integer index of the error sought. Parameter
        'severity' is the severity of the error sought.

        See also SBMLDocument.getNumErrors().

        """
        return _libsbml.SBMLDocument_getErrorWithSeverity(self, n, severity)

    def getNumErrors(self, *args):
        r"""
        getNumErrors(SBMLDocument self) -> unsigned int
        getNumErrors(SBMLDocument self, unsigned int severity) -> unsigned int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getNumErrors()

        Returns the number of errors or warnings encountered during parsing,
        consistency checking, or attempted translation of this model.

        Returns the number of errors or warnings encountered.

        See also SBMLDocument.getError().

        ______________________________________________________________________
        Method variant with the following signature:

            getNumErrors(long severity)

        Returns the number of errors or warnings encountered with the given
        severity during parsing, consistency checking, or attempted
        translation of this model.

        Parameter 'severity' is the severity of the error sought.

        Returns the number of errors or warnings encountered.

        See also SBMLDocument.getError().

        """
        return _libsbml.SBMLDocument_getNumErrors(self, *args)

    def printErrors(self, *args):
        r"""
        printErrors(SBMLDocument self, ostream stream=cerr)
        printErrors(SBMLDocument self, ostream stream, unsigned int severity)

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            printErrors(std::ostream& stream = std::cerr)

        Prints all the errors or warnings encountered trying to parse, check,
        or translate this SBML document.

        It prints the text to the stream given by the optional parameter
        'stream'.  If no parameter is given, it prints the output to the
        standard error stream.

        If no errors have occurred, i.e., getNumErrors() == 0, no output will
        be sent to the stream.

        The format of the output is:

             N error(s):
               line NNN: (id) message

        Parameter 'stream' is the ostream or ostringstream object indicating
        where the output should be printed.

        </dl><dl class="docnote"><dt>Documentation note:</dt><dd> The native
        C++ implementation of this method defines a default argument value. In
        the documentation generated for different libSBML language bindings,
        you may or may not see corresponding arguments in the method
        declarations. For example, in Java and C#, a default argument is
        handled by declaring two separate methods, with one of them having the
        argument and the other one lacking the argument. However, the libSBML
        documentation will be identical for both methods. Consequently, if you
        are reading this and do not see an argument even though one is
        described, please look for descriptions of other variants of this
        method near where this one appears in the documentation. </dd></dl>

        See also getNumErrors(), getErrorLog(), SBMLDocument.getError().

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        ______________________________________________________________________
        Method variant with the following signature:

            printErrors(std::ostream& stream, long severity)

        Prints all the errors or warnings with the given severity encountered
        trying to parse, check, or translate this SBML document.

        It prints the text to the stream given by the parameter 'stream'.

        If no errors have occurred, i.e., getNumErrors(severity) == 0, no
        output will be sent to the stream.

        The format of the output is:

              N error(s):
                line NNN: (id) message

        Parameter 'stream' is the ostream or ostringstream object indicating
        where the output should be printed. Parameter 'severity' is of the
        errors sought.

        See also getNumErrors(), getErrorLog(),
        SBMLDocument.getErrorWithSeverity().

        """
        return _libsbml.SBMLDocument_printErrors(self, *args)

    def connectToChild(self):
        r"""connectToChild(SBMLDocument self)"""
        return _libsbml.SBMLDocument_connectToChild(self)

    def convert(self, props):
        r"""
        convert(SBMLDocument self, ConversionProperties props) -> int

        Converts this document using the converter that best matches the given
        conversion properties.

        Parameter 'props' is the conversion properties to use.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_CONV_CONVERSION_NOT_AVAILABLE

        """
        return _libsbml.SBMLDocument_convert(self, props)

    def enablePackageInternal(self, pkgURI, pkgPrefix, flag):
        r"""
        enablePackageInternal(SBMLDocument self, string pkgURI, string pkgPrefix, bool flag)

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_enablePackageInternal(self, pkgURI, pkgPrefix, flag)

    def getTypeCode(self):
        r"""
        getTypeCode(SBMLDocument self) -> int

        Returns the libSBML type code for this SBML object.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_DOCUMENT (default).

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also SBMLDocument.getElementName(), getPackageName().

        """
        return _libsbml.SBMLDocument_getTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(SBMLDocument self) -> string

        Returns the XML element name of this object, which for SBMLDocument,
        is always ''sbml'.'

        Returns the name of this element, i.e., ''sbml'.'

        """
        return _libsbml.SBMLDocument_getElementName(self)

    def getErrorLog(self, *args):
        r"""
        getErrorLog(SBMLDocument self) -> SBMLErrorLog
        getErrorLog(SBMLDocument self) -> SBMLErrorLog

        Returns the list of errors or warnings logged during parsing,
        consistency checking, or attempted translation of this model.

        Returns the SBMLErrorLog used for this SBMLDocument.

        See also SBMLDocument.getNumErrors().

        """
        return _libsbml.SBMLDocument_getErrorLog(self, *args)

    def getNamespaces(self):
        r"""
        getNamespaces(SBMLDocument self) -> XMLNamespaces

        Returns a list of XML Namespaces associated with the XML content of
        this SBML document.

        Returns the XML Namespaces associated with this SBML object.

        """
        return _libsbml.SBMLDocument_getNamespaces(self)

    def enableDefaultNS(self, package, flag):
        r"""
        enableDefaultNS(SBMLDocument self, string package, bool flag) -> int

        Set/unset default namespace to each top-level element defined in the
        given package extension.

        This works by adding a xmlns="..." attribute.  No prefix will be
        written when writing elements defined in the given package extension
        if 'True' is given as second argument.

        Parameter 'package' is the name or URI of the package extension.
        Parameter 'flag' is boolean value to indicate whether to write a
        namespace prefix.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_PKG_UNKNOWN_VERSION

        """
        return _libsbml.SBMLDocument_enableDefaultNS(self, package, flag)

    def isEnabledDefaultNS(self, package):
        r"""
        isEnabledDefaultNS(SBMLDocument self, string package) -> bool

        Returns 'True' if a default namespace is added to each top-level
        element defined in the given package extension, otherwise returns
        'False.'

        This basically checks if the attribute xmlns="..." is present.

        Parameter 'package' is the name or URI of the package extension.

        Returns a boolean indicating whether the given package's default
        namespace is enabled.

        """
        return _libsbml.SBMLDocument_isEnabledDefaultNS(self, package)

    def setPackageRequired(self, package, flag):
        r"""
        setPackageRequired(SBMLDocument self, string package, bool flag) -> int

        Sets the required attribute value of the given package extension.

        Parameter 'package' is the name or URI of the package extension.
        Parameter 'flag' is Boolean value indicating whether the package is
        required.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_PKG_UNKNOWN_VERSION

        """
        return _libsbml.SBMLDocument_setPackageRequired(self, package, flag)

    def getPackageRequired(self, package):
        r"""
        getPackageRequired(SBMLDocument self, string package) -> bool

        Returns the required attribute of the given package extension.

        Parameter 'package' is the name or URI of the package extension.

        Returns Boolean flag indicating whether the package is flagged as
        being required.

        """
        return _libsbml.SBMLDocument_getPackageRequired(self, package)

    def isSetPackageRequired(self, package):
        r"""
        isSetPackageRequired(SBMLDocument self, string package) -> bool

        Returns 'True' if the required attribute of the given package
        extension is defined, otherwise returns 'False.'

        Parameter 'package' is the name or URI of the package extension.

        Returns a Boolean indicating whether the package's 'required' flag is
        set.

        """
        return _libsbml.SBMLDocument_isSetPackageRequired(self, package)

    def isIgnoredPackage(self, pkgURI):
        r"""
        isIgnoredPackage(SBMLDocument self, string pkgURI) -> bool

        Returns 'True' if the given package extension is one of an ignored
        packages, otherwise returns 'False.'

        An ignored package is one that is defined to be used in this SBML
        document, but the package is not enabled in this copy of libSBML.

        Parameter 'pkgURI' is the URI of the package extension.

        Returns a Boolean, 'True' if the package is being ignored and 'False'
        otherwise.

        """
        return _libsbml.SBMLDocument_isIgnoredPackage(self, pkgURI)

    def isDisabledIgnoredPackage(self, pkgURI):
        r"""
        isDisabledIgnoredPackage(SBMLDocument self, string pkgURI) -> bool

        Returns 'True' if the given package extension is one of an ignored
        packages that has been disabled, otherwise returns 'False.'

        An ignored package is one that is defined to be used in this SBML
        document, but the package is not enabled in this copy of libSBML. It
        may have been disabled to avoid reproducing the package information
        when writing out the file.

        Parameter 'pkgURI' is the URI of the package extension.

        Returns a Boolean, 'True' if the package is being ignored and 'False'
        otherwise.

        """
        return _libsbml.SBMLDocument_isDisabledIgnoredPackage(self, pkgURI)

    def setPkgRequired(self, package, flag):
        r"""
        setPkgRequired(SBMLDocument self, string package, bool flag) -> int

        Sets the value of the required attribute for the given package.

        Parameter 'package' is the name or URI of the package extension.
        Parameter 'flag' is a Boolean value.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_PKG_UNKNOWN_VERSION

        DEPRECATED. Replaced in libSBML 5.2.0 by setPackageRequired()

        """
        return _libsbml.SBMLDocument_setPkgRequired(self, package, flag)

    def getPkgRequired(self, package):
        r"""
        getPkgRequired(SBMLDocument self, string package) -> bool

        Returns the required attribute of the given package extension.

        Parameter 'package' is the name or URI of the package extension.

        Returns a Boolean value indicating whether the package is flagged as
        being required in this SBML document.

        DEPRECATED. Replaced in libSBML 5.2.0 by getPackageRequired()

        """
        return _libsbml.SBMLDocument_getPkgRequired(self, package)

    def isSetPkgRequired(self, package):
        r"""
        isSetPkgRequired(SBMLDocument self, string package) -> bool

        Returns 'True' if the required attribute of the given package
        extension is defined, otherwise returns 'False.'

        Parameter 'package' is the name or URI of the package extension.

        Returns a Boolean value.

        DEPRECATED. Replaced in libSBML 5.2.0 by isSetPackageRequired()

        """
        return _libsbml.SBMLDocument_isSetPkgRequired(self, package)

    def isIgnoredPkg(self, pkgURI):
        r"""
        isIgnoredPkg(SBMLDocument self, string pkgURI) -> bool

        Returns 'True' if the given package extension is one of ignored
        packages, otherwise returns 'False.'

        An ignored package is one that is defined to be used in this SBML
        document, but the package is not enabled in this copy of libSBML.

        Parameter 'pkgURI' is the URI of the package extension.

        Returns a boolean indicating whether the given package is being
        ignored.

        DEPRECATED. Replaced in libSBML 5.2.0 by isIgnoredPackage()

        """
        return _libsbml.SBMLDocument_isIgnoredPkg(self, pkgURI)

    def getApplicableValidators(self):
        r"""
        getApplicableValidators(SBMLDocument self) -> unsigned char

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_getApplicableValidators(self)

    def getConversionValidators(self):
        r"""
        getConversionValidators(SBMLDocument self) -> unsigned char

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_getConversionValidators(self)

    def setApplicableValidators(self, appl):
        r"""
        setApplicableValidators(SBMLDocument self, unsigned char appl)

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_setApplicableValidators(self, appl)

    def setConversionValidators(self, appl):
        r"""
        setConversionValidators(SBMLDocument self, unsigned char appl)

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_setConversionValidators(self, appl)

    def getNumValidators(self):
        r"""
        getNumValidators(SBMLDocument self) -> unsigned int

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_getNumValidators(self)

    def clearValidators(self):
        r"""
        clearValidators(SBMLDocument self) -> int

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_clearValidators(self)

    def addValidator(self, validator):
        r"""
        addValidator(SBMLDocument self, SBMLValidator validator) -> int

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_addValidator(self, validator)

    def getValidator(self, index):
        r"""
        getValidator(SBMLDocument self, unsigned int index) -> SBMLValidator

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_getValidator(self, index)

    def addUnknownPackageRequired(self, pkgURI, prefix, flag):
        r"""
        addUnknownPackageRequired(SBMLDocument self, string pkgURI, string prefix, bool flag) -> int

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_addUnknownPackageRequired(self, pkgURI, prefix, flag)

    def hasUnknownPackage(self, pkgURI):
        r"""
        hasUnknownPackage(SBMLDocument self, string pkgURI) -> bool

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_hasUnknownPackage(self, pkgURI)

    def getNumUnknownPackages(self):
        r"""
        getNumUnknownPackages(SBMLDocument self) -> int

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_getNumUnknownPackages(self)

    def getUnknownPackageURI(self, index):
        r"""
        getUnknownPackageURI(SBMLDocument self, int index) -> string

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_getUnknownPackageURI(self, index)

    def getUnknownPackagePrefix(self, index):
        r"""
        getUnknownPackagePrefix(SBMLDocument self, int index) -> string

        Internal implementation method.

        """
        return _libsbml.SBMLDocument_getUnknownPackagePrefix(self, index)

# Register SBMLDocument in _libsbml:
_libsbml.SBMLDocument_swigregister(SBMLDocument)

def SBMLDocument_getDefaultLevel():
    r"""
    SBMLDocument_getDefaultLevel() -> unsigned int

    The default SBML Level of new SBMLDocument objects.

    This 'default Level' corresponds to the most recent SBML
    specification Level available at the time libSBML version 5.19.3  was
    released.  The default Level is used by SBMLDocument if no Level is
    explicitly specified at the time of the construction of an
    SBMLDocument instance.

    Returns an integer indicating the most recent SBML specification
    Level.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also SBMLDocument.getDefaultVersion() .

    """
    return _libsbml.SBMLDocument_getDefaultLevel()

def SBMLDocument_getDefaultVersion():
    r"""
    SBMLDocument_getDefaultVersion() -> unsigned int

    The default Version of new SBMLDocument objects.

    This 'default Version' corresponds to the most recent Version within
    the most recent Level of SBML available at the time libSBML version
    5.19.3  was released.  The default Version is used by SBMLDocument if
    no Version is explicitly specified at the time of the construction of
    an SBMLDocument instance.

    Returns an integer indicating the most recent SBML specification
    Version.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also SBMLDocument.getDefaultLevel() .

    """
    return _libsbml.SBMLDocument_getDefaultVersion()

class FunctionDefinition(SBase):
    r"""

    A user-defined function in an SBML model.

    The FunctionDefinition structure associates an identifier with a
    function definition.  This identifier can then be used as the function
    called in subsequent MathML content elsewhere in an SBML model.

    FunctionDefinition has one required attribute, 'id', to give the
    function a unique identifier by which other parts of an SBML model
    definition can refer to it.  A FunctionDefinition instance can also
    have an optional 'name' attribute of type 'string.'  Identifiers and
    names must be used according to the guidelines described in the SBML
    specification (e.g., Section 3.3 in the Level 2 Version 4
    specification).

    FunctionDefinition has a 'math' subelement containing a MathML
    expression defining the function body.  In SBML Level 2 and SBML Level
    3 Version 1, that 'math' subelement is required; in SBML Level 3
    Version 2, this restriction was relaxed, making the 'math' subelement
    optional.  The content of this element can only be a MathML 'lambda'
    element.  The 'lambda' element must begin with zero or more 'bvar'
    elements, followed by any other of the elements in the MathML subset
    allowed in SBML Level 2 except 'lambda' (i.e., a 'lambda' element
    cannot contain another 'lambda' element).  This is the only place in
    SBML where a 'lambda' element can be used.  The function defined by a
    FunctionDefinition is only available for use in other MathML elements
    that follow the FunctionDefinition definition in the model.  (These
    restrictions prevent recursive and mutually-recursive functions from
    being expressed.)

    A further restriction on the content of 'math' is that it cannot
    contain references to variables other than the variables declared to
    the 'lambda' itself.  That is, the contents of MathML 'ci' elements
    inside the body of the 'lambda' can only be the variables declared by
    its 'bvar' elements, or the identifiers of other FunctionDefinition
    instances in the model.  This means must be written so that all
    variables or parameters used in the MathML content are passed to them
    via their function parameters.  In SBML Level 2, this restriction
    applies also to the MathML 'csymbol' elements for time and delay; in
    SBML Level 3, it additionally applies to the 'csymbol' element for
    avogadro.

    In SBML Level 3 Version 2, if no math element is present in  the
    FunctionDefinition, the function has no mathematical meaning  defined
    in SBML Level 3 Core. This situation may arise when models  are
    incomplete, or when additional meanings are provided by an SBML  Level
    3 package.

    Note: Function definitions (also informally known as user-defined
    functions) were introduced in SBML Level 2.  They have purposefully
    limited capabilities.  A function cannot reference parameters or other
    model quantities outside of itself; values must be passed as
    parameters to the function.  Moreover, recursive and mutually-
    recursive functions are not permitted.  The purpose of these
    limitations is to balance power against complexity of implementation.
    With the restrictions as they are, function definitions could be
    implemented as textual substitutions---they are simply macros.
    Software implementations therefore do not need the full function-
    definition machinery typically associated with programming languages.

    Another important point to note is FunctionDefinition does not have a
    separate attribute for defining the units of the value returned by the
    function.  The units associated with the function's return value, when
    the function is called from within MathML expressions elsewhere in
    SBML, are simply the overall units of the expression in
    FunctionDefinition's 'math' subelement when applied to the arguments
    supplied in the call to the function.  Ascertaining these units
    requires performing dimensional analysis on the expression.  (Readers
    may wonder why there is no attribute.  The reason is that having a
    separate attribute for declaring the units would not only be
    redundant, but also lead to the potential for having conflicting
    information.  In the case of a conflict between the declared units and
    those of the value actually returned by the function, the only logical
    resolution rule would be to assume that the correct units are those of
    the expression anyway.)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_FunctionDefinition

    def __init__(self, *args):
        r"""
        __init__(FunctionDefinition self, unsigned int level, unsigned int version) -> FunctionDefinition
        __init__(FunctionDefinition self, SBMLNamespaces sbmlns) -> FunctionDefinition
        __init__(FunctionDefinition self, FunctionDefinition orig) -> FunctionDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            FunctionDefinition(long level, long version)

        Creates a new FunctionDefinition using the given SBML 'level' and
        'version' values.

        Parameter 'level' is a long integer, the SBML Level to assign to this
        FunctionDefinition.

        Parameter 'version' is a long integer, the SBML Version to assign to
        this FunctionDefinition.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            FunctionDefinition(SBMLNamespaces sbmlns)

        Creates a new FunctionDefinition using the given SBMLNamespaces object
        'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            FunctionDefinition(FunctionDefinition orig)

        Copy constructor; creates a copy of this FunctionDefinition.

        Parameter 'orig' is the object to copy.

        """
        _libsbml.FunctionDefinition_swiginit(self, _libsbml.new_FunctionDefinition(*args))

    def clone(self):
        r"""
        clone(FunctionDefinition self) -> FunctionDefinition

        Creates and returns a deep copy of this FunctionDefinition object.

        Returns the (deep) copy of this FunctionDefinition object.

        """
        return _libsbml.FunctionDefinition_clone(self)

    def getId(self):
        r"""
        getId(FunctionDefinition self) -> string

        Returns the value of the 'id' attribute of this FunctionDefinition.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is now recommended to use the
        getIdAttribute() function instead.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this FunctionDefinition.

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.FunctionDefinition_getId(self)

    def getName(self):
        r"""
        getName(FunctionDefinition self) -> string

        Returns the value of the 'name' attribute of this FunctionDefinition
        object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns the name of this SBML object, or the empty string if not set
        or unsettable.

        See also getIdAttribute(), isSetName(), setName(), unsetName().

        """
        return _libsbml.FunctionDefinition_getName(self)

    def getMath(self):
        r"""
        getMath(FunctionDefinition self) -> ASTNode

        Get the mathematical formula of this FunctionDefinition.

        Returns an ASTNode, the value of the 'math' subelement of this
        FunctionDefinition, or 'None' if the math is not set.

        """
        return _libsbml.FunctionDefinition_getMath(self)

    def isSetId(self):
        r"""
        isSetId(FunctionDefinition self) -> bool

        Predicate returning 'True' if this FunctionDefinition's 'id' attribute
        is set.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is recommended that callers use
        isSetIdAttribute() instead.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
        isSetIdAttribute().

        """
        return _libsbml.FunctionDefinition_isSetId(self)

    def isSetName(self):
        r"""
        isSetName(FunctionDefinition self) -> bool

        Predicate returning 'True' if this FunctionDefinition's 'name'
        attribute is set.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns 'True' if the 'name' attribute of this SBML object is set,
        'False' otherwise.

        See also getName(), setName(), unsetName().

        """
        return _libsbml.FunctionDefinition_isSetName(self)

    def isSetMath(self):
        r"""
        isSetMath(FunctionDefinition self) -> bool

        Predicate returning 'True' if this FunctionDefinition's 'math'
        subelement contains a value.

        Returns 'True' if the 'math' for this FunctionDefinition is set,
        'False' otherwise.

        """
        return _libsbml.FunctionDefinition_isSetMath(self)

    def setId(self, sid):
        r"""
        setId(FunctionDefinition self, string sid) -> int

        Sets the value of the 'id' attribute of this FunctionDefinition.

        The string 'sid' is copied.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Parameter 'sid' is the string to use as the identifier of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.FunctionDefinition_setId(self, sid)

    def setName(self, name):
        r"""
        setName(FunctionDefinition self, string name) -> int

        Sets the value of the 'name' attribute of this FunctionDefinition.

        The string in 'name' is copied.

        Parameter 'name' is the new name for the SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.FunctionDefinition_setName(self, name)

    def setMath(self, math):
        r"""
        setMath(FunctionDefinition self, ASTNode math) -> int

        Sets the 'math' subelement of this FunctionDefinition to the Abstract
        Syntax Tree given in 'math'.

        Parameter 'math' is an AST containing the mathematical expression to
        be used as the formula for this FunctionDefinition.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_OBJECT

        """
        return _libsbml.FunctionDefinition_setMath(self, math)

    def unsetName(self):
        r"""
        unsetName(FunctionDefinition self) -> int

        Unsets the value of the 'name' attribute of this FunctionDefinition.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getName(), setName(), isSetName().

        """
        return _libsbml.FunctionDefinition_unsetName(self)

    def getArgument(self, *args):
        r"""
        getArgument(FunctionDefinition self, unsigned int n) -> ASTNode
        getArgument(FunctionDefinition self, string name) -> ASTNode

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            getArgument(long n)

        Get the nth argument to this function.

        Callers should first find out the number of arguments to the function
        by calling getNumArguments().

        Parameter 'n' is an integer index for the argument sought.

        Returns the nth argument (bound variable) passed to this
        FunctionDefinition. If the index 'n' is invalid, 'None' is returned.

        See also getNumArguments().

        ______________________________________________________________________
        Method variant with the following signature:

            getArgument(string name)

        Get the argument named 'name' to this FunctionDefinition.

        Parameter 'name' is the exact name (case-sensitive) of the sought-
        after argument.

        Returns the argument (bound variable) having the given name, or 'None'
        if no such argument exists.

        """
        return _libsbml.FunctionDefinition_getArgument(self, *args)

    def getBody(self, *args):
        r"""
        getBody(FunctionDefinition self) -> ASTNode
        getBody(FunctionDefinition self) -> ASTNode

        Get the mathematical expression that is the body of this
        FunctionDefinition object.

        Returns the body of this FunctionDefinition as an Abstract Syntax
        Tree, or 'None' if no body is defined.

        """
        return _libsbml.FunctionDefinition_getBody(self, *args)

    def isSetBody(self):
        r"""
        isSetBody(FunctionDefinition self) -> bool

        Predicate returning 'True' if the body of this FunctionDefinition has
        set.

        Returns 'True' if the body of this FunctionDefinition is  set, 'False'
        otherwise.

        """
        return _libsbml.FunctionDefinition_isSetBody(self)

    def getNumArguments(self):
        r"""
        getNumArguments(FunctionDefinition self) -> unsigned int

        Get the number of arguments (bound variables) taken by this
        FunctionDefinition.

        Returns the number of arguments (bound variables) that must be passed
        to this FunctionDefinition.

        """
        return _libsbml.FunctionDefinition_getNumArguments(self)

    def getTypeCode(self):
        r"""
        getTypeCode(FunctionDefinition self) -> int

        Returns the libSBML type code for this SBML object.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_FUNCTION_DEFINITION
        (default).

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getElementName(), getPackageName().

        """
        return _libsbml.FunctionDefinition_getTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(FunctionDefinition self) -> string

        Returns the XML element name of this object, which for
        FunctionDefinition, is always ''functionDefinition'.'

        Returns the name of this element, i.e., ''functionDefinition'.'

        """
        return _libsbml.FunctionDefinition_getElementName(self)

    def hasRequiredAttributes(self):
        r"""
        hasRequiredAttributes(FunctionDefinition self) -> bool

        Predicate returning 'True' if all the required attributes for this
        FunctionDefinition object have been set.

        The required attributes for a FunctionDefinition object are:

        * 'id'

        Returns 'True' if the required attributes have been set, 'False'
        otherwise.

        """
        return _libsbml.FunctionDefinition_hasRequiredAttributes(self)

    def hasRequiredElements(self):
        r"""
        hasRequiredElements(FunctionDefinition self) -> bool

        Predicate returning 'True' if all the required elements for this
        FunctionDefinition object have been set.

        Note: The required elements for a FunctionDefinition object are:

        * 'math' inSBML Level 2 and Level 3 Version 1.   (In SBML Level 3
        Version 2+, it is no longer required.)

        Returns a boolean value indicating whether all the required elements
        for this object have been defined.

        """
        return _libsbml.FunctionDefinition_hasRequiredElements(self)

    def renameUnitSIdRefs(self, oldid, newid):
        r"""
        renameUnitSIdRefs(FunctionDefinition self, string oldid, string newid)

        Renames all the 'UnitSIdRef' attributes on this element.

        In SBML, unit definitions have identifiers of type UnitSId.  In SBML
        Level 3, an explicit data type called UnitSIdRef was introduced for
        attribute values that refer to UnitSId values; in previous Levels of
        SBML, this data type did not exist and attributes were simply
        described to as 'referring to a unit identifier', but the effective
        data type was the same as UnitSIdRef in Level 3.  These and other
        methods of libSBML refer to the type UnitSIdRef for all Levels of
        SBML, even if the corresponding SBML specification did not explicitly
        name the data type.

        This method works by looking at all unit identifier attribute values
        (including, if appropriate, inside mathematical formulas), comparing
        the unit identifiers to the value of 'oldid'.  If any matches are
        found, the matching identifiers are replaced with 'newid'.  The method
        does not descend into child elements.

        Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
        identifier.

        """
        return _libsbml.FunctionDefinition_renameUnitSIdRefs(self, oldid, newid)

# Register FunctionDefinition in _libsbml:
_libsbml.FunctionDefinition_swigregister(FunctionDefinition)

class ListOfFunctionDefinitions(ListOf):
    r"""

    A list of FunctionDefinition objects.

    The various ListOf___ classes in SBML are merely containers used for
    organizing the main components of an SBML model.  In libSBML's
    implementation, ListOf___ classes are derived from the intermediate
    utility class ListOf, which is not defined by the SBML specifications
    but serves as a useful programmatic construct.  ListOf is itself is in
    turn derived from SBase, which provides all of the various ListOf___
    classes with common features defined by the SBML specification, such
    as 'metaid' attributes and annotations.

    The relationship between the lists and the rest of an SBML model is
    illustrated by the following (for SBML Level 2 Version 4):

      <?xml version="1.0" encoding="UTF-8"?>
      <sbml xmlns="http://www.sbml.org/sbml/level3/version1/core" 
            level="3" version="1">
        <model id="My_Model">
          <listOfFunctionDefinitions>
            <functionDefinition> ... </functionDefinition> 
          </listOfFunctionDefinitions>
          <listOfUnitDefinitions>
            <unitDefinition> ... </unitDefinition> 
          </listOfUnitDefinitions>
          <listOfCompartments>
            <compartment> ... </compartment> 
          </listOfCompartments>
          <listOfSpecies>
            <species> ... </species> 
          </listOfSpecies>
          <listOfParameters>
            <parameter> ... </parameter> 
          </listOfParameters>
          <listOfInitialAssignments>
            <initialAssignment> ... </initialAssignment> 
          </listOfInitialAssignments>
          <listOfRules>
            ... elements of subclasses of Rule ...
          </listOfRules>
          <listOfConstraints>
            <constraint> ... </constraint> 
          </listOfConstraints>
          <listOfReactions>
            <reaction> ... </reaction> 
          </listOfReactions>
          <listOfEvents>
            <event> ... </event> 
          </listOfEvents>
        </model>
      </sbml>

    SBML Level 3 Version 1 has essentially the same structure as  Level
    2 Version 4, depicted above, but SBML Level 3  Version 2 allows
    containers to contain zero or more of the relevant object, instead of
    requiring at least one.  As such, libsbml will write out an
    otherwise-empty ListOf___ element that has any optional attribute set
    (such as 'id' or 'metaid'), that has an optional child (such  as a
    'notes' or 'annotation'), or that has attributes or children set from
    any SBML Level 3 package, whether or not the ListOf___ has  any other
    children.

    Readers may wonder about the motivations for using the ListOf___
    containers in SBML.  A simpler approach in XML might be to place the
    components all directly at the top level of the model definition.  The
    choice made in SBML is to group them within XML elements named after
    ListOfClassname, in part because it helps organize the components.
    More importantly, the fact that the container classes are derived from
    SBase means that software tools can add information about the lists
    themselves into each list container's 'annotation'.

    See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
    ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
    ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ListOfFunctionDefinitions self, unsigned int level, unsigned int version) -> ListOfFunctionDefinitions
        __init__(ListOfFunctionDefinitions self, SBMLNamespaces sbmlns) -> ListOfFunctionDefinitions

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfFunctionDefinitions(long level, long version)

        Creates a new ListOfFunctionDefinitions object.

        The object is constructed such that it is valid for the given SBML
        Level and Version combination.

        Parameter 'level' is the SBML Level.

        Parameter 'version' is the Version within the SBML Level.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfFunctionDefinitions(SBMLNamespaces sbmlns)

        Creates a new ListOfFunctionDefinitions object.

        The object is constructed such that it is valid for the SBML Level and
        Version combination determined by the SBMLNamespaces object in
        'sbmlns'.

        Parameter 'sbmlns' is an SBMLNamespaces object that is used to
        determine the characteristics of the ListOfFunctionDefinitions object
        to be created.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        """
        _libsbml.ListOfFunctionDefinitions_swiginit(self, _libsbml.new_ListOfFunctionDefinitions(*args))

    def clone(self):
        r"""
        clone(ListOfFunctionDefinitions self) -> ListOfFunctionDefinitions

        Creates and returns a deep copy of this ListOfFunctionDefinitions
        object.

        Returns the (deep) copy of this ListOfFunctionDefinitions object.

        """
        return _libsbml.ListOfFunctionDefinitions_clone(self)

    def getItemTypeCode(self):
        r"""
        getItemTypeCode(ListOfFunctionDefinitions self) -> int

        Returns the libSBML type code for the objects contained in this ListOf
        (i.e., FunctionDefinition objects, if the list is non-empty).

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for the objects contained in this ListOf:
        SBML_FUNCTION_DEFINITION (default).

        See also getElementName(), getPackageName().

        """
        return _libsbml.ListOfFunctionDefinitions_getItemTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(ListOfFunctionDefinitions self) -> string

        Returns the XML element name of this object.

        For ListOfFunctionDefinitions, the XML element name is
        ''listOfFunctionDefinitions'.'

        Returns the name of this element, i.e., ''listOfFunctionDefinitions'.'

        """
        return _libsbml.ListOfFunctionDefinitions_getElementName(self)

    def get(self, *args):
        r"""
        get(ListOfFunctionDefinitions self, unsigned int n) -> FunctionDefinition
        get(ListOfFunctionDefinitions self, unsigned int n) -> FunctionDefinition
        get(ListOfFunctionDefinitions self, string sid) -> FunctionDefinition
        get(ListOfFunctionDefinitions self, string sid) -> FunctionDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            get(long n)

        Get a FunctionDefinition from the ListOfFunctionDefinitions.

        Parameter 'n' is the index number of the FunctionDefinition to get.

        Returns the nth FunctionDefinition in this ListOfFunctionDefinitions.
        If the index 'n' is invalid, 'None' is returned.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            get(string sid)

        Get a FunctionDefinition from the ListOfFunctionDefinitions based on
        its identifier.

        Parameter 'sid' is a string representing the identifier  of the
        FunctionDefinition to get.

        Returns FunctionDefinition in this ListOfFunctionDefinitions with the
        given 'sid' or 'None' if no such FunctionDefinition exists.

        See also get(), size().

        """
        return _libsbml.ListOfFunctionDefinitions_get(self, *args)

    def remove(self, *args):
        r"""
        remove(ListOfFunctionDefinitions self, unsigned int n) -> FunctionDefinition
        remove(ListOfFunctionDefinitions self, string sid) -> FunctionDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            remove(long n)

        Removes the nth item from this ListOfFunctionDefinitions items and
        returns a pointer to it.

        The caller owns the returned item and is responsible for deleting it.

        Parameter 'n' is the index of the item to remove.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            remove(string sid)

        Removes item in this ListOfFunctionDefinitions items with the given
        identifier.

        The caller owns the returned item and is responsible for deleting it.
        If none of the items in this list have the identifier 'sid', then
        'None' is returned.

        Parameter 'sid' is the identifier of the item to remove.

        Returns the item removed.  As mentioned above, the caller owns the
        returned item.

        """
        return _libsbml.ListOfFunctionDefinitions_remove(self, *args)
    __swig_destroy__ = _libsbml.delete_ListOfFunctionDefinitions

# Register ListOfFunctionDefinitions in _libsbml:
_libsbml.ListOfFunctionDefinitions_swigregister(ListOfFunctionDefinitions)

UNIT_KIND_AMPERE = _libsbml.UNIT_KIND_AMPERE

UNIT_KIND_AVOGADRO = _libsbml.UNIT_KIND_AVOGADRO

UNIT_KIND_BECQUEREL = _libsbml.UNIT_KIND_BECQUEREL

UNIT_KIND_CANDELA = _libsbml.UNIT_KIND_CANDELA

UNIT_KIND_CELSIUS = _libsbml.UNIT_KIND_CELSIUS

UNIT_KIND_COULOMB = _libsbml.UNIT_KIND_COULOMB

UNIT_KIND_DIMENSIONLESS = _libsbml.UNIT_KIND_DIMENSIONLESS

UNIT_KIND_FARAD = _libsbml.UNIT_KIND_FARAD

UNIT_KIND_GRAM = _libsbml.UNIT_KIND_GRAM

UNIT_KIND_GRAY = _libsbml.UNIT_KIND_GRAY

UNIT_KIND_HENRY = _libsbml.UNIT_KIND_HENRY

UNIT_KIND_HERTZ = _libsbml.UNIT_KIND_HERTZ

UNIT_KIND_ITEM = _libsbml.UNIT_KIND_ITEM

UNIT_KIND_JOULE = _libsbml.UNIT_KIND_JOULE

UNIT_KIND_KATAL = _libsbml.UNIT_KIND_KATAL

UNIT_KIND_KELVIN = _libsbml.UNIT_KIND_KELVIN

UNIT_KIND_KILOGRAM = _libsbml.UNIT_KIND_KILOGRAM

UNIT_KIND_LITER = _libsbml.UNIT_KIND_LITER

UNIT_KIND_LITRE = _libsbml.UNIT_KIND_LITRE

UNIT_KIND_LUMEN = _libsbml.UNIT_KIND_LUMEN

UNIT_KIND_LUX = _libsbml.UNIT_KIND_LUX

UNIT_KIND_METER = _libsbml.UNIT_KIND_METER

UNIT_KIND_METRE = _libsbml.UNIT_KIND_METRE

UNIT_KIND_MOLE = _libsbml.UNIT_KIND_MOLE

UNIT_KIND_NEWTON = _libsbml.UNIT_KIND_NEWTON

UNIT_KIND_OHM = _libsbml.UNIT_KIND_OHM

UNIT_KIND_PASCAL = _libsbml.UNIT_KIND_PASCAL

UNIT_KIND_RADIAN = _libsbml.UNIT_KIND_RADIAN

UNIT_KIND_SECOND = _libsbml.UNIT_KIND_SECOND

UNIT_KIND_SIEMENS = _libsbml.UNIT_KIND_SIEMENS

UNIT_KIND_SIEVERT = _libsbml.UNIT_KIND_SIEVERT

UNIT_KIND_STERADIAN = _libsbml.UNIT_KIND_STERADIAN

UNIT_KIND_TESLA = _libsbml.UNIT_KIND_TESLA

UNIT_KIND_VOLT = _libsbml.UNIT_KIND_VOLT

UNIT_KIND_WATT = _libsbml.UNIT_KIND_WATT

UNIT_KIND_WEBER = _libsbml.UNIT_KIND_WEBER

UNIT_KIND_INVALID = _libsbml.UNIT_KIND_INVALID


def UnitKind_equals(uk1, uk2):
    r"""
    UnitKind_equals(UnitKind_t uk1, UnitKind_t uk2) -> int

    Tests for logical equality between two given UNIT_KIND_ code values.

    This function behaves exactly like C's == operator, except for the
    following two cases:

    * UNIT_KIND_LITER == UNIT_KIND_LITRE

    * UNIT_KIND_METER == UNIT_KIND_METRE In the two cases above, C
    equality comparison would yield '0' (false) (because each of the above
    is a distinct enumeration value), but this function returns 'True.'

    Parameter 'uk1' is a UNIT_KIND_ value. Parameter 'uk2' is a second
    UNIT_KIND_ value to compare to 'uk1'.

    Returns '1' (true) if 'uk1' is logically equivalent to 'uk2', '0'
    (false) otherwise.

    Note: For more information about the libSBML unit codes, please refer
    to the class documentation for Unit.

    """
    return _libsbml.UnitKind_equals(uk1, uk2)

def UnitKind_forName(name):
    r"""
    UnitKind_forName(char const * name) -> UnitKind_t

    Converts a text string naming a kind of unit to its corresponding
    libSBML UNIT_KIND_ constant/enumeration value.

    Parameter 'name' is a string, the name of a predefined base unit in
    SBML.

    Returns a value the set of UNIT_KIND_ codes defined in class libsbml,
    corresponding to the string 'name' (determined in a case-insensitive
    manner).

    Note: For more information about the libSBML unit codes, please refer
    to the class documentation for Unit.

    """
    return _libsbml.UnitKind_forName(name)

def UnitKind_toString(uk):
    r"""
    UnitKind_toString(UnitKind_t uk) -> char const *

    Converts a unit code to a text string equivalent.

    Parameter 'uk' is a value from the set of UNIT_KIND_ codes defined in
    the class libsbml

    Returns the name corresponding to the given unit code.

    Note: For more information about the libSBML unit codes, please refer
    to the class documentation for Unit.

    WARNING:

    The string returned is a static data value.  The caller does not own
    the returned string and is therefore not allowed to modify it.

    """
    return _libsbml.UnitKind_toString(uk)

def UnitKind_isValidUnitKindString(str, level, version):
    r"""
    UnitKind_isValidUnitKindString(char const * str, unsigned int level, unsigned int version) -> int

    Predicate for testing whether a given string corresponds to a
    predefined libSBML unit code.

    Parameter 'str' is a text string naming a base unit defined by SBML.
    Parameter 'level' is the Level of SBML. Parameter 'version' is the
    Version within the Level of SBML.

    Returns 1 (true) if string is the name of a valid UNIT_KIND_ value,
    '0' (false) otherwise.

    Note: For more information about the libSBML unit codes, please refer
    to the class documentation for Unit.

    """
    return _libsbml.UnitKind_isValidUnitKindString(str, level, version)
class Unit(SBase):
    r"""

    A single unit referenced in an SBML unit definition.

    The SBML unit definition facility uses two classes of objects,
    UnitDefinition and Unit.  The approach to defining units in SBML is
    compositional; for example, meter second^-2 is constructed by
    combining a Unit object representing meter with another Unit object
    representing second^-2. The combination is wrapped inside a
    UnitDefinition, which provides for assigning an identifier and
    optional name to the combination.  The identifier can then be
    referenced from elsewhere in a model.  Thus, the UnitDefinition class
    is the container, and Unit instances are placed inside UnitDefinition
    instances.

    A Unit has four attributes named 'kind', 'exponent', 'scale' and
    'multiplier'.  It represents a (possibly transformed) reference to a
    base unit.  The attribute 'kind' on Unit indicates the chosen base
    unit. Its value must be one of the text strings listed below; this
    list corresponds to SBML Level 3:

       ampere         farad  joule     lux     radian     volt  
       avogadro       gram   katal     metre   second     watt  
       becquerel      gray   kelvin    mole    siemens    weber 
       candela        henry  kilogram  newton  sievert          
       coulomb        hertz  litre     ohm     steradian        
       dimensionless  item   lumen     pascal  tesla

    A few small differences exist between the Level 3 list of base units
    and the list defined in other Level/Version combinations of SBML.
    Specifically, Levels of SBML before Level 3 do not define 'avogadro;'
    conversely, Level 2 Version 1 defines 'Celsius,' and Level 1 defines
    'celsius,' 'meter,' and 'liter,' none of which are available in Level
    3.  In libSBML, each of the predefined base unit names is represented
    by an enumeration value whose name begins with the characters
    UNIT_KIND_, discussed in a separate section below.

    The attribute named 'exponent' on Unit represents an exponent on the
    unit.  In SBML Level 2, the attribute is optional and has a default
    value of '1' (one); in SBML Level 3, the attribute is mandatory and
    there is no default value.  A Unit also has an attribute called
    'scale'; its value must be an integer exponent for a power-of-ten
    multiplier used to set the scale of the unit.  For example, a unit
    having a 'kind' value of 'gram' and a 'scale' value of '-3' signifies
    10^-3 * gram, or milligrams.  In SBML Level 2, the attribute is
    optional and has a default value of '0' (zero), because 10^0 = 1; in
    SBML Level 3, the attribute is mandatory and has no default value.
    Lastly, the attribute named 'multiplier' can be used to multiply the
    unit by a real-numbered factor; this enables the definition of units
    that are not power-of-ten multiples of SI units.  For instance, a
    multiplier of 0.3048 could be used to define 'foot' as a measure of
    length in terms of a 'metre.'  The 'multiplier' attribute is optional
    in SBML Level 2, where it has a default value of '1' (one); in SBML
    Level 3, the attribute is mandatory and has no default value.

    Unit identification codes
    ......................................................................

    As discussed above, SBML defines a set of base units which serves as
    the starting point for new unit definitions.  This set of base units
    consists of the SI units and a small number of additional convenience
    units.

    In SBML Level 2 Versions before Version 3, there existed an
    enumeration of units called 'UnitKind.'  In Version 3, this
    enumeration was removed and the identifier class 'UnitSId' redefined
    to include the previous 'UnitKind' values as reserved symbols.  This
    change has no net effect on permissible models, their representation
    or their syntax.  The purpose of the change in the SBML specification
    was simply to clean up an inconsistency about the contexts in which
    these values were usable. However, libSBML maintains UnitKind in the
    form of of a set of static integer constants whose names begin with
    the characters UNIT_KIND_.  These constants are defined in the class
    libsbml.

    As a consequence of the fact that libSBML supports models in all
    Levels and Versions of SBML, libSBML's set of 'UNIT_KIND_' values is a
    union of all the possible base unit names defined in the different
    SBML specifications.  However, not every base unit is allowed in every
    Level+Version combination of SBML.  Note in particular the following
    exceptions:

    * The alternate spelling ''meter'' is included in addition to the
    official SI spelling ''metre'.'  This spelling is only permitted in
    SBML Level 1 models.

    * The alternate spelling ''liter'' is included in addition to the
    official SI spelling ''litre'.'  This spelling is only permitted in
    SBML Level 1 models.

    * The unit ''Celsius'' is included because of its presence in
    specifications of SBML prior to SBML Level 2 Version 2.

    * The unit 'avogadro' was introduced in SBML Level 3, and is only
    permitted for use in SBML Level 3 models. The table below lists the
    unit constants defined in libSBML, and their meanings.

      Enumerator              Meaning
      ---------               ---------
      UNIT_KIND_AMPERE        The ampere unit.
      UNIT_KIND_AVOGADRO      'dimensionless' multiplied by the value of Avogadro's constant.
      UNIT_KIND_BECQUEREL     The becquerel unit.
      UNIT_KIND_CANDELA       The candela unit.
      UNIT_KIND_CELSIUS       The Celsius unit. 
      UNIT_KIND_COULOMB       The coulomb unit.
      UNIT_KIND_DIMENSIONLESS A pseudo-unit indicating a dimensionless quantity.
      UNIT_KIND_FARAD         The farad unit.
      UNIT_KIND_GRAM          The gram unit.
      UNIT_KIND_GRAY          The gray unit.
      UNIT_KIND_HENRY         The henry unit.
      UNIT_KIND_HERTZ         The hertz unit.
      UNIT_KIND_ITEM          A pseudo-unit representing a single "thing".
      UNIT_KIND_JOULE         The joule unit.
      UNIT_KIND_KATAL         The katal unit.
      UNIT_KIND_KELVIN        The kelvin unit.
      UNIT_KIND_KILOGRAM      The kilogram unit.
      UNIT_KIND_LITER         Alternate spelling of litre.
      UNIT_KIND_LITRE         The litre unit.
      UNIT_KIND_LUMEN         The lumen unit.
      UNIT_KIND_LUX           The lux unit.
      UNIT_KIND_METER         Alternate spelling of metre.
      UNIT_KIND_METRE         The metre unit.
      UNIT_KIND_MOLE          The mole unit.
      UNIT_KIND_NEWTON        The newton unit.
      UNIT_KIND_OHM           The ohm unit.
      UNIT_KIND_PASCAL        The pascal unit.
      UNIT_KIND_RADIAN        The radian unit.
      UNIT_KIND_SECOND        The second unit.
      UNIT_KIND_SIEMENS       The siemens unit.
      UNIT_KIND_SIEVERT       The sievert unit.
      UNIT_KIND_STERADIAN     The steradian unit.
      UNIT_KIND_TESLA         The tesla unit.
      UNIT_KIND_VOLT          The volt unit.
      UNIT_KIND_WATT          The watt unit.
      UNIT_KIND_WEBER         The weber unit.
      UNIT_KIND_INVALID       Marker used by libSBML to indicate an invalid or unset unit.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_Unit

    def __init__(self, *args):
        r"""
        __init__(Unit self, unsigned int level, unsigned int version) -> Unit
        __init__(Unit self, SBMLNamespaces sbmlns) -> Unit
        __init__(Unit self, Unit orig) -> Unit

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            Unit(long level, long version)

        Creates a new Unit using the given SBML 'level' and 'version' values.

        Parameter 'level' is a long integer, the SBML Level to assign to this
        Unit.

        Parameter 'version' is a long integer, the SBML Version to assign to
        this Unit.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            Unit(SBMLNamespaces sbmlns)

        Creates a new Unit using the given SBMLNamespaces object 'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            Unit(Unit orig)

        Copy constructor; creates a copy of this Unit.

        Parameter 'orig' is the object to copy.

        """
        _libsbml.Unit_swiginit(self, _libsbml.new_Unit(*args))

    def clone(self):
        r"""
        clone(Unit self) -> Unit

        Creates and returns a deep copy of this Unit object.

        Returns the (deep) copy of this Unit object.

        """
        return _libsbml.Unit_clone(self)

    def initDefaults(self):
        r"""
        initDefaults(Unit self)

        Initializes the fields of this Unit object to 'typical' default
        values.

        The SBML Unit component has slightly different aspects and default
        attribute values in different SBML Levels and Versions.  This method
        sets the values to certain common defaults, based mostly on what they
        are in SBML Level 2.  Specifically:

        * Sets attribute 'exponent' to '1'

        * Sets attribute 'scale' to '0'

        * Sets attribute 'multiplier' to '1.0' The 'kind' attribute is left
        unchanged.

        """
        return _libsbml.Unit_initDefaults(self)

    def getKind(self):
        r"""
        getKind(Unit self) -> UnitKind_t

        Returns the 'kind' of Unit this is.

        Returns the value of the 'kind' attribute of this Unit as a value from
        the set of constants whose names begin with UNIT_KIND_ defined in the
        class libsbml.

        """
        return _libsbml.Unit_getKind(self)

    def getExponent(self):
        r"""
        getExponent(Unit self) -> int

        Returns the value of the 'exponent' attribute of this unit.

        Returns the 'exponent' value of this Unit, as an integer.

        """
        return _libsbml.Unit_getExponent(self)

    def getExponentAsDouble(self):
        r"""
        getExponentAsDouble(Unit self) -> double

        Returns the value of the 'exponent' attribute of this unit.

        Returns the 'exponent' value of this Unit, as a double.

        """
        return _libsbml.Unit_getExponentAsDouble(self)

    def getScale(self):
        r"""
        getScale(Unit self) -> int

        Returns the value of the 'scale' attribute of this unit.

        Returns the 'scale' value of this Unit, as an integer.

        """
        return _libsbml.Unit_getScale(self)

    def getMultiplier(self):
        r"""
        getMultiplier(Unit self) -> double

        Returns the value of the 'multiplier' attribute of this Unit.

        Returns the 'multiplier' value of this Unit, as a double.

        """
        return _libsbml.Unit_getMultiplier(self)

    def getOffset(self):
        r"""
        getOffset(Unit self) -> double

        Returns the value of the 'offset' attribute of this Unit.

        Returns the 'offset' value of this Unit, as a double.

        WARNING:

        The 'offset' attribute is only available in SBML Level 2 Version 1.
        This attribute is not present in SBML Level 2 Version 2 or above.
        When producing SBML models using these later specifications, modelers
        and software tools need to account for units with offsets explicitly.
        The SBML specification document offers a number of suggestions for how
        to achieve this.  LibSBML methods such as this one related to 'offset'
        are retained for compatibility with earlier versions of SBML Level 2,
        but their use is strongly discouraged.

        """
        return _libsbml.Unit_getOffset(self)

    def isAmpere(self):
        r"""
        isAmpere(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'ampere.'

        Returns 'True' if the kind of this Unit is 'ampere,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isAmpere(self)

    def isAvogadro(self):
        r"""
        isAvogadro(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'avogadro.'

        Returns 'True' if the kind of this Unit is 'avogadro,' 'False'
        otherwise.

        Note: The unit 'avogadro' was introduced in SBML Level 3, and is only
        permitted for use in SBML Level 3 models.

        """
        return _libsbml.Unit_isAvogadro(self)

    def isBecquerel(self):
        r"""
        isBecquerel(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'becquerel'

        Returns 'True' if the kind of this Unit is 'becquerel,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isBecquerel(self)

    def isCandela(self):
        r"""
        isCandela(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'candela'

        Returns 'True' if the kind of this Unit is 'candela,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isCandela(self)

    def isCelsius(self):
        r"""
        isCelsius(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'Celsius'

        Returns 'True' if the kind of this Unit is 'Celsius,' 'False'
        otherwise.

        WARNING:

        The predefined unit 'Celsius' was removed from the list of predefined
        units in SBML Level 2 Version 2 at the same time that the 'offset'
        attribute was removed from Unit definitions.  LibSBML methods such as
        this one related to 'Celsius' are retained in order to support SBML
        Level 2 Version 1, but their use is strongly discouraged.

        """
        return _libsbml.Unit_isCelsius(self)

    def isCoulomb(self):
        r"""
        isCoulomb(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'coulomb'

        Returns 'True' if the kind of this Unit is 'coulomb,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isCoulomb(self)

    def isDimensionless(self):
        r"""
        isDimensionless(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind
        'dimensionless.'

        Returns 'True' if the kind of this Unit is 'dimensionless,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isDimensionless(self)

    def isFarad(self):
        r"""
        isFarad(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'farad'

        Returns 'True' if the kind of this Unit is 'farad,' 'False' otherwise.

        """
        return _libsbml.Unit_isFarad(self)

    def isGram(self):
        r"""
        isGram(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'gram'

        Returns 'True' if the kind of this Unit is 'gram,' 'False' otherwise.

        """
        return _libsbml.Unit_isGram(self)

    def isGray(self):
        r"""
        isGray(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'gray'

        Returns 'True' if the kind of this Unit is 'gray,' 'False' otherwise.

        """
        return _libsbml.Unit_isGray(self)

    def isHenry(self):
        r"""
        isHenry(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'henry'

        Returns 'True' if the kind of this Unit is 'henry,' 'False' otherwise.

        """
        return _libsbml.Unit_isHenry(self)

    def isHertz(self):
        r"""
        isHertz(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'hertz'

        Returns 'True' if the kind of this Unit is 'hertz,' 'False' otherwise.

        """
        return _libsbml.Unit_isHertz(self)

    def isItem(self):
        r"""
        isItem(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'item'

        Returns 'True' if the kind of this Unit is 'item,' 'False' otherwise.

        """
        return _libsbml.Unit_isItem(self)

    def isJoule(self):
        r"""
        isJoule(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'joule'

        Returns 'True' if the kind of this Unit is 'joule,' 'False' otherwise.

        """
        return _libsbml.Unit_isJoule(self)

    def isKatal(self):
        r"""
        isKatal(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'katal'

        Returns 'True' if the kind of this Unit is 'katal,' 'False' otherwise.

        """
        return _libsbml.Unit_isKatal(self)

    def isKelvin(self):
        r"""
        isKelvin(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'kelvin'

        Returns 'True' if the kind of this Unit is 'kelvin,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isKelvin(self)

    def isKilogram(self):
        r"""
        isKilogram(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'kilogram'

        Returns 'True' if the kind of this Unit is 'kilogram,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isKilogram(self)

    def isLitre(self):
        r"""
        isLitre(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'litre'

        Returns 'True' if the kind of this Unit is 'litre' or 'liter', 'False'
        otherwise.

        """
        return _libsbml.Unit_isLitre(self)

    def isLumen(self):
        r"""
        isLumen(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'lumen'

        Returns 'True' if the kind of this Unit is 'lumen,' 'False' otherwise.

        """
        return _libsbml.Unit_isLumen(self)

    def isLux(self):
        r"""
        isLux(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'lux'

        Returns 'True' if the kind of this Unit is 'lux,' 'False' otherwise.

        """
        return _libsbml.Unit_isLux(self)

    def isMetre(self):
        r"""
        isMetre(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'metre'

        Returns 'True' if the kind of this Unit is 'metre' or 'meter', 'False'
        otherwise.

        """
        return _libsbml.Unit_isMetre(self)

    def isMole(self):
        r"""
        isMole(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'mole'

        Returns 'True' if the kind of this Unit is 'mole,' 'False' otherwise.

        """
        return _libsbml.Unit_isMole(self)

    def isNewton(self):
        r"""
        isNewton(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'newton'

        Returns 'True' if the kind of this Unit is 'newton,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isNewton(self)

    def isOhm(self):
        r"""
        isOhm(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'ohm'

        Returns 'True' if the kind of this Unit is 'ohm,' 'False' otherwise.

        """
        return _libsbml.Unit_isOhm(self)

    def isPascal(self):
        r"""
        isPascal(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'pascal'

        Returns 'True' if the kind of this Unit is 'pascal,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isPascal(self)

    def isRadian(self):
        r"""
        isRadian(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'radian'

        Returns 'True' if the kind of this Unit is 'radian,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isRadian(self)

    def isSecond(self):
        r"""
        isSecond(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'second'

        Returns 'True' if the kind of this Unit is 'second,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isSecond(self)

    def isSiemens(self):
        r"""
        isSiemens(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'siemens'

        Returns 'True' if the kind of this Unit is 'siemens,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isSiemens(self)

    def isSievert(self):
        r"""
        isSievert(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'sievert'

        Returns 'True' if the kind of this Unit is 'sievert,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isSievert(self)

    def isSteradian(self):
        r"""
        isSteradian(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'steradian'

        Returns 'True' if the kind of this Unit is 'steradian,' 'False'
        otherwise.

        """
        return _libsbml.Unit_isSteradian(self)

    def isTesla(self):
        r"""
        isTesla(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'tesla'

        Returns 'True' if the kind of this Unit is 'tesla,' 'False' otherwise.

        """
        return _libsbml.Unit_isTesla(self)

    def isVolt(self):
        r"""
        isVolt(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'volt'

        Returns 'True' if the kind of this Unit is 'volt,' 'False' otherwise.

        """
        return _libsbml.Unit_isVolt(self)

    def isWatt(self):
        r"""
        isWatt(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'watt'

        Returns 'True' if the kind of this Unit is 'watt,' 'False' otherwise.

        """
        return _libsbml.Unit_isWatt(self)

    def isWeber(self):
        r"""
        isWeber(Unit self) -> bool

        Predicate for testing whether this Unit is of the kind 'weber'

        Returns 'True' if the kind of this Unit is 'weber,' 'False' otherwise.

        """
        return _libsbml.Unit_isWeber(self)

    def isSetKind(self):
        r"""
        isSetKind(Unit self) -> bool

        Predicate to test whether the 'kind' attribute of this Unit is set.

        Returns 'True' if the 'kind' attribute of this Unit is set, 'False'
        otherwise.

        """
        return _libsbml.Unit_isSetKind(self)

    def isSetExponent(self):
        r"""
        isSetExponent(Unit self) -> bool

        Predicate to test whether the 'exponent' attribute of this Unit  is
        set.

        Returns 'True' if the 'exponent' attribute of this Unit is set,
        'False' otherwise.

        """
        return _libsbml.Unit_isSetExponent(self)

    def isSetScale(self):
        r"""
        isSetScale(Unit self) -> bool

        Predicate to test whether the 'scale' attribute of this Unit  is set.

        Returns 'True' if the 'scale' attribute of this Unit is set,  'False'
        otherwise.

        """
        return _libsbml.Unit_isSetScale(self)

    def isSetMultiplier(self):
        r"""
        isSetMultiplier(Unit self) -> bool

        Predicate to test whether the 'multiplier' attribute of this Unit  is
        set.

        Returns 'True' if the 'multiplier' attribute of this Unit is set,
        'False' otherwise.

        """
        return _libsbml.Unit_isSetMultiplier(self)

    def isSetOffset(self):
        r"""
        isSetOffset(Unit self) -> bool

        Predicate to test whether the 'offset' attribute of this Unit  is set.

        Returns 'True' if the 'offset' attribute of this Unit is set,  'False'
        otherwise.

        WARNING:

        The 'offset' attribute is only available in SBML Level 2 Version 1.
        This attribute is not present in SBML Level 2 Version 2 or above.
        When producing SBML models using these later specifications, modelers
        and software tools need to account for units with offsets explicitly.
        The SBML specification document offers a number of suggestions for how
        to achieve this.  LibSBML methods such as this one related to 'offset'
        are retained for compatibility with earlier versions of SBML Level 2,
        but their use is strongly discouraged.

        """
        return _libsbml.Unit_isSetOffset(self)

    def setKind(self, kind):
        r"""
        setKind(Unit self, UnitKind_t kind) -> int

        Sets the 'kind' attribute value of this Unit.

        Parameter 'kind' is a unit identifier chosen from the set of constants
        whose names begin with UNIT_KIND_ in libsbml.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.Unit_setKind(self, kind)

    def setExponent(self, *args):
        r"""
        setExponent(Unit self, int value) -> int
        setExponent(Unit self, double value) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            setExponent(int value)

        Sets the 'exponent' attribute value of this Unit.

        Parameter 'value' is the integer to which the attribute 'exponent'
        should be set.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        ______________________________________________________________________
        Method variant with the following signature:

            setExponent(double value)

        Sets the 'exponent' attribute value of this Unit.

        Parameter 'value' is the double to which the attribute 'exponent'
        should be set.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        """
        return _libsbml.Unit_setExponent(self, *args)

    def setScale(self, value):
        r"""
        setScale(Unit self, int value) -> int

        Sets the 'scale' attribute value of this Unit.

        Parameter 'value' is the integer to which the attribute 'scale' should
        be set.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        """
        return _libsbml.Unit_setScale(self, value)

    def setMultiplier(self, value):
        r"""
        setMultiplier(Unit self, double value) -> int

        Sets the 'multipler' attribute value of this Unit.

        Parameter 'value' is the floating-point value to which the attribute
        'multiplier' should be set.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        """
        return _libsbml.Unit_setMultiplier(self, value)

    def setOffset(self, value):
        r"""
        setOffset(Unit self, double value) -> int

        Sets the 'offset' attribute value of this Unit.

        Parameter 'value' is the floating point value to which the attribute
        'offset' should set.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        WARNING:

        The 'offset' attribute is only available in SBML Level 2 Version 1.
        This attribute is not present in SBML Level 2 Version 2 or above.
        When producing SBML models using these later specifications, modelers
        and software tools need to account for units with offsets explicitly.
        The SBML specification document offers a number of suggestions for how
        to achieve this.  LibSBML methods such as this one related to 'offset'
        are retained for compatibility with earlier versions of SBML Level 2,
        but their use is strongly discouraged.

        """
        return _libsbml.Unit_setOffset(self, value)

    def unsetKind(self):
        r"""
        unsetKind(Unit self) -> int

        Unsets the 'kind' attribute value of this Unit.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.Unit_unsetKind(self)

    def unsetExponent(self):
        r"""
        unsetExponent(Unit self) -> int

        Unsets the 'exponent' attribute value of this Unit.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.Unit_unsetExponent(self)

    def unsetScale(self):
        r"""
        unsetScale(Unit self) -> int

        Unsets the 'scale' attribute value of this Unit.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        """
        return _libsbml.Unit_unsetScale(self)

    def unsetMultiplier(self):
        r"""
        unsetMultiplier(Unit self) -> int

        Unsets the 'multipler' attribute value of this Unit.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        """
        return _libsbml.Unit_unsetMultiplier(self)

    def unsetOffset(self):
        r"""
        unsetOffset(Unit self) -> int

        Unsets the 'offset' attribute value of this Unit.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        WARNING:

        The 'offset' attribute is only available in SBML Level 2 Version 1.
        This attribute is not present in SBML Level 2 Version 2 or above.
        When producing SBML models using these later specifications, modelers
        and software tools need to account for units with offsets explicitly.
        The SBML specification document offers a number of suggestions for how
        to achieve this.  LibSBML methods such as this one related to 'offset'
        are retained for compatibility with earlier versions of SBML Level 2,
        but their use is strongly discouraged.

        """
        return _libsbml.Unit_unsetOffset(self)

    def getTypeCode(self):
        r"""
        getTypeCode(Unit self) -> int

        Returns the libSBML type code of this object instance.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_UNIT (default).

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getPackageName(), getElementName().

        """
        return _libsbml.Unit_getTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(Unit self) -> string

        Returns the XML element name of this object, which for Unit, is always
        ''unit'.'

        Returns the name of this element, i.e., ''unit'.'

        """
        return _libsbml.Unit_getElementName(self)

    @staticmethod
    def isBuiltIn(name, level):
        r"""
        isBuiltIn(string name, unsigned int level) -> bool

        Predicate to test whether a given string is the name of a built-in
        SBML unit, depending on the SBML level, since new predefined units
        were added between level 2 versions 1 and 2, and then all predefined
        units were removed again in SBML Level 3.

        Parameter 'name' is a string to be tested against the built-in unit
        names. Parameter 'level' is the level of SBML one is checking.

        Returns 'True' if 'name' is one of ''substance',' ''volume',' or
        ''time'' and the 'level' is '1;' or if 'name' is one of ''substance','
        ''volume',' ''area',' ''length',' or ''time'' and the 'level' is '2;'
        'False' otherwise (including all values when 'level' is '3).'

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        """
        return _libsbml.Unit_isBuiltIn(name, level)

    @staticmethod
    def isUnitKind(name, level, version):
        r"""
        isUnitKind(string name, unsigned int level, unsigned int version) -> bool

        Predicate to test whether a given string is the name of a valid base
        unit in SBML (such as ''gram'' or ''mole').'

        This method exists because prior to SBML Level 2 Version 3, an
        enumeration called 'UnitKind' was defined by SBML.  This enumeration
        was removed in SBML Level 2 Version 3 and its values were folded into
        the space of values of a type called 'UnitSId.'  This method therefore
        has less significance in SBML Level 2 Version 3 and Level 2 Version 4,
        but remains for backward compatibility and support for reading models
        in older Versions of Level 2.

        Parameter 'name' is a string to be tested.

        Parameter 'level' is a long integer representing the SBML
        specification Level.

        Parameter 'version' is a long integer representing the SBML
        specification Version.

        Returns 'True' if name is a valid SBML UnitKind, 'False' otherwise.

        Note: The allowed unit names differ between SBML Levels 1 and 2 and
        again slightly between Level 2 Versions 1 and 2.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        """
        return _libsbml.Unit_isUnitKind(name, level, version)

    @staticmethod
    def areIdentical(unit1, unit2):
        r"""
        areIdentical(Unit unit1, Unit unit2) -> bool

        Predicate returning 'True' if two Unit objects are identical.

        Two Unit objects are considered to be identical if they match in all
        attributes.  (Contrast this to the method areEquivalent(), which
        compares Unit objects only with respect to certain attributes.)

        Parameter 'unit1' is the first Unit object to compare. Parameter
        'unit2' is the second Unit object to compare.

        Returns 'True' if all the attributes of unit1 are identical to the
        attributes of unit2, 'False' otherwise.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also Unit.areEquivalent() .

        """
        return _libsbml.Unit_areIdentical(unit1, unit2)

    @staticmethod
    def areEquivalent(unit1, unit2):
        r"""
        areEquivalent(Unit unit1, Unit unit2) -> bool

        Predicate returning 'True' if  Unit objects are equivalent.

        Two Unit objects are considered to be equivalent either if (1) both
        have a 'kind' attribute value of 'dimensionless,' or (2) their 'kind',
        'exponent' and (for SBML Level 2 Version 1) 'offset' attribute values
        are equal. (Contrast this to the method areIdentical(), which compares
        Unit objects with respect to all attributes, not just the 'kind' and
        'exponent'.)

        Parameter 'unit1' is the first Unit object to compare. Parameter
        'unit2' is the second Unit object to compare.

        Returns 'True' if the 'kind' and 'exponent' attributes of unit1 are
        identical to the kind and exponent attributes of unit2, or if the kind
        attributes of both are 'dimensionless;' 'False' otherwise.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also Unit.areIdentical() .

        """
        return _libsbml.Unit_areEquivalent(unit1, unit2)

    @staticmethod
    def removeScale(unit):
        r"""
        removeScale(Unit unit) -> int

        Manipulates the attributes of the Unit to express the unit with the
        value of the scale attribute reduced to zero.

        For example, 1 millimetre can be expressed as a Unit with kind=
        ''metre'' multiplier=''1'' scale=''-3'' exponent=''1'.' It can also be
        expressed as a Unit with kind=''metre'' multiplier='0.001' scale=''0''
        exponent=''1'.'

        Parameter 'unit' is the Unit object to manipulate.

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also Unit.convertToSI() , Unit.merge() .

        """
        return _libsbml.Unit_removeScale(unit)

    @staticmethod
    def merge(unit1, unit2):
        r"""
        merge(Unit unit1, Unit unit2)

        Merges two Unit objects with the same 'kind' attribute value into a
        single Unit.

        For example, the following,

           <unit kind='metre' exponent='2'/>
           <unit kind='metre' exponent='1'/>

        would be merged to become

           <unit kind='metre' exponent='3'/>

        Parameter 'unit1' is the first Unit object; the result of the
        operation is left as a new version of this unit, modified in-place.
        Not modified if the two units have different kinds.

        Parameter 'unit2' is the second Unit object to merge with the first.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also Unit.convertToSI() , Unit.removeScale() .

        """
        return _libsbml.Unit_merge(unit1, unit2)

    @staticmethod
    def convertToSI(unit):
        r"""
        convertToSI(Unit unit) -> UnitDefinition

        Returns a UnitDefinition object containing the given 'unit' converted
        to the appropriate SI unit.

        This method exists because some units can be expressed in terms of
        others when the same physical dimension is involved.  For example, one
        hertz is identical to 1 sec^-1, one litre is equivalent to 1 cubic
        decametre, and so on.

        Parameter 'unit' is the Unit object to convert to SI.

        Returns a UnitDefinition object containing the SI unit.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also Unit.merge() .

        """
        return _libsbml.Unit_convertToSI(unit)

    def hasRequiredAttributes(self):
        r"""
        hasRequiredAttributes(Unit self) -> bool

        Predicate returning 'True' if all the required attributes for this
        Unit object have been set.

        The required attributes for a Unit object are:

        * 'kind'

        * 'exponent' (required in SBML Level 3; optional in Level 2)

        * 'multiplier' (required in SBML Level 3; optional in Level 2)

        * 'scale' (required in SBML Level 3; optional in Level 2)

        Returns 'True' if the required attributes have been set, 'False'
        otherwise.

        """
        return _libsbml.Unit_hasRequiredAttributes(self)

    def setExponentUnitChecking(self, value):
        r"""
        setExponentUnitChecking(Unit self, double value)

        Internal implementation method.

        """
        return _libsbml.Unit_setExponentUnitChecking(self, value)

    def getExponentUnitChecking(self, *args):
        r"""
        getExponentUnitChecking(Unit self) -> double
        getExponentUnitChecking(Unit self) -> double

        Internal implementation method.

        """
        return _libsbml.Unit_getExponentUnitChecking(self, *args)

    def isUnitChecking(self, *args):
        r"""
        isUnitChecking(Unit self) -> bool
        isUnitChecking(Unit self) -> bool

        Internal implementation method.

        """
        return _libsbml.Unit_isUnitChecking(self, *args)

# Register Unit in _libsbml:
_libsbml.Unit_swigregister(Unit)

def Unit_isBuiltIn(name, level):
    r"""
    Unit_isBuiltIn(string name, unsigned int level) -> bool

    Predicate to test whether a given string is the name of a built-in
    SBML unit, depending on the SBML level, since new predefined units
    were added between level 2 versions 1 and 2, and then all predefined
    units were removed again in SBML Level 3.

    Parameter 'name' is a string to be tested against the built-in unit
    names. Parameter 'level' is the level of SBML one is checking.

    Returns 'True' if 'name' is one of ''substance',' ''volume',' or
    ''time'' and the 'level' is '1;' or if 'name' is one of ''substance','
    ''volume',' ''area',' ''length',' or ''time'' and the 'level' is '2;'
    'False' otherwise (including all values when 'level' is '3).'

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    """
    return _libsbml.Unit_isBuiltIn(name, level)

def Unit_isUnitKind(name, level, version):
    r"""
    Unit_isUnitKind(string name, unsigned int level, unsigned int version) -> bool

    Predicate to test whether a given string is the name of a valid base
    unit in SBML (such as ''gram'' or ''mole').'

    This method exists because prior to SBML Level 2 Version 3, an
    enumeration called 'UnitKind' was defined by SBML.  This enumeration
    was removed in SBML Level 2 Version 3 and its values were folded into
    the space of values of a type called 'UnitSId.'  This method therefore
    has less significance in SBML Level 2 Version 3 and Level 2 Version 4,
    but remains for backward compatibility and support for reading models
    in older Versions of Level 2.

    Parameter 'name' is a string to be tested.

    Parameter 'level' is a long integer representing the SBML
    specification Level.

    Parameter 'version' is a long integer representing the SBML
    specification Version.

    Returns 'True' if name is a valid SBML UnitKind, 'False' otherwise.

    Note: The allowed unit names differ between SBML Levels 1 and 2 and
    again slightly between Level 2 Versions 1 and 2.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    """
    return _libsbml.Unit_isUnitKind(name, level, version)

def Unit_areIdentical(unit1, unit2):
    r"""
    Unit_areIdentical(Unit unit1, Unit unit2) -> bool

    Predicate returning 'True' if two Unit objects are identical.

    Two Unit objects are considered to be identical if they match in all
    attributes.  (Contrast this to the method areEquivalent(), which
    compares Unit objects only with respect to certain attributes.)

    Parameter 'unit1' is the first Unit object to compare. Parameter
    'unit2' is the second Unit object to compare.

    Returns 'True' if all the attributes of unit1 are identical to the
    attributes of unit2, 'False' otherwise.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also Unit.areEquivalent() .

    """
    return _libsbml.Unit_areIdentical(unit1, unit2)

def Unit_areEquivalent(unit1, unit2):
    r"""
    Unit_areEquivalent(Unit unit1, Unit unit2) -> bool

    Predicate returning 'True' if  Unit objects are equivalent.

    Two Unit objects are considered to be equivalent either if (1) both
    have a 'kind' attribute value of 'dimensionless,' or (2) their 'kind',
    'exponent' and (for SBML Level 2 Version 1) 'offset' attribute values
    are equal. (Contrast this to the method areIdentical(), which compares
    Unit objects with respect to all attributes, not just the 'kind' and
    'exponent'.)

    Parameter 'unit1' is the first Unit object to compare. Parameter
    'unit2' is the second Unit object to compare.

    Returns 'True' if the 'kind' and 'exponent' attributes of unit1 are
    identical to the kind and exponent attributes of unit2, or if the kind
    attributes of both are 'dimensionless;' 'False' otherwise.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also Unit.areIdentical() .

    """
    return _libsbml.Unit_areEquivalent(unit1, unit2)

def Unit_removeScale(unit):
    r"""
    Unit_removeScale(Unit unit) -> int

    Manipulates the attributes of the Unit to express the unit with the
    value of the scale attribute reduced to zero.

    For example, 1 millimetre can be expressed as a Unit with kind=
    ''metre'' multiplier=''1'' scale=''-3'' exponent=''1'.' It can also be
    expressed as a Unit with kind=''metre'' multiplier='0.001' scale=''0''
    exponent=''1'.'

    Parameter 'unit' is the Unit object to manipulate.

    Returns integer value indicating success/failure of the function.
    This particular function only does one thing irrespective of user
    input or  object state, and thus will only return a single value:

    * LIBSBML_OPERATION_SUCCESS

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also Unit.convertToSI() , Unit.merge() .

    """
    return _libsbml.Unit_removeScale(unit)

def Unit_merge(unit1, unit2):
    r"""
    Unit_merge(Unit unit1, Unit unit2)

    Merges two Unit objects with the same 'kind' attribute value into a
    single Unit.

    For example, the following,

       <unit kind='metre' exponent='2'/>
       <unit kind='metre' exponent='1'/>

    would be merged to become

       <unit kind='metre' exponent='3'/>

    Parameter 'unit1' is the first Unit object; the result of the
    operation is left as a new version of this unit, modified in-place.
    Not modified if the two units have different kinds.

    Parameter 'unit2' is the second Unit object to merge with the first.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also Unit.convertToSI() , Unit.removeScale() .

    """
    return _libsbml.Unit_merge(unit1, unit2)

def Unit_convertToSI(unit):
    r"""
    Unit_convertToSI(Unit unit) -> UnitDefinition

    Returns a UnitDefinition object containing the given 'unit' converted
    to the appropriate SI unit.

    This method exists because some units can be expressed in terms of
    others when the same physical dimension is involved.  For example, one
    hertz is identical to 1 sec^-1, one litre is equivalent to 1 cubic
    decametre, and so on.

    Parameter 'unit' is the Unit object to convert to SI.

    Returns a UnitDefinition object containing the SI unit.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also Unit.merge() .

    """
    return _libsbml.Unit_convertToSI(unit)

class ListOfUnits(ListOf):
    r"""

    A list of Unit objects.

    ListOfUnits is entirely contained within UnitDefinition.

    The various ListOf___ classes in SBML are merely containers used for
    organizing the main components of an SBML model.  In libSBML's
    implementation, ListOf___ classes are derived from the intermediate
    utility class ListOf, which is not defined by the SBML specifications
    but serves as a useful programmatic construct.  ListOf is itself is in
    turn derived from SBase, which provides all of the various ListOf___
    classes with common features defined by the SBML specification, such
    as 'metaid' attributes and annotations.

    The relationship between the lists and the rest of an SBML model is
    illustrated by the following (for SBML Level 2 Version 4):

      <?xml version="1.0" encoding="UTF-8"?>
      <sbml xmlns="http://www.sbml.org/sbml/level3/version1/core" 
            level="3" version="1">
        <model id="My_Model">
          <listOfFunctionDefinitions>
            <functionDefinition> ... </functionDefinition> 
          </listOfFunctionDefinitions>
          <listOfUnitDefinitions>
            <unitDefinition> ... </unitDefinition> 
          </listOfUnitDefinitions>
          <listOfCompartments>
            <compartment> ... </compartment> 
          </listOfCompartments>
          <listOfSpecies>
            <species> ... </species> 
          </listOfSpecies>
          <listOfParameters>
            <parameter> ... </parameter> 
          </listOfParameters>
          <listOfInitialAssignments>
            <initialAssignment> ... </initialAssignment> 
          </listOfInitialAssignments>
          <listOfRules>
            ... elements of subclasses of Rule ...
          </listOfRules>
          <listOfConstraints>
            <constraint> ... </constraint> 
          </listOfConstraints>
          <listOfReactions>
            <reaction> ... </reaction> 
          </listOfReactions>
          <listOfEvents>
            <event> ... </event> 
          </listOfEvents>
        </model>
      </sbml>

    SBML Level 3 Version 1 has essentially the same structure as  Level
    2 Version 4, depicted above, but SBML Level 3  Version 2 allows
    containers to contain zero or more of the relevant object, instead of
    requiring at least one.  As such, libsbml will write out an
    otherwise-empty ListOf___ element that has any optional attribute set
    (such as 'id' or 'metaid'), that has an optional child (such  as a
    'notes' or 'annotation'), or that has attributes or children set from
    any SBML Level 3 package, whether or not the ListOf___ has  any other
    children.

    Readers may wonder about the motivations for using the ListOf___
    containers in SBML.  A simpler approach in XML might be to place the
    components all directly at the top level of the model definition.  The
    choice made in SBML is to group them within XML elements named after
    ListOfClassname, in part because it helps organize the components.
    More importantly, the fact that the container classes are derived from
    SBase means that software tools can add information about the lists
    themselves into each list container's 'annotation'.

    See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
    ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
    ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ListOfUnits self, unsigned int level, unsigned int version) -> ListOfUnits
        __init__(ListOfUnits self, SBMLNamespaces sbmlns) -> ListOfUnits

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfUnits(long level, long version)

        Creates a new ListOfUnits object.

        The object is constructed such that it is valid for the given SBML
        Level and Version combination.

        Parameter 'level' is the SBML Level.

        Parameter 'version' is the Version within the SBML Level.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfUnits(SBMLNamespaces sbmlns)

        Creates a new ListOfUnits object.

        The object is constructed such that it is valid for the SBML Level and
        Version combination determined by the SBMLNamespaces object in
        'sbmlns'.

        Parameter 'sbmlns' is an SBMLNamespaces object that is used to
        determine the characteristics of the ListOfUnits object to be created.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        """
        _libsbml.ListOfUnits_swiginit(self, _libsbml.new_ListOfUnits(*args))

    def clone(self):
        r"""
        clone(ListOfUnits self) -> ListOfUnits

        Creates and returns a deep copy of this ListOfUnits object.

        Returns the (deep) copy of this ListOfUnits object.

        """
        return _libsbml.ListOfUnits_clone(self)

    def getItemTypeCode(self):
        r"""
        getItemTypeCode(ListOfUnits self) -> int

        Returns the libSBML type code for the objects contained in this ListOf
        (i.e., Unit objects, if the list is non-empty).

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for objects contained in this list:
        SBML_UNIT (default).

        See also getElementName(), getPackageName().

        """
        return _libsbml.ListOfUnits_getItemTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(ListOfUnits self) -> string

        Returns the XML element name of this object.

        For ListOfUnits, the XML element name is ''listOfUnits'.'

        Returns the name of this element, i.e., ''listOfUnits'.'

        """
        return _libsbml.ListOfUnits_getElementName(self)

    def get(self, *args):
        r"""
        get(ListOfUnits self, unsigned int n) -> Unit
        get(ListOfUnits self, unsigned int n) -> Unit

        Get a Unit from the ListOfUnits.

        Parameter 'n' is the index number of the Unit to get.

        Returns the nth Unit in this ListOfUnits. If the index 'n' is invalid,
        'None' is returned.

        See also size().

        """
        return _libsbml.ListOfUnits_get(self, *args)

    def remove(self, n):
        r"""
        remove(ListOfUnits self, unsigned int n) -> Unit

        Removes the nth item from this ListOfUnits items and returns a pointer
        to it.

        The caller owns the returned item and is responsible for deleting it.

        Parameter 'n' is the index of the item to remove.

        See also size().

        """
        return _libsbml.ListOfUnits_remove(self, n)
    __swig_destroy__ = _libsbml.delete_ListOfUnits

# Register ListOfUnits in _libsbml:
_libsbml.ListOfUnits_swigregister(ListOfUnits)

class UnitDefinition(SBase):
    r"""

    A definition of a unit used in an SBML model.

    Units of measurement may be supplied in a number of contexts in an
    SBML model.  The SBML unit definition facility uses two classes of
    objects, UnitDefinition and Unit.  The approach to defining units in
    SBML is compositional; for example, meter second^-2 is constructed by
    combining a Unit object representing meter with another Unit object
    representing second^-2. The combination is wrapped inside a
    UnitDefinition, which provides for assigning an identifier and
    optional name to the combination.  The identifier can then be
    referenced from elsewhere in a model.  Thus, the UnitDefinition class
    is the container, and Unit instances are placed inside UnitDefinition
    instances.

    Two points are worth discussing in the context of SBML units.  First,
    unit declarations in SBML models are optional.  The consequence of
    this is that a model must be numerically self-consistent independently
    of unit declarations, for the benefit of software tools that cannot
    interpret or manipulate units.  Unit declarations in SBML are thus
    more akin to a type of annotation; they can indicate intentions, and
    can be used by model readers for checking the consistency of the
    model, labeling simulation output, etc., but any transformations of
    values implied by different units must be incorporated explicitly into
    a model.

    Second, the vast majority of situations that require new SBML unit
    definitions involve simple multiplicative combinations of base units
    and factors.  An example is moles per litre per second.  What
    distinguishes these sorts of unit definitions from more complex ones
    is that they may be expressed without the use of an additive offset
    from a zero point.  The use of offsets complicates all unit definition
    systems, yet in the domain of SBML, the real-life cases requiring
    offsets are few (and in fact, to the best of our knowledge, only
    involve temperature). Consequently, the SBML unit system has been
    consciously designed to simplify implementation of unit support for
    the most common cases in systems biology.  The cost of this
    simplification is to require units with offsets to be handled
    explicitly by the modeler.

    Summary of the UnitDefinition construct
    ======================================================================

    UnitDefinition has two attributes and one subelement.  The two
    attributes are 'id' and 'name', and the subelement is ListOfUnits.

    The required attribute 'id' and optional attribute 'name' are both
    strings.  The 'id' attribute is used to give the defined unit a unique
    identifier by which other parts of an SBML model definition can refer
    to it.  The 'name' attribute is intended to be used for giving the
    unit definition an optional human-readable name.  Please see the next
    section for information about the values permitted for 'id'.

    A UnitDefinition may contain exactly one ListOfUnits, and this list
    may contain one or more Unit definitions; see the definitions of these
    other object classes for more information about them.  In SBML  Level
    2 and SBML Level 3 Version 1, if the ListOfUnits was present, it must
    have one or more Unit definitions.  In SBML Level 3 Version 2, this
    restriction was relaxed, and  a ListOfUnits was allowed to be empty.
    In either case, if a UnitDefinition had no child Unit elements, the
    unit was considered to be undefined.

    The following example illustrates a complete unit definition (when
    written in XML) when all the pieces are combined together.  This
    defines 'mmls' to be millimoles per litre per second.

       <listOfUnitDefinitions>
           <unitDefinition id='mmls'>
               <listOfUnits>
                   <unit kind='mole'   scale='-3'/>
                   <unit kind='litre'  exponent='-1'/>
                   <unit kind='second' exponent='-1'/>
               </listOfUnits>
           </unitDefinition>
       </listOfUnitDefinitions>

    Special considerations for Unit object identifiers
    ======================================================================

    The attribute 'id' in UnitDefinition cannot be given simply any value,
    and the precise details of the values permitted differ slightly
    between Levels of SBML:

    * The 'id' of a UnitDefinition must not contain a value from the list
    of SBML's predefined base unit names (i.e., the strings 'gram,'
    'litre,' etc.).  In SBML Level 3, this list consists of the following:

       ampere         farad  joule     lux     radian     volt  
       avogadro       gram   katal     metre   second     watt  
       becquerel      gray   kelvin    mole    siemens    weber 
       candela        henry  kilogram  newton  sievert          
       coulomb        hertz  litre     ohm     steradian        
       dimensionless  item   lumen     pascal  tesla

    This list of predefined base units is nearly identical in SBML Level
    2 Version 4, the exception being that Level 2 does not define
    'avogadro.'  SBML Level 2 Version 1 (and only this Level+Version
    combination) provides an additional predefined unit name, 'Celsius,'
    not available in Level 3.  Finally, SBML Level 1 Versions 2-3 provide
    two more additional predefined unit names, 'meter' and 'liter.'  This
    is explained in somewhat greater detail in the description of the Unit
    class.

    * In SBML Level 2 (all Versions), there is an additional set of
    reserved identifiers: 'substance,' 'volume,' 'area,' 'length,' and
    'time.'  Using one of these values for the attribute 'id' of a
    UnitDefinition has the effect of redefining the model-wide default
    units for the corresponding quantities.  The list of special unit
    names in SBML Level 2 is given in the table below:

      +------------+-------------------------------------------+---------------+
      | Identifier | Possible scalable units                   | Default units |
      +------------+-------------------------------------------+---------------+
      | substance  | mole, item, gram, kilogram, dimensionless | mole          |
      | volume     | litre, cubic metre, dimensionless         | litre         |
      | area       | square metre, dimensionless               | square metre  |
      | length     | metre, dimensionless                      | metre         |
      | time       | second, dimensionless                     | second        |
      +------------+-------------------------------------------+---------------+

    Also, SBML Level 2 imposes two limitations on redefining the
    predefined unit 'substance,' 'volume,' 'area,' 'length,' and 'time:'
    (1) The UnitDefinition of a predefined SBML unit can only contain a
    single Unit object within it.  (2) The value of the 'kind' attribute
    in a Unit instance must be drawn from one of the values in the second
    column of the table above.

    The special unit names 'substance,' 'volume,' 'area,' 'length,' and
    'time' are not defined by SBML Level 3, which uses a different
    approach to setting model-wide inherited units.

    Further comments about SBML's unit definition system
    ======================================================================

    The vast majority of modeling situations requiring new SBML unit
    definitions involve simple multiplicative combinations of base units
    and factors.  An example of this might be moles per litre per second.
    What distinguishes these sorts of simpler unit definitions from more
    complex ones is that they may be expressed without the use of an
    additive offset from a zero point.  The use of offsets complicates all
    unit definition systems, yet in the domain of SBML the real-life cases
    requiring offsets are few (and in fact, to the best of our knowledge,
    only involve temperature).  Consequently, the SBML unit system has
    been consciously designed in a way that attempts to simplify
    implementation of unit support for the most common cases in systems
    biology.

    As of SBML Level 2 Version 2, Unit no longer has the attribute called
    'offset' introduced in SBML Level 2 Version 1.  It turned out that the
    general case involving units with offsets was incorrectly defined, and
    few (if any) developers even attempted to support offset-based units
    in their software.  In the development of Level 2 Version 2, a
    consensus among SBML developers emerged that a fully generalized unit
    scheme is so confusing and complicated that it actually impedes
    interoperability. SBML Level 2 Version 2, Version 3 and Version 4
    acknowledge this reality by reducing and simplifying the unit system,
    specifically by removing the 'offset' attribute on Unit and 'Celsius'
    as a pre-defined unit.

    The following guidelines suggest methods for handling units that do
    require the use of zero offsets for their definitions:

    * Handling Celsius.  A model in which certain quantities are
    temperatures measured in degrees Celsius can be converted
    straightforwardly to a model in which those temperatures are in
    kelvin.  A software tool could do this by performing a straightforward
    substitution using the following relationship: T_ kelvin = T_Celsius +
    273.15.  In every mathematical formula of the model where a quantity
    (call it x) in degrees Celsius appears, replace x with x_k+ 273.15,
    where x_k is now in kelvin.  An alternative approach would  be to use
    a FunctionDefinition object to define a function encapsulating this
    relationship above and then using that in the rest of the model as
    needed.  Since Celsius is a commonly-used unit, software tools could
    help users by providing users with the ability to express temperatures
    in Celsius in the tools' interfaces, and making substitutions
    automatically when writing out the SBML.

    * Other units requiring offsets.  One approach to handling other kinds
    of units is to use a FunctionDefinition to define a function
    encapsulating the necessary mathematical relationship, then
    substituting a call to this function wherever the original quantity
    appeared in the model.  For example, here is a possible definition for
    converting Fahrenheit to Celsius degrees:

       <functionDefinition id='Fahrenheit_to_kelvin'>
           <math xmlns='http://www.w3.org/1998/Math/MathML'>
               <lambda>
                   <bvar><ci> temp_in_fahrenheit </ci></bvar>
                   <apply>
                       <divide/>
                       <apply>
                           <plus/>
                           <ci> temp_in_fahrenheit </ci>
                           <cn> 459.67 </cn>
                       </apply>
                       <cn> 1.8 </cn>
                   </apply>
               </lambda>
           </math>
       </functionDefinition>

    * An alternative approach not requiring the use of function
    definitions is to use an AssignmentRule for each variable in
    Fahrenheit units. The AssignmentRule could compute the conversion from
    Fahrenheit to (say) kelvin, assign its value to a variable (in Kelvin
    units), and then that variable could be used elsewhere in the model.

    * Still another approach is to rewrite the mathematical formulas of a
    model to directly incorporate the conversion formula wherever the
    original quantity appeared. Please consult the SBML specifications for
    more information about this and other issues involving units.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_UnitDefinition

    def __init__(self, *args):
        r"""
        __init__(UnitDefinition self, unsigned int level, unsigned int version) -> UnitDefinition
        __init__(UnitDefinition self, SBMLNamespaces sbmlns) -> UnitDefinition
        __init__(UnitDefinition self, UnitDefinition orig) -> UnitDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            UnitDefinition(long level, long version)

        Creates a new UnitDefinition using the given SBML 'level' and
        'version' values.

        Parameter 'level' is a long integer, the SBML Level to assign to this
        UnitDefinition.

        Parameter 'version' is a long integer, the SBML Version to assign to
        this UnitDefinition.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            UnitDefinition(SBMLNamespaces sbmlns)

        Creates a new UnitDefinition using the given SBMLNamespaces object
        'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            UnitDefinition(UnitDefinition orig)

        Copy constructor; creates a copy of this UnitDefinition.

        Parameter 'orig' is the object to copy.

        """
        _libsbml.UnitDefinition_swiginit(self, _libsbml.new_UnitDefinition(*args))

    def clone(self):
        r"""
        clone(UnitDefinition self) -> UnitDefinition

        Creates and returns a deep copy of this UnitDefinition object.

        Returns the (deep) copy of this UnitDefinition object.

        """
        return _libsbml.UnitDefinition_clone(self)

    def getElementBySId(self, id):
        r"""
        getElementBySId(UnitDefinition self, string id) -> SBase

        Returns the first child element found that has the given 'id' in the
        model-wide SId namespace, or 'None' if no such object is found.

        Parameter 'id' is string representing the id of the object to find.

        Returns pointer to the first element found with the given 'id'.

        """
        return _libsbml.UnitDefinition_getElementBySId(self, id)

    def getElementByMetaId(self, metaid):
        r"""
        getElementByMetaId(UnitDefinition self, string metaid) -> SBase

        Returns the first child element it can find with the given 'metaid',
        or 'None' if no such object is found.

        Parameter 'metaid' is string representing the metaid of the object to
        find.

        Returns pointer to the first element found with the given 'metaid'.

        """
        return _libsbml.UnitDefinition_getElementByMetaId(self, metaid)

    def getId(self):
        r"""
        getId(UnitDefinition self) -> string

        Returns the value of the 'id' attribute of this UnitDefinition.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is now recommended to use the
        getIdAttribute() function instead.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this UnitDefinition.

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.UnitDefinition_getId(self)

    def getName(self):
        r"""
        getName(UnitDefinition self) -> string

        Returns the value of the 'name' attribute of this UnitDefinition
        object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns the name of this SBML object, or the empty string if not set
        or unsettable.

        See also getIdAttribute(), isSetName(), setName(), unsetName().

        """
        return _libsbml.UnitDefinition_getName(self)

    def isSetId(self):
        r"""
        isSetId(UnitDefinition self) -> bool

        Predicate returning 'True' if this UnitDefinition's 'id' attribute is
        set.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is recommended that callers use
        isSetIdAttribute() instead.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
        isSetIdAttribute().

        """
        return _libsbml.UnitDefinition_isSetId(self)

    def isSetName(self):
        r"""
        isSetName(UnitDefinition self) -> bool

        Predicate returning 'True' if this UnitDefinition's 'name' attribute
        is set.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns 'True' if the 'name' attribute of this SBML object is set,
        'False' otherwise.

        See also getName(), setName(), unsetName().

        """
        return _libsbml.UnitDefinition_isSetName(self)

    def setId(self, sid):
        r"""
        setId(UnitDefinition self, string sid) -> int

        Sets the value of the 'id' attribute of this UnitDefinition.

        The string 'sid' is copied.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Parameter 'sid' is the string to use as the identifier of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.UnitDefinition_setId(self, sid)

    def setName(self, name):
        r"""
        setName(UnitDefinition self, string name) -> int

        Sets the value of the 'name' attribute of this UnitDefinition.

        The string in 'name' is copied.

        Parameter 'name' is the new name for the SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.UnitDefinition_setName(self, name)

    def unsetName(self):
        r"""
        unsetName(UnitDefinition self) -> int

        Unsets the value of the 'name' attribute of this UnitDefinition.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getName(), setName(), isSetName().

        """
        return _libsbml.UnitDefinition_unsetName(self)

    def isVariantOfArea(self, relaxed=False):
        r"""
        isVariantOfArea(UnitDefinition self, bool relaxed=False) -> bool

        Convenience function for testing if a given unit definition is a
        variant of the predefined unit identifier ''area'.'

        Returns 'True' if this UnitDefinition is a variant of the predefined
        unit 'area,' meaning square metres with only arbitrary variations in
        scale or multiplier values; 'False' otherwise.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_isVariantOfArea(self, relaxed)

    def isVariantOfLength(self, relaxed=False):
        r"""
        isVariantOfLength(UnitDefinition self, bool relaxed=False) -> bool

        Convenience function for testing if a given unit definition is a
        variant of the predefined unit identifier ''length'.'

        Returns 'True' if this UnitDefinition is a variant of the predefined
        unit 'length,' meaning metres with only arbitrary variations in scale
        or multiplier values; 'False' otherwise.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_isVariantOfLength(self, relaxed)

    def isVariantOfSubstance(self, relaxed=False):
        r"""
        isVariantOfSubstance(UnitDefinition self, bool relaxed=False) -> bool

        Convenience function for testing if a given unit definition is a
        variant of the predefined unit identifier ''substance'.'

        Returns 'True' if this UnitDefinition is a variant of the predefined
        unit 'substance,' meaning moles or items (and grams or kilograms from
        SBML Level 2 Version 2 onwards) with only arbitrary variations in
        scale or multiplier values; 'False' otherwise.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_isVariantOfSubstance(self, relaxed)

    def isVariantOfTime(self, relaxed=False):
        r"""
        isVariantOfTime(UnitDefinition self, bool relaxed=False) -> bool

        Convenience function for testing if a given unit definition is a
        variant of the predefined unit identifier ''time'.'

        Returns 'True' if this UnitDefinition is a variant of the predefined
        unit 'time,' meaning seconds with only arbitrary variations in scale
        or multiplier values; 'False' otherwise.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_isVariantOfTime(self, relaxed)

    def isVariantOfVolume(self, relaxed=False):
        r"""
        isVariantOfVolume(UnitDefinition self, bool relaxed=False) -> bool

        Convenience function for testing if a given unit definition is a
        variant of the predefined unit identifier ''volume'.'

        Returns 'True' if this UnitDefinition is a variant of the predefined
        unit 'volume,' meaning litre or cubic metre with only arbitrary
        variations in scale or multiplier values; 'False' otherwise.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_isVariantOfVolume(self, relaxed)

    def isVariantOfDimensionless(self, relaxed=False):
        r"""
        isVariantOfDimensionless(UnitDefinition self, bool relaxed=False) -> bool

        Convenience function for testing if a given unit definition is a
        variant of the unit ''dimensionless'.'

        Returns 'True' if this UnitDefinition is a variant of 'dimensionless,'
        meaning dimensionless with only arbitrary variations in scale or
        multiplier values; 'False' otherwise.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_isVariantOfDimensionless(self, relaxed)

    def isVariantOfMass(self, relaxed=False):
        r"""
        isVariantOfMass(UnitDefinition self, bool relaxed=False) -> bool

        Convenience function for testing if a given unit definition is a
        variant of the predefined unit identifier ''mass'.'

        Returns 'True' if this UnitDefinition is a variant of mass units,
        meaning gram or kilogram with only arbitrary variations in scale or
        multiplier values; 'False' otherwise.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_isVariantOfMass(self, relaxed)

    def isVariantOfSubstancePerTime(self, relaxed=False):
        r"""
        isVariantOfSubstancePerTime(UnitDefinition self, bool relaxed=False) -> bool

        Convenience function for testing if a given unit definition is a
        variant of the predefined unit ''substance'' divided by the predefined
        unit ''time'.'

        Returns 'True' if this UnitDefinition is a variant of the predefined
        unit 'substance' per predefined unit 'time,' meaning it contains two
        units one of which is a variant of substance and the other is a
        variant of time which an exponent of -1; 'False' otherwise.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_isVariantOfSubstancePerTime(self, relaxed)

    def addUnit(self, u):
        r"""
        addUnit(UnitDefinition self, Unit u) -> int

        Adds a copy of the given Unit to this UnitDefinition.

        Parameter 'u' is the Unit instance to add to this UnitDefinition.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_LEVEL_MISMATCH

        * LIBSBML_VERSION_MISMATCH

        * LIBSBML_INVALID_OBJECT

        * LIBSBML_OPERATION_FAILED

        Note: This method should be used with some caution.  The fact that
        this method copies the object passed to it means that the caller will
        be left holding a physically different object instance than the one
        contained inside this object.  Changes made to the original object
        instance (such as resetting attribute values) will not affect the
        instance in this object.  In addition, the caller should make sure to
        free the original object if it is no longer being used, or else a
        memory leak will result.  Please see other methods on this class
        (particularly a corresponding method whose name begins with the word
        create) for alternatives that do not lead to these issues.

        See also createUnit().

        """
        return _libsbml.UnitDefinition_addUnit(self, u)

    def createUnit(self):
        r"""
        createUnit(UnitDefinition self) -> Unit

        Creates a new and empty Unit, adds it to this UnitDefinition's list of
        units, and returns it.

        Returns a newly constructed (and empty) Unit instance.

        Note: It is worth emphasizing that the attribute 'kind' value of a
        Unit is a required attribute for a valid Unit definition.  The
        createUnit() method does not assign a valid kind to the constructed
        unit (instead, it sets the 'kind' to UNIT_KIND_INVALID). Callers are
        cautioned to set the newly-constructed Unit's kind using
        Unit.setKind() soon after calling this method.

        See also addUnit().

        """
        return _libsbml.UnitDefinition_createUnit(self)

    def getListOfUnits(self, *args):
        r"""
        getListOfUnits(UnitDefinition self) -> ListOfUnits
        getListOfUnits(UnitDefinition self) -> ListOfUnits

        Returns the list of Units for this UnitDefinition instance. Returns
        the ListOfUnits value for this UnitDefinition.

        """
        return _libsbml.UnitDefinition_getListOfUnits(self, *args)

    def getUnit(self, *args):
        r"""
        getUnit(UnitDefinition self, unsigned int n) -> Unit
        getUnit(UnitDefinition self, unsigned int n) -> Unit

        Returns a specific Unit instance belonging to this UnitDefinition.

        Parameter 'n' is an integer, the index of the Unit to be returned.

        Returns the nth Unit of this UnitDefinition. If the index 'n' is
        invalid, 'None' is returned.

        See also getNumUnits().

        """
        return _libsbml.UnitDefinition_getUnit(self, *args)

    def getNumUnits(self):
        r"""
        getNumUnits(UnitDefinition self) -> unsigned int

        Returns the number of Unit objects contained within this
        UnitDefinition.

        Returns an integer representing the number of Units in this
        UnitDefinition.

        """
        return _libsbml.UnitDefinition_getNumUnits(self)

    def removeUnit(self, n):
        r"""
        removeUnit(UnitDefinition self, unsigned int n) -> Unit

        Removes the nth Unit object from this UnitDefinition object and
        returns a pointer to it.

        The caller owns the returned object and is responsible for deleting
        it.

        Parameter 'n' is the index of the Unit object to remove.

        Returns the Unit object removed, or 'None' if the given index  is out
        of range.

        """
        return _libsbml.UnitDefinition_removeUnit(self, n)

    def connectToChild(self):
        r"""connectToChild(UnitDefinition self)"""
        return _libsbml.UnitDefinition_connectToChild(self)

    def enablePackageInternal(self, pkgURI, pkgPrefix, flag):
        r"""
        enablePackageInternal(UnitDefinition self, string pkgURI, string pkgPrefix, bool flag)

        Internal implementation method.

        """
        return _libsbml.UnitDefinition_enablePackageInternal(self, pkgURI, pkgPrefix, flag)

    def updateSBMLNamespace(self, package, level, version):
        r"""
        updateSBMLNamespace(UnitDefinition self, string package, unsigned int level, unsigned int version)

        Internal implementation method.

        """
        return _libsbml.UnitDefinition_updateSBMLNamespace(self, package, level, version)

    def getTypeCode(self):
        r"""
        getTypeCode(UnitDefinition self) -> int

        Returns the libSBML type code for this object instance.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_UNIT_DEFINITION
        (default).

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getPackageName(), getElementName().

        """
        return _libsbml.UnitDefinition_getTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(UnitDefinition self) -> string

        Returns the XML element name of this object, which for UnitDefinition,
        is always ''unitDefinition'.'

        Returns the name of this element, i.e., ''unitDefinition'.'

        """
        return _libsbml.UnitDefinition_getElementName(self)

    @staticmethod
    def simplify(ud):
        r"""
        simplify(UnitDefinition ud)

        Simplifies the UnitDefinition such that any given kind of Unit object
        occurs only once in the ListOfUnits.

        For example, the following definition,

           <unitDefinition>
            <listOfUnits>
              <unit kind='metre' exponent='1'/>
              <unit kind='metre' exponent='2'/>
            </listOfUnits>
           <unitDefinition>

        will be simplified to

           <unitDefinition>
             <listOfUnits>
               <unit kind='metre' exponent='3'/>
             </listOfUnits>
           <unitDefinition>

        Parameter 'ud' is the UnitDefinition object to be simplified.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        """
        return _libsbml.UnitDefinition_simplify(ud)

    @staticmethod
    def reorder(ud):
        r"""
        reorder(UnitDefinition ud)

        Alphabetically orders the Unit objects within the ListOfUnits of a
        UnitDefinition.

        Parameter 'ud' is the UnitDefinition object whose units are to be
        reordered.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        """
        return _libsbml.UnitDefinition_reorder(ud)

    @staticmethod
    def convertToSI(ud):
        r"""
        convertToSI(UnitDefinition ud) -> UnitDefinition

        Convert a given UnitDefinition into a new UnitDefinition object that
        uses SI units.

        Parameter 'ud' is the UnitDefinition object to convert to SI.

        Returns a new UnitDefinition object representing the results of the
        conversion.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        """
        return _libsbml.UnitDefinition_convertToSI(ud)

    @staticmethod
    def areIdentical(ud1, ud2):
        r"""
        areIdentical(UnitDefinition ud1, UnitDefinition ud2) -> bool

        Predicate returning 'True' if two UnitDefinition objects are
        identical.

        For the purposes of performing this comparison, two UnitDefinition
        objects are considered identical when they contain identical lists of
        Unit objects.  Pairs of Unit objects in the lists are in turn
        considered identical if they satisfy the predicate
        Unit.areIdentical(). The predicate compares every attribute of the
        Unit objects.

        Parameter 'ud1' is the first UnitDefinition object to compare.
        Parameter 'ud2' is the second UnitDefinition object to compare.

        Returns 'True' if all the Unit objects in 'ud1' are identical to the
        Unit objects of 'ud2', 'False' otherwise.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also UnitDefinition.areEquivalent(), Unit.areIdentical().

        """
        return _libsbml.UnitDefinition_areIdentical(ud1, ud2)

    @staticmethod
    def areEquivalent(ud1, ud2):
        r"""
        areEquivalent(UnitDefinition ud1, UnitDefinition ud2) -> bool

        Predicate returning 'True' if two UnitDefinition objects are
        equivalent.

        For the purposes of performing this comparison, two UnitDefinition
        objects are considered equivalent when they contain equivalent list of
        Unit objects.  Unit objects are in turn considered equivalent if they
        satisfy the predicate Unit.areEquivalent(). The predicate tests a
        subset of the objects's attributes.

        Parameter 'ud1' is the first UnitDefinition object to compare.

        Parameter 'ud2' is the second UnitDefinition object to compare.

        Returns 'True' if all the Unit objects in 'ud1' are equivalent to the
        Unit objects in 'ud2', 'False' otherwise.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        See also UnitDefinition.areIdentical(), Unit.areEquivalent().

        """
        return _libsbml.UnitDefinition_areEquivalent(ud1, ud2)

    @staticmethod
    def combine(ud1, ud2):
        r"""
        combine(UnitDefinition ud1, UnitDefinition ud2) -> UnitDefinition

        Combines two UnitDefinition objects into a single UnitDefinition.

        This takes UnitDefinition objects 'ud1' and 'ud2', and creates a
        UnitDefinition object that expresses the product of the units of 'ud1'
        and 'ud2'.

        Parameter 'ud1' is the first UnitDefinition object. Parameter 'ud2' is
        the second UnitDefinition object.

        Returns a UnitDefinition which represents the product of the  units of
        the two argument UnitDefinitions.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        """
        return _libsbml.UnitDefinition_combine(ud1, ud2)

    @staticmethod
    def divide(ud1, ud2):
        r"""
        divide(UnitDefinition ud1, UnitDefinition ud2) -> UnitDefinition

        Combines two UnitDefinition objects into a single UnitDefinition as a
        division.

        This takes UnitDefinition objects 'ud1' and 'ud2', and creates a
        UnitDefinition object that expresses the division of the units of
        'ud1' and 'ud2'.

        Parameter 'ud1' is the first UnitDefinition object. Parameter 'ud2' is
        the second UnitDefinition object.

        Returns a UnitDefinition which represents the division of the  units
        of the two argument UnitDefinitions.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        """
        return _libsbml.UnitDefinition_divide(ud1, ud2)

    @staticmethod
    def printUnits(ud, compact=False):
        r"""
        printUnits(UnitDefinition ud, bool compact=False) -> string

        Expresses the given definition in a plain-text form.

        For example, UnitDefinition.printUnits() applied to

           <unitDefinition>
            <listOfUnits>
              <unit kind='metre' exponent='1'/>
              <unit kind='second' exponent='-2'/>
            </listOfUnits>
           <unitDefinition>

        will return the string 'metre (exponent = 1, multiplier = 1, scale =
        0) second (exponent = -2, multiplier = 1, scale = 0)' or, if the
        optional parameter 'compact' is given the value 'True,' the string '(1
        metre)^1 (1 second)^-2'.  This method may be useful for printing unit
        information to human users, or in debugging software, or other
        situations.

        Parameter 'ud' is the UnitDefinition object. Parameter 'compact' is
        boolean indicating whether the compact form should be used (defaults
        to false).

        Returns a string expressing the unit definition defined by the given
        UnitDefinition object 'ud'.

        Note: Because this is a static method on a class, the Python language
        interface for libSBML will contain two variants.  One will be the
        expected, normal static method on the class (i.e., a regular
        methodName), and the other will be a standalone top-level function
        with the name ClassName_methodName(). This is merely an artifact of
        how the language interfaces are created in libSBML.  The methods are
        functionally identical.

        Note: Owing to the way that language interfaces are created in
        libSBML, this documentation may show methods that define default
        values for parameters with text that has the form parameter = value.
        This is not to be intepreted as a Python keyword argument; the use of
        a parameter name followed by an equals sign followed by a value is
        only meant to indicate a default value if the argument is not provided
        at all.  It is not a keyword in the Python sense.

        """
        return _libsbml.UnitDefinition_printUnits(ud, compact)

    def hasRequiredAttributes(self):
        r"""
        hasRequiredAttributes(UnitDefinition self) -> bool

        Predicate returning 'True' if all the required attributes for this
        UnitDefinition object have been set.

        The required attributes for a UnitDefinition object are:

        * 'id'

        Returns 'True' if the required attributes have been set, 'False'
        otherwise.

        """
        return _libsbml.UnitDefinition_hasRequiredAttributes(self)

    def hasRequiredElements(self):
        r"""
        hasRequiredElements(UnitDefinition self) -> bool

        Predicate returning 'True' if all the required elements for this
        UnitDefinition object have been set.

        Note: The required elements for a Constraint object are:

        * 'listOfUnits' (required in SBML Level 2 only, optional in Level
        3)

        Returns a boolean value indicating whether all the required elements
        for this object have been defined.

        """
        return _libsbml.UnitDefinition_hasRequiredElements(self)

# Register UnitDefinition in _libsbml:
_libsbml.UnitDefinition_swigregister(UnitDefinition)

def UnitDefinition_simplify(ud):
    r"""
    UnitDefinition_simplify(UnitDefinition ud)

    Simplifies the UnitDefinition such that any given kind of Unit object
    occurs only once in the ListOfUnits.

    For example, the following definition,

       <unitDefinition>
        <listOfUnits>
          <unit kind='metre' exponent='1'/>
          <unit kind='metre' exponent='2'/>
        </listOfUnits>
       <unitDefinition>

    will be simplified to

       <unitDefinition>
         <listOfUnits>
           <unit kind='metre' exponent='3'/>
         </listOfUnits>
       <unitDefinition>

    Parameter 'ud' is the UnitDefinition object to be simplified.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    """
    return _libsbml.UnitDefinition_simplify(ud)

def UnitDefinition_reorder(ud):
    r"""
    UnitDefinition_reorder(UnitDefinition ud)

    Alphabetically orders the Unit objects within the ListOfUnits of a
    UnitDefinition.

    Parameter 'ud' is the UnitDefinition object whose units are to be
    reordered.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    """
    return _libsbml.UnitDefinition_reorder(ud)

def UnitDefinition_convertToSI(ud):
    r"""
    UnitDefinition_convertToSI(UnitDefinition ud) -> UnitDefinition

    Convert a given UnitDefinition into a new UnitDefinition object that
    uses SI units.

    Parameter 'ud' is the UnitDefinition object to convert to SI.

    Returns a new UnitDefinition object representing the results of the
    conversion.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    """
    return _libsbml.UnitDefinition_convertToSI(ud)

def UnitDefinition_areIdentical(ud1, ud2):
    r"""
    UnitDefinition_areIdentical(UnitDefinition ud1, UnitDefinition ud2) -> bool

    Predicate returning 'True' if two UnitDefinition objects are
    identical.

    For the purposes of performing this comparison, two UnitDefinition
    objects are considered identical when they contain identical lists of
    Unit objects.  Pairs of Unit objects in the lists are in turn
    considered identical if they satisfy the predicate
    Unit.areIdentical(). The predicate compares every attribute of the
    Unit objects.

    Parameter 'ud1' is the first UnitDefinition object to compare.
    Parameter 'ud2' is the second UnitDefinition object to compare.

    Returns 'True' if all the Unit objects in 'ud1' are identical to the
    Unit objects of 'ud2', 'False' otherwise.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also UnitDefinition.areEquivalent(), Unit.areIdentical().

    """
    return _libsbml.UnitDefinition_areIdentical(ud1, ud2)

def UnitDefinition_areEquivalent(ud1, ud2):
    r"""
    UnitDefinition_areEquivalent(UnitDefinition ud1, UnitDefinition ud2) -> bool

    Predicate returning 'True' if two UnitDefinition objects are
    equivalent.

    For the purposes of performing this comparison, two UnitDefinition
    objects are considered equivalent when they contain equivalent list of
    Unit objects.  Unit objects are in turn considered equivalent if they
    satisfy the predicate Unit.areEquivalent(). The predicate tests a
    subset of the objects's attributes.

    Parameter 'ud1' is the first UnitDefinition object to compare.

    Parameter 'ud2' is the second UnitDefinition object to compare.

    Returns 'True' if all the Unit objects in 'ud1' are equivalent to the
    Unit objects in 'ud2', 'False' otherwise.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    See also UnitDefinition.areIdentical(), Unit.areEquivalent().

    """
    return _libsbml.UnitDefinition_areEquivalent(ud1, ud2)

def UnitDefinition_combine(ud1, ud2):
    r"""
    UnitDefinition_combine(UnitDefinition ud1, UnitDefinition ud2) -> UnitDefinition

    Combines two UnitDefinition objects into a single UnitDefinition.

    This takes UnitDefinition objects 'ud1' and 'ud2', and creates a
    UnitDefinition object that expresses the product of the units of 'ud1'
    and 'ud2'.

    Parameter 'ud1' is the first UnitDefinition object. Parameter 'ud2' is
    the second UnitDefinition object.

    Returns a UnitDefinition which represents the product of the  units of
    the two argument UnitDefinitions.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    """
    return _libsbml.UnitDefinition_combine(ud1, ud2)

def UnitDefinition_divide(ud1, ud2):
    r"""
    UnitDefinition_divide(UnitDefinition ud1, UnitDefinition ud2) -> UnitDefinition

    Combines two UnitDefinition objects into a single UnitDefinition as a
    division.

    This takes UnitDefinition objects 'ud1' and 'ud2', and creates a
    UnitDefinition object that expresses the division of the units of
    'ud1' and 'ud2'.

    Parameter 'ud1' is the first UnitDefinition object. Parameter 'ud2' is
    the second UnitDefinition object.

    Returns a UnitDefinition which represents the division of the  units
    of the two argument UnitDefinitions.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    """
    return _libsbml.UnitDefinition_divide(ud1, ud2)

def UnitDefinition_printUnits(ud, compact=False):
    r"""
    UnitDefinition_printUnits(UnitDefinition ud, bool compact=False) -> string

    Expresses the given definition in a plain-text form.

    For example, UnitDefinition.printUnits() applied to

       <unitDefinition>
        <listOfUnits>
          <unit kind='metre' exponent='1'/>
          <unit kind='second' exponent='-2'/>
        </listOfUnits>
       <unitDefinition>

    will return the string 'metre (exponent = 1, multiplier = 1, scale =
    0) second (exponent = -2, multiplier = 1, scale = 0)' or, if the
    optional parameter 'compact' is given the value 'True,' the string '(1
    metre)^1 (1 second)^-2'.  This method may be useful for printing unit
    information to human users, or in debugging software, or other
    situations.

    Parameter 'ud' is the UnitDefinition object. Parameter 'compact' is
    boolean indicating whether the compact form should be used (defaults
    to false).

    Returns a string expressing the unit definition defined by the given
    UnitDefinition object 'ud'.

    Note: Because this is a static method on a class, the Python language
    interface for libSBML will contain two variants.  One will be the
    expected, normal static method on the class (i.e., a regular
    methodName), and the other will be a standalone top-level function
    with the name ClassName_methodName(). This is merely an artifact of
    how the language interfaces are created in libSBML.  The methods are
    functionally identical.

    Note: Owing to the way that language interfaces are created in
    libSBML, this documentation may show methods that define default
    values for parameters with text that has the form parameter = value.
    This is not to be intepreted as a Python keyword argument; the use of
    a parameter name followed by an equals sign followed by a value is
    only meant to indicate a default value if the argument is not provided
    at all.  It is not a keyword in the Python sense.

    """
    return _libsbml.UnitDefinition_printUnits(ud, compact)

class ListOfUnitDefinitions(ListOf):
    r"""

    A list of UnitDefinition objects.

    The various ListOf___ classes in SBML are merely containers used for
    organizing the main components of an SBML model.  In libSBML's
    implementation, ListOf___ classes are derived from the intermediate
    utility class ListOf, which is not defined by the SBML specifications
    but serves as a useful programmatic construct.  ListOf is itself is in
    turn derived from SBase, which provides all of the various ListOf___
    classes with common features defined by the SBML specification, such
    as 'metaid' attributes and annotations.

    The relationship between the lists and the rest of an SBML model is
    illustrated by the following (for SBML Level 2 Version 4):

      <?xml version="1.0" encoding="UTF-8"?>
      <sbml xmlns="http://www.sbml.org/sbml/level3/version1/core" 
            level="3" version="1">
        <model id="My_Model">
          <listOfFunctionDefinitions>
            <functionDefinition> ... </functionDefinition> 
          </listOfFunctionDefinitions>
          <listOfUnitDefinitions>
            <unitDefinition> ... </unitDefinition> 
          </listOfUnitDefinitions>
          <listOfCompartments>
            <compartment> ... </compartment> 
          </listOfCompartments>
          <listOfSpecies>
            <species> ... </species> 
          </listOfSpecies>
          <listOfParameters>
            <parameter> ... </parameter> 
          </listOfParameters>
          <listOfInitialAssignments>
            <initialAssignment> ... </initialAssignment> 
          </listOfInitialAssignments>
          <listOfRules>
            ... elements of subclasses of Rule ...
          </listOfRules>
          <listOfConstraints>
            <constraint> ... </constraint> 
          </listOfConstraints>
          <listOfReactions>
            <reaction> ... </reaction> 
          </listOfReactions>
          <listOfEvents>
            <event> ... </event> 
          </listOfEvents>
        </model>
      </sbml>

    SBML Level 3 Version 1 has essentially the same structure as  Level
    2 Version 4, depicted above, but SBML Level 3  Version 2 allows
    containers to contain zero or more of the relevant object, instead of
    requiring at least one.  As such, libsbml will write out an
    otherwise-empty ListOf___ element that has any optional attribute set
    (such as 'id' or 'metaid'), that has an optional child (such  as a
    'notes' or 'annotation'), or that has attributes or children set from
    any SBML Level 3 package, whether or not the ListOf___ has  any other
    children.

    Readers may wonder about the motivations for using the ListOf___
    containers in SBML.  A simpler approach in XML might be to place the
    components all directly at the top level of the model definition.  The
    choice made in SBML is to group them within XML elements named after
    ListOfClassname, in part because it helps organize the components.
    More importantly, the fact that the container classes are derived from
    SBase means that software tools can add information about the lists
    themselves into each list container's 'annotation'.

    See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
    ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
    ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ListOfUnitDefinitions self, unsigned int level, unsigned int version) -> ListOfUnitDefinitions
        __init__(ListOfUnitDefinitions self, SBMLNamespaces sbmlns) -> ListOfUnitDefinitions

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfUnitDefinitions(long level, long version)

        Creates a new ListOfUnitDefinitions object.

        The object is constructed such that it is valid for the given SBML
        Level and Version combination.

        Parameter 'level' is the SBML Level.

        Parameter 'version' is the Version within the SBML Level.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfUnitDefinitions(SBMLNamespaces sbmlns)

        Creates a new ListOfUnitDefinitions object.

        The object is constructed such that it is valid for the SBML Level and
        Version combination determined by the SBMLNamespaces object in
        'sbmlns'.

        Parameter 'sbmlns' is an SBMLNamespaces object that is used to
        determine the characteristics of the ListOfUnitDefinitions object to
        be created.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        """
        _libsbml.ListOfUnitDefinitions_swiginit(self, _libsbml.new_ListOfUnitDefinitions(*args))

    def clone(self):
        r"""
        clone(ListOfUnitDefinitions self) -> ListOfUnitDefinitions

        Creates and returns a deep copy of this ListOfUnitDefinitions object.

        Returns the (deep) copy of this ListOfUnitDefinitions object.

        """
        return _libsbml.ListOfUnitDefinitions_clone(self)

    def getItemTypeCode(self):
        r"""
        getItemTypeCode(ListOfUnitDefinitions self) -> int

        Returns the libSBML type code for the objects contained in this ListOf
        (i.e., UnitDefinition objects, if the list is non-empty).

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for objects contained in this list:
        SBML_UNIT_DEFINITION (default).

        See also getElementName(), getPackageName().

        """
        return _libsbml.ListOfUnitDefinitions_getItemTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(ListOfUnitDefinitions self) -> string

        Returns the XML element name of this object.

        For ListOfUnitDefinitions, the XML element name is
        ''listOfUnitDefinitions'.'

        Returns the name of this element, i.e., ''listOfUnitDefinitions'.'

        """
        return _libsbml.ListOfUnitDefinitions_getElementName(self)

    def get(self, *args):
        r"""
        get(ListOfUnitDefinitions self, unsigned int n) -> UnitDefinition
        get(ListOfUnitDefinitions self, unsigned int n) -> UnitDefinition
        get(ListOfUnitDefinitions self, string sid) -> UnitDefinition
        get(ListOfUnitDefinitions self, string sid) -> UnitDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            get(long n)

        Get a UnitDefinition from the ListOfUnitDefinitions.

        Parameter 'n' is the index number of the UnitDefinition to get.

        Returns the nth UnitDefinition in this ListOfUnitDefinitions. If the
        index 'n' is invalid, 'None' is returned.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            get(string sid)

        Get a UnitDefinition from the ListOfUnitDefinitions based on its
        identifier.

        Parameter 'sid' is a string representing the identifier  of the
        UnitDefinition to get.

        Returns UnitDefinition in this ListOfUnitDefinitions with the given
        'sid' or 'None' if no such UnitDefinition exists.

        See also get(), size().

        """
        return _libsbml.ListOfUnitDefinitions_get(self, *args)

    def getElementBySId(self, id):
        r"""
        getElementBySId(ListOfUnitDefinitions self, string id) -> SBase

        Returns the first child element found that has the given 'id' in the
        model-wide SId namespace, or 'None' if no such object is found.

        Note that UnitDefinitions themselves are in the UnitId namespace, not
        the SId namespace, so no UnitDefinition object will be returned from
        this function (and is the reason we override the base
        ListOf::getElementBySId function here).

        Parameter 'id' is string representing the id of the object to find.

        Returns pointer to the first element found with the given 'id'.

        """
        return _libsbml.ListOfUnitDefinitions_getElementBySId(self, id)

    def remove(self, *args):
        r"""
        remove(ListOfUnitDefinitions self, unsigned int n) -> UnitDefinition
        remove(ListOfUnitDefinitions self, string sid) -> UnitDefinition

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            remove(long n)

        Removes the nth item from this ListOfUnitDefinitions items and returns
        a pointer to it.

        The caller owns the returned item and is responsible for deleting it.

        Parameter 'n' is the index of the item to remove.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            remove(string sid)

        Removes item in this ListOfUnitDefinitions items with the given
        identifier.

        The caller owns the returned item and is responsible for deleting it.
        If none of the items in this list have the identifier 'sid', then
        'None' is returned.

        Parameter 'sid' is the identifier of the item to remove.

        Returns the item removed.  As mentioned above, the caller owns the
        returned item.

        """
        return _libsbml.ListOfUnitDefinitions_remove(self, *args)
    __swig_destroy__ = _libsbml.delete_ListOfUnitDefinitions

# Register ListOfUnitDefinitions in _libsbml:
_libsbml.ListOfUnitDefinitions_swigregister(ListOfUnitDefinitions)

class CompartmentType(SBase):
    r"""

    A compartment type in SBML Level 2.

    SBML Level 2 Versions 2-4 provide the compartment type as a grouping
    construct that can be used to establish a relationship between
    multiple Compartment objects.  A CompartmentType object only has an
    identity, and this identity can only be used to indicate that
    particular Compartment objects in the model belong to this type.  This
    may be useful for conveying a modeling intention, such as when a model
    contains many similar compartments, either by their biological
    function or the reactions they carry.  Without a compartment type
    construct, it would be impossible within SBML itself to indicate that
    all of the compartments share an underlying conceptual relationship
    because each SBML compartment must be given a unique and separate
    identity.  A CompartmentType has no mathematical meaning in SBML---it
    has no effect on a model's mathematical interpretation. Simulators and
    other numerical analysis software may ignore CompartmentType
    definitions and references to them in a model.

    There is no mechanism in SBML Level 2 for representing hierarchies of
    compartment types.  One CompartmentType instance cannot be the subtype
    of another CompartmentType instance; SBML provides no means of
    defining such relationships.

    As with other major structures in SBML, CompartmentType has a
    mandatory attribute, 'id', used to give the compartment type an
    identifier.  The identifier must be a text string conforming to the
    identifer syntax permitted in SBML.  CompartmentType also has an
    optional 'name' attribute, of type 'string.'  The 'id' and 'name' must
    be used according to the guidelines described in the SBML
    specification (e.g., Section 3.3 in the Level 2 Version 4
    specification).

    CompartmentType was introduced in SBML Level 2 Version 2.  It is not
    available in SBML Level 1 nor in Level 3.

    See also Compartment, ListOfCompartmentTypes, SpeciesType,
    ListOfSpeciesTypes.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_CompartmentType

    def __init__(self, *args):
        r"""
        __init__(CompartmentType self, unsigned int level, unsigned int version) -> CompartmentType
        __init__(CompartmentType self, SBMLNamespaces sbmlns) -> CompartmentType
        __init__(CompartmentType self, CompartmentType orig) -> CompartmentType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            CompartmentType(long level, long version)

        Creates a new CompartmentType object using the given SBML 'level' and
        'version' values.

        Parameter 'level' is a long integer, the SBML Level to assign to this
        CompartmentType.

        Parameter 'version' is a long integer, the SBML Version to assign to
        this CompartmentType.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            CompartmentType(SBMLNamespaces sbmlns)

        Creates a new CompartmentType object using the given SBMLNamespaces
        object 'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        It is worth emphasizing that although this constructor does not take
        an identifier argument, in SBML Level 2 and beyond, the 'id'
        (identifier) attribute of a CompartmentType object is required to have
        a value.  Thus, callers are cautioned to assign a value after calling
        this constructor.  Setting the identifier can be accomplished using
        the method setId().

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            CompartmentType(CompartmentType orig)

        Copy constructor; creates a copy of this CompartmentType object.

        Parameter 'orig' is the object to copy.

        """
        _libsbml.CompartmentType_swiginit(self, _libsbml.new_CompartmentType(*args))

    def clone(self):
        r"""
        clone(CompartmentType self) -> CompartmentType

        Creates and returns a deep copy of this CompartmentType object.

        Returns the (deep) copy of this CompartmentType object.

        """
        return _libsbml.CompartmentType_clone(self)

    def getId(self):
        r"""
        getId(CompartmentType self) -> string

        Returns the value of the 'id' attribute of this CompartmentType.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is now recommended to use the
        getIdAttribute() function instead.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this CompartmentType.

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.CompartmentType_getId(self)

    def getName(self):
        r"""
        getName(CompartmentType self) -> string

        Returns the value of the 'name' attribute of this CompartmentType
        object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns the name of this SBML object, or the empty string if not set
        or unsettable.

        See also getIdAttribute(), isSetName(), setName(), unsetName().

        """
        return _libsbml.CompartmentType_getName(self)

    def isSetId(self):
        r"""
        isSetId(CompartmentType self) -> bool

        Predicate returning 'True' if this CompartmentType object's 'id'
        attribute is set.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is recommended that callers use
        isSetIdAttribute() instead.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
        isSetIdAttribute().

        """
        return _libsbml.CompartmentType_isSetId(self)

    def isSetName(self):
        r"""
        isSetName(CompartmentType self) -> bool

        Predicate returning 'True' if this CompartmentType object's 'name'
        attribute is set.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns 'True' if the 'name' attribute of this SBML object is set,
        'False' otherwise.

        See also getName(), setName(), unsetName().

        """
        return _libsbml.CompartmentType_isSetName(self)

    def setId(self, sid):
        r"""
        setId(CompartmentType self, string sid) -> int

        Sets the value of the 'id' attribute of this CompartmentType.

        The string 'sid' is copied.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Parameter 'sid' is the string to use as the identifier of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.CompartmentType_setId(self, sid)

    def setName(self, name):
        r"""
        setName(CompartmentType self, string name) -> int

        Sets the value of the 'name' attribute of this CompartmentType.

        The string in 'name' is copied.

        Parameter 'name' is the new name for the SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.CompartmentType_setName(self, name)

    def unsetName(self):
        r"""
        unsetName(CompartmentType self) -> int

        Unsets the value of the 'name' attribute of this CompartmentType
        object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getName(), setName(), isSetName().

        """
        return _libsbml.CompartmentType_unsetName(self)

    def getTypeCode(self):
        r"""
        getTypeCode(CompartmentType self) -> int

        Returns the libSBML type code for this SBML object.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_COMPARTMENT_TYPE
        (default).

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getElementName(), getPackageName().

        """
        return _libsbml.CompartmentType_getTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(CompartmentType self) -> string

        Returns the XML element name of this object

        For CompartmentType, the element name is always ''compartmentType'.'

        Returns the name of this element.

        See also getTypeCode(), getPackageName().

        """
        return _libsbml.CompartmentType_getElementName(self)

    def hasRequiredAttributes(self):
        r"""
        hasRequiredAttributes(CompartmentType self) -> bool

        Predicate returning 'True' if all the required attributes for this
        CompartmentType object have been set.

        The required attributes for a CompartmentType object are:

        * 'id'

        Returns 'True' if the required attributes have been set, 'False'
        otherwise.

        """
        return _libsbml.CompartmentType_hasRequiredAttributes(self)

# Register CompartmentType in _libsbml:
_libsbml.CompartmentType_swigregister(CompartmentType)

class ListOfCompartmentTypes(ListOf):
    r"""

    A list of CompartmentType objects.

    The various ListOf___ classes in SBML are merely containers used for
    organizing the main components of an SBML model.  In libSBML's
    implementation, ListOf___ classes are derived from the intermediate
    utility class ListOf, which is not defined by the SBML specifications
    but serves as a useful programmatic construct.  ListOf is itself is in
    turn derived from SBase, which provides all of the various ListOf___
    classes with common features defined by the SBML specification, such
    as 'metaid' attributes and annotations.

    The relationship between the lists and the rest of an SBML model is
    illustrated by the following (for SBML Level 2 Version 4):

      <?xml version="1.0" encoding="UTF-8"?>
      <sbml xmlns="http://www.sbml.org/sbml/level3/version1/core" 
            level="3" version="1">
        <model id="My_Model">
          <listOfFunctionDefinitions>
            <functionDefinition> ... </functionDefinition> 
          </listOfFunctionDefinitions>
          <listOfUnitDefinitions>
            <unitDefinition> ... </unitDefinition> 
          </listOfUnitDefinitions>
          <listOfCompartments>
            <compartment> ... </compartment> 
          </listOfCompartments>
          <listOfSpecies>
            <species> ... </species> 
          </listOfSpecies>
          <listOfParameters>
            <parameter> ... </parameter> 
          </listOfParameters>
          <listOfInitialAssignments>
            <initialAssignment> ... </initialAssignment> 
          </listOfInitialAssignments>
          <listOfRules>
            ... elements of subclasses of Rule ...
          </listOfRules>
          <listOfConstraints>
            <constraint> ... </constraint> 
          </listOfConstraints>
          <listOfReactions>
            <reaction> ... </reaction> 
          </listOfReactions>
          <listOfEvents>
            <event> ... </event> 
          </listOfEvents>
        </model>
      </sbml>

    SBML Level 3 Version 1 has essentially the same structure as  Level
    2 Version 4, depicted above, but SBML Level 3  Version 2 allows
    containers to contain zero or more of the relevant object, instead of
    requiring at least one.  As such, libsbml will write out an
    otherwise-empty ListOf___ element that has any optional attribute set
    (such as 'id' or 'metaid'), that has an optional child (such  as a
    'notes' or 'annotation'), or that has attributes or children set from
    any SBML Level 3 package, whether or not the ListOf___ has  any other
    children.

    Readers may wonder about the motivations for using the ListOf___
    containers in SBML.  A simpler approach in XML might be to place the
    components all directly at the top level of the model definition.  The
    choice made in SBML is to group them within XML elements named after
    ListOfClassname, in part because it helps organize the components.
    More importantly, the fact that the container classes are derived from
    SBase means that software tools can add information about the lists
    themselves into each list container's 'annotation'.

    See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
    ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
    ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ListOfCompartmentTypes self, unsigned int level, unsigned int version) -> ListOfCompartmentTypes
        __init__(ListOfCompartmentTypes self, SBMLNamespaces sbmlns) -> ListOfCompartmentTypes

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfCompartmentTypes(long level, long version)

        Creates a new ListOfCompartmentTypes object.

        The object is constructed such that it is valid for the given SBML
        Level and Version combination.

        Parameter 'level' is the SBML Level.

        Parameter 'version' is the Version within the SBML Level.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfCompartmentTypes(SBMLNamespaces sbmlns)

        Creates a new ListOfCompartmentTypes object.

        The object is constructed such that it is valid for the SBML Level and
        Version combination determined by the SBMLNamespaces object in
        'sbmlns'.

        Parameter 'sbmlns' is an SBMLNamespaces object that is used to
        determine the characteristics of the ListOfCompartmentTypes object to
        be created.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        """
        _libsbml.ListOfCompartmentTypes_swiginit(self, _libsbml.new_ListOfCompartmentTypes(*args))

    def clone(self):
        r"""
        clone(ListOfCompartmentTypes self) -> ListOfCompartmentTypes

        Creates and returns a deep copy of this ListOfCompartmentTypes object.

        Returns the (deep) copy of this ListOfCompartmentTypes object.

        """
        return _libsbml.ListOfCompartmentTypes_clone(self)

    def getItemTypeCode(self):
        r"""
        getItemTypeCode(ListOfCompartmentTypes self) -> int

        Returns the libSBML type code for the objects contained in this ListOf
        (i.e., CompartmentType objects, if the list is non-empty).

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for the objects contained in this ListOf
        instance: SBML_COMPARTMENT_TYPE (default).

        See also getElementName(), getPackageName().

        """
        return _libsbml.ListOfCompartmentTypes_getItemTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(ListOfCompartmentTypes self) -> string

        Returns the XML element name of this object.

        For ListOfCompartmentTypes, the XML element name is
        ''listOfCompartmentTypes'.'

        Returns the name of this element, i.e., ''listOfCompartmentTypes'.'

        """
        return _libsbml.ListOfCompartmentTypes_getElementName(self)

    def get(self, *args):
        r"""
        get(ListOfCompartmentTypes self, unsigned int n) -> CompartmentType
        get(ListOfCompartmentTypes self, unsigned int n) -> CompartmentType
        get(ListOfCompartmentTypes self, string sid) -> CompartmentType
        get(ListOfCompartmentTypes self, string sid) -> CompartmentType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            get(long n)

        Get a CompartmentType object from the ListOfCompartmentTypes.

        Parameter 'n' is the index number of the CompartmentType object to
        get.

        Returns the nth CompartmentType object in this ListOfCompartmentTypes.
        If the index 'n' is invalid, 'None' is returned.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            get(string sid)

        Get a CompartmentType object from the ListOfCompartmentTypes based on
        its identifier.

        Parameter 'sid' is a string representing the identifier of the
        CompartmentType object to get.

        Returns CompartmentType object in this ListOfCompartmentTypes with the
        given 'sid' or 'None' if no such CompartmentType object exists.

        See also get(), size().

        """
        return _libsbml.ListOfCompartmentTypes_get(self, *args)

    def remove(self, *args):
        r"""
        remove(ListOfCompartmentTypes self, unsigned int n) -> CompartmentType
        remove(ListOfCompartmentTypes self, string sid) -> CompartmentType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            remove(long n)

        Removes the nth item from this ListOfCompartmentTypes items and
        returns a pointer to it.

        The caller owns the returned item and is responsible for deleting it.

        Parameter 'n' is the index of the item to remove.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            remove(string sid)

        Removes item in this ListOfCompartmentTypes items with the given
        identifier.

        The caller owns the returned item and is responsible for deleting it.
        If none of the items in this list have the identifier 'sid', then
        'None' is returned.

        Parameter 'sid' is the identifier of the item to remove.

        Returns the item removed.  As mentioned above, the caller owns the
        returned item.

        """
        return _libsbml.ListOfCompartmentTypes_remove(self, *args)
    __swig_destroy__ = _libsbml.delete_ListOfCompartmentTypes

# Register ListOfCompartmentTypes in _libsbml:
_libsbml.ListOfCompartmentTypes_swigregister(ListOfCompartmentTypes)

class SpeciesType(SBase):
    r"""

    A species type in SBML Level 2.

    The term species type refers to reacting entities independent of
    location.  These include simple ions (e.g., protons, calcium), simple
    molecules (e.g., glucose, ATP), large molecules (e.g., RNA,
    polysaccharides, and proteins), and others.

    SBML Level 2 Versions 2-4 provide an explicit SpeciesType class of
    object to enable Species objects of the same type to be related
    together.  SpeciesType is a conceptual construct; the existence of
    SpeciesType objects in a model has no effect on the model's numerical
    interpretation.  Except for the requirement for uniqueness of
    species/species type combinations located in compartments, simulators
    and other numerical analysis software may ignore SpeciesType
    definitions and references to them in a model.

    There is no mechanism in SBML Level 2 for representing hierarchies of
    species types.  One SpeciesType object cannot be the subtype of
    another SpeciesType object; SBML provides no means of defining such
    relationships.

    As with other major structures in SBML, SpeciesType has a mandatory
    attribute, 'id', used to give the species type an identifier.  The
    identifier must be a text string conforming to the identifer syntax
    permitted in SBML.  SpeciesType also has an optional 'name' attribute,
    of type 'string.'  The 'id' and 'name' must be used according to the
    guidelines described in the SBML specification (e.g., Section 3.3 in
    the Level 2 Version 4 specification).

    SpeciesType was introduced in SBML Level 2 Version 2.  It is not
    available in SBML Level 1 nor in Level 3.

    See also Species, ListOfSpeciesTypes, CompartmentType,
    ListOfCompartmentTypes.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_SpeciesType

    def __init__(self, *args):
        r"""
        __init__(SpeciesType self, unsigned int level, unsigned int version) -> SpeciesType
        __init__(SpeciesType self, SBMLNamespaces sbmlns) -> SpeciesType
        __init__(SpeciesType self, SpeciesType orig) -> SpeciesType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            SpeciesType(long level, long version)

        Creates a new SpeciesType using the given SBML 'level' and 'version'
        values.

        Parameter 'level' is a long integer, the SBML Level to assign to this
        SpeciesType.

        Parameter 'version' is a long integer, the SBML Version to assign to
        this SpeciesType.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            SpeciesType(SBMLNamespaces sbmlns)

        Creates a new SpeciesType using the given SBMLNamespaces object
        'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        It is worth emphasizing that although this constructor does not take
        an identifier argument, in SBML Level 2 and beyond, the 'id'
        (identifier) attribute of a SpeciesType object is required to have a
        value. Thus, callers are cautioned to assign a value after calling
        this constructor.  Setting the identifier can be accomplished using
        the method SBase.setId().

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            SpeciesType(SpeciesType orig)

        Copy constructor; creates a copy of this SpeciesType.

        Parameter 'orig' is the object to copy.

        """
        _libsbml.SpeciesType_swiginit(self, _libsbml.new_SpeciesType(*args))

    def clone(self):
        r"""
        clone(SpeciesType self) -> SpeciesType

        Creates and returns a deep copy of this SpeciesType object.

        Returns the (deep) copy of this SpeciesType object.

        """
        return _libsbml.SpeciesType_clone(self)

    def getId(self):
        r"""
        getId(SpeciesType self) -> string

        Returns the value of the 'id' attribute of this SpeciesType.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is now recommended to use the
        getIdAttribute() function instead.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this SpeciesType.

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.SpeciesType_getId(self)

    def getName(self):
        r"""
        getName(SpeciesType self) -> string

        Returns the value of the 'name' attribute of this SpeciesType object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns the name of this SBML object, or the empty string if not set
        or unsettable.

        See also getIdAttribute(), isSetName(), setName(), unsetName().

        """
        return _libsbml.SpeciesType_getName(self)

    def isSetId(self):
        r"""
        isSetId(SpeciesType self) -> bool

        Predicate returning 'True' if this SpeciesType's 'id' attribute is
        set.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is recommended that callers use
        isSetIdAttribute() instead.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
        isSetIdAttribute().

        """
        return _libsbml.SpeciesType_isSetId(self)

    def isSetName(self):
        r"""
        isSetName(SpeciesType self) -> bool

        Predicate returning 'True' if this SpeciesType's 'name' attribute is
        set.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns 'True' if the 'name' attribute of this SBML object is set,
        'False' otherwise.

        See also getName(), setName(), unsetName().

        """
        return _libsbml.SpeciesType_isSetName(self)

    def setId(self, sid):
        r"""
        setId(SpeciesType self, string sid) -> int

        Sets the value of the 'id' attribute of this SpeciesType.

        The string 'sid' is copied.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Parameter 'sid' is the string to use as the identifier of this object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.SpeciesType_setId(self, sid)

    def setName(self, name):
        r"""
        setName(SpeciesType self, string name) -> int

        Sets the value of the 'name' attribute of this SpeciesType.

        The string in 'name' is copied.

        Parameter 'name' is the new name for the SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.SpeciesType_setName(self, name)

    def unsetName(self):
        r"""
        unsetName(SpeciesType self) -> int

        Unsets the value of the 'name' attribute of this SpeciesType.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getName(), setName(), isSetName().

        """
        return _libsbml.SpeciesType_unsetName(self)

    def getTypeCode(self):
        r"""
        getTypeCode(SpeciesType self) -> int

        Returns the libSBML type code for this SBML object.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_SPECIES_TYPE
        (default).

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getElementName(), getPackageName().

        """
        return _libsbml.SpeciesType_getTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(SpeciesType self) -> string

        Returns the XML element name of this object, which for SpeciesType, is
        always ''compartmentType'.'

        Returns the name of this element, i.e., ''compartmentType'.'

        """
        return _libsbml.SpeciesType_getElementName(self)

    def hasRequiredAttributes(self):
        r"""
        hasRequiredAttributes(SpeciesType self) -> bool

        Predicate returning 'True' if all the required attributes for this
        SpeciesType object have been set.

        The required attributes for a SpeciesType object are:

        * 'id'

        Returns 'True' if the required attributes have been set, 'False'
        otherwise.

        """
        return _libsbml.SpeciesType_hasRequiredAttributes(self)

# Register SpeciesType in _libsbml:
_libsbml.SpeciesType_swigregister(SpeciesType)

class ListOfSpeciesTypes(ListOf):
    r"""

    A list of SpeciesType objects.

    The various ListOf___ classes in SBML are merely containers used for
    organizing the main components of an SBML model.  In libSBML's
    implementation, ListOf___ classes are derived from the intermediate
    utility class ListOf, which is not defined by the SBML specifications
    but serves as a useful programmatic construct.  ListOf is itself is in
    turn derived from SBase, which provides all of the various ListOf___
    classes with common features defined by the SBML specification, such
    as 'metaid' attributes and annotations.

    The relationship between the lists and the rest of an SBML model is
    illustrated by the following (for SBML Level 2 Version 4):

      <?xml version="1.0" encoding="UTF-8"?>
      <sbml xmlns="http://www.sbml.org/sbml/level3/version1/core" 
            level="3" version="1">
        <model id="My_Model">
          <listOfFunctionDefinitions>
            <functionDefinition> ... </functionDefinition> 
          </listOfFunctionDefinitions>
          <listOfUnitDefinitions>
            <unitDefinition> ... </unitDefinition> 
          </listOfUnitDefinitions>
          <listOfCompartments>
            <compartment> ... </compartment> 
          </listOfCompartments>
          <listOfSpecies>
            <species> ... </species> 
          </listOfSpecies>
          <listOfParameters>
            <parameter> ... </parameter> 
          </listOfParameters>
          <listOfInitialAssignments>
            <initialAssignment> ... </initialAssignment> 
          </listOfInitialAssignments>
          <listOfRules>
            ... elements of subclasses of Rule ...
          </listOfRules>
          <listOfConstraints>
            <constraint> ... </constraint> 
          </listOfConstraints>
          <listOfReactions>
            <reaction> ... </reaction> 
          </listOfReactions>
          <listOfEvents>
            <event> ... </event> 
          </listOfEvents>
        </model>
      </sbml>

    SBML Level 3 Version 1 has essentially the same structure as  Level
    2 Version 4, depicted above, but SBML Level 3  Version 2 allows
    containers to contain zero or more of the relevant object, instead of
    requiring at least one.  As such, libsbml will write out an
    otherwise-empty ListOf___ element that has any optional attribute set
    (such as 'id' or 'metaid'), that has an optional child (such  as a
    'notes' or 'annotation'), or that has attributes or children set from
    any SBML Level 3 package, whether or not the ListOf___ has  any other
    children.

    Readers may wonder about the motivations for using the ListOf___
    containers in SBML.  A simpler approach in XML might be to place the
    components all directly at the top level of the model definition.  The
    choice made in SBML is to group them within XML elements named after
    ListOfClassname, in part because it helps organize the components.
    More importantly, the fact that the container classes are derived from
    SBase means that software tools can add information about the lists
    themselves into each list container's 'annotation'.

    See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
    ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
    ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ListOfSpeciesTypes self, unsigned int level, unsigned int version) -> ListOfSpeciesTypes
        __init__(ListOfSpeciesTypes self, SBMLNamespaces sbmlns) -> ListOfSpeciesTypes

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfSpeciesTypes(long level, long version)

        Creates a new ListOfSpeciesTypes object.

        The object is constructed such that it is valid for the given SBML
        Level and Version combination.

        Parameter 'level' is the SBML Level.

        Parameter 'version' is the Version within the SBML Level.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfSpeciesTypes(SBMLNamespaces sbmlns)

        Creates a new ListOfSpeciesTypes object.

        The object is constructed such that it is valid for the SBML Level and
        Version combination determined by the SBMLNamespaces object in
        'sbmlns'.

        Parameter 'sbmlns' is an SBMLNamespaces object that is used to
        determine the characteristics of the ListOfSpeciesTypes object to be
        created.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        """
        _libsbml.ListOfSpeciesTypes_swiginit(self, _libsbml.new_ListOfSpeciesTypes(*args))

    def clone(self):
        r"""
        clone(ListOfSpeciesTypes self) -> ListOfSpeciesTypes

        Creates and returns a deep copy of this ListOfSpeciesTypes object.

        Returns the (deep) copy of this ListOfSpeciesTypes object.

        """
        return _libsbml.ListOfSpeciesTypes_clone(self)

    def getItemTypeCode(self):
        r"""
        getItemTypeCode(ListOfSpeciesTypes self) -> int

        Returns the libSBML type code for the objects contained in this ListOf
        (i.e., SpeciesType objects, if the list is non-empty).

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for objects contained in this list:
        SBML_SPECIES_TYPE (default).

        See also getElementName(), getPackageName().

        """
        return _libsbml.ListOfSpeciesTypes_getItemTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(ListOfSpeciesTypes self) -> string

        Returns the XML element name of this object.

        For ListOfSpeciesTypes, the XML element name is
        ''listOfSpeciesTypes'.'

        Returns the name of this element, i.e., ''listOfSpeciesTypes'.'

        """
        return _libsbml.ListOfSpeciesTypes_getElementName(self)

    def get(self, *args):
        r"""
        get(ListOfSpeciesTypes self, unsigned int n) -> SpeciesType
        get(ListOfSpeciesTypes self, unsigned int n) -> SpeciesType
        get(ListOfSpeciesTypes self, string sid) -> SpeciesType
        get(ListOfSpeciesTypes self, string sid) -> SpeciesType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            get(long n)

        Get a SpeciesType from the ListOfSpeciesTypes.

        Parameter 'n' is the index number of the SpeciesType to get.

        Returns the nth SpeciesType in this ListOfSpeciesTypes. If the index
        'n' is invalid, 'None' is returned.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            get(string sid)

        Get a SpeciesType from the ListOfSpeciesTypes based on its identifier.

        Parameter 'sid' is a string representing the identifier  of the
        SpeciesType to get.

        Returns SpeciesType in this ListOfSpeciesTypes with the given 'sid' or
        'None' if no such SpeciesType exists.

        See also get(), size().

        """
        return _libsbml.ListOfSpeciesTypes_get(self, *args)

    def remove(self, *args):
        r"""
        remove(ListOfSpeciesTypes self, unsigned int n) -> SpeciesType
        remove(ListOfSpeciesTypes self, string sid) -> SpeciesType

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            remove(long n)

        Removes the nth item from this ListOfSpeciesTypes items and returns a
        pointer to it.

        The caller owns the returned item and is responsible for deleting it.

        Parameter 'n' is the index of the item to remove.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            remove(string sid)

        Removes item in this ListOfSpeciesTypes items with the given
        identifier.

        The caller owns the returned item and is responsible for deleting it.
        If none of the items in this list have the identifier 'sid', then
        'None' is returned.

        Parameter 'sid' is the identifier of the item to remove.

        Returns the item removed.  As mentioned above, the caller owns the
        returned item.

        """
        return _libsbml.ListOfSpeciesTypes_remove(self, *args)
    __swig_destroy__ = _libsbml.delete_ListOfSpeciesTypes

# Register ListOfSpeciesTypes in _libsbml:
_libsbml.ListOfSpeciesTypes_swigregister(ListOfSpeciesTypes)

class Compartment(SBase):
    r"""

    An SBML compartment, where species are located.

    A compartment in SBML represents a bounded space in which species are
    located.  Compartments do not necessarily have to correspond to actual
    structures inside or outside of a biological cell.

    It is important to note that although compartments are optional in the
    overall definition of Model, every species in an SBML model must be
    located in a compartment.  This in turn means that if a model defines
    any species, the model must also define at least one compartment.  The
    reason is simply that species represent physical things, and therefore
    must exist somewhere.  Compartments represent the somewhere.

    Compartment has one required attribute, 'id', to give the compartment
    a unique identifier by which other parts of an SBML model definition
    can refer to it.  A compartment can also have an optional 'name'
    attribute of type 'string.'  Identifiers and names must be used
    according to the guidelines described in the SBML specifications.

    Compartment also has an optional attribute 'spatialDimensions' that is
    used to indicate the number of spatial dimensions possessed by the
    compartment.  Most modeling scenarios involve compartments with
    integer values of 'spatialDimensions' of '3' (i.e., a three-
    dimensional compartment, which is to say, a volume), or 2 (a two-
    dimensional compartment, a surface), or '1' (a one-dimensional
    compartment, a line).  In SBML Level 3, the type of this attribute is
    'float,' there are no restrictions on the permitted values of the
    'spatialDimensions' attribute, and there are no default values.  In
    SBML Level 2, the value must be a positive 'integer,' and the default
    value is '3;' the permissible values in SBML Level 2 are '3,' '2,'
    '1,' and '0' (for a point).

    Another optional attribute on Compartment is 'size', representing the
    initial total size of that compartment in the model.  The 'size'
    attribute must be a floating-point value and may represent a volume
    (if the compartment is a three-dimensional one), or an area (if the
    compartment is two-dimensional), or a length (if the compartment is
    one-dimensional). There is no default value of compartment size in
    SBML Level 2 or Level 3.  In particular, a missing 'size' value does
    not imply that the compartment size is 1.  (This is unlike the
    definition of compartment 'volume' in SBML Level 1.)  When the
    compartment's 'spatialDimensions' attribute does not have a value of
    '0,' a missing value of 'size' for a given compartment signifies that
    the value either is unknown, or to be obtained from an external
    source, or determined by an InitialAssignment, AssignmentRule,
    AlgebraicRule or RateRule object elsewhere in the model.  In SBML
    Level 2, there are additional special requirements on the values of
    'size'; we discuss them in a separate section below.

    The units associated with a compartment's 'size' attribute value may
    be set using the optional attribute 'units'.  The rules for setting
    and using compartment size units differ between SBML Level 2 and Level
    3, and are discussed separately below.

    Finally, the Compartment attribute named 'constant' is used to
    indicate whether the compartment's size stays constant after
    simulation begins.  A value of 'True' indicates the compartment's
    'size' cannot be changed by any other construct except
    InitialAssignment; a value of 'False' indicates the compartment's
    'size' can be changed by other constructs in SBML.  In SBML Level 2,
    there is an additional explicit restriction that if
    'spatialDimensions'=''0',' the value cannot be changed by
    InitialAssignment either.  Further, in Level 2, 'constant' is
    optional, and has a default value of 'True.'  In SBML Level 3, there
    is no default value for the 'constant' attribute, and it is required.

    Additional considerations in SBML Level 2
    ======================================================================

    In SBML Level 2, the default units of compartment size, and the kinds
    of units allowed as values of the attribute 'units', interact with the
    number of spatial dimensions of the compartment.  The value of the
    'units' attribute of a Compartment object must be one of the base
    units (see Unit), or the predefined unit identifiers 'volume,' 'area,'
    'length' or 'dimensionless,' or a new unit defined by a UnitDefinition
    object in the enclosing Model, subject to the restrictions detailed in
    the following table:

      +----------------------------+---------------+----------------+-----------------------------------+----------------------------------+
      | Value of spatialDimensions | size allowed? | units allowed? | Allowable kinds of units          | Default value of attribute units |
      +----------------------------+---------------+----------------+-----------------------------------+----------------------------------+
      | 3                          | yes           | yes            | units of volume, or dimensionless | volume                           |
      | 2                          | yes           | yes            | units of area, or dimensionless   | area                             |
      | 1                          | yes           | yes            | units of length, or dimensionless | length                           |
      | 0                          | no            | no             | (no units allowed)                |                                  |
      +----------------------------+---------------+----------------+-----------------------------------+----------------------------------+

    In SBML Level 2, the units of the compartment size, as defined by
    the 'units' attribute or (if 'units' is not set) the default value
    listed in the table above, are used in the following ways when the
    compartment has a 'spatialDimensions' value greater than '0:'

    * The value of the 'units' attribute is used as the units of the
    compartment identifier when the identifier appears as a numerical
    quantity in a mathematical formula expressed in MathML.

    * The 'math' element of an AssignmentRule or InitialAssignment
    referring to this compartment must (in Level 2 Versions 1-3) or should
    (in Level 2 Version 4) have identical units.

    * In RateRule objects that set the rate of change of the compartment's
    size, the units of the rule's 'math' element must (in Level 2
    Versions 1-3) or should (in Level 2 Version 4) be identical to the
    compartment's units (whether defined by the 'units' attribute or by
    taking the  default value from the Model) divided by the default time
    units. (In other words, the units for the rate of change of
    compartment size are compartment size/time units.

    * When a Species is to be treated in terms of concentrations or
    density, the units of the spatial size portion of the concentration
    value (i.e., the denominator in the units formula substance/size) are
    those indicated by the value of the 'units' attribute on the
    compartment in which the species is located. Compartments with
    'spatialDimensions'='0' require special treatment in this framework.
    As implied above, the 'size' attribute must not have a value on an
    SBML Level 2 Compartment object if the 'spatialDimensions' attribute
    has a value of '0.'  An additional related restriction is that the
    'constant' attribute must default to or be set to 'True' if the value
    of the 'spatialDimensions' attribute is '0,' because a zero-
    dimensional compartment cannot ever have a size.

    If a compartment has no size or dimensional units, how should such a
    compartment's identifier be interpreted when it appears in
    mathematical formulas?  The answer is that such a compartment's
    identifier should not appear in mathematical formulas in the first
    place---it has no value, and its value cannot change.  Note also that
    a zero-dimensional compartment is a point, and species located at
    points can only be described in terms of amounts, not spatially-
    dependent measures such as concentration.  Since SBML KineticLaw
    formulas are already in terms of substance/time and not (say)
    concentration/time, volume or other factors in principle are not
    needed for species located in zero-dimensional compartments.

    Finally, in SBML Level 2 Versions 2-4, each compartment in a model may
    optionally be designated as belonging to a particular compartment
    type.  The optional attribute 'compartmentType' is used identify the
    compartment type represented by the Compartment structure. The
    'compartmentType' attribute's value must be the identifier of a
    CompartmentType instance defined in the model.  If the
    'compartmentType' attribute is not present on a particular compartment
    definition, a unique virtual compartment type is assumed for that
    compartment, and no other compartment can belong to that compartment
    type.  The values of 'compartmentType' attributes on compartments have
    no effect on the numerical interpretation of a model.  Simulators and
    other numerical analysis software may ignore 'compartmentType'
    attributes.  The 'compartmentType' attribute and the CompartmentType
    class of objects are not present in SBML Level 3 Core nor in SBML
    Level 1.

    Additional considerations in SBML Level 3
    ======================================================================

    One difference between SBML Level 3 and lower Levels of SBML is that
    there are no restrictions on the permissible values of the
    'spatialDimensions' attribute, and there is no default value defined
    for the attribute.  The value of 'spatialDimensions' does not have to
    be an integer, either; this is to allow for the possibility of
    representing structures with fractal dimensions.

    The number of spatial dimensions possessed by a compartment cannot
    enter into mathematical formulas, and therefore cannot directly alter
    the numerical interpretation of a model.  However, the value of
    'spatialDimensions' does affect the interpretation of the units
    associated with a compartment's size.  Specifically, the value of
    'spatialDimensions' is used to select among the Model attributes
    'volumeUnits', 'areaUnits' and 'lengthUnits' when a Compartment
    structure does not define a value for its 'units' attribute.

    The 'units' attribute may be left unspecified for a given compartment
    in a model; in that case, the compartment inherits the unit of
    measurement specified by one of the attributes on the enclosing Model
    object instance.  The applicable attribute on Model depends on the
    value of the compartment's 'spatialDimensions' attribute; the
    relationship is shown in the table below.  If the Model object does
    not define the relevant attribute ('volumeUnits', 'areaUnits' or
    'lengthUnits') for a given 'spatialDimensions' value, the unit
    associated with that Compartment object's size is undefined.  If a
    given Compartment's 'units' are left unset and  the
    'spatialDimensions' either has a value other than '1,' '2,' or  '3' or
    is left unset itself (as it has no default value), then no unit can be
    chosen from among the Model's 'volumeUnits', 'areaUnits' or
    'lengthUnits' attributes (even if the Model instance provides values
    for those attributes), because there is no basis to select between
    them. Leaving the units of compartments' sizes undefined in an SBML
    model does not render the model invalid; however, as a matter of best
    practice, we strongly recommend that all models specify the units of
    measurement for all compartment sizes.

      +----------------------------------------+-------------------------------------------------+-----------------------------------+
      | Value of attribute 'spatialDimensions' | Attribute of Model used for inheriting the unit | Recommended candidate units       |
      +----------------------------------------+-------------------------------------------------+-----------------------------------+
      | 3                                      | "volumeUnits"                                 | units of volume, or dimensionless |
      | 2                                      | "areaUnits"                                   | units of area, or dimensionless   |
      | 1                                      | "lengthUnits"                                 | units of length, or dimensionless |
      | other                                  | no units inherited                              | no specific recommendations       |
      +----------------------------------------+-------------------------------------------------+-----------------------------------+

    The unit of measurement associated with a compartment's size, as
    defined by the 'units' attribute or (if 'units' is not set) the
    inherited value from Model according to the table above, is used in
    the following ways:

    * When the identifier of the compartment appears as a numerical
    quantity in a mathematical formula expressed in MathML, it represents
    the size of the compartment, and the unit associated with the size is
    the value of the 'units' attribute.

    * When a Species is to be treated in terms of concentrations or
    density, the unit associated with the spatial size portion of the
    concentration value (i.e., the denominator in the formula amount/size)
    is specified by the value of the 'units' attribute on the compartment
    in which the species is located.

    * The 'math' elements of AssignmentRule, InitialAssignment and
    EventAssignment objects setting the value of the compartment size
    should all have the same units as the unit associated with the
    compartment's size.

    * In a RateRule object that defines a rate of change for a
    compartment's size, the unit of the rule's 'math' element should be
    identical to the compartment's 'units' attribute divided by the model-
    wide unit of time.  (In other words, {unit of compartment size}/{unit
    of time}.)

    Other aspects of Compartment
    ======================================================================

    In SBML Level 1 and Level 2, Compartment has an optional attribute
    named 'outside', whose value can be the identifier of another
    Compartment object defined in the enclosing Model object.  Doing so
    means that the other compartment contains it or is outside of it.
    This enables the representation of simple topological relationships
    between compartments, for those simulation systems that can make use
    of the information (e.g., for drawing simple diagrams of
    compartments).  It is worth noting that in SBML, there is no
    relationship between compartment sizes when compartment positioning is
    expressed using the 'outside' attribute.  The size of a given
    compartment does not in any sense include the sizes of other
    compartments having it as the value of their 'outside' attributes.  In
    other words, if a compartment B has the identifier of compartment A as
    its 'outside' attribute value, the size of A does not include the size
    of B.  The compartment sizes are separate.

    In Level 2, there are two restrictions on the 'outside' attribute.
    First, because a compartment with 'spatialDimensions' of '0' has no
    size, such a compartment cannot act as the container of any other
    compartment except compartments that also have 'spatialDimensions'
    values of '0.'  Second, the directed graph formed by representing
    Compartment structures as vertexes and the 'outside' attribute values
    as edges must be acyclic.  The latter condition is imposed to prevent
    a compartment from being contained inside itself.  In the absence of a
    value for 'outside', compartment definitions in SBML Level 2 do not
    have any implied spatial relationships between each other.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_Compartment

    def __init__(self, *args):
        r"""
        __init__(Compartment self, unsigned int level, unsigned int version) -> Compartment
        __init__(Compartment self, SBMLNamespaces sbmlns) -> Compartment
        __init__(Compartment self, Compartment orig) -> Compartment

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            Compartment(long level, long version)

        Creates a new Compartment object using the given SBML 'level' and
        'version' values.

        Parameter 'level' is a long integer, the SBML Level to assign to this
        Compartment.

        Parameter 'version' is a long integer, the SBML Version to assign to
        this Compartment.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            Compartment(SBMLNamespaces sbmlns)

        Creates a new Compartment object using the given SBMLNamespaces object
        'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        It is worth emphasizing that although this constructor does not take
        an identifier argument, in SBML Level 2 and beyond, the 'id'
        (identifier) attribute of a Compartment object is required to have a
        value.  Thus, callers are cautioned to assign a value after calling
        this constructor.  Setting the identifier can be accomplished using
        the method setId().

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            Compartment(Compartment orig)

        Copy constructor.

        This creates a copy of a Compartment object.

        Parameter 'orig' is the Compartment instance to copy.

        """
        _libsbml.Compartment_swiginit(self, _libsbml.new_Compartment(*args))

    def clone(self):
        r"""
        clone(Compartment self) -> Compartment

        Creates and returns a deep copy of this Compartment object.

        Returns the (deep) copy of this Compartment object.

        """
        return _libsbml.Compartment_clone(self)

    def initDefaults(self):
        r"""
        initDefaults(Compartment self)

        Initializes the fields of this Compartment object to 'typical' default
        values.

        The SBML Compartment component has slightly different aspects and
        default attribute values in different SBML Levels and Versions. This
        method sets the values to certain common defaults, based mostly on
        what they are in SBML Level 2.  Specifically:

        * Sets attribute 'spatialDimensions' to '3'

        * Sets attribute 'constant' to 'True'

        * (Applies to Level 1 models only) Sets attribute 'volume' to '1.0'

        * (Applies to Level 3 models only) Sets attribute 'units' to
        'litre'

        """
        return _libsbml.Compartment_initDefaults(self)

    def getId(self):
        r"""
        getId(Compartment self) -> string

        Returns the value of the 'id' attribute of this Compartment.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is now recommended to use the
        getIdAttribute() function instead.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this Compartment.

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.Compartment_getId(self)

    def getName(self):
        r"""
        getName(Compartment self) -> string

        Returns the value of the 'name' attribute of this Compartment object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns the name of this SBML object, or the empty string if not set
        or unsettable.

        See also getIdAttribute(), isSetName(), setName(), unsetName().

        """
        return _libsbml.Compartment_getName(self)

    def getCompartmentType(self):
        r"""
        getCompartmentType(Compartment self) -> string

        Get the value of the 'compartmentType' attribute of this Compartment
        object.

        Returns the value of the 'compartmentType' attribute of this
        Compartment object as a string.

        Note: The 'compartmentType' attribute is only available in SBML Level
        2 Versions 2-4.

        See also isSetCompartmentType(), setCompartmentType(),
        unsetCompartmentType().

        """
        return _libsbml.Compartment_getCompartmentType(self)

    def getSpatialDimensions(self):
        r"""
        getSpatialDimensions(Compartment self) -> unsigned int

        Get the number of spatial dimensions of this Compartment object.

        Returns the value of the 'spatialDimensions' attribute of this
        Compartment object as a long integereger.

        Note: In SBML Level 3, the data type of the 'spatialDimensions'
        attribute is 'float,' whereas in Level 2, it is 'integer.'  To avoid
        backward compatibility issues, libSBML provides two separate methods
        for obtaining the value as either an integer or a type 'float,' for
        models where it is relevant.

        See also getSpatialDimensionsAsDouble(), setSpatialDimensions(),
        isSetSpatialDimensions(), unsetSpatialDimensions().

        """
        return _libsbml.Compartment_getSpatialDimensions(self)

    def getSpatialDimensionsAsDouble(self):
        r"""
        getSpatialDimensionsAsDouble(Compartment self) -> double

        Get the number of spatial dimensions of this Compartment object, as a
        double.

        Returns the value of the 'spatialDimensions' attribute of this
        Compartment object as a double, or 'NaN' if this model is not in SBML
        Level 3 format.

        Note: In SBML Level 3, the data type of the 'spatialDimensions'
        attribute is 'float,' whereas in Level 2, it is 'integer.'  To avoid
        backward compatibility issues, libSBML provides two separate methods
        for obtaining the value as either an integer or a type 'float,' for
        models where it is relevant.

        See also getSpatialDimensions(), setSpatialDimensions(),
        isSetSpatialDimensions(), unsetSpatialDimensions().

        """
        return _libsbml.Compartment_getSpatialDimensionsAsDouble(self)

    def getSize(self):
        r"""
        getSize(Compartment self) -> double

        Get the size of this Compartment object.

        In SBML Level 1, compartments are always three-dimensional constructs
        and only have volumes, whereas in SBML Level 2 and higher,
        compartments may be other than three-dimensional, and therefore the
        'volume' attribute is named 'size' in Level 2 and above.  LibSBML
        provides both getSize() and getVolume() for easier support of
        different SBML Levels.

        Returns the value of the 'size' attribute ('volume' in Level 1) of
        this Compartment object as a floating-point number.

        Note: This method is identical to getVolume().

        See also getVolume(), isSetSize(), setSize(), unsetSize().

        """
        return _libsbml.Compartment_getSize(self)

    def getVolume(self):
        r"""
        getVolume(Compartment self) -> double

        Get the volume of this Compartment object.

        In SBML Level 1, compartments are always three-dimensional constructs
        and only have volumes, whereas in SBML Level 2 and higher,
        compartments may be other than three-dimensional, and therefore the
        'volume' attribute is named 'size' in Level 2 and above.  LibSBML
        provides both getSize() and getVolume() for easier support of
        different SBML Levels.

        Returns the value of the 'volume' attribute ('size' in Level 2) of
        this Compartment object, as a floating-point number.

        Note: The attribute 'volume' only exists by that name in SBML Level 1.
        In Level 2 and above, the equivalent attribute is named 'size'.  In
        SBML Level 1, a compartment's volume has a default value ('1.0)' and
        therefore methods such as isSetVolume() will always return 'True' for
        a Level 1 model.  In Level 2, a compartment's size (the equivalent of
        SBML Level 1's 'volume') is optional and has no default value, and
        therefore may or may not be set.

        Note: This method is identical to getSize().

        See also getSize(), isSetVolume(), setVolume(), unsetVolume().

        """
        return _libsbml.Compartment_getVolume(self)

    def getUnits(self):
        r"""
        getUnits(Compartment self) -> string

        Get the units of this Compartment object's size.

        The value of an SBML compartment's 'units' attribute establishes the
        unit of measurement associated with the compartment's size.

        Returns the value of the 'units' attribute of this Compartment object,
        as a string.  An empty string indicates that no units have been
        assigned to the value of the size.

        Note: There is an important distinction to be made between no units
        assigned, and assuming a value without units has any specific unit
        such as dimensionless.  In SBML, default units are never attributed to
        numbers, and numbers without units are not automatically assumed to
        have the unit dimensionless.  Please consult the relevant SBML
        specification document for a more in-depth explanation of this topic
        and the SBML unit system.

        See also isSetUnits(), setUnits(), unsetUnits().

        """
        return _libsbml.Compartment_getUnits(self)

    def getOutside(self):
        r"""
        getOutside(Compartment self) -> string

        Get the identifier, if any, of the Compartment object that is
        designated as being outside of this one.

        Returns the value of the 'outside' attribute of this Compartment
        object.

        Note: The 'outside' attribute is defined in SBML Level 1 and Level 2,
        but does not exist in SBML Level 3.

        See also isSetOutside(), setOutside(), unsetOutside().

        """
        return _libsbml.Compartment_getOutside(self)

    def getConstant(self):
        r"""
        getConstant(Compartment self) -> bool

        Get the value of the 'constant' attribute of this Compartment object.

        Returns 'True' if this Compartment object's size is flagged as being
        constant, 'False' otherwise.

        See also isSetConstant(), setConstant().

        """
        return _libsbml.Compartment_getConstant(self)

    def isSetId(self):
        r"""
        isSetId(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's 'id' attribute
        is set.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is recommended that callers use
        isSetIdAttribute() instead.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
        isSetIdAttribute().

        """
        return _libsbml.Compartment_isSetId(self)

    def isSetName(self):
        r"""
        isSetName(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's 'name'
        attribute is set.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns 'True' if the 'name' attribute of this SBML object is set,
        'False' otherwise.

        See also getName(), setName(), unsetName().

        """
        return _libsbml.Compartment_isSetName(self)

    def isSetCompartmentType(self):
        r"""
        isSetCompartmentType(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's
        'compartmentType' attribute is set.

        Returns 'True' if the 'compartmentType' attribute of this Compartment
        is set, 'False' otherwise.

        Note: The 'compartmentType' attribute is only available in SBML Level
        2 Versions 2-4.

        See also setCompartmentType(), getCompartmentType(),
        unsetCompartmentType().

        """
        return _libsbml.Compartment_isSetCompartmentType(self)

    def isSetSize(self):
        r"""
        isSetSize(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's 'size'
        attribute is set.

        This method is similar but not identical to isSetVolume().  The latter
        should be used in the context of SBML Level 1 models instead of
        isSetSize() because isSetVolume() performs extra processing to take
        into account the difference in default values between SBML Levels 1
        and 2.

        Returns 'True' if the 'size' attribute ('volume' in Level 2) of this
        Compartment object is set, 'False' otherwise.

        See also isSetVolume(), setSize(), getSize(), unsetSize().

        """
        return _libsbml.Compartment_isSetSize(self)

    def isSetVolume(self):
        r"""
        isSetVolume(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's 'volume'
        attribute is set.

        This method is similar but not identical to isSetSize().  The latter
        should not be used in the context of SBML Level 1 models because the
        present method performs extra processing to take into account the
        difference in default values between SBML Levels 1 and 2.

        Returns 'True' if the 'volume' attribute ('size' in Level 2 and above)
        of this Compartment object is set, 'False' otherwise.

        Note: The attribute 'volume' only exists by that name in SBML Level 1.
        In Level 2 and above, the equivalent attribute is named 'size'.  In
        SBML Level 1, a compartment's volume has a default value ('1.0)' and
        therefore methods such as isSetVolume() will always return 'True' for
        a Level 1 model.  In Level 2, a compartment's size (the equivalent of
        SBML Level 1's 'volume') is optional and has no default value, and
        therefore may or may not be set.

        See also isSetSize(), getVolume(), setVolume(), unsetVolume().

        """
        return _libsbml.Compartment_isSetVolume(self)

    def isSetUnits(self):
        r"""
        isSetUnits(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's 'units'
        attribute is set.

        Returns 'True' if the 'units' attribute of this Compartment object is
        set, 'False' otherwise.

        Note: There is an important distinction to be made between no units
        assigned, and assuming a value without units has any specific unit
        such as dimensionless.  In SBML, default units are never attributed to
        numbers, and numbers without units are not automatically assumed to
        have the unit dimensionless.  Please consult the relevant SBML
        specification document for a more in-depth explanation of this topic
        and the SBML unit system.

        See also setUnits(), getUnits(), unsetUnits().

        """
        return _libsbml.Compartment_isSetUnits(self)

    def isSetOutside(self):
        r"""
        isSetOutside(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's 'outside'
        attribute is set.

        Returns 'True' if the 'outside' attribute of this Compartment object
        is set, 'False' otherwise.

        Note: The 'outside' attribute is defined in SBML Level 1 and Level 2,
        but does not exist in SBML Level 3.

        See also getOutside(), setOutside(), unsetOutside().

        """
        return _libsbml.Compartment_isSetOutside(self)

    def isSetSpatialDimensions(self):
        r"""
        isSetSpatialDimensions(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's
        'spatialDimensions' attribute is set.

        Returns 'True' if the 'spatialDimensions' attribute of this
        Compartment object is set, 'False' otherwise.

        See also getSpatialDimensions(), setSpatialDimensions(),
        unsetSpatialDimensions().

        """
        return _libsbml.Compartment_isSetSpatialDimensions(self)

    def isSetConstant(self):
        r"""
        isSetConstant(Compartment self) -> bool

        Predicate returning 'True' if this Compartment object's 'constant'
        attribute is set.

        Returns 'True' if the 'constant' attribute of this Compartment object
        is set, 'False' otherwise.

        See also getConstant(), setConstant().

        """
        return _libsbml.Compartment_isSetConstant(self)

    def setId(self, sid):
        r"""
        setId(Compartment self, string sid) -> int

        Sets the value of the 'id' attribute of this Compartment object.

        The string 'sid' is copied.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Parameter 'sid' is the string to use as the identifier of this
        Compartment object. If the string is 'None,' this method will return
        LIBSBML_INVALID_ATTRIBUTE_VALUE.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        See also getId(), unsetId(), isSetId().

        """
        return _libsbml.Compartment_setId(self, sid)

    def setName(self, name):
        r"""
        setName(Compartment self, string name) -> int

        Sets the value of the 'name' attribute of this Compartment object.

        The string in 'name' is copied.

        Parameter 'name' is the new name for the SBML object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        """
        return _libsbml.Compartment_setName(self, name)

    def setCompartmentType(self, sid):
        r"""
        setCompartmentType(Compartment self, string sid) -> int

        Sets the 'compartmentType' attribute of this Compartment object.

        Parameter 'sid' is the identifier of a CompartmentType object defined
        elsewhere in this Model. If the string is 'None,' this method will
        return LIBSBML_INVALID_ATTRIBUTE_VALUE.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        Note: The 'compartmentType' attribute is only available in SBML Level
        2 Versions 2-4.

        See also isSetCompartmentType(), getCompartmentType(),
        unsetCompartmentType().

        """
        return _libsbml.Compartment_setCompartmentType(self, sid)

    def setSpatialDimensions(self, *args):
        r"""
        setSpatialDimensions(Compartment self, unsigned int value) -> int
        setSpatialDimensions(Compartment self, double value) -> int

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            setSpatialDimensions(long value)

        Sets the 'spatialDimensions' attribute of this Compartment object.

        Parameter 'value' is a long integereger indicating the number of
        dimensions of this compartment.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getSpatialDimensions(), isSetSpatialDimensions(),
        unsetSpatialDimensions().

        ______________________________________________________________________
        Method variant with the following signature:

            setSpatialDimensions(double value)

        Sets the 'spatialDimensions' attribute of this Compartment object as a
        double.

        Parameter 'value' is a double indicating the number of dimensions of
        this compartment.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also getSpatialDimensions(), isSetSpatialDimensions(),
        unsetSpatialDimensions().

        """
        return _libsbml.Compartment_setSpatialDimensions(self, *args)

    def setSize(self, value):
        r"""
        setSize(Compartment self, double value) -> int

        Sets the 'size' attribute (or 'volume' in SBML Level 1) of this
        Compartment object.

        Parameter 'value' is a 'float' representing the size of this
        compartment instance in whatever units are in effect for the
        compartment.

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        Note: This method is identical to setVolume().

        See also setVolume(), getSize(), isSetSize(), unsetSize().

        """
        return _libsbml.Compartment_setSize(self, value)

    def setVolume(self, value):
        r"""
        setVolume(Compartment self, double value) -> int

        Sets the 'volume' attribute (or 'size' in SBML Level 2) of this
        Compartment object.

        This method is identical to setSize() and is provided for
        compatibility between SBML Level 1 and higher Levels of SBML.

        Parameter 'value' is a 'float' representing the volume of this
        compartment instance in whatever units are in effect for the
        compartment.

        Returns integer value indicating success/failure of the function.
        This particular function only does one thing irrespective of user
        input or  object state, and thus will only return a single value:

        * LIBSBML_OPERATION_SUCCESS

        Note: The attribute 'volume' only exists by that name in SBML Level 1.
        In Level 2 and above, the equivalent attribute is named 'size'.  In
        SBML Level 1, a compartment's volume has a default value ('1.0)' and
        therefore methods such as isSetVolume() will always return 'True' for
        a Level 1 model.  In Level 2, a compartment's size (the equivalent of
        SBML Level 1's 'volume') is optional and has no default value, and
        therefore may or may not be set.

        See also setSize(), getVolume(), isSetVolume(), unsetVolume().

        """
        return _libsbml.Compartment_setVolume(self, value)

    def setUnits(self, sid):
        r"""
        setUnits(Compartment self, string sid) -> int

        Sets the 'units' attribute of this Compartment object.

        Parameter 'sid' is the identifier of the defined units to use.  If
        'sid' is 'None,' then this method will return
        LIBSBML_INVALID_ATTRIBUTE_VALUE.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        See also isSetUnits(), getUnits(), unsetUnits().

        """
        return _libsbml.Compartment_setUnits(self, sid)

    def setOutside(self, sid):
        r"""
        setOutside(Compartment self, string sid) -> int

        Sets the 'outside' attribute of this Compartment object.

        Parameter 'sid' is the identifier of a compartment that encloses this
        one. If 'sid' is 'None,' then this method will return
        LIBSBML_INVALID_ATTRIBUTE_VALUE.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_INVALID_ATTRIBUTE_VALUE

        Note: The 'outside' attribute is defined in SBML Level 1 and Level 2,
        but does not exist in SBML Level 3.

        See also isSetOutside(), getOutside(), unsetOutside().

        """
        return _libsbml.Compartment_setOutside(self, sid)

    def setConstant(self, value):
        r"""
        setConstant(Compartment self, bool value) -> int

        Sets the value of the 'constant' attribute of this Compartment object.

        Parameter 'value' is a boolean indicating whether the size/volume of
        this compartment should be considered constant ('True)' or variable
        ('False).'

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        See also isSetConstant(), getConstant().

        """
        return _libsbml.Compartment_setConstant(self, value)

    def renameSIdRefs(self, oldid, newid):
        r"""
        renameSIdRefs(Compartment self, string oldid, string newid)

        Replaces all uses of a given 'SIdRef' type attribute value with
        another value.

        In SBML, object identifiers are of a data type called SId. In SBML
        Level 3, an explicit data type called SIdRef was introduced for
        attribute values that refer to SId values; in previous Levels of SBML,
        this data type did not exist and attributes were simply described to
        as 'referring to an identifier', but the effective data type was the
        same as SIdRef in Level 3.  These and other methods of libSBML refer
        to the type SIdRef for all Levels of SBML, even if the corresponding
        SBML specification did not explicitly name the data type.

        This method works by looking at all attributes and (if appropriate)
        mathematical formulas in MathML content, comparing the referenced
        identifiers to the value of 'oldid'.  If any matches are found, the
        matching values are replaced with 'newid'.  The method does not
        descend into child elements.

        Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
        identifier.

        """
        return _libsbml.Compartment_renameSIdRefs(self, oldid, newid)

    def renameUnitSIdRefs(self, oldid, newid):
        r"""
        renameUnitSIdRefs(Compartment self, string oldid, string newid)

        Replaces all uses of a given 'UnitSIdRef' type attribute value with
        another value.

        In SBML, unit definitions have identifiers of type UnitSId.  In SBML
        Level 3, an explicit data type called UnitSIdRef was introduced for
        attribute values that refer to UnitSId values; in previous Levels of
        SBML, this data type did not exist and attributes were simply
        described to as 'referring to a unit identifier', but the effective
        data type was the same as UnitSIdRef in Level 3.  These and other
        methods of libSBML refer to the type UnitSIdRef for all Levels of
        SBML, even if the corresponding SBML specification did not explicitly
        name the data type.

        This method works by looking at all unit identifier attribute values
        (including, if appropriate, inside mathematical formulas), comparing
        the referenced unit identifiers to the value of 'oldid'.  If any
        matches are found, the matching values are replaced with 'newid'.  The
        method does not descend into child elements.

        Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
        identifier.

        """
        return _libsbml.Compartment_renameUnitSIdRefs(self, oldid, newid)

    def unsetName(self):
        r"""
        unsetName(Compartment self) -> int

        Unsets the value of the 'name' attribute of this Compartment object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also getName(), setName(), isSetName().

        """
        return _libsbml.Compartment_unsetName(self)

    def unsetCompartmentType(self):
        r"""
        unsetCompartmentType(Compartment self) -> int

        Unsets the value of the 'compartmentType' attribute of this
        Compartment object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        Note: The 'compartmentType' attribute is only available in SBML Level
        2 Versions 2-4.

        See also setCompartmentType(), isSetCompartmentType(),
        getCompartmentType().

        """
        return _libsbml.Compartment_unsetCompartmentType(self)

    def unsetConstant(self):
        r"""
        unsetConstant(Compartment self) -> int

        Unsets the value of the 'constant' attribute of this Compartment
        object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also isSetConstant(), setConstant(), getConstant().

        """
        return _libsbml.Compartment_unsetConstant(self)

    def unsetSize(self):
        r"""
        unsetSize(Compartment self) -> int

        Unsets the value of the 'size' attribute of this Compartment object.

        In SBML Level 1, a compartment's volume has a default value ('1.0)'
        and therefore should always be set.  Calling this method on a Level 1
        model resets the value to '1.0' rather than actually unsetting it.  In
        Level 2, a compartment's 'size' is optional with no default value, and
        unsetting it will result in the compartment having no defined size.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        Note: This method is identical to unsetVolume().

        See also unsetVolume(), getSize(), isSetSize(), setSize().

        """
        return _libsbml.Compartment_unsetSize(self)

    def unsetVolume(self):
        r"""
        unsetVolume(Compartment self) -> int

        Unsets the value of the 'volume' attribute of this Compartment object.

        This method is identical to unsetSize().  Please refer to that
        method's documentation for more information about its behavior.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        Note: The attribute 'volume' only exists by that name in SBML Level 1.
        In Level 2 and above, the equivalent attribute is named 'size'.  In
        SBML Level 1, a compartment's volume has a default value ('1.0)' and
        therefore methods such as isSetVolume() will always return 'True' for
        a Level 1 model.  In Level 2, a compartment's size (the equivalent of
        SBML Level 1's 'volume') is optional and has no default value, and
        therefore may or may not be set.

        See also unsetSize(), getVolume(), setVolume(), isSetVolume().

        """
        return _libsbml.Compartment_unsetVolume(self)

    def unsetUnits(self):
        r"""
        unsetUnits(Compartment self) -> int

        Unsets the value of the 'units' attribute of this Compartment object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        See also isSetUnits(), setUnits(), getUnits().

        """
        return _libsbml.Compartment_unsetUnits(self)

    def unsetOutside(self):
        r"""
        unsetOutside(Compartment self) -> int

        Unsets the value of the 'outside' attribute of this Compartment
        object.

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        Note: The 'outside' attribute is defined in SBML Level 1 and Level 2,
        but does not exist in SBML Level 3.

        See also isSetOutside(), getOutside(), setOutside().

        """
        return _libsbml.Compartment_unsetOutside(self)

    def unsetSpatialDimensions(self):
        r"""
        unsetSpatialDimensions(Compartment self) -> int

        Unsets the value of the 'spatialDimensions' attribute of this
        Compartment object.

        In SBML Levels prior to Level 3, compartments must always have a value
        for the number of dimensions.  Consequently, calling this method on a
        model of SBML Level 1-2 will result in a return value of
        LIBSBML_UNEXPECTED_ATTRIBUTE

        Returns integer value indicating success/failure of the function.
        The possible values returned by this function are:

        * LIBSBML_OPERATION_SUCCESS

        * LIBSBML_OPERATION_FAILED

        * LIBSBML_UNEXPECTED_ATTRIBUTE

        Note: This function is only valid for SBML Level 3.

        See also getSpatialDimensions(), isSetSpatialDimensions(),
        setSpatialDimensions().

        """
        return _libsbml.Compartment_unsetSpatialDimensions(self)

    def getDerivedUnitDefinition(self, *args):
        r"""
        getDerivedUnitDefinition(Compartment self) -> UnitDefinition
        getDerivedUnitDefinition(Compartment self) -> UnitDefinition

        Constructs and returns a UnitDefinition that corresponds to the units
        of this Compartment object's designated size.

        Compartments in SBML have an attribute ('units') for declaring the
        units of measurement intended for the value of the compartment's size.
        In the absence of a value given for this attribute, the units are
        inherited from values either defined on the enclosing Model (in SBML
        Level 3) or in defaults (in SBML Level 2).  This method returns a
        UnitDefinition object based on how this compartment's units are
        interpreted according to the relevant SBML guidelines, or it returns
        'None' if no units have been declared and no defaults are defined by
        the relevant SBML specification.

        Note that unit declarations for Compartment objects  are specified in
        terms of the identifier of a unit, but this method returns an object ,
        not a unit identifier.  It does this by constructing an appropriate
        UnitDefinition object.  For SBML Level 2 models, it will do this even
        when the value of the 'units' attribute is one of the special SBML
        Level 2 unit identifiers ''substance',' ''volume',' ''area','
        ''length'' or ''time'.'  Callers may find this useful in conjunction
        with the helper methods provided by the UnitDefinition class for
        comparing different UnitDefinition objects.

        Returns a UnitDefinition that expresses the units of this Compartment
        object, or 'None' if one cannot be constructed.

        Note: The libSBML system for unit analysis depends on the model as a
        whole.  In cases where the Compartment object has not yet been added
        to a model, or the model itself is incomplete, unit analysis is not
        possible, and consequently this method will return 'None.'

        See also isSetUnits(), getUnits().

        """
        return _libsbml.Compartment_getDerivedUnitDefinition(self, *args)

    def getTypeCode(self):
        r"""
        getTypeCode(Compartment self) -> int

        Returns the libSBML type code for this SBML object.

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for this object: SBML_COMPARTMENT
        (default).

        WARNING:

        The specific integer values of the possible type codes may be reused
        by different libSBML plug-ins for SBML Level 3. packages,  To fully
        identify the correct code, it is necessary to invoke both
        getPackageName() and getTypeCode() (or  ListOf.getItemTypeCode()).

        See also getElementName(), getPackageName().

        """
        return _libsbml.Compartment_getTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(Compartment self) -> string

        Returns the XML element name of this object

        For Compartment, the XML element name is always ''compartment'.'

        Returns the name of this element.

        """
        return _libsbml.Compartment_getElementName(self)

    def hasRequiredAttributes(self):
        r"""
        hasRequiredAttributes(Compartment self) -> bool

        Predicate returning 'True' if all the required attributes for this
        Compartment object have been set.

        The required attributes for a Compartment object are:

        * 'id' (or 'name' in SBML Level 1)

        * 'constant' (in SBML Level 3 only)

        Returns 'True' if the required attributes have been set, 'False'
        otherwise.

        """
        return _libsbml.Compartment_hasRequiredAttributes(self)

# Register Compartment in _libsbml:
_libsbml.Compartment_swigregister(Compartment)

class ListOfCompartments(ListOf):
    r"""

    A list of Compartment objects.

    The various ListOf___ classes in SBML are merely containers used for
    organizing the main components of an SBML model.  In libSBML's
    implementation, ListOf___ classes are derived from the intermediate
    utility class ListOf, which is not defined by the SBML specifications
    but serves as a useful programmatic construct.  ListOf is itself is in
    turn derived from SBase, which provides all of the various ListOf___
    classes with common features defined by the SBML specification, such
    as 'metaid' attributes and annotations.

    The relationship between the lists and the rest of an SBML model is
    illustrated by the following (for SBML Level 2 Version 4):

      <?xml version="1.0" encoding="UTF-8"?>
      <sbml xmlns="http://www.sbml.org/sbml/level3/version1/core" 
            level="3" version="1">
        <model id="My_Model">
          <listOfFunctionDefinitions>
            <functionDefinition> ... </functionDefinition> 
          </listOfFunctionDefinitions>
          <listOfUnitDefinitions>
            <unitDefinition> ... </unitDefinition> 
          </listOfUnitDefinitions>
          <listOfCompartments>
            <compartment> ... </compartment> 
          </listOfCompartments>
          <listOfSpecies>
            <species> ... </species> 
          </listOfSpecies>
          <listOfParameters>
            <parameter> ... </parameter> 
          </listOfParameters>
          <listOfInitialAssignments>
            <initialAssignment> ... </initialAssignment> 
          </listOfInitialAssignments>
          <listOfRules>
            ... elements of subclasses of Rule ...
          </listOfRules>
          <listOfConstraints>
            <constraint> ... </constraint> 
          </listOfConstraints>
          <listOfReactions>
            <reaction> ... </reaction> 
          </listOfReactions>
          <listOfEvents>
            <event> ... </event> 
          </listOfEvents>
        </model>
      </sbml>

    SBML Level 3 Version 1 has essentially the same structure as  Level
    2 Version 4, depicted above, but SBML Level 3  Version 2 allows
    containers to contain zero or more of the relevant object, instead of
    requiring at least one.  As such, libsbml will write out an
    otherwise-empty ListOf___ element that has any optional attribute set
    (such as 'id' or 'metaid'), that has an optional child (such  as a
    'notes' or 'annotation'), or that has attributes or children set from
    any SBML Level 3 package, whether or not the ListOf___ has  any other
    children.

    Readers may wonder about the motivations for using the ListOf___
    containers in SBML.  A simpler approach in XML might be to place the
    components all directly at the top level of the model definition.  The
    choice made in SBML is to group them within XML elements named after
    ListOfClassname, in part because it helps organize the components.
    More importantly, the fact that the container classes are derived from
    SBase means that software tools can add information about the lists
    themselves into each list container's 'annotation'.

    See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
    ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
    ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
    ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ListOfCompartments self, unsigned int level, unsigned int version) -> ListOfCompartments
        __init__(ListOfCompartments self, SBMLNamespaces sbmlns) -> ListOfCompartments

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfCompartments(long level, long version)

        Creates a new ListOfCompartments object.

        The object is constructed such that it is valid for the given SBML
        Level and Version combination.

        Parameter 'level' is the SBML Level.

        Parameter 'version' is the Version within the SBML Level.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            ListOfCompartments(SBMLNamespaces sbmlns)

        Creates a new ListOfCompartments object.

        The object is constructed such that it is valid for the SBML Level and
        Version combination determined by the SBMLNamespaces object in
        'sbmlns'.

        Parameter 'sbmlns' is an SBMLNamespaces object that is used to
        determine the characteristics of the ListOfCompartments object to be
        created.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        """
        _libsbml.ListOfCompartments_swiginit(self, _libsbml.new_ListOfCompartments(*args))

    def clone(self):
        r"""
        clone(ListOfCompartments self) -> ListOfCompartments

        Creates and returns a deep copy of this ListOfCompartments object.

        Returns the (deep) copy of this ListOfCompartments object.

        """
        return _libsbml.ListOfCompartments_clone(self)

    def getItemTypeCode(self):
        r"""
        getItemTypeCode(ListOfCompartments self) -> int

        Returns the libSBML type code for the objects contained in this ListOf
        (i.e., Compartment objects, if the list is non-empty).

        LibSBML attaches an identifying code to every kind of SBML object.
        These are integer constants known as SBML type codes.  The names of
        all the codes begin with the characters SBML_. In the Python language
        interface for libSBML, the type codes are defined as static integer
        constants in the interface class 'libsbml'.  Note that different Level
        3 package plug-ins may use overlapping type codes; to identify the
        package to which a given object belongs, call the
        SBase.getPackageName()

        method on the object.

        The exception to this is lists:  all SBML-style list elements have the
        type  SBML_LIST_OF, regardless of what package they  are from.

        Returns the SBML type code for the objects contained in this ListOf
        instance: SBML_COMPARTMENT (default).

        See also getElementName(), getPackageName().

        """
        return _libsbml.ListOfCompartments_getItemTypeCode(self)

    def getElementName(self):
        r"""
        getElementName(ListOfCompartments self) -> string

        Returns the XML element name of this object.

        For ListOfCompartments, the XML element name is always
        ''listOfCompartments'.'

        Returns the name of this element.

        """
        return _libsbml.ListOfCompartments_getElementName(self)

    def get(self, *args):
        r"""
        get(ListOfCompartments self, unsigned int n) -> Compartment
        get(ListOfCompartments self, unsigned int n) -> Compartment
        get(ListOfCompartments self, string sid) -> Compartment
        get(ListOfCompartments self, string sid) -> Compartment

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            get(long n)

        Get a Compartment object from the ListOfCompartments.

        Parameter 'n' is the index number of the Compartment object to get.

        Returns the nth Compartment object in this ListOfCompartments. If the
        index 'n' is invalid, 'None' is returned.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            get(string sid)

        Get a Compartment object from the ListOfCompartments based on its
        identifier.

        Parameter 'sid' is a string representing the identifier of the
        Compartment object to get.

        Returns Compartment object in this ListOfCompartments with the given
        'sid' or 'None' if no such Compartment object exists.

        See also get(), size().

        """
        return _libsbml.ListOfCompartments_get(self, *args)

    def remove(self, *args):
        r"""
        remove(ListOfCompartments self, unsigned int n) -> Compartment
        remove(ListOfCompartments self, string sid) -> Compartment

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            remove(long n)

        Removes the nth item from this ListOfCompartments items and returns a
        pointer to it.

        The caller owns the returned item and is responsible for deleting it.

        Parameter 'n' is the index of the item to remove.

        See also size().

        ______________________________________________________________________
        Method variant with the following signature:

            remove(string sid)

        Removes item in this ListOfCompartments items with the given
        identifier.

        The caller owns the returned item and is responsible for deleting it.
        If none of the items in this list have the identifier 'sid', then
        'None' is returned.

        Parameter 'sid' is the identifier of the item to remove.

        Returns the item removed.  As mentioned above, the caller owns the
        returned item.

        """
        return _libsbml.ListOfCompartments_remove(self, *args)
    __swig_destroy__ = _libsbml.delete_ListOfCompartments

# Register ListOfCompartments in _libsbml:
_libsbml.ListOfCompartments_swigregister(ListOfCompartments)

class Species(SBase):
    r"""

    An SBML species - a pool of entities.

    A species in SBML refers to a pool of entities that (a) are considered
    indistinguishable from each other for the purposes of the model, (b)
    participate in reactions, and (c) are located in a specific
    compartment.  The SBML Species object class is intended to represent
    these pools.

    As with other major constructs in SBML, Species has a mandatory
    attribute, 'id', used to give the species type an identifier in the
    model.  The identifier must be a text string conforming to the
    identifer syntax permitted in SBML.  Species also has an optional
    'name' attribute, of type 'string.'  The 'id' and 'name' must be used
    according to the guidelines described in the SBML specifications.

    The required attribute 'compartment' is used to identify the
    compartment in which the species is located.  The attribute's value
    must be the identifier of an existing Compartment object.  It is
    important to note that there is no default value for the 'compartment'
    attribute on Species; every species in an SBML model must be assigned
    a compartment explicitly.  (This also implies that every model with
    one or more Species objects must define at least one Compartment
    object.)

    The initial amount and concentration of a species
    ======================================================================

    The optional attributes 'initialAmount' and 'initialConcentration',
    both having a data type of 'float,' can be used to set the initial
    quantity of the species in the compartment where the species is
    located. These attributes are mutually exclusive; i.e., only one can
    have a value on any given instance of a Species object.  Missing
    'initialAmount' and 'initialConcentration' values implies that their
    values either are unknown, or to be obtained from an external source,
    or determined by an InitialAssignment or other SBML construct
    elsewhere in the model.

    A species' initial quantity in SBML is set by the 'initialAmount' or
    'initialConcentration' attribute exactly once.  If the 'constant'
    attribute is 'True,' then the value of the species' quantity is fixed
    and cannot be changed except by an InitialAssignment.  These methods
    differ in that the 'initialAmount' and 'initialConcentration'
    attributes can only be used to set the species quantity to a literal
    floating-point number, whereas the use of an InitialAssignment object
    allows the value to be set using an arbitrary mathematical expression
    (which, thanks to MathML's expressiveness, may evaluate to a rational
    number).  If the species' 'constant' attribute is 'False,' the
    species' quantity value may be overridden by an InitialAssignment or
    changed by AssignmentRule or AlgebraicRule, and in addition, for t >
    0, it may also be changed by a RateRule, Event objects, and as a
    result of being a reactant or product in one or more Reaction objects.
    (However, some constructs are mutually exclusive; see the SBML
    specifications for the precise details.)  It is not an error to define
    'initialAmount' or 'initialConcentration' on a species and also
    redefine the value using an InitialAssignment, but the 'initialAmount'
    or 'initialConcentration' setting in that case is ignored.  The SBML
    specifications provide additional information about the semantics of
    assignments, rules and values for simulation time t <= 0.

    SBML Level 2 additionally stipulates that in cases where a species'
    compartment has a 'spatialDimensions' value of '0' (zero), the species
    cannot have a value for 'initialConcentration' because the concepts of
    concentration and density break down when a container has zero
    dimensions.

    The units of a species' amount or concentration
    ======================================================================

    When the attribute 'initialAmount' is set, the unit of measurement
    associated with the value of 'initialAmount' is specified by the
    Species attribute 'substanceUnits'.  When the 'initialConcentration'
    attribute is set, the unit of measurement associated with this
    concentration value is {unit of amount} divided by {unit of size},
    where the {unit of amount} is specified by the Species
    'substanceUnits' attribute, and the {unit of size} is specified by the
    'units' attribute of the Compartment object in which the species is
    located.  Note that in either case, a unit of amount is involved and
    determined by the 'substanceUnits' attribute.  Note these two
    attributes alone do not determine the units of the species when the
    species identifier appears in a mathematical expression; that aspect
    is determined by the attribute 'hasOnlySubstanceUnits' discussed
    below.

    In SBML Level 3, if the 'substanceUnits' attribute is not set on a
    given Species object instance, then the unit of amount for that
    species is inherited from the 'substanceUnits' attribute on the
    enclosing Model object instance.  If that attribute on Model is not
    set either, then the unit associated with the species' quantity is
    undefined.

    In SBML Level 2, if the 'substanceUnits' attribute is not set on a
    given Species object instance, then the unit of amount for that
    species is taken from the predefined SBML unit identifier
    ''substance'.'  The value assigned to 'substanceUnits' must be chosen
    from one of the following possibilities: one of the base unit
    identifiers defined in SBML, the built-in unit identifier
    ''substance',' or the identifier of a new unit defined in the list of
    unit definitions in the enclosing Model object.  The chosen units for
    'substanceUnits' must be be ''dimensionless',' ''mole',' ''item','
    ''kilogram',' ''gram',' or units derived from these.

    As noted at the beginning of this section, simply setting
    'initialAmount' or 'initialConcentration' alone does not determine
    whether a species identifier represents an amount or a concentration
    when it appears elsewhere in an SBML model.  The role of the attribute
    'hasOnlySubstanceUnits' is to indicate whether the units of the
    species, when the species identifier appears in mathematical formulas,
    are intended to be concentration or amount.  The attribute takes on a
    boolean value.  In SBML Level 3, the attribute has no default value
    and must always be set in a model; in SBML Level 2, it has a default
    value of 'False.'

    The units of the species are used in the following ways:

    * When the species' identifier appears in a MathML formula, it
    represents the species' quantity, and the unit of measurement
    associated with the quantity is as described above.

    * The 'math' elements of AssignmentRule, InitialAssignment and
    EventAssignment objects referring to this species should all have the
    same units as the unit of measurement associated with the species
    quantity.

    * In a RateRule object that defines the rate of change of the species'
    quantity, the unit associated with the rule's 'math' element should be
    equal to the unit of the species' quantity divided by the model-wide
    unit of time; in other words, {unit of species quantity}/{unit of
    time}.

    The 'constant' and 'boundaryCondition' attributes
    ======================================================================

    The Species object class has two boolean attributes named 'constant'
    and 'boundaryCondition', used to indicate whether and how the quantity
    of that species can vary during a simulation.  In SBML Level 2 they
    are optional; in SBML Level 3 they are mandatory.  The following table
    shows how to interpret the combined values of these attributes.

      +----------------+-------------------------+-----------------------------------+-----------------------------+----------------------------------------------------------------+
      | constant value | boundaryCondition value | Can have assignment or rate rule? | Can be reactant or product? | Species' quantity can be changed by                            |
      +----------------+-------------------------+-----------------------------------+-----------------------------+----------------------------------------------------------------+
      | true           | true                    | no                                | yes                         | (never changes)                                                |
      | false          | true                    | yes                               | yes                         | rules and events                                               |
      | true           | false                   | no                                | no                          | (never changes)                                                |
      | false          | false                   | yes                               | yes                         | reactions or rules (but not both at the same time), and events |
      +----------------+-------------------------+-----------------------------------+-----------------------------+----------------------------------------------------------------+

    By default, when a species is a product or reactant of one or more
    reactions, its quantity is determined by those reactions.  In SBML, it
    is possible to indicate that a given species' quantity is not
    determined by the set of reactions even when that species occurs as a
    product or reactant; i.e., the species is on the boundary of the
    reaction system, and its quantity is not determined by the reactions.
    The boolean attribute 'boundaryCondition' can be used to indicate
    this.  A value of 'False' indicates that the species is part of the
    reaction system.  In SBML Level 2, the attribute has a default value
    of 'False,' while in SBML Level 3, it has no default.

    The 'constant' attribute indicates whether the species' quantity can
    be changed at all, regardless of whether by reactions, rules, or
    constructs other than InitialAssignment.  A value of 'False' indicates
    that the species' quantity can be changed.  (This is also a common
    value because the purpose of most simulations is precisely to
    calculate changes in species quantities.)  In SBML Level 2, the
    attribute has a default value of 'False,' while in SBML Level 3, it
    has no default.  Note that the initial quantity of a species can be
    set by an InitialAssignment irrespective of the value of the
    'constant' attribute.

    In practice, a 'boundaryCondition' value of 'True' means a
    differential equation derived from the reaction definitions should not
    be generated for the species.  However, the species' quantity may
    still be changed by AssignmentRule, RateRule, AlgebraicRule, Event,
    and InitialAssignment constructs if its 'constant' attribute is
    'False.'  Conversely, if the species' 'constant' attribute is 'True,'
    then its value cannot be changed by anything except InitialAssignment.

    A species having 'boundaryCondition'='False' and 'constant'='False'
    can appear as a product and/or reactant of one or more reactions in
    the model.  If the species is a reactant or product of a reaction, it
    must not also appear as the target of any AssignmentRule or RateRule
    object in the model.  If instead the species has 'boundaryCondition'=
    'False' and 'constant'='True,' then it cannot appear as a reactant or
    product, or as the target of any AssignmentRule, RateRule or
    EventAssignment object in the model.

    Finally, it is worth clarifying that while the constant and
    boundaryCondition attributes restrict whether and how the species
    amount changes, the same is not true of a species' concentration. In
    SBML, the concentration of a species is a quantity that depends on the
    size of the compartment in which it is located. A compartment's size
    may change, and therefore, so can the concentration of a species even
    if the amount of the species remains unchanged. A species'
    concentration  may therefore vary even if the Species object's
    constant attribute is  set to 'True' in a model.

    The conversionFactor attribute in SBML Level 3
    ======================================================================

    In SBML Level 3, Species has an additional optional attribute,
    'conversionFactor', that defines a conversion factor that applies to a
    particular species.  The value must be the identifier of a Parameter
    object instance defined in the model.  That Parameter object must be a
    constant, meaning its 'constant' attribute must be set to 'True.' If a
    given Species object definition defines a value for its
    'conversionFactor' attribute, it takes precedence over any factor
    defined by the Model object's 'conversionFactor' attribute.

    The unit of measurement associated with a species' quantity can be
    different from the unit of extent of reactions in the model.  SBML
    Level 3 avoids implicit unit conversions by providing an explicit way
    to indicate any unit conversion that might be required.  The use of a
    conversion factor in computing the effects of reactions on a species'
    quantity is explained in detail in the SBML Level 3 specification
    document.  Because the value of the 'conversionFactor' attribute is
    the identifier of a Parameter object, and because parameters can have
    units attached to them, the transformation from reaction extent units
    to species units can be completely specified using this approach.

    Note that the unit conversion factor is only applied when calculating
    the effect of a reaction on a species.  It is not used in any rules or
    other SBML constructs that affect the species, and it is also not used
    when the value of the species is referenced in a mathematical
    expression.

    The speciesType attribute in SBML Level 2 Versions 2-4
    ======================================================================

    In SBML Level 2 Versions 2-4, each species in a model may optionally
    be designated as belonging to a particular species type. The optional
    attribute 'speciesType' is used to identify the species type of the
    chemical entities that make up the pool represented by the Species
    objects.  The attribute's value must be the identifier of an existing
    SpeciesType object in the model.  If the 'speciesType' attribute is
    not present on a particular species definition, it means the pool
    contains chemical entities of a type unique to that pool; in effect, a
    virtual species type is assumed for that species, and no other species
    can belong to that species type.  The value of 'speciesType'
    attributes on species have no effect on the numerical interpretation
    of a model; simulators and other numerical analysis software may
    ignore 'speciesType' attributes.

    There can be only one species of a given species type in any given
    compartment of a model.  More specifically, for all Species objects
    having a value for the 'speciesType' attribute, the pair <center>
    ('speciesType' attribute value, 'compartment' attribute value)
    </center>

    must be unique across the set of all Species object in a model.

    The spatialSizeUnits attribute in SBML Level 2 Versions 1-2
    ======================================================================

    In versions of SBML Level 2 before Version 3, the class Species
    included an attribute called 'spatialSizeUnits', which allowed
    explicitly setting the units of size for initial concentration.
    LibSBML retains this attribute for compatibility with older
    definitions of Level 2, but its use is strongly discouraged because
    many software tools do no properly interpret this unit declaration and
    it is incompatible with all SBML specifications after Level 2 Version
    3.

    Additional considerations for interpreting the numerical value of a
    species
    ======================================================================

    Species are unique in SBML in that they have a kind of duality: a
    species identifier may stand for either substance amount (meaning, a
    count of the number of individual entities) or a concentration or
    density (meaning, amount divided by a compartment size).  The previous
    sections explain the meaning of a species identifier when it is
    referenced in a mathematical formula or in rules or other SBML
    constructs; however, it remains to specify what happens to a species
    when the compartment in which it is located changes in size.

    When a species definition has a 'hasOnlySubstanceUnits' attribute
    value of 'False' and the size of the compartment in which the species
    is located changes, the default in SBML is to assume that it is the
    concentration that must be updated to account for the size change.
    This follows from the principle that, all other things held constant,
    if a compartment simply changes in size, the size change does not in
    itself cause an increase or decrease in the number of entities of any
    species in that compartment.  In a sense, the default is that the
    amount of a species is preserved across compartment size changes.
    Upon such size changes, the value of the concentration or density must
    be recalculated from the simple relationship concentration = amount /
    size if the value of the concentration is needed (for example, if the
    species identifier appears in a mathematical formula or is otherwise
    referenced in an SBML construct).  There is one exception: if the
    species' quantity is determined by an AssignmentRule, RateRule,
    AlgebraicRule, or an EventAssignment and the species has a
    'hasOnlySubstanceUnits' attribute value of 'False,' it means that the
    concentration is assigned by the rule or event; in that case, the
    amount must be calculated when the compartment size changes.  (Events
    also require additional care in this situation, because an event with
    multiple assignments could conceivably reassign both a species
    quantity and a compartment size simultaneously.  Please refer to the
    SBML specifications for the details.)

    Note that the above only matters if a species has a
    'hasOnlySubstanceUnits' attribute value of 'False,' meaning that the
    species identifier refers to a concentration wherever the identifier
    appears in a mathematical formula.  If instead the attribute's value
    is 'True,' then the identifier of the species always stands for an
    amount wherever it appears in a mathematical formula or is referenced
    by an SBML construct.  In that case, there is never a question about
    whether an assignment or event is meant to affect the amount or
    concentration: it is always the amount.

    A particularly confusing situation can occur when the species has
    'constant' attribute value of 'True' in combination with a
    'hasOnlySubstanceUnits' attribute value of 'False.'  Suppose this
    species is given a value for 'initialConcentration'.  Does a
    'constant' value of 'True' mean that the concentration is held
    constant if the compartment size changes?  No; it is still the amount
    that is kept constant across a compartment size change.  The fact that
    the species was initialized using a concentration value is irrelevant.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libsbml.delete_Species

    def __init__(self, *args):
        r"""
        __init__(Species self, unsigned int level, unsigned int version) -> Species
        __init__(Species self, SBMLNamespaces sbmlns) -> Species
        __init__(Species self, Species orig) -> Species

        This method has multiple variants; they differ in the arguments  they
        accept.  Each variant is described separately below.

        ______________________________________________________________________
        Method variant with the following signature:

            Species(long level, long version)

        Creates a new Species using the given SBML 'level' and 'version'
        values.

        Parameter 'level' is a long integer, the SBML Level to assign to this
        Species.

        Parameter 'version' is a long integer, the SBML Version to assign to
        this Species.

        Throws SBMLConstructorException: Thrown if the given 'level' and
        'version' combination are invalid or if this object is incompatible
        with the given level and version.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            Species(SBMLNamespaces sbmlns)

        Creates a new Species using the given SBMLNamespaces object 'sbmlns'.

        The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
        information.  It is used to communicate the SBML Level, Version, and
        (in Level 3) packages used in addition to SBML Level 3 Core.  A common
        approach to using libSBML's SBMLNamespaces facilities is to create an
        SBMLNamespaces object somewhere in a program once, then hand that
        object as needed to object constructors that accept SBMLNamespaces as
        arguments.

        It is worth emphasizing that although this constructor does not take
        an identifier argument, in SBML Level 2 and beyond, the 'id'
        (identifier) attribute of a Species is required to have a value. Thus,
        callers are cautioned to assign a value after calling this
        constructor.  Setting the identifier can be accomplished using the
        method Species.setId().

        Parameter 'sbmlns' is an SBMLNamespaces object.

        Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
        inconsistent or incompatible with this object.

        Note: Attempting to add an object to an SBMLDocument having a
        different combination of SBML Level, Version and XML namespaces than
        the object itself will result in an error at the time a caller
        attempts to make the addition.  A parent object must have compatible
        Level, Version and XML namespaces.  (Strictly speaking, a parent may
        also have more XML namespaces than a child, but the reverse is not
        permitted.)  The restriction is necessary to ensure that an SBML model
        has a consistent overall structure.  This requires callers to manage
        their objects carefully, but the benefit is increased flexibility in
        how models can be created by permitting callers to create objects
        bottom-up if desired.  In situations where objects are not yet
        attached to parents (e.g., SBMLDocument), knowledge of the intented
        SBML Level and Version help libSBML determine such things as whether
        it is valid to assign a particular value to an attribute.

        ______________________________________________________________________
        Method variant with the following signature:

            Species(Species orig)

        Copy constructor; creates a copy of this Species object.

        Parameter 'orig' is the object to copy.

        """
        _libsbml.Species_swiginit(self, _libsbml.new_Species(*args))

    def clone(self):
        r"""
        clone(Species self) -> Species

        Creates and returns a deep copy of this Species object.

        Returns the (deep) copy of this Species object.

        """
        return _libsbml.Species_clone(self)

    def initDefaults(self):
        r"""
        initDefaults(Species self)

        Initializes the fields of this Species object to 'typical' defaults
        values.

        The SBML Species component has slightly different aspects and default
        attribute values in different SBML Levels and Versions. This method
        sets the values to certain common defaults, based mostly on what they
        are in SBML Level 2.  Specifically:

        * Sets 'boundaryCondition' to 'False'

        * Sets 'constant' to 'False'

        * sets 'hasOnlySubstanceUnits' to 'False'

        * (Applies to Level 3 models only) Sets attribute 'substanceUnits'
        to 'mole'

        """
        return _libsbml.Species_initDefaults(self)

    def getId(self):
        r"""
        getId(Species self) -> string

        Returns the value of the 'id' attribute of this Species.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is now recommended to use the
        getIdAttribute() function instead.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns the id of this Species.

        See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
        unsetIdAttribute().

        """
        return _libsbml.Species_getId(self)

    def getName(self):
        r"""
        getName(Species self) -> string

        Returns the value of the 'name' attribute of this Species object.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns the name of this SBML object, or the empty string if not set
        or unsettable.

        See also getIdAttribute(), isSetName(), setName(), unsetName().

        """
        return _libsbml.Species_getName(self)

    def getSpeciesType(self):
        r"""
        getSpeciesType(Species self) -> string

        Get the type of this Species object object.

        Returns the value of the 'speciesType' attribute of this Species as a
        string.

        Note: The 'speciesType' attribute is only available in SBML Level 2
        Versions 2-4.

        """
        return _libsbml.Species_getSpeciesType(self)

    def getCompartment(self):
        r"""
        getCompartment(Species self) -> string

        Get the compartment in which this species is located.

        The compartment is designated by its identifier.

        Returns the value of the 'compartment' attribute of this Species
        object, as a string.

        """
        return _libsbml.Species_getCompartment(self)

    def getInitialAmount(self):
        r"""
        getInitialAmount(Species self) -> double

        Get the value of the 'initialAmount' attribute.

        Returns the initialAmount of this Species, as a floating point number.

        """
        return _libsbml.Species_getInitialAmount(self)

    def getInitialConcentration(self):
        r"""
        getInitialConcentration(Species self) -> double

        Get the value of the 'initialConcentration' attribute.

        Returns the initialConcentration of this Species,, as a floating point
        number.

        Note: The attribute 'initialConcentration' is only available in SBML
        Level 2 and 3.  It does not exist on Species in Level 1.

        """
        return _libsbml.Species_getInitialConcentration(self)

    def getSubstanceUnits(self):
        r"""
        getSubstanceUnits(Species self) -> string

        Get the value of the 'substanceUnits' attribute.

        Returns the value of the 'substanceUnits' attribute of this Species,
        as a string.  An empty string indicates that no units have been
        assigned.

        Note: There is an important distinction to be made between no units
        assigned, and assuming a value without units has any specific unit
        such as dimensionless.  In SBML, default units are never attributed to
        numbers, and numbers without units are not automatically assumed to
        have the unit dimensionless.  Please consult the relevant SBML
        specification document for a more in-depth explanation of this topic
        and the SBML unit system.

        See also isSetSubstanceUnits(), setSubstanceUnits().

        """
        return _libsbml.Species_getSubstanceUnits(self)

    def getSpatialSizeUnits(self):
        r"""
        getSpatialSizeUnits(Species self) -> string

        Get the value of the 'spatialSizeUnits' attribute.

        Returns the value of the 'spatialSizeUnits' attribute of this Species
        object, as a string.

        WARNING:

        In versions of SBML Level 2 before Version 3, the class Species
        included an attribute called 'spatialSizeUnits', which allowed
        explicitly setting the units of size for initial concentration.  This
        attribute was removed in SBML Level 2 Version 3.  LibSBML retains this
        attribute for compatibility with older definitions of Level 2, but its
        use is strongly discouraged because it is incompatible with levels and
        versions of SBML beyond Level 2 Version 2.

        """
        return _libsbml.Species_getSpatialSizeUnits(self)

    def getUnits(self):
        r"""
        getUnits(Species self) -> string

        Get the value of the 'units' attribute.

        Returns the units of this Species (L1 only).

        Note: The 'units' attribute is defined only in SBML Level 1.  In SBML
        Level 2 and Level 3, it has been replaced by a combination of
        'substanceUnits' and the units of the Compartment object in which a
        species is located.  In SBML Level 2 Versions 1-2, an additional
        attribute 'spatialSizeUnits' helps determine the units of the species
        quantity, but this attribute was removed in later versions of SBML
        Level 2.

        """
        return _libsbml.Species_getUnits(self)

    def getHasOnlySubstanceUnits(self):
        r"""
        getHasOnlySubstanceUnits(Species self) -> bool

        Get the value of the 'hasOnlySubstanceUnits' attribute.

        Returns 'True' if this Species' 'hasOnlySubstanceUnits' attribute
        value is 'True,' 'False' otherwise.

        Note: The 'hasOnlySubstanceUnits' attribute does not exist in SBML
        Level 1.

        """
        return _libsbml.Species_getHasOnlySubstanceUnits(self)

    def getBoundaryCondition(self):
        r"""
        getBoundaryCondition(Species self) -> bool

        Get the value of the 'boundaryCondition' attribute.

        Returns 'True' if this Species' 'boundaryCondition' attribute value is
        'True,' 'False' otherwise.

        """
        return _libsbml.Species_getBoundaryCondition(self)

    def getCharge(self):
        r"""
        getCharge(Species self) -> int

        Get the value of the 'charge' attribute.

        Returns the charge of this Species object.

        Note: Beginning in SBML Level 2 Version 2, the 'charge' attribute on
        Species is deprecated and in SBML Level 3 it does not exist at all.
        Its use strongly discouraged.  Its presence is considered a misfeature
        in earlier definitions of SBML because its implications for the
        mathematics of a model were never defined, and in any case, no known
        modeling system ever used it.  Instead, models take account of charge
        values directly in their definitions of species by (for example)
        having separate species identities for the charged and uncharged
        versions of the same species.  This allows the condition to affect
        model mathematics directly.  LibSBML retains this method for easier
        compatibility with SBML Level 1.

        """
        return _libsbml.Species_getCharge(self)

    def getConstant(self):
        r"""
        getConstant(Species self) -> bool

        Get the value of the 'constant' attribute.

        Returns 'True' if this Species's 'constant' attribute value is 'True,'
        'False' otherwise.

        Note: The attribute 'constant' is only available in SBML Levels 2 and
        3.  It does not exist on Species in Level 1.

        """
        return _libsbml.Species_getConstant(self)

    def getConversionFactor(self):
        r"""
        getConversionFactor(Species self) -> string

        Get the value of the 'conversionFactor' attribute.

        Returns the conversionFactor of this Species, as a string.

        Note: The 'conversionFactor' attribute was introduced in SBML Level 3.
        It does not exist on Species in SBML Levels 1 and 2.

        """
        return _libsbml.Species_getConversionFactor(self)

    def isSetId(self):
        r"""
        isSetId(Species self) -> bool

        Predicate returning 'True' if this Species object's 'id' attribute is
        set.

        The identifier given by an object's 'id' attribute value is used to
        identify the object within the SBML model definition. Other objects
        can refer to the component using this identifier.  The data type of
        'id' is always SId or a type derived from that, such as UnitSId,
        depending on the object in  question.  All data types are defined as
        follows:

          letter ::= 'a'..'z','A'..'Z'
          digit  ::= '0'..'9'
          idChar ::= letter | digit | '_'
          SId    ::= ( letter | '_' ) idChar*

        The characters ( and ) are used for grouping, the character * 'zero or
        more times', and the character | indicates logical 'or'.  The equality
        of SBML identifiers is determined by an exact character sequence
        match; i.e., comparisons must be performed in a case-sensitive manner.
        This applies to all uses of SId, SIdRef, and derived types.

        Users need to be aware of some important API issues that are the
        result of the history of SBML and libSBML.  Prior to SBML Level 3
        Version 2, SBML defined 'id' and 'name' attributes on only a subset of
        SBML objects.  To simplify the work of programmers, libSBML's API
        provided get, set, check, and unset on the SBase object class itself
        instead of on individual subobject classes. This made the get/set/etc.
        methods uniformly available on all objects in the libSBML API.
        LibSBML simply returned empty strings or otherwise did not act when
        the methods were applied to SBML objects that were not defined by the
        SBML specification to have 'id' or 'name' attributes.  Additional
        complications arose with the rule and assignment objects:
        InitialAssignment, EventAssignment, AssignmentRule, and RateRule.  In
        early versions of SBML, the rule object hierarchy was different, and
        in addition, then as now, they possess different attributes:
        'variable' (for the rules and event assignments), 'symbol' (for
        initial assignments), or neither (for algebraic rules).  Prior to SBML
        Level 3 Version 2, getId() would always return an empty string, and
        isSetId() would always return 'False' for objects of these classes.

        With the addition of 'id' and 'name' attributes on SBase in Level 3
        Version 2, it became necessary to introduce a new way to interact with
        the attributes more consistently in libSBML to avoid breaking backward
        compatibility in the behavior of the original 'id' methods.  For this
        reason, libSBML provides four functions (getIdAttribute(),
        setIdAttribute(), isSetIdAttribute(), and unsetIdAttribute()) that
        always act on the actual 'id' attribute inherited from SBase,
        regardless of the object's type.  These new methods should be used
        instead of the older getId()/setId()/etc. methods unless the old
        behavior is somehow necessary.  Regardless of the Level and Version of
        the SBML, these functions allow client applications to use more
        generalized code in some situations (for instance, when manipulating
        objects that are all known to have identifiers).  If the object in
        question does not posess an 'id' attribute according to the SBML
        specification for the Level and Version in use, libSBML will not allow
        the identifier to be set, nor will it read or write 'id' attributes
        for those objects.

        Returns 'True' if the 'id' attribute of this SBML object is set,
        'False' otherwise.

        Note: Because of the inconsistent behavior of this function with
        respect to assignments and rules, it is recommended that callers use
        isSetIdAttribute() instead.

        See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
        isSetIdAttribute().

        """
        return _libsbml.Species_isSetId(self)

    def isSetName(self):
        r"""
        isSetName(Species self) -> bool

        Predicate returning 'True' if this Species object's 'name' attribute
        is set.

        In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
        to SBase directly, instead of being defined individually for many (but
        not all) objects.  LibSBML has for a long time provided functions
        defined on SBase itself to get, set, and unset those attributes, which
        would fail or otherwise return empty strings if executed on any object
        for which those attributes were not defined.  Now that all SBase
        objects  define those attributes, those functions now succeed for any
        object with  the appropriate level and version.

        The 'name' attribute is optional and is not intended to be used for
        cross-referencing purposes within a model.  Its purpose instead is to
        provide a human-readable label for the component.  The data type of
        'name' is the type string defined in XML Schema.  SBML imposes no
        restrictions as to the content of 'name' attributes beyond those
        restrictions defined by the string type in XML Schema.

        The recommended practice for handling 'name' is as follows.  If a
        software tool has the capability for displaying the content of 'name'
        attributes, it should display this content to the user as a
        component's label instead of the component's 'id'.  If the user
        interface does not have this capability (e.g., because it cannot
        display or use special characters in symbol names), or if the 'name'
        attribute is missing on a given component, then the user interface
        should display the value of the 'id' attribute instead.  (Script
        language interpreters are especially likely to display 'id' instead of
        'name'.)

        As a consequence of the above, authors of systems that automatically
        generate the values of 'id' attributes should be aware some systems
        may display the 'id''s to the user.  Authors therefore may wish to
        take some care to have their software create 'id' values that are: (a)
        reasonably easy for humans to type and read; and (b) likely to be
        meaningful, for example by making the 'id' attribute be an abbreviated
        form of the name attribute value.

        An additional point worth mentioning is although there are
        restrictions on the uniqueness of 'id' values, there are no
        restrictions on the uniqueness of 'name' values in a model.  This
        allows software applications leeway in assigning component
        identifiers.

        Regardless of the level and version of the SBML, these functions allow
        client applications to use more generalized code in some situations
        (for instance, when manipulating objects that are all known to have
        names).  If the object in question does not posess a 'name' attribute
        according to the SBML specification for the Level and Version in use,
        libSBML will not allow the name to be set, nor will it read or  write
        'name' attributes for those objects.

        Returns 'True' if the 'name' attribute of this SBML object is set,
        'False' otherwise.

        See also getName(), setName(), unsetName().

        """
        return _libsbml.Species_isSetName(self)

    def isSetSpeciesType(self):
        r"""
        isSetSpeciesType(Species self) -> bool

        Predicate returning 'True' if this Species object's 'speciesType'
        attribute is set.

        Returns 'True' if the 'speciesType' attribute of this Species is set,
        'False' otherwise.

        Note: The 'speciesType' attribute is only available in SBML Level 2
        Versions 2-4.

        """
        return _libsbml.Species_isSetSpeciesType(self)

    def isSetCompartment(self):
        r"""
        isSetCompartment(Species self) -> bool

        Predicate returning 'True' if this Species object's 'compartment'
        attribute is set.

        Returns 'True' if the 'compartment' attribute of this Species is set,
        'False' otherwise.

        """
        return _libsbml.Species_isSetCompartment(self)

    def isSetInitialAmount(self):
        r"""
        isSetInitialAmount(Species self) -> bool

        Predicate returning 'True' if this Species object's 'initialAmount'
        attribute is set.

        Returns 'True' if the 'initialAmount' attribute of this Species is
        set, 'False' otherwise.

        Note: In SBML Level 1, Species' 'initialAmount' is required and
        therefore should always be set.  (However, in Level 1, the attribute
        has no default value either, so this method will not return 'True'
        until a value has been assigned.)  In SBML Level 2, 'initialAmount' is
        optional and as such may or may not be set.

        """
        return _libsbml.Species_isSetInitialAmount(self)

    def isSetInitialConcentration(self):
        r"""
        isSetInitialConcentration(Species self) -> bool

        Pred