
# Language syntax files
This folder contains the language syntax definition files in ``sublime-syntax`` format. All the following language declarations were taken from the [GitHub linguist tool](https://github.com/github/linguist/). Right now, this library lacks a straight-forward, automatic way of converting all the diverse syntax defintions formats (``plist``, ``cson``, ``yaml``, ``json``, ``tmLanguage``) into the ``sublime-syntax`` format. Additionally, some of the files may need manual fixes in order to be syntactically correct, thus all the conversions were done manually at this point.

If you find out that a language has a new update that is not present on this repository, feel free to convert it and open a Pull Request. Here are some hints to convert syntax grammars across different formats.

* JSON -> PList: Use [json2plist](https://github.com/javiertoledo/json2plist) Ruby library
* YAML -> PList: Convert YAML to JSON and then JSON to PList
* CSON -> PList: Convert CSON to JSON by using the following [node.js library](https://github.com/atom/season), then convert the JSON to PList
* tmLanguage -> PList: They are the same format, thus a extension renaming is enough.
* PList -> sublime-syntax: Use the following [Python script](https://gist.github.com/andfoy/0bf4b5e6cfb18b28f1673870f2d20bcc) to convert PList files into sublime-syntax ones

When adding a new language, please do not forget to add the correspoding license into the ``licenses/grammar`` folder, found at the root of this repository.

## Grammar index

- **1C Enterprise:** [xDrivenDevelopment/atom-language-1c-bsl](https://github.com/xDrivenDevelopment/atom-language-1c-bsl)
- **4D:** [ayoubserti/lang-4d](https://github.com/ayoubserti/lang-4d)
- **ABAP:** [pvl/abap.tmbundle](https://github.com/pvl/abap.tmbundle)
- **ABNF:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **AGS Script:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **AMPL:** [ampl/sublime-ampl](https://github.com/ampl/sublime-ampl)
- **ANTLR:** [textmate/antlr.tmbundle](https://github.com/textmate/antlr.tmbundle)
- **API Blueprint:** [apiaryio/api-blueprint-sublime-plugin](https://github.com/apiaryio/api-blueprint-sublime-plugin)
- **APL:** [Alhadis/language-apl](https://github.com/Alhadis/language-apl)
- **ASN.1:** [ajlangley/language-asn1](https://github.com/ajlangley/language-asn1)
- **ASP:** [textmate/asp.tmbundle](https://github.com/textmate/asp.tmbundle)
- **ATS:** [steinwaywhw/ats-mode-sublimetext](https://github.com/steinwaywhw/ats-mode-sublimetext)
- **ActionScript:** [simongregory/actionscript3-tmbundle](https://github.com/simongregory/actionscript3-tmbundle)
- **Ada:** [textmate/ada.tmbundle](https://github.com/textmate/ada.tmbundle)
- **Adobe Font Metrics:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Agda:** [agda/agda-github-syntax-highlighting](https://github.com/agda/agda-github-syntax-highlighting)
- **Alloy:** [macekond/Alloy.tmbundle](https://github.com/macekond/Alloy.tmbundle)
- **Alpine Abuild:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **Altium Designer:** [textmate/ini.tmbundle](https://github.com/textmate/ini.tmbundle)
- **AngelScript:** [wronex/sublime-angelscript](https://github.com/wronex/sublime-angelscript)
- **Ant Build System:** [textmate/ant.tmbundle](https://github.com/textmate/ant.tmbundle)
- **ApacheConf:** [textmate/apache.tmbundle](https://github.com/textmate/apache.tmbundle)
- **Apex:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **Apollo Guidance Computer:** [Alhadis/language-agc](https://github.com/Alhadis/language-agc)
- **AppleScript:** [textmate/applescript.tmbundle](https://github.com/textmate/applescript.tmbundle)
- **AsciiDoc:** [zuckschwerdt/asciidoc.tmbundle](https://github.com/zuckschwerdt/asciidoc.tmbundle)
- **AspectJ:** [pchaigno/sublime-aspectj](https://github.com/pchaigno/sublime-aspectj)
- **Assembly:** [Nessphoro/sublimeassembly](https://github.com/Nessphoro/sublimeassembly)
- **Asymptote:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **AutoHotkey:** [ahkscript/SublimeAutoHotkey](https://github.com/ahkscript/SublimeAutoHotkey)
- **AutoIt:** [AutoIt/SublimeAutoItScript](https://github.com/AutoIt/SublimeAutoItScript)
- **Awk:** [github-linguist/awk-sublime](https://github.com/github-linguist/awk-sublime)
- **Ballerina:** [ballerina-platform/ballerina-grammar](https://github.com/ballerina-platform/ballerina-grammar)
- **Batchfile:** [mmims/language-batchfile](https://github.com/mmims/language-batchfile)
- **Befunge:** [johanasplund/sublime-befunge](https://github.com/johanasplund/sublime-befunge)
- **BibTeX:** [textmate/latex.tmbundle](https://github.com/textmate/latex.tmbundle)
- **Bison:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **Blade:** [jawee/language-blade](https://github.com/jawee/language-blade)
- **BlitzBasic:** [textmate/blitzmax.tmbundle](https://github.com/textmate/blitzmax.tmbundle)
- **BlitzMax:** [textmate/blitzmax.tmbundle](https://github.com/textmate/blitzmax.tmbundle)
- **Bluespec:** [thotypous/sublime-bsv](https://github.com/thotypous/sublime-bsv)
- **Boo:** [Shammah/boo-sublime](https://github.com/Shammah/boo-sublime)
- **Brainfuck:** [Drako/SublimeBrainfuck](https://github.com/Drako/SublimeBrainfuck)
- **Brightscript:** [cmink/BrightScript.tmbundle](https://github.com/cmink/BrightScript.tmbundle)
- **C:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **C#:** [atom/language-csharp](https://github.com/atom/language-csharp)
- **C++:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **C-ObjDump:** [nanoant/assembly.tmbundle](https://github.com/nanoant/assembly.tmbundle)
- **C2hs Haskell:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **CLIPS:** [psicomante/CLIPS-sublime](https://github.com/psicomante/CLIPS-sublime)
- **CMake:** [textmate/cmake.tmbundle](https://github.com/textmate/cmake.tmbundle)
- **COBOL:** [bitbucket:bitlang/sublime_cobol](https://bitbucket.org/bitlang/sublime_cobol)
- **COLLADA:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **CSON:** [atom/language-coffee-script](https://github.com/atom/language-coffee-script)
- **CSS:** [atom/language-css](https://github.com/atom/language-css)
- **Cabal Config:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **Cap'n Proto:** [textmate/capnproto.tmbundle](https://github.com/textmate/capnproto.tmbundle)
- **CartoCSS:** [yohanboniface/carto-atom](https://github.com/yohanboniface/carto-atom)
- **Ceylon:** [jeancharles-roger/ceylon-sublimetext](https://github.com/jeancharles-roger/ceylon-sublimetext)
- **Chapel:** [chapel-lang/chapel-tmbundle](https://github.com/chapel-lang/chapel-tmbundle)
- **ChucK:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **Cirru:** [Cirru/sublime-cirru](https://github.com/Cirru/sublime-cirru)
- **Clarion:** [fushnisoft/SublimeClarion](https://github.com/fushnisoft/SublimeClarion)
- **Clean:** [timjs/atom-language-clean](https://github.com/timjs/atom-language-clean)
- **Click:** [stenverbois/language-click](https://github.com/stenverbois/language-click)
- **Clojure:** [atom/language-clojure](https://github.com/atom/language-clojure)
- **Closure Templates:** [mthadley/language-closure-templates](https://github.com/mthadley/language-closure-templates)
- **Cloud Firestore Security Rules:** [jaysquared/atom-firestore-grammar](https://github.com/jaysquared/atom-firestore-grammar)
- **CoNLL-U:** [odanoburu/conllu-linguist-grammar](https://github.com/odanoburu/conllu-linguist-grammar)
- **CodeQL:** [github/vscode-codeql](https://github.com/github/vscode-codeql)
- **CoffeeScript:** [atom/language-coffee-script](https://github.com/atom/language-coffee-script)
- **ColdFusion:** [SublimeText/ColdFusion](https://github.com/SublimeText/ColdFusion)
- **ColdFusion CFC:** [SublimeText/ColdFusion](https://github.com/SublimeText/ColdFusion)
- **Common Lisp:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **Common Workflow Language:** [manabuishii/language-cwl](https://github.com/manabuishii/language-cwl)
- **Component Pascal:** [textmate/pascal.tmbundle](https://github.com/textmate/pascal.tmbundle)
- **Cool:** [anunayk/cool-tmbundle](https://github.com/anunayk/cool-tmbundle)
- **Coq:** [mkolosick/Sublime-Coq](https://github.com/mkolosick/Sublime-Coq)
- **Cpp-ObjDump:** [nanoant/assembly.tmbundle](https://github.com/nanoant/assembly.tmbundle)
- **Creole:** [Siddley/Creole](https://github.com/Siddley/Creole)
- **Crystal:** [atom-crystal/language-crystal](https://github.com/atom-crystal/language-crystal)
- **Csound:** [nwhetsell/language-csound](https://github.com/nwhetsell/language-csound)
- **Csound Document:** [nwhetsell/language-csound](https://github.com/nwhetsell/language-csound)
- **Csound Score:** [nwhetsell/language-csound](https://github.com/nwhetsell/language-csound)
- **Cuda:** [harrism/sublimetext-cuda-cpp](https://github.com/harrism/sublimetext-cuda-cpp)
- **Cycript:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **Cython:** [textmate/cython.tmbundle](https://github.com/textmate/cython.tmbundle)
- **D:** [textmate/d.tmbundle](https://github.com/textmate/d.tmbundle)
- **D-ObjDump:** [nanoant/assembly.tmbundle](https://github.com/nanoant/assembly.tmbundle)
- **DM:** [PJB3005/atomic-dreams](https://github.com/PJB3005/atomic-dreams)
- **DNS Zone:** [sixty4k/st2-zonefile](https://github.com/sixty4k/st2-zonefile)
- **DTrace:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Dart:** [dart-lang/dart-syntax-highlight](https://github.com/dart-lang/dart-syntax-highlight)
- **DataWeave:** [mulesoft-labs/data-weave-tmLanguage](https://github.com/mulesoft-labs/data-weave-tmLanguage)
- **Dhall:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **Diff:** [textmate/diff.tmbundle](https://github.com/textmate/diff.tmbundle)
- **Dockerfile:** [asbjornenge/Docker.tmbundle](https://github.com/asbjornenge/Docker.tmbundle)
- **Dylan:** [textmate/dylan.tmbundle](https://github.com/textmate/dylan.tmbundle)
- **EBNF:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **ECLiPSe:** [alnkpa/sublimeprolog](https://github.com/alnkpa/sublimeprolog)
- **EJS:** [gregory-m/ejs-tmbundle](https://github.com/gregory-m/ejs-tmbundle)
- **EML:** [mariozaizar/language-eml](https://github.com/mariozaizar/language-eml)
- **EQ:** [atom/language-csharp](https://github.com/atom/language-csharp)
- **Eagle:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **Easybuild:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Ecere Projects:** [textmate/json.tmbundle](https://github.com/textmate/json.tmbundle)
- **EditorConfig:** [sindresorhus/atom-editorconfig](https://github.com/sindresorhus/atom-editorconfig)
- **Edje Data Collection:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Eiffel:** [textmate/eiffel.tmbundle](https://github.com/textmate/eiffel.tmbundle)
- **Elixir:** [elixir-lang/elixir-tmbundle](https://github.com/elixir-lang/elixir-tmbundle)
- **Emacs Lisp:** [Alhadis/language-emacs-lisp](https://github.com/Alhadis/language-emacs-lisp)
- **EmberScript:** [atom/language-coffee-script](https://github.com/atom/language-coffee-script)
- **Erlang:** [textmate/erlang.tmbundle](https://github.com/textmate/erlang.tmbundle)
- **F#:** [fsprojects/atom-fsharp](https://github.com/fsprojects/atom-fsharp)
- **F\*:** [FStarLang/atom-fstar](https://github.com/FStarLang/atom-fstar)
- **FIGlet Font:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Factor:** [slavapestov/factor](https://github.com/slavapestov/factor)
- **Fancy:** [fancy-lang/fancy-tmbundle](https://github.com/fancy-lang/fancy-tmbundle)
- **Fantom:** [rkoeninger/sublime-fantom](https://github.com/rkoeninger/sublime-fantom)
- **Faust:** [jpcima/language-faust](https://github.com/jpcima/language-faust)
- **Forth:** [textmate/forth.tmbundle](https://github.com/textmate/forth.tmbundle)
- **Fortran:** [textmate/fortran.tmbundle](https://github.com/textmate/fortran.tmbundle)
- **FreeMarker:** [freemarker/FreeMarker.tmbundle](https://github.com/freemarker/FreeMarker.tmbundle)
- **Frege:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **G-code:** [appliedengdesign/vscode-gcode-syntax](https://github.com/appliedengdesign/vscode-gcode-syntax)
- **GAP:** [dhowden/gap-tmbundle](https://github.com/dhowden/gap-tmbundle)
- **GCC Machine Description:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **GDB:** [quarnster/SublimeGDB](https://github.com/quarnster/SublimeGDB)
- **GDScript:** [beefsack/GDScript-sublime](https://github.com/beefsack/GDScript-sublime)
- **GLSL:** [euler0/sublime-glsl](https://github.com/euler0/sublime-glsl)
- **GN:** [devoncarew/language-gn](https://github.com/devoncarew/language-gn)
- **Game Maker Language:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Genshi:** [genshi.edgewall.org/query](https://genshi.edgewall.org/query)
- **Gentoo Ebuild:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **Gentoo Eclass:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **Gerber Image:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **Gettext Catalog:** [textmate/gettext.tmbundle](https://github.com/textmate/gettext.tmbundle)
- **Gherkin:** [cucumber/cucumber-tmbundle](https://github.com/cucumber/cucumber-tmbundle)
- **Git Attributes:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Git Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Glyph:** [textmate/tcl.tmbundle](https://github.com/textmate/tcl.tmbundle)
- **Glyph Bitmap Distribution Format:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Gnuplot:** [mattfoster/gnuplot-tmbundle](https://github.com/mattfoster/gnuplot-tmbundle)
- **Go:** [AlanQuatermain/go-tmbundle](https://github.com/AlanQuatermain/go-tmbundle)
- **Golo:** [TypeUnsafe/sublime-golo](https://github.com/TypeUnsafe/sublime-golo)
- **Gosu:** [jpcamara/Textmate-Gosu-Bundle](https://github.com/jpcamara/Textmate-Gosu-Bundle)
- **Grace:** [zmthy/grace-tmbundle](https://github.com/zmthy/grace-tmbundle)
- **Gradle:** [alkemist/gradle.tmbundle](https://github.com/alkemist/gradle.tmbundle)
- **Grammatical Framework:** [johnjcamilleri/language-gf](https://github.com/johnjcamilleri/language-gf)
- **GraphQL:** [rmosolgo/language-graphql](https://github.com/rmosolgo/language-graphql)
- **Graphviz (DOT):** [textmate/graphviz.tmbundle](https://github.com/textmate/graphviz.tmbundle)
- **Groovy:** [textmate/groovy.tmbundle](https://github.com/textmate/groovy.tmbundle)
- **Groovy Server Pages:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **HAProxy:** [abulimov/atom-language-haproxy](https://github.com/abulimov/atom-language-haproxy)
- **HCL:** [alexlouden/Terraform.tmLanguage](https://github.com/alexlouden/Terraform.tmLanguage)
- **HLSL:** [tgjones/shaders-tmLanguage](https://github.com/tgjones/shaders-tmLanguage)
- **HTML:** [atom/language-html](https://github.com/atom/language-html)
- **HTML+Django:** [textmate/python-django.tmbundle](https://github.com/textmate/python-django.tmbundle)
- **HTML+ECR:** [atom-crystal/language-crystal](https://github.com/atom-crystal/language-crystal)
- **HTML+EEX:** [elixir-lang/elixir-tmbundle](https://github.com/elixir-lang/elixir-tmbundle)
- **HTML+ERB:** [atom/language-ruby](https://github.com/atom/language-ruby)
- **HTML+PHP:** [textmate/php.tmbundle](https://github.com/textmate/php.tmbundle)
- **HTML+Razor:** [austincummings/razor-plus](https://github.com/austincummings/razor-plus)
- **HTTP:** [samsalisbury/Sublime-HTTP](https://github.com/samsalisbury/Sublime-HTTP)
- **HXML:** [vshaxe/haxe-TmLanguage](https://github.com/vshaxe/haxe-TmLanguage)
- **Hack:** [slackhq/vscode-hack](https://github.com/slackhq/vscode-hack)
- **Haml:** [ezekg/language-haml](https://github.com/ezekg/language-haml)
- **Handlebars:** [daaain/Handlebars](https://github.com/daaain/Handlebars)
- **Harbour:** [hernad/atom-language-harbour](https://github.com/hernad/atom-language-harbour)
- **Haskell:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **Haxe:** [vshaxe/haxe-TmLanguage](https://github.com/vshaxe/haxe-TmLanguage)
- **HiveQL:** [adidonato/language-hql](https://github.com/adidonato/language-hql)
- **HolyC:** [codingdandy/holyc.tmbundle](https://github.com/codingdandy/holyc.tmbundle)
- **Hy:** [Slowki/hy.tmLanguage](https://github.com/Slowki/hy.tmLanguage)
- **IDL:** [mgalloy/idl.tmbundle](https://github.com/mgalloy/idl.tmbundle)
- **IGOR Pro:** [byte-physics/language-igor](https://github.com/byte-physics/language-igor)
- **INI:** [textmate/ini.tmbundle](https://github.com/textmate/ini.tmbundle)
- **Idris:** [idris-hackers/idris-sublime](https://github.com/idris-hackers/idris-sublime)
- **Ignore List:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Inform 7:** [erkyrath/language-inform7](https://github.com/erkyrath/language-inform7)
- **Inno Setup:** [idleberg/atom-language-innosetup](https://github.com/idleberg/atom-language-innosetup)
- **Io:** [textmate/io.tmbundle](https://github.com/textmate/io.tmbundle)
- **Ioke:** [vic/ioke-outdated](https://github.com/vic/ioke-outdated)
- **Isabelle:** [lsf37/Isabelle.tmbundle](https://github.com/lsf37/Isabelle.tmbundle)
- **Isabelle ROOT:** [lsf37/Isabelle.tmbundle](https://github.com/lsf37/Isabelle.tmbundle)
- **J:** [tikkanz/JSyntax](https://github.com/tikkanz/JSyntax)
- **JFlex:** [jflex-de/jflex.tmbundle](https://github.com/jflex-de/jflex.tmbundle)
- **JSON:** [textmate/json.tmbundle](https://github.com/textmate/json.tmbundle)
- **JSON with Comments:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **JSON5:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **JSONLD:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **JSONiq:** [wcandillon/language-jsoniq](https://github.com/wcandillon/language-jsoniq)
- **JSX:** [github-linguist/babel-sublime](https://github.com/github-linguist/babel-sublime)
- **Jasmin:** [atmarksharp/jasmin-sublime](https://github.com/atmarksharp/jasmin-sublime)
- **Java:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **Java Properties:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **Java Server Pages:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **JavaScript:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **JavaScript+ERB:** [atom/language-javascript](https://github.com/atom/language-javascript)
- **Jison:** [cdibbs/language-jison](https://github.com/cdibbs/language-jison)
- **Jison Lex:** [cdibbs/language-jison](https://github.com/cdibbs/language-jison)
- **Jolie:** [fmontesi/language-jolie](https://github.com/fmontesi/language-jolie)
- **Jsonnet:** [google/language-jsonnet](https://github.com/google/language-jsonnet)
- **Julia:** [JuliaEditorSupport/atom-language-julia](https://github.com/JuliaEditorSupport/atom-language-julia)
- **Jupyter Notebook:** [textmate/json.tmbundle](https://github.com/textmate/json.tmbundle)
- **KiCad Layout:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **KiCad Legacy Layout:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **KiCad Schematic:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **Kit:** [atom/language-html](https://github.com/atom/language-html)
- **Kotlin:** [nishtahir/language-kotlin](https://github.com/nishtahir/language-kotlin)
- **LFE:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **LLVM:** [whitequark/llvm.tmbundle](https://github.com/whitequark/llvm.tmbundle)
- **LSL:** [textmate/secondlife-lsl.tmbundle](https://github.com/textmate/secondlife-lsl.tmbundle)
- **LTspice Symbol:** [Alhadis/language-pcb](https://github.com/Alhadis/language-pcb)
- **LabVIEW:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **Lasso:** [bfad/Sublime-Lasso](https://github.com/bfad/Sublime-Lasso)
- **Latte:** [textmate/php-smarty.tmbundle](https://github.com/textmate/php-smarty.tmbundle)
- **Lean:** [leanprover/vscode-lean](https://github.com/leanprover/vscode-lean)
- **Less:** [atom/language-less](https://github.com/atom/language-less)
- **Lex:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **LilyPond:** [textmate/lilypond.tmbundle](https://github.com/textmate/lilypond.tmbundle)
- **Liquid:** [bastilian/validcode-textmate-bundles](https://github.com/bastilian/validcode-textmate-bundles)
- **Literate CoffeeScript:** [atom/language-coffee-script](https://github.com/atom/language-coffee-script)
- **Literate Haskell:** [atom-haskell/language-haskell](https://github.com/atom-haskell/language-haskell)
- **LiveScript:** [paulmillr/LiveScript.tmbundle](https://github.com/paulmillr/LiveScript.tmbundle)
- **Logos:** [Cykey/Sublime-Logos](https://github.com/Cykey/Sublime-Logos)
- **Logtalk:** [textmate/logtalk.tmbundle](https://github.com/textmate/logtalk.tmbundle)
- **LookML:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **LoomScript:** [ambethia/Sublime-Loom](https://github.com/ambethia/Sublime-Loom)
- **Lua:** [textmate/lua.tmbundle](https://github.com/textmate/lua.tmbundle)
- **M4:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **M4Sugar:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **MATLAB:** [mathworks/MATLAB-Language-grammar](https://github.com/mathworks/MATLAB-Language-grammar)
- **MAXScript:** [Alhadis/language-maxscript](https://github.com/Alhadis/language-maxscript)
- **MLIR:** [jpienaar/mlir-grammar](https://github.com/jpienaar/mlir-grammar)
- **MQL4:** [mqsoft/MQL5-sublime](https://github.com/mqsoft/MQL5-sublime)
- **MQL5:** [mqsoft/MQL5-sublime](https://github.com/mqsoft/MQL5-sublime)
- **MTML:** [atom/language-html](https://github.com/atom/language-html)
- **Makefile:** [textmate/make.tmbundle](https://github.com/textmate/make.tmbundle)
- **Mako:** [marconi/mako-tmbundle](https://github.com/marconi/mako-tmbundle)
- **Markdown:** [atom/language-gfm](https://github.com/atom/language-gfm)
- **Marko:** [marko-js/marko-tmbundle](https://github.com/marko-js/marko-tmbundle)
- **Mask:** [tenbits/sublime-mask](https://github.com/tenbits/sublime-mask)
- **Mathematica:** [shadanan/mathematica-tmbundle](https://github.com/shadanan/mathematica-tmbundle)
- **Maven POM:** [textmate/maven.tmbundle](https://github.com/textmate/maven.tmbundle)
- **Max:** [textmate/json.tmbundle](https://github.com/textmate/json.tmbundle)
- **MediaWiki:** [textmate/mediawiki.tmbundle](https://github.com/textmate/mediawiki.tmbundle)
- **Mercury:** [sebgod/mercury-tmlanguage](https://github.com/sebgod/mercury-tmlanguage)
- **Meson:** [TingPing/language-meson](https://github.com/TingPing/language-meson)
- **Metal:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Mirah:** [atom/language-ruby](https://github.com/atom/language-ruby)
- **Modelica:** [BorisChumichev/modelicaSublimeTextPackage](https://github.com/BorisChumichev/modelicaSublimeTextPackage)
- **Modula-2:** [harogaston/Sublime-Modula-2](https://github.com/harogaston/Sublime-Modula-2)
- **Modula-3:** [newgrammars/m3](https://github.com/newgrammars/m3)
- **Monkey:** [gingerbeardman/monkey.tmbundle](https://github.com/gingerbeardman/monkey.tmbundle)
- **MoonScript:** [leafo/moonscript-tmbundle](https://github.com/leafo/moonscript-tmbundle)
- **Motorola 68K Assembly:** [zerkman/language-m68k](https://github.com/zerkman/language-m68k)
- **Muse:** [Alhadis/language-emacs-lisp](https://github.com/Alhadis/language-emacs-lisp)
- **NASL:** [tenable/sublimetext-nasl](https://github.com/tenable/sublimetext-nasl)
- **NCL:** [rpavlick/language-ncl](https://github.com/rpavlick/language-ncl)
- **NPM Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **NSIS:** [github-linguist/NSIS](https://github.com/github-linguist/NSIS)
- **Nearley:** [Hardmath123/sublime-nearley](https://github.com/Hardmath123/sublime-nearley)
- **Nemerle:** [textmate/nemerle.tmbundle](https://github.com/textmate/nemerle.tmbundle)
- **NetLinx:** [amclain/sublime-netlinx](https://github.com/amclain/sublime-netlinx)
- **NetLinx+ERB:** [amclain/sublime-netlinx](https://github.com/amclain/sublime-netlinx)
- **NetLogo:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **NewLisp:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **Nextflow:** [nextflow-io/atom-language-nextflow](https://github.com/nextflow-io/atom-language-nextflow)
- **Nginx:** [brandonwamboldt/sublime-nginx](https://github.com/brandonwamboldt/sublime-nginx)
- **Nim:** [Varriount/NimLime](https://github.com/Varriount/NimLime)
- **Ninja:** [khyo/language-ninja](https://github.com/khyo/language-ninja)
- **Nit:** [R4PaSs/Sublime-Nit](https://github.com/R4PaSs/Sublime-Nit)
- **Nix:** [wmertens/sublime-nix](https://github.com/wmertens/sublime-nix)
- **Nu:** [jsallis/nu.tmbundle](https://github.com/jsallis/nu.tmbundle)
- **OCaml:** [textmate/ocaml.tmbundle](https://github.com/textmate/ocaml.tmbundle)
- **ObjDump:** [nanoant/assembly.tmbundle](https://github.com/nanoant/assembly.tmbundle)
- **Object Data Instance Notation:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **ObjectScript:** [intersystems-community/ObjectScript.tmBundle](https://github.com/intersystems-community/ObjectScript.tmBundle)
- **Objective-C:** [textmate/objective-c.tmbundle](https://github.com/textmate/objective-c.tmbundle)
- **Objective-C++:** [textmate/objective-c.tmbundle](https://github.com/textmate/objective-c.tmbundle)
- **Objective-J:** [textmate/javascript-objective-j.tmbundle](https://github.com/textmate/javascript-objective-j.tmbundle)
- **Odin:** [odin-lang/sublime-odin](https://github.com/odin-lang/sublime-odin)
- **Opa:** [mads379/opa.tmbundle](https://github.com/mads379/opa.tmbundle)
- **Opal:** [artifactz/sublime-opal](https://github.com/artifactz/sublime-opal)
- **Open Policy Agent:** [tsandall/vscode-opa](https://github.com/tsandall/vscode-opa)
- **OpenCL:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **OpenEdge ABL:** [jfairbank/Sublime-Text-2-OpenEdge-ABL](https://github.com/jfairbank/Sublime-Text-2-OpenEdge-ABL)
- **OpenQASM:** [tareqdandachi/language-qasm](https://github.com/tareqdandachi/language-qasm)
- **OpenRC runscript:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **OpenSCAD:** [tbuser/openscad.tmbundle](https://github.com/tbuser/openscad.tmbundle)
- **OpenStep Property List:** [atom/language-property-list](https://github.com/atom/language-property-list)
- **OpenType Feature File:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Ox:** [andreashetland/sublime-text-ox](https://github.com/andreashetland/sublime-text-ox)
- **Oz:** [eregon/oz-tmbundle](https://github.com/eregon/oz-tmbundle)
- **P4:** [TakeshiTseng/atom-language-p4](https://github.com/TakeshiTseng/atom-language-p4)
- **PHP:** [textmate/php.tmbundle](https://github.com/textmate/php.tmbundle)
- **PLpgSQL:** [textmate/sql.tmbundle](https://github.com/textmate/sql.tmbundle)
- **POV-Ray SDL:** [c-lipka/language-povray](https://github.com/c-lipka/language-povray)
- **Pan:** [quattor/language-pan](https://github.com/quattor/language-pan)
- **Papyrus:** [Kapiainen/SublimePapyrus](https://github.com/Kapiainen/SublimePapyrus)
- **Parrot Internal Representation:** [textmate/parrot.tmbundle](https://github.com/textmate/parrot.tmbundle)
- **Pascal:** [textmate/pascal.tmbundle](https://github.com/textmate/pascal.tmbundle)
- **Pawn:** [Southclaw/pawn-sublime-language](https://github.com/Southclaw/pawn-sublime-language)
- **Pep8:** [R4PaSs/Sublime-Pep8](https://github.com/R4PaSs/Sublime-Pep8)
- **Perl:** [textmate/perl.tmbundle](https://github.com/textmate/perl.tmbundle)
- **Pic:** [Alhadis/language-roff](https://github.com/Alhadis/language-roff)
- **PicoLisp:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **PigLatin:** [goblindegook/sublime-text-pig-latin](https://github.com/goblindegook/sublime-text-pig-latin)
- **Pike:** [hww3/pike-textmate](https://github.com/hww3/pike-textmate)
- **PlantUML:** [qjebbs/vscode-plantuml](https://github.com/qjebbs/vscode-plantuml)
- **Pod 6:** [perl6/atom-language-perl6](https://github.com/perl6/atom-language-perl6)
- **PogoScript:** [featurist/PogoScript.tmbundle](https://github.com/featurist/PogoScript.tmbundle)
- **Pony:** [CausalityLtd/sublime-pony](https://github.com/CausalityLtd/sublime-pony)
- **PostCSS:** [hudochenkov/Syntax-highlighting-for-PostCSS](https://github.com/hudochenkov/Syntax-highlighting-for-PostCSS)
- **PostScript:** [textmate/postscript.tmbundle](https://github.com/textmate/postscript.tmbundle)
- **PowerShell:** [PowerShell/EditorSyntax](https://github.com/PowerShell/EditorSyntax)
- **Prisma:** [prisma/vscode-prisma](https://github.com/prisma/vscode-prisma)
- **Processing:** [textmate/processing.tmbundle](https://github.com/textmate/processing.tmbundle)
- **Prolog:** [alnkpa/sublimeprolog](https://github.com/alnkpa/sublimeprolog)
- **Propeller Spin:** [bitbased/sublime-spintools](https://github.com/bitbased/sublime-spintools)
- **Protocol Buffer:** [michaeledgar/protobuf-tmbundle](https://github.com/michaeledgar/protobuf-tmbundle)
- **Pug:** [davidrios/jade-tmbundle](https://github.com/davidrios/jade-tmbundle)
- **Puppet:** [russCloak/SublimePuppet](https://github.com/russCloak/SublimePuppet)
- **PureScript:** [purescript-contrib/atom-language-purescript](https://github.com/purescript-contrib/atom-language-purescript)
- **Python:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Python console:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Python traceback:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **QML:** [skozlovf/Sublime-QML](https://github.com/skozlovf/Sublime-QML)
- **QMake:** [textmate/cpp-qt.tmbundle](https://github.com/textmate/cpp-qt.tmbundle)
- **Quake:** [newgrammars/quake](https://github.com/newgrammars/quake)
- **R:** [textmate/r.tmbundle](https://github.com/textmate/r.tmbundle)
- **RAML:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **RDoc:** [joshaven/RDoc.tmbundle](https://github.com/joshaven/RDoc.tmbundle)
- **REALbasic:** [angryant0007/VBDotNetSyntax](https://github.com/angryant0007/VBDotNetSyntax)
- **REXX:** [mblocker/rexx-sublime](https://github.com/mblocker/rexx-sublime)
- **RHTML:** [atom/language-ruby](https://github.com/atom/language-ruby)
- **RMarkdown:** [atom/language-gfm](https://github.com/atom/language-gfm)
- **RPC:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **RPM Spec:** [waveclaw/language-rpm-spec](https://github.com/waveclaw/language-rpm-spec)
- **RUNOFF:** [Alhadis/language-roff](https://github.com/Alhadis/language-roff)
- **Racket:** [soegaard/racket-highlight-for-github](https://github.com/soegaard/racket-highlight-for-github)
- **Raku:** [perl6/atom-language-perl6](https://github.com/perl6/atom-language-perl6)
- **Rascal:** [usethesource/rascal-syntax-highlighting](https://github.com/usethesource/rascal-syntax-highlighting)
- **Readline Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Reason:** [reasonml-editor/language-reason](https://github.com/reasonml-editor/language-reason)
- **Rebol:** [Oldes/Sublime-REBOL](https://github.com/Oldes/Sublime-REBOL)
- **Red:** [Oldes/Sublime-Red](https://github.com/Oldes/Sublime-Red)
- **Regular Expression:** [Alhadis/language-regexp](https://github.com/Alhadis/language-regexp)
- **Ren'Py:** [williamd1k0/language-renpy](https://github.com/williamd1k0/language-renpy)
- **Rich Text Format:** [nwhetsell/language-rtf](https://github.com/nwhetsell/language-rtf)
- **Ring:** [MahmoudFayed/atom-language-ring](https://github.com/MahmoudFayed/atom-language-ring)
- **Riot:** [riot/syntax-highlight](https://github.com/riot/syntax-highlight)
- **RobotFramework:** [shellderp/sublime-robot-plugin](https://github.com/shellderp/sublime-robot-plugin)
- **Roff:** [Alhadis/language-roff](https://github.com/Alhadis/language-roff)
- **Roff Manpage:** [Alhadis/language-roff](https://github.com/Alhadis/language-roff)
- **Rouge:** [atom/language-clojure](https://github.com/atom/language-clojure)
- **Ruby:** [atom/language-ruby](https://github.com/atom/language-ruby)
- **Rust:** [zargony/atom-language-rust](https://github.com/zargony/atom-language-rust)
- **SAS:** [rpardee/sas.tmbundle](https://github.com/rpardee/sas.tmbundle)
- **SCSS:** [atom/language-sass](https://github.com/atom/language-sass)
- **SMT:** [SRI-CSL/SMT.tmbundle](https://github.com/SRI-CSL/SMT.tmbundle)
- **SPARQL:** [peta/turtle.tmbundle](https://github.com/peta/turtle.tmbundle)
- **SQF:** [JonBons/Sublime-SQF-Language](https://github.com/JonBons/Sublime-SQF-Language)
- **SQL:** [textmate/sql.tmbundle](https://github.com/textmate/sql.tmbundle)
- **SQLPL:** [textmate/sql.tmbundle](https://github.com/textmate/sql.tmbundle)
- **SRecode Template:** [textmate/lisp.tmbundle](https://github.com/textmate/lisp.tmbundle)
- **SSH Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **STON:** [tomas-stefano/smalltalk-tmbundle](https://github.com/tomas-stefano/smalltalk-tmbundle)
- **SVG:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **SWIG:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Sage:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **SaltStack:** [saltstack/atom-salt](https://github.com/saltstack/atom-salt)
- **Sass:** [atom/language-sass](https://github.com/atom/language-sass)
- **Scala:** [scala/vscode-scala-syntax](https://github.com/scala/vscode-scala-syntax)
- **Scaml:** [scalate/Scalate.tmbundle](https://github.com/scalate/Scalate.tmbundle)
- **Scheme:** [sicp-lang/scheme.tmbundle](https://github.com/sicp-lang/scheme.tmbundle)
- **Scilab:** [textmate/scilab.tmbundle](https://github.com/textmate/scilab.tmbundle)
- **ShaderLab:** [tgjones/shaders-tmLanguage](https://github.com/tgjones/shaders-tmLanguage)
- **Shell:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **ShellSession:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **Shen:** [rkoeninger/sublime-shen](https://github.com/rkoeninger/sublime-shen)
- **Slash:** [slash-lang/Slash.tmbundle](https://github.com/slash-lang/Slash.tmbundle)
- **Slice:** [zeroc-ice/vscode-slice](https://github.com/zeroc-ice/vscode-slice)
- **Slim:** [slim-template/ruby-slim.tmbundle](https://github.com/slim-template/ruby-slim.tmbundle)
- **SmPL:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Smali:** [ShaneWilton/sublime-smali](https://github.com/ShaneWilton/sublime-smali)
- **Smalltalk:** [tomas-stefano/smalltalk-tmbundle](https://github.com/tomas-stefano/smalltalk-tmbundle)
- **Smarty:** [textmate/php-smarty.tmbundle](https://github.com/textmate/php-smarty.tmbundle)
- **Solidity:** [davidhq/SublimeEthereum](https://github.com/davidhq/SublimeEthereum)
- **SourcePawn:** [Dreae/sourcepawn-vscode](https://github.com/Dreae/sourcepawn-vscode)
- **Spline Font Database:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **Squirrel:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Stan:** [jrnold/atom-language-stan](https://github.com/jrnold/atom-language-stan)
- **Standard ML:** [textmate/standard-ml.tmbundle](https://github.com/textmate/standard-ml.tmbundle)
- **Starlark:** [MagicStack/MagicPython](https://github.com/MagicStack/MagicPython)
- **Stata:** [pschumm/Stata.tmbundle](https://github.com/pschumm/Stata.tmbundle)
- **Stylus:** [billymoon/Stylus](https://github.com/billymoon/Stylus)
- **SubRip Text:** [314eter/atom-language-srt](https://github.com/314eter/atom-language-srt)
- **SugarSS:** [hudochenkov/Syntax-highlighting-for-PostCSS](https://github.com/hudochenkov/Syntax-highlighting-for-PostCSS)
- **SuperCollider:** [supercollider/language-supercollider](https://github.com/supercollider/language-supercollider)
- **Svelte:** [umanghome/svelte-atom](https://github.com/umanghome/svelte-atom)
- **Swift:** [textmate/swift.tmbundle](https://github.com/textmate/swift.tmbundle)
- **SystemVerilog:** [bitbucket:Clams/sublimesystemverilog](https://bitbucket.org/Clams/sublimesystemverilog)
- **TLA:** [agentultra/TLAGrammar](https://github.com/agentultra/TLAGrammar)
- **TOML:** [textmate/toml.tmbundle](https://github.com/textmate/toml.tmbundle)
- **TSQL:** [beau-witter/language-tsql](https://github.com/beau-witter/language-tsql)
- **TSX:** [Microsoft/TypeScript-TmLanguage](https://github.com/Microsoft/TypeScript-TmLanguage)
- **TXL:** [MikeHoffert/Sublime-Text-TXL-syntax](https://github.com/MikeHoffert/Sublime-Text-TXL-syntax)
- **Tcl:** [textmate/tcl.tmbundle](https://github.com/textmate/tcl.tmbundle)
- **Tcsh:** [atom/language-shellscript](https://github.com/atom/language-shellscript)
- **TeX:** [textmate/latex.tmbundle](https://github.com/textmate/latex.tmbundle)
- **Tea:** [pferruggiaro/sublime-tea](https://github.com/pferruggiaro/sublime-tea)
- **Terra:** [pyk/sublime-terra](https://github.com/pyk/sublime-terra)
- **Texinfo:** [Alhadis/language-texinfo](https://github.com/Alhadis/language-texinfo)
- **Thrift:** [textmate/thrift.tmbundle](https://github.com/textmate/thrift.tmbundle)
- **Turing:** [Alhadis/language-turing](https://github.com/Alhadis/language-turing)
- **Turtle:** [peta/turtle.tmbundle](https://github.com/peta/turtle.tmbundle)
- **Twig:** [Anomareh/PHP-Twig.tmbundle](https://github.com/Anomareh/PHP-Twig.tmbundle)
- **Type Language:** [goodmind/language-typelanguage](https://github.com/goodmind/language-typelanguage)
- **TypeScript:** [Microsoft/TypeScript-TmLanguage](https://github.com/Microsoft/TypeScript-TmLanguage)
- **Unified Parallel C:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **Unity3D Asset:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **Unix Assembly:** [calculuswhiz/Assembly-Syntax-Definition](https://github.com/calculuswhiz/Assembly-Syntax-Definition)
- **Uno:** [atom/language-csharp](https://github.com/atom/language-csharp)
- **UnrealScript:** [textmate/java.tmbundle](https://github.com/textmate/java.tmbundle)
- **UrWeb:** [gwalborn/UrWeb-Language-Definition](https://github.com/gwalborn/UrWeb-Language-Definition)
- **V:** [0x9ef/vscode-vlang](https://github.com/0x9ef/vscode-vlang)
- **VBA:** [angryant0007/VBDotNetSyntax](https://github.com/angryant0007/VBDotNetSyntax)
- **VBScript:** [angryant0007/VBDotNetSyntax](https://github.com/angryant0007/VBDotNetSyntax)
- **VCL:** [brandonwamboldt/sublime-varnish](https://github.com/brandonwamboldt/sublime-varnish)
- **VHDL:** [textmate/vhdl.tmbundle](https://github.com/textmate/vhdl.tmbundle)
- **Vala:** [technosophos/Vala-TMBundle](https://github.com/technosophos/Vala-TMBundle)
- **Verilog:** [textmate/verilog.tmbundle](https://github.com/textmate/verilog.tmbundle)
- **Vim Snippet:** [Alhadis/language-viml](https://github.com/Alhadis/language-viml)
- **Vim script:** [Alhadis/language-viml](https://github.com/Alhadis/language-viml)
- **Visual Basic .NET:** [angryant0007/VBDotNetSyntax](https://github.com/angryant0007/VBDotNetSyntax)
- **Volt:** [textmate/d.tmbundle](https://github.com/textmate/d.tmbundle)
- **Vue:** [vuejs/vue-syntax-highlight](https://github.com/vuejs/vue-syntax-highlight)
- **Wavefront Material:** [Alhadis/language-wavefront](https://github.com/Alhadis/language-wavefront)
- **Wavefront Object:** [Alhadis/language-wavefront](https://github.com/Alhadis/language-wavefront)
- **Web Ontology Language:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **WebAssembly:** [Alhadis/language-webassembly](https://github.com/Alhadis/language-webassembly)
- **WebIDL:** [andik/IDL-Syntax](https://github.com/andik/IDL-Syntax)
- **WebVTT:** [weizhenye/language-vtt](https://github.com/weizhenye/language-vtt)
- **Wget Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **Windows Registry Entries:** [bsara/language-reg](https://github.com/bsara/language-reg)
- **Wollok:** [uqbar-project/wollok-sublime](https://github.com/uqbar-project/wollok-sublime)
- **World of Warcraft Addon Data:** [nebularg/language-toc-wow](https://github.com/nebularg/language-toc-wow)
- **X BitMap:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **X Font Directory Index:** [Alhadis/language-fontforge](https://github.com/Alhadis/language-fontforge)
- **X PixMap:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **X10:** [x10-lang/x10-highlighting](https://github.com/x10-lang/x10-highlighting)
- **XC:** [graymalkin/xc.tmbundle](https://github.com/graymalkin/xc.tmbundle)
- **XCompose:** [samcv/language-xcompose](https://github.com/samcv/language-xcompose)
- **XML:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **XML Property List:** [atom/language-property-list](https://github.com/atom/language-property-list)
- **XPages:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **XProc:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **XQuery:** [wcandillon/language-jsoniq](https://github.com/wcandillon/language-jsoniq)
- **XS:** [textmate/c.tmbundle](https://github.com/textmate/c.tmbundle)
- **XSLT:** [textmate/xml.tmbundle](https://github.com/textmate/xml.tmbundle)
- **Xojo:** [jimmckay/XojoSyntaxTM](https://github.com/jimmckay/XojoSyntaxTM)
- **Xtend:** [staltz/SublimeXtend](https://github.com/staltz/SublimeXtend)
- **YAML:** [atom/language-yaml](https://github.com/atom/language-yaml)
- **YANG:** [DzonyKalafut/language-yang](https://github.com/DzonyKalafut/language-yang)
- **YARA:** [blacktop/language-yara](https://github.com/blacktop/language-yara)
- **YASnippet:** [Alhadis/language-emacs-lisp](https://github.com/Alhadis/language-emacs-lisp)
- **Yacc:** [Alhadis/language-grammars](https://github.com/Alhadis/language-grammars)
- **ZAP:** [tclem/vscode-zil-language](https://github.com/tclem/vscode-zil-language)
- **ZIL:** [tclem/vscode-zil-language](https://github.com/tclem/vscode-zil-language)
- **Zeek:** [zeek/zeek-sublime](https://github.com/zeek/zeek-sublime)
- **ZenScript:** [CraftTweaker/ZenScript-tmLanguage](https://github.com/CraftTweaker/ZenScript-tmLanguage)
- **Zephir:** [phalcon/zephir-sublime](https://github.com/phalcon/zephir-sublime)
- **Zig:** [ziglang/sublime-zig-language](https://github.com/ziglang/sublime-zig-language)
- **cURL Config:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **desktop:** [Mailaender/desktop.tmbundle](https://github.com/Mailaender/desktop.tmbundle)
- **dircolors:** [jolkdarr/language-dircolors](https://github.com/jolkdarr/language-dircolors)
- **eC:** [ecere/ec.tmbundle](https://github.com/ecere/ec.tmbundle)
- **edn:** [atom/language-clojure](https://github.com/atom/language-clojure)
- **fish:** [l15n/fish-tmbundle](https://github.com/l15n/fish-tmbundle)
- **mIRC Script:** [gen-angry/language-msl](https://github.com/gen-angry/language-msl)
- **mcfunction:** [Arcensoth/language-mcfunction](https://github.com/Arcensoth/language-mcfunction)
- **mupad:** [ccreutzig/sublime-MuPAD](https://github.com/ccreutzig/sublime-MuPAD)
- **nanorc:** [Alhadis/language-etc](https://github.com/Alhadis/language-etc)
- **nesC:** [cdwilson/nesC.tmbundle](https://github.com/cdwilson/nesC.tmbundle)
- **ooc:** [nilium/ooc.tmbundle](https://github.com/nilium/ooc.tmbundle)
- **q:** [komsit37/sublime-q](https://github.com/komsit37/sublime-q)
- **reStructuredText:** [Lukasa/language-restructuredtext](https://github.com/Lukasa/language-restructuredtext)
- **sed:** [Alhadis/language-sed](https://github.com/Alhadis/language-sed)
- **wdl:** [broadinstitute/wdl-sublime-syntax-highlighter](https://github.com/broadinstitute/wdl-sublime-syntax-highlighter)
- **wisp:** [atom/language-clojure](https://github.com/atom/language-clojure)
- **xBase:** [hernad/atom-language-harbour](https://github.com/hernad/atom-language-harbour)
