import unittest

from pystan import stanc, StanModel
from pystan._compat import PY2

class TestUTF8(unittest.TestCase):

    desired = sorted({"status", "model_cppname", "cppcode", "model_name", "model_code", "include_paths"})

    def test_utf8(self):
        model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
        result = stanc(model_code=model_code)
        self.assertEqual(sorted(result.keys()), self.desired)
        self.assertTrue(result['cppcode'].startswith("// Code generated by Stan "))
        self.assertEqual(result['status'], 0)

    def test_utf8_linecomment(self):
        model_code = u'parameters {real y;\n //äöéü\n} model {y ~ normal(0,1);}'
        result = stanc(model_code=model_code)
        self.assertEqual(sorted(result.keys()), self.desired)
        self.assertTrue(result['cppcode'].startswith("// Code generated by Stan "))
        self.assertEqual(result['status'], 0)

    def test_utf8_multilinecomment(self):
        model_code = u'parameters {real y;\n /*äöéü\näöéü*/\n} model {y ~ normal(0,1);}'
        result = stanc(model_code=model_code)
        self.assertEqual(sorted(result.keys()), self.desired)
        self.assertTrue(result['cppcode'].startswith("// Code generated by Stan "))
        self.assertEqual(result['status'], 0)

    def test_utf8_inprogramcode(self):
        model_code = u'parameters {real ö;\n} model {ö ~ normal(0,1);}'
        assertRaisesRegex = self.assertRaisesRegexp if PY2 else self.assertRaisesRegex
        with assertRaisesRegex(ValueError, 'Failed to parse Stan model .*'):
            stanc(model_code=model_code)
