#  tests for pystan-2.17.1.0-py35h830ac7b_1 (this is a generated file);
print('===== testing package: pystan-2.17.1.0-py35h830ac7b_1 =====');
print('running run_test.py');
#  --- run_test.py (begin) ---
import pystan

schools_code = """
data {
    int<lower=0> J; // number of schools
    real y[J]; // estimated treatment effects
    real<lower=0> sigma[J]; // s.e. of effect estimates
}
parameters {
    real mu;
    real<lower=0> tau;
    real eta[J];
}
transformed parameters {
    real theta[J];
    for (j in 1:J)
        theta[j] = mu + tau * eta[j];
}
model {
    eta ~ normal(0, 1);
    y ~ normal(theta, sigma);
}
"""

schools_dat = {'J': 8,
               'y': [28,  8, -3,  7, -1,  1, 18, 12],
               'sigma': [15, 10, 16, 11,  9, 11, 10, 18]}

fit = pystan.stan(model_code=schools_code, data=schools_dat,
                  iter=1000, chains=4, n_jobs=1)
print(fit)
#  --- run_test.py (end) ---

print('===== pystan-2.17.1.0-py35h830ac7b_1 OK =====');
print("import: 'pystan'")
import pystan

