"""
PySparse: A Fast Sparse Matrix Library for Python
=================================================

Documentation is available in the docstrings and
online at http://pysparse.sourceforge.net/.

Contents
--------
Pysparse imports
::
 spmatrix                     --- sparse matrix types

and, in addition, provides:
    
Subpackages
-----------
Using any of these subpackages requires an explicit import.  For example,
``import pysparse.itsolvers``.

::

 itsolvers                    --- Iterative linear algebra solvers
 precon                       --- Preconditioners
 direct                       --- Direct solvers
 direct.superlu               --- Wrappers to SuperLU library
 direct.umfpack               --- Wrappers to UMFPACK library
 eigen.jdsym                  --- Jacobi davidson eigenvalue solver for symmetric matrices
 
Utility tools
-------------
::

 __version__       --- pysparse version string
"""


__docformat__ = 'restructuredtext'

try:
    from version import version as __version__
except ImportError:
    Warning("Run setup.py to generate version number.")
    __version__ = 'undefined'
    
from sparse import spmatrix

from pysparse.misc import Deprecated

class _superlu:
    @Deprecated('Use pysparse.direct.superlu.factorize instead.')
    def factorize(self, *args, **kwargs):
        import pysparse.direct.superlu
        self.factorizeFnc = pysparse.direct.superlu.factorize
        return self.factorizeFnc(*args, **kwargs)
    
superlu = _superlu()

__all__ = ['spmatrix', 'superlu', '__version__']
