/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.GBTRegressorWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.regression.GBTRegressor;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class GBTRegressorWrapper$
implements MLReadable<GBTRegressorWrapper> {
    public static final GBTRegressorWrapper$ MODULE$;

    static {
        new GBTRegressorWrapper$();
    }

    public GBTRegressorWrapper fit(Dataset<Row> data, String formula, int maxDepth, int maxBins, int maxIter, double stepSize, int minInstancesPerNode, double minInfoGain, int checkpointInterval, String lossType, String seed, double subsamplingRate, int maxMemoryInMB, boolean cacheNodeIds) {
        RFormula rFormula = new RFormula().setFormula(formula);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])Predef$.MODULE$.refArrayOps((Object[])featureAttrs).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$1) {
                return (String)x$1.name().get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        GBTRegressor rfr = (GBTRegressor)new GBTRegressor().setMaxDepth(maxDepth).setMaxBins(maxBins).setMaxIter(maxIter).setStepSize(stepSize).setMinInstancesPerNode(minInstancesPerNode).setMinInfoGain(minInfoGain).setCheckpointInterval(checkpointInterval).setLossType(lossType).setSubsamplingRate(subsamplingRate).setMaxMemoryInMB(maxMemoryInMB).setCacheNodeIds(cacheNodeIds).setFeaturesCol(rFormula.getFeaturesCol());
        Object object = seed != null && seed.length() > 0 ? rfr.setSeed(new StringOps(Predef$.MODULE$.augmentString(seed)).toLong()) : BoxedUnit.UNIT;
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, rfr})).fit((Dataset)data);
        return new GBTRegressorWrapper((PipelineModel)pipeline, formula, features);
    }

    @Override
    public MLReader<GBTRegressorWrapper> read() {
        return new GBTRegressorWrapper.GBTRegressorWrapperReader();
    }

    @Override
    public GBTRegressorWrapper load(String path) {
        return (GBTRegressorWrapper)MLReadable$class.load(this, path);
    }

    private GBTRegressorWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
    }
}

