/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.input.StreamInputFormat;
import org.apache.spark.rdd.BinaryFileRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.FailureSafeParser;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.json.MultiLineJsonDataSource$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.spark_project.guava.io.ByteStreams;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class MultiLineJsonDataSource$
extends JsonDataSource {
    public static final MultiLineJsonDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new MultiLineJsonDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        RDD<PortableDataStream> json = this.createBaseRdd(sparkSession, inputPaths, parsedOptions);
        RDD<PortableDataStream> sampled = JsonUtils$.MODULE$.sample(json, parsedOptions);
        Function2 parser = (Function2)parsedOptions.encoding().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<JsonFactory, PortableDataStream, JsonParser> apply(String enc) {
                return new Serializable(this, enc){
                    public static final long serialVersionUID = 0L;
                    private final String enc$3;

                    public final JsonParser apply(JsonFactory x$12, PortableDataStream x$13) {
                        return MultiLineJsonDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$createParser(this.enc$3, x$12, x$13);
                    }
                    {
                        this.enc$3 = enc$3;
                    }
                };
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<JsonFactory, PortableDataStream, JsonParser> apply() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonParser apply(JsonFactory x$14, PortableDataStream x$15) {
                        return MultiLineJsonDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$createParser(x$14, x$15);
                    }
                };
            }
        });
        return (StructType)SQLExecution$.MODULE$.withSQLConfPropagated(sparkSession, new Serializable(parsedOptions, sampled, parser){
            public static final long serialVersionUID = 0L;
            private final JSONOptions parsedOptions$2;
            private final RDD sampled$1;
            private final Function2 parser$2;

            public final StructType apply() {
                return JsonInferSchema$.MODULE$.infer(this.sampled$1, this.parsedOptions$2, this.parser$2);
            }
            {
                this.parsedOptions$2 = parsedOptions$2;
                this.sampled$1 = sampled$1;
                this.parser$2 = parser$2;
            }
        });
    }

    private RDD<PortableDataStream> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        Seq paths = (Seq)inputPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$16) {
                return x$16.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConfWithOptions((Map<String, String>)parsedOptions.parameters()));
        Configuration conf = job.getConfiguration();
        String name2 = paths.mkString(",");
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        return RDD$.MODULE$.rddToPairRDDFunctions(new BinaryFileRDD(sparkSession.sparkContext(), StreamInputFormat.class, String.class, PortableDataStream.class, conf, sparkSession.sparkContext().defaultMinPartitions()).setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JsonFile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2}))), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PortableDataStream.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    private InputStream dataToInputStream(PortableDataStream dataStream) {
        Path path = new Path(dataStream.getPath());
        return CodecStreams$.MODULE$.createInputStreamWithCloseResource(dataStream.getConfiguration(), path);
    }

    public JsonParser org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$createParser(JsonFactory jsonFactory, PortableDataStream stream) {
        return CreateJacksonParser$.MODULE$.inputStream(jsonFactory, this.dataToInputStream(stream));
    }

    public JsonParser org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$createParser(String enc, JsonFactory jsonFactory, PortableDataStream stream) {
        return CreateJacksonParser$.MODULE$.inputStream(enc, jsonFactory, this.dataToInputStream(stream));
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, JacksonParser parser, StructType schema2) {
        Function2 streamParser = (Function2)parser.options().encoding().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<JsonFactory, InputStream, JsonParser> apply(String enc) {
                return new Serializable(this, enc){
                    public static final long serialVersionUID = 0L;
                    private final String enc$4;

                    public final JsonParser apply(JsonFactory x$17, InputStream x$18) {
                        return CreateJacksonParser$.MODULE$.inputStream(this.enc$4, x$17, x$18);
                    }
                    {
                        this.enc$4 = enc$4;
                    }
                };
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function2<JsonFactory, InputStream, JsonParser> apply() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonParser apply(JsonFactory x$19, InputStream x$20) {
                        return CreateJacksonParser$.MODULE$.inputStream(x$19, x$20);
                    }
                };
            }
        });
        FailureSafeParser<InputStream> safeParser = new FailureSafeParser<InputStream>((Function1<InputStream, Seq<InternalRow>>)new Serializable(conf, file, parser, streamParser){
            public static final long serialVersionUID = 0L;
            public final Configuration conf$1;
            public final PartitionedFile file$1;
            private final JacksonParser parser$3;
            private final Function2 streamParser$1;

            public final Seq<InternalRow> apply(InputStream input) {
                return this.parser$3.parse((Object)input, this.streamParser$1, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.12 $outer;

                    public final UTF8String apply(Object ignored) {
                        return MultiLineJsonDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$partitionedFileString$1(ignored, this.$outer.conf$1, this.$outer.file$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
                this.file$1 = file$1;
                this.parser$3 = parser$3;
                this.streamParser$1 = streamParser$1;
            }
        }, parser.options().parseMode(), schema2, parser.options().columnNameOfCorruptRecord(), parser.options().multiLine());
        return safeParser.parse(CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf, new Path(new URI(file.filePath()))));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final UTF8String org$apache$spark$sql$execution$datasources$json$MultiLineJsonDataSource$$partitionedFileString$1(Object ignored, Configuration conf$1, PartitionedFile file$1) {
        return (UTF8String)Utils$.MODULE$.tryWithResource((Function0)new Serializable(conf$1, file$1){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;
            private final PartitionedFile file$1;

            public final InputStream apply() {
                return CodecStreams$.MODULE$.createInputStreamWithCloseResource(this.conf$1, new Path(new URI(this.file$1.filePath())));
            }
            {
                this.conf$1 = conf$1;
                this.file$1 = file$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UTF8String apply(InputStream inputStream) {
                return UTF8String.fromBytes((byte[])ByteStreams.toByteArray((InputStream)inputStream));
            }
        });
    }

    private MultiLineJsonDataSource$() {
        MODULE$ = this;
        this.isSplitable = false;
    }
}

