/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.DependencyUtils$;
import org.apache.spark.deploy.SparkSubmitUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class DependencyUtils$
implements Logging {
    public static final DependencyUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DependencyUtils$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public String resolveMavenDependencies(String packagesExclusions, String packages, String repositories, String ivyRepoPath, Option<String> ivySettingsPath) {
        Option<String> option;
        block4: {
            IvySettings ivySettings;
            Nil$ exclusions;
            block3: {
                block2: {
                    exclusions = StringUtils.isBlank((CharSequence)packagesExclusions) ? Nil$.MODULE$ : Predef$.MODULE$.wrapRefArray((Object[])packagesExclusions.split(","));
                    option = ivySettingsPath;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String path = (String)some.x();
                    ivySettings = SparkSubmitUtils$.MODULE$.loadIvySettings(path, (Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                ivySettings = SparkSubmitUtils$.MODULE$.buildIvySettings((Option<String>)Option$.MODULE$.apply((Object)repositories), (Option<String>)Option$.MODULE$.apply((Object)ivyRepoPath));
            }
            IvySettings ivySettings2 = ivySettings;
            return SparkSubmitUtils$.MODULE$.resolveMavenCoordinates(packages, ivySettings2, (Seq<String>)exclusions, SparkSubmitUtils$.MODULE$.resolveMavenCoordinates$default$4());
        }
        throw new MatchError(option);
    }

    public String resolveAndDownloadJars(String jars, String userJar, SparkConf sparkConf, Configuration hadoopConf, SecurityManager secMgr) {
        File targetDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        return (String)Option$.MODULE$.apply((Object)jars).map((Function1)new Serializable(userJar, hadoopConf){
            public static final long serialVersionUID = 0L;
            public final String userJar$1;
            private final Configuration hadoopConf$1;

            public final String apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])DependencyUtils$.MODULE$.resolveGlobPaths(x$1, this.hadoopConf$1).split(",")).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.resolveAndDownloadJars.1 $outer;

                    public final boolean apply(String x$2) {
                        return x$2.contains((CharSequence)Predef$.MODULE$.refArrayOps((Object[])this.$outer.userJar$1.split("/")).last());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).mkString(",");
            }
            {
                this.userJar$1 = userJar$1;
                this.hadoopConf$1 = hadoopConf$1;
            }
        }).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                String string = x$3;
                String string2 = "";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).map((Function1)new Serializable(sparkConf, hadoopConf, secMgr, targetDir){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final Configuration hadoopConf$1;
            private final SecurityManager secMgr$1;
            private final File targetDir$1;

            public final String apply(String x$4) {
                return DependencyUtils$.MODULE$.downloadFileList(x$4, this.targetDir$1, this.sparkConf$1, this.hadoopConf$1, this.secMgr$1);
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.hadoopConf$1 = hadoopConf$1;
                this.secMgr$1 = secMgr$1;
                this.targetDir$1 = targetDir$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public void addJarsToClassPath(String jars, MutableURLClassLoader loader) {
        if (jars != null) {
            Predef$.MODULE$.refArrayOps((Object[])jars.split(",")).foreach((Function1)new Serializable(loader){
                public static final long serialVersionUID = 0L;
                private final MutableURLClassLoader loader$1;

                public final void apply(String jar) {
                    DependencyUtils$.MODULE$.addJarToClasspath(jar, this.loader$1);
                }
                {
                    this.loader$1 = loader$1;
                }
            });
        }
    }

    public String downloadFileList(String fileList, File targetDir, SparkConf sparkConf, Configuration hadoopConf, SecurityManager secMgr) {
        Predef$.MODULE$.require(fileList != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "fileList cannot be null.";
            }
        });
        return ((TraversableOnce)Utils$.MODULE$.stringToSeq(fileList).map((Function1)new Serializable(targetDir, sparkConf, hadoopConf, secMgr){
            public static final long serialVersionUID = 0L;
            private final File targetDir$2;
            private final SparkConf sparkConf$2;
            private final Configuration hadoopConf$3;
            private final SecurityManager secMgr$2;

            public final String apply(String x$5) {
                return DependencyUtils$.MODULE$.downloadFile(x$5, this.targetDir$2, this.sparkConf$2, this.hadoopConf$3, this.secMgr$2);
            }
            {
                this.targetDir$2 = targetDir$2;
                this.sparkConf$2 = sparkConf$2;
                this.hadoopConf$3 = hadoopConf$3;
                this.secMgr$2 = secMgr$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public String downloadFile(String path, File targetDir, SparkConf sparkConf, Configuration hadoopConf, SecurityManager secMgr) {
        String string;
        Predef$.MODULE$.require(path != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "path cannot be null.";
            }
        });
        URI uri = Utils$.MODULE$.resolveURI(path);
        String string2 = uri.getScheme();
        boolean bl = "file".equals(string2) ? true : "local".equals(string2);
        if (bl) {
            string = path;
        } else {
            boolean bl2 = "http".equals(string2) ? true : ("https".equals(string2) ? true : "ftp".equals(string2));
            if (bl2 && Utils$.MODULE$.isTesting()) {
                File file = new File(uri.getPath());
                string = new File(targetDir, file.getName()).toURI().toString();
            } else {
                String fname = new Path(uri).getName();
                File localFile = Utils$.MODULE$.doFetchFile(uri.toString(), targetDir, fname, sparkConf, secMgr, hadoopConf);
                string = localFile.toURI().toString();
            }
        }
        return string;
    }

    public String resolveGlobPaths(String paths, Configuration hadoopConf) {
        Predef$.MODULE$.require(paths != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "paths cannot be null.";
            }
        });
        return ((TraversableOnce)Utils$.MODULE$.stringToSeq(paths).flatMap((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$2;

            public final ArrayOps<String> apply(String path) {
                Tuple2<URI, Option<String>> tuple2;
                block5: {
                    Tuple2 tuple22;
                    block8: {
                        ArrayOps arrayOps;
                        block7: {
                            block6: {
                                Tuple2 tuple23;
                                tuple2 = DependencyUtils$.MODULE$.org$apache$spark$deploy$DependencyUtils$$splitOnFragment(path);
                                if (tuple2 == null) break block5;
                                URI base = (URI)tuple2._1();
                                Option fragment = (Option)tuple2._2();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)base, (Object)fragment);
                                URI base2 = (URI)tuple24._1();
                                Option fragment2 = (Option)tuple24._2();
                                tuple22 = new Tuple2((Object)DependencyUtils$.MODULE$.org$apache$spark$deploy$DependencyUtils$$resolveGlobPath(base2, this.hadoopConf$2), (Object)fragment2);
                                if (tuple22 != null) {
                                    String[] resolved = (String[])tuple22._1();
                                    Option option = (Option)tuple22._2();
                                    if (option instanceof Some && resolved.length > 1) {
                                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " resolves ambiguously to multiple files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base2.toString(), Predef$.MODULE$.refArrayOps((Object[])resolved).mkString(",")})));
                                    }
                                }
                                if (tuple22 == null) break block6;
                                String[] resolved = (String[])tuple22._1();
                                Option option = (Option)tuple22._2();
                                if (!(option instanceof Some)) break block6;
                                Some some = (Some)option;
                                String namedAs = (String)some.x();
                                arrayOps = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])resolved).map((Function1)new Serializable(this, namedAs){
                                    public static final long serialVersionUID = 0L;
                                    private final String namedAs$1;

                                    public final String apply(String x$7) {
                                        return new StringBuilder().append((Object)x$7).append((Object)"#").append((Object)this.namedAs$1).toString();
                                    }
                                    {
                                        this.namedAs$1 = namedAs$1;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                                break block7;
                            }
                            if (tuple22 == null) break block8;
                            String[] resolved = (String[])tuple22._1();
                            arrayOps = Predef$.MODULE$.refArrayOps((Object[])resolved);
                        }
                        return arrayOps;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                this.hadoopConf$2 = hadoopConf$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public void addJarToClasspath(String localJar, MutableURLClassLoader loader) {
        URI uri = Utils$.MODULE$.resolveURI(localJar);
        String string = uri.getScheme();
        boolean bl = "file".equals(string) ? true : "local".equals(string);
        if (bl) {
            BoxedUnit boxedUnit;
            File file = new File(uri.getPath());
            if (file.exists()) {
                loader.addURL(file.toURI().toURL());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(file){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local jar ", " does not exist, skipping."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.logWarning((Function0<String>)new Serializable(uri){
                public static final long serialVersionUID = 0L;
                private final URI uri$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skip remote jar ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uri$2}));
                }
                {
                    this.uri$2 = uri$2;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String mergeFileLists(Seq<String> lists) {
        Seq merged = (Seq)((TraversableLike)lists.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CharSequence x$1) {
                return StringUtils.isBlank((CharSequence)x$1);
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String str) {
                return Utils$.MODULE$.stringToSeq(str);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return merged.nonEmpty() ? merged.mkString(",") : null;
    }

    public Tuple2<URI, Option<String>> org$apache$spark$deploy$DependencyUtils$$splitOnFragment(String path) {
        URI uri = Utils$.MODULE$.resolveURI(path);
        URI withoutFragment = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
        return new Tuple2((Object)withoutFragment, (Object)Option$.MODULE$.apply((Object)uri.getFragment()));
    }

    public String[] org$apache$spark$deploy$DependencyUtils$$resolveGlobPath(URI uri, Configuration hadoopConf) {
        String[] stringArray;
        String string = uri.getScheme();
        boolean bl = "local".equals(string) ? true : ("http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string)));
        if (bl) {
            stringArray = (String[])((Object[])new String[]{uri.toString()});
        } else {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConf);
            stringArray = (String[])Option$.MODULE$.apply((Object)fs.globStatus(new Path(uri))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String[] apply(FileStatus[] status) {
                    return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])status).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(FileStatus x$8) {
                            return x$8.isFile();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(FileStatus x$9) {
                            return x$9.getPath().toUri().toString();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                }
            }).getOrElse((Function0)new Serializable(uri){
                public static final long serialVersionUID = 0L;
                private final URI uri$1;

                public final String[] apply() {
                    return (String[])((Object[])new String[]{this.uri$1.toString()});
                }
                {
                    this.uri$1 = uri$1;
                }
            });
        }
        return stringArray;
    }

    private DependencyUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

