/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.PredictorParams$class;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.optim.aggregator.HuberAggregator;
import org.apache.spark.ml.optim.aggregator.LeastSquaresAggregator;
import org.apache.spark.ml.optim.loss.DifferentiableRegularization;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth$class;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasLoss$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.LinearRegression$;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionParams$class;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.Instrumentation$loggerTags$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0001\u0003\u00015\u0011\u0001\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002H\u0010&!\u0015y\u0001C\u0005\r\u001a\u001b\u0005\u0011\u0011BA\t\u0003\u0005%\u0011Vm\u001a:fgN|'\u000f\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u00051A.\u001b8bY\u001eL!a\u0006\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u00105%\u00111D\u0001\u0002\u0016\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tyQ$\u0003\u0002\u001f\u0005\t1B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c)be\u0006l7\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\t\u0005!Q\u000f^5m\u0013\t!\u0013EA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn],sSR\f'\r\\3\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!2\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005):#a\u0002'pO\u001eLgn\u001a\u0005\tY\u0001\u0011)\u0019!C![\u0005\u0019Q/\u001b3\u0016\u00039\u0002\"aL\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003iEB3aK\u001d@!\tQT(D\u0001<\u0015\tad!\u0001\u0006b]:|G/\u0019;j_:L!AP\u001e\u0003\u000bMKgnY3\"\u0003\u0001\u000bQ!\r\u00184]AB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0005k&$\u0007\u0005K\u0002Bs}BQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtDC\u0001\rH\u0011\u0015aC\t1\u0001/Q\r9\u0015h\u0010\u0015\u0004\tfz\u0004\"B#\u0001\t\u0003YE#\u0001\r)\u0007)KT*I\u0001O\u0003\u0015\td\u0006\u000e\u00181\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003-\u0019X\r\u001e*fOB\u000b'/Y7\u0015\u0005I\u001bV\"\u0001\u0001\t\u000bQ{\u0005\u0019A+\u0002\u000bY\fG.^3\u0011\u0005A2\u0016BA,2\u0005\u0019!u.\u001e2mK\"\u001aq*O \t\u000bi\u0003A\u0011A.\u0002\u001fM,GOR5u\u0013:$XM]2faR$\"A\u0015/\t\u000bQK\u0006\u0019A/\u0011\u0005Ar\u0016BA02\u0005\u001d\u0011un\u001c7fC:D3!W\u001dbC\u0005\u0011\u0017!B\u0019/k9\u0002\u0004\"\u00023\u0001\t\u0003)\u0017AE:fiN#\u0018M\u001c3be\u0012L'0\u0019;j_:$\"A\u00154\t\u000bQ\u001b\u0007\u0019A/)\u0007\rL\u0014\rC\u0003j\u0001\u0011\u0005!.\u0001\ntKR,E.Y:uS\u000etU\r\u001e)be\u0006lGC\u0001*l\u0011\u0015!\u0006\u000e1\u0001VQ\rA\u0017(\u0014\u0005\u0006]\u0002!\ta\\\u0001\u000bg\u0016$X*\u0019=Ji\u0016\u0014HC\u0001*q\u0011\u0015!V\u000e1\u0001r!\t\u0001$/\u0003\u0002tc\t\u0019\u0011J\u001c;)\u00075Lt\bC\u0003w\u0001\u0011\u0005q/\u0001\u0004tKR$v\u000e\u001c\u000b\u0003%bDQ\u0001V;A\u0002UC3!^\u001dN\u0011\u0015Y\b\u0001\"\u0001}\u00031\u0019X\r^,fS\u001eDGoQ8m)\t\u0011V\u0010C\u0003Uu\u0002\u0007a\u0006K\u0002{s}\f#!!\u0001\u0002\u000bErcG\f\u0019\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u0005I1/\u001a;T_24XM\u001d\u000b\u0004%\u0006%\u0001B\u0002+\u0002\u0004\u0001\u0007a\u0006\u000b\u0003\u0002\u0004ez\bbBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\u0014g\u0016$\u0018iZ4sK\u001e\fG/[8o\t\u0016\u0004H\u000f\u001b\u000b\u0004%\u0006M\u0001B\u0002+\u0002\u000e\u0001\u0007\u0011\u000fK\u0003\u0002\u000ee\n9\"\t\u0002\u0002\u001a\u0005)!GL\u0019/a!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011aB:fi2{7o\u001d\u000b\u0004%\u0006\u0005\u0002B\u0002+\u0002\u001c\u0001\u0007a\u0006K\u0003\u0002\u001ce\n)#\t\u0002\u0002(\u0005)!GL\u001a/a!9\u00111\u0006\u0001\u0005\u0002\u00055\u0012AC:fi\u0016\u00038/\u001b7p]R\u0019!+a\f\t\rQ\u000bI\u00031\u0001VQ\u0015\tI#OA\u0013\u0011\u001d\t)\u0004\u0001C)\u0003o\tQ\u0001\u001e:bS:$2!GA\u001d\u0011!\tY$a\rA\u0002\u0005u\u0012a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u007f\ty\u0005\u0005\u0004\u0002B\u0005\u001d\u00131J\u0007\u0003\u0003\u0007R1!!\u0012\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u0013\n\u0019EA\u0004ECR\f7/\u001a;\u0011\t\u00055\u0013q\n\u0007\u0001\t1\t\t&!\u000f\u0002\u0002\u0003\u0005)\u0011AA*\u0005\ryF%M\t\u0005\u0003+\nY\u0006E\u00021\u0003/J1!!\u00172\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001MA/\u0013\r\ty&\r\u0002\u0004\u0003:L\bbBA2\u0001\u0011\u0005\u0013QM\u0001\u0005G>\u0004\u0018\u0010F\u0002\u0019\u0003OB\u0001\"!\u001b\u0002b\u0001\u0007\u00111N\u0001\u0006Kb$(/\u0019\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011\u000f\u0003\u0002\u000bA\f'/Y7\n\t\u0005U\u0014q\u000e\u0002\t!\u0006\u0014\u0018-\\'ba\"\"\u0011\u0011M\u001dNQ\r\u0001\u0011hP\u0004\b\u0003{\u0012\u0001\u0012AA@\u0003Aa\u0015N\\3beJ+wM]3tg&|g\u000eE\u0002\u0010\u0003\u00033a!\u0001\u0002\t\u0002\u0005\r5\u0003CAA\u0003\u000b\u000bY)!%\u0011\u0007A\n9)C\u0002\u0002\nF\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0011\u0002\u000ebI1!a$\"\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042\u0001MAJ\u0013\r\t)*\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u000b\u0006\u0005E\u0011AAM)\t\ty\b\u0003\u0005\u0002\u001e\u0006\u0005E\u0011IAP\u0003\u0011aw.\u00193\u0015\u0007a\t\t\u000bC\u0004\u0002$\u0006m\u0005\u0019\u0001\u0018\u0002\tA\fG\u000f\u001b\u0015\u0005\u00037Kt\u0010\u0003\u0006\u0002*\u0006\u0005%\u0019!C\u0001\u0003W\u000ba$T!Y?\u001a+\u0015\tV+S\u000bN{fi\u0014*`\u001d>\u0013V*\u0011'`'>ce+\u0012*\u0016\u0003EDS!a*:\u0003/A\u0001\"!-\u0002\u0002\u0002\u0006I!]\u0001 \u001b\u0006CvLR#B)V\u0013ViU0G\u001fJ{fj\u0014*N\u00032{6k\u0014'W\u000bJ\u0003\u0003&BAXs\u0005]\u0001bCA\\\u0003\u0003\u0013\r\u0011\"\u0001\u0003\u0003s\u000bA!Q;u_V\u0011\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0017\u0001\u00026bm\u0006L1ANA`\u0011%\tY-!!!\u0002\u0013\tY,A\u0003BkR|\u0007\u0005C\u0006\u0002P\u0006\u0005%\u0019!C\u0001\u0005\u0005e\u0016A\u0002(pe6\fG\u000eC\u0005\u0002T\u0006\u0005\u0005\u0015!\u0003\u0002<\u00069aj\u001c:nC2\u0004\u0003bCAl\u0003\u0003\u0013\r\u0011\"\u0001\u0003\u0003s\u000bQ\u0001\u0014\"G\u000fNC\u0011\"a7\u0002\u0002\u0002\u0006I!a/\u0002\r1\u0013eiR*!\u0011-\ty.!!C\u0002\u0013\u0005!!!9\u0002!M,\b\u000f]8si\u0016$7k\u001c7wKJ\u001cXCAAr!\u0015\u0001\u0014Q]A^\u0013\r\t9/\r\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0003W\f\t\t)A\u0005\u0003G\f\u0011c];qa>\u0014H/\u001a3T_24XM]:!\u0011-\ty/!!C\u0002\u0013\u0005!!!/\u0002\u0019M\u000bX/\u0019:fI\u0016\u0013(o\u001c:\t\u0013\u0005M\u0018\u0011\u0011Q\u0001\n\u0005m\u0016!D*rk\u0006\u0014X\rZ#se>\u0014\b\u0005C\u0006\u0002x\u0006\u0005%\u0019!C\u0001\u0005\u0005e\u0016!\u0002%vE\u0016\u0014\b\"CA~\u0003\u0003\u0003\u000b\u0011BA^\u0003\u0019AUOY3sA!Y\u0011q`AA\u0005\u0004%\tAAAq\u0003=\u0019X\u000f\u001d9peR,G\rT8tg\u0016\u001c\b\"\u0003B\u0002\u0003\u0003\u0003\u000b\u0011BAr\u0003A\u0019X\u000f\u001d9peR,G\rT8tg\u0016\u001c\b\u0005\u0003\u0006\u0003\b\u0005\u0005\u0015\u0011!C\u0005\u0005\u0013\t1B]3bIJ+7o\u001c7wKR\u0011!1\u0002\t\u0005\u0003{\u0013i!\u0003\u0003\u0003\u0010\u0005}&AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002\u0002fz\b\u0006BA>s}\u0004")
public class LinearRegression
extends Regressor<Vector, LinearRegression, LinearRegressionModel>
implements LinearRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> solver;
    private final Param<String> loss;
    private final DoubleParam epsilon;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static MLReader<LinearRegression> read() {
        return LinearRegression$.MODULE$.read();
    }

    public static int MAX_FEATURES_FOR_NORMAL_SOLVER() {
        return LinearRegression$.MODULE$.MAX_FEATURES_FOR_NORMAL_SOLVER();
    }

    public static LinearRegression load(String string) {
        return LinearRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams$class.getEpsilon(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param x$1) {
    }

    @Override
    public final String getLoss() {
        return HasLoss$class.getLoss(this);
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth$class.getAggregationDepth(this);
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearRegression setRegParam(double value) {
        return (LinearRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setFitIntercept(boolean value) {
        return (LinearRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setStandardization(boolean value) {
        return (LinearRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setElasticNetParam(double value) {
        return (LinearRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxIter(int value) {
        return (LinearRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setTol(double value) {
        return (LinearRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setWeightCol(String value) {
        return (LinearRegression)this.set(this.weightCol(), value);
    }

    public LinearRegression setSolver(String value) {
        return (LinearRegression)this.set(this.solver(), value);
    }

    public LinearRegression setAggregationDepth(int value) {
        return (LinearRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setLoss(String value) {
        return (LinearRegression)this.set(this.loss(), value);
    }

    public LinearRegression setEpsilon(double value) {
        return (LinearRegression)this.set(this.epsilon(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LinearRegressionModel train(Dataset<?> dataset) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            LinearRegressionModel linearRegressionModel;
            Object object = new Object();
            try {
                linearRegressionModel = (LinearRegressionModel)Instrumentation$.MODULE$.instrumented(new Serializable(this, dataset, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LinearRegression $outer;
                    private final Dataset dataset$1;
                    private final Object nonLocalReturnKey1$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final LinearRegressionModel apply(Instrumentation instr) {
                        Tuple2 tuple2;
                        Tuple4 tuple4;
                        double d;
                        double d2;
                        double d3;
                        double[] dArray;
                        Vector vector;
                        LBFGS lBFGS;
                        RDDLossFunction<T, Agg> rDDLossFunction;
                        None$ none$;
                        double d4;
                        Tuple2 tuple22;
                        RDD instances;
                        int numFeatures;
                        block33: {
                            Tuple2 tuple23;
                            block34: {
                                numFeatures = ((Vector)((Row)this.dataset$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$outer.$(this.$outer.featuresCol()))})).first()).getAs(0)).size();
                                Column w2 = this.$outer.isDefined(this.$outer.weightCol()) && !this.$outer.$(this.$outer.weightCol()).isEmpty() ? functions$.MODULE$.col(this.$outer.$(this.$outer.weightCol())) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
                                instances = this.dataset$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$outer.$(this.$outer.labelCol())), w2, functions$.MODULE$.col(this.$outer.$(this.$outer.featuresCol()))})).rdd().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Instance apply(Row x0$1) {
                                        Row row = x0$1;
                                        Some some = Row$.MODULE$.unapplySeq(row);
                                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                                            Object label = ((SeqLike)some.get()).apply(0);
                                            Object weight = ((SeqLike)some.get()).apply(1);
                                            Object features = ((SeqLike)some.get()).apply(2);
                                            if (label instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)label);
                                                if (weight instanceof Double) {
                                                    double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                                                    if (features instanceof Vector) {
                                                        Vector vector = (Vector)features;
                                                        Instance instance = new Instance(d, d2, vector);
                                                        return instance;
                                                    }
                                                }
                                            }
                                        }
                                        throw new MatchError((Object)row);
                                    }
                                }, ClassTag$.MODULE$.apply(Instance.class));
                                instr.logPipelineStage(this.$outer);
                                instr.logDataset(this.dataset$1);
                                instr.logParams(this.$outer, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.$outer.labelCol(), this.$outer.featuresCol(), this.$outer.weightCol(), this.$outer.predictionCol(), this.$outer.solver(), this.$outer.tol(), this.$outer.elasticNetParam(), this.$outer.fitIntercept(), this.$outer.maxIter(), this.$outer.regParam(), this.$outer.standardization(), this.$outer.aggregationDepth(), this.$outer.loss(), this.$outer.epsilon()}));
                                instr.logNumFeatures(numFeatures);
                                String string = this.$outer.$(this.$outer.loss());
                                String string2 = LinearRegression$.MODULE$.SquaredError();
                                if (string != null ? !string.equals(string2) : string2 != null) break block33;
                                String string3 = this.$outer.$(this.$outer.solver());
                                String string4 = LinearRegression$.MODULE$.Auto();
                                if (!(string3 != null ? !string3.equals(string4) : string4 != null) && numFeatures <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()) break block34;
                                String string5 = this.$outer.$(this.$outer.solver());
                                String string6 = LinearRegression$.MODULE$.Normal();
                                if (string5 != null ? !string5.equals(string6) : string6 != null) break block33;
                            }
                            WeightedLeastSquares optimizer = new WeightedLeastSquares(BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.regParam())), BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.elasticNetParam())), BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.standardization())), true, WeightedLeastSquares$Auto$.MODULE$, BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.maxIter())), BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.tol())));
                            WeightedLeastSquaresModel model = optimizer.fit((RDD<Instance>)instances, OptionalInstrumentation$.MODULE$.create(instr));
                            LinearRegressionModel lrModel = this.$outer.copyValues(new LinearRegressionModel(this.$outer.uid(), (Vector)model.coefficients(), model.intercept()), this.$outer.copyValues$default$2());
                            Tuple2<LinearRegressionModel, String> tuple24 = lrModel.findSummaryModelAndPredictionCol();
                            if (tuple24 == null) throw new MatchError(tuple24);
                            LinearRegressionModel summaryModel = (LinearRegressionModel)tuple24._1();
                            String predictionColName = (String)tuple24._2();
                            Tuple2 tuple25 = tuple23 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                            LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple25._1();
                            String predictionColName2 = (String)tuple25._2();
                            LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel2.transform(this.dataset$1), predictionColName2, this.$outer.$(this.$outer.labelCol()), this.$outer.$(this.$outer.featuresCol()), summaryModel2, model.diagInvAtWA().toArray(), model.objectiveHistory());
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)lrModel.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary)));
                        }
                        StorageLevel storageLevel = this.dataset$1.storageLevel();
                        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
                        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
                        Serializable seqOp = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c, Instance instance) {
                                return new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultivariateOnlineSummarizer)c._2()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(Vectors$.MODULE$.dense(instance.label(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), instance.weight()));
                            }
                        };
                        Serializable combOp = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c2) {
                                return new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultivariateOnlineSummarizer)c1._2()).merge((MultivariateOnlineSummarizer)c2._2()));
                            }
                        };
                        Tuple2 tuple26 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultivariateOnlineSummarizer()), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
                        if (tuple26 == null) throw new MatchError((Object)tuple26);
                        MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)tuple26._1();
                        MultivariateOnlineSummarizer ySummarizer = (MultivariateOnlineSummarizer)tuple26._2();
                        Tuple2 tuple27 = tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
                        MultivariateOnlineSummarizer featuresSummarizer2 = (MultivariateOnlineSummarizer)tuple27._1();
                        MultivariateOnlineSummarizer ySummarizer2 = (MultivariateOnlineSummarizer)tuple27._2();
                        double yMean = ySummarizer2.mean().apply(0);
                        double rawYStd = package$.MODULE$.sqrt(ySummarizer2.variance().apply(0));
                        instr.logNumExamples(ySummarizer2.count());
                        instr.logNamedValue(Instrumentation$loggerTags$.MODULE$.meanOfLabels(), yMean);
                        instr.logNamedValue(Instrumentation$loggerTags$.MODULE$.varianceOfLabels(), rawYStd);
                        if (rawYStd == 0.0) {
                            if (BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept())) || yMean == 0.0) {
                                Tuple2 tuple28;
                                if (yMean == 0.0) {
                                    instr.logWarning((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mean and standard deviation of the label are zero, so the "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients and the intercept will all be zero; as a result, training is not "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"needed."})).s((Seq)Nil$.MODULE$)).toString();
                                        }
                                    });
                                } else {
                                    instr.logWarning((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero, so the coefficients "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"will be zeros and the intercept will be the mean of the label; as a result, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                                        }
                                    });
                                }
                                Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                                Vector coefficients2 = Vectors$.MODULE$.sparse(numFeatures, (Seq)Seq$.MODULE$.empty());
                                double intercept = yMean;
                                LinearRegressionModel model = this.$outer.copyValues(new LinearRegressionModel(this.$outer.uid(), coefficients2, intercept), this.$outer.copyValues$default$2());
                                Tuple2<LinearRegressionModel, String> tuple29 = model.findSummaryModelAndPredictionCol();
                                if (tuple29 == null) throw new MatchError(tuple29);
                                LinearRegressionModel summaryModel = (LinearRegressionModel)tuple29._1();
                                String predictionColName = (String)tuple29._2();
                                Tuple2 tuple210 = tuple28 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                                LinearRegressionModel summaryModel3 = (LinearRegressionModel)tuple210._1();
                                String predictionColName3 = (String)tuple210._2();
                                LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel3.transform(this.dataset$1), predictionColName3, this.$outer.$(this.$outer.labelCol()), this.$outer.$(this.$outer.featuresCol()), model, new double[]{0.0}, new double[]{0.0});
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)model.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary)));
                            }
                            Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.regParam())) == 0.0, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "The standard deviation of the label is zero. Model cannot be regularized.";
                                }
                            });
                            instr.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero. "})).s((Seq)Nil$.MODULE$)).append((Object)"Consider setting fitIntercept=true.").toString();
                                }
                            });
                        }
                        double yStd = rawYStd > 0.0 ? rawYStd : package$.MODULE$.abs(yMean);
                        double[] featuresMean = featuresSummarizer2.mean().toArray();
                        double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x) {
                                return this.apply$mcDD$sp(x);
                            }

                            public double apply$mcDD$sp(double x) {
                                return package$.MODULE$.sqrt(x);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                        Broadcast bcFeaturesMean = instances.context().broadcast((Object)featuresMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                        Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                        if (!BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)new Serializable(this, featuresMean, featuresStd){
                            public static final long serialVersionUID = 0L;
                            private final double[] featuresMean$1;
                            private final double[] featuresStd$1;

                            public final boolean apply(int i) {
                                return this.apply$mcZI$sp(i);
                            }

                            public boolean apply$mcZI$sp(int i) {
                                return this.featuresStd$1[i] == 0.0 && this.featuresMean$1[i] != 0.0;
                            }
                            {
                                this.featuresMean$1 = featuresMean$1;
                                this.featuresStd$1 = featuresStd$1;
                            }
                        })) {
                            instr.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Fitting LinearRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.";
                                }
                            });
                        }
                        String string = this.$outer.$(this.$outer.loss());
                        String string7 = LinearRegression$.MODULE$.SquaredError();
                        String string8 = string;
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            d4 = BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.regParam())) / yStd;
                        } else {
                            String string9 = LinearRegression$.MODULE$.Huber();
                            String string10 = string;
                            if (string9 != null ? !string9.equals(string10) : string10 != null) throw new MatchError((Object)string);
                            d4 = BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.regParam()));
                        }
                        double effectiveRegParam = d4;
                        double effectiveL1RegParam = BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.elasticNetParam())) * effectiveRegParam;
                        double effectiveL2RegParam = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.elasticNetParam()))) * effectiveRegParam;
                        Serializable getFeaturesStd = new Serializable(this, numFeatures, featuresStd){
                            public static final long serialVersionUID = 0L;
                            private final int numFeatures$1;
                            private final double[] featuresStd$1;

                            public final double apply(int j) {
                                return this.apply$mcDI$sp(j);
                            }

                            public double apply$mcDI$sp(int j) {
                                return j >= 0 && j < this.numFeatures$1 ? this.featuresStd$1[j] : 0.0;
                            }
                            {
                                this.numFeatures$1 = numFeatures$1;
                                this.featuresStd$1 = featuresStd$1;
                            }
                        };
                        if (effectiveL2RegParam != 0.0) {
                            Serializable shouldApply = new Serializable(this, numFeatures){
                                public static final long serialVersionUID = 0L;
                                private final int numFeatures$1;

                                public final boolean apply(int idx) {
                                    return this.apply$mcZI$sp(idx);
                                }

                                public boolean apply$mcZI$sp(int idx) {
                                    return idx >= 0 && idx < this.numFeatures$1;
                                }
                                {
                                    this.numFeatures$1 = numFeatures$1;
                                }
                            };
                            none$ = new Some((Object)new L2Regularization(effectiveL2RegParam, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                        } else {
                            none$ = None$.MODULE$;
                        }
                        None$ regularization = none$;
                        String string11 = this.$outer.$(this.$outer.loss());
                        String string12 = LinearRegression$.MODULE$.SquaredError();
                        String string13 = string11;
                        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                            Serializable getAggregatorFunc = new Serializable(this, yMean, yStd, bcFeaturesMean, bcFeaturesStd){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$train$1 $outer;
                                private final double yMean$1;
                                private final double yStd$1;
                                private final Broadcast bcFeaturesMean$1;
                                private final Broadcast bcFeaturesStd$1;

                                public final LeastSquaresAggregator apply(Broadcast<Vector> x$4) {
                                    return new LeastSquaresAggregator(this.yStd$1, this.yMean$1, BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$spark$ml$regression$LinearRegression$$anonfun$$$outer().$(this.$outer.org$apache$spark$ml$regression$LinearRegression$$anonfun$$$outer().fitIntercept())), (Broadcast<double[]>)this.bcFeaturesStd$1, (Broadcast<double[]>)this.bcFeaturesMean$1, x$4);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.yMean$1 = yMean$1;
                                    this.yStd$1 = yStd$1;
                                    this.bcFeaturesMean$1 = bcFeaturesMean$1;
                                    this.bcFeaturesStd$1 = bcFeaturesStd$1;
                                }
                            };
                            rDDLossFunction = new RDDLossFunction<T, Agg>(instances, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)regularization, BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.aggregationDepth())), ClassTag$.MODULE$.apply(Instance.class), ClassTag$.MODULE$.apply(LeastSquaresAggregator.class));
                        } else {
                            String string14 = LinearRegression$.MODULE$.Huber();
                            String string15 = string11;
                            if (string14 != null ? !string14.equals(string15) : string15 != null) throw new MatchError((Object)string11);
                            Serializable getAggregatorFunc = new Serializable(this, bcFeaturesStd){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$train$1 $outer;
                                private final Broadcast bcFeaturesStd$1;

                                public final HuberAggregator apply(Broadcast<Vector> x$5) {
                                    return new HuberAggregator(BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$spark$ml$regression$LinearRegression$$anonfun$$$outer().$(this.$outer.org$apache$spark$ml$regression$LinearRegression$$anonfun$$$outer().fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$ml$regression$LinearRegression$$anonfun$$$outer().$(this.$outer.org$apache$spark$ml$regression$LinearRegression$$anonfun$$$outer().epsilon())), (Broadcast<double[]>)this.bcFeaturesStd$1, x$5);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.bcFeaturesStd$1 = bcFeaturesStd$1;
                                }
                            };
                            rDDLossFunction = new RDDLossFunction<T, Agg>(instances, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)regularization, BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.aggregationDepth())), ClassTag$.MODULE$.apply(Instance.class), ClassTag$.MODULE$.apply(HuberAggregator.class));
                        }
                        RDDLossFunction<T, Agg> costFun = rDDLossFunction;
                        String string16 = this.$outer.$(this.$outer.loss());
                        String string17 = LinearRegression$.MODULE$.SquaredError();
                        String string18 = string16;
                        if (!(string17 != null ? !string17.equals(string18) : string18 != null)) {
                            LBFGS lBFGS2;
                            if (BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.elasticNetParam())) == 0.0 || effectiveRegParam == 0.0) {
                                lBFGS2 = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
                            } else {
                                boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.standardization()));
                                lBFGS2 = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.maxIter())), 10, this.effectiveL1RegFun$1(featuresStd, effectiveL1RegParam, standardizationParam), BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
                            }
                            lBFGS = lBFGS2;
                        } else {
                            String string19 = LinearRegression$.MODULE$.Huber();
                            String string20 = string16;
                            if (string19 != null ? !string19.equals(string20) : string20 != null) throw new MatchError((Object)string16);
                            int dim = BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept())) ? numFeatures + 2 : numFeatures + 1;
                            DenseVector lowerBounds = DenseVector$.MODULE$.apply(Array$.MODULE$.fill(dim, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply() {
                                    return this.apply$mcD$sp();
                                }

                                public double apply$mcD$sp() {
                                    return Double$.MODULE$.MinValue();
                                }
                            }, ClassTag$.MODULE$.Double()));
                            lowerBounds.update$mcD$sp(dim - 1, Double.MIN_VALUE);
                            DenseVector upperBounds = DenseVector$.MODULE$.apply(Array$.MODULE$.fill(dim, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply() {
                                    return this.apply$mcD$sp();
                                }

                                public double apply$mcD$sp() {
                                    return Double.MAX_VALUE;
                                }
                            }, ClassTag$.MODULE$.Double()));
                            lBFGS = new LBFGSB(lowerBounds, upperBounds, BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7());
                        }
                        LBFGS optimizer = lBFGS;
                        String string21 = this.$outer.$(this.$outer.loss());
                        String string22 = LinearRegression$.MODULE$.SquaredError();
                        String string23 = string21;
                        if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                            vector = Vectors$.MODULE$.zeros(numFeatures);
                        } else {
                            String string24 = LinearRegression$.MODULE$.Huber();
                            String string25 = string21;
                            if (string24 != null ? !string24.equals(string25) : string25 != null) throw new MatchError((Object)string21);
                            int dim = BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept())) ? numFeatures + 2 : numFeatures + 1;
                            vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(dim, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply() {
                                    return this.apply$mcD$sp();
                                }

                                public double apply$mcD$sp() {
                                    return 1.0;
                                }
                            }, ClassTag$.MODULE$.Double()));
                        }
                        Vector initialValues = vector;
                        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialValues.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
                        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                        FirstOrderMinimizer.State state = null;
                        while (states.hasNext()) {
                            state = (FirstOrderMinimizer.State)states.next();
                            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
                        }
                        if (state == null) {
                            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                            instr.logError((Function0<String>)new Serializable(this, msg){
                                public static final long serialVersionUID = 0L;
                                private final String msg$1;

                                public final String apply() {
                                    return this.msg$1;
                                }
                                {
                                    this.msg$1 = msg$1;
                                }
                            });
                            throw new SparkException(msg);
                        }
                        bcFeaturesMean.destroy(false);
                        bcFeaturesStd.destroy(false);
                        double[] parameters = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
                        String string26 = this.$outer.$(this.$outer.loss());
                        String string27 = LinearRegression$.MODULE$.SquaredError();
                        String string28 = string26;
                        if (!(string27 != null ? !string27.equals(string28) : string28 != null)) {
                            dArray = parameters;
                        } else {
                            String string29 = LinearRegression$.MODULE$.Huber();
                            String string30 = string26;
                            if (string29 != null ? !string29.equals(string30) : string30 != null) throw new MatchError((Object)string26);
                            dArray = (double[])Predef$.MODULE$.doubleArrayOps(parameters).slice(0, numFeatures);
                        }
                        double[] rawCoefficients = dArray;
                        int i = 0;
                        int len = rawCoefficients.length;
                        String string31 = this.$outer.$(this.$outer.loss());
                        String string32 = LinearRegression$.MODULE$.SquaredError();
                        String string33 = string31;
                        if (!(string32 != null ? !string32.equals(string33) : string33 != null)) {
                            d3 = yStd;
                        } else {
                            String string34 = LinearRegression$.MODULE$.Huber();
                            String string35 = string31;
                            if (string34 != null ? !string34.equals(string35) : string35 != null) throw new MatchError((Object)string31);
                            d3 = 1.0;
                        }
                        double multiplier = d3;
                        while (i < len) {
                            int n = i;
                            rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i] != 0.0 ? multiplier / featuresStd[i] : 0.0);
                            ++i;
                        }
                        if (BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept()))) {
                            double d5;
                            String string36 = this.$outer.$(this.$outer.loss());
                            String string37 = LinearRegression$.MODULE$.SquaredError();
                            String string38 = string36;
                            if (!(string37 != null ? !string37.equals(string38) : string38 != null)) {
                                d5 = yMean - BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(rawCoefficients), Vectors$.MODULE$.dense(featuresMean));
                            } else {
                                String string39 = LinearRegression$.MODULE$.Huber();
                                String string40 = string36;
                                if (string39 != null ? !string39.equals(string40) : string40 != null) throw new MatchError((Object)string36);
                                d5 = parameters[numFeatures];
                            }
                            d2 = d5;
                        } else {
                            d2 = 0.0;
                        }
                        double interceptValue = d2;
                        String string41 = this.$outer.$(this.$outer.loss());
                        String string42 = LinearRegression$.MODULE$.SquaredError();
                        String string43 = string41;
                        if (!(string42 != null ? !string42.equals(string43) : string43 != null)) {
                            d = 1.0;
                        } else {
                            String string44 = LinearRegression$.MODULE$.Huber();
                            String string45 = string41;
                            if (string44 != null ? !string44.equals(string45) : string45 != null) throw new MatchError((Object)string41);
                            d = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(parameters).last());
                        }
                        double scaleValue = d;
                        Tuple4 tuple42 = new Tuple4((Object)Vectors$.MODULE$.dense(rawCoefficients).compressed(), (Object)BoxesRunTime.boxToDouble((double)interceptValue), (Object)BoxesRunTime.boxToDouble((double)scaleValue), arrayBuilder.result());
                        if (tuple42 == null) throw new MatchError((Object)tuple42);
                        Vector coefficients3 = (Vector)tuple42._1();
                        double intercept = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                        double scale = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                        double[] objectiveHistory = (double[])tuple42._4();
                        Tuple4 tuple43 = tuple4 = new Tuple4((Object)coefficients3, (Object)BoxesRunTime.boxToDouble((double)intercept), (Object)BoxesRunTime.boxToDouble((double)scale), (Object)objectiveHistory);
                        Vector coefficients4 = (Vector)tuple43._1();
                        double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                        double scale2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
                        double[] objectiveHistory2 = (double[])tuple43._4();
                        Object object3 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                        LinearRegressionModel model = this.$outer.copyValues(new LinearRegressionModel(this.$outer.uid(), coefficients4, intercept2, scale2), this.$outer.copyValues$default$2());
                        Tuple2<LinearRegressionModel, String> tuple211 = model.findSummaryModelAndPredictionCol();
                        if (tuple211 == null) throw new MatchError(tuple211);
                        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple211._1();
                        String predictionColName = (String)tuple211._2();
                        Tuple2 tuple212 = tuple2 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                        LinearRegressionModel summaryModel4 = (LinearRegressionModel)tuple212._1();
                        String predictionColName4 = (String)tuple212._2();
                        LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel4.transform(this.dataset$1), predictionColName4, this.$outer.$(this.$outer.labelCol()), this.$outer.$(this.$outer.featuresCol()), model, new double[]{0.0}, objectiveHistory2);
                        return model.setSummary((Option<LinearRegressionTrainingSummary>)new Some((Object)trainingSummary));
                    }

                    public /* synthetic */ LinearRegression org$apache$spark$ml$regression$LinearRegression$$anonfun$$$outer() {
                        return this.$outer;
                    }

                    private final Function1 effectiveL1RegFun$1(double[] featuresStd$1, double effectiveL1RegParam$1, boolean standardizationParam$1) {
                        return new Serializable(this, featuresStd$1, effectiveL1RegParam$1, standardizationParam$1){
                            public static final long serialVersionUID = 0L;
                            private final double[] featuresStd$1;
                            private final double effectiveL1RegParam$1;
                            private final boolean standardizationParam$1;

                            public final double apply(int index2) {
                                return this.apply$mcDI$sp(index2);
                            }

                            public double apply$mcDI$sp(int index2) {
                                return this.standardizationParam$1 ? this.effectiveL1RegParam$1 : (this.featuresStd$1[index2] != 0.0 ? this.effectiveL1RegParam$1 / this.featuresStd$1[index2] : 0.0);
                            }
                            {
                                this.featuresStd$1 = featuresStd$1;
                                this.effectiveL1RegParam$1 = effectiveL1RegParam$1;
                                this.standardizationParam$1 = standardizationParam$1;
                            }
                        };
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dataset$1 = dataset$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                linearRegressionModel = (LinearRegressionModel)nonLocalReturnControl2.value();
            }
            return linearRegressionModel;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public LinearRegression copy(ParamMap extra) {
        return (LinearRegression)this.defaultCopy(extra);
    }

    public LinearRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        HasAggregationDepth$class.$init$(this);
        HasLoss$class.$init$(this);
        LinearRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.solver().$minus$greater(LinearRegression$.MODULE$.Auto())}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.loss().$minus$greater(LinearRegression$.MODULE$.SquaredError())}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.epsilon().$minus$greater(BoxesRunTime.boxToDouble((double)1.35))}));
    }

    public LinearRegression() {
        this(Identifiable$.MODULE$.randomUID("linReg"));
    }
}

