/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.LSHParams;
import org.apache.spark.ml.feature.LSHParams$class;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t}baB\u0001\u0003\u0003\u0003!AB\u0005\u0002\t\u0019NCUj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014x-\u0006\u0002\u000e)M!\u0001A\u0004\u0011$!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'Qa\u0001\u0001B\u0003\u0016\u0001\t\u0007qCA\u0001U\u0007\u0001\t\"\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000f9{G\u000f[5oOB\u0019q\u0004\u0001\n\u000e\u0003\t\u0001\"aH\u0011\n\u0005\t\u0012!!\u0003'T\u0011B\u000b'/Y7t!\t!s%D\u0001&\u0015\t1C!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003yAQ!\f\u0001\u0005\u00029\n1b]3u\u0013:\u0004X\u000f^\"pYR\u0011q\u0006M\u0007\u0002\u0001!)\u0011\u0007\fa\u0001e\u0005)a/\u00197vKB\u00111G\u000e\b\u00033QJ!!\u000e\u000e\u0002\rA\u0013X\rZ3g\u0013\t9\u0004H\u0001\u0004TiJLgn\u001a\u0006\u0003kiAQA\u000f\u0001\u0005\u0002m\nAb]3u\u001fV$\b/\u001e;D_2$\"a\f\u001f\t\u000bEJ\u0004\u0019\u0001\u001a\t\ry\u0002a\u0011\u0003\u0003@\u00031A\u0017m\u001d5Gk:\u001cG/[8o)\t\u0001\u0015\nE\u0002\u001a\u0003\u000eK!A\u0011\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019#\u0011A\u00027j]\u0006dw-\u0003\u0002I\u000b\n1a+Z2u_JDQAS\u001fA\u0002\r\u000bQ!\u001a7f[NDa\u0001\u0014\u0001\u0007\u0012\u0011i\u0015aC6fs\u0012K7\u000f^1oG\u0016$2AT)T!\tIr*\u0003\u0002Q5\t1Ai\\;cY\u0016DQAU&A\u0002\r\u000b\u0011\u0001\u001f\u0005\u0006).\u0003\raQ\u0001\u0002s\"1a\u000b\u0001D\t\t]\u000bA\u0002[1tQ\u0012K7\u000f^1oG\u0016$2A\u0014-f\u0011\u0015\u0011V\u000b1\u0001Z!\rQ&m\u0011\b\u00037\u0002t!\u0001X0\u000e\u0003uS!A\u0018\f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012BA1\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0007M+\u0017O\u0003\u0002b5!)A+\u0016a\u00013\")q\r\u0001C!Q\u0006IAO]1og\u001a|'/\u001c\u000b\u0003Sf\u0004\"A\u001b<\u000f\u0005-$hB\u00017s\u001d\ti\u0017O\u0004\u0002oa:\u0011Al\\\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!a\u001d\u0004\u0002\u0007M\fH.\u0003\u0002bk*\u00111OB\u0005\u0003ob\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005\u0005,\b\"\u0002>g\u0001\u0004Y\u0018a\u00023bi\u0006\u001cX\r\u001e\u0019\u0004y\u0006\r\u0001\u0003B?\u007f\u0003\u0003i\u0011!^\u0005\u0003\u007fV\u0014q\u0001R1uCN,G\u000fE\u0002\u0014\u0003\u0007!1\"!\u0002z\u0003\u0003\u0005\tQ!\u0001\u0002\b\t\u0019q\fJ\u0019\u0012\u0007a\tI\u0001E\u0002\u001a\u0003\u0017I1!!\u0004\u001b\u0005\r\te.\u001f\u0005\b\u0003#\u0001A\u0011IA\n\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\u000b\u0003C\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037)\u0018!\u0002;za\u0016\u001c\u0018\u0002BA\u0010\u00033\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011!\t\u0019#a\u0004A\u0002\u0005U\u0011AB:dQ\u0016l\u0017\r\u0003\u0005\u0002(\u0001!\tAAA\u0015\u0003Y\t\u0007\u000f\u001d:pq:+\u0017M]3ti:+\u0017n\u001a5c_J\u001cH\u0003DA\u0016\u0003k\t\t%!\u0012\u0002P\u0005e\u0003\u0007BA\u0017\u0003c\u0001B! @\u00020A\u00191#!\r\u0005\u0019\u0005M\u0012QEA\u0001\u0002\u0003\u0015\t!a\u0002\u0003\u0007}#3\u0007C\u0004{\u0003K\u0001\r!a\u000e1\t\u0005e\u0012Q\b\t\u0005{z\fY\u0004E\u0002\u0014\u0003{!A\"a\u0010\u00026\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00133\u0011\u001d\t\u0019%!\nA\u0002\r\u000b1a[3z\u0011!\t9%!\nA\u0002\u0005%\u0013a\u00058v[:+\u0017M]3ti:+\u0017n\u001a5c_J\u001c\bcA\r\u0002L%\u0019\u0011Q\n\u000e\u0003\u0007%sG\u000f\u0003\u0005\u0002R\u0005\u0015\u0002\u0019AA*\u0003-\u0019\u0018N\\4mKB\u0013xNY3\u0011\u0007e\t)&C\u0002\u0002Xi\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\\\u0005\u0015\u0002\u0019\u0001\u001a\u0002\u000f\u0011L7\u000f^\"pY\"9\u0011q\u0005\u0001\u0005\u0002\u0005}CCCA1\u0003W\n9(!\u001f\u0002|A\"\u00111MA4!\u0011ih0!\u001a\u0011\u0007M\t9\u0007\u0002\u0007\u0002j\u0005u\u0013\u0011!A\u0001\u0006\u0003\t9AA\u0002`IUBqA_A/\u0001\u0004\ti\u0007\r\u0003\u0002p\u0005M\u0004\u0003B?\u007f\u0003c\u00022aEA:\t1\t)(a\u001b\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0005\ryF\u0005\u000e\u0005\b\u0003\u0007\ni\u00061\u0001D\u0011!\t9%!\u0018A\u0002\u0005%\u0003bBA.\u0003;\u0002\rA\r\u0005\b\u0003O\u0001A\u0011AA@)!\t\t)a#\u0002\u0018\u0006e\u0005\u0007BAB\u0003\u000f\u0003B! @\u0002\u0006B\u00191#a\"\u0005\u0019\u0005%\u0015QPA\u0001\u0002\u0003\u0015\t!a\u0002\u0003\u0007}#s\u0007C\u0004{\u0003{\u0002\r!!$1\t\u0005=\u00151\u0013\t\u0005{z\f\t\nE\u0002\u0014\u0003'#A\"!&\u0002\f\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00137\u0011\u001d\t\u0019%! A\u0002\rC\u0001\"a\u0012\u0002~\u0001\u0007\u0011\u0011\n\u0005\t\u0003;\u0003\u0001\u0015\"\u0003\u0002 \u0006q\u0001O]8dKN\u001cH)\u0019;bg\u0016$H\u0003CAQ\u0003W\u000b9,a/1\t\u0005\r\u0016q\u0015\t\u0005{z\f)\u000bE\u0002\u0014\u0003O#A\"!+\u0002\u001c\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u0013:\u0011\u001dQ\u00181\u0014a\u0001\u0003[\u0003D!a,\u00024B!QP`AY!\r\u0019\u00121\u0017\u0003\r\u0003k\u000bY+!A\u0001\u0002\u000b\u0005\u0011q\u0001\u0002\u0004?\u0012B\u0004bBA]\u00037\u0003\rAM\u0001\nS:\u0004X\u000f\u001e(b[\u0016D\u0001\"!0\u0002\u001c\u0002\u0007\u0011qX\u0001\fKb\u0004Hn\u001c3f\u0007>d7\u000fE\u0002[EJB\u0001\"a1\u0001A\u0013%\u0011QY\u0001\fe\u0016\u001c'/Z1uK\u000e{G\u000e\u0006\u0005\u0002H\u0006E\u0017Q\\Aqa\u0011\tI-!4\u0011\tut\u00181\u001a\t\u0004'\u00055G\u0001DAh\u0003\u0003\f\t\u0011!A\u0003\u0002\u0005\u001d!\u0001B0%cEBqA_Aa\u0001\u0004\t\u0019\u000e\r\u0003\u0002V\u0006e\u0007\u0003B?\u007f\u0003/\u00042aEAm\t1\tY.!5\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0005\u0011yF%\r\u0019\t\u000f\u0005}\u0017\u0011\u0019a\u0001e\u000591m\u001c7OC6,\u0007bBAr\u0003\u0003\u0004\rAM\u0001\u000bi6\u00048i\u001c7OC6,\u0007bBAt\u0001\u0011\u0005\u0011\u0011^\u0001\u0015CB\u0004(o\u001c=TS6LG.\u0019:jifTu.\u001b8\u0015\u0015\u0005-\u0018Q\u001fB\u0002\u0005#\u0011)\u0002\r\u0003\u0002n\u0006E\b\u0003B?\u007f\u0003_\u00042aEAy\t1\t\u00190!:\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0005\u0011yF%\r\u001b\t\u0011\u0005]\u0018Q\u001da\u0001\u0003s\f\u0001\u0002Z1uCN,G/\u0011\u0019\u0005\u0003w\fy\u0010\u0005\u0003~}\u0006u\bcA\n\u0002\u0000\u0012a!\u0011AA{\u0003\u0003\u0005\tQ!\u0001\u0002\b\t!q\fJ\u00193\u0011!\u0011)!!:A\u0002\t\u001d\u0011\u0001\u00033bi\u0006\u001cX\r\u001e\"1\t\t%!Q\u0002\t\u0005{z\u0014Y\u0001E\u0002\u0014\u0005\u001b!ABa\u0004\u0003\u0004\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u0011Aa\u0018\u00132g!9!1CAs\u0001\u0004q\u0015!\u0003;ie\u0016\u001c\bn\u001c7e\u0011\u001d\tY&!:A\u0002IBq!a:\u0001\t\u0003\u0011I\u0002\u0006\u0005\u0003\u001c\t\u0015\"\u0011\u0007B\u001fa\u0011\u0011iB!\t\u0011\tut(q\u0004\t\u0004'\t\u0005B\u0001\u0004B\u0012\u0005/\t\t\u0011!A\u0003\u0002\u0005\u001d!\u0001B0%c]B\u0001\"a>\u0003\u0018\u0001\u0007!q\u0005\u0019\u0005\u0005S\u0011i\u0003\u0005\u0003~}\n-\u0002cA\n\u0003.\u0011a!q\u0006B\u0013\u0003\u0003\u0005\tQ!\u0001\u0002\b\t!q\fJ\u00196\u0011!\u0011)Aa\u0006A\u0002\tM\u0002\u0007\u0002B\u001b\u0005s\u0001B! @\u00038A\u00191C!\u000f\u0005\u0019\tm\"\u0011GA\u0001\u0002\u0003\u0015\t!a\u0002\u0003\t}#\u0013G\u000e\u0005\b\u0005'\u00119\u00021\u0001O\u0001")
public abstract class LSHModel<T extends LSHModel<T>>
extends Model<T>
implements LSHParams,
MLWritable {
    private final IntParam numHashTables;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam numHashTables() {
        return this.numHashTables;
    }

    @Override
    public final void org$apache$spark$ml$feature$LSHParams$_setter_$numHashTables_$eq(IntParam x$1) {
        this.numHashTables = x$1;
    }

    @Override
    public final int getNumHashTables() {
        return LSHParams$class.getNumHashTables(this);
    }

    @Override
    public final StructType validateAndTransformSchema(StructType schema) {
        return LSHParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    public T setInputCol(String value) {
        return (T)((LSHModel)this.set(this.inputCol(), value));
    }

    public T setOutputCol(String value) {
        return (T)((LSHModel)this.set(this.outputCol(), value));
    }

    public abstract Vector[] hashFunction(Vector var1);

    public abstract double keyDistance(Vector var1, Vector var2);

    public abstract double hashDistance(Seq<Vector> var1, Seq<Vector> var2);

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        UserDefinedFunction transformUDF = functions$.MODULE$.udf((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LSHModel $outer;

            public final Vector[] apply(Vector x$1) {
                return this.$outer.hashFunction(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (DataType)DataTypes.createArrayType((DataType)new VectorUDT()));
        return dataset.withColumn(this.$(this.outputCol()), transformUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply(this.$(this.inputCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors, boolean singleProbe, String distCol) {
        Dataset dataset2;
        Dataset<Row> modelDataset;
        Predef$.MODULE$.require(numNearestNeighbors > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The number of nearest neighbors cannot be less than 1";
            }
        });
        Vector[] keyHash = this.hashFunction(key);
        Dataset<Row> dataset3 = modelDataset = Predef$.MODULE$.refArrayOps((Object[])dataset.columns()).contains((Object)this.$(this.outputCol())) ? dataset.toDF() : this.transform(dataset);
        if (singleProbe) {
            UserDefinedFunction sameBucketWithKeyUDF = functions$.MODULE$.udf((Object)new Serializable(this, keyHash){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LSHModel $outer;
                private final Vector[] keyHash$1;

                public final boolean apply(Seq<Vector> x) {
                    return this.$outer.org$apache$spark$ml$feature$LSHModel$$sameBucket$1(x, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.keyHash$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.keyHash$1 = keyHash$1;
                }
            }, DataTypes.BooleanType);
            dataset2 = modelDataset.filter(sameBucketWithKeyUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.outputCol()))})));
        } else {
            UserDefinedFunction hashDistUDF = functions$.MODULE$.udf((Object)new Serializable(this, keyHash){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LSHModel $outer;
                private final Vector[] keyHash$1;

                public final double apply(Seq<Vector> x) {
                    return this.$outer.hashDistance(x, (Seq<Vector>)Predef$.MODULE$.wrapRefArray((Object[])this.keyHash$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.keyHash$1 = keyHash$1;
                }
            }, DataTypes.DoubleType);
            Column hashDistCol = hashDistUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.outputCol()))}));
            Dataset modelDatasetSortedByHash = modelDataset.sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{hashDistCol})).limit(numNearestNeighbors);
            Dataset thresholdDataset = modelDatasetSortedByHash.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(hashDistCol)}));
            double hashThreshold = ((Row)Predef$.MODULE$.refArrayOps((Object[])thresholdDataset.take(1)).head()).getDouble(0);
            dataset2 = modelDataset.filter(hashDistCol.$less$eq((Object)BoxesRunTime.boxToDouble((double)hashThreshold)));
        }
        Dataset modelSubset = dataset2;
        UserDefinedFunction keyDistUDF = functions$.MODULE$.udf((Object)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LSHModel $outer;
            private final Vector key$1;

            public final double apply(Vector x) {
                return this.$outer.keyDistance(x, this.key$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
            }
        }, DataTypes.DoubleType);
        Dataset modelSubsetWithDistCol = modelSubset.withColumn(distCol, keyDistUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})));
        return modelSubsetWithDistCol.sort(distCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).limit(numNearestNeighbors);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors, String distCol) {
        return this.approxNearestNeighbors(dataset, key, numNearestNeighbors, true, distCol);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors) {
        return this.approxNearestNeighbors(dataset, key, numNearestNeighbors, true, "distCol");
    }

    private Dataset<?> processDataset(Dataset<?> dataset, String inputName, Seq<String> explodeCols) {
        Predef$.MODULE$.require(explodeCols.size() == 2, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "explodeCols must be two strings.";
            }
        });
        Dataset<Row> modelDataset = Predef$.MODULE$.refArrayOps((Object[])dataset.columns()).contains((Object)this.$(this.outputCol())) ? dataset.toDF() : this.transform(dataset);
        return modelDataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*")})).as(inputName), functions$.MODULE$.posexplode(functions$.MODULE$.col(this.$(this.outputCol()))).as(explodeCols)}));
    }

    private Dataset<?> recreateCol(Dataset<?> dataset, String colName, String tmpColName) {
        return dataset.withColumnRenamed(colName, tmpColName).withColumn(colName, functions$.MODULE$.col(tmpColName)).drop(tmpColName);
    }

    public Dataset<?> approxSimilarityJoin(Dataset<?> datasetA, Dataset<?> datasetB, double threshold, String distCol) {
        Dataset<?> dataset;
        String leftColName = "datasetA";
        String rightColName = "datasetB";
        Seq explodeCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"entry", "hashValue"}));
        Dataset<?> explodedA = this.processDataset(datasetA, leftColName, (Seq<String>)explodeCols);
        Dataset<?> dataset2 = datasetA;
        Dataset<?> dataset3 = datasetB;
        if (!(dataset2 != null ? !dataset2.equals(dataset3) : dataset3 != null)) {
            Dataset<?> recreatedB = this.recreateCol(datasetB, this.$(this.inputCol()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "#", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.inputCol()), Random$.MODULE$.nextString(5)})));
            dataset = this.processDataset(recreatedB, rightColName, (Seq<String>)explodeCols);
        } else {
            dataset = this.processDataset(datasetB, rightColName, (Seq<String>)explodeCols);
        }
        Dataset<?> explodedB = dataset;
        Dataset joinedDataset = explodedA.join(explodedB, explodeCols).drop(explodeCols).distinct();
        UserDefinedFunction distUDF = functions$.MODULE$.udf((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LSHModel $outer;

            public final double apply(Vector x, Vector y) {
                return this.$outer.keyDistance(x, y);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, DataTypes.DoubleType);
        Dataset joinedDatasetWithDist = joinedDataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), distUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftColName, this.$(this.inputCol())}))), functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightColName, this.$(this.inputCol())})))})).as(distCol)}));
        return joinedDatasetWithDist.filter(functions$.MODULE$.col(distCol).$less((Object)BoxesRunTime.boxToDouble((double)threshold)));
    }

    public Dataset<?> approxSimilarityJoin(Dataset<?> datasetA, Dataset<?> datasetB, double threshold) {
        return this.approxSimilarityJoin(datasetA, datasetB, threshold, "distCol");
    }

    public final boolean org$apache$spark$ml$feature$LSHModel$$sameBucket$1(Seq x, Seq y) {
        return ((IterableLike)x.zip((GenIterable)y, Seq$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Vector, Vector> tuple) {
                return BoxesRunTime.equals((Object)tuple._1(), (Object)tuple._2());
            }
        });
    }

    public LSHModel() {
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        LSHParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }
}

