/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.net.URI;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$buildReaderWithPartitionValues$1$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$FileTypes$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetLogRedirector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\r=b\u0001B\u0001\u0003\u0001E\u0011\u0011\u0003U1scV,GOR5mK\u001a{'/\\1u\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0002\u0001\u00131q\u0011\u0003\u0006\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033ii\u0011\u0001B\u0005\u00037\u0011\u0011!BR5mK\u001a{'/\\1u!\ti\u0002%D\u0001\u001f\u0015\ty\u0002\"A\u0004t_V\u00148-Z:\n\u0005\u0005r\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0006\u0002\u0011%tG/\u001a:oC2L!a\n\u0013\u0003\u000f1{wmZ5oOB\u00111#K\u0005\u0003UQ\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000fE\u0002!\u0019!C\u0005e\u0005!\u0002/\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J,\u0012a\r\t\u0003_QJ!!\u000e\u0002\u0003)A\u000b'/];fi2{wMU3eSJ,7\r^8s\u0011\u00199\u0004\u0001)A\u0005g\u0005)\u0002/\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J\u0004\u0003\"B\u001d\u0001\t\u0003R\u0014!C:i_J$h*Y7f)\u0005Y\u0004C\u0001\u001f@\u001d\t\u0019R(\u0003\u0002?)\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tqD\u0003C\u0003D\u0001\u0011\u0005#(\u0001\u0005u_N#(/\u001b8h\u0011\u0015)\u0005\u0001\"\u0011G\u0003!A\u0017m\u001d5D_\u0012,G#A$\u0011\u0005MA\u0015BA%\u0015\u0005\rIe\u000e\u001e\u0005\u0006\u0017\u0002!\t\u0005T\u0001\u0007KF,\u0018\r\\:\u0015\u00055\u0003\u0006CA\nO\u0013\tyECA\u0004C_>dW-\u00198\t\u000bES\u0005\u0019\u0001*\u0002\u000b=$\b.\u001a:\u0011\u0005M\u0019\u0016B\u0001+\u0015\u0005\r\te.\u001f\u0005\u0006-\u0002!\teV\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u00061n\u000b7\u000e\u001d\t\u00033eK!A\u0017\u0003\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000bq+\u0006\u0019A/\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005y{V\"\u0001\u0005\n\u0005\u0001D!\u0001D*qCJ\\7+Z:tS>t\u0007\"\u00022V\u0001\u0004\u0019\u0017a\u00016pEB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!\u0001\u001b\u0007\u0002\r!\fGm\\8q\u0013\tQWMA\u0002K_\nDQ\u0001\\+A\u00025\fqa\u001c9uS>t7\u000f\u0005\u0003=]nZ\u0014BA8B\u0005\ri\u0015\r\u001d\u0005\u0006cV\u0003\rA]\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA:w\u001b\u0005!(BA;\t\u0003\u0015!\u0018\u0010]3t\u0013\t9HO\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u001f\u0001\u0005Bi\f1\"\u001b8gKJ\u001c6\r[3nCR)1P`@\u0002\u0004A\u00191\u0003 :\n\u0005u$\"AB(qi&|g\u000eC\u0003]q\u0002\u0007Q\f\u0003\u0004\u0002\u0002a\u0004\r!\\\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bbBA\u0003q\u0002\u0007\u0011qA\u0001\u0006M&dWm\u001d\t\u0007\u0003\u0013\tI\"a\b\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\t\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012bAA\f)\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u00111aU3r\u0015\r\t9\u0002\u0006\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011QE4\u0002\u0005\u0019\u001c\u0018\u0002BA\u0015\u0003G\u0011!BR5mKN#\u0018\r^;t\r\u0019\ti\u0003\u0001!\u00020\tIa)\u001b7f)f\u0004Xm]\n\u0007\u0003W\u0011\u0012\u0011\u0007\u0015\u0011\u0007M\t\u0019$C\u0002\u00026Q\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0006\u0002:\u0005-\"Q3A\u0005\u0002\u0005m\u0012\u0001\u00023bi\u0006,\"!a\u0002\t\u0017\u0005}\u00121\u0006B\tB\u0003%\u0011qA\u0001\u0006I\u0006$\u0018\r\t\u0005\f\u0003\u0007\nYC!f\u0001\n\u0003\tY$\u0001\u0005nKR\fG-\u0019;b\u0011-\t9%a\u000b\u0003\u0012\u0003\u0006I!a\u0002\u0002\u00135,G/\u00193bi\u0006\u0004\u0003bCA&\u0003W\u0011)\u001a!C\u0001\u0003w\tabY8n[>tW*\u001a;bI\u0006$\u0018\rC\u0006\u0002P\u0005-\"\u0011#Q\u0001\n\u0005\u001d\u0011aD2p[6|g.T3uC\u0012\fG/\u0019\u0011\t\u000f1\nY\u0003\"\u0001\u0002TQA\u0011QKA-\u00037\ni\u0006\u0005\u0003\u0002X\u0005-R\"\u0001\u0001\t\u0011\u0005e\u0012\u0011\u000ba\u0001\u0003\u000fA\u0001\"a\u0011\u0002R\u0001\u0007\u0011q\u0001\u0005\t\u0003\u0017\n\t\u00061\u0001\u0002\b!Q\u0011\u0011MA\u0016\u0003\u0003%\t!a\u0019\u0002\t\r|\u0007/\u001f\u000b\t\u0003+\n)'a\u001a\u0002j!Q\u0011\u0011HA0!\u0003\u0005\r!a\u0002\t\u0015\u0005\r\u0013q\fI\u0001\u0002\u0004\t9\u0001\u0003\u0006\u0002L\u0005}\u0003\u0013!a\u0001\u0003\u000fA!\"!\u001c\u0002,E\u0005I\u0011AA8\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001d+\t\u0005\u001d\u00111O\u0016\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0010\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0004\u0006e$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011qQA\u0016#\u0003%\t!a\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q\u00111RA\u0016#\u0003%\t!a\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011qRA\u0016\u0003\u0003%\t%!%\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\t1\fgn\u001a\u0006\u0003\u0003;\u000bAA[1wC&\u0019\u0001)a&\t\u0015\u0005\r\u00161FA\u0001\n\u0003\t)+\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001H\u0011)\tI+a\u000b\u0002\u0002\u0013\u0005\u00111V\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0011\u0016Q\u0016\u0005\n\u0003_\u000b9+!AA\u0002\u001d\u000b1\u0001\u001f\u00132\u0011)\t\u0019,a\u000b\u0002\u0002\u0013\u0005\u0013QW\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0017\t\u0006\u0003s\u000byLU\u0007\u0003\u0003wS1!!0\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\fYL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\t)-a\u000b\u0002\u0002\u0013\u0005\u0011qY\u0001\tG\u0006tW)];bYR\u0019Q*!3\t\u0013\u0005=\u00161YA\u0001\u0002\u0004\u0011\u0006\u0002C#\u0002,\u0005\u0005I\u0011\t$\t\u0013\r\u000bY#!A\u0005B\u0005=GCAAJ\u0011%Y\u00151FA\u0001\n\u0003\n\u0019\u000eF\u0002N\u0003+D\u0011\"a,\u0002R\u0006\u0005\t\u0019\u0001*\b\u0013\u0005e\u0007!!A\t\u0002\u0005m\u0017!\u0003$jY\u0016$\u0016\u0010]3t!\u0011\t9&!8\u0007\u0013\u00055\u0002!!A\t\u0002\u0005}7#BAo\u0003CD\u0003\u0003DAr\u0003S\f9!a\u0002\u0002\b\u0005USBAAs\u0015\r\t9\u000fF\u0001\beVtG/[7f\u0013\u0011\tY/!:\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004-\u0003;$\t!a<\u0015\u0005\u0005m\u0007\"C\"\u0002^\u0006\u0005IQIAh\u0011)\t)0!8\u0002\u0002\u0013\u0005\u0015q_\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003+\nI0a?\u0002~\"A\u0011\u0011HAz\u0001\u0004\t9\u0001\u0003\u0005\u0002D\u0005M\b\u0019AA\u0004\u0011!\tY%a=A\u0002\u0005\u001d\u0001B\u0003B\u0001\u0003;\f\t\u0011\"!\u0003\u0004\u00059QO\\1qa2LH\u0003\u0002B\u0003\u0005\u001b\u0001Ba\u0005?\u0003\bAI1C!\u0003\u0002\b\u0005\u001d\u0011qA\u0005\u0004\u0005\u0017!\"A\u0002+va2,7\u0007\u0003\u0006\u0003\u0010\u0005}\u0018\u0011!a\u0001\u0003+\n1\u0001\u001f\u00131\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+\t!b\u001d9mSR4\u0015\u000e\\3t)\u0011\t)Fa\u0006\t\u0011\te!\u0011\u0003a\u0001\u0003\u000f\t\u0001\"\u00197m\r&dWm\u001d\u0005\b\u0005;\u0001A\u0011\u0002B\u0010\u00035I7oU;n[\u0006\u0014\u0018PR5mKR\u0019QJ!\t\t\u0011\t\r\"1\u0004a\u0001\u0005K\tAAZ5mKB!\u0011\u0011\u0005B\u0014\u0013\u0011\u0011I#a\t\u0003\tA\u000bG\u000f\u001b\u0005\b\u0005[\u0001A\u0011\tB\u0018\u00031\u0019X\u000f\u001d9peR\u0014\u0015\r^2i)\u0015i%\u0011\u0007B\u001a\u0011\u0019a&1\u0006a\u0001;\"9!Q\u0007B\u0016\u0001\u0004\u0011\u0018AB:dQ\u0016l\u0017\rC\u0004\u0003:\u0001!\tEa\u000f\u0002\u0017Y,7\r^8s)f\u0004Xm\u001d\u000b\t\u0005{\u0011\tE!\u0012\u0003JA!1\u0003 B !\u0015\tI!!\u0007<\u0011\u001d\u0011\u0019Ea\u000eA\u0002I\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0003H\t]\u0002\u0019\u0001:\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006D\u0001Ba\u0013\u00038\u0001\u0007!QJ\u0001\bgFd7i\u001c8g!\u0011\u0011yEa\u0015\u000e\u0005\tE#BA\u0013\t\u0013\u0011\u0011)F!\u0015\u0003\u000fM\u000bFjQ8oM\"9!\u0011\f\u0001\u0005B\tm\u0013aC5t'Bd\u0017\u000e^1cY\u0016$r!\u0014B/\u0005?\u0012\t\u0007\u0003\u0004]\u0005/\u0002\r!\u0018\u0005\u0007Y\n]\u0003\u0019A7\t\u0011\t\r$q\u000ba\u0001\u0005K\tA\u0001]1uQ\"9!q\r\u0001\u0005B\t%\u0014A\b2vS2$'+Z1eKJ<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]Z\u000bG.^3t)A\u0011YGa\"\u0003\n\n-%Q\u0012BH\u00057\u0013i\nE\u0004\u0014\u0005[\u0012\tHa\u001e\n\u0007\t=DCA\u0005Gk:\u001cG/[8ocA\u0019\u0011Da\u001d\n\u0007\tUDAA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0019\tIA!\u001f\u0003|%!\u0011\u0011YA\u000f!\u0011\u0011iHa!\u000e\u0005\t}$b\u0001BA\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0003\u0006\n}$aC%oi\u0016\u0014h.\u00197S_^Da\u0001\u0018B3\u0001\u0004i\u0006BB9\u0003f\u0001\u0007!\u000fC\u0004\u0003H\t\u0015\u0004\u0019\u0001:\t\u000f\t\r#Q\ra\u0001e\"A!\u0011\u0013B3\u0001\u0004\u0011\u0019*A\u0004gS2$XM]:\u0011\r\u0005%\u0011\u0011\u0004BK!\ri\"qS\u0005\u0004\u00053s\"A\u0002$jYR,'\u000f\u0003\u0004m\u0005K\u0002\r!\u001c\u0005\t\u0005?\u0013)\u00071\u0001\u0003\"\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\t\r&\u0011V\u0007\u0003\u0005KS1Aa*h\u0003\u0011\u0019wN\u001c4\n\t\t-&Q\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\t=\u0006\u0001\"\u0011\u00032\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\rF\u0003N\u0005g\u0013i\f\u0003\u0005\u00036\n5\u0006\u0019\u0001B\\\u0003!!\u0017\r^1UsB,\u0007cA:\u0003:&\u0019!1\u0018;\u0003\u0011\u0011\u000bG/\u0019+za\u0016DqAa0\u0003.\u0002\u0007Q*\u0001\u0006jgJ+\u0017\r\u001a)bi\"<qAa1\u0003\u0011\u0003\u0011)-A\tQCJ\fX/\u001a;GS2,gi\u001c:nCR\u00042a\fBd\r\u0019\t!\u0001#\u0001\u0003JN)!q\u0019\n#Q!9AFa2\u0005\u0002\t5GC\u0001Bc\u0011%\u0011\tNa2\u0005\u0002\t\u0011\u0019.\u0001\u0006sK\u0006$7k\u00195f[\u0006$Ra\u001fBk\u0005OD\u0001Ba6\u0003P\u0002\u0007!\u0011\\\u0001\bM>|G/\u001a:t!\u0019\tI!!\u0007\u0003\\B!!Q\u001cBr\u001b\t\u0011yNC\u0002i\u0005CT!a\u0001\u0007\n\t\t\u0015(q\u001c\u0002\u0007\r>|G/\u001a:\t\rq\u0013y\r1\u0001^\u0011%\u0011YOa2\u0005\u0002\t\u0011i/\u0001\u000fsK\u0006$\u0007+\u0019:rk\u0016$hi\\8uKJ\u001c\u0018J\u001c)be\u0006dG.\u001a7\u0015\u0011\te'q\u001eBy\u0005kD\u0001Ba*\u0003j\u0002\u0007!\u0011\u0015\u0005\t\u0005g\u0014I\u000f1\u0001\u0002\b\u0005I\u0001/\u0019:u\r&dWm\u001d\u0005\b\u0005o\u0014I\u000f1\u0001N\u0003IIwM\\8sK\u000e{'O];qi\u001aKG.Z:\t\u0011\tm(q\u0019C\u0001\u0005{\fa#\\3sO\u0016\u001c6\r[3nCNLe\u000eU1sC2dW\r\u001c\u000b\u0006w\n}81\u0001\u0005\t\u0007\u0003\u0011I\u00101\u0001\u0002\b\u0005aa-\u001b7fgR{Gk\\;dQ\"1AL!?A\u0002uC\u0001ba\u0002\u0003H\u0012\u00051\u0011B\u0001\u0015e\u0016\fGmU2iK6\fgI]8n\r>|G/\u001a:\u0015\u000bI\u001cYaa\u0004\t\u0011\r51Q\u0001a\u0001\u00057\faAZ8pi\u0016\u0014\b\u0002CB\t\u0007\u000b\u0001\raa\u0005\u0002\u0013\r|gN^3si\u0016\u0014\bcA\u0018\u0004\u0016%\u00191q\u0003\u0002\u0003;A\u000b'/];fiR{7\u000b]1sWN\u001b\u0007.Z7b\u0007>tg/\u001a:uKJD\u0001ba\u0007\u0003H\u0012%1QD\u0001\u0018I\u0016\u001cXM]5bY&TXmU2iK6\f7\u000b\u001e:j]\u001e$2a_B\u0010\u0011\u001d\u0019\tc!\u0007A\u0002m\nAb]2iK6\f7\u000b\u001e:j]\u001eD!b!\n\u0003H\u0006\u0005I\u0011BB\u0014\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r%\u0002\u0003BAK\u0007WIAa!\f\u0002\u0018\n1qJ\u00196fGR\u0004")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private final ParquetLogRedirector parquetLogRedirector;
    private volatile ParquetFileFormat$FileTypes$ FileTypes$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter parquetToSparkSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetToSparkSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(seq, sparkSession);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParquetFileFormat$FileTypes$ FileTypes$lzycompute() {
        ParquetFileFormat parquetFileFormat = this;
        synchronized (parquetFileFormat) {
            if (this.FileTypes$module != null) return this.FileTypes$module;
            this.FileTypes$module = new ParquetFileFormat$FileTypes$(this);
            return this.FileTypes$module;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat$class.buildReader(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    private ParquetLogRedirector parquetLogRedirector() {
        return this.parquetLogRedirector;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using default output committer for Parquet: ").append((Object)ParquetOutputCommitter.class.getCanonicalName()).toString();
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this, committerClass){
                public static final long serialVersionUID = 0L;
                private final Class committerClass$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using user defined output committer for Parquet: ").append((Object)this.committerClass$1.getCanonicalName()).toString();
                }
                {
                    this.committerClass$1 = committerClass$1;
                }
            });
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().writeLegacyParquetFormat())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if (!(jobSummaryLevel != null ? !jobSummaryLevel.equals(jobSummaryLevel2) : jobSummaryLevel2 != null) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)new Serializable(this, committerClass){
                public static final long serialVersionUID = 0L;
                private final Class committerClass$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committer ", " is not a ParquetOutputCommitter and cannot"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.committerClass$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" create job summaries. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set Parquet option ", " to NONE."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"parquet.summary.metadata.level"}))).toString();
                }
                {
                    this.committerClass$1 = committerClass$1;
                }
            });
        }
        return new OutputWriterFactory(this){
            private final ParquetLogRedirector parquetLogRedirector;

            private ParquetLogRedirector parquetLogRedirector() {
                return this.parquetLogRedirector;
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append((Object)".parquet").toString();
            }
            {
                this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = sparkSession.sessionState().conf().isParquetSchemaRespectSummaries();
        FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq needMerged = mergeRespectSummaries ? (Seq)Seq$.MODULE$.empty() : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.metadata().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            }).orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.data().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            })).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel((Seq<FileStatus>)filesToTouch, sparkSession);
    }

    public ParquetFileFormat$FileTypes$ FileTypes() {
        return this.FileTypes$module == null ? this.FileTypes$lzycompute() : this.FileTypes$module;
    }

    private FileTypes splitFiles(Seq<FileStatus> allFiles2) {
        FileStatus[] leaves = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])allFiles2.toArray(ClassTag$.MODULE$.apply(FileStatus.class))).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$1) {
                return x$1.getPath().toString();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        return new FileTypes(this, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$2) {
                String string = x$2.getPath().getName();
                String string2 = "_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                String string = x$3.getPath().getName();
                String string2 = "_common_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema2) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema2.length() <= conf.wholeStageMaxNumFields() && schema2.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$4) {
                return x$4.dataType() instanceof AtomicType;
            }
        });
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply((Object)Seq$.MODULE$.fill(requiredSchema.fields().length + partitionSchema.fields().length, (Function0)new Serializable(this, sqlConf){
            public static final long serialVersionUID = 0L;
            private final SQLConf sqlConf$1;

            public final String apply() {
                return this.sqlConf$1.offHeapColumnVectorEnabled() ? OffHeapColumnVector.class.getName() : OnHeapColumnVector.class.getName();
            }
            {
                this.sqlConf$1 = sqlConf$1;
            }
        }));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$5) {
                return x$5.dataType() instanceof AtomicType;
            }
        });
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return new Serializable(this, partitionSchema, requiredSchema, filters, broadcastedHadoopConf, enableOffHeapColumnVector, enableVectorizedReader, enableRecordFilter, timestampConversion, capacity, enableParquetFilterPushDown, returningBatch, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;
            public final StructType partitionSchema$1;
            private final StructType requiredSchema$1;
            private final Seq filters$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final boolean enableOffHeapColumnVector$1;
            private final boolean enableVectorizedReader$1;
            private final boolean enableRecordFilter$1;
            private final boolean timestampConversion$1;
            private final int capacity$1;
            private final boolean enableParquetFilterPushDown$1;
            private final boolean returningBatch$1;
            private final boolean pushDownDate$1;
            private final boolean pushDownTimestamp$1;
            private final boolean pushDownDecimal$1;
            private final boolean pushDownStringStartWith$1;
            private final int pushDownInFilterThreshold$1;
            private final boolean isCaseSensitive$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                RecordReaderIterator<Object> recordReaderIterator;
                None$ none$;
                ObjectRef footerFileMetaData$lzy = ObjectRef.zero();
                VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
                Predef$.MODULE$.assert(file.partitionValues().numFields() == this.partitionSchema$1.size());
                FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                Path filePath = fileSplit.getPath();
                ParquetInputSplit split = new ParquetInputSplit(filePath, fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getLocations(), null);
                Configuration sharedConf = ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value();
                if (this.enableParquetFilterPushDown$1) {
                    MessageType parquetSchema = this.footerFileMetaData$1(filePath, sharedConf, footerFileMetaData$lzy, bitmap$0).getSchema();
                    ParquetFilters parquetFilters = new ParquetFilters(this.pushDownDate$1, this.pushDownTimestamp$1, this.pushDownDecimal$1, this.pushDownStringStartWith$1, this.pushDownInFilterThreshold$1, this.isCaseSensitive$1);
                    none$ = ((TraversableOnce)this.filters$1.flatMap((Function1)new Serializable(this, parquetSchema, parquetFilters){
                        public static final long serialVersionUID = 0L;
                        private final MessageType parquetSchema$1;
                        private final ParquetFilters parquetFilters$1;

                        public final Iterable<FilterPredicate> apply(Filter x$6) {
                            return Option$.MODULE$.option2Iterable(this.parquetFilters$1.createFilter(this.parquetSchema$1, x$6));
                        }
                        {
                            this.parquetSchema$1 = parquetSchema$1;
                            this.parquetFilters$1 = parquetFilters$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final FilterPredicate apply(FilterPredicate x$1, FilterPredicate x$2) {
                            return FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2);
                        }
                    });
                } else {
                    none$ = None$.MODULE$;
                }
                None$ pushed = none$;
                None$ convertTz = this.timestampConversion$1 && !this.isCreatedByParquetMr$1(filePath, sharedConf, footerFileMetaData$lzy, bitmap$0) ? new Some((Object)DateTimeUtils$.MODULE$.getTimeZone(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value(), attemptId);
                if (pushed.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
                }
                Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
                if (this.enableVectorizedReader$1) {
                    VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((TimeZone)convertTz.orNull(Predef$.MODULE$.$conforms()), this.enableOffHeapColumnVector$1 && taskContext.isDefined(), this.capacity$1);
                    RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
                    taskContext.foreach((Function1)new Serializable(this, iter){
                        public static final long serialVersionUID = 0L;
                        public final RecordReaderIterator iter$1;

                        public final TaskContext apply(TaskContext x$7) {
                            return x$7.addTaskCompletionListener((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$buildReaderWithPartitionValues$1$$anonfun$apply$3 $outer;

                                public final void apply(TaskContext x$8) {
                                    this.$outer.iter$1.close();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.iter$1 = iter$1;
                        }
                    });
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildReaderWithPartitionValues$1 $outer;
                        private final PartitionedFile file$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appending ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.partitionSchema$1, this.file$1.partitionValues()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$1 = file$1;
                        }
                    });
                    vectorizedReader.initBatch(this.partitionSchema$1, file.partitionValues());
                    if (this.returningBatch$1) {
                        vectorizedReader.enableReturningBatches();
                    }
                    recordReaderIterator = iter;
                } else {
                    ParquetRecordReader parquetRecordReader;
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to parquet-mr"})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    if (pushed.isDefined() && this.enableRecordFilter$1) {
                        FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport((Option<TimeZone>)convertTz), parquetFilter);
                    } else {
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport((Option<TimeZone>)convertTz));
                    }
                    ParquetRecordReader reader = parquetRecordReader;
                    RecordReaderIterator<T> iter = new RecordReaderIterator<T>(reader);
                    taskContext.foreach((Function1)new Serializable(this, iter){
                        public static final long serialVersionUID = 0L;
                        public final RecordReaderIterator iter$2;

                        public final TaskContext apply(TaskContext x$9) {
                            return x$9.addTaskCompletionListener((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$buildReaderWithPartitionValues$1$$anonfun$apply$7 $outer;

                                public final void apply(TaskContext x$10) {
                                    this.$outer.iter$2.close();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.iter$2 = iter$2;
                        }
                    });
                    reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    Seq fullSchema = (Seq)this.requiredSchema$1.toAttributes().$plus$plus((GenTraversableOnce)this.partitionSchema$1.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    JoinedRow joinedRow = new JoinedRow();
                    UnsafeProjection appendPartitionColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    recordReaderIterator = this.partitionSchema$1.length() == 0 ? iter : iter.map((Function1)new Serializable(this, joinedRow, appendPartitionColumns, file){
                        public static final long serialVersionUID = 0L;
                        private final JoinedRow joinedRow$1;
                        private final UnsafeProjection appendPartitionColumns$1;
                        private final PartitionedFile file$1;

                        public final UnsafeRow apply(InternalRow d) {
                            return this.appendPartitionColumns$1.apply((InternalRow)this.joinedRow$1.apply(d, this.file$1.partitionValues()));
                        }
                        {
                            this.joinedRow$1 = joinedRow$1;
                            this.appendPartitionColumns$1 = appendPartitionColumns$1;
                            this.file$1 = file$1;
                        }
                    });
                }
                return recordReaderIterator;
            }

            private final FileMetaData footerFileMetaData$lzycompute$1(Path filePath$1, Configuration sharedConf$1, ObjectRef footerFileMetaData$lzy$1, VolatileByteRef bitmap$0$1) {
                $anonfun$buildReaderWithPartitionValues$1 var5_5 = this;
                synchronized (var5_5) {
                    if ((byte)(bitmap$0$1.elem & 1) == 0) {
                        footerFileMetaData$lzy$1.elem = ParquetFileReader.readFooter((Configuration)sharedConf$1, (Path)filePath$1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData();
                        bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
                    }
                    return (FileMetaData)footerFileMetaData$lzy$1.elem;
                }
            }

            private final FileMetaData footerFileMetaData$1(Path filePath$1, Configuration sharedConf$1, ObjectRef footerFileMetaData$lzy$1, VolatileByteRef bitmap$0$1) {
                return (byte)(bitmap$0$1.elem & 1) == 0 ? this.footerFileMetaData$lzycompute$1(filePath$1, sharedConf$1, footerFileMetaData$lzy$1, bitmap$0$1) : (FileMetaData)footerFileMetaData$lzy$1.elem;
            }

            private final boolean isCreatedByParquetMr$1(Path filePath$1, Configuration sharedConf$1, ObjectRef footerFileMetaData$lzy$1, VolatileByteRef bitmap$0$1) {
                return this.footerFileMetaData$1(filePath$1, sharedConf$1, footerFileMetaData$lzy$1, bitmap$0$1).getCreatedBy().startsWith("parquet-mr");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionSchema$1 = partitionSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.filters$1 = filters$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.enableOffHeapColumnVector$1 = enableOffHeapColumnVector$1;
                this.enableVectorizedReader$1 = enableVectorizedReader$1;
                this.enableRecordFilter$1 = enableRecordFilter$1;
                this.timestampConversion$1 = timestampConversion$1;
                this.capacity$1 = capacity$1;
                this.enableParquetFilterPushDown$1 = enableParquetFilterPushDown$1;
                this.returningBatch$1 = returningBatch$1;
                this.pushDownDate$1 = pushDownDate$1;
                this.pushDownTimestamp$1 = pushDownTimestamp$1;
                this.pushDownDecimal$1 = pushDownDecimal$1;
                this.pushDownStringStartWith$1 = pushDownStringStartWith$1;
                this.pushDownInFilterThreshold$1 = pushDownInFilterThreshold$1;
                this.isCaseSensitive$1 = isCaseSensitive$1;
            }
        };
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1)new Serializable(this, isReadPath){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ParquetFileFormat $outer;
                private final boolean isReadPath$1;

                public final boolean apply(StructField f) {
                    return this.$outer.supportDataType(f.dataType(), this.isReadPath$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.isReadPath$1 = isReadPath$1;
                }
            });
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType, isReadPath);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType, isReadPath) && this.supportDataType(valueType, isReadPath);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType(), isReadPath);
        } else {
            bl = false;
        }
        return bl;
    }

    public ParquetFileFormat() {
        FileFormat$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
    }

    public class FileTypes
    implements Product,
    Serializable {
        private final Seq<FileStatus> data;
        private final Seq<FileStatus> metadata;
        private final Seq<FileStatus> commonMetadata;
        public final /* synthetic */ ParquetFileFormat $outer;

        public Seq<FileStatus> data() {
            return this.data;
        }

        public Seq<FileStatus> metadata() {
            return this.metadata;
        }

        public Seq<FileStatus> commonMetadata() {
            return this.commonMetadata;
        }

        public FileTypes copy(Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            return new FileTypes(this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer(), data, metadata, commonMetadata);
        }

        public Seq<FileStatus> copy$default$1() {
            return this.data();
        }

        public Seq<FileStatus> copy$default$2() {
            return this.metadata();
        }

        public Seq<FileStatus> copy$default$3() {
            return this.commonMetadata();
        }

        public String productPrefix() {
            return "FileTypes";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<FileStatus> seq;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    seq = this.commonMetadata();
                    break;
                }
                case 1: {
                    seq = this.metadata();
                    break;
                }
                case 0: {
                    seq = this.data();
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileTypes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileTypes)) return false;
            if (((FileTypes)object).org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() != this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FileTypes fileTypes = (FileTypes)x$1;
            Seq<FileStatus> seq = this.data();
            Seq<FileStatus> seq2 = fileTypes.data();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<FileStatus> seq3 = this.metadata();
            Seq<FileStatus> seq4 = fileTypes.metadata();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<FileStatus> seq5 = this.commonMetadata();
            Seq<FileStatus> seq6 = fileTypes.commonMetadata();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            if (!fileTypes.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ParquetFileFormat org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() {
            return this.$outer;
        }

        public FileTypes(ParquetFileFormat $outer, Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            this.data = data;
            this.metadata = metadata;
            this.commonMetadata = commonMetadata;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

