/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskKilledException;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.CodegenMetrics$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$$anonfun$27$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$$anonfun$27$$anonfun$28$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ParentClassLoader;
import org.apache.spark.util.Utils$;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.InternalCompilerException;
import org.codehaus.janino.SimpleCompiler;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.spark_project.guava.cache.CacheBuilder;
import org.spark_project.guava.cache.CacheLoader;
import org.spark_project.guava.cache.LoadingCache;
import org.spark_project.guava.util.concurrent.ExecutionError;
import org.spark_project.guava.util.concurrent.UncheckedExecutionException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CodeGenerator$
implements Logging {
    public static final CodeGenerator$ MODULE$;
    private final int DEFAULT_JVM_HUGE_METHOD_LIMIT;
    private final int MAX_JVM_METHOD_PARAMS_LENGTH;
    private final int MERGE_SPLIT_METHODS_THRESHOLD;
    private final int GENERATED_CLASS_SIZE_THRESHOLD;
    private final int OUTER_CLASS_VARIABLES_THRESHOLD;
    private final int MUTABLESTATEARRAY_SIZE_LIMIT;
    private final LoadingCache<CodeAndComment, Tuple2<GeneratedClass, Object>> cache;
    private final String JAVA_BOOLEAN;
    private final String JAVA_BYTE;
    private final String JAVA_SHORT;
    private final String JAVA_INT;
    private final String JAVA_LONG;
    private final String JAVA_FLOAT;
    private final String JAVA_DOUBLE;
    private final Seq<String> primitiveTypes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CodeGenerator$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public final int DEFAULT_JVM_HUGE_METHOD_LIMIT() {
        return 8000;
    }

    public final int MAX_JVM_METHOD_PARAMS_LENGTH() {
        return 255;
    }

    public final int MERGE_SPLIT_METHODS_THRESHOLD() {
        return 3;
    }

    public final int GENERATED_CLASS_SIZE_THRESHOLD() {
        return 1000000;
    }

    public final int OUTER_CLASS_VARIABLES_THRESHOLD() {
        return 10000;
    }

    public final int MUTABLESTATEARRAY_SIZE_LIMIT() {
        return 32768;
    }

    public Tuple2<GeneratedClass, Object> compile(CodeAndComment code2) {
        try {
            return (Tuple2)this.cache().get((Object)code2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError;
            if (bl) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
    }

    public Tuple2<GeneratedClass, Object> org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(CodeAndComment code2) {
        int maxCodeSize;
        ClassBodyEvaluator evaluator = new ClassBodyEvaluator();
        ParentClassLoader parentClassLoader = new ParentClassLoader(Utils$.MODULE$.getContextOrSparkClassLoader());
        evaluator.setParentClassLoader((ClassLoader)parentClassLoader);
        evaluator.setClassName("org.apache.spark.sql.catalyst.expressions.GeneratedClass");
        evaluator.setDefaultImports(new String[]{Platform.class.getName(), InternalRow.class.getName(), UnsafeRow.class.getName(), UTF8String.class.getName(), Decimal.class.getName(), CalendarInterval.class.getName(), ArrayData.class.getName(), UnsafeArrayData.class.getName(), MapData.class.getName(), UnsafeMapData.class.getName(), Expression.class.getName(), TaskContext.class.getName(), TaskKilledException.class.getName(), InputMetrics.class.getName()});
        evaluator.setExtendedClass(GeneratedClass.class);
        this.logDebug((Function0<String>)new Serializable(code2, evaluator){
            public static final long serialVersionUID = 0L;
            private final CodeAndComment code$1;
            private final ClassBodyEvaluator evaluator$1;

            public final String apply() {
                this.evaluator$1.setDebuggingInformation(true, true, false);
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeFormatter$.MODULE$.format(this.code$1, CodeFormatter$.MODULE$.format$default$2())}));
            }
            {
                this.code$1 = code$1;
                this.evaluator$1 = evaluator$1;
            }
        });
        try {
            evaluator.cook("generated.java", code2.body());
            maxCodeSize = this.updateAndGetCompilationStats(evaluator);
        }
        catch (CompileException compileException) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to compile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compileException}));
            this.logError((Function0<String>)new Serializable(msg){
                public static final long serialVersionUID = 0L;
                private final String msg$2;

                public final String apply() {
                    return this.msg$2;
                }
                {
                    this.msg$2 = msg$2;
                }
            }, compileException);
            int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
            this.logInfo((Function0<String>)new Serializable(code2, maxLines){
                public static final long serialVersionUID = 0L;
                private final CodeAndComment code$1;
                private final int maxLines$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeFormatter$.MODULE$.format(this.code$1, this.maxLines$2)}));
                }
                {
                    this.code$1 = code$1;
                    this.maxLines$2 = maxLines$2;
                }
            });
            throw new CompileException(msg, compileException.getLocation());
        }
        catch (InternalCompilerException internalCompilerException) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to compile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{internalCompilerException}));
            this.logError((Function0<String>)new Serializable(msg){
                public static final long serialVersionUID = 0L;
                private final String msg$1;

                public final String apply() {
                    return this.msg$1;
                }
                {
                    this.msg$1 = msg$1;
                }
            }, internalCompilerException);
            int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
            this.logInfo((Function0<String>)new Serializable(code2, maxLines){
                public static final long serialVersionUID = 0L;
                private final CodeAndComment code$1;
                private final int maxLines$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeFormatter$.MODULE$.format(this.code$1, this.maxLines$1)}));
                }
                {
                    this.code$1 = code$1;
                    this.maxLines$1 = maxLines$1;
                }
            });
            throw new InternalCompilerException(msg, (Throwable)internalCompilerException);
        }
        return new Tuple2((Object)((GeneratedClass)evaluator.getClazz().newInstance()), (Object)BoxesRunTime.boxToInteger((int)maxCodeSize));
    }

    private int updateAndGetCompilationStats(ClassBodyEvaluator evaluator) {
        Field resultField = SimpleCompiler.class.getDeclaredField("result");
        resultField.setAccessible(true);
        ByteArrayClassLoader loader = (ByteArrayClassLoader)resultField.get(evaluator);
        Field classesField = loader.getClass().getDeclaredField("classes");
        classesField.setAccessible(true);
        scala.collection.mutable.Map classes = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)classesField.get(loader)).asScala();
        Class codeAttr = Utils$.MODULE$.classForName("org.codehaus.janino.util.ClassFile$CodeAttribute");
        Field codeAttrField = codeAttr.getDeclaredField("code");
        codeAttrField.setAccessible(true);
        scala.collection.mutable.Iterable codeSizes = (scala.collection.mutable.Iterable)((GenericTraversableTemplate)classes.flatMap((Function1)new Serializable(codeAttr, codeAttrField){
            public static final long serialVersionUID = 0L;
            public final Class codeAttr$1;
            public final Field codeAttrField$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Iterable<Buffer<Object>> apply(Tuple2<String, byte[]> x0$11) {
                Iterable iterable;
                Tuple2<String, byte[]> tuple2 = x0$11;
                if (tuple2 == null) throw new MatchError(tuple2);
                byte[] classBytes = (byte[])tuple2._2();
                CodegenMetrics$.MODULE$.METRIC_GENERATED_CLASS_BYTECODE_SIZE().update(classBytes.length);
                try {
                    ClassFile cf = new ClassFile((InputStream)new ByteArrayInputStream(classBytes));
                    Buffer stats2 = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cf.methodInfos).asScala()).flatMap((Function1)new Serializable(this, cf){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.27 $outer;
                        public final ClassFile cf$1;

                        public final ArrayOps<Object> apply(ClassFile.MethodInfo method2) {
                            return Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])method2.getAttributes()).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$27$$anonfun$28 $outer;

                                public final boolean apply(ClassFile.AttributeInfo x$21) {
                                    return x$21.getClass() == this.$outer.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anonfun$$anonfun$$$outer().codeAttr$1;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            })).map((Function1)new Serializable(this, method2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$27$$anonfun$28 $outer;
                                public final ClassFile.MethodInfo method$1;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final int apply(ClassFile.AttributeInfo a) {
                                    void var2_2;
                                    int byteCodeSize = ((byte[])this.$outer.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anonfun$$anonfun$$$outer().codeAttrField$1.get(a)).length;
                                    CodegenMetrics$.MODULE$.METRIC_GENERATED_METHOD_BYTECODE_SIZE().update(byteCodeSize);
                                    if (byteCodeSize > 8000) {
                                        CodeGenerator$.MODULE$.logInfo((Function0<String>)new Serializable(this, byteCodeSize){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$27$$anonfun$28$$anonfun$apply$7 $outer;
                                            private final int byteCodeSize$1;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"Generated method too long to be JIT compiled: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", " is ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anonfun$$anonfun$$anonfun$$$outer().cf$1.getThisClassName(), this.$outer.method$1.getName(), BoxesRunTime.boxToInteger((int)this.byteCodeSize$1)}))).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.byteCodeSize$1 = byteCodeSize$1;
                                            }
                                        });
                                    }
                                    return (int)var2_2;
                                }

                                public /* synthetic */ anonfun$27$$anonfun$28 org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anonfun$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.method$1 = method$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                        }

                        public /* synthetic */ anonfun.27 org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.cf$1 = cf$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)stats2));
                    return iterable;
                }
                catch (Throwable throwable) {
                    Iterable iterable2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    CodeGenerator$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error calculating stats of compiled class.";
                        }
                    }, e);
                    iterable = iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                this.codeAttr$1 = codeAttr$1;
                this.codeAttrField$1 = codeAttrField$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        return BoxesRunTime.unboxToInt((Object)codeSizes.max((Ordering)Ordering.Int$.MODULE$));
    }

    private LoadingCache<CodeAndComment, Tuple2<GeneratedClass, Object>> cache() {
        return this.cache;
    }

    public final String JAVA_BOOLEAN() {
        return "boolean";
    }

    public final String JAVA_BYTE() {
        return "byte";
    }

    public final String JAVA_SHORT() {
        return "short";
    }

    public final String JAVA_INT() {
        return "int";
    }

    public final String JAVA_LONG() {
        return "long";
    }

    public final String JAVA_FLOAT() {
        return "float";
    }

    public final String JAVA_DOUBLE() {
        return "double";
    }

    public Seq<String> primitiveTypes() {
        return this.primitiveTypes;
    }

    public boolean isPrimitiveType(String jt) {
        return this.primitiveTypes().contains((Object)jt);
    }

    public boolean isPrimitiveType(DataType dt) {
        return this.isPrimitiveType(this.javaType(dt));
    }

    public String getValue(String input, DataType dataType2, String ordinal) {
        String string;
        block10: {
            String jt;
            while (true) {
                jt = this.javaType(dataType2);
                DataType dataType3 = dataType2;
                if (this.isPrimitiveType(jt)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".get", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, this.primitiveTypeName(jt), ordinal}));
                    break block10;
                }
                if (dataType3 instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType3;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getDecimal(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, ordinal, BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())}));
                    break block10;
                }
                if (StringType$.MODULE$.equals(dataType3)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getUTF8String(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, ordinal}));
                    break block10;
                }
                if (BinaryType$.MODULE$.equals(dataType3)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getBinary(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, ordinal}));
                    break block10;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType3)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getInterval(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, ordinal}));
                    break block10;
                }
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getStruct(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, ordinal, BoxesRunTime.boxToInteger((int)structType2.size())}));
                    break block10;
                }
                if (dataType3 instanceof ArrayType) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getArray(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, ordinal}));
                    break block10;
                }
                if (dataType3 instanceof MapType) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMap(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, ordinal}));
                    break block10;
                }
                if (NullType$.MODULE$.equals(dataType3)) {
                    string = "null";
                    break block10;
                }
                if (!(dataType3 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = userDefinedType.sqlType();
            }
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")", ".get(", ", null)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jt, input, ordinal}));
        }
        return string;
    }

    public String createArrayData(String arrayName, DataType elementType, String numElements, String additionalErrorMessage) {
        int elementSize = this.isPrimitiveType(elementType) ? elementType.defaultSize() : -1;
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |ArrayData ", " = ArrayData.allocateArrayData(\n       |  ", ", ", ", \"", "\");\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arrayName, BoxesRunTime.boxToInteger((int)elementSize), numElements, additionalErrorMessage})))).stripMargin();
    }

    public String createArrayAssignment(String dstArray, DataType elementType, String srcArray, String dstArrayIndex, String srcArrayIndex, boolean needNullCheck2) {
        return this.setArrayElement(dstArray, elementType, dstArrayIndex, this.getValue(srcArray, elementType, srcArrayIndex), (Option<String>)(needNullCheck2 ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isNullAt(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcArray, srcArrayIndex}))) : None$.MODULE$));
    }

    public String setColumn(String row, DataType dataType2, int ordinal, String value2) {
        String string;
        block3: {
            DataType dataType3;
            while (true) {
                String jt = this.javaType(dataType2);
                dataType3 = dataType2;
                if (this.isPrimitiveType(jt)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".set", "(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row, this.primitiveTypeName(jt), BoxesRunTime.boxToInteger((int)ordinal), value2}));
                    break block3;
                }
                if (dataType3 instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType3;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".setDecimal(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row, BoxesRunTime.boxToInteger((int)ordinal), value2, BoxesRunTime.boxToInteger((int)decimalType.precision())}));
                    break block3;
                }
                if (!(dataType3 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = userDefinedType.sqlType();
            }
            boolean bl = StringType$.MODULE$.equals(dataType3) ? true : (dataType3 instanceof StructType ? true : (dataType3 instanceof ArrayType ? true : dataType3 instanceof MapType));
            string = bl ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".update(", ", ", ".copy())"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row, BoxesRunTime.boxToInteger((int)ordinal), value2})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".update(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row, BoxesRunTime.boxToInteger((int)ordinal), value2}));
        }
        return string;
    }

    public String updateColumn(String row, DataType dataType2, int ordinal, ExprCode ev, boolean nullable2, boolean isVectorized) {
        return nullable2 ? (!isVectorized && dataType2 instanceof DecimalType ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |if (!", ") {\n           |  ", ";\n           |} else {\n           |  ", ";\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.setColumn(row, dataType2, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value())), this.setColumn(row, dataType2, ordinal, "null")})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |if (!", ") {\n           |  ", ";\n           |} else {\n           |  ", ".setNullAt(", ");\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.setColumn(row, dataType2, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value())), row, BoxesRunTime.boxToInteger((int)ordinal)})))).stripMargin()) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.setColumn(row, dataType2, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))}));
    }

    public String setValue(String vector, String rowId, DataType dataType2, String value2) {
        block5: {
            String string;
            block3: {
                DataType dataType3;
                block4: {
                    block2: {
                        String jt = this.javaType(dataType2);
                        dataType3 = dataType2;
                        if (!this.isPrimitiveType(jt)) break block2;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".put", "(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vector, this.primitiveTypeName(jt), rowId, value2}));
                        break block3;
                    }
                    if (!(dataType3 instanceof DecimalType)) break block4;
                    DecimalType decimalType = (DecimalType)dataType3;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".putDecimal(", ", ", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vector, rowId, value2, BoxesRunTime.boxToInteger((int)decimalType.precision())}));
                    break block3;
                }
                if (!(dataType3 instanceof StringType)) break block5;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".putByteArray(", ", ", ".getBytes());"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vector, rowId, value2}));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot generate code for unsupported type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType2})));
    }

    public String setArrayElement(String array, DataType elementType, String i, String value2, Option<String> isNull) {
        boolean isPrimitiveType = this.isPrimitiveType(elementType);
        String setFunc = isPrimitiveType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"set", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.primitiveTypeName(elementType)})) : "update";
        return isNull.isDefined() && isPrimitiveType ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |if (", ") {\n         |  ", ".setNullAt(", ");\n         |} else {\n         |  ", ".", "(", ", ", ");\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{isNull.get(), array, i, array, setFunc, i, value2})))).stripMargin() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array, setFunc, i, value2}));
    }

    public Option<String> setArrayElement$default$5() {
        return None$.MODULE$;
    }

    public String updateColumn(String vector, String rowId, DataType dataType2, ExprCode ev, boolean nullable2) {
        return nullable2 ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |if (!", ") {\n         |  ", "\n         |} else {\n         |  ", ".putNull(", ");\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), this.setValue(vector, rowId, dataType2, ExprValue$.MODULE$.exprValueToString(ev.value())), vector, rowId})))).stripMargin() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.setValue(vector, rowId, dataType2, ExprValue$.MODULE$.exprValueToString(ev.value()))}));
    }

    public boolean updateColumn$default$6() {
        return false;
    }

    public String getValueFromVector(String vector, DataType dataType2, String rowId) {
        return dataType2 instanceof StructType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getStruct(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vector, rowId})) : this.getValue(vector, dataType2, rowId);
    }

    public String primitiveTypeName(String jt) {
        String string = jt;
        String string2 = "int".equals(string) ? "Int" : this.boxedType(jt);
        return string2;
    }

    public String primitiveTypeName(DataType dt) {
        return this.primitiveTypeName(this.javaType(dt));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String javaType(DataType dt) {
        DataType dataType2;
        ObjectType objectType;
        boolean bl;
        while (true) {
            bl = false;
            objectType = null;
            dataType2 = dt;
            if (BooleanType$.MODULE$.equals(dataType2)) {
                return "boolean";
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return "byte";
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return "short";
            }
            if (IntegerType$.MODULE$.equals(dataType2)) {
                return "int";
            }
            if (DateType$.MODULE$.equals(dataType2)) {
                return "int";
            }
            boolean bl2 = false;
            if (bl2) {
                return "int";
            }
            if (LongType$.MODULE$.equals(dataType2)) {
                return "long";
            }
            if (TimestampType$.MODULE$.equals(dataType2)) {
                return "long";
            }
            boolean bl3 = false;
            if (bl3) {
                return "long";
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return "float";
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return "double";
            }
            if (dataType2 instanceof DecimalType) {
                return "Decimal";
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return "byte[]";
            }
            if (StringType$.MODULE$.equals(dataType2)) {
                return "UTF8String";
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                return "CalendarInterval";
            }
            if (dataType2 instanceof StructType) {
                return "InternalRow";
            }
            if (dataType2 instanceof ArrayType) {
                return "ArrayData";
            }
            if (dataType2 instanceof MapType) {
                return "MapData";
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dt = userDefinedType.sqlType();
        }
        if (dataType2 instanceof ObjectType) {
            bl = true;
            objectType = (ObjectType)dataType2;
            Class<?> cls = objectType.cls();
            if (cls.isArray()) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.javaType(new ObjectType(cls.getComponentType()))}));
            }
        }
        if (!bl) return "Object";
        Class<?> cls = objectType.cls();
        return cls.getName();
    }

    public Class<?> javaClass(DataType dt) {
        Class<Object> clazz;
        block17: {
            DataType dataType2;
            while (true) {
                if (BooleanType$.MODULE$.equals(dataType2 = dt)) {
                    clazz = Boolean.TYPE;
                    break block17;
                }
                if (ByteType$.MODULE$.equals(dataType2)) {
                    clazz = Byte.TYPE;
                    break block17;
                }
                if (ShortType$.MODULE$.equals(dataType2)) {
                    clazz = Short.TYPE;
                    break block17;
                }
                boolean bl = IntegerType$.MODULE$.equals(dataType2) ? true : DateType$.MODULE$.equals(dataType2);
                if (bl) {
                    clazz = Integer.TYPE;
                    break block17;
                }
                boolean bl2 = LongType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2);
                if (bl2) {
                    clazz = Long.TYPE;
                    break block17;
                }
                if (FloatType$.MODULE$.equals(dataType2)) {
                    clazz = Float.TYPE;
                    break block17;
                }
                if (DoubleType$.MODULE$.equals(dataType2)) {
                    clazz = Double.TYPE;
                    break block17;
                }
                if (dataType2 instanceof DecimalType) {
                    clazz = Decimal.class;
                    break block17;
                }
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    clazz = byte[].class;
                    break block17;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    clazz = UTF8String.class;
                    break block17;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                    clazz = CalendarInterval.class;
                    break block17;
                }
                if (dataType2 instanceof StructType) {
                    clazz = InternalRow.class;
                    break block17;
                }
                if (dataType2 instanceof ArrayType) {
                    clazz = ArrayData.class;
                    break block17;
                }
                if (dataType2 instanceof MapType) {
                    clazz = MapData.class;
                    break block17;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dt = userDefinedType.sqlType();
            }
            if (dataType2 instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dataType2;
                Class<?> cls = objectType.cls();
                clazz = cls;
            } else {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    public String boxedType(String jt) {
        String string = jt;
        String string2 = "boolean".equals(string) ? "Boolean" : ("byte".equals(string) ? "Byte" : ("short".equals(string) ? "Short" : ("int".equals(string) ? "Integer" : ("long".equals(string) ? "Long" : ("float".equals(string) ? "Float" : ("double".equals(string) ? "Double" : string))))));
        return string2;
    }

    public String boxedType(DataType dt) {
        return this.boxedType(this.javaType(dt));
    }

    public String defaultValue(String jt, boolean typedNull) {
        String string = jt;
        String string2 = "boolean".equals(string) ? "false" : ("byte".equals(string) ? "(byte)-1" : ("short".equals(string) ? "(short)-1" : ("int".equals(string) ? "-1" : ("long".equals(string) ? "-1L" : ("float".equals(string) ? "-1.0f" : ("double".equals(string) ? "-1.0" : (typedNull ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", ")null)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jt})) : "null")))))));
        return string2;
    }

    public String defaultValue(DataType dt, boolean typedNull) {
        return this.defaultValue(this.javaType(dt), typedNull);
    }

    public boolean defaultValue$default$2() {
        return false;
    }

    public int calculateParamLength(Seq<Expression> params) {
        return 1 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)params.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Expression input) {
                return CodeGenerator$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$paramLengthForExpr$1(input);
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public boolean isValidParamLength(int paramLength) {
        return paramLength <= 255;
    }

    public final int org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$paramLengthForExpr$1(Expression input) {
        String string = this.javaType(input.dataType());
        boolean bl = "long".equals(string) ? true : "double".equals(string);
        int n = bl ? 2 : 1;
        int javaParamLength = n;
        return (input.nullable() ? 1 : 0) + javaParamLength;
    }

    private CodeGenerator$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)SQLConf$.MODULE$.get().codegenCacheMaxEntries()).build((CacheLoader)new CacheLoader<CodeAndComment, Tuple2<GeneratedClass, Object>>(){

            public Tuple2<GeneratedClass, Object> load(CodeAndComment code2) {
                long startTime = System.nanoTime();
                Tuple2<GeneratedClass, Object> result = CodeGenerator$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(code2);
                long endTime = System.nanoTime();
                CodegenMetrics$.MODULE$.METRIC_SOURCE_CODE_SIZE().update(code2.body().length());
                CodegenMetrics$.MODULE$.METRIC_COMPILATION_TIME().update((long)this.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anon$$timeMs$1(startTime, endTime));
                CodeGenerator$.MODULE$.logInfo((Function0<String>)new Serializable(this, startTime, endTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final long startTime$1;
                    private final long endTime$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code generated in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anon$$timeMs$1(this.startTime$1, this.endTime$1))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.startTime$1 = startTime$1;
                        this.endTime$1 = endTime$1;
                    }
                });
                return result;
            }

            public final double org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$anon$$timeMs$1(long startTime$1, long endTime$1) {
                return (double)(endTime$1 - startTime$1) / (double)1000000;
            }
        });
        this.primitiveTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"boolean", "byte", "short", "int", "long", "float", "double"}));
    }
}

