/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic$class;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.Stateful$class;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Returns monotonically increasing 64-bit integers. The generated ID is guaranteed\n      to be monotonically increasing and unique, but not consecutive. The current implementation\n      puts the partition ID in the upper 31 bits, and the lower 33 bits represent the record number\n      within each partition. The assumption is that the data frame has less than 1 billion\n      partitions, and each partition has less than 8 billion records.\n      The function is non-deterministic because its result depends on partition IDs.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001>\u0011\u0011$T8o_R|g.[2bY2L\u0018J\\2sK\u0006\u001c\u0018N\\4J\t*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tqA*Z1g\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\u0005Ti\u0006$XMZ;m!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0001$!\t\t\u0002\u0001C\u0005&\u0001\u0001\u0007\t\u0011)Q\u0005M\u0005)1m\\;oiB\u0011\u0001dJ\u0005\u0003Qe\u0011A\u0001T8oO\"\u0012AE\u000b\t\u00031-J!\u0001L\r\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"\u0003\u0018\u0001\u0001\u0004\u0005\t\u0015)\u0003'\u00035\u0001\u0018M\u001d;ji&|g.T1tW\"\u0012QF\u000b\u0005\u0006c\u0001!\tFM\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u00024mA\u0011\u0001\u0004N\u0005\u0003ke\u0011A!\u00168ji\")q\u0007\ra\u0001q\u0005q\u0001/\u0019:uSRLwN\\%oI\u0016D\bC\u0001\r:\u0013\tQ\u0014DA\u0002J]RDQ\u0001\u0010\u0001\u0005Bu\n\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002}A\u0011\u0001dP\u0005\u0003\u0001f\u0011qAQ8pY\u0016\fg\u000eC\u0003C\u0001\u0011\u00053)\u0001\u0005eCR\fG+\u001f9f+\u0005!\u0005CA#I\u001b\u00051%BA$\u0007\u0003\u0015!\u0018\u0010]3t\u0013\tIeI\u0001\u0005ECR\fG+\u001f9f\u0011\u0015Y\u0005\u0001\"\u0015M\u00031)g/\u00197J]R,'O\\1m)\t1S\nC\u0003O\u0015\u0002\u0007q*A\u0003j]B,H\u000f\u0005\u0002Q#6\tA!\u0003\u0002S\t\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015!\u0006\u0001\"\u0011V\u0003%!wnR3o\u0007>$W\rF\u0002W9\u0006\u0004\"a\u0016.\u000e\u0003aS!!\u0017\u0002\u0002\u000f\r|G-Z4f]&\u00111\f\u0017\u0002\t\u000bb\u0004(oQ8eK\")Ql\u0015a\u0001=\u0006\u00191\r\u001e=\u0011\u0005]{\u0016B\u00011Y\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQAY*A\u0002Y\u000b!!\u001a<\t\u000b\u0011\u0004A\u0011I3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001g!\t9'N\u0004\u0002\u0019Q&\u0011\u0011.G\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j3!)q\u0001\u0001C!K\")q\u000e\u0001C!E\u0005IaM]3tQ\u000e{\u0007/\u001f\u0005\bc\u0002\t\t\u0011\"\u0001#\u0003\u0011\u0019w\u000e]=\t\u000fM\u0004\u0011\u0011!C!i\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u001e\t\u0003mnl\u0011a\u001e\u0006\u0003qf\fA\u0001\\1oO*\t!0\u0001\u0003kCZ\f\u0017BA6x\u0011\u001di\b!!A\u0005\u0002y\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012\u0001\u000f\u0005\n\u0003\u0003\u0001\u0011\u0011!C\u0001\u0003\u0007\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0006\u0005-\u0001c\u0001\r\u0002\b%\u0019\u0011\u0011B\r\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u000e}\f\t\u00111\u00019\u0003\rAH%\r\u0005\n\u0003#\u0001\u0011\u0011!C!\u0003'\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003+\u0001b!a\u0006\u0002\u001e\u0005\u0015QBAA\r\u0015\r\tY\"G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0010\u00033\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003G\u0001\u0011\u0011!C\u0001\u0003K\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004}\u0005\u001d\u0002BCA\u0007\u0003C\t\t\u00111\u0001\u0002\u0006!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0013QF\u0001\u0007KF,\u0018\r\\:\u0015\u0007y\ny\u0003\u0003\u0006\u0002\u000e\u0005%\u0012\u0011!a\u0001\u0003\u000bAs\u0001AA\u001a\u0003s\tY\u0004E\u0002\u0012\u0003kI1!a\u000e\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0010\u0002\t{Q\u0001\u0005\t\u0011!?\u001a+fjQ0)S\u0001j\u0003EU3ukJt7\u000fI7p]>$xN\\5dC2d\u0017\u0010I5oGJ,\u0017m]5oO\u00022D'\f2ji\u0002Jg\u000e^3hKJ\u001ch\u0006\t+iK\u0002:WM\\3sCR,G\rI%EA%\u001c\beZ;be\u0006tG/Z3e\u0015\u0001\u0002\u0003\u0005\t\u0011!i>\u0004#-\u001a\u0011n_:|Go\u001c8jG\u0006dG.\u001f\u0011j]\u000e\u0014X-Y:j]\u001e\u0004\u0013M\u001c3!k:L\u0017/^3-A\t,H\u000f\t8pi\u0002\u001awN\\:fGV$\u0018N^3/AQCW\rI2veJ,g\u000e\u001e\u0011j[BdW-\\3oi\u0006$\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011qkR\u001c\b\u0005\u001e5fAA\f'\u000f^5uS>t\u0007%\u0013#!S:\u0004C\u000f[3!kB\u0004XM\u001d\u00114c\u0001\u0012\u0017\u000e^:-A\u0005tG\r\t;iK\u0002bwn^3sAM\u001a\u0004EY5ug\u0002\u0012X\r\u001d:fg\u0016tG\u000f\t;iK\u0002\u0012XmY8sI\u0002rW/\u001c2fe*\u0001\u0003\u0005\t\u0011!A]LG\u000f[5oA\u0015\f7\r\u001b\u0011qCJ$\u0018\u000e^5p]:\u0002C\u000b[3!CN\u001cX/\u001c9uS>t\u0007%[:!i\"\fG\u000f\t;iK\u0002\"\u0017\r^1!MJ\fW.\u001a\u0011iCN\u0004C.Z:tAQD\u0017M\u001c\u00112A\tLG\u000e\\5p]*\u0001\u0003\u0005\t\u0011!AA\f'\u000f^5uS>t7\u000f\f\u0011b]\u0012\u0004S-Y2iAA\f'\u000f^5uS>t\u0007\u0005[1tA1,7o\u001d\u0011uQ\u0006t\u0007\u0005\u000f\u0011cS2d\u0017n\u001c8!e\u0016\u001cwN\u001d3t])\u0001\u0003\u0005\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2!E\u0016\u001c\u0017-^:fA%$8\u000f\t:fgVdG\u000f\t3fa\u0016tGm\u001d\u0011p]\u0002\u0002\u0018M\u001d;ji&|g\u000eI%Eg:R\u0001\u0005I\u0004\n\u0003\u0003\u0012\u0011\u0011!E\u0001\u0003\u0007\n\u0011$T8o_R|g.[2bY2L\u0018J\\2sK\u0006\u001c\u0018N\\4J\tB\u0019\u0011#!\u0012\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u000f\u001aR!!\u0012\u0002Ju\u0001R!a\u0013\u0002R\rj!!!\u0014\u000b\u0007\u0005=\u0013$A\u0004sk:$\u0018.\\3\n\t\u0005M\u0013Q\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0004\u0004bB\u0011\u0002F\u0011\u0005\u0011q\u000b\u000b\u0003\u0003\u0007B!\"a\u0017\u0002F\u0005\u0005IQIA/\u0003!!xn\u0015;sS:<G#A;\t\u0013\u0005\u0005\u0014QIA\u0001\n\u0003\u0013\u0013!B1qa2L\bBCA3\u0003\u000b\n\t\u0011\"!\u0002h\u00059QO\\1qa2LHc\u0001 \u0002j!I\u00111NA2\u0003\u0003\u0005\raI\u0001\u0004q\u0012\u0002\u0004BCA8\u0003\u000b\n\t\u0011\"\u0003\u0002r\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\bE\u0002w\u0003kJ1!a\u001ex\u0005\u0019y%M[3di\u0002")
public class MonotonicallyIncreasingID
extends LeafExpression
implements Stateful,
Serializable {
    private transient long count;
    private transient long partitionMask;
    private final boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;

    public static boolean unapply(MonotonicallyIncreasingID monotonicallyIncreasingID) {
        return MonotonicallyIncreasingID$.MODULE$.unapply(monotonicallyIncreasingID);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful$class.fastEquals(this, other);
    }

    private boolean deterministic$lzycompute() {
        MonotonicallyIncreasingID monotonicallyIncreasingID = this;
        synchronized (monotonicallyIncreasingID) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic$class.deterministic(this);
                this.bitmap$0 = true;
            }
            return this.deterministic;
        }
    }

    @Override
    public final boolean deterministic() {
        return this.bitmap$0 ? this.deterministic : this.deterministic$lzycompute();
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic$class.foldable(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic$class.initialize(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic$class.eval(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic$class.eval$default$1(this);
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.count = 0L;
        this.partitionMask = (long)partitionIndex << 33;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public long evalInternal(InternalRow input) {
        long currentCount = this.count++;
        return this.partitionMask + currentCount;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String countTerm = ctx.addMutableState("long", "count", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String partitionMaskTerm = "partitionMask";
        ctx.addImmutableStateIfNotExists("long", partitionMaskTerm, ctx.addImmutableStateIfNotExists$default$3());
        ctx.addPartitionInitializationStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = 0L;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{countTerm})));
        ctx.addPartitionInitializationStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ((long) partitionIndex) << 33;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionMaskTerm})));
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", " + ", ";\n      ", "++;"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), partitionMaskTerm, countTerm, countTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "monotonically_increasing_id";
    }

    @Override
    public String sql() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}));
    }

    @Override
    public MonotonicallyIncreasingID freshCopy() {
        return new MonotonicallyIncreasingID();
    }

    public MonotonicallyIncreasingID copy() {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public String productPrefix() {
        return "MonotonicallyIncreasingID";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonotonicallyIncreasingID;
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        boolean bl = object instanceof MonotonicallyIncreasingID;
        return bl && ((MonotonicallyIncreasingID)x$1).canEqual(this);
    }

    public MonotonicallyIncreasingID() {
        Nondeterministic$class.$init$(this);
        Stateful$class.$init$(this);
    }
}

