/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import org.spark_project.jetty.client.DuplexConnectionPool;
import org.spark_project.jetty.client.HttpClient;
import org.spark_project.jetty.client.HttpDestination;
import org.spark_project.jetty.client.HttpExchange;
import org.spark_project.jetty.client.HttpRequest;
import org.spark_project.jetty.client.Origin;
import org.spark_project.jetty.client.SendFailure;
import org.spark_project.jetty.client.api.Connection;
import org.spark_project.jetty.util.Callback;
import org.spark_project.jetty.util.annotation.ManagedAttribute;
import org.spark_project.jetty.util.annotation.ManagedObject;
import org.spark_project.jetty.util.thread.Sweeper;

@ManagedObject
public abstract class PoolingHttpDestination<C extends Connection>
extends HttpDestination
implements Callback {
    private DuplexConnectionPool connectionPool;

    public PoolingHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
    }

    @Override
    protected void doStart() throws Exception {
        HttpClient client = this.getHttpClient();
        this.connectionPool = this.newConnectionPool(client);
        this.addBean(this.connectionPool);
        super.doStart();
        Sweeper sweeper = client.getBean(Sweeper.class);
        if (sweeper != null) {
            sweeper.offer(this.connectionPool);
        }
    }

    @Override
    protected void doStop() throws Exception {
        HttpClient client = this.getHttpClient();
        Sweeper sweeper = client.getBean(Sweeper.class);
        if (sweeper != null) {
            sweeper.remove(this.connectionPool);
        }
        super.doStop();
        this.removeBean(this.connectionPool);
    }

    protected DuplexConnectionPool newConnectionPool(HttpClient client) {
        return new DuplexConnectionPool(this, client.getMaxConnectionsPerDestination(), this);
    }

    @ManagedAttribute(value="The connection pool", readonly=true)
    public DuplexConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public void succeeded() {
        this.send();
    }

    @Override
    public void failed(Throwable x) {
        this.abort(x);
    }

    @Override
    public void send() {
        if (this.getHttpExchanges().isEmpty()) {
            return;
        }
        this.process();
    }

    public C acquire() {
        return (C)this.connectionPool.acquire();
    }

    private void process() {
        boolean proceed;
        C connection;
        while ((connection = this.acquire()) != null && (proceed = this.process(connection))) {
        }
    }

    public boolean process(C connection) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", exchange, connection, this);
        }
        if (exchange == null) {
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", client);
                }
                connection.close();
            }
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
            }
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            exchange.abort(cause);
        } else {
            SendFailure result2 = this.send(connection, exchange);
            if (result2 != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send failed {} for {}", result2, exchange);
                }
                if (result2.retry) {
                    this.send(exchange);
                } else {
                    request.abort(result2.failure);
                }
            }
        }
        return this.getHttpExchanges().peek() != null;
    }

    protected abstract SendFailure send(C var1, HttpExchange var2);

    @Override
    public void release(Connection c) {
        HttpClient client;
        Connection connection = c;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", connection);
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                if (this.connectionPool.release(connection)) {
                    this.send();
                } else {
                    connection.close();
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Released explicit {}", connection);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", client);
            }
            connection.close();
        }
    }

    @Override
    public void close(Connection connection) {
        super.close(connection);
        boolean removed = this.connectionPool.remove(connection);
        if (this.getHttpExchanges().isEmpty()) {
            if (this.getHttpClient().isRemoveIdleDestinations() && this.connectionPool.isEmpty()) {
                this.getHttpClient().removeDestination(this);
            }
        } else if (removed) {
            this.process();
        }
    }

    @Override
    public void close() {
        super.close();
        this.connectionPool.close();
    }

    @Override
    public String toString() {
        return String.format("%s,pool=%s", super.toString(), this.connectionPool);
    }
}

