/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.util.LimitedInputStream;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import org.spark_project.guava.io.ByteStreams;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public final class ChunkedByteBuffer$ {
    public static final ChunkedByteBuffer$ MODULE$;

    static {
        new ChunkedByteBuffer$();
    }

    public ChunkedByteBuffer fromManagedBuffer(ManagedBuffer data) {
        ChunkedByteBuffer chunkedByteBuffer;
        ManagedBuffer managedBuffer = data;
        if (managedBuffer instanceof FileSegmentManagedBuffer) {
            FileSegmentManagedBuffer fileSegmentManagedBuffer = (FileSegmentManagedBuffer)managedBuffer;
            chunkedByteBuffer = this.fromFile(fileSegmentManagedBuffer.getFile(), fileSegmentManagedBuffer.getOffset(), fileSegmentManagedBuffer.getLength());
        } else {
            chunkedByteBuffer = new ChunkedByteBuffer(managedBuffer.nioByteBuffer());
        }
        return chunkedByteBuffer;
    }

    public ChunkedByteBuffer fromFile(File file) {
        return this.fromFile(file, 0L, file.length());
    }

    private ChunkedByteBuffer fromFile(File file, long offset, long length) {
        FileInputStream is = new FileInputStream(file);
        ByteStreams.skipFully((InputStream)is, (long)offset);
        LimitedInputStream in = new LimitedInputStream((InputStream)is, length);
        int chunkSize = (int)package$.MODULE$.min((long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH, length);
        ChunkedByteBufferOutputStream out = new ChunkedByteBufferOutputStream(chunkSize, (Function1<Object, ByteBuffer>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ByteBuffer apply(int x$1) {
                return ByteBuffer.allocate(x$1);
            }
        });
        Utils$.MODULE$.tryWithSafeFinally(new Serializable(in, out){
            public static final long serialVersionUID = 0L;
            private final LimitedInputStream in$1;
            private final ChunkedByteBufferOutputStream out$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return IOUtils.copy((InputStream)this.in$1, (OutputStream)this.out$1);
            }
            {
                this.in$1 = in$1;
                this.out$1 = out$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(in, out){
            public static final long serialVersionUID = 0L;
            private final LimitedInputStream in$1;
            private final ChunkedByteBufferOutputStream out$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.in$1.close();
                this.out$1.close();
            }
            {
                this.in$1 = in$1;
                this.out$1 = out$1;
            }
        });
        return out.toChunkedByteBuffer();
    }

    private ChunkedByteBuffer$() {
        MODULE$ = this;
    }
}

