/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.SeqViewLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

public final class CompactibleFileStreamLog$ {
    public static final CompactibleFileStreamLog$ MODULE$;
    private final String COMPACT_FILE_SUFFIX;

    static {
        new CompactibleFileStreamLog$();
    }

    public String COMPACT_FILE_SUFFIX() {
        return this.COMPACT_FILE_SUFFIX;
    }

    public long getBatchIdFromFileName(String fileName) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(fileName)).stripSuffix(this.COMPACT_FILE_SUFFIX()))).toLong();
    }

    public boolean isCompactionBatch(long batchId, int compactInterval2) {
        return (batchId + 1L) % (long)compactInterval2 == 0L;
    }

    public Seq<Object> getValidBatchesBeforeCompactionBatch(long compactionBatchId, int compactInterval2) {
        Predef$.MODULE$.assert(this.isCompactionBatch(compactionBatchId, compactInterval2), (Function0)new Serializable(compactionBatchId){
            public static final long serialVersionUID = 0L;
            private final long compactionBatchId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a compaction batch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.compactionBatchId$1)}));
            }
            {
                this.compactionBatchId$1 = compactionBatchId$1;
            }
        });
        return new RichLong(Predef$.MODULE$.longWrapper(package$.MODULE$.max(0L, compactionBatchId - (long)compactInterval2))).until((Object)BoxesRunTime.boxToLong((long)compactionBatchId));
    }

    public Seq<Object> getAllValidBatches(long batchId, long compactInterval2) {
        Predef$.MODULE$.assert(batchId >= 0L);
        long start2 = package$.MODULE$.max(0L, (batchId + 1L) / compactInterval2 * compactInterval2 - 1L);
        return new RichLong(Predef$.MODULE$.longWrapper(start2)).to((Object)BoxesRunTime.boxToLong((long)batchId));
    }

    public long nextCompactionBatchId(long batchId, long compactInterval2) {
        return (batchId + compactInterval2 + 1L) / compactInterval2 * compactInterval2 - 1L;
    }

    public int deriveCompactInterval(int defaultInterval, int latestCompactBatchId) {
        return latestCompactBatchId + 1 <= defaultInterval ? latestCompactBatchId + 1 : (defaultInterval < (latestCompactBatchId + 1) / 2 ? BoxesRunTime.unboxToInt((Object)this.properDivisors$1(defaultInterval, latestCompactBatchId + 1).head()) : latestCompactBatchId + 1);
    }

    private final SeqView properDivisors$1(int min, int n) {
        return (SeqView)((SeqViewLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(min), n / 2).view().filter((Function1)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return this.n$1 % i == 0;
            }
            {
                this.n$1 = n$1;
            }
        })).$colon$plus((Object)BoxesRunTime.boxToInteger((int)n), SeqView$.MODULE$.canBuildFrom());
    }

    private CompactibleFileStreamLog$() {
        MODULE$ = this;
        this.COMPACT_FILE_SUFFIX = ".compact";
    }
}

