/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleSecretManager
implements SecretKeyHolder {
    private static final Logger logger = LoggerFactory.getLogger(ShuffleSecretManager.class);
    private final ConcurrentHashMap<String, String> shuffleSecretMap = new ConcurrentHashMap();
    private static final String SPARK_SASL_USER = "sparkSaslUser";

    public void registerApp(String appId, String shuffleSecret) {
        this.shuffleSecretMap.put(appId, shuffleSecret);
        logger.info("Registered shuffle secret for application {}", (Object)appId);
    }

    public void registerApp(String appId, ByteBuffer shuffleSecret) {
        this.registerApp(appId, JavaUtils.bytesToString((ByteBuffer)shuffleSecret));
    }

    public void unregisterApp(String appId) {
        this.shuffleSecretMap.remove(appId);
        logger.info("Unregistered shuffle secret for application {}", (Object)appId);
    }

    public String getSaslUser(String appId) {
        return SPARK_SASL_USER;
    }

    public String getSecretKey(String appId) {
        return this.shuffleSecretMap.get(appId);
    }
}

