/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import com.google.common.base.Supplier;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.calcite.rex.RexNode;

public final class LogicalFilter
extends Filter {
    public LogicalFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
    }

    @Deprecated
    public LogicalFilter(RelOptCluster cluster, RelNode child, RexNode condition) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), child, condition);
    }

    public LogicalFilter(RelInput input) {
        super(input);
    }

    public static LogicalFilter create(final RelNode input, RexNode condition) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            public List<RelCollation> get() {
                return RelMdCollation.filter(input);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            public RelDistribution get() {
                return RelMdDistribution.filter(input);
            }
        });
        return new LogicalFilter(cluster, traitSet, input, condition);
    }

    @Override
    public LogicalFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }
}

