/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.scheduler.cluster.k8s.PodUnknown;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ExecutorPodsSnapshot$
implements Logging,
Serializable {
    public static final ExecutorPodsSnapshot$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ExecutorPodsSnapshot$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public ExecutorPodsSnapshot apply(Seq<Pod> executorPods) {
        return new ExecutorPodsSnapshot(this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toStatesByExecutorId(executorPods));
    }

    public ExecutorPodsSnapshot apply() {
        return new ExecutorPodsSnapshot((Map<Object, ExecutorPodState>)Predef$.MODULE$.Map().empty());
    }

    public Map<Object, ExecutorPodState> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toStatesByExecutorId(Seq<Pod> executorPods) {
        return ((TraversableOnce)executorPods.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, ExecutorPodState> apply(Pod pod) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString((String)pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()))).toLong()), (Object)ExecutorPodsSnapshot$.MODULE$.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toState(pod));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public ExecutorPodState org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toState(Pod pod) {
        Product product;
        if (this.isDeleted(pod)) {
            product = new PodDeleted(pod);
        } else {
            Product product2;
            String phase2 = pod.getStatus().getPhase().toLowerCase();
            String string = phase2;
            if ("pending".equals(string)) {
                product2 = new PodPending(pod);
            } else if ("running".equals(string)) {
                product2 = new PodRunning(pod);
            } else if ("failed".equals(string)) {
                product2 = new PodFailed(pod);
            } else if ("succeeded".equals(string)) {
                product2 = new PodSucceeded(pod);
            } else {
                this.logWarning((Function0<String>)new Serializable(pod, phase2){
                    public static final long serialVersionUID = 0L;
                    private final Pod pod$1;
                    private final String phase$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received unknown phase ", " for executor pod with name"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.phase$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " in namespace ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pod$1.getMetadata().getName(), this.pod$1.getMetadata().getNamespace()}))).toString();
                    }
                    {
                        this.pod$1 = pod$1;
                        this.phase$1 = phase$1;
                    }
                });
                product2 = new PodUnknown(pod);
            }
            product = product2;
        }
        return product;
    }

    private boolean isDeleted(Pod pod) {
        return pod.getMetadata().getDeletionTimestamp() != null;
    }

    public ExecutorPodsSnapshot apply(Map<Object, ExecutorPodState> executorPods) {
        return new ExecutorPodsSnapshot(executorPods);
    }

    public Option<Map<Object, ExecutorPodState>> unapply(ExecutorPodsSnapshot x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.executorPods());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExecutorPodsSnapshot$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

