/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!B\u0001\u0003\u0001!q!aF'pk:$hk\u001c7v[\u0016\u001ch)Z1ukJ,7\u000b^3q\u0015\t\u0019A!\u0001\u0005gK\u0006$XO]3t\u0015\t)a!A\u0002lqMT!a\u0002\u0005\u0002\r\u0011,\u0007\u000f\\8z\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u00037-+(-\u001a:oKR,7OR3biV\u0014XmQ8oM&<7\u000b^3q\u0011!Q\u0002A!A!\u0002\u0013a\u0012AD6vE\u0016\u0014h.\u001a;fg\u000e{gNZ\u0002\u0001a\ti2\u0005E\u0002\u001f?\u0005j\u0011\u0001B\u0005\u0003A\u0011\u0011abS;cKJtW\r^3t\u0007>tg\r\u0005\u0002#G1\u0001A!\u0003\u0013\u001a\u0003\u0003\u0005\tQ!\u0001&\u0005\ryF%M\t\u0003M%\u0002\"\u0001E\u0014\n\u0005!\n\"a\u0002(pi\"Lgn\u001a\t\u0003=)J!a\u000b\u0003\u00035-+(-\u001a:oKR,7OU8mKN\u0003XmY5gS\u000e\u001cuN\u001c4\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\ty\u0003\u0007\u0005\u0002\u0017\u0001!)!\u0004\fa\u0001cA\u0012!\u0007\u000e\t\u0004=}\u0019\u0004C\u0001\u00125\t%!\u0003'!A\u0001\u0002\u000b\u0005Q\u0005C\u00037\u0001\u0011\u0005s'\u0001\u0007d_:4\u0017nZ;sKB{G\r\u0006\u00029wA\u0011a$O\u0005\u0003u\u0011\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006yU\u0002\r\u0001O\u0001\u0004a>$\u0007\"\u0002 \u0001\t\u0003z\u0014\u0001I4fi\u0006#G-\u001b;j_:\fG\u000eU8e'f\u001cH/Z7Qe>\u0004XM\u001d;jKN$\u0012\u0001\u0011\t\u0005\u0003\u0012;uI\u0004\u0002\u0011\u0005&\u00111)E\u0001\u0007!J,G-\u001a4\n\u0005\u00153%aA'ba*\u00111)\u0005\t\u0003\u0003\"K!!\u0013$\u0003\rM#(/\u001b8h\u0011\u0015Y\u0005\u0001\"\u0011M\u0003\u0001:W\r^!eI&$\u0018n\u001c8bY.+(-\u001a:oKR,7OU3t_V\u00148-Z:\u0015\u00035\u00032A\u0014,Z\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002S7\u00051AH]8pizJ\u0011AE\u0005\u0003+F\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n\u00191+Z9\u000b\u0005U\u000b\u0002C\u0001.f\u001b\u0005Y&B\u0001/^\u0003\u0015iw\u000eZ3m\u0015\tqv,A\u0002ba&T!\u0001Y1\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002cG\u00069a-\u00192sS\u000eD$\"\u00013\u0002\u0005%|\u0017B\u00014\\\u0005-A\u0015m]'fi\u0006$\u0017\r^1\t\u000b!\u0004A\u0011B5\u0002!\r|gn\u001d;sk\u000e$hk\u001c7v[\u0016\u001cHC\u00016w!\rq5.\\\u0005\u0003Yb\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005!9\u00048/\u0003\u0002p#\t1A+\u001e9mKJ\u0002\"AW9\n\u0005I\\&a\u0003,pYVlW-T8v]R\u0004\"A\u0017;\n\u0005U\\&A\u0002,pYVlW\rC\u0003xO\u0002\u0007\u00010A\u0006w_2,X.Z*qK\u000e\u001c\bc\u0001(lsB\u0012!P \t\u0004=ml\u0018B\u0001?\u0005\u0005QYUOY3s]\u0016$Xm\u001d,pYVlWm\u00159fGB\u0011!E \u0003\u000b\u007fZ\f\t\u0011!A\u0003\u0002\u0005\u0005!aA0%eE\u0019a%a\u0001\u0011\u0007y\t)!C\u0002\u0002\b\u0011\u0011AdS;cKJtW\r^3t->dW/\\3Ta\u0016\u001c\u0017NZ5d\u0007>tg\r")
public class MountVolumesFeatureStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf;

    @Override
    public SparkPod configurePod(SparkPod pod) {
        Tuple2 tuple2 = this.constructVolumes(this.kubernetesConf.roleVolumes()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterable volumeMounts = (Iterable)tuple2._1();
            Iterable volumes = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)volumeMounts, (Object)volumes);
            Iterable volumeMounts2 = (Iterable)tuple23._1();
            Iterable volumes2 = (Iterable)tuple23._2();
            Pod podWithVolumes = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editSpec().addToVolumes((Volume[])volumes2.toSeq().toArray(ClassTag$.MODULE$.apply(Volume.class)))).endSpec()).build();
            Container containerWithVolumeMounts = ((ContainerBuilder)new ContainerBuilder(pod.container()).addToVolumeMounts((VolumeMount[])volumeMounts2.toSeq().toArray(ClassTag$.MODULE$.apply(VolumeMount.class)))).build();
            return new SparkPod(podWithVolumes, containerWithVolumeMounts);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Iterable<Tuple2<VolumeMount, Volume>> constructVolumes(Iterable<KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf>> volumeSpecs) {
        return (Iterable)volumeSpecs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<VolumeMount, Volume> apply(KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf> spec) {
                KubernetesVolumeSpecificConf kubernetesVolumeSpecificConf;
                block5: {
                    VolumeBuilder volumeBuilder;
                    VolumeMount volumeMount;
                    block3: {
                        block4: {
                            block2: {
                                volumeMount = ((VolumeMountBuilder)((VolumeMountFluentImpl)((VolumeMountFluentImpl)new VolumeMountBuilder().withMountPath(spec.mountPath())).withReadOnly(Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly()))).withName(spec.volumeName())).build();
                                kubernetesVolumeSpecificConf = spec.volumeConf();
                                if (!(kubernetesVolumeSpecificConf instanceof KubernetesHostPathVolumeConf)) break block2;
                                KubernetesHostPathVolumeConf kubernetesHostPathVolumeConf = (KubernetesHostPathVolumeConf)kubernetesVolumeSpecificConf;
                                String hostPath = kubernetesHostPathVolumeConf.hostPath();
                                volumeBuilder = (VolumeBuilder)new VolumeBuilder().withHostPath(new HostPathVolumeSource(hostPath));
                                break block3;
                            }
                            if (!(kubernetesVolumeSpecificConf instanceof KubernetesPVCVolumeConf)) break block4;
                            KubernetesPVCVolumeConf kubernetesPVCVolumeConf = (KubernetesPVCVolumeConf)kubernetesVolumeSpecificConf;
                            String claimName = kubernetesPVCVolumeConf.claimName();
                            volumeBuilder = (VolumeBuilder)new VolumeBuilder().withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, Predef$.MODULE$.boolean2Boolean(spec.mountReadOnly())));
                            break block3;
                        }
                        if (!(kubernetesVolumeSpecificConf instanceof KubernetesEmptyDirVolumeConf)) break block5;
                        KubernetesEmptyDirVolumeConf kubernetesEmptyDirVolumeConf = (KubernetesEmptyDirVolumeConf)kubernetesVolumeSpecificConf;
                        Option<String> medium = kubernetesEmptyDirVolumeConf.medium();
                        Option<String> sizeLimit = kubernetesEmptyDirVolumeConf.sizeLimit();
                        volumeBuilder = (VolumeBuilder)new VolumeBuilder().withEmptyDir(new EmptyDirVolumeSource((String)medium.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }), new Quantity((String)sizeLimit.orNull(Predef$.MODULE$.$conforms()))));
                    }
                    VolumeBuilder volumeBuilder2 = volumeBuilder;
                    Volume volume = ((VolumeBuilder)volumeBuilder2.withName(spec.volumeName())).build();
                    return new Tuple2((Object)volumeMount, (Object)volume);
                }
                throw new MatchError((Object)kubernetesVolumeSpecificConf);
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public MountVolumesFeatureStep(KubernetesConf<? extends KubernetesRoleSpecificConf> kubernetesConf) {
        this.kubernetesConf = kubernetesConf;
    }
}

