/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!B\u0001\u0003\u0001!q!\u0001\u0007\"bg&\u001cW\t_3dkR|'OR3biV\u0014Xm\u0015;fa*\u00111\u0001B\u0001\tM\u0016\fG/\u001e:fg*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u0019!W\r\u001d7ps*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005mYUOY3s]\u0016$Xm\u001d$fCR,(/Z\"p]\u001aLwm\u0015;fa\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\blk\n,'O\\3uKN\u001cuN\u001c4\u0004\u0001A\u0019QD\b\u0011\u000e\u0003\u0011I!a\b\u0003\u0003\u001d-+(-\u001a:oKR,7oQ8oMB\u0011Q$I\u0005\u0003E\u0011\u0011adS;cKJtW\r^3t\u000bb,7-\u001e;peN\u0003XmY5gS\u000e\u001cuN\u001c4\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u0017\u0001!)!d\ta\u00019!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0013AF3yK\u000e,Ho\u001c:FqR\u0014\u0018m\u00117bgN\u0004\u0018\r\u001e5\u0016\u0003-\u00022\u0001\u0005\u0017/\u0013\ti\u0013C\u0001\u0004PaRLwN\u001c\t\u0003_Ir!\u0001\u0005\u0019\n\u0005E\n\u0012A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!M\t\t\rY\u0002\u0001\u0015!\u0003,\u0003])\u00070Z2vi>\u0014X\t\u001f;sC\u000ec\u0017m]:qCRD\u0007\u0005C\u00049\u0001\t\u0007I\u0011B\u001d\u0002-\u0015DXmY;u_J\u001cuN\u001c;bS:,'/S7bO\u0016,\u0012A\f\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u0018\u0002/\u0015DXmY;u_J\u001cuN\u001c;bS:,'/S7bO\u0016\u0004\u0003bB\u001f\u0001\u0005\u0004%IAP\u0001\u0011E2|7m['b]\u0006<WM\u001d)peR,\u0012a\u0010\t\u0003!\u0001K!!Q\t\u0003\u0007%sG\u000f\u0003\u0004D\u0001\u0001\u0006IaP\u0001\u0012E2|7m['b]\u0006<WM\u001d)peR\u0004\u0003bB#\u0001\u0005\u0004%I!O\u0001\u0016Kb,7-\u001e;peB{GMT1nKB\u0013XMZ5y\u0011\u00199\u0005\u0001)A\u0005]\u00051R\r_3dkR|'\u000fU8e\u001d\u0006lW\r\u0015:fM&D\b\u0005C\u0004J\u0001\t\u0007I\u0011B\u001d\u0002\u0013\u0011\u0014\u0018N^3s+Jd\u0007BB&\u0001A\u0003%a&\u0001\u0006ee&4XM]+sY\u0002Bq!\u0014\u0001C\u0002\u0013%a*A\tfq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=NS\n+\u0012a\u0014\t\u0003!AK!!U\t\u0003\t1{gn\u001a\u0005\u0007'\u0002\u0001\u000b\u0011B(\u0002%\u0015DXmY;u_JlU-\\8ss6K'\t\t\u0005\b+\u0002\u0011\r\u0011\"\u0003:\u0003Q)\u00070Z2vi>\u0014X*Z7pef\u001cFO]5oO\"1q\u000b\u0001Q\u0001\n9\nQ#\u001a=fGV$xN]'f[>\u0014\u0018p\u0015;sS:<\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011\u0002(\u0002#5,Wn\u001c:z\u001fZ,'\u000f[3bI6K'\t\u0003\u0004\\\u0001\u0001\u0006IaT\u0001\u0013[\u0016lwN]=Pm\u0016\u0014\b.Z1e\u001b&\u0014\u0005\u0005C\u0004^\u0001\t\u0007I\u0011\u0002(\u00025\u0015DXmY;u_JlU-\\8ss^KG\u000f[(wKJDW-\u00193\t\r}\u0003\u0001\u0015!\u0003P\u0003m)\u00070Z2vi>\u0014X*Z7pef<\u0016\u000e\u001e5Pm\u0016\u0014\b.Z1eA!9\u0011\r\u0001b\u0001\n\u0013q\u0015aE3yK\u000e,Ho\u001c:NK6|'/\u001f+pi\u0006d\u0007BB2\u0001A\u0003%q*\u0001\u000bfq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=U_R\fG\u000e\t\u0005\bK\u0002\u0011\r\u0011\"\u0003?\u00035)\u00070Z2vi>\u00148i\u001c:fg\"1q\r\u0001Q\u0001\n}\na\"\u001a=fGV$xN]\"pe\u0016\u001c\b\u0005C\u0004j\u0001\t\u0007I\u0011B\u001d\u0002)\u0015DXmY;u_J\u001cuN]3t%\u0016\fX/Z:u\u0011\u0019Y\u0007\u0001)A\u0005]\u0005)R\r_3dkR|'oQ8sKN\u0014V-];fgR\u0004\u0003bB7\u0001\u0005\u0004%IAK\u0001\u0013Kb,7-\u001e;pe2KW.\u001b;D_J,7\u000f\u0003\u0004p\u0001\u0001\u0006IaK\u0001\u0014Kb,7-\u001e;pe2KW.\u001b;D_J,7\u000f\t\u0005\u0006c\u0002!\tE]\u0001\rG>tg-[4ve\u0016\u0004v\u000e\u001a\u000b\u0003gZ\u0004\"!\b;\n\u0005U$!\u0001C*qCJ\\\u0007k\u001c3\t\u000b]\u0004\b\u0019A:\u0002\u0007A|G\rC\u0003z\u0001\u0011\u0005#0\u0001\u0011hKR\fE\rZ5uS>t\u0017\r\u001c)pINK8\u000f^3n!J|\u0007/\u001a:uS\u0016\u001cH#A>\u0011\t=bhFL\u0005\u0003{R\u00121!T1q\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005\u0001s-\u001a;BI\u0012LG/[8oC2\\UOY3s]\u0016$Xm\u001d*fg>,(oY3t)\t\t\u0019\u0001\u0005\u0004\u0002\u0006\u0005U\u00111\u0004\b\u0005\u0003\u000f\t\tB\u0004\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiaG\u0001\u0007yI|w\u000e\u001e \n\u0003II1!a\u0005\u0012\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0006\u0002\u001a\t\u00191+Z9\u000b\u0007\u0005M\u0011\u0003\u0005\u0003\u0002\u001e\u0005MRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000b5|G-\u001a7\u000b\t\u0005\u0015\u0012qE\u0001\u0004CBL'\u0002BA\u0015\u0003W\t!b[;cKJtW\r^3t\u0015\u0011\ti#a\f\u0002\u000f\u0019\f'M]5dq)\u0011\u0011\u0011G\u0001\u0003S>LA!!\u000e\u0002 \tY\u0001*Y:NKR\fG-\u0019;b\u0001")
public class BasicExecutorFeatureStep
implements KubernetesFeatureConfigStep {
    public final KubernetesConf<KubernetesExecutorSpecificConf> org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf;
    private final Option<String> executorExtraClasspath;
    private final String executorContainerImage;
    private final int blockManagerPort;
    private final String executorPodNamePrefix;
    private final String driverUrl;
    private final long org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryMiB;
    private final String executorMemoryString;
    private final long memoryOverheadMiB;
    private final long org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryWithOverhead;
    private final long executorMemoryTotal;
    private final int executorCores;
    private final String executorCoresRequest;
    private final Option<String> executorLimitCores;

    private Option<String> executorExtraClasspath() {
        return this.executorExtraClasspath;
    }

    private String executorContainerImage() {
        return this.executorContainerImage;
    }

    private int blockManagerPort() {
        return this.blockManagerPort;
    }

    private String executorPodNamePrefix() {
        return this.executorPodNamePrefix;
    }

    private String driverUrl() {
        return this.driverUrl;
    }

    public long org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryMiB() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryMiB;
    }

    private String executorMemoryString() {
        return this.executorMemoryString;
    }

    private long memoryOverheadMiB() {
        return this.memoryOverheadMiB;
    }

    public long org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryWithOverhead() {
        return this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryWithOverhead;
    }

    private long executorMemoryTotal() {
        return this.executorMemoryTotal;
    }

    private int executorCores() {
        return this.executorCores;
    }

    private String executorCoresRequest() {
        return this.executorCoresRequest;
    }

    private Option<String> executorLimitCores() {
        return this.executorLimitCores;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-exec-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorPodNamePrefix(), this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.roleSpecificConf().executorId()}));
        String hostname = name.substring(Math.max(0, name.length() - 63));
        Quantity executorMemoryQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "Mi"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.executorMemoryTotal())})))).build();
        Quantity executorCpuQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(this.executorCoresRequest())).build();
        Option executorExtraClasspathEnv = this.executorExtraClasspath().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EnvVar apply(String cp) {
                return ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_CLASSPATH())).withValue(cp)).build();
            }
        });
        Seq executorExtraJavaOptionsEnv = (Seq)((Option)this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStep $outer;

            public final Seq<EnvVar> apply(String opts) {
                String subsOpts = Utils$.MODULE$.substituteAppNExecIds(opts, this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.appId(), this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.roleSpecificConf().executorId());
                Seq delimitedOpts = Utils$.MODULE$.splitCommandString(subsOpts);
                return (Seq)((TraversableLike)delimitedOpts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final EnvVar apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String opt = (String)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Constants$.MODULE$.ENV_JAVA_OPT_PREFIX(), BoxesRunTime.boxToInteger((int)index)})))).withValue(opt)).build();
                            return envVar;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<EnvVar> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        Seq executorEnv = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.ENV_DRIVER_URL(), (Object)this.driverUrl()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES(), (Object)((Object)BoxesRunTime.boxToInteger((int)this.executorCores())).toString()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY(), (Object)this.executorMemoryString()), new Tuple2((Object)Constants$.MODULE$.ENV_APPLICATION_ID(), (Object)this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.appId()), new Tuple2((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR(), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), new Tuple2((Object)Constants$.MODULE$.ENV_EXECUTOR_ID(), (Object)this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.roleSpecificConf().executorId())}))).$plus$plus(this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.roleEnvs(), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final EnvVar apply(Tuple2<String, String> env) {
                return ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName((String)env._1())).withValue((String)env._2())).build();
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EnvVar[]{((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(Constants$.MODULE$.ENV_EXECUTOR_POD_IP())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).build()})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)executorExtraJavaOptionsEnv, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(executorExtraClasspathEnv).toSeq(), Seq$.MODULE$.canBuildFrom());
        Seq requiredPorts = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME(), (Object)BoxesRunTime.boxToInteger((int)this.blockManagerPort()))}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ContainerPort apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortFluentImpl)new ContainerPortBuilder().withName(name)).withContainerPort(Predef$.MODULE$.int2Integer(port))).build();
                    return containerPort;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Container executorContainer = ((ContainerBuilder)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluent.ResourcesNested)((ContainerFluentImpl)((ContainerFluentImpl)((ContainerFluentImpl)new ContainerBuilder(pod.container()).withName("executor")).withImage(this.executorContainerImage())).withImagePullPolicy(this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.imagePullPolicy())).withNewResources().addToRequests("memory", executorMemoryQuantity).addToLimits("memory", executorMemoryQuantity).addToRequests("cpu", executorCpuQuantity)).endResources()).addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(executorEnv).asJava())).withPorts((List)JavaConverters$.MODULE$.seqAsJavaListConverter(requiredPorts).asJava())).addToArgs(new String[]{"executor"})).build();
        Container containerWithLimitCores = (Container)this.executorLimitCores().map((Function1)new Serializable(this, executorContainer){
            public static final long serialVersionUID = 0L;
            private final Container executorContainer$1;

            public final Container apply(String limitCores) {
                Quantity executorCpuLimitQuantity = ((QuantityBuilder)new QuantityBuilder(Predef$.MODULE$.boolean2Boolean(false)).withAmount(limitCores)).build();
                return ((ContainerBuilder)((ContainerFluent.ResourcesNested)new ContainerBuilder(this.executorContainer$1).editResources().addToLimits("cpu", executorCpuLimitQuantity)).endResources()).build();
            }
            {
                this.executorContainer$1 = executorContainer$1;
            }
        }).getOrElse((Function0)new Serializable(this, executorContainer){
            public static final long serialVersionUID = 0L;
            private final Container executorContainer$1;

            public final Container apply() {
                return this.executorContainer$1;
            }
            {
                this.executorContainer$1 = executorContainer$1;
            }
        });
        Option<Pod> driverPod = this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.roleSpecificConf().driverPod();
        Option ownerReference = driverPod.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final OwnerReference apply(Pod pod) {
                return ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withController(Predef$.MODULE$.boolean2Boolean(true))).withApiVersion(pod.getApiVersion())).withKind(pod.getKind())).withName(pod.getMetadata().getName())).withUid(pod.getMetadata().getUid())).build();
            }
        });
        Pod executorPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(pod.pod()).editOrNewMetadata().withName(name).withLabels((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.roleLabels()).asJava()).withAnnotations((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.roleAnnotations()).asJava()).addToOwnerReferences((OwnerReference[])Option$.MODULE$.option2Iterable(ownerReference).toSeq().toArray(ClassTag$.MODULE$.apply(OwnerReference.class)))).endMetadata()).editOrNewSpec().withHostname(hostname).withRestartPolicy("Never").withNodeSelector((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.nodeSelector()).asJava()).addToImagePullSecrets((LocalObjectReference[])this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.imagePullSecrets().toArray(ClassTag$.MODULE$.apply(LocalObjectReference.class)))).endSpec()).build();
        return new SparkPod(executorPod, containerWithLimitCores);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public BasicExecutorFeatureStep(KubernetesConf<KubernetesExecutorSpecificConf> kubernetesConf) {
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf = kubernetesConf;
        this.executorExtraClasspath = (Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CLASS_PATH());
        this.executorContainerImage = (String)kubernetesConf.get(Config$.MODULE$.EXECUTOR_CONTAINER_IMAGE()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("Must specify the executor container image");
            }
        });
        this.blockManagerPort = kubernetesConf.sparkConf().getInt("spark.blockmanager.port", Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        this.executorPodNamePrefix = kubernetesConf.appResourceNamePrefix();
        this.driverUrl = RpcEndpointAddress$.MODULE$.apply(kubernetesConf.get("spark.driver.host"), kubernetesConf.sparkConf().getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT()), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryMiB = BoxesRunTime.unboxToLong((Object)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        this.executorMemoryString = kubernetesConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().key(), org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY().defaultValueString());
        this.memoryOverheadMiB = BoxesRunTime.unboxToLong((Object)((Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStep $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return package$.MODULE$.max((long)((int)(BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR())) * (double)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryMiB())), Constants$.MODULE$.MEMORY_OVERHEAD_MIN_MIB());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryWithOverhead = this.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryMiB() + this.memoryOverheadMiB();
        this.executorMemoryTotal = BoxesRunTime.unboxToLong((Object)kubernetesConf.sparkConf().getOption(Config$.MODULE$.APP_RESOURCE_TYPE().key()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStep $outer;

            public final long apply(String res) {
                String string = res;
                int n = "python".equals(string) ? BoxesRunTime.unboxToInt((Object)((Option)this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$kubernetesConf.sparkConf().get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.PYSPARK_EXECUTOR_MEMORY())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(long x$1) {
                        return this.apply$mcIJ$sp(x$1);
                    }

                    public int apply$mcIJ$sp(long x$1) {
                        return (int)x$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                })) : 0;
                int additionalPySparkMemory = n;
                return this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryWithOverhead() + (long)additionalPySparkMemory;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicExecutorFeatureStep $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.org$apache$spark$deploy$k8s$features$BasicExecutorFeatureStep$$executorMemoryWithOverhead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.executorCores = kubernetesConf.sparkConf().getInt("spark.executor.cores", 1);
        this.executorCoresRequest = kubernetesConf.sparkConf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES()) ? (String)((Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)Config$.MODULE$.KUBERNETES_EXECUTOR_REQUEST_CORES())).get() : ((Object)BoxesRunTime.boxToInteger((int)this.executorCores())).toString();
        this.executorLimitCores = (Option)kubernetesConf.get((ConfigEntry<KubernetesExecutorSpecificConf>)Config$.MODULE$.KUBERNETES_EXECUTOR_LIMIT_CORES());
    }
}

