/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SchedulerBackendUtils$ {
    public static final SchedulerBackendUtils$ MODULE$;
    private final int DEFAULT_NUMBER_EXECUTORS;

    static {
        new SchedulerBackendUtils$();
    }

    public int DEFAULT_NUMBER_EXECUTORS() {
        return this.DEFAULT_NUMBER_EXECUTORS;
    }

    public int getInitialTargetExecutorNumber(SparkConf conf, int numExecutors) {
        int n;
        if (Utils$.MODULE$.isDynamicAllocationEnabled(conf)) {
            int minNumExecutors = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()));
            int initialNumExecutors = Utils$.MODULE$.getDynamicAllocationInitialExecutors(conf);
            int maxNumExecutors = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DYN_ALLOCATION_MAX_EXECUTORS()));
            Predef$.MODULE$.require(initialNumExecutors >= minNumExecutors && initialNumExecutors <= maxNumExecutors, (Function0)new Serializable(minNumExecutors, initialNumExecutors, maxNumExecutors){
                public static final long serialVersionUID = 0L;
                private final int minNumExecutors$1;
                private final int initialNumExecutors$1;
                private final int maxNumExecutors$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initial executor number ", " must between min executor number "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.initialNumExecutors$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and max executor number ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.minNumExecutors$1), BoxesRunTime.boxToInteger((int)this.maxNumExecutors$1)}))).toString();
                }
                {
                    this.minNumExecutors$1 = minNumExecutors$1;
                    this.initialNumExecutors$1 = initialNumExecutors$1;
                    this.maxNumExecutors$1 = maxNumExecutors$1;
                }
            });
            n = initialNumExecutors;
        } else {
            n = BoxesRunTime.unboxToInt((Object)((Option)conf.get(package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)new Serializable(numExecutors){
                public static final long serialVersionUID = 0L;
                private final int numExecutors$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.numExecutors$1;
                }
                {
                    this.numExecutors$1 = numExecutors$1;
                }
            }));
        }
        return n;
    }

    public int getInitialTargetExecutorNumber$default$2() {
        return this.DEFAULT_NUMBER_EXECUTORS();
    }

    private SchedulerBackendUtils$() {
        MODULE$ = this;
        this.DEFAULT_NUMBER_EXECUTORS = 2;
    }
}

