/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.ClusteringEvaluator$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u00015\u00111c\u00117vgR,'/\u001b8h\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%ii\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005%)e/\u00197vCR|'\u000f\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u000511\u000f[1sK\u0012T!a\u0006\u0003\u0002\u000bA\f'/Y7\n\u0005e!\"\u0001\u0005%bgB\u0013X\rZ5di&|gnQ8m!\t\u00192$\u0003\u0002\u001d)\tq\u0001*Y:GK\u0006$XO]3t\u0007>d\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0011)H/\u001b7\n\u0005\tz\"!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u0019!C!K\u0005\u0019Q/\u001b3\u0016\u0003\u0019\u0002\"aJ\u0017\u000f\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y%B3aI\u00198!\t\u0011T'D\u00014\u0015\t!d!\u0001\u0006b]:|G/\u0019;j_:L!AN\u001a\u0003\u000bMKgnY3\"\u0003a\nQA\r\u00184]AB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0005k&$\u0007\u0005K\u0002:c]BQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDCA A!\ty\u0001\u0001C\u0003%y\u0001\u0007a\u0005K\u0002Ac]B3\u0001P\u00198\u0011\u0015i\u0004\u0001\"\u0001E)\u0005y\u0004fA\"2o!)q\t\u0001C!\u0011\u0006!1m\u001c9z)\ty\u0014\nC\u0003K\r\u0002\u00071*\u0001\u0003q\u001b\u0006\u0004\bC\u0001'N\u001b\u00051\u0012B\u0001(\u0017\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001$2o!)\u0011\u000b\u0001C!%\u0006q\u0011n\u001d'be\u001e,'OQ3ui\u0016\u0014X#A*\u0011\u0005!\"\u0016BA+*\u0005\u001d\u0011un\u001c7fC:D3\u0001U\u00198\u0011\u0015A\u0006\u0001\"\u0001Z\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002[76\t\u0001\u0001C\u0003]/\u0002\u0007a%A\u0003wC2,X\rK\u0002Xc]BQa\u0018\u0001\u0005\u0002\u0001\fab]3u\r\u0016\fG/\u001e:fg\u000e{G\u000e\u0006\u0002[C\")AL\u0018a\u0001M!\u001aa,M\u001c\t\u000f\u0011\u0004!\u0019!C\u0001K\u0006QQ.\u001a;sS\u000et\u0015-\\3\u0016\u0003\u0019\u00042\u0001T4'\u0013\tAgCA\u0003QCJ\fW\u000eK\u0002dc]Baa\u001b\u0001!\u0002\u00131\u0017aC7fiJL7MT1nK\u0002B3A[\u00198\u0011\u0015q\u0007\u0001\"\u0001&\u000359W\r^'fiJL7MT1nK\"\u001aQ.M\u001c\t\u000bE\u0004A\u0011\u0001:\u0002\u001bM,G/T3ue&\u001cg*Y7f)\tQ6\u000fC\u0003]a\u0002\u0007a\u0005K\u0002qc]BQA\u001e\u0001\u0005B]\f\u0001\"\u001a<bYV\fG/\u001a\u000b\u0003qn\u0004\"\u0001K=\n\u0005iL#A\u0002#pk\ndW\rC\u0003}k\u0002\u0007Q0A\u0004eCR\f7/\u001a;1\u0007y\fi\u0001E\u0003\u0000\u0003\u000b\tI!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0004\u0002\u0007M\fH.\u0003\u0003\u0002\b\u0005\u0005!a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u0017\ti\u0001\u0004\u0001\u0005\u0017\u0005=10!A\u0001\u0002\u000b\u0005\u0011\u0011\u0003\u0002\u0004?\u0012\n\u0014\u0003BA\n\u00033\u00012\u0001KA\u000b\u0013\r\t9\"\u000b\u0002\b\u001d>$\b.\u001b8h!\rA\u00131D\u0005\u0004\u0003;I#aA!os\"\u001aQ/M\u001c)\u0007\u0001\tt\u0007K\u0002\u0001\u0003K\u00012AMA\u0014\u0013\r\tIc\r\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\\\u0004\b\u0003[\u0011\u0001\u0012AA\u0018\u0003M\u0019E.^:uKJLgnZ#wC2,\u0018\r^8s!\ry\u0011\u0011\u0007\u0004\u0007\u0003\tA\t!a\r\u0014\u0011\u0005E\u0012QGA\u001e\u0003\u0003\u00022\u0001KA\u001c\u0013\r\tI$\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\ty\tidP\u0005\u0004\u0003\u007fy\"!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0004Q\u0005\r\u0013bAA#S\ta1+\u001a:jC2L'0\u00192mK\"9Q(!\r\u0005\u0002\u0005%CCAA\u0018\u0011!\ti%!\r\u0005B\u0005=\u0013\u0001\u00027pC\u0012$2aPA)\u0011\u001d\t\u0019&a\u0013A\u0002\u0019\nA\u0001]1uQ\"\"\u00111J\u00198\u0011)\tI&!\r\u0002\u0002\u0013%\u00111L\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002^A!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014\u0001\u00027b]\u001eT!!a\u001a\u0002\t)\fg/Y\u0005\u0005\u0003W\n\tG\u0001\u0004PE*,7\r\u001e\u0015\u0005\u0003c\tt\u0007\u000b\u0003\u0002,E:\u0004")
public class ClusteringEvaluator
extends Evaluator
implements HasPredictionCol,
HasFeaturesCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> featuresCol;
    private final Param<String> predictionCol;

    public static MLReader<ClusteringEvaluator> read() {
        return ClusteringEvaluator$.MODULE$.read();
    }

    public static ClusteringEvaluator load(String string) {
        return ClusteringEvaluator$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public ClusteringEvaluator copy(ParamMap pMap) {
        return (ClusteringEvaluator)this.defaultCopy(pMap);
    }

    @Override
    public boolean isLargerBetter() {
        return true;
    }

    public ClusteringEvaluator setPredictionCol(String value) {
        return (ClusteringEvaluator)this.set(this.predictionCol(), value);
    }

    public ClusteringEvaluator setFeaturesCol(String value) {
        return (ClusteringEvaluator)this.set(this.featuresCol(), value);
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public ClusteringEvaluator setMetricName(String value) {
        return (ClusteringEvaluator)this.set(this.metricName(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        SchemaUtils$.MODULE$.checkColumnType(dataset.schema(), this.$(this.featuresCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
        SchemaUtils$.MODULE$.checkNumericType(dataset.schema(), this.$(this.predictionCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        String string = this.$(this.metricName());
        if ("silhouette".equals(string)) {
            double d = SquaredEuclideanSilhouette$.MODULE$.computeSilhouetteScore(dataset, this.$(this.predictionCol()), this.$(this.featuresCol()));
            return d;
        }
        throw new MatchError((Object)string);
    }

    public ClusteringEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"silhouette"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (silhouette)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("silhouette")}));
    }

    public ClusteringEvaluator() {
        this(Identifiable$.MODULE$.randomUID("cluEval"));
    }
}

