/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.uploader;

import contribs.com.centerkey.utils.BareBonesBrowserLaunch;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.jets3t.apps.uploader.UploaderFileExtensionFilter;
import org.jets3t.apps.uploader.XmlGenerator;
import org.jets3t.gui.AuthenticationDialog;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.GuiUtils;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.UserInputFields;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.CancelEventTrigger;
import org.jets3t.service.multithread.CopyObjectsEvent;
import org.jets3t.service.multithread.CreateBucketsEvent;
import org.jets3t.service.multithread.CreateObjectsEvent;
import org.jets3t.service.multithread.DeleteObjectsEvent;
import org.jets3t.service.multithread.DeleteVersionedObjectsEvent;
import org.jets3t.service.multithread.DownloadObjectsEvent;
import org.jets3t.service.multithread.GetObjectHeadsEvent;
import org.jets3t.service.multithread.GetObjectsEvent;
import org.jets3t.service.multithread.ListObjectsEvent;
import org.jets3t.service.multithread.LookupACLEvent;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.S3ServiceMulti;
import org.jets3t.service.multithread.ThreadWatcher;
import org.jets3t.service.multithread.UpdateACLEvent;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ByteFormatter;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.TimeFormatter;
import org.jets3t.service.utils.gatekeeper.GatekeeperMessage;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;
import org.jets3t.service.utils.signedurl.SignedUrlAndObject;

public class Uploader
extends JApplet
implements S3ServiceEventListener,
ActionListener,
ListSelectionListener,
HyperlinkActivatedListener,
CredentialsProvider {
    private static final long serialVersionUID = 2759324769352022783L;
    private static final Log log = LogFactory.getLog(Uploader.class);
    public static final String APPLICATION_DESCRIPTION = "Uploader/0.9.4";
    public static final String UPLOADER_PROPERTIES_FILENAME = "uploader.properties";
    private static final String UPLOADER_VERSION_ID = "JetS3t Uploader/0.9.4";
    public static final int WIZARD_SCREEN_1 = 1;
    public static final int WIZARD_SCREEN_2 = 2;
    public static final int WIZARD_SCREEN_3 = 3;
    public static final int WIZARD_SCREEN_4 = 4;
    public static final int WIZARD_SCREEN_5 = 5;
    public static final String ERROR_CODE__MISSING_REQUIRED_PARAM = "100";
    public static final String ERROR_CODE__S3_UPLOAD_FAILED = "101";
    public static final String ERROR_CODE__UPLOAD_REQUEST_DECLINED = "102";
    public static final String ERROR_CODE__TRANSACTION_ID_REQUIRED_TO_CREATE_XML_SUMMARY = "103";
    public static final int HTTP_CONNECTION_TIMEOUT = 60000;
    public static final int SOCKET_CONNECTION_TIMEOUT = 60000;
    public static final int MAX_CONNECTION_RETRIES = 5;
    private Frame ownerFrame = null;
    private UserInputFields userInputFields = null;
    private Properties userInputProperties = null;
    private HttpClient httpClientGatekeeper = null;
    private S3ServiceMulti s3ServiceMulti = null;
    private File[] filesToUpload = null;
    private ArrayList validFileExtensions = new ArrayList();
    private Jets3tProperties uploaderProperties = null;
    private Properties standAloneArgumentProperties = null;
    private final ByteFormatter byteFormatter = new ByteFormatter();
    private final TimeFormatter timeFormatter = new TimeFormatter();
    private int fileMaxCount = 0;
    private long fileMaxSizeMB = 0L;
    private long fileMinSizeMB = 0L;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);
    private final Insets insetsNone = new Insets(0, 0, 0, 0);
    private final GuiUtils guiUtils = new GuiUtils();
    private int currentState = 0;
    private final boolean isRunningAsApplet;
    private HashMap parametersMap = new HashMap();
    private SkinsFactory skinsFactory = null;
    private final GridBagLayout GRID_BAG_LAYOUT = new GridBagLayout();
    private JHtmlLabel userGuidanceLabel = null;
    private JPanel appContentPanel = null;
    private JPanel buttonsPanel = null;
    private JPanel primaryPanel = null;
    private CardLayout primaryPanelCardLayout = null;
    private CardLayout buttonsPanelCardLayout = null;
    private JButton backButton = null;
    private JButton nextButton = null;
    private JButton cancelUploadButton = null;
    private JHtmlLabel dragDropTargetLabel = null;
    private JHtmlLabel fileToUploadLabel = null;
    private JHtmlLabel fileInformationLabel = null;
    private JHtmlLabel progressTransferDetailsLabel = null;
    private JProgressBar progressBar = null;
    private JHtmlLabel progressStatusTextLabel = null;
    private JHtmlLabel finalMessageLabel = null;
    private CancelEventTrigger uploadCancelEventTrigger = null;
    private volatile boolean uploadingFinalObject = false;
    private volatile boolean includeXmlSummaryDoc = false;
    private volatile boolean uploadCancelled = false;
    private boolean fatalErrorOccurred = false;
    private Exception priorFailureException = null;
    private final CredentialsProvider mCredentialProvider;

    private Uploader(boolean pIsRunningApplet) {
        this.isRunningAsApplet = pIsRunningApplet;
        this.mCredentialProvider = new BasicCredentialsProvider();
    }

    public Uploader() {
        this(true);
    }

    public Uploader(JFrame ownerFrame, Properties standAloneArgumentProperties) throws S3ServiceException {
        this(false);
        this.ownerFrame = ownerFrame;
        this.standAloneArgumentProperties = standAloneArgumentProperties;
        this.init();
        ownerFrame.getContentPane().add(this);
        ownerFrame.setBounds(this.getBounds());
        ownerFrame.setVisible(true);
    }

    public void init() {
        StringTokenizer st;
        super.init();
        boolean isMissingRequiredInitProperty = false;
        if (this.ownerFrame == null) {
            Container c = this;
            while (!(c instanceof Frame) && c.getParent() != null) {
                c = c.getParent();
            }
            this.ownerFrame = !(c instanceof Frame) ? new JFrame() : (Frame)c;
        }
        this.uploaderProperties = Jets3tProperties.getInstance(UPLOADER_PROPERTIES_FILENAME);
        if (this.isRunningAsApplet) {
            String appletParamNames = this.uploaderProperties.getStringProperty("applet.params", "");
            st = new StringTokenizer(appletParamNames, ",");
            while (st.hasMoreTokens()) {
                String paramName = st.nextToken();
                String paramValue = this.getParameter(paramName);
                if (null == paramValue) {
                    log.error((Object)("Missing required applet parameter: " + paramName));
                    isMissingRequiredInitProperty = true;
                    continue;
                }
                log.debug((Object)("Found applet parameter: " + paramName + "='" + paramValue + "'"));
                this.uploaderProperties.setProperty(paramName, paramValue);
                this.parametersMap.put(paramName, paramValue);
            }
        } else if (this.standAloneArgumentProperties != null) {
            Enumeration<Object> e = this.standAloneArgumentProperties.keys();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                String propValue = this.standAloneArgumentProperties.getProperty(propName);
                if (null == propValue) {
                    log.error((Object)("Missing required command-line property: " + propName));
                    isMissingRequiredInitProperty = true;
                    continue;
                }
                log.debug((Object)("Using command-line property: " + propName + "='" + propValue + "'"));
                this.uploaderProperties.setProperty(propName, propValue);
                this.parametersMap.put(propName, propValue);
            }
        }
        this.fileMaxCount = this.uploaderProperties.getIntProperty("file.maxCount", 1);
        this.fileMaxSizeMB = this.uploaderProperties.getLongProperty("file.maxSizeMB", 200L);
        this.fileMinSizeMB = this.uploaderProperties.getLongProperty("file.minSizeMB", 0L);
        this.initGui();
        if (isMissingRequiredInitProperty) {
            this.failWithFatalError(ERROR_CODE__MISSING_REQUIRED_PARAM);
            return;
        }
        String validFileExtensionsStr = this.uploaderProperties.getStringProperty("file.extensions", "");
        if (validFileExtensionsStr != null) {
            st = new StringTokenizer(validFileExtensionsStr, ",");
            while (st.hasMoreTokens()) {
                this.validFileExtensions.add(st.nextToken().toLowerCase(Locale.getDefault()));
            }
        }
    }

    private void initGui() {
        this.skinsFactory = SkinsFactory.getInstance(this.uploaderProperties.getProperties());
        LookAndFeel lookAndFeel = this.skinsFactory.createSkinnedMetalTheme("SkinnedLookAndFeel");
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)"Unable to set skinned LookAndFeel", (Throwable)e);
        }
        String applicationTitle = this.replaceMessageVariables(this.uploaderProperties.getStringProperty("gui.applicationTitle", null));
        if (applicationTitle != null) {
            this.ownerFrame.setTitle(applicationTitle);
        }
        String applicationIconPath = this.uploaderProperties.getStringProperty("gui.applicationIcon", null);
        if (!this.isRunningAsApplet && applicationIconPath != null) {
            this.guiUtils.applyIcon(this.ownerFrame, applicationIconPath);
        }
        String footerHtml = this.uploaderProperties.getStringProperty("gui.footerHtml", null);
        String footerIconPath = this.uploaderProperties.getStringProperty("gui.footerIcon", null);
        boolean includeFooter = false;
        JHtmlLabel footerLabel = this.skinsFactory.createSkinnedJHtmlLabel("FooterLabel");
        footerLabel.setHyperlinkeActivatedListener(this);
        footerLabel.setHorizontalAlignment(0);
        if (footerHtml != null) {
            footerLabel.setText(this.replaceMessageVariables(footerHtml));
            includeFooter = true;
        }
        if (footerIconPath != null) {
            this.guiUtils.applyIcon(footerLabel, footerIconPath);
        }
        this.userInputFields = new UserInputFields(this.insetsDefault, this, this.skinsFactory);
        JPanel screen1Panel = this.skinsFactory.createSkinnedJPanel("Screen1Panel");
        screen1Panel.setLayout(this.GRID_BAG_LAYOUT);
        this.userInputFields.buildFieldsPanel(screen1Panel, this.uploaderProperties);
        JPanel screen2Panel = this.skinsFactory.createSkinnedJPanel("Screen2Panel");
        screen2Panel.setLayout(this.GRID_BAG_LAYOUT);
        this.dragDropTargetLabel = this.skinsFactory.createSkinnedJHtmlLabel("DragDropTargetLabel");
        this.dragDropTargetLabel.setHyperlinkeActivatedListener(this);
        this.dragDropTargetLabel.setHorizontalAlignment(0);
        this.dragDropTargetLabel.setVerticalAlignment(0);
        JButton chooseFileButton = this.skinsFactory.createSkinnedJButton("ChooseFileButton");
        chooseFileButton.setActionCommand("ChooseFile");
        chooseFileButton.addActionListener(this);
        this.configureButton(chooseFileButton, "screen.2.browseButton");
        screen2Panel.add((Component)this.dragDropTargetLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        screen2Panel.add((Component)chooseFileButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 0, this.insetsDefault, 0, 0));
        JPanel screen3Panel = this.skinsFactory.createSkinnedJPanel("Screen3Panel");
        screen3Panel.setLayout(this.GRID_BAG_LAYOUT);
        this.fileToUploadLabel = this.skinsFactory.createSkinnedJHtmlLabel("FileToUploadLabel");
        this.fileToUploadLabel.setHyperlinkeActivatedListener(this);
        this.fileToUploadLabel.setHorizontalAlignment(0);
        this.fileToUploadLabel.setVerticalAlignment(0);
        screen3Panel.add((Component)this.fileToUploadLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        JPanel screen4Panel = this.skinsFactory.createSkinnedJPanel("Screen4Panel");
        screen4Panel.setLayout(this.GRID_BAG_LAYOUT);
        this.fileInformationLabel = this.skinsFactory.createSkinnedJHtmlLabel("FileInformationLabel");
        this.fileInformationLabel.setHyperlinkeActivatedListener(this);
        this.fileInformationLabel.setHorizontalAlignment(0);
        this.progressBar = this.skinsFactory.createSkinnedJProgressBar("ProgressBar", 0, 100);
        this.progressBar.setStringPainted(true);
        this.progressStatusTextLabel = this.skinsFactory.createSkinnedJHtmlLabel("ProgressStatusTextLabel");
        this.progressStatusTextLabel.setHyperlinkeActivatedListener(this);
        this.progressStatusTextLabel.setText(" ");
        this.progressStatusTextLabel.setHorizontalAlignment(0);
        this.progressTransferDetailsLabel = this.skinsFactory.createSkinnedJHtmlLabel("ProgressTransferDetailsLabel");
        this.progressTransferDetailsLabel.setHyperlinkeActivatedListener(this);
        this.progressTransferDetailsLabel.setText(" ");
        this.progressTransferDetailsLabel.setHorizontalAlignment(0);
        this.cancelUploadButton = this.skinsFactory.createSkinnedJButton("CancelUploadButton");
        this.cancelUploadButton.setActionCommand("CancelUpload");
        this.cancelUploadButton.addActionListener(this);
        this.configureButton(this.cancelUploadButton, "screen.4.cancelButton");
        screen4Panel.add((Component)this.fileInformationLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        screen4Panel.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        screen4Panel.add((Component)this.progressStatusTextLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        screen4Panel.add((Component)this.progressTransferDetailsLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        screen4Panel.add((Component)this.cancelUploadButton, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        JPanel screen5Panel = this.skinsFactory.createSkinnedJPanel("Screen5Panel");
        screen5Panel.setLayout(this.GRID_BAG_LAYOUT);
        this.finalMessageLabel = this.skinsFactory.createSkinnedJHtmlLabel("FinalMessageLabel");
        this.finalMessageLabel.setHyperlinkeActivatedListener(this);
        this.finalMessageLabel.setHorizontalAlignment(0);
        screen5Panel.add((Component)this.finalMessageLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.backButton = this.skinsFactory.createSkinnedJButton("backButton");
        this.backButton.setActionCommand("Back");
        this.backButton.addActionListener(this);
        this.nextButton = this.skinsFactory.createSkinnedJButton("nextButton");
        this.nextButton.setActionCommand("Next");
        this.nextButton.addActionListener(this);
        this.buttonsPanel = this.skinsFactory.createSkinnedJPanel("ButtonsPanel");
        this.buttonsPanelCardLayout = new CardLayout();
        this.buttonsPanel.setLayout(this.buttonsPanelCardLayout);
        JPanel buttonsInvisiblePanel = this.skinsFactory.createSkinnedJPanel("ButtonsInvisiblePanel");
        JPanel buttonsVisiblePanel = this.skinsFactory.createSkinnedJPanel("ButtonsVisiblePanel");
        buttonsVisiblePanel.setLayout(this.GRID_BAG_LAYOUT);
        buttonsVisiblePanel.add((Component)this.backButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        buttonsVisiblePanel.add((Component)this.nextButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        this.buttonsPanel.add((Component)buttonsInvisiblePanel, "invisible");
        this.buttonsPanel.add((Component)buttonsVisiblePanel, "visible");
        this.appContentPanel = this.skinsFactory.createSkinnedJPanel("ApplicationContentPanel");
        this.appContentPanel.setLayout(this.GRID_BAG_LAYOUT);
        JPanel userGuidancePanel = this.skinsFactory.createSkinnedJPanel("UserGuidancePanel");
        userGuidancePanel.setLayout(this.GRID_BAG_LAYOUT);
        this.primaryPanel = this.skinsFactory.createSkinnedJPanel("PrimaryPanel");
        this.primaryPanelCardLayout = new CardLayout();
        this.primaryPanel.setLayout(this.primaryPanelCardLayout);
        JPanel navigationPanel = this.skinsFactory.createSkinnedJPanel("NavigationPanel");
        navigationPanel.setLayout(this.GRID_BAG_LAYOUT);
        this.appContentPanel.add((Component)userGuidancePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.2, 10, 1, this.insetsDefault, 0, 0));
        this.appContentPanel.add((Component)this.primaryPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.6, 10, 1, this.insetsDefault, 0, 0));
        this.appContentPanel.add((Component)navigationPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.2, 10, 1, this.insetsDefault, 0, 0));
        if (includeFooter) {
            log.debug((Object)"Adding footer for branding");
            this.appContentPanel.add((Component)footerLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        }
        this.getContentPane().add(this.appContentPanel);
        this.userGuidanceLabel = this.skinsFactory.createSkinnedJHtmlLabel("UserGuidanceLabel");
        this.userGuidanceLabel.setHyperlinkeActivatedListener(this);
        this.userGuidanceLabel.setHorizontalAlignment(0);
        userGuidancePanel.add((Component)this.userGuidanceLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsNone, 0, 0));
        navigationPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, this.insetsNone, 0, 0));
        this.primaryPanel.add((Component)screen1Panel, "screen1");
        this.primaryPanel.add((Component)screen2Panel, "screen2");
        this.primaryPanel.add((Component)screen3Panel, "screen3");
        this.primaryPanel.add((Component)screen4Panel, "screen4");
        this.primaryPanel.add((Component)screen5Panel, "screen5");
        int preferredWidth = this.uploaderProperties.getIntProperty("gui.minSizeWidth", 400);
        int preferredHeight = this.uploaderProperties.getIntProperty("gui.minSizeHeight", 500);
        this.setBounds(new Rectangle(new Dimension(preferredWidth, preferredHeight)));
        this.initDropTarget(new Component[]{this});
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.error((Object)"Unable to set default system LookAndFeel", (Throwable)e);
        }
        this.wizardStepForward();
    }

    private void initDropTarget(Component[] dropTargetComponents) {
        DropTargetListener dropTargetListener = new DropTargetListener(){
            private Border originalBorder;
            private Border dragOverBorder;
            {
                this.originalBorder = Uploader.this.appContentPanel.getBorder();
                this.dragOverBorder = BorderFactory.createBevelBorder(1);
            }

            private boolean checkValidDrag(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (1 == dtde.getDropAction() || 2 == dtde.getDropAction())) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return true;
                }
                dtde.rejectDrag();
                return false;
            }

            public void dragEnter(DropTargetDragEvent dtde) {
                if (this.checkValidDrag(dtde)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Uploader.this.appContentPanel.setBorder(dragOverBorder);
                        }
                    });
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
                this.checkValidDrag(dtde);
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
                this.checkValidDrag(dtde);
            }

            public void dragExit(DropTargetEvent dte) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Uploader.this.appContentPanel.setBorder(originalBorder);
                    }
                });
            }

            public void drop(DropTargetDropEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (1 == dtde.getDropAction() || 2 == dtde.getDropAction())) {
                    dtde.acceptDrop(dtde.getDropAction());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Uploader.this.appContentPanel.setBorder(originalBorder);
                        }
                    });
                    try {
                        List fileList = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        if (fileList != null && fileList.size() > 0 && Uploader.this.checkProposedUploadFiles(fileList)) {
                            Uploader.this.wizardStepForward();
                        }
                    }
                    catch (Exception e) {
                        String errorMessage = "Unable to accept dropped item";
                        log.error((Object)errorMessage, (Throwable)e);
                        ErrorDialog.showDialog(Uploader.this.ownerFrame, null, Uploader.this.uploaderProperties.getProperties(), errorMessage, (Throwable)e);
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
        };
        for (int i = 0; i < dropTargetComponents.length; ++i) {
            new DropTarget(dropTargetComponents[i], 1, dropTargetListener, true);
        }
    }

    private boolean checkProposedUploadFiles(List fileList) {
        if (this.fileMaxCount > 0 && fileList.size() > this.fileMaxCount) {
            String errorMessage = "You may only upload " + this.fileMaxCount + (this.fileMaxCount == 1 ? " file" : " files") + " at a time";
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.uploaderProperties.getProperties(), errorMessage, null);
            return false;
        }
        for (File file : fileList) {
            long fileSizeMB = file.length() / 0x100000L;
            if (this.fileMinSizeMB > 0L && fileSizeMB < this.fileMinSizeMB) {
                ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.uploaderProperties.getProperties(), "File size must be greater than " + this.fileMinSizeMB + " MB", null);
                return false;
            }
            if (this.fileMaxSizeMB <= 0L || fileSizeMB <= this.fileMaxSizeMB) continue;
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.uploaderProperties.getProperties(), "File size must be less than " + this.fileMaxSizeMB + " MB", null);
            return false;
        }
        if (this.validFileExtensions.size() > 0) {
            for (File file : fileList) {
                String fileName = file.getName();
                String fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
                if (this.validFileExtensions.contains(fileExtension.toLowerCase(Locale.getDefault()))) continue;
                String extList = this.validFileExtensions.toString();
                extList = extList.substring(1, extList.length() - 1);
                extList = extList.replaceAll(",", " ");
                ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.uploaderProperties.getProperties(), "<html>File name must end with one of the following extensions:<br>" + extList + "</html>", null);
                return false;
            }
        }
        this.filesToUpload = fileList.toArray(new File[fileList.size()]);
        return true;
    }

    private GatekeeperMessage buildGatekeeperResponse(S3Object[] objects) throws Exception {
        String awsAccessKey = this.userInputProperties.getProperty("AwsAccessKey");
        String awsSecretKey = this.userInputProperties.getProperty("AwsSecretKey");
        String s3BucketName = this.userInputProperties.getProperty("S3BucketName");
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        Date expiryDate = cal.getTime();
        AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
        RestS3Service s3Service = new RestS3Service(awsCredentials);
        try {
            GatekeeperMessage gatekeeperMessage = new GatekeeperMessage();
            gatekeeperMessage.addApplicationProperties(this.userInputProperties);
            gatekeeperMessage.addApplicationProperties(this.parametersMap);
            for (int i = 0; i < objects.length; ++i) {
                String signedPutUrl = s3Service.createSignedPutUrl(s3BucketName, objects[i].getKey(), objects[i].getMetadataMap(), expiryDate, false);
                SignatureRequest signatureRequest = new SignatureRequest("put", objects[i].getKey());
                signatureRequest.setBucketName(s3BucketName);
                signatureRequest.setObjectMetadata(objects[i].getMetadataMap());
                signatureRequest.signRequest(signedPutUrl);
                gatekeeperMessage.addSignatureRequest(signatureRequest);
            }
            return gatekeeperMessage;
        }
        catch (Exception e) {
            throw new Exception("Unable to generate locally-signed PUT URLs for testing", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GatekeeperMessage contactGatewayServer(S3Object[] objects) throws Exception {
        String gatekeeperUrl = this.uploaderProperties.getStringProperty("gatekeeperUrl", "Missing required property gatekeeperUrl");
        GatekeeperMessage gatekeeperMessage = new GatekeeperMessage();
        gatekeeperMessage.addApplicationProperties(this.userInputProperties);
        gatekeeperMessage.addApplicationProperties(this.parametersMap);
        gatekeeperMessage.addApplicationProperty("clientVersionId", UPLOADER_VERSION_ID);
        if (this.priorFailureException != null) {
            gatekeeperMessage.addApplicationProperty("priorFailureMessage", this.priorFailureException.getMessage());
            this.priorFailureException = null;
        }
        for (int i = 0; i < objects.length; ++i) {
            SignatureRequest signatureRequest = new SignatureRequest("put", objects[i].getKey());
            signatureRequest.setObjectMetadata(objects[i].getMetadataMap());
            gatekeeperMessage.addSignatureRequest(signatureRequest);
        }
        HttpPost postMethod = new HttpPost(gatekeeperUrl);
        Properties properties = gatekeeperMessage.encodeToProperties();
        Iterator<Map.Entry<Object, Object>> propsIter = properties.entrySet().iterator();
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(properties.size());
        while (propsIter.hasNext()) {
            Map.Entry<Object, Object> entry = propsIter.next();
            String fieldName = (String)entry.getKey();
            String fieldValue = (String)entry.getValue();
            parameters.add(new BasicNameValuePair(fieldName, fieldValue));
        }
        postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        if (this.httpClientGatekeeper == null) {
            this.httpClientGatekeeper = this.initHttpConnection();
        }
        try {
            HttpHost proxyHost = PluginProxyUtil.detectProxy(new URL(gatekeeperUrl));
            if (proxyHost != null) {
                this.httpClientGatekeeper.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
            }
            ((DefaultHttpClient)this.httpClientGatekeeper).setCredentialsProvider((CredentialsProvider)this);
        }
        catch (Throwable t) {
            log.debug((Object)"No proxy detected");
        }
        log.debug((Object)("Contacting Gatekeeper at: " + gatekeeperUrl));
        HttpResponse response = null;
        try {
            response = this.httpClientGatekeeper.execute((HttpUriRequest)postMethod);
            int responseCode = response.getStatusLine().getStatusCode();
            String contentType = response.getFirstHeader("Content-Type").getValue();
            if (responseCode == 200) {
                InputStream responseInputStream = null;
                Header encodingHeader = response.getFirstHeader("Content-Encoding");
                if (encodingHeader != null && "gzip".equalsIgnoreCase(encodingHeader.getValue())) {
                    log.debug((Object)"Inflating gzip-encoded response");
                    responseInputStream = new GZIPInputStream(response.getEntity().getContent());
                } else {
                    responseInputStream = response.getEntity().getContent();
                }
                if (responseInputStream == null) {
                    throw new IOException("No response input stream available from Gatekeeper");
                }
                Properties responseProperties = new Properties();
                try {
                    responseProperties.load(responseInputStream);
                }
                finally {
                    responseInputStream.close();
                }
                GatekeeperMessage gatekeeperResponseMessage = GatekeeperMessage.decodeFromProperties(responseProperties);
                String gatekeeperErrorCode = gatekeeperResponseMessage.getApplicationProperties().getProperty("gatekeeperErrorCode");
                if (gatekeeperErrorCode != null) {
                    log.warn((Object)("Received Gatekeeper error code: " + gatekeeperErrorCode));
                    this.failWithFatalError(gatekeeperErrorCode);
                    GatekeeperMessage gatekeeperMessage2 = null;
                    return gatekeeperMessage2;
                }
                if (gatekeeperResponseMessage.getSignatureRequests().length != objects.length) {
                    throw new Exception("The Gatekeeper service did not provide the necessary " + objects.length + " response items");
                }
                GatekeeperMessage gatekeeperMessage3 = gatekeeperResponseMessage;
                return gatekeeperMessage3;
            }
            try {
                log.debug((Object)("The Gatekeeper did not permit a request. Response code: " + responseCode + ", Response content type: " + contentType));
                throw new Exception("The Gatekeeper did not permit your request");
            }
            catch (Exception e) {
                throw new Exception("Gatekeeper did not respond", e);
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    private GatekeeperMessage retrieveGatekeeperResponse(S3Object[] objects) throws Exception {
        boolean s3CredentialsProvided = this.userInputProperties.getProperty("AwsAccessKey") != null && this.userInputProperties.getProperty("AwsSecretKey") != null && this.userInputProperties.getProperty("S3BucketName") != null;
        GatekeeperMessage gatekeeperMessage = null;
        if (s3CredentialsProvided) {
            log.debug((Object)"S3 login credentials and bucket name are available, the Uploader will generate its own Gatekeeper response");
            gatekeeperMessage = this.buildGatekeeperResponse(objects);
        } else {
            gatekeeperMessage = this.contactGatewayServer(objects);
        }
        return gatekeeperMessage;
    }

    private void uploadFilesToS3() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uploader.this.progressStatusTextLabel.setText(Uploader.this.replaceMessageVariables(Uploader.this.uploaderProperties.getStringProperty("screen.4.hashingMessage", "Missing property 'screen.4.hashingMessage'")));
                }
            });
            long[] filesSizeTotal = new long[1];
            for (int i = 0; i < this.filesToUpload.length; ++i) {
                filesSizeTotal[0] = filesSizeTotal[0] + this.filesToUpload[i].length();
            }
            BytesProgressWatcher progressWatcher = new BytesProgressWatcher(filesSizeTotal[0]){

                public void updateBytesTransferred(long byteCount) {
                    super.updateBytesTransferred(byteCount);
                    final int percentage = (int)((double)this.getBytesTransferred() * 100.0 / (double)this.getBytesToTransfer());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Uploader.this.progressBar.setValue(percentage);
                        }
                    });
                }
            };
            S3Object[] objectsForUpload = new S3Object[this.filesToUpload.length];
            for (int i = 0; i < this.filesToUpload.length; ++i) {
                File file = this.filesToUpload[i];
                log.debug((Object)("Computing MD5 hash for file: " + file));
                byte[] fileHash = ServiceUtils.computeMD5Hash(new ProgressMonitoredInputStream(new FileInputStream(file), progressWatcher));
                S3Object object = new S3Object(null, file);
                object.setMd5Hash(fileHash);
                objectsForUpload[i] = object;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uploader.this.progressStatusTextLabel.setText(Uploader.this.replaceMessageVariables(Uploader.this.uploaderProperties.getStringProperty("screen.4.connectingMessage", "Missing property 'screen.4.connectingMessage'")));
                    Uploader.this.progressBar.setValue(0);
                }
            });
            GatekeeperMessage gatekeeperMessage = null;
            try {
                gatekeeperMessage = this.retrieveGatekeeperResponse(objectsForUpload);
            }
            catch (Exception e) {
                log.info((Object)"Upload request was denied", (Throwable)e);
                this.failWithFatalError(ERROR_CODE__UPLOAD_REQUEST_DECLINED);
                return;
            }
            if (gatekeeperMessage == null) {
                return;
            }
            log.debug((Object)("Gatekeeper response properties: " + gatekeeperMessage.encodeToProperties()));
            XmlGenerator xmlGenerator = new XmlGenerator();
            xmlGenerator.addApplicationProperties(gatekeeperMessage.getApplicationProperties());
            xmlGenerator.addMessageProperties(gatekeeperMessage.getMessageProperties());
            SignedUrlAndObject[] uploadItems = this.prepareSignedObjects(objectsForUpload, gatekeeperMessage.getSignatureRequests(), xmlGenerator);
            if (this.s3ServiceMulti == null) {
                this.s3ServiceMulti = new S3ServiceMulti(new RestS3Service(null, APPLICATION_DESCRIPTION, this), this);
            }
            this.includeXmlSummaryDoc = this.uploaderProperties.getBoolProperty("xmlSummary", false);
            S3Object summaryXmlObject = null;
            if (this.includeXmlSummaryDoc) {
                String priorTransactionId = gatekeeperMessage.getMessageProperties().getProperty("transactionId");
                if (priorTransactionId == null) {
                    this.failWithFatalError(ERROR_CODE__TRANSACTION_ID_REQUIRED_TO_CREATE_XML_SUMMARY);
                    return;
                }
                summaryXmlObject = new S3Object(null, priorTransactionId + ".xml", xmlGenerator.generateXml());
                summaryXmlObject.setContentType("application/xml");
                summaryXmlObject.addMetadata("transactionId", priorTransactionId);
                summaryXmlObject.addMetadata("jets3t-uploader-summary-doc", "true");
            }
            this.uploadCancelled = false;
            this.uploadingFinalObject = !this.includeXmlSummaryDoc;
            this.s3ServiceMulti.putObjects(uploadItems);
            if (this.includeXmlSummaryDoc && !this.uploadCancelled && !this.fatalErrorOccurred) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Uploader.this.fileInformationLabel.setText(Uploader.this.replaceMessageVariables(Uploader.this.uploaderProperties.getStringProperty("screen.4.summaryFileInformation", "Missing property 'screen.4.summaryFileInformation'")));
                        Uploader.this.progressStatusTextLabel.setText(Uploader.this.replaceMessageVariables(Uploader.this.uploaderProperties.getStringProperty("screen.4.connectingMessage", "Missing property 'screen.4.connectingMessage'")));
                    }
                });
                gatekeeperMessage = this.retrieveGatekeeperResponse(new S3Object[]{summaryXmlObject});
                SignedUrlAndObject[] xmlSummaryItem = this.prepareSignedObjects(new S3Object[]{summaryXmlObject}, gatekeeperMessage.getSignatureRequests(), null);
                this.uploadingFinalObject = true;
                this.s3ServiceMulti.putObjects(xmlSummaryItem);
            }
        }
        catch (Exception e) {
            this.priorFailureException = e;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uploader.this.wizardStepBackward();
                    log.error((Object)"File upload failed", (Throwable)e);
                    ErrorDialog.showDialog(Uploader.this.ownerFrame, null, Uploader.this.uploaderProperties.getProperties(), "File upload failed", (Throwable)e);
                }
            });
        }
    }

    private SignedUrlAndObject[] prepareSignedObjects(S3Object[] objects, SignatureRequest[] signatureRequests, XmlGenerator xmlGenerator) throws Exception {
        ArrayList<SignedUrlAndObject> signedObjects = new ArrayList<SignedUrlAndObject>();
        String firstDeclineReason = null;
        for (int i = 0; i < signatureRequests.length; ++i) {
            SignatureRequest request = signatureRequests[i];
            S3Object object = objects[i];
            if (xmlGenerator != null) {
                HashMap<String, Object> clonedMetadata = new HashMap<String, Object>();
                clonedMetadata.putAll(object.getMetadataMap());
                xmlGenerator.addSignatureRequest(object.getKey(), object.getBucketName(), clonedMetadata, request);
            }
            if (request.isSigned()) {
                if (request.getObjectKey() != null) {
                    object.setKey(request.getObjectKey());
                }
                if (request.getBucketName() != null) {
                    object.setBucketName(request.getBucketName());
                }
                if (request.getObjectMetadata() != null && request.getObjectMetadata().size() > 0) {
                    object.replaceAllMetadata(request.getObjectMetadata());
                }
                SignedUrlAndObject urlAndObject = new SignedUrlAndObject(request.getSignedUrl(), object);
                signedObjects.add(urlAndObject);
                continue;
            }
            String declineReason = request.getDeclineReason() == null ? "Unknown" : request.getDeclineReason();
            log.warn((Object)("Upload of '" + objects[i].getKey() + "' was declined for reason: " + declineReason));
            if (firstDeclineReason != null) continue;
            firstDeclineReason = declineReason;
        }
        if (firstDeclineReason != null) {
            throw new Exception("Your upload" + (objects.length > 1 ? "s were" : " was") + " declined by the Gatekeeper. Reason: " + firstDeclineReason);
        }
        return signedObjects.toArray(new SignedUrlAndObject[signedObjects.size()]);
    }

    public void s3ServiceEventPerformed(CreateObjectsEvent event) {
        if (1 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean isXmlSummaryUpload = Uploader.this.includeXmlSummaryDoc && Uploader.this.uploadingFinalObject;
                    Uploader.this.cancelUploadButton.setEnabled(!isXmlSummaryUpload);
                }
            });
            ThreadWatcher watcher = event.getThreadWatcher();
            this.uploadCancelEventTrigger = watcher.getCancelEventListener();
            String bytesTotalStr = this.byteFormatter.formatByteSize(watcher.getBytesTotal());
            final String statusText = "Uploaded 0 of " + bytesTotalStr;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uploader.this.progressStatusTextLabel.setText(Uploader.this.replaceMessageVariables(statusText));
                    Uploader.this.progressBar.setValue(0);
                }
            });
        } else if (3 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.getBytesTransferred() >= watcher.getBytesTotal()) {
                String statusText = "Upload completed, awaiting confirmation";
                this.progressBar.setValue(100);
                this.progressStatusTextLabel.setText(this.replaceMessageVariables(statusText));
                this.progressTransferDetailsLabel.setText("");
            } else {
                String bytesCompletedStr = this.byteFormatter.formatByteSize(watcher.getBytesTransferred());
                String bytesTotalStr = this.byteFormatter.formatByteSize(watcher.getBytesTotal());
                String statusText = "Uploaded " + bytesCompletedStr + " of " + bytesTotalStr;
                int percentage = (int)((double)watcher.getBytesTransferred() / (double)watcher.getBytesTotal() * 100.0);
                long bytesPerSecond = watcher.getBytesPerSecond();
                String transferDetailsText = "Speed: " + this.byteFormatter.formatByteSize(bytesPerSecond) + "/s";
                if (watcher.isTimeRemainingAvailable()) {
                    long secondsRemaining = watcher.getTimeRemaining();
                    if (transferDetailsText.trim().length() > 0) {
                        transferDetailsText = transferDetailsText + " - ";
                    }
                    transferDetailsText = transferDetailsText + "Time remaining: " + this.timeFormatter.formatTime(secondsRemaining);
                }
                this.progressBar.setValue(percentage);
                this.progressStatusTextLabel.setText(this.replaceMessageVariables(statusText));
                this.progressTransferDetailsLabel.setText(this.replaceMessageVariables(transferDetailsText));
            }
        } else if (2 == event.getEventCode()) {
            if (this.uploadingFinalObject) {
                this.drawWizardScreen(5);
            }
            this.progressBar.setValue(0);
            this.progressStatusTextLabel.setText("");
            this.progressTransferDetailsLabel.setText("");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uploader.this.cancelUploadButton.setEnabled(false);
                }
            });
        } else if (4 == event.getEventCode()) {
            this.progressBar.setValue(0);
            this.progressStatusTextLabel.setText("");
            this.progressTransferDetailsLabel.setText("");
            this.uploadCancelled = true;
            this.drawWizardScreen(3);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uploader.this.cancelUploadButton.setEnabled(false);
                }
            });
        } else if (0 == event.getEventCode()) {
            this.progressBar.setValue(0);
            this.progressStatusTextLabel.setText("");
            this.progressTransferDetailsLabel.setText("");
            this.failWithFatalError(ERROR_CODE__S3_UPLOAD_FAILED);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uploader.this.cancelUploadButton.setEnabled(false);
                }
            });
        }
    }

    private void configureButton(JButton button, String propertiesPrefix) {
        button.setHorizontalAlignment(0);
        String buttonImagePath = this.uploaderProperties.getStringProperty(propertiesPrefix + ".image", null);
        String buttonText = this.replaceMessageVariables(this.uploaderProperties.getStringProperty(propertiesPrefix + ".text", null));
        String buttonTooltip = this.replaceMessageVariables(this.uploaderProperties.getStringProperty(propertiesPrefix + ".tooltip", null));
        boolean hasImage = false;
        boolean hasText = false;
        if (buttonImagePath != null && buttonImagePath.length() > 0) {
            if (!this.guiUtils.applyIcon(button, buttonImagePath)) {
                log.error((Object)("Unable to load image URL for a button with property prefix '" + propertiesPrefix + "'. Image path: " + buttonImagePath));
            } else {
                hasImage = true;
            }
        }
        if (buttonText != null && buttonText.length() > 0) {
            String text = this.replaceMessageVariables(buttonText);
            button.setText(text);
            button.setMnemonic(text.charAt(0));
            hasText = true;
        }
        if (buttonTooltip != null && buttonTooltip.length() > 0) {
            button.setToolTipText(buttonTooltip);
        }
        if (!hasImage && !hasText) {
            button.setVisible(false);
        } else {
            button.setVisible(true);
        }
    }

    private void drawWizardScreen(int nextState) {
        String title = this.uploaderProperties.getStringProperty("screen." + nextState + ".title", "");
        this.userGuidanceLabel.setText(this.replaceMessageVariables(title));
        this.configureButton(this.nextButton, "screen." + nextState + ".nextButton");
        this.configureButton(this.backButton, "screen." + nextState + ".backButton");
        this.getDropTarget().setActive(false);
        if (nextState == 1) {
            this.primaryPanelCardLayout.show(this.primaryPanel, "screen1");
            this.buttonsPanelCardLayout.show(this.buttonsPanel, "visible");
        } else if (nextState == 2) {
            this.userInputProperties = this.userInputFields.getUserInputsAsProperties(false);
            this.primaryPanelCardLayout.show(this.primaryPanel, "screen2");
            this.dragDropTargetLabel.setText(this.replaceMessageVariables(this.uploaderProperties.getStringProperty("screen.2.dragDropPrompt", "Missing property 'screen.2.dragDropPrompt'")));
            this.getDropTarget().setActive(true);
        } else if (nextState == 3) {
            this.primaryPanelCardLayout.show(this.primaryPanel, "screen3");
            String fileInformation = this.uploaderProperties.getStringProperty("screen.3.fileInformation", "Missing property 'screen.3.fileInformation'");
            this.fileToUploadLabel.setText(this.replaceMessageVariables(fileInformation));
        } else if (nextState == 4) {
            this.primaryPanelCardLayout.show(this.primaryPanel, "screen4");
            String fileInformation = this.uploaderProperties.getStringProperty("screen.4.fileInformation", "Missing property 'screen.4.fileInformation'");
            this.fileInformationLabel.setText(this.replaceMessageVariables(fileInformation));
            this.cancelUploadButton.setEnabled(false);
            new Thread(){

                public void run() {
                    Uploader.this.uploadFilesToS3();
                }
            }.start();
        } else if (nextState == 5) {
            this.primaryPanelCardLayout.show(this.primaryPanel, "screen5");
            String finalMessage = null;
            finalMessage = this.fatalErrorOccurred ? this.uploaderProperties.getStringProperty("screen.5.errorMessage", "Missing property 'screen.5.errorMessage'") : this.uploaderProperties.getStringProperty("screen.5.thankyouMessage", "Missing property 'screen.5.thankyouMessage'");
            this.finalMessageLabel.setText(this.replaceMessageVariables(finalMessage));
        } else {
            log.error((Object)("Ignoring unexpected wizard screen number: " + nextState));
            return;
        }
        this.currentState = nextState;
    }

    private void wizardStepForward() {
        this.drawWizardScreen(this.currentState + 1);
    }

    private void wizardStepBackward() {
        this.drawWizardScreen(this.currentState - 1);
    }

    private void failWithFatalError(String errorCode) {
        this.uploaderProperties.setProperty("errorCode", errorCode);
        String errorCodeMessagePropertyName = "errorCodeMessage." + errorCode;
        String errorCodeMessage = this.uploaderProperties.getStringProperty(errorCodeMessagePropertyName, "");
        this.uploaderProperties.setProperty("errorMessage", errorCodeMessage);
        this.fatalErrorOccurred = true;
        this.drawWizardScreen(5);
    }

    private String replaceMessageVariables(String message) {
        if (message == null) {
            return "";
        }
        String result = message;
        if (this.filesToUpload != null) {
            long filesSize = 0L;
            StringBuffer fileNameList = new StringBuffer();
            for (int i = 0; i < this.filesToUpload.length; ++i) {
                filesSize += this.filesToUpload[i].length();
                fileNameList.append(this.filesToUpload[i].getName()).append(" ");
            }
            result = result.replaceAll("\\$\\{fileNameList\\}", fileNameList.toString());
            result = result.replaceAll("\\$\\{filesSize\\}", this.byteFormatter.formatByteSize(filesSize));
        }
        result = result.replaceAll("\\$\\{maxFileSize\\}", String.valueOf(this.fileMaxSizeMB));
        result = result.replaceAll("\\$\\{maxFileCount\\}", String.valueOf(this.fileMaxCount));
        String extList = this.validFileExtensions.toString();
        extList = extList.substring(1, extList.length() - 1);
        extList = extList.replaceAll(",", " ");
        result = result.replaceAll("\\$\\{validFileExtensions\\}", extList);
        Pattern pattern = Pattern.compile("\\$\\{.+?\\}");
        Matcher matcher = pattern.matcher(result);
        int offset = 0;
        while (matcher.find(offset)) {
            String variable = matcher.group();
            String variableName = variable.substring(2, variable.length() - 1);
            String replacement = null;
            if (this.userInputProperties != null && this.userInputProperties.containsKey(variableName)) {
                log.debug((Object)("Replacing variable '" + variableName + "' with value from a user input field"));
                replacement = this.userInputProperties.getProperty(variableName, null);
            } else if (this.parametersMap != null && this.parametersMap.containsKey(variableName)) {
                log.debug((Object)("Replacing variable '" + variableName + "' with value from Uploader's parameters"));
                replacement = (String)this.parametersMap.get(variableName);
            } else if (this.uploaderProperties != null && this.uploaderProperties.containsKey(variableName)) {
                log.debug((Object)("Replacing variable '" + variableName + "' with value from uploader.properties file"));
                replacement = this.uploaderProperties.getStringProperty(variableName, null);
            }
            if (replacement != null) {
                result = result.substring(0, matcher.start()) + replacement + result.substring(matcher.end());
                offset = matcher.start() + 1;
                matcher.reset(result);
                continue;
            }
            offset = matcher.start() + 1;
        }
        if (!result.equals(message)) {
            log.debug((Object)("Replaced variables in text: " + message + " => " + result));
        }
        return result;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Next".equals(actionEvent.getActionCommand())) {
            this.wizardStepForward();
        } else if ("Back".equals(actionEvent.getActionCommand())) {
            this.wizardStepBackward();
        } else if ("ChooseFile".equals(actionEvent.getActionCommand())) {
            JFileChooser fileChooser = new JFileChooser();
            if (this.validFileExtensions.size() > 0) {
                UploaderFileExtensionFilter filter = new UploaderFileExtensionFilter("Allowed files", this.validFileExtensions);
                fileChooser.setFileFilter(filter);
            }
            fileChooser.setMultiSelectionEnabled(this.fileMaxCount > 1);
            fileChooser.setDialogTitle("Choose file" + (this.fileMaxCount > 1 ? "s" : "") + " to upload");
            fileChooser.setFileSelectionMode(0);
            fileChooser.setApproveButtonText("Choose file" + (this.fileMaxCount > 1 ? "s" : ""));
            int returnVal = fileChooser.showOpenDialog(this.ownerFrame);
            if (returnVal != 0) {
                return;
            }
            ArrayList<File> fileList = new ArrayList<File>();
            if (fileChooser.getSelectedFiles().length > 0) {
                fileList.addAll(Arrays.asList(fileChooser.getSelectedFiles()));
            } else {
                fileList.add(fileChooser.getSelectedFile());
            }
            if (this.checkProposedUploadFiles(fileList)) {
                this.wizardStepForward();
            }
        } else if ("CancelUpload".equals(actionEvent.getActionCommand())) {
            if (this.uploadCancelEventTrigger != null) {
                this.uploadCancelEventTrigger.cancelTask(this);
                this.progressBar.setValue(0);
            } else {
                log.warn((Object)"Ignoring attempt to cancel file upload when cancel trigger is not available");
            }
        } else {
            log.warn((Object)("Unrecognised action command, ignoring: " + actionEvent.getActionCommand()));
        }
    }

    private HttpClient initHttpConnection() {
        HttpParams params = RestUtils.createDefaultHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)ServiceUtils.getUserAgentDescription(APPLICATION_DESCRIPTION));
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        DefaultHttpClient httpClient = new DefaultHttpClient(params);
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RestUtils.JetS3tRetryHandler(5, null));
        return httpClient;
    }

    public void followHyperlink(URL url, String target) {
        if (this.isRunningAsApplet) {
            if (target == null) {
                this.getAppletContext().showDocument(url);
            } else {
                this.getAppletContext().showDocument(url, target);
            }
        } else {
            BareBonesBrowserLaunch.openURL(url.toString());
        }
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.mCredentialProvider.setCredentials(authscope, credentials);
    }

    public void clear() {
        this.mCredentialProvider.clear();
    }

    public Credentials getCredentials(AuthScope scope) {
        if (scope == null || scope.getScheme() == null) {
            return null;
        }
        Credentials credentials = this.mCredentialProvider.getCredentials(scope);
        if (credentials != null) {
            return credentials;
        }
        try {
            if (scope.getScheme().equals("ntlm")) {
                AuthenticationDialog pwDialog = new AuthenticationDialog(this.ownerFrame, "Authentication Required", "<html>Host <b>" + scope.getHost() + ":" + scope.getPort() + "</b> requires Windows authentication</html>", true);
                pwDialog.setVisible(true);
                if (pwDialog.getUser().length() > 0) {
                    credentials = new NTCredentials(pwDialog.getUser(), pwDialog.getPassword(), scope.getHost(), pwDialog.getDomain());
                }
                pwDialog.dispose();
            } else if (scope.getScheme().equals("basic") || scope.getScheme().equals("digest")) {
                AuthenticationDialog pwDialog = new AuthenticationDialog(this.ownerFrame, "Authentication Required", "<html><center>Host <b>" + scope.getHost() + ":" + scope.getPort() + "</b>" + " requires authentication for the realm:<br><b>" + scope.getRealm() + "</b></center></html>", false);
                pwDialog.setVisible(true);
                if (pwDialog.getUser().length() > 0) {
                    credentials = new UsernamePasswordCredentials(pwDialog.getUser(), pwDialog.getPassword());
                }
                pwDialog.dispose();
            } else {
                throw new IllegalArgumentException("Unsupported authentication scheme: " + scope.getScheme());
            }
            if (credentials != null) {
                this.mCredentialProvider.setCredentials(scope, credentials);
            }
            return credentials;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void s3ServiceEventPerformed(ListObjectsEvent event) {
    }

    public void s3ServiceEventPerformed(CreateBucketsEvent event) {
    }

    public void s3ServiceEventPerformed(DeleteObjectsEvent event) {
    }

    public void s3ServiceEventPerformed(GetObjectsEvent event) {
    }

    public void s3ServiceEventPerformed(GetObjectHeadsEvent event) {
    }

    public void s3ServiceEventPerformed(LookupACLEvent event) {
    }

    public void s3ServiceEventPerformed(UpdateACLEvent event) {
    }

    public void s3ServiceEventPerformed(DownloadObjectsEvent event) {
    }

    public void s3ServiceEventPerformed(CopyObjectsEvent event) {
    }

    public void s3ServiceEventPerformed(DeleteVersionedObjectsEvent event) {
    }

    public void valueChanged(ListSelectionEvent arg0) {
    }

    public static void main(String[] args) throws Exception {
        JFrame ownerFrame = new JFrame("JetS3t Uploader");
        ownerFrame.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        Properties argumentProperties = new Properties();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                int delimIndex = arg.indexOf("=");
                if (delimIndex >= 0) {
                    String name = arg.substring(0, delimIndex);
                    String value = arg.substring(delimIndex + 1);
                    argumentProperties.put(name, value);
                    continue;
                }
                System.out.println("Ignoring property argument with incorrect format: " + arg);
            }
        }
        new Uploader(ownerFrame, argumentProperties);
    }
}

