/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit;

import java.io.Serializable;
import java.util.Properties;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;

public class CockpitPreferences
implements Serializable {
    private static final long serialVersionUID = 6072192057121567975L;
    public static final String UPLOAD_ACL_PERMISSION_PRIVATE = "PRIVATE";
    public static final String UPLOAD_ACL_PERMISSION_PUBLIC_READ = "PUBLIC_READ";
    public static final String UPLOAD_ACL_PERMISSION_PUBLIC_READ_WRITE = "PUBLIC_READ_WRITE";
    private boolean rememberPreferences = true;
    private String uploadACLPermission = "PRIVATE";
    private boolean uploadCompressionActive = false;
    private boolean uploadEncryptionActive = false;
    private String uploadStorageClass = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).getStringProperty("s3service.default-storage-class", "STANDARD");
    private String encryptionPassword = null;
    private String encryptionAlgorithm = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).getStringProperty("crypto.algorithm", "PBEWithMD5AndDES");

    public String getEncryptionPassword() {
        return this.encryptionPassword;
    }

    public void setEncryptionPassword(String encryptionPasswrod) {
        this.encryptionPassword = encryptionPasswrod;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public boolean isEncryptionPasswordSet() {
        return this.encryptionPassword != null && this.encryptionPassword.length() > 0;
    }

    public String getUploadACLPermission() {
        return this.uploadACLPermission;
    }

    public void setUploadACLPermission(String uploadACLPermission) {
        if (!(UPLOAD_ACL_PERMISSION_PRIVATE.equals(uploadACLPermission) || UPLOAD_ACL_PERMISSION_PUBLIC_READ.equals(uploadACLPermission) || UPLOAD_ACL_PERMISSION_PUBLIC_READ_WRITE.equals(uploadACLPermission))) {
            throw new IllegalArgumentException("ACL Permission string is not a legal value: " + uploadACLPermission);
        }
        this.uploadACLPermission = uploadACLPermission;
    }

    public boolean isUploadCompressionActive() {
        return this.uploadCompressionActive;
    }

    public void setUploadCompressionActive(boolean uploadCompressionActive) {
        this.uploadCompressionActive = uploadCompressionActive;
    }

    public boolean isUploadEncryptionActive() {
        return this.uploadEncryptionActive;
    }

    public void setUploadEncryptionActive(boolean uploadEncryptionActive) {
        this.uploadEncryptionActive = uploadEncryptionActive;
    }

    public String getUploadStorageClass() {
        return this.uploadStorageClass;
    }

    public void setUploadStorageClass(String storageClass) {
        this.uploadStorageClass = storageClass;
    }

    public void setRememberPreferences(boolean rememberPreferences) {
        this.rememberPreferences = rememberPreferences;
    }

    public boolean isRememberPreferences() {
        return this.rememberPreferences;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty("upload-acl-permission", this.getUploadACLPermission());
        properties.setProperty("upload-compression-active", this.isUploadCompressionActive() ? "true" : "false");
        properties.setProperty("upload-encryption-active", this.isUploadEncryptionActive() ? "true" : "false");
        properties.setProperty("upload-storage-class", this.getUploadStorageClass());
        properties.setProperty("upload-encryption-algorithm", this.getEncryptionAlgorithm());
        return properties;
    }

    public void fromProperties(Properties properties) {
        this.setRememberPreferences(true);
        this.setUploadACLPermission(properties.getProperty("upload-acl-permission", this.getUploadACLPermission()));
        this.setUploadCompressionActive("true".equalsIgnoreCase(properties.getProperty("upload-compression-active")));
        this.setUploadEncryptionActive("true".equalsIgnoreCase(properties.getProperty("upload-encryption-active")));
        this.setUploadStorageClass(properties.getProperty("upload-storage-class", this.getUploadStorageClass()));
        this.setEncryptionAlgorithm(properties.getProperty("upload-encryption-algorithm", this.getEncryptionAlgorithm()));
    }
}

