/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression$class;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the trailing string which contains the characters from the trim string from the `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('LQSa', 'SSparkSQLS');\n       SSpark\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005-w!B\u0001\u0003\u0011\u0003y\u0011aD*ue&tw\r\u0016:j[JKw\r\u001b;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011qb\u0015;sS:<GK]5n%&<\u0007\u000e^\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=AQ!I\t\u0005\u0002\t\nQ!\u00199qYf$RaIAI\u0003+\u0003\"\u0001\u0005\u0013\u0007\tI\u0011\u0001)J\n\u0006I\u0019JCF\u0007\t\u0003!\u001dJ!\u0001\u000b\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002\u0011U%\u00111F\u0001\u0002\u0016'R\u0014\u0018N\\43)JLW.\u0012=qe\u0016\u001c8/[8o!\t)R&\u0003\u0002/-\t9\u0001K]8ek\u000e$\b\u0002\u0003\u0019%\u0005+\u0007I\u0011A\u0019\u0002\rM\u00148m\u0015;s+\u00051\u0003\u0002C\u001a%\u0005#\u0005\u000b\u0011\u0002\u0014\u0002\u000fM\u00148m\u0015;sA!AQ\u0007\nBK\u0002\u0013\u0005a'A\u0004ue&l7\u000b\u001e:\u0016\u0003]\u00022!\u0006\u001d'\u0013\tIdC\u0001\u0004PaRLwN\u001c\u0005\tw\u0011\u0012\t\u0012)A\u0005o\u0005AAO]5n'R\u0014\b\u0005C\u0003\u001fI\u0011\u0005Q\bF\u0002$}}BQ\u0001\r\u001fA\u0002\u0019Bq!\u000e\u001f\u0011\u0002\u0003\u0007q\u0007C\u0003\u001fI\u0011\u0005\u0011\tF\u0002$\u0005\u000eCQ!\u000e!A\u0002\u0019BQ\u0001\r!A\u0002\u0019BQA\b\u0013\u0005\u0002\u0015#\"a\t$\t\u000bA\"\u0005\u0019\u0001\u0014\t\u000b!#C\u0011I%\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001K!\tYeJ\u0004\u0002\u0016\u0019&\u0011QJF\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002N-!)!\u000b\nC!'\u0006A1\r[5mIJ,g.F\u0001U!\r)VL\n\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012B\u0001/\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0007M+\u0017O\u0003\u0002]-!)\u0011\r\nC!E\u0006!QM^1m)\t\u0019g\r\u0005\u0002\u0016I&\u0011QM\u0006\u0002\u0004\u0003:L\bbB4a!\u0003\u0005\r\u0001[\u0001\u0006S:\u0004X\u000f\u001e\t\u0003S*l\u0011\u0001B\u0005\u0003W\u0012\u00111\"\u00138uKJt\u0017\r\u001c*po\")Q\u000e\nC)]\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004_VT\bC\u00019t\u001b\u0005\t(B\u0001:\u0003\u0003\u001d\u0019w\u000eZ3hK:L!\u0001^9\u0003\u0011\u0015C\bO]\"pI\u0016DQA\u001e7A\u0002]\f1a\u0019;y!\t\u0001\b0\u0003\u0002zc\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B>m\u0001\u0004y\u0017AA3w\u0011\u001diH%!A\u0005\u0002y\fAaY8qsR!1e`A\u0001\u0011\u001d\u0001D\u0010%AA\u0002\u0019Bq!\u000e?\u0011\u0002\u0003\u0007q\u0007C\u0005\u0002\u0006\u0011\n\n\u0011\"\u0001\u0002\b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0005U\r1\u00131B\u0016\u0003\u0003\u001b\u0001B!a\u0004\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0003\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0005E!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u0004\u0013\u0012\u0002\u0013\u0005\u0011\u0011E\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019CK\u00028\u0003\u0017A\u0011\"a\n%\u0003\u0003%\t%!\u000b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t1\fgn\u001a\u0006\u0003\u0003k\tAA[1wC&\u0019q*a\f\t\u0013\u0005mB%!A\u0005\u0002\u0005u\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA !\r)\u0012\u0011I\u0005\u0004\u0003\u00072\"aA%oi\"I\u0011q\t\u0013\u0002\u0002\u0013\u0005\u0011\u0011J\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0019\u00171\n\u0005\u000b\u0003\u001b\n)%!AA\u0002\u0005}\u0012a\u0001=%c!I\u0011\u0011\u000b\u0013\u0002\u0002\u0013\u0005\u00131K\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000b\t\u0006\u0003/\nifY\u0007\u0003\u00033R1!a\u0017\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\nIF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\u0007JA\u0001\n\u0003\t)'\u0001\u0005dC:,\u0015/^1m)\u0011\t9'!\u001c\u0011\u0007U\tI'C\u0002\u0002lY\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002N\u0005\u0005\u0014\u0011!a\u0001G\"I\u0011\u0011\u000f\u0013\u0002\u0002\u0013\u0005\u00131O\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u0014Q\u000f\u0005\n\u0003\u001b\ny'!AA\u0002\rDs\u0002JA=\u0003\u007f\n\t)!\"\u0002\b\u0006-\u0015Q\u0012\t\u0004!\u0005m\u0014bAA?\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAB\u0003\u0005\r%\u0002\t\u0011!A}3UKT\"`QM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011ue\u0006LG.\u001b8hAM\u0004\u0018mY3!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)iJLWn\u0015;sY\u0001\u001aHO]\u0015![\u0001\u0012V-\\8wKN\u0004C\u000f[3!iJ\f\u0017\u000e\\5oO\u0002\u001aHO]5oO\u0002:\b.[2iA\r|g\u000e^1j]N\u0004C\u000f[3!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011ue&l\u0007e\u001d;sS:<\u0007E\u001a:p[\u0002\"\b.\u001a\u0011agR\u0014\bM\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002\n\u0006\tiB\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ue&l7\u000b\u001e:![\u0001\"\b.\u001a\u0011ue&l\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tAQ|\u0007\u0005\u001e:j[2\u0002C\u000f[3!I\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004\u0013\rI:j]\u001edW\rI:qC\u000e,'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a$\u0002\u0003\u001bQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u0011!A\u0001\u001a\u0006/\u0019:l'Fc\u0005\u0005\t\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sWN\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0019F\u001b\u0016m\n\u0017!OM\u001b\u0006/\u0019:l'Fc5kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u001b\u0006/\u0019:l\u0015\u0001\u0002\u0003BBAJA\u0001\u0007a%A\u0002tiJDQ!\u000e\u0011A\u0002\u0019Ba!I\t\u0005\u0002\u0005eEcA\u0012\u0002\u001c\"9\u00111SAL\u0001\u00041\u0003\u0002C\u0011\u0012\u0003\u0003%\t)a(\u0015\u000b\r\n\t+a)\t\rA\ni\n1\u0001'\u0011!)\u0014Q\u0014I\u0001\u0002\u00049\u0004\"CAT#\u0005\u0005I\u0011QAU\u0003\u001d)h.\u00199qYf$B!a+\u00024B!Q\u0003OAW!\u0015)\u0012q\u0016\u00148\u0013\r\t\tL\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005U\u0016QUA\u0001\u0002\u0004\u0019\u0013a\u0001=%a!I\u0011\u0011X\t\u0012\u0002\u0013\u0005\u0011\u0011E\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005u\u0016#%A\u0005\u0002\u0005\u0005\u0012aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\u0005\u0017#!A\u0005\n\u0005\r\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!2\u0011\t\u00055\u0012qY\u0005\u0005\u0003\u0013\fyC\u0001\u0004PE*,7\r\u001e")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight stringTrimRight) {
        return StringTrimRight$.MODULE$.unapply(stringTrimRight);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression$class.dataType(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression$class.inputTypes(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression$class.nullable(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression$class.foldable(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimRight((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimRight());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$6;

            public final ExprCode apply(Expression x$55) {
                return x$55.genCode(this.ctx$6);
            }
            {
                this.ctx$6 = ctx$6;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(new StringBuilder().append((Object)((TraversableOnce)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ExprCode x$56) {
                    return x$56.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimRight();\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()}))).toString(), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimRightFunction = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimRight(", ");\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trimString.isNull(), ev.isNull(), ev.value(), srcString.value(), trimString.value()}));
            exprCode = ev.copy(new StringBuilder().append((Object)((TraversableOnce)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ExprCode x$57) {
                    return x$57.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimRightFunction}))).toString(), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            case 0: {
                object = this.srcStr();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes$class.$init$(this);
        String2TrimExpression$class.$init$(this);
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

