/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.EquiJoin;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableIntList;

public class EnumerableMergeJoin
extends EquiJoin
implements EnumerableRel {
    EnumerableMergeJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
        super(cluster, traits, left, right, condition, leftKeys, rightKeys, joinType, variablesStopped);
        List<RelCollation> collations = traits.getTraits(RelCollationTraitDef.INSTANCE);
        assert (collations == null || RelCollations.contains(collations, leftKeys));
    }

    public static EnumerableMergeJoin create(RelNode left, RelNode right, RexLiteral condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType) throws InvalidRelException {
        RelOptCluster cluster = right.getCluster();
        RelTraitSet traitSet = cluster.traitSet();
        if (traitSet.isEnabled(RelCollationTraitDef.INSTANCE)) {
            List<RelCollation> collations = RelMdCollation.mergeJoin(left, right, leftKeys, rightKeys);
            traitSet = traitSet.replace(collations);
        }
        return new EnumerableMergeJoin(cluster, traitSet, left, right, condition, leftKeys, rightKeys, joinType, (Set<String>)ImmutableSet.of());
    }

    @Override
    public EnumerableMergeJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        assert (joinInfo.isEqui());
        try {
            return new EnumerableMergeJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys, joinType, (Set<String>)this.variablesStopped);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double rightRowCount = this.right.getRows();
        double leftRowCount = this.left.getRows();
        double rowCount = RelMetadataQuery.getRowCount(this);
        double d = leftRowCount + rightRowCount + rowCount;
        return planner.getCostFactory().makeCost(d, 0.0, 0.0);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        PhysType keyPhysType = leftResult.physType.project(this.leftKeys, JavaRowFormat.LIST);
        return implementor.result(physType, builder.append((Expression)Expressions.call((Method)BuiltInMethod.MERGE_JOIN.method, (Iterable)Expressions.list((Object[])new Expression[]{leftExpression, rightExpression, leftResult.physType.generateAccessor(this.leftKeys), rightResult.physType.generateAccessor(this.rightKeys), EnumUtils.joinSelector(this.joinType, physType, (List<PhysType>)ImmutableList.of((Object)leftResult.physType, (Object)rightResult.physType)), Expressions.constant((Object)this.joinType.generatesNullsOnLeft()), Expressions.constant((Object)this.joinType.generatesNullsOnRight())}))).toBlock());
    }
}

