/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.LeadLagInfo;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLag;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLead;

public class WindowingExprNodeEvaluatorFactory {
    public static ExprNodeEvaluator get(LeadLagInfo llInfo, ExprNodeDesc desc) throws HiveException {
        FindLeadLagFuncExprs visitor = new FindLeadLagFuncExprs(llInfo, desc);
        new ExprNodeWalker(visitor).walk(desc);
        return ExprNodeEvaluatorFactory.get(desc);
    }

    static class ExprNodeWalker {
        FindLeadLagFuncExprs visitor;

        public ExprNodeWalker(FindLeadLagFuncExprs visitor) {
            this.visitor = visitor;
        }

        public void walk(ExprNodeDesc e) throws HiveException {
            if (e == null) {
                return;
            }
            List<ExprNodeDesc> children = e.getChildren();
            if (children != null) {
                for (ExprNodeDesc child : children) {
                    this.walk(child);
                }
            }
            if (e instanceof ExprNodeGenericFuncDesc) {
                this.visitor.visit((ExprNodeGenericFuncDesc)e);
            }
        }
    }

    public static class FindLeadLagFuncExprs {
        ExprNodeDesc topExpr;
        LeadLagInfo llInfo;

        FindLeadLagFuncExprs(LeadLagInfo llInfo, ExprNodeDesc topExpr) {
            this.llInfo = llInfo;
            this.topExpr = topExpr;
        }

        public void visit(ExprNodeGenericFuncDesc fnExpr) throws HiveException {
            GenericUDF fn = fnExpr.getGenericUDF();
            if (fn instanceof GenericUDFLead || fn instanceof GenericUDFLag) {
                this.llInfo.addLLFuncExprForTopExpr(this.topExpr, fnExpr);
            }
        }
    }
}

