/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

public class SearchArgumentFactory {
    public static final String SARG_PUSHDOWN = "sarg.pushdown";

    public static SearchArgument create(ExprNodeGenericFuncDesc expression) {
        return new SearchArgumentImpl(expression);
    }

    public static SearchArgument.Builder newBuilder() {
        return SearchArgumentImpl.newBuilder();
    }

    public static SearchArgument create(String kryo) {
        return SearchArgumentImpl.fromKryo(kryo);
    }

    public static SearchArgument createFromConf(Configuration conf) {
        String sargString = null;
        sargString = conf.get("hive.io.filter.expr.serialized");
        if (sargString != null) {
            return SearchArgumentFactory.create(Utilities.deserializeExpression(sargString));
        }
        sargString = conf.get(SARG_PUSHDOWN);
        if (sargString != null) {
            return SearchArgumentFactory.create(sargString);
        }
        return null;
    }
}

