/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroGenericRecordWriter;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class AvroContainerOutputFormat
implements HiveOutputFormat<WritableComparable, AvroGenericRecordWritable> {
    public static final Log LOG = LogFactory.getLog(AvroContainerOutputFormat.class);

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path path, Class<? extends Writable> valueClass, boolean isCompressed, Properties properties, Progressable progressable) throws IOException {
        Schema schema;
        try {
            schema = AvroSerdeUtils.determineSchemaOrThrowException((Configuration)jobConf, properties);
        }
        catch (AvroSerdeException e) {
            throw new IOException(e);
        }
        GenericDatumWriter gdw = new GenericDatumWriter(schema);
        DataFileWriter dfw = new DataFileWriter((DatumWriter)gdw);
        if (isCompressed) {
            int level = jobConf.getInt("avro.mapred.deflate.level", 1);
            String codecName = jobConf.get("avro.output.codec", "deflate");
            CodecFactory factory = codecName.equals("deflate") ? CodecFactory.deflateCodec((int)level) : CodecFactory.fromString((String)codecName);
            dfw.setCodec(factory);
        }
        dfw.create(schema, (OutputStream)path.getFileSystem((Configuration)jobConf).create(path));
        return new AvroGenericRecordWriter((DataFileWriter<GenericRecord>)dfw);
    }

    public RecordWriter<WritableComparable, AvroGenericRecordWritable> getRecordWriter(FileSystem ignored, JobConf job, String fileName, Progressable progress) throws IOException {
        return new WrapperRecordWriter<WritableComparable, AvroGenericRecordWritable>(job, progress, fileName);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
    }

    class WrapperRecordWriter<K extends Writable, V extends Writable>
    implements RecordWriter<K, V> {
        FileSinkOperator.RecordWriter hiveWriter = null;
        JobConf jobConf;
        Progressable progressable;
        String fileName;

        public WrapperRecordWriter(JobConf jobConf, Progressable progressable, String fileName) {
            this.progressable = progressable;
            this.jobConf = jobConf;
            this.fileName = fileName;
        }

        private FileSinkOperator.RecordWriter getHiveWriter() throws IOException {
            if (this.hiveWriter == null) {
                Properties properties = new Properties();
                for (AvroSerdeUtils.AvroTableProperties tableProperty : AvroSerdeUtils.AvroTableProperties.values()) {
                    String propVal = this.jobConf.get(tableProperty.getPropName());
                    if (propVal == null) continue;
                    properties.put(tableProperty.getPropName(), propVal);
                }
                Boolean isCompressed = this.jobConf.getBoolean("mapreduce.output.fileoutputformat.compress", false);
                Path path = new Path(this.fileName);
                if (path.getFileSystem((Configuration)this.jobConf).isDirectory(path)) {
                    path = new Path(path, "_dummy");
                }
                this.hiveWriter = AvroContainerOutputFormat.this.getHiveRecordWriter(this.jobConf, path, null, isCompressed, properties, this.progressable);
            }
            return this.hiveWriter;
        }

        public void write(K key, V value) throws IOException {
            this.getHiveWriter().write((Writable)value);
        }

        public void close(Reporter reporter) throws IOException {
            this.getHiveWriter().close(false);
        }
    }
}

