/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception$;

public final class CSVInferSchema$ {
    public static final CSVInferSchema$ MODULE$;
    private final IndexedSeq<DataType> org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence;
    private final Function2<DataType, DataType, Option<DataType>> findTightestCommonType;

    static {
        new CSVInferSchema$();
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header, CSVOptions options) {
        StructField[] structFieldArray;
        if (options.inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final NullType$ apply() {
                    return NullType$.MODULE$;
                }
            }, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2)new Serializable(options){
                public static final long serialVersionUID = 0L;
                private final CSVOptions options$1;

                public final DataType[] apply(DataType[] rowSoFar, String[] next2) {
                    return CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$inferRowType(this.options$1, rowSoFar, next2);
                }
                {
                    this.options$1 = options$1;
                }
            }, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType[] apply(DataType[] first, DataType[] second) {
                    return CSVInferSchema$.MODULE$.mergeRowTypes(first, second);
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = (StructField[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])header).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rootTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(Tuple2<String, DataType> x0$1) {
                    Tuple2<String, DataType> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String thisHeader = (String)tuple2._1();
                        DataType rootType = (DataType)tuple2._2();
                        DataType dataType = rootType;
                        Object object = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
                        StringType$ dType = object;
                        StructField structField = new StructField(thisHeader, (DataType)dType, true, StructField$.MODULE$.apply$default$4());
                        return structField;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        } else {
            structFieldArray = (StructField[])Predef$.MODULE$.refArrayOps((Object[])header).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String fieldName) {
                    return new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public DataType[] org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$inferRowType(CSVOptions options, DataType[] rowSoFar, String[] next2) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next2.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next2[i], options);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])first).zipAll((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Tuple2<DataType, DataType> x0$2) {
                Tuple2<DataType, DataType> tuple2 = x0$2;
                if (tuple2 != null) {
                    DataType a = (DataType)tuple2._1();
                    DataType b = (DataType)tuple2._2();
                    DataType dataType = (DataType)((Option)CSVInferSchema$.MODULE$.findTightestCommonType().apply((Object)a, (Object)b)).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final NullType$ apply() {
                            return NullType$.MODULE$;
                        }
                    });
                    return dataType;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
    }

    public DataType inferField(DataType typeSoFar, String field, CSVOptions options) {
        DataType dataType;
        block15: {
            DataType dataType2;
            block6: {
                DataType dataType3;
                block8: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block7: {
                                                block5: {
                                                    block4: {
                                                        if (field == null || field.isEmpty()) break block4;
                                                        String string = field;
                                                        String string2 = options.nullValue();
                                                        if (string != null ? !string.equals(string2) : string2 != null) break block5;
                                                    }
                                                    dataType2 = typeSoFar;
                                                    break block6;
                                                }
                                                dataType = typeSoFar;
                                                if (!NullType$.MODULE$.equals(dataType)) break block7;
                                                dataType3 = this.tryParseInteger(field, options);
                                                break block8;
                                            }
                                            if (!IntegerType$.MODULE$.equals(dataType)) break block9;
                                            dataType3 = this.tryParseInteger(field, options);
                                            break block8;
                                        }
                                        if (!LongType$.MODULE$.equals(dataType)) break block10;
                                        dataType3 = this.tryParseLong(field, options);
                                        break block8;
                                    }
                                    if (!(dataType instanceof DecimalType)) break block11;
                                    dataType3 = (DataType)((Option)this.findTightestCommonType().apply((Object)typeSoFar, (Object)this.tryParseDecimal(field, options))).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final StringType$ apply() {
                                            return StringType$.MODULE$;
                                        }
                                    });
                                    break block8;
                                }
                                if (!DoubleType$.MODULE$.equals(dataType)) break block12;
                                dataType3 = this.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$tryParseDouble(field, options);
                                break block8;
                            }
                            if (!TimestampType$.MODULE$.equals(dataType)) break block13;
                            dataType3 = this.tryParseTimestamp(field, options);
                            break block8;
                        }
                        if (!BooleanType$.MODULE$.equals(dataType)) break block14;
                        dataType3 = this.tryParseBoolean(field, options);
                        break block8;
                    }
                    if (!StringType$.MODULE$.equals(dataType)) break block15;
                    dataType3 = StringType$.MODULE$;
                }
                dataType2 = dataType3;
            }
            return dataType2;
        }
        if (dataType != null) {
            DataType dataType4 = dataType;
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType4})));
        }
        throw new MatchError((Object)dataType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field, CSVOptions options) {
        String string = field;
        String string2 = options.nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = options.negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = options.positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.field$1)).toInt();
            }
            {
                this.field$1 = field$1;
            }
        }).isDefined() ? IntegerType$.MODULE$ : this.tryParseLong(field, options);
    }

    private DataType tryParseLong(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.field$2)).toLong();
            }
            {
                this.field$2 = field$2;
            }
        }).isDefined() ? LongType$.MODULE$ : this.tryParseDecimal(field, options);
    }

    private DataType tryParseDecimal(String field, CSVOptions options) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field, options){
            public static final long serialVersionUID = 0L;
            private final String field$3;
            private final CSVOptions options$2;

            public final DataType apply() {
                BigDecimal bigDecimal = new BigDecimal(this.field$3);
                return bigDecimal.scale() <= 0 ? new DecimalType(bigDecimal.precision(), bigDecimal.scale()) : CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$tryParseDouble(this.field$3, this.options$2);
            }
            {
                this.field$3 = field$3;
                this.options$2 = options$2;
            }
        });
        return (DataType)decimalTry.getOrElse((Function0)new Serializable(field, options){
            public static final long serialVersionUID = 0L;
            private final String field$3;
            private final CSVOptions options$2;

            public final DataType apply() {
                return CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$tryParseDouble(this.field$3, this.options$2);
            }
            {
                this.field$3 = field$3;
                this.options$2 = options$2;
            }
        });
    }

    public DataType org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$tryParseDouble(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$4;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.field$4)).toDouble();
            }
            {
                this.field$4 = field$4;
            }
        }).isDefined() || this.isInfOrNan(field, options) ? DoubleType$.MODULE$ : this.tryParseTimestamp(field, options);
    }

    private DataType tryParseTimestamp(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field, options){
            public static final long serialVersionUID = 0L;
            private final String field$5;
            private final CSVOptions options$3;

            public final Date apply() {
                return this.options$3.timestampFormat().parse(this.field$5);
            }
            {
                this.field$5 = field$5;
                this.options$3 = options$3;
            }
        }).isDefined() ? TimestampType$.MODULE$ : (Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$5;

            public final Date apply() {
                return DateTimeUtils$.MODULE$.stringToTime(this.field$5);
            }
            {
                this.field$5 = field$5;
            }
        }).isDefined() ? TimestampType$.MODULE$ : this.tryParseBoolean(field, options));
    }

    private DataType tryParseBoolean(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.field$6)).toBoolean();
            }
            {
                this.field$6 = field$6;
            }
        }).isDefined() ? BooleanType$.MODULE$ : this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    public IndexedSeq<DataType> org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence() {
        return this.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence;
    }

    public Function2<DataType, DataType, Option<DataType>> findTightestCommonType() {
        return this.findTightestCommonType;
    }

    private CSVInferSchema$() {
        MODULE$ = this;
        this.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence = TypeCoercion$.MODULE$.numericPrecedence();
        this.findTightestCommonType = new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Unable to fully structure code
             */
            public final Option<DataType> apply(DataType x0$3, DataType x1$1) {
                block5: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block9: {
                                                        block8: {
                                                            block7: {
                                                                block6: {
                                                                    block4: {
                                                                        var3_3 = new Tuple2((Object)x0$3, (Object)x1$1);
                                                                        if (var3_3 == null) break block4;
                                                                        t1 = (DataType)var3_3._1();
                                                                        t2 = (DataType)var3_3._2();
                                                                        v0 = t1;
                                                                        var6_6 = t2;
                                                                        if (v0 != null ? v0.equals(var6_6) == false : var6_6 != null) break block4;
                                                                        var7_7 = new Some((Object)t1);
                                                                        break block5;
                                                                    }
                                                                    if (var3_3 == null) break block6;
                                                                    var8_8 = (DataType)var3_3._1();
                                                                    t1 = (DataType)var3_3._2();
                                                                    if (!NullType$.MODULE$.equals(var8_8)) break block6;
                                                                    var7_7 = new Some((Object)t1);
                                                                    break block5;
                                                                }
                                                                if (var3_3 == null) break block7;
                                                                t1 = (DataType)var3_3._1();
                                                                var11_11 = (DataType)var3_3._2();
                                                                if (!NullType$.MODULE$.equals(var11_11)) break block7;
                                                                var7_7 = new Some((Object)t1);
                                                                break block5;
                                                            }
                                                            if (var3_3 == null || !StringType$.MODULE$.equals(var12_12 = (DataType)var3_3._1())) break block8;
                                                            var7_7 = new Some((Object)StringType$.MODULE$);
                                                            break block5;
                                                        }
                                                        if (var3_3 == null || !StringType$.MODULE$.equals(var13_13 = (DataType)var3_3._2())) break block9;
                                                        var7_7 = new Some((Object)StringType$.MODULE$);
                                                        break block5;
                                                    }
                                                    if (var3_3 == null || !((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{t1 = (DataType)var3_3._1(), t2 = (DataType)var3_3._2()}))).forall((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final boolean apply(Object elem) {
                                                            return CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence().contains(elem);
                                                        }
                                                    })) break block10;
                                                    index = CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence().lastIndexWhere((Function1)new Serializable(this, t1, t2){
                                                        public static final long serialVersionUID = 0L;
                                                        private final DataType t1$1;
                                                        private final DataType t2$1;

                                                        /*
                                                         * Enabled force condition propagation
                                                         * Lifted jumps to return sites
                                                         */
                                                        public final boolean apply(DataType t) {
                                                            DataType dataType = t;
                                                            DataType dataType2 = this.t1$1;
                                                            if (dataType == null) {
                                                                if (dataType2 == null) return true;
                                                            } else if (dataType.equals(dataType2)) return true;
                                                            DataType dataType3 = t;
                                                            DataType dataType4 = this.t2$1;
                                                            if (dataType3 != null) {
                                                                if (!dataType3.equals(dataType4)) return false;
                                                                return true;
                                                            }
                                                            if (dataType4 == null) return true;
                                                            return false;
                                                        }
                                                        {
                                                            this.t1$1 = t1$1;
                                                            this.t2$1 = t2$1;
                                                        }
                                                    });
                                                    var7_7 = new Some(CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence().apply(index));
                                                    break block5;
                                                }
                                                if (var3_3 == null) break block11;
                                                t1 = (DataType)var3_3._1();
                                                t2 = (DataType)var3_3._2();
                                                if (!(t1 instanceof IntegralType)) break block11;
                                                var19_19 = (IntegralType)t1;
                                                if (!(t2 instanceof DecimalType) || !(var20_20 = (DecimalType)t2).isWiderThan((DataType)var19_19)) break block11;
                                                var7_7 = new Some((Object)var20_20);
                                                break block5;
                                            }
                                            if (var3_3 == null) break block12;
                                            t1 = (DataType)var3_3._1();
                                            t2 = (DataType)var3_3._2();
                                            if (!(t1 instanceof DecimalType)) break block12;
                                            var23_23 = (DecimalType)t1;
                                            if (!(t2 instanceof IntegralType) || !var23_23.isWiderThan((DataType)(var24_24 = (IntegralType)t2))) break block12;
                                            var7_7 = new Some((Object)var23_23);
                                            break block5;
                                        }
                                        if (var3_3 == null) break block13;
                                        t1 = (DataType)var3_3._1();
                                        t2 = (DataType)var3_3._2();
                                        if (!(t1 instanceof IntegralType)) break block13;
                                        var27_27 = (IntegralType)t1;
                                        if (!(t2 instanceof DecimalType)) break block13;
                                        var28_28 = (DecimalType)t2;
                                        var7_7 = (Option)CSVInferSchema$.MODULE$.findTightestCommonType().apply((Object)DecimalType$.MODULE$.forType((DataType)var27_27), (Object)var28_28);
                                        break block5;
                                    }
                                    if (var3_3 == null) break block14;
                                    t1 = (DataType)var3_3._1();
                                    t2 = (DataType)var3_3._2();
                                    if (!(t1 instanceof DecimalType)) break block14;
                                    var31_31 = (DecimalType)t1;
                                    if (!(t2 instanceof IntegralType)) break block14;
                                    var32_32 = (IntegralType)t2;
                                    var7_7 = (Option)CSVInferSchema$.MODULE$.findTightestCommonType().apply((Object)var31_31, (Object)DecimalType$.MODULE$.forType((DataType)var32_32));
                                    break block5;
                                }
                                if (var3_3 == null || !DoubleType$.MODULE$.equals(var33_33 = (DataType)var3_3._1()) || !(var3_3._2() instanceof DecimalType)) break block15;
                                var34_34 = true;
                                break block16;
                            }
                            if (var3_3 == null) ** GOTO lbl-1000
                            var35_35 = (DataType)var3_3._2();
                            if (var3_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var35_35)) {
                                var34_34 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var34_34 = false;
                            }
                        }
                        if (!var34_34) break block17;
                        var7_7 = new Some((Object)DoubleType$.MODULE$);
                        break block5;
                    }
                    if (var3_3 == null) ** GOTO lbl-1000
                    t1 = (DataType)var3_3._1();
                    t2 = (DataType)var3_3._2();
                    if (!(t1 instanceof DecimalType)) ** GOTO lbl-1000
                    var38_38 = (DecimalType)t1;
                    if (t2 instanceof DecimalType) {
                        var39_39 = (DecimalType)t2;
                        scale = package$.MODULE$.max(var38_38.scale(), var39_39.scale());
                        range = package$.MODULE$.max(var38_38.precision() - var38_38.scale(), var39_39.precision() - var39_39.scale());
                        var7_7 = range + scale > 38 ? new Some((Object)DoubleType$.MODULE$) : new Some((Object)new DecimalType(range + scale, scale));
                    } else lbl-1000:
                    // 3 sources

                    {
                        var7_7 = None$.MODULE$;
                    }
                }
                return var7_7;
            }
        };
    }
}

