/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.scostore.ListStore;

public class SCOListIterator
implements ListIterator {
    private final ListIterator iter;
    private final List ownerSCO;
    private boolean reverse;

    public SCOListIterator(List sco, ObjectProvider sm, List theDelegate, ListStore theStore, boolean useDelegate, int startIndex) {
        this.ownerSCO = sco;
        ArrayList entries = new ArrayList();
        Iterator i = null;
        i = useDelegate ? theDelegate.iterator() : (theStore != null ? theStore.iterator(sm) : theDelegate.iterator());
        while (i.hasNext()) {
            entries.add(i.next());
        }
        this.iter = startIndex >= 0 ? entries.listIterator(startIndex) : entries.listIterator();
    }

    public void add(Object o) {
        this.iter.add(o);
        this.ownerSCO.add(this.iter.previousIndex(), o);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.iter.hasPrevious();
    }

    @Override
    public Object next() {
        Object result = this.iter.next();
        this.reverse = false;
        return result;
    }

    @Override
    public int nextIndex() {
        return this.iter.nextIndex();
    }

    public Object previous() {
        Object result = this.iter.previous();
        this.reverse = true;
        return result;
    }

    @Override
    public int previousIndex() {
        return this.iter.previousIndex();
    }

    @Override
    public void remove() {
        this.iter.remove();
        this.ownerSCO.remove(this.iter.nextIndex());
    }

    public void set(Object o) {
        this.iter.set(o);
        this.ownerSCO.set(this.reverse ? this.iter.nextIndex() : this.iter.previousIndex(), o);
    }
}

