/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit.steps;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.steps.DriverConfigurationStep;
import org.apache.spark.deploy.k8s.submit.steps.DriverServiceBootstrapStep$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4Q!\u0001\u0002\u0001\u0015A\u0011!\u0004\u0012:jm\u0016\u00148+\u001a:wS\u000e,'i\\8ugR\u0014\u0018\r]*uKBT!a\u0001\u0003\u0002\u000bM$X\r]:\u000b\u0005\u00151\u0011AB:vE6LGO\u0003\u0002\b\u0011\u0005\u00191\u000eO:\u000b\u0005%Q\u0011A\u00023fa2|\u0017P\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h'\u0011\u0001\u0011cF\u000e\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tA\u0012$D\u0001\u0003\u0013\tQ\"AA\fEe&4XM]\"p]\u001aLw-\u001e:bi&|gn\u0015;faB\u0011AdH\u0007\u0002;)\u0011aDC\u0001\tS:$XM\u001d8bY&\u0011\u0001%\b\u0002\b\u0019><w-\u001b8h\u0011!\u0011\u0003A!A!\u0002\u0013!\u0013A\u0005:fg>,(oY3OC6,\u0007K]3gSb\u001c\u0001\u0001\u0005\u0002&Q9\u0011!CJ\u0005\u0003OM\ta\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011qe\u0005\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005aAM]5wKJd\u0015MY3mgB!QE\f\u0013%\u0013\ty#FA\u0002NCBD\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\ngB\f'o[\"p]\u001a\u0004\"a\r\u001b\u000e\u0003)I!!\u000e\u0006\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u000b\rdwnY6\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mR\u0011\u0001B;uS2L!!\u0010\u001e\u0003\u000b\rcwnY6\t\u000b}\u0002A\u0011\u0001!\u0002\rqJg.\u001b;?)\u0015\t%i\u0011#F!\tA\u0002\u0001C\u0003#}\u0001\u0007A\u0005C\u0003-}\u0001\u0007Q\u0006C\u00032}\u0001\u0007!\u0007C\u00038}\u0001\u0007\u0001\bC\u0003H\u0001\u0011\u0005\u0003*A\bd_:4\u0017nZ;sK\u0012\u0013\u0018N^3s)\tIU\n\u0005\u0002K\u00176\tA!\u0003\u0002M\t\t!2*\u001e2fe:,G/Z:Ee&4XM]*qK\u000eDQA\u0014$A\u0002%\u000b!\u0002\u001a:jm\u0016\u00148\u000b]3d\u000f\u0019\u0001&\u0001#\u0001\u000b#\u0006QBI]5wKJ\u001cVM\u001d<jG\u0016\u0014un\u001c;tiJ\f\u0007o\u0015;faB\u0011\u0001D\u0015\u0004\u0007\u0003\tA\tAC*\u0014\u0005I\u000b\u0002\"B S\t\u0003)F#A)\t\u000f]\u0013&\u0019!C\u00011\u00069BIU%W\u000bJ{&)\u0013(E?\u0006#EIU#T'~[U)W\u000b\u0002I!1!L\u0015Q\u0001\n\u0011\n\u0001\u0004\u0012*J-\u0016\u0013vLQ%O\t~\u000bE\t\u0012*F'N{6*R-!\u0011\u001da&K1A\u0005\u0002a\u000bq\u0002\u0012*J-\u0016\u0013v\fS(T)~[U)\u0017\u0005\u0007=J\u0003\u000b\u0011\u0002\u0013\u0002!\u0011\u0013\u0016JV#S?\"{5\u000bV0L\u000bf\u0003\u0003b\u00021S\u0005\u0004%\t!Y\u0001\u0013\tJKe+\u0012*`'Z\u001bu\fU(T)\u001aK\u0005,F\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0003mC:<'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0011DaA\u001b*!\u0002\u0013\u0011\u0017a\u0005#S\u0013Z+%kX*W\u0007~\u0003vj\u0015+G\u0013b\u0003\u0003b\u00027S\u0005\u0004%\t!\\\u0001\u0018\u001b\u0006CvlU#S-&\u001bUi\u0018(B\u001b\u0016{F*\u0012(H)\"+\u0012A\u001c\t\u0003%=L!\u0001]\n\u0003\u0007%sG\u000f\u0003\u0004s%\u0002\u0006IA\\\u0001\u0019\u001b\u0006CvlU#S-&\u001bUi\u0018(B\u001b\u0016{F*\u0012(H)\"\u0003\u0003")
public class DriverServiceBootstrapStep
implements DriverConfigurationStep,
Logging {
    private final String resourceNamePrefix;
    private final Map<String, String> driverLabels;
    private final SparkConf sparkConf;
    private final Clock clock;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int MAX_SERVICE_NAME_LENGTH() {
        return DriverServiceBootstrapStep$.MODULE$.MAX_SERVICE_NAME_LENGTH();
    }

    public static String DRIVER_SVC_POSTFIX() {
        return DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX();
    }

    public static String DRIVER_HOST_KEY() {
        return DriverServiceBootstrapStep$.MODULE$.DRIVER_HOST_KEY();
    }

    public static String DRIVER_BIND_ADDRESS_KEY() {
        return DriverServiceBootstrapStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public KubernetesDriverSpec configureDriver(KubernetesDriverSpec driverSpec) {
        SparkConf resolvedSparkConf;
        String string;
        Predef$.MODULE$.require(this.sparkConf.getOption(DriverServiceBootstrapStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported in Kubernetes mode, as the driver's bind "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DriverServiceBootstrapStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()}))).append((Object)"address is managed and set to the driver pod's IP address.").toString();
            }
        });
        Predef$.MODULE$.require(this.sparkConf.getOption(DriverServiceBootstrapStep$.MODULE$.DRIVER_HOST_KEY()).isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported in Kubernetes mode, as the driver's hostname will be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DriverServiceBootstrapStep$.MODULE$.DRIVER_HOST_KEY()}))).append((Object)"managed via a Kubernetes service.").toString();
            }
        });
        String preferredServiceName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resourceNamePrefix, DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX()}));
        if (preferredServiceName.length() <= DriverServiceBootstrapStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()) {
            string = preferredServiceName;
        } else {
            long randomServiceId = this.clock.getTimeMillis();
            String shorterServiceName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)randomServiceId), DriverServiceBootstrapStep$.MODULE$.DRIVER_SVC_POSTFIX()}));
            this.logWarning((Function0<String>)new Serializable(this, preferredServiceName, shorterServiceName){
                public static final long serialVersionUID = 0L;
                private final String preferredServiceName$1;
                private final String shorterServiceName$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Driver's hostname would preferably be ", ", but this is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.preferredServiceName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"too long (must be <= ", " characters). Falling back to use "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)DriverServiceBootstrapStep$.MODULE$.MAX_SERVICE_NAME_LENGTH())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " as the driver service's name."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shorterServiceName$1}))).toString();
                }
                {
                    this.preferredServiceName$1 = preferredServiceName$1;
                    this.shorterServiceName$1 = shorterServiceName$1;
                }
            });
            string = shorterServiceName;
        }
        String resolvedServiceName = string;
        int driverPort = this.sparkConf.getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        int driverBlockManagerPort = this.sparkConf.getInt(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        Service driverService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent)((ServiceSpecFluent.PortsNested)((ServiceFluentImpl)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(resolvedServiceName)).endMetadata()).withNewSpec().withClusterIP("None").withSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.driverLabels).asJava()).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(driverPort)).withNewTargetPort(Predef$.MODULE$.int2Integer(driverPort))).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(driverBlockManagerPort)).withNewTargetPort(Predef$.MODULE$.int2Integer(driverBlockManagerPort))).endPort()).endSpec()).build();
        String namespace = (String)this.sparkConf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        String driverHostname = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".svc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{driverService.getMetadata().getName(), namespace}));
        SparkConf x$1 = resolvedSparkConf = driverSpec.driverSparkConf().clone().set(DriverServiceBootstrapStep$.MODULE$.DRIVER_HOST_KEY(), driverHostname).set("spark.driver.port", ((Object)BoxesRunTime.boxToInteger((int)driverPort)).toString()).set(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)driverBlockManagerPort));
        Seq x$2 = (Seq)driverSpec.otherKubernetesResources().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Service[]{driverService})), Seq$.MODULE$.canBuildFrom());
        Pod x$3 = driverSpec.copy$default$1();
        Container x$4 = driverSpec.copy$default$2();
        return driverSpec.copy(x$3, x$4, (Seq<HasMetadata>)x$2, x$1);
    }

    public DriverServiceBootstrapStep(String resourceNamePrefix, Map<String, String> driverLabels, SparkConf sparkConf, Clock clock) {
        this.resourceNamePrefix = resourceNamePrefix;
        this.driverLabels = driverLabels;
        this.sparkConf = sparkConf;
        this.clock = clock;
        Logging.class.$init$((Logging)this);
    }
}

