/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit.steps;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.SecretFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.steps.DriverConfigurationStep;
import org.apache.spark.deploy.k8s.submit.steps.DriverKubernetesCredentialsStep$;
import org.apache.spark.deploy.k8s.submit.steps.OptionSettableSparkConf;
import org.spark_project.guava.io.BaseEncoding;
import org.spark_project.guava.io.Files;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\u0001\u0003\u0001)\u0001\"a\b#sSZ,'oS;cKJtW\r^3t\u0007J,G-\u001a8uS\u0006d7o\u0015;fa*\u00111\u0001B\u0001\u0006gR,\u0007o\u001d\u0006\u0003\u000b\u0019\taa];c[&$(BA\u0004\t\u0003\rY\u0007h\u001d\u0006\u0003\u0013)\ta\u0001Z3qY>L(BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0014\u0007\u0001\tr\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VM\u001a\t\u00031ei\u0011AA\u0005\u00035\t\u0011q\u0003\u0012:jm\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u001cF/\u001a9\t\u0011q\u0001!\u0011!Q\u0001\ny\t1c];c[&\u001c8/[8o'B\f'o[\"p]\u001a\u001c\u0001\u0001\u0005\u0002 A5\t!\"\u0003\u0002\"\u0015\tI1\u000b]1sW\u000e{gN\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005a2.\u001e2fe:,G/Z:SKN|WO]2f\u001d\u0006lW\r\u0015:fM&D\bCA\u0013)\u001d\t\u0011b%\u0003\u0002('\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t93\u0003C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]=\u0002\u0004C\u0001\r\u0001\u0011\u0015a2\u00061\u0001\u001f\u0011\u0015\u00193\u00061\u0001%\u0011\u001d\u0011\u0004A1A\u0005\nM\n!$\\1zE\u0016lu.\u001e8uK\u0012|\u0015)\u001e;i)>\\WM\u001c$jY\u0016,\u0012\u0001\u000e\t\u0004%U\"\u0013B\u0001\u001c\u0014\u0005\u0019y\u0005\u000f^5p]\"1\u0001\b\u0001Q\u0001\nQ\n1$\\1zE\u0016lu.\u001e8uK\u0012|\u0015)\u001e;i)>\\WM\u001c$jY\u0016\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%IaM\u0001\u001a[\u0006L(-Z'pk:$X\rZ\"mS\u0016tGoS3z\r&dW\r\u0003\u0004=\u0001\u0001\u0006I\u0001N\u0001\u001b[\u0006L(-Z'pk:$X\rZ\"mS\u0016tGoS3z\r&dW\r\t\u0005\b}\u0001\u0011\r\u0011\"\u00034\u0003ii\u0017-\u001f2f\u001b>,h\u000e^3e\u00072LWM\u001c;DKJ$h)\u001b7f\u0011\u0019\u0001\u0005\u0001)A\u0005i\u0005YR.Y=cK6{WO\u001c;fI\u000ec\u0017.\u001a8u\u0007\u0016\u0014HOR5mK\u0002BqA\u0011\u0001C\u0002\u0013%1'\u0001\fnCf\u0014W-T8v]R,GmQ1DKJ$h)\u001b7f\u0011\u0019!\u0005\u0001)A\u0005i\u00059R.Y=cK6{WO\u001c;fI\u000e\u000b7)\u001a:u\r&dW\r\t\u0005\b\r\u0002\u0011\r\u0011\"\u00034\u0003Q!'/\u001b<feN+'O^5dK\u0006\u001b7m\\;oi\"1\u0001\n\u0001Q\u0001\nQ\nQ\u0003\u001a:jm\u0016\u00148+\u001a:wS\u000e,\u0017iY2pk:$\b\u0005C\u0003K\u0001\u0011\u00053*A\bd_:4\u0017nZ;sK\u0012\u0013\u0018N^3s)\ta\u0005\u000b\u0005\u0002N\u001d6\tA!\u0003\u0002P\t\t!2*\u001e2fe:,G/Z:Ee&4XM]*qK\u000eDQ!U%A\u00021\u000b!\u0002\u001a:jm\u0016\u00148\u000b]3d\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0003]\u0019'/Z1uK\u000e\u0013X\rZ3oi&\fGn]*fGJ,G\u000fF\u0003VI\u001aD'\u000eE\u0002\u0013kY\u0003\"a\u00162\u000e\u0003aS!!\u0017.\u0002\u000b5|G-\u001a7\u000b\u0005mc\u0016aA1qS*\u0011QLX\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(BA0a\u0003\u001d1\u0017M\u0019:jGbR\u0011!Y\u0001\u0003S>L!a\u0019-\u0003\rM+7M]3u\u0011\u0015)'\u000b1\u00015\u0003Y!'/\u001b<fe>\u000bU\u000f\u001e5U_.,gNQ1tKZ\"\u0004\"B4S\u0001\u0004!\u0014A\u00063sSZ,'oQ1DKJ$H)\u0019;b\u0005\u0006\u001cXM\u000e\u001b\t\u000b%\u0014\u0006\u0019\u0001\u001b\u00023\u0011\u0014\u0018N^3s\u00072LWM\u001c;LKf$\u0015\r^1CCN,g\u0007\u000e\u0005\u0006WJ\u0003\r\u0001N\u0001\u001bIJLg/\u001a:DY&,g\u000e^\"feR$\u0015\r^1CCN,g\u0007\u000e\u0005\u0006[\u0002!IA\\\u0001*g\u0016$HI]5wKJ\u0004v\u000eZ&vE\u0016\u0014h.\u001a;fg\u000e\u0013X\rZ3oi&\fG\u000eT8dCRLwN\\:\u0015\ryy\u0017o\u001d;v\u0011\u0015\u0001H\u000e1\u0001\u001f\u0003=!'/\u001b<feN\u0003\u0018M]6D_:4\u0007\"\u0002:m\u0001\u0004!\u0014A\u00063sSZ,'oT1vi\"$vn[3o\u0005\u0006\u001cXM\u000e\u001b\t\u000b\u001dd\u0007\u0019\u0001\u001b\t\u000b%d\u0007\u0019\u0001\u001b\t\u000b-d\u0007\u0019\u0001\u001b\t\u000b]\u0004A\u0011\u0002=\u0002)M\fg-\u001a$jY\u0016\u001cuN\u001c4U_\n\u000b7/\u001a\u001c5)\r!\u0014p\u001f\u0005\u0006uZ\u0004\r\u0001J\u0001\u0005G>tg\rC\u0003}m\u0002\u0007A%\u0001\u0005gS2,G+\u001f9f\u0011\u0015q\b\u0001\"\u0003\u0000\u0003U\u0011Xm]8mm\u0016\u001cVm\u0019:fi2{7-\u0019;j_:$r\u0001NA\u0001\u0003\u000b\tI\u0001\u0003\u0004\u0002\u0004u\u0004\r\u0001N\u0001\u0015[>,h\u000e^3e+N,'o\u00159fG&4\u0017.\u001a3\t\r\u0005\u001dQ\u00101\u00015\u0003e1\u0018\r\\;f\u001b>,h\u000e^3e\rJ|WnU;c[&$H/\u001a:\t\r\u0005-Q\u00101\u0001%\u0003aiw.\u001e8uK\u0012\u001c\u0015M\\8oS\u000e\fG\u000eT8dCRLwN\u001c\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0003E\u0011Xm]8mm\u0016\u001cVm\u0019:fi\u0012\u000bG/\u0019\u000b\u0007\u0003'\tI\"!\b\u0011\u000b\u0015\n)\u0002\n\u0013\n\u0007\u0005]!FA\u0002NCBDq!a\u0007\u0002\u000e\u0001\u0007A'A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ\"sK\u0012,g\u000e^5bY\"9\u0011qDA\u0007\u0001\u0004!\u0013AC:fGJ,GOT1nK\"9\u00111\u0005\u0001\u0005\f\u0005\u0015\u0012\u0001E1vO6,g\u000e^*qCJ\\7i\u001c8g)\u0011\t9#!\f\u0011\u0007a\tI#C\u0002\u0002,\t\u0011qc\u00149uS>t7+\u001a;uC\ndWm\u00159be.\u001cuN\u001c4\t\u000f\u0005=\u0012\u0011\u0005a\u0001=\u0005I1\u000f]1sW\u000e{gN\u001a")
public class DriverKubernetesCredentialsStep
implements DriverConfigurationStep {
    private final SparkConf submissionSparkConf;
    private final String kubernetesResourceNamePrefix;
    private final Option<String> maybeMountedOAuthTokenFile;
    private final Option<String> maybeMountedClientKeyFile;
    private final Option<String> maybeMountedClientCertFile;
    private final Option<String> maybeMountedCaCertFile;
    private final Option<String> org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStep$$driverServiceAccount;

    private Option<String> maybeMountedOAuthTokenFile() {
        return this.maybeMountedOAuthTokenFile;
    }

    private Option<String> maybeMountedClientKeyFile() {
        return this.maybeMountedClientKeyFile;
    }

    private Option<String> maybeMountedClientCertFile() {
        return this.maybeMountedClientCertFile;
    }

    private Option<String> maybeMountedCaCertFile() {
        return this.maybeMountedCaCertFile;
    }

    public Option<String> org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStep$$driverServiceAccount() {
        return this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStep$$driverServiceAccount;
    }

    @Override
    public KubernetesDriverSpec configureDriver(KubernetesDriverSpec driverSpec) {
        SparkConf driverSparkConf = driverSpec.driverSparkConf().clone();
        Option oauthTokenBase64 = this.submissionSparkConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String token) {
                return BaseEncoding.base64().encode(token.getBytes(StandardCharsets.UTF_8));
            }
        });
        Option<String> caCertDataBase64 = this.safeFileConfToBase64(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()})), "Driver CA cert file");
        Option<String> clientKeyDataBase64 = this.safeFileConfToBase64(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()})), "Driver client key file");
        Option<String> clientCertDataBase64 = this.safeFileConfToBase64(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()})), "Driver client cert file");
        SparkConf driverSparkConfWithCredentialsLocations = this.setDriverPodKubernetesCredentialLocations(driverSparkConf, (Option<String>)oauthTokenBase64, caCertDataBase64, clientKeyDataBase64, clientCertDataBase64);
        Option<Secret> kubernetesCredentialsSecret = this.createCredentialsSecret((Option<String>)oauthTokenBase64, caCertDataBase64, clientKeyDataBase64, clientCertDataBase64);
        Pod driverPodWithMountedKubernetesCredentials = (Pod)kubernetesCredentialsSecret.map((Function1)new Serializable(this, driverSpec){
            public static final long serialVersionUID = 0L;
            private final KubernetesDriverSpec driverSpec$1;

            public final Pod apply(Secret secret) {
                return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)new PodBuilder(this.driverSpec$1.driverPod()).editOrNewSpec().addNewVolume().withName(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME()).withNewSecret().withSecretName(secret.getMetadata().getName())).endSecret()).endVolume()).endSpec()).build();
            }
            {
                this.driverSpec$1 = driverSpec$1;
            }
        }).getOrElse((Function0)new Serializable(this, driverSpec){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DriverKubernetesCredentialsStep $outer;
            public final KubernetesDriverSpec driverSpec$1;

            public final Pod apply() {
                return (Pod)this.$outer.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStep$$driverServiceAccount().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Pod apply(String account) {
                        return ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(this.$outer.driverSpec$1.driverPod()).editOrNewSpec().withServiceAccount(account).withServiceAccountName(account)).endSpec()).build();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Pod apply() {
                        return this.$outer.driverSpec$1.driverPod();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driverSpec$1 = driverSpec$1;
            }
        });
        Container driverContainerWithMountedSecretVolume = (Container)kubernetesCredentialsSecret.map((Function1)new Serializable(this, driverSpec){
            public static final long serialVersionUID = 0L;
            private final KubernetesDriverSpec driverSpec$1;

            public final Container apply(Secret secret) {
                return ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(this.driverSpec$1.driverContainer()).addNewVolumeMount().withName(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRET_VOLUME_NAME()).withMountPath(Constants$.MODULE$.DRIVER_CREDENTIALS_SECRETS_BASE_DIR())).endVolumeMount()).build();
            }
            {
                this.driverSpec$1 = driverSpec$1;
            }
        }).getOrElse((Function0)new Serializable(this, driverSpec){
            public static final long serialVersionUID = 0L;
            private final KubernetesDriverSpec driverSpec$1;

            public final Container apply() {
                return this.driverSpec$1.driverContainer();
            }
            {
                this.driverSpec$1 = driverSpec$1;
            }
        });
        Pod x$6 = driverPodWithMountedKubernetesCredentials;
        Seq x$7 = (Seq)driverSpec.otherKubernetesResources().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(kubernetesCredentialsSecret).toSeq(), Seq$.MODULE$.canBuildFrom());
        SparkConf x$8 = driverSparkConfWithCredentialsLocations;
        Container x$9 = driverContainerWithMountedSecretVolume;
        return driverSpec.copy(x$6, x$9, (Seq<HasMetadata>)x$7, x$8);
    }

    private Option<Secret> createCredentialsSecret(Option<String> driverOAuthTokenBase64, Option<String> driverCaCertDataBase64, Option<String> driverClientKeyDataBase64, Option<String> driverClientCertDataBase64) {
        scala.collection.immutable.Map allSecretData = this.resolveSecretData(driverClientKeyDataBase64, Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_SECRET_NAME()).$plus$plus(this.resolveSecretData(driverClientCertDataBase64, Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_SECRET_NAME())).$plus$plus(this.resolveSecretData(driverCaCertDataBase64, Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_SECRET_NAME())).$plus$plus(this.resolveSecretData(driverOAuthTokenBase64, Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_SECRET_NAME()));
        return allSecretData.isEmpty() ? None$.MODULE$ : new Some((Object)((SecretBuilder)((SecretFluentImpl)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-kubernetes-credentials"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kubernetesResourceNamePrefix})))).endMetadata()).withData((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)allSecretData).asJava())).build());
    }

    private SparkConf setDriverPodKubernetesCredentialLocations(SparkConf driverSparkConf, Option<String> driverOauthTokenBase64, Option<String> driverCaCertDataBase64, Option<String> driverClientKeyDataBase64, Option<String> driverClientCertDataBase64) {
        Option<String> resolvedMountedOAuthTokenFile = this.resolveSecretLocation(this.maybeMountedOAuthTokenFile(), driverOauthTokenBase64, Constants$.MODULE$.DRIVER_CREDENTIALS_OAUTH_TOKEN_PATH());
        Option<String> resolvedMountedClientKeyFile = this.resolveSecretLocation(this.maybeMountedClientKeyFile(), driverClientKeyDataBase64, Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_KEY_PATH());
        Option<String> resolvedMountedClientCertFile = this.resolveSecretLocation(this.maybeMountedClientCertFile(), driverClientCertDataBase64, Constants$.MODULE$.DRIVER_CREDENTIALS_CLIENT_CERT_PATH());
        Option<String> resolvedMountedCaCertFile = this.resolveSecretLocation(this.maybeMountedCaCertFile(), driverCaCertDataBase64, Constants$.MODULE$.DRIVER_CREDENTIALS_CA_CERT_PATH());
        SparkConf sparkConfWithCredentialLocations = this.augmentSparkConf(this.augmentSparkConf(this.augmentSparkConf(this.augmentSparkConf(driverSparkConf).setOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()})), resolvedMountedCaCertFile)).setOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()})), resolvedMountedClientKeyFile)).setOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()})), resolvedMountedClientCertFile)).setOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()})), resolvedMountedOAuthTokenFile);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sparkConfWithCredentialLocations.getAll()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$1) {
                return ((String)x$1._1()).endsWith(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX());
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x$2) {
                return (String)x$2._1();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, sparkConfWithCredentialLocations){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConfWithCredentialLocations$1;

            public final SparkConf apply(String x$3) {
                return this.sparkConfWithCredentialLocations$1.set(x$3, "<present_but_redacted>");
            }
            {
                this.sparkConfWithCredentialLocations$1 = sparkConfWithCredentialLocations$1;
            }
        });
        return sparkConfWithCredentialLocations;
    }

    private Option<String> safeFileConfToBase64(String conf, String fileType) {
        return this.submissionSparkConf.getOption(conf).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$4) {
                return new File(x$4);
            }
        }).map((Function1)new Serializable(this, fileType){
            public static final long serialVersionUID = 0L;
            public final String fileType$1;

            public final String apply(File file) {
                Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$safeFileConfToBase64$2 $outer;
                    private final File file$1;

                    public final String apply() {
                        return String.format("%s provided at %s does not exist or is not a file.", this.$outer.fileType$1, this.file$1.getAbsolutePath());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.file$1 = file$1;
                    }
                });
                return BaseEncoding.base64().encode(Files.toByteArray((File)file));
            }
            {
                this.fileType$1 = fileType$1;
            }
        });
    }

    private Option<String> resolveSecretLocation(Option<String> mountedUserSpecified, Option<String> valueMountedFromSubmitter, String mountedCanonicalLocation) {
        return mountedUserSpecified.orElse((Function0)new Serializable(this, valueMountedFromSubmitter, mountedCanonicalLocation){
            public static final long serialVersionUID = 0L;
            private final Option valueMountedFromSubmitter$1;
            public final String mountedCanonicalLocation$1;

            public final Option<String> apply() {
                return this.valueMountedFromSubmitter$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$resolveSecretLocation$1 $outer;

                    public final String apply(String x$5) {
                        return this.$outer.mountedCanonicalLocation$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.valueMountedFromSubmitter$1 = valueMountedFromSubmitter$1;
                this.mountedCanonicalLocation$1 = mountedCanonicalLocation$1;
            }
        });
    }

    private scala.collection.immutable.Map<String, String> resolveSecretData(Option<String> userSpecifiedCredential, String secretName) {
        return (scala.collection.immutable.Map)userSpecifiedCredential.map((Function1)new Serializable(this, secretName){
            public static final long serialVersionUID = 0L;
            private final String secretName$1;

            public final scala.collection.immutable.Map<String, String> apply(String valueBase64) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.secretName$1), (Object)valueBase64)}));
            }
            {
                this.secretName$1 = secretName$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
    }

    private OptionSettableSparkConf augmentSparkConf(SparkConf sparkConf) {
        return new OptionSettableSparkConf(sparkConf);
    }

    public DriverKubernetesCredentialsStep(SparkConf submissionSparkConf, String kubernetesResourceNamePrefix) {
        this.submissionSparkConf = submissionSparkConf;
        this.kubernetesResourceNamePrefix = kubernetesResourceNamePrefix;
        this.maybeMountedOAuthTokenFile = submissionSparkConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()})));
        this.maybeMountedClientKeyFile = submissionSparkConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()})));
        this.maybeMountedClientCertFile = submissionSparkConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()})));
        this.maybeMountedCaCertFile = submissionSparkConf.getOption(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()})));
        this.org$apache$spark$deploy$k8s$submit$steps$DriverKubernetesCredentialsStep$$driverServiceAccount = (Option)submissionSparkConf.get(Config$.MODULE$.KUBERNETES_SERVICE_ACCOUNT_NAME());
    }
}

