/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit.steps;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.submit.steps.DriverConfigurationStep;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!3Q!\u0001\u0002\u0001\u0015A\u0011\u0001\u0004R3qK:$WM\\2z%\u0016\u001cx\u000e\\;uS>t7\u000b^3q\u0015\t\u0019A!A\u0003ti\u0016\u00048O\u0003\u0002\u0006\r\u000511/\u001e2nSRT!a\u0002\u0005\u0002\u0007-D4O\u0003\u0002\n\u0015\u00051A-\u001a9m_fT!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u001935\t!!\u0003\u0002\u001b\u0005\t9BI]5wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]N#X\r\u001d\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005I1\u000f]1sW*\u000b'o]\u0002\u0001!\ryrE\u000b\b\u0003A\u0015r!!\t\u0013\u000e\u0003\tR!aI\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0012B\u0001\u0014\u0014\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001K\u0015\u0003\u0007M+\u0017O\u0003\u0002''A\u00111F\f\b\u0003%1J!!L\n\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[MA\u0001B\r\u0001\u0003\u0002\u0003\u0006IAH\u0001\u000bgB\f'o\u001b$jY\u0016\u001c\b\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002!)\f'o\u001d#po:dw.\u00193QCRD\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002#\u0019LG.Z:E_^tGn\\1e!\u0006$\b\u000eC\u00039\u0001\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\u0006umbTH\u0010\t\u00031\u0001AQ\u0001H\u001cA\u0002yAQAM\u001cA\u0002yAQ\u0001N\u001cA\u0002)BQAN\u001cA\u0002)BQ\u0001\u0011\u0001\u0005B\u0005\u000bqbY8oM&<WO]3Ee&4XM\u001d\u000b\u0003\u0005\u001a\u0003\"a\u0011#\u000e\u0003\u0011I!!\u0012\u0003\u0003)-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u00148\u000b]3d\u0011\u00159u\b1\u0001C\u0003)!'/\u001b<feN\u0003Xm\u0019")
public class DependencyResolutionStep
implements DriverConfigurationStep {
    private final Seq<String> sparkJars;
    private final Seq<String> sparkFiles;
    private final String jarsDownloadPath;
    private final String filesDownloadPath;

    @Override
    public KubernetesDriverSpec configureDriver(KubernetesDriverSpec driverSpec) {
        Container resolvedDriverContainer;
        Iterable<String> resolvedSparkJars = KubernetesUtils$.MODULE$.resolveFileUris((Iterable<String>)this.sparkJars, this.jarsDownloadPath);
        Iterable<String> resolvedSparkFiles = KubernetesUtils$.MODULE$.resolveFileUris((Iterable<String>)this.sparkFiles, this.filesDownloadPath);
        SparkConf sparkConf = driverSpec.driverSparkConf().clone();
        Object object = resolvedSparkJars.nonEmpty() ? sparkConf.set("spark.jars", resolvedSparkJars.mkString(",")) : BoxedUnit.UNIT;
        Object object2 = resolvedSparkFiles.nonEmpty() ? sparkConf.set("spark.files", resolvedSparkFiles.mkString(",")) : BoxedUnit.UNIT;
        Iterable<String> resolvedClasspath = KubernetesUtils$.MODULE$.resolveFilePaths((Iterable<String>)this.sparkJars, this.jarsDownloadPath);
        Container x$1 = resolvedDriverContainer = resolvedClasspath.nonEmpty() ? ((ContainerBuilder)((ContainerFluent.EnvNested)new ContainerBuilder(driverSpec.driverContainer()).addNewEnv().withName(Constants$.MODULE$.ENV_MOUNTED_CLASSPATH()).withValue(resolvedClasspath.mkString(File.pathSeparator))).endEnv()).build() : driverSpec.driverContainer();
        SparkConf x$2 = sparkConf;
        Pod x$3 = driverSpec.copy$default$1();
        Seq<HasMetadata> x$4 = driverSpec.copy$default$3();
        return driverSpec.copy(x$3, x$1, x$4, x$2);
    }

    public DependencyResolutionStep(Seq<String> sparkJars, Seq<String> sparkFiles, String jarsDownloadPath, String filesDownloadPath) {
        this.sparkJars = sparkJars;
        this.sparkFiles = sparkFiles;
        this.jarsDownloadPath = jarsDownloadPath;
        this.filesDownloadPath = filesDownloadPath;
    }
}

