/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

class SumAvgAggregateDefinition
implements AggregateDefinition {
    private boolean isSum;

    SumAvgAggregateDefinition() {
    }

    @Override
    public final DataTypeDescriptor getAggregator(DataTypeDescriptor dataTypeDescriptor, StringBuffer stringBuffer) {
        try {
            TypeId typeId = dataTypeDescriptor.getTypeId();
            CompilerContext compilerContext = (CompilerContext)QueryTreeNode.getContext("CompilerContext");
            TypeCompilerFactory typeCompilerFactory = compilerContext.getTypeCompilerFactory();
            TypeCompiler typeCompiler = typeCompilerFactory.getTypeCompiler(typeId);
            if (typeId.isNumericTypeId()) {
                stringBuffer.append(this.getAggregatorClassName());
                DataTypeDescriptor dataTypeDescriptor2 = typeCompiler.resolveArithmeticOperation(dataTypeDescriptor, dataTypeDescriptor, this.getOperator());
                return dataTypeDescriptor2.getNullabilityType(true);
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return null;
    }

    private String getAggregatorClassName() {
        if (this.isSum) {
            return "org.apache.derby.impl.sql.execute.SumAggregator";
        }
        return "org.apache.derby.impl.sql.execute.AvgAggregator";
    }

    protected String getOperator() {
        if (this.isSum) {
            return "sum";
        }
        return "avg";
    }

    final void setSumOrAvg(boolean bl) {
        this.isSum = bl;
    }
}

