/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlCallBinding
extends SqlOperatorBinding {
    private final SqlValidator validator;
    private final SqlValidatorScope scope;
    private final SqlCall call;

    public SqlCallBinding(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        super(validator.getTypeFactory(), call.getOperator());
        this.validator = validator;
        this.scope = scope;
        this.call = call;
    }

    @Override
    public int getGroupCount() {
        SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(this.scope);
        if (selectScope == null) {
            return 0;
        }
        SqlSelect select = selectScope.getNode();
        SqlNodeList group = select.getGroup();
        if (group != null) {
            int n = 0;
            for (SqlNode groupItem : group) {
                if (groupItem instanceof SqlNodeList && ((SqlNodeList)groupItem).size() == 0) continue;
                ++n;
            }
            return n;
        }
        return this.validator.isAggregate(select) ? 0 : -1;
    }

    public SqlValidator getValidator() {
        return this.validator;
    }

    public SqlValidatorScope getScope() {
        return this.scope;
    }

    public SqlCall getCall() {
        return this.call;
    }

    @Override
    public String getStringLiteralOperand(int ordinal) {
        Object node = this.call.operand(ordinal);
        return SqlLiteral.stringValue(node);
    }

    @Override
    public int getIntLiteralOperand(int ordinal) {
        Object child;
        SqlCall c;
        Object node = this.call.operand(ordinal);
        if (node instanceof SqlLiteral) {
            SqlLiteral sqlLiteral = (SqlLiteral)node;
            return sqlLiteral.intValue(true);
        }
        if (node instanceof SqlCall && (c = (SqlCall)node).getKind() == SqlKind.MINUS_PREFIX && (child = c.operand(0)) instanceof SqlLiteral) {
            return -((SqlLiteral)child).intValue(true);
        }
        throw Util.newInternal("should never come here");
    }

    @Override
    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return SqlUtil.isNullLiteral(this.call.operand(ordinal), allowCast);
    }

    @Override
    public int getOperandCount() {
        return this.call.getOperandList().size();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        Object operand = this.call.operand(ordinal);
        RelDataType type = this.validator.deriveType(this.scope, (SqlNode)operand);
        SqlValidatorNamespace namespace = this.validator.getNamespace((SqlNode)operand);
        if (namespace != null) {
            return namespace.getType();
        }
        return type;
    }

    @Override
    public RelDataType getCursorOperand(int ordinal) {
        Object operand = this.call.operand(ordinal);
        if (!SqlUtil.isCallTo(operand, SqlStdOperatorTable.CURSOR)) {
            return null;
        }
        SqlCall cursorCall = (SqlCall)operand;
        Object query = cursorCall.operand(0);
        return this.validator.deriveType(this.scope, (SqlNode)query);
    }

    @Override
    public String getColumnListParamInfo(int ordinal, String paramName, List<String> columnList) {
        Object operand = this.call.operand(ordinal);
        if (!SqlUtil.isCallTo(operand, SqlStdOperatorTable.ROW)) {
            return null;
        }
        for (SqlNode id : ((SqlCall)operand).getOperandList()) {
            columnList.add(((SqlIdentifier)id).getSimple());
        }
        return this.validator.getParentCursor(paramName);
    }

    @Override
    public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
        return this.validator.newValidationError(this.call, e);
    }

    public CalciteException newValidationSignatureError() {
        return this.validator.newValidationError(this.call, Static.RESOURCE.canNotApplyOp2Type(this.getOperator().getName(), this.call.getCallSignature(this.validator, this.scope), this.getOperator().getAllowedSignatures()));
    }

    public CalciteException newValidationError(Resources.ExInst<SqlValidatorException> ex) {
        return this.validator.newValidationError(this.call, ex);
    }
}

