/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.spark_project.jetty.util.Callback;

public class CountingCallback
extends Callback.Nested {
    private final AtomicInteger count;

    public CountingCallback(Callback callback, int count2) {
        super(callback);
        if (count2 < 1) {
            throw new IllegalArgumentException();
        }
        this.count = new AtomicInteger(count2);
    }

    @Override
    public void succeeded() {
        int current;
        do {
            if ((current = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(current, current - 1));
        if (current == 1) {
            super.succeeded();
        }
    }

    @Override
    public void failed(Throwable failure) {
        int current;
        do {
            if ((current = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(current, 0));
        super.failed(failure);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

