/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.server.session;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.spark_project.jetty.server.SessionManager;
import org.spark_project.jetty.server.session.AbstractSessionManager;
import org.spark_project.jetty.server.session.SessionHandler;
import org.spark_project.jetty.util.log.Logger;

public abstract class AbstractSession
implements AbstractSessionManager.SessionIf {
    static final Logger LOG = SessionHandler.LOG;
    public static final String SESSION_CREATED_SECURE = "org.spark_project.jetty.security.sessionCreatedSecure";
    private String _clusterId;
    private String _nodeId;
    private final AbstractSessionManager _manager;
    private boolean _idChanged;
    private final long _created;
    private long _cookieSet;
    private long _accessed;
    private long _lastAccessed;
    private boolean _invalid;
    private boolean _doInvalidate;
    private long _maxIdleMs;
    private boolean _newSession;
    private int _requests;

    protected AbstractSession(AbstractSessionManager abstractSessionManager, HttpServletRequest request) {
        this._manager = abstractSessionManager;
        this._newSession = true;
        this._created = System.currentTimeMillis();
        this._clusterId = this._manager._sessionIdManager.newSessionId(request, this._created);
        this._nodeId = this._manager._sessionIdManager.getNodeId(this._clusterId, request);
        this._accessed = this._created;
        this._lastAccessed = this._created;
        this._requests = 1;
        long l = this._maxIdleMs = this._manager._dftMaxIdleSecs > 0 ? (long)this._manager._dftMaxIdleSecs * 1000L : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("New session & id " + this._nodeId + " " + this._clusterId, new Object[0]);
        }
    }

    protected AbstractSession(AbstractSessionManager abstractSessionManager, long created, long accessed, String clusterId) {
        this._manager = abstractSessionManager;
        this._created = created;
        this._clusterId = clusterId;
        this._nodeId = this._manager._sessionIdManager.getNodeId(this._clusterId, null);
        this._accessed = accessed;
        this._lastAccessed = accessed;
        this._requests = 1;
        long l = this._maxIdleMs = this._manager._dftMaxIdleSecs > 0 ? (long)this._manager._dftMaxIdleSecs * 1000L : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restored session " + this._nodeId + " " + this._clusterId, new Object[0]);
        }
    }

    protected void checkValid() throws IllegalStateException {
        if (this._invalid) {
            throw new IllegalStateException("id=" + this._clusterId + " created=" + this._created + " accessed=" + this._accessed + " lastaccessed=" + this._lastAccessed + " maxInactiveMs=" + this._maxIdleMs);
        }
    }

    protected boolean checkExpiry(long time) {
        return this._maxIdleMs > 0L && this._lastAccessed > 0L && this._lastAccessed + this._maxIdleMs < time;
    }

    @Override
    public AbstractSession getSession() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAccessed() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return this._accessed;
        }
    }

    public abstract Map<String, Object> getAttributeMap();

    public abstract int getAttributes();

    public abstract Set<String> getNames();

    public long getCookieSetTime() {
        return this._cookieSet;
    }

    public void setCookieSetTime(long time) {
        this._cookieSet = time;
    }

    public long getCreationTime() throws IllegalStateException {
        this.checkValid();
        return this._created;
    }

    public String getId() throws IllegalStateException {
        return this._manager._nodeIdInSessionId ? this._nodeId : this._clusterId;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public String getClusterId() {
        return this._clusterId;
    }

    public long getLastAccessedTime() throws IllegalStateException {
        this.checkValid();
        return this._lastAccessed;
    }

    public void setLastAccessedTime(long time) {
        this._lastAccessed = time;
    }

    public int getMaxInactiveInterval() {
        return (int)(this._maxIdleMs / 1000L);
    }

    public ServletContext getServletContext() {
        return this._manager._context;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() throws IllegalStateException {
        this.checkValid();
        return AbstractSessionManager.__nullSessionContext;
    }

    @Deprecated
    public Object getValue(String name2) throws IllegalStateException {
        return this.getAttribute(name2);
    }

    public void renewId(HttpServletRequest request) {
        this._manager._sessionIdManager.renewSessionId(this.getClusterId(), this.getNodeId(), request);
        this.setIdChanged(true);
    }

    public SessionManager getSessionManager() {
        return this._manager;
    }

    protected void setClusterId(String clusterId) {
        this._clusterId = clusterId;
    }

    protected void setNodeId(String nodeId) {
        this._nodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean access(long time) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (this._invalid) {
                return false;
            }
            this._newSession = false;
            this._lastAccessed = this._accessed;
            this._accessed = time;
            if (this.checkExpiry(time)) {
                this.invalidate();
                return false;
            }
            ++this._requests;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            --this._requests;
            if (this._doInvalidate && this._requests <= 0) {
                this.doInvalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeout() throws IllegalStateException {
        this._manager.removeSession(this, true);
        boolean do_invalidate = false;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (!this._invalid) {
                if (this._requests <= 0) {
                    do_invalidate = true;
                } else {
                    this._doInvalidate = true;
                }
            }
        }
        if (do_invalidate) {
            this.doInvalidate();
        }
    }

    public void invalidate() throws IllegalStateException {
        this.checkValid();
        this._manager.removeSession(this, true);
        this.doInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvalidate() throws IllegalStateException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("invalidate {}", this._clusterId);
            }
            if (this.isValid()) {
                this.clearAttributes();
            }
        }
        finally {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                this._invalid = true;
            }
        }
    }

    public abstract void clearAttributes();

    public boolean isIdChanged() {
        return this._idChanged;
    }

    public boolean isNew() throws IllegalStateException {
        this.checkValid();
        return this._newSession;
    }

    @Deprecated
    public void putValue(String name2, Object value2) throws IllegalStateException {
        this.changeAttribute(name2, value2);
    }

    public void removeAttribute(String name2) {
        this.setAttribute(name2, null);
    }

    @Deprecated
    public void removeValue(String name2) throws IllegalStateException {
        this.removeAttribute(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            return this.doGetAttributeNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String[] getValueNames() throws IllegalStateException {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            Enumeration<String> anames = this.doGetAttributeNames();
            if (anames == null) {
                return new String[0];
            }
            ArrayList<String> names = new ArrayList<String>();
            while (anames.hasMoreElements()) {
                names.add(anames.nextElement());
            }
            return names.toArray(new String[names.size()]);
        }
    }

    public abstract Object doPutOrRemove(String var1, Object var2);

    public abstract Object doGet(String var1);

    public abstract Enumeration<String> doGetAttributeNames();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name2) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            return this.doGet(name2);
        }
    }

    public void setAttribute(String name2, Object value2) {
        this.changeAttribute(name2, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected boolean updateAttribute(String name2, Object value2) {
        Object old = null;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            old = this.doPutOrRemove(name2, value2);
        }
        if (value2 == null || !value2.equals(old)) {
            if (old != null) {
                this.unbindValue(name2, old);
            }
            if (value2 != null) {
                this.bindValue(name2, value2);
            }
            this._manager.doSessionAttributeListeners(this, name2, old, value2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object changeAttribute(String name2, Object value2) {
        Object old = null;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            old = this.doPutOrRemove(name2, value2);
        }
        this.callSessionAttributeListeners(name2, value2, old);
        return old;
    }

    protected void callSessionAttributeListeners(String name2, Object newValue, Object oldValue) {
        if (newValue == null || !newValue.equals(oldValue)) {
            if (oldValue != null) {
                this.unbindValue(name2, oldValue);
            }
            if (newValue != null) {
                this.bindValue(name2, newValue);
            }
            this._manager.doSessionAttributeListeners(this, name2, oldValue, newValue);
        }
    }

    public void setIdChanged(boolean changed) {
        this._idChanged = changed;
    }

    public void setMaxInactiveInterval(int secs) {
        if (LOG.isDebugEnabled()) {
            if (secs <= 0) {
                LOG.debug("Session {} is now immortal (maxInactiveInterval={})", this._clusterId, secs);
            } else {
                LOG.debug("Session {} maxInactiveInterval={}", this._clusterId, secs);
            }
        }
        this._maxIdleMs = (long)secs * 1000L;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
    }

    public void bindValue(String name2, Object value2) {
        if (value2 != null && value2 instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value2).valueBound(new HttpSessionBindingEvent((HttpSession)this, name2));
        }
    }

    public boolean isValid() {
        return !this._invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cookieSet() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this._cookieSet = this._accessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequests() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return this._requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequests(int requests) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this._requests = requests;
        }
    }

    public void unbindValue(String name2, Object value2) {
        if (value2 != null && value2 instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value2).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void willPassivate() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (Object value2 : this.getAttributeMap().values()) {
                if (!(value2 instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value2;
                listener.sessionWillPassivate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didActivate() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (Object value2 : this.getAttributeMap().values()) {
                if (!(value2 instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value2;
                listener.sessionDidActivate(event);
            }
        }
    }
}

