/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.spark.scheduler.TaskDescription;
import org.apache.spark.util.ByteBufferInputStream;
import org.apache.spark.util.ByteBufferOutputStream;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TaskDescription$ {
    public static final TaskDescription$ MODULE$;

    static {
        new TaskDescription$();
    }

    private void serializeStringLongMap(Map<String, Object> map2, DataOutputStream dataOut) {
        dataOut.writeInt(map2.size());
        map2.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(dataOut){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream dataOut$1;

            public final void apply(Tuple2<String, Object> x$1) {
                Tuple2<String, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    long value2 = tuple2._2$mcJ$sp();
                    this.dataOut$1.writeUTF(key);
                    this.dataOut$1.writeLong(value2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.dataOut$1 = dataOut$1;
            }
        });
    }

    public ByteBuffer encode(TaskDescription taskDescription) {
        ByteBufferOutputStream bytesOut = new ByteBufferOutputStream(4096);
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        dataOut.writeLong(taskDescription.taskId());
        dataOut.writeInt(taskDescription.attemptNumber());
        dataOut.writeUTF(taskDescription.executorId());
        dataOut.writeUTF(taskDescription.name());
        dataOut.writeInt(taskDescription.index());
        this.serializeStringLongMap(taskDescription.addedFiles(), dataOut);
        this.serializeStringLongMap(taskDescription.addedJars(), dataOut);
        dataOut.writeInt(taskDescription.properties().size());
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(taskDescription.properties()).asScala()).foreach((Function1)new Serializable(dataOut){
            public static final long serialVersionUID = 0L;
            private final DataOutputStream dataOut$2;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value2 = (String)tuple2._2();
                    this.dataOut$2.writeUTF(key);
                    byte[] bytes = value2.getBytes(StandardCharsets.UTF_8);
                    this.dataOut$2.writeInt(bytes.length);
                    this.dataOut$2.write(bytes);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.dataOut$2 = dataOut$2;
            }
        });
        Utils$.MODULE$.writeByteBuffer(taskDescription.serializedTask(), bytesOut);
        dataOut.close();
        bytesOut.close();
        return bytesOut.toByteBuffer();
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, Object> deserializeStringLongMap(DataInputStream dataIn) {
        void var2_2;
        HashMap map2 = new HashMap();
        int mapSize = dataIn.readInt();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mapSize).foreach$mVc$sp((Function1)new Serializable(dataIn, map2){
            public static final long serialVersionUID = 0L;
            private final DataInputStream dataIn$1;
            private final HashMap map$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.map$1.update((Object)this.dataIn$1.readUTF(), (Object)BoxesRunTime.boxToLong((long)this.dataIn$1.readLong()));
            }
            {
                this.dataIn$1 = dataIn$1;
                this.map$1 = map$1;
            }
        });
        return var2_2;
    }

    public TaskDescription decode(ByteBuffer byteBuffer) {
        DataInputStream dataIn = new DataInputStream(new ByteBufferInputStream(byteBuffer));
        long taskId = dataIn.readLong();
        int attemptNumber = dataIn.readInt();
        String executorId = dataIn.readUTF();
        String name2 = dataIn.readUTF();
        int index = dataIn.readInt();
        HashMap<String, Object> taskFiles = this.deserializeStringLongMap(dataIn);
        HashMap<String, Object> taskJars = this.deserializeStringLongMap(dataIn);
        Properties properties = new Properties();
        int numProperties = dataIn.readInt();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numProperties).foreach((Function1)new Serializable(dataIn, properties){
            public static final long serialVersionUID = 0L;
            private final DataInputStream dataIn$2;
            private final Properties properties$1;

            public final Object apply(int i) {
                String key = this.dataIn$2.readUTF();
                int valueLength = this.dataIn$2.readInt();
                byte[] valueBytes = new byte[valueLength];
                this.dataIn$2.readFully(valueBytes);
                return this.properties$1.setProperty(key, new String(valueBytes, StandardCharsets.UTF_8));
            }
            {
                this.dataIn$2 = dataIn$2;
                this.properties$1 = properties$1;
            }
        });
        ByteBuffer serializedTask = byteBuffer.slice();
        return new TaskDescription(taskId, attemptNumber, executorId, name2, index, (Map<String, Object>)taskFiles, (Map<String, Object>)taskJars, properties, serializedTask);
    }

    private TaskDescription$() {
        MODULE$ = this;
    }
}

