/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.deploy.PythonRunner$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import py4j.GatewayServer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Try$;

public final class PythonRunner$ {
    public static final PythonRunner$ MODULE$;

    static {
        new PythonRunner$();
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        GatewayServer gatewayServer;
        block2: {
            String pythonFile = args[0];
            String pyFiles = args[1];
            String[] otherArgs = (String[])Predef$.MODULE$.refArrayOps((Object[])args).slice(2, args.length);
            SparkConf sparkConf = new SparkConf();
            String secret = Utils$.MODULE$.createSecret(sparkConf);
            String pythonExec = (String)((Option)sparkConf.get(package$.MODULE$.PYSPARK_DRIVER_PYTHON())).orElse((Function0)new Serializable(sparkConf){
                public static final long serialVersionUID = 0L;
                private final SparkConf sparkConf$1;

                public final Option<String> apply() {
                    return (Option)this.sparkConf$1.get(package$.MODULE$.PYSPARK_PYTHON());
                }
                {
                    this.sparkConf$1 = sparkConf$1;
                }
            }).orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_DRIVER_PYTHON");
                }
            }).orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_PYTHON");
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "python";
                }
            });
            String formattedPythonFile = this.formatPath(pythonFile, this.formatPath$default$2());
            String[] formattedPyFiles = this.resolvePyFiles(this.formatPaths(pyFiles, this.formatPaths$default$2()));
            InetAddress localhost = InetAddress.getLoopbackAddress();
            gatewayServer = new GatewayServer.GatewayServerBuilder().authToken(secret).javaPort(0).javaAddress(localhost).callbackClient(25334, localhost, secret).build();
            Thread thread = new Thread(new Runnable(gatewayServer){
                public final GatewayServer gatewayServer$1;

                public void run() {
                    Utils$.MODULE$.logUncaughtExceptions(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.1 $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.gatewayServer$1.start();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.gatewayServer$1 = gatewayServer$1;
                }
            });
            thread.setName("py4j-gateway-init");
            thread.setDaemon(true);
            thread.start();
            thread.join();
            ArrayBuffer pathElements = new ArrayBuffer();
            pathElements.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])formattedPyFiles));
            pathElements.$plus$eq((Object)PythonUtils$.MODULE$.sparkPythonPath());
            pathElements.$plus$eq(scala.sys.package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }));
            String pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq<String>)pathElements);
            ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pythonExec, formattedPythonFile}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])otherArgs), Seq$.MODULE$.canBuildFrom())).asJava());
            Map<String, String> env = builder.environment();
            env.put("PYTHONPATH", pythonPath);
            env.put("PYTHONUNBUFFERED", "YES");
            env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)gatewayServer.getListeningPort())));
            env.put("PYSPARK_GATEWAY_SECRET", secret);
            ((Option)sparkConf.get(package$.MODULE$.PYSPARK_PYTHON())).foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final Map env$1;

                public final String apply(String x$1) {
                    return this.env$1.put("PYSPARK_PYTHON", x$1);
                }
                {
                    this.env$1 = env$1;
                }
            });
            scala.sys.package$.MODULE$.env().get((Object)"PYTHONHASHSEED").foreach((Function1)new Serializable(env){
                public static final long serialVersionUID = 0L;
                private final Map env$1;

                public final String apply(String x$2) {
                    return this.env$1.put("PYTHONHASHSEED", x$2);
                }
                {
                    this.env$1 = env$1;
                }
            });
            builder.redirectErrorStream(true);
            try {
                Process process2 = builder.start();
                new RedirectThread(process2.getInputStream(), System.out, "redirect output", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
                int exitCode = process2.waitFor();
                if (exitCode == 0) break block2;
                throw new SparkUserAppException(exitCode);
            }
            catch (Throwable throwable) {
                void var11_11;
                var11_11.shutdown();
                throw throwable;
            }
        }
        gatewayServer.shutdown();
    }

    public String formatPath(String path, boolean testWindows) {
        String string;
        if (Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.nonLocalPaths(path, testWindows)).nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Launching Python applications through ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-submit is currently only supported for local files: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))).toString());
        }
        URI uri = (URI)Try$.MODULE$.apply((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final URI apply() {
                return new URI(this.path$1);
            }
            {
                this.path$1 = path$1;
            }
        }).getOrElse((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final URI apply() {
                return new File(this.path$1).toURI();
            }
            {
                this.path$1 = path$1;
            }
        });
        String string2 = uri.getScheme();
        if (string2 == null) {
            string = path;
        } else {
            boolean bl = "file".equals(string2) ? true : "local".equals(string2);
            string = bl ? uri.getPath() : null;
        }
        String formattedPath = string;
        if (formattedPath == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Python file path is malformed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        if (Utils$.MODULE$.isWindows() && formattedPath.matches("/[a-zA-Z]:/.*")) {
            formattedPath = new StringOps(Predef$.MODULE$.augmentString(formattedPath)).stripPrefix("/");
        }
        return formattedPath;
    }

    public boolean formatPath$default$2() {
        return false;
    }

    public String[] formatPaths(String paths, boolean testWindows) {
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)Option$.MODULE$.apply((Object)paths).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).split(",")).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
            }
        })).map((Function1)new Serializable(testWindows){
            public static final long serialVersionUID = 0L;
            private final boolean testWindows$1;

            public final String apply(String p) {
                return PythonRunner$.MODULE$.formatPath(p, this.testWindows$1);
            }
            {
                this.testWindows$1 = testWindows$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public boolean formatPaths$default$2() {
        return false;
    }

    private String[] resolvePyFiles(String[] pyFiles) {
        ObjectRef dest$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pyFiles).flatMap((Function1)new Serializable(dest$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final ObjectRef dest$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final Iterable<String> apply(String pyFile) {
                Iterable iterable;
                if (pyFile.endsWith(".py")) {
                    File source = new File(pyFile);
                    if (source.exists() && source.isFile() && source.canRead()) {
                        Files.copy(source.toPath(), new File(PythonRunner$.MODULE$.org$apache$spark$deploy$PythonRunner$$dest$1(this.dest$lzy$1, this.bitmap$0$1), source.getName()).toPath(), new CopyOption[0]);
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)PythonRunner$.MODULE$.org$apache$spark$deploy$PythonRunner$$dest$1(this.dest$lzy$1, this.bitmap$0$1).getAbsolutePath()));
                    } else {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)pyFile));
                }
                return iterable;
            }
            {
                this.dest$lzy$1 = dest$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).distinct();
    }

    private final File dest$lzycompute$1(ObjectRef dest$lzy$1, VolatileByteRef bitmap$0$1) {
        PythonRunner$ pythonRunner$ = this;
        synchronized (pythonRunner$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                String x$4 = "localPyFiles";
                String x$5 = Utils$.MODULE$.createTempDir$default$1();
                dest$lzy$1.elem = Utils$.MODULE$.createTempDir(x$5, x$4);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (File)dest$lzy$1.elem;
        }
    }

    public final File org$apache$spark$deploy$PythonRunner$$dest$1(ObjectRef dest$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.dest$lzycompute$1(dest$lzy$1, bitmap$0$1) : (File)dest$lzy$1.elem;
    }

    private PythonRunner$() {
        MODULE$ = this;
    }
}

