/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.kvstore.ArrayWrappers;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.KVTypeInfo;
import org.spark_project.guava.base.Objects;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.base.Throwables;

@Private
public class InMemoryStore
implements KVStore {
    private Object metadata;
    private ConcurrentMap<Class<?>, InstanceList> data = new ConcurrentHashMap();

    @Override
    public <T> T getMetadata(Class<T> klass) {
        return klass.cast(this.metadata);
    }

    @Override
    public void setMetadata(Object value) {
        this.metadata = value;
    }

    @Override
    public long count(Class<?> type) {
        InstanceList list = (InstanceList)this.data.get(type);
        return list != null ? (long)list.size() : 0L;
    }

    @Override
    public long count(Class<?> type, String index, Object indexedValue) throws Exception {
        InstanceList list = (InstanceList)this.data.get(type);
        int count = 0;
        Comparable<Object> comparable = InMemoryStore.asKey(indexedValue);
        KVTypeInfo.Accessor accessor = list.getIndexAccessor(index);
        for (Object o : this.view(type)) {
            if (!Objects.equal(comparable, InMemoryStore.asKey(accessor.get(o)))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public <T> T read(Class<T> klass, Object naturalKey) {
        Object value;
        InstanceList list = (InstanceList)this.data.get(klass);
        Object object = value = list != null ? list.get(naturalKey) : null;
        if (value == null) {
            throw new NoSuchElementException();
        }
        return klass.cast(value);
    }

    @Override
    public void write(Object value) throws Exception {
        InstanceList list = this.data.computeIfAbsent(value.getClass(), key -> {
            try {
                return new InstanceList((Class)key);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
        list.put(value);
    }

    @Override
    public void delete(Class<?> type, Object naturalKey) {
        InstanceList list = (InstanceList)this.data.get(type);
        if (list != null) {
            list.delete(naturalKey);
        }
    }

    @Override
    public <T> KVStoreView<T> view(Class<T> type) {
        InstanceList list = (InstanceList)this.data.get(type);
        return list != null ? list.view(type) : new InMemoryView<T>(type, Collections.emptyList(), null);
    }

    @Override
    public void close() {
        this.metadata = null;
        this.data.clear();
    }

    private static Comparable<Object> asKey(Object in) {
        if (in.getClass().isArray()) {
            in = ArrayWrappers.forArray(in);
        }
        return in;
    }

    private static class InMemoryIterator<T>
    implements KVStoreIterator<T> {
        private final Iterator<T> iter;

        InMemoryIterator(Iterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<T> next(int max) {
            ArrayList<T> list = new ArrayList<T>(max);
            while (this.hasNext() && list.size() < max) {
                list.add(this.next());
            }
            return list;
        }

        @Override
        public boolean skip(long n) {
            for (long skipped = 0L; skipped < n; ++skipped) {
                if (this.hasNext()) {
                    this.next();
                    continue;
                }
                return false;
            }
            return this.hasNext();
        }

        @Override
        public void close() {
        }
    }

    private static class InMemoryView<T>
    extends KVStoreView<T> {
        private final Collection<T> elements;
        private final KVTypeInfo ti;
        private final KVTypeInfo.Accessor natural;

        InMemoryView(Class<T> type, Collection<T> elements, KVTypeInfo ti) {
            super(type);
            this.elements = elements;
            this.ti = ti;
            this.natural = ti != null ? ti.getAccessor("__main__") : null;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.elements.isEmpty()) {
                return new InMemoryIterator<T>(this.elements.iterator());
            }
            try {
                KVTypeInfo.Accessor getter = this.index != null ? this.ti.getAccessor(this.index) : null;
                int modifier = this.ascending ? 1 : -1;
                List<T> sorted = this.copyElements();
                Collections.sort(sorted, (e1, e2) -> modifier * this.compare(e1, e2, getter));
                Stream<Object> stream = sorted.stream();
                if (this.first != null) {
                    stream = stream.filter(e -> modifier * this.compare(e, getter, this.first) >= 0);
                }
                if (this.last != null) {
                    stream = stream.filter(e -> modifier * this.compare(e, getter, this.last) <= 0);
                }
                if (this.skip > 0L) {
                    stream = stream.skip(this.skip);
                }
                if (this.max < (long)sorted.size()) {
                    stream = stream.limit((int)this.max);
                }
                return new InMemoryIterator(stream.iterator());
            }
            catch (Exception e3) {
                throw Throwables.propagate((Throwable)e3);
            }
        }

        private List<T> copyElements() {
            if (this.parent != null) {
                KVTypeInfo.Accessor parentGetter = this.ti.getParentAccessor(this.index);
                Preconditions.checkArgument((parentGetter != null ? 1 : 0) != 0, (Object)"Parent filter for non-child index.");
                return this.elements.stream().filter(e -> this.compare(e, parentGetter, this.parent) == 0).collect(Collectors.toList());
            }
            return new ArrayList<T>(this.elements);
        }

        private int compare(T e1, T e2, KVTypeInfo.Accessor getter) {
            try {
                int diff = this.compare(e1, getter, getter.get(e2));
                if (diff == 0 && getter != this.natural) {
                    diff = this.compare(e1, this.natural, this.natural.get(e2));
                }
                return diff;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        private int compare(T e1, KVTypeInfo.Accessor getter, Object v2) {
            try {
                return InMemoryStore.asKey(getter.get(e1)).compareTo(InMemoryStore.asKey(v2));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static class InstanceList {
        private final KVTypeInfo ti;
        private final KVTypeInfo.Accessor naturalKey;
        private final ConcurrentMap<Comparable<Object>, Object> data;
        private int size;

        private InstanceList(Class<?> type) throws Exception {
            this.ti = new KVTypeInfo(type);
            this.naturalKey = this.ti.getAccessor("__main__");
            this.data = new ConcurrentHashMap<Comparable<Object>, Object>();
            this.size = 0;
        }

        KVTypeInfo.Accessor getIndexAccessor(String indexName) {
            return this.ti.getAccessor(indexName);
        }

        public Object get(Object key) {
            return this.data.get(InMemoryStore.asKey(key));
        }

        public void put(Object value) throws Exception {
            Preconditions.checkArgument((boolean)this.ti.type().equals(value.getClass()), (String)"Unexpected type: %s", (Object[])new Object[]{value.getClass()});
            if (this.data.put(InMemoryStore.asKey(this.naturalKey.get(value)), value) == null) {
                ++this.size;
            }
        }

        public void delete(Object key) {
            if (this.data.remove(InMemoryStore.asKey(key)) != null) {
                --this.size;
            }
        }

        public int size() {
            return this.size;
        }

        public <T> InMemoryView<T> view(Class<T> type) {
            Preconditions.checkArgument((boolean)this.ti.type().equals(type), (String)"Unexpected type: %s", (Object[])new Object[]{type});
            Collection all = this.data.values();
            return new InMemoryView<T>(type, all, this.ti);
        }
    }
}

