/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassConstants;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.flush.MapPutOperation;
import org.datanucleus.flush.MapRemoveOperation;
import org.datanucleus.flush.Operation;
import org.datanucleus.flush.SCOOperation;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class OperationQueue {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected List<Operation> queuedOperations = new ArrayList<Operation>();

    public synchronized void enqueue(Operation oper) {
        this.queuedOperations.add(oper);
    }

    public synchronized void log() {
        NucleusLogger.GENERAL.debug(">> OperationQueue :");
        for (Operation op : this.queuedOperations) {
            NucleusLogger.GENERAL.debug(">> " + op);
        }
    }

    public void clear() {
        this.queuedOperations.clear();
    }

    public List<Operation> getOperations() {
        return Collections.unmodifiableList(this.queuedOperations);
    }

    public synchronized void performAll() {
        for (Operation op : this.queuedOperations) {
            op.perform();
        }
        this.queuedOperations.clear();
    }

    public synchronized void performAll(Store store, ObjectProvider op) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023005", (Object)op.getObjectAsPrintable(), (Object)store.getOwnerMemberMetaData().getFullFieldName()));
        }
        ArrayList<Operation> flushOperations = new ArrayList<Operation>();
        ListIterator<Operation> operIter = this.queuedOperations.listIterator();
        while (operIter.hasNext()) {
            Operation oper = operIter.next();
            if (!(oper instanceof SCOOperation) || ((SCOOperation)oper).getStore() != store) continue;
            flushOperations.add(oper);
            operIter.remove();
        }
        ListIterator<Operation> flushOperIter = flushOperations.listIterator();
        while (flushOperIter.hasNext()) {
            Operation oper = (Operation)flushOperIter.next();
            if (store instanceof CollectionStore) {
                if (!(store instanceof ListStore)) {
                    if (OperationQueue.isAddFollowedByRemoveOnSameSCO(store, op, oper, flushOperIter)) {
                        flushOperIter.next();
                        continue;
                    }
                    if (OperationQueue.isRemoveFollowedByAddOnSameSCO(store, op, oper, flushOperIter)) {
                        flushOperIter.next();
                        continue;
                    }
                    oper.perform();
                    continue;
                }
                oper.perform();
                continue;
            }
            if (store instanceof MapStore) {
                if (OperationQueue.isPutFollowedByRemoveOnSameSCO(store, op, oper, flushOperIter)) {
                    flushOperIter.next();
                    continue;
                }
                oper.perform();
                continue;
            }
            oper.perform();
        }
    }

    protected static boolean isAddFollowedByRemoveOnSameSCO(Store store, ObjectProvider op, Operation currentOper, ListIterator<Operation> listIter) {
        if (CollectionAddOperation.class.isInstance(currentOper)) {
            boolean addThenRemove = false;
            if (listIter.hasNext()) {
                Object value;
                Operation operNext = listIter.next();
                if (CollectionRemoveOperation.class.isInstance(operNext) && (value = ((CollectionAddOperation)CollectionAddOperation.class.cast(currentOper)).getValue()) == ((CollectionRemoveOperation)CollectionRemoveOperation.class.cast(operNext)).getValue()) {
                    addThenRemove = true;
                    NucleusLogger.PERSISTENCE.info("Member " + store.getOwnerMemberMetaData().getFullFieldName() + " of " + StringUtils.toJVMIDString(op.getObject()) + " had an add then a remove of element " + StringUtils.toJVMIDString(value) + " - operations ignored");
                }
                listIter.previous();
            }
            return addThenRemove;
        }
        return false;
    }

    protected static boolean isRemoveFollowedByAddOnSameSCO(Store store, ObjectProvider op, Operation currentOper, ListIterator<Operation> listIter) {
        if (CollectionRemoveOperation.class.isInstance(currentOper)) {
            boolean removeThenAdd = false;
            if (listIter.hasNext()) {
                Object value;
                Operation opNext = listIter.next();
                if (CollectionAddOperation.class.isInstance(opNext) && (value = ((CollectionRemoveOperation)CollectionRemoveOperation.class.cast(currentOper)).getValue()) == ((CollectionAddOperation)CollectionAddOperation.class.cast(opNext)).getValue()) {
                    removeThenAdd = true;
                    NucleusLogger.PERSISTENCE.info("Member" + store.getOwnerMemberMetaData().getFullFieldName() + " of " + StringUtils.toJVMIDString(op.getObject()) + " had a remove then add of element " + StringUtils.toJVMIDString(value) + " - operations ignored");
                }
                listIter.previous();
            }
            return removeThenAdd;
        }
        return false;
    }

    protected static boolean isPutFollowedByRemoveOnSameSCO(Store store, ObjectProvider op, Operation currentOper, ListIterator<Operation> listIter) {
        if (MapPutOperation.class.isInstance(currentOper)) {
            boolean putThenRemove = false;
            if (listIter.hasNext()) {
                Object key;
                Operation operNext = listIter.next();
                if (MapRemoveOperation.class.isInstance(operNext) && (key = ((MapPutOperation)MapPutOperation.class.cast(currentOper)).getKey()) == ((MapRemoveOperation)MapRemoveOperation.class.cast(operNext)).getKey()) {
                    putThenRemove = true;
                    NucleusLogger.PERSISTENCE.info("Member " + store.getOwnerMemberMetaData().getFullFieldName() + " of " + StringUtils.toJVMIDString(op.getObject()) + " had a put then a remove of key " + StringUtils.toJVMIDString(key) + " - operations ignored");
                }
                listIter.previous();
            }
            return putThenRemove;
        }
        return false;
    }
}

